/**
 *  Copyright (C) 2016 MongoDB Inc.
 */

#pragma once

#include <memory>

#include "mongo/db/commands/server_status.h"
#include "mongo/executor/connection_pool.h"

namespace mongo {

template <class T>
class StatusWith;

class LDAPTypeFactory;
class LDAPConnectionReaper;
class LDAPConnection;
struct LDAPConnectionOptions;

/**
 * Interface for factories which produce LDAPConnection objects.
 */
class LDAPConnectionFactory {
public:
    virtual ~LDAPConnectionFactory() = default;

    explicit LDAPConnectionFactory(Milliseconds poolSetupTimeout);

    /**
     * Factory function to produce LDAP client objects
     * @param options Describes the connection to create
     *
     * @return Objects of type OpenLDAPConnection, or error
     */
    StatusWith<std::unique_ptr<LDAPConnection>> create(const LDAPConnectionOptions& options);

private:
    friend class LDAPConnectionFactoryServerStatus;

    std::shared_ptr<LDAPConnectionReaper> _reaper;
    std::shared_ptr<LDAPTypeFactory> _typeFactory;
    std::shared_ptr<executor::ConnectionPool> _pool;
    std::unique_ptr<ServerStatusSection> _serverStatusSection;
};

}  // namespace mongo
