/**
 * Test that a search with a specified sort succeeds in a standalone.
 */
(function() {
"use strict";

load('jstests/libs/uuid_util.js');  // For getUUIDFromListCollections.
load('src/mongo/db/modules/enterprise/jstests/search/lib/mongotmock.js');

const mongotmock = new MongotMock();
mongotmock.start();
const mongotConn = mongotmock.getConnection();

const conn = MongoRunner.runMongod({setParameter: {mongotHost: mongotConn.host}});

const dbName = "test";
const collName = jsTestName();
let testDB = conn.getDB(dbName);
const coll = testDB.getCollection(collName);
coll.drop();

assert.commandWorked(coll.insert([
    {_id: 1, a: 10},
    {_id: 2, a: 0},
    {_id: 3, a: 5},
]));

const mongotQuery = {
    sort: {a: 1}
};

const responseBatch = [
    {_id: 2, $searchSortValues: {a: 0}},
    {_id: 3, $searchSortValues: {a: 5}},
    {_id: 1, $searchSortValues: {a: 10}},
];

const collUUID = getUUIDFromListCollections(testDB, collName);

mongotmock.setMockResponses(
    [{
        expectedCommand: mongotCommandForQuery(mongotQuery, collName, dbName, collUUID),
        response: mongotResponseForBatch(responseBatch, NumberLong(0), coll.getFullName(), 1),
    }],
    123);

assert.eq(
    [
        {_id: 2, a: 0},
        {_id: 3, a: 5},
        {_id: 1, a: 10},
    ],
    coll.aggregate([{$search: mongotQuery}]).toArray());

MongoRunner.stopMongod(conn);
mongotmock.stop();
})();
