/**
 * Verify that `$search` queries that set '$$SEARCH_META' fail on sharded collections.
 */
(function() {
"use strict";
load("src/mongo/db/modules/enterprise/jstests/search/lib/mongotmock.js");  // For
                                                                           // mongotCommandForQuery.
load('jstests/libs/uuid_util.js');                               // For getUUIDFromListCollections.
load("jstests/noPassthrough/libs/server_parameter_helpers.js");  // For setParameterOnAllHosts.
load("src/mongo/db/modules/enterprise/jstests/search/lib/shardingtest_with_mongotmock.js");

// This test tests behavior before search sharded facets were enabled.
if (TestData.setParameters.hasOwnProperty("featureFlagSearchShardedFacets")) {
    jsTestLog("Skipping test as 'featureFlagSearchShardedFacets is enabled");
    return;
}
const dbName = jsTestName();
const collName = jsTestName();
const stWithMock = new ShardingTestWithMongotMock({
    name: "sharded_search",
    shards: {
        rs0: {nodes: 1},
        rs1: {nodes: 1},
    },
    mongos: 1
});
stWithMock.start();
const st = stWithMock.st;

const mongos = st.s;
const testDB = mongos.getDB(dbName);

const testColl = testDB.getCollection(collName);

// Shard the test collection, split it at {shardKey: 10}, and move the higher chunk to shard1.
assert.commandWorked(testColl.createIndex({shardKey: 1}));
assert.commandWorked(testDB.adminCommand({enableSharding: dbName}));
st.ensurePrimaryShard(dbName, st.shard0.name);
st.shardColl(testColl, {shardKey: 1}, {shardKey: 10}, {shardKey: 10 + 1});

// Documents that end up on shard0.
assert.commandWorked(testColl.insert({_id: 1, shardKey: 0, x: "ow"}));
assert.commandWorked(testColl.insert({_id: 2, shardKey: 0, x: "now", y: "lorem"}));
assert.commandWorked(testColl.insert({_id: 3, shardKey: 0, x: "brown", y: "ipsum"}));
assert.commandWorked(testColl.insert({_id: 4, shardKey: 0, x: "cow", y: "lorem ipsum"}));
// Documents that end up on shard1.
assert.commandWorked(testColl.insert({_id: 11, shardKey: 100, x: "brown", y: "ipsum"}));
assert.commandWorked(testColl.insert({_id: 12, shardKey: 100, x: "cow", y: "lorem ipsum"}));
assert.commandWorked(testColl.insert({_id: 13, shardKey: 100, x: "brown", y: "ipsum"}));
assert.commandWorked(testColl.insert({_id: 14, shardKey: 100, x: "cow", y: "lorem ipsum"}));

const mongotQuery = {};
mockPlanShardSearchOk(stWithMock.getMockConnectedToHost(mongos), dbName, collName, mongotQuery);
assert.commandFailedWithCode(testDB.runCommand({
    aggregate: testColl.getName(),
    pipeline: [{$search: mongotQuery}, {$project: {val: "$$SEARCH_META"}}],
    cursor: {}
}),
                             [5858100, 6347900]);
stWithMock.stop();
})();
