/**
 * Test that $search is banned in a $lookup subpipeline.
 */

(function() {
"use strict";

load("src/mongo/db/modules/enterprise/jstests/search/lib/mongotmock.js");
load("src/mongo/db/modules/enterprise/jstests/search/lib/shardingtest_with_mongotmock.js");

function checkLookupBanned(conn) {
    const db = conn.getDB("test");
    const coll = db["internal_search_banned_in_lookup"];
    const foreignColl = db[coll.getName() + "_foreign"];

    assert.commandWorked(foreignColl.insert({a: 1}));
    assert.commandWorked(coll.insert({a: 1}));

    {
        const pipeline = [
                {
                  $lookup: {
                      let : {},
                      pipeline: [
                          {$search: {}},
                      ],
                      from: foreignColl.getName(),
                      as: "c",
                  }
                },
            ];
        const err = assert.throws(() => coll.aggregate(pipeline));
        assert.commandFailedWithCode(err, 51047);
    }

    // $search within a $lookup within a $lookup.
    {
        const nestedPipeline = [
                {
                  $lookup: {
                      pipeline: [{
                          $lookup: {
                              pipeline: [
                                  {$search: {}},
                              ],
                              from: foreignColl.getName(),
                              as: "c",
                          }
                      }],
                      from: foreignColl.getName(),
                      as: "c",
                  }
                },
            ];
        const err = assert.throws(() => coll.aggregate(nestedPipeline));
        assert.commandFailedWithCode(err, 51047);
    }
}

{
    const conn = MongoRunner.runMongod();
    checkLookupBanned(conn);
    MongoRunner.stopMongod(conn);
}

{
    const stWithMock = new ShardingTestWithMongotMock({
        shards: {
            rs0: {nodes: 1},
            rs1: {nodes: 1},
        },
        mongos: 1,
    });
    stWithMock.start();

    {
        // Create the 'test' database by inserting a document into a collection.
        const db = stWithMock.st.s.getDB("test");
        const coll = db["internal_search_banned_in_lookup"];
        coll.insert({a: 1});
        // Ensure shard0 is the primary shard.
        stWithMock.st.ensurePrimaryShard("test", stWithMock.st.shard0.name);
    }
    // Mock PSS once for each query in 'checkLookupBanned()'.
    mockPlanShardSearchOk(stWithMock.getMockConnectedToHost(stWithMock.st.shard0),
                          "test",
                          "internal_search_banned_in_lookup_foreign",
                          {} /* mongotQuery */);
    mockPlanShardSearchOk(stWithMock.getMockConnectedToHost(stWithMock.st.shard0),
                          "test",
                          "internal_search_banned_in_lookup_foreign",
                          {} /* mongotQuery */);

    checkLookupBanned(stWithMock.st.s);
    stWithMock.stop();
}
})();
