/*
 * Arrays are not supported in query analysis currently. This test verifies that fields within
 * embedded documents are not treated as top-level fields by query analysis.
 */
(function() {
'use strict';
load("src/mongo/db/modules/enterprise/jstests/fle/lib/mongocryptd.js");
const mongocryptd = new MongoCryptD();
mongocryptd.start();
const dbName = jsTestName();
const testDB = mongocryptd.getConnection().getDB(dbName);
const uuid = UUID();
const schema = {
    type: "object",
    properties: {
        name: {
            encrypt: {
                bsonType: 'string',
                algorithm: 'AEAD_AES_256_CBC_HMAC_SHA_512-Deterministic',
                keyId: [uuid]
            }
        }
    }
};

let cmd = {
    "find": "coll",
    "filter": {
        "name": "encrypted",
        "bars": {
            "$elemMatch": {"name": "unencrypted"},
        }
    },
    jsonSchema: schema,
    isRemoteSchema: false
};
let res = assert.commandWorked(testDB.runCommand(cmd));

assert(res.result.filter.$and[0].name.$eq instanceof BinData, tojson(res));
assert.eq(res.result.filter.$and[1].bars.$elemMatch.name.$eq, "unencrypted", tojson(res));

mongocryptd.stop();
}());
