// Test setting special values for ldapTimeoutMS (e.g., NaN, out-of-bound doubles)

(function() {

load("src/mongo/db/modules/enterprise/jstests/external_auth/lib/ldap_authz_lib.js");

const testOptions = {
    isPooled: false,
};

function checkRuntimeTimeoutValues({conn, testObj, options}) {
    const adminDB = conn.getDB("admin");
    assert(adminDB.auth("siteRootAdmin", "secret"));

    assert.commandFailed(conn.adminCommand({setParameter: 1, "ldapTimeoutMS": NaN}));
    assert.commandFailed(conn.adminCommand({setParameter: 1, "ldapTimeoutMS": "hi"}));
    assert.commandFailed(conn.adminCommand({setParameter: 1, "ldapTimeoutMS": (0 / 0)}));
    assert.commandFailed(
        conn.adminCommand({setParameter: 1, "ldapTimeoutMS": (Number.MAX_SAFE_INTEGER)}));
    assert.commandFailed(
        conn.adminCommand({setParameter: 1, "ldapTimeoutMS": (Number.MIN_SAFE_INTEGER)}));
    assert.commandFailed(conn.adminCommand({setParameter: 1, "ldapTimeoutMS": 0}));

    // Valid numbers should be accepted for new timeouts.
    assert.commandWorked(conn.adminCommand({setParameter: 1, "ldapTimeoutMS": 50000}));
}

function runTimeoutTest(timeoutCallback, timeoutCallbackOptions) {
    // First, set up the LDAP config so that the replica set recognizes user ldapz_ldap1 for
    // authentication and authorization.
    let configGenerator = new LDAPTestConfigGenerator();
    configGenerator.ldapAuthzQueryTemplate = "{USER}?memberOf";
    configGenerator.ldapUserToDNMapping = [
        {match: "(ldapz_ldap1)", substitution: "cn={0}," + defaultUserDNSuffix},
        {match: "(ldapz_ldap2)", substitution: "cn={0}," + defaultUserDNSuffix},
    ];
    configGenerator.ldapTimeoutMS =
        (timeoutCallbackOptions.ldapTimeoutMS ? timeoutCallbackOptions.ldapTimeoutMS : 30000);
    configGenerator.ldapUseConnectionPool = timeoutCallbackOptions.isPooled;
    if (configGenerator.ldapUseConnectionPool) {
        configGenerator.ldapConnectionPoolMaximumConnectionsPerHost =
            timeoutCallbackOptions.maxPoolSize;
        configGenerator.ldapConnectionPoolHostRefreshIntervalMillis =
            timeoutCallbackOptions.ldapConnectionPoolHostRefreshIntervalMillis;
    }
    configGenerator.ldapValidateLDAPServerConfig = false;

    runTests(timeoutCallback, configGenerator, timeoutCallbackOptions);
}

runTimeoutTest(checkRuntimeTimeoutValues, testOptions);
}());
