/**
 * Verify the AWS IAM Auth can retry if the remote side kills the connection
 */

load("src/mongo/db/modules/enterprise/jstests/external_auth/lib/mock_sts.js");

(function() {
"use strict";

const mock_sts = new MockSTSServer(FAULT_CLOSE_TEN);
mock_sts.start();

const conn = MongoRunner.runMongod({
    setParameter: {
        "awsSTSUrl": mock_sts.getURL(),
        "authenticationMechanisms": "MONGODB-AWS,SCRAM-SHA-256",
        "awsSTSRetryCount": 15,
        "logComponentVerbosity": '{"accessControl":{"verbosity":4}}',
    },
    auth: "",
});

const external = conn.getDB("$external");
const admin = conn.getDB("admin");
assert.commandWorked(admin.runCommand({createUser: "admin", pwd: "pwd", roles: ['root']}));
assert(admin.auth("admin", "pwd"));

assert.commandWorked(
    external.runCommand({createUser: aws_common.users.permanentUser.simplifiedArn, roles: []}));
admin.logout();

// Make connection easy
assert(external.auth({
    user: aws_common.users.permanentUser.id,
    pwd: aws_common.users.permanentUser.secretKey,
    mechanism: 'MONGODB-AWS'
}));
external.logout();

// Make connection with lots of retries
assert(external.auth({
    user: aws_common.users.permanentUser.id,
    pwd: aws_common.users.permanentUser.secretKey,
    mechanism: 'MONGODB-AWS'
}));
external.logout();

// Make connection with lots of retries
assert(external.auth({
    user: aws_common.users.permanentUser.id,
    pwd: aws_common.users.permanentUser.secretKey,
    mechanism: 'MONGODB-AWS'
}));
external.logout();

assert(admin.auth("admin", "pwd"));

// Check for STS retry messages
checkLog.containsWithCount(conn, 7669901, 8);

mock_sts.stop();

MongoRunner.stopMongod(conn);
}());
