Copyright (c) 2010, Christiano F. Haesbaert <haesbaert@haesbaert.org>

# Multicast Domain Name System for OpenBSD

## Quickstart

If you're looking for a quickstart jump to the end of this document. 

## Intro

This is an attempt to bring native mdns/dns-sd to OpenBSD. Mainly cause all the other options suck and proper network browsing is a nice feature these days. 

My goal is to first provide a solid mdns framework without the service-discovery capabilities which are much more complex. When that is working properly, work on service-discovery will begin, the architecture was designed in order to support it. So goals: 

* Have a mdns responder/querier as an user process (`mdnsd`).
* Have integration with libc's resolver, read: make `gethostbyname` and friends resolve names through mdns.
* Have an application interface so other software can publish names/services as they see fit.
* Have a mdns control program, which is mainly a crude interface to the API. 

## MDNSD Design

The "Multicast Domain Name System Daemon" is an user process that runs without privileges, it binds to udp port 5353 and acts as the querier/responder for all mdns requests. By responder we understand who is responsible for answering mdns queries, and by querier the other way around, read: This is different from libc's unicast resolver, we *NEED* to cache answers and maintain state. 

As most OpenBSD daemons, it drops privilege upon startup and none task requires super-user privilege. All work is done on a single process, my first design had a process per interface, but that became overkill and overcomplex. 

The API is designed above Henning Brauer `imsg` framework, so we have a unix domain socket that listen to requests from other processes, much like `ripctl` and `ospfctl` do, but we need a fancier API.  We use libevent and all it's glorious features to have a proper unix daemon. 

There is a routing socket in order to be notified when link goes up and down, or when an interface address changes, this is *required* in order to publish records, every time link comes up we need to re-probe for our records and things like that, we use as our main name the short name from /etc/myname in the .local domain. 

The basic data flow would be: 

     __________                              _______  
    | Programs | <--Control Socket (API)--> | MDNSD | <-- Mcast Packets -->
     ----------                              -------

## LIBMDNS Design (API)

Libmdns is a shared library in which programs can link against in order to have mdns capabilities, like publishing services, browsing the network and so on, by now you can lookup resources, browse and publish services. All the library does is sending and receiving messages to `mdnsd` through the imsg framework.  The library should provides: 

* Means for looking up names. (DONE)
* Means for publishing names. (DONE)
* Means for browsing services (dns-service-discovery). (DONE)
* Means for publishing services. (DONE) 

By now no library is being used to make it easier for people to test `mdnsctl` (read no shared objecto), everything is being kept on `mdnsl.c` in `mdnsctl/`. 

On libc integration: 

After a chat with nicm@ we have decided not to worry about libc right now, maybe never. See the README file on mdns-libc branch if you're curious. 

## MDNSCTL

It's a simple interface for the library, code is inspired in `ripctl`. By now you can use it to lookup hosts, and browse and publish services. 

## How do I use this thing ?

Install it from openbsd ports (net/openmdns) 

Run `mdnsd` on the desired interface: `mdnsd -d rl0` 

Play with `mdnsctl`:


     # Lookup a host as well as the HINFO record
     mdnsctl lookup -h foobar.local
     # Reverse lookup an address
     mdnsctl rlookup 192.168.8.32
     # Browse up all services in the local network
     mdnsctl browse
     # Browse and resolve all services
     mdnsctl browse -r
     # Browse and resolve all the http services in the local network
     mdnsctl browse -r http tcp
     # Publish a simple ftp service
     mdnsctl publish myftp ftp tcp 21 "user=foobar"
     # Proxy publish a https service that has www.mysite.com as the target
     mdnsctl proxy mysite https tcp 443 www.mysite.com 12.3.45.6 "user=foobar"

