// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated from the elasticsearch-specification DO NOT EDIT.
// https://github.com/elastic/elasticsearch-specification/tree/470b4b9aaaa25cae633ec690e54b725c6fc939c7

package types

import (
	"bytes"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"strconv"
)

// NodeInfoSettingsTransport type.
//
// https://github.com/elastic/elasticsearch-specification/blob/470b4b9aaaa25cae633ec690e54b725c6fc939c7/specification/nodes/info/types.ts#L218-L227
type NodeInfoSettingsTransport struct {
	Features *NodeInfoSettingsTransportFeatures `json:"features,omitempty"`
	// IgnoreDeserializationErrors Only used in unit tests
	IgnoreDeserializationErrors Stringifiedboolean            `json:"ignore_deserialization_errors,omitempty"`
	Type                        NodeInfoSettingsTransportType `json:"type"`
	TypeDefault                 *string                       `json:"type.default,omitempty"`
}

func (s *NodeInfoSettingsTransport) UnmarshalJSON(data []byte) error {

	dec := json.NewDecoder(bytes.NewReader(data))

	for {
		t, err := dec.Token()
		if err != nil {
			if errors.Is(err, io.EOF) {
				break
			}
			return err
		}

		switch t {

		case "features":
			if err := dec.Decode(&s.Features); err != nil {
				return fmt.Errorf("%s | %w", "Features", err)
			}

		case "ignore_deserialization_errors":
			if err := dec.Decode(&s.IgnoreDeserializationErrors); err != nil {
				return fmt.Errorf("%s | %w", "IgnoreDeserializationErrors", err)
			}

		case "type":
			if err := dec.Decode(&s.Type); err != nil {
				return fmt.Errorf("%s | %w", "Type", err)
			}

		case "type.default":
			var tmp json.RawMessage
			if err := dec.Decode(&tmp); err != nil {
				return fmt.Errorf("%s | %w", "TypeDefault", err)
			}
			o := string(tmp[:])
			o, err = strconv.Unquote(o)
			if err != nil {
				o = string(tmp[:])
			}
			s.TypeDefault = &o

		}
	}
	return nil
}

// NewNodeInfoSettingsTransport returns a NodeInfoSettingsTransport.
func NewNodeInfoSettingsTransport() *NodeInfoSettingsTransport {
	r := &NodeInfoSettingsTransport{}

	return r
}
