// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated from the elasticsearch-specification DO NOT EDIT.
// https://github.com/elastic/elasticsearch-specification/tree/470b4b9aaaa25cae633ec690e54b725c6fc939c7

// Package tasktypealibabacloudai
package tasktypealibabacloudai

import "strings"

// https://github.com/elastic/elasticsearch-specification/blob/470b4b9aaaa25cae633ec690e54b725c6fc939c7/specification/inference/_types/TaskType.ts#L36-L41
type TaskTypeAlibabaCloudAI struct {
	Name string
}

var (
	Textembedding = TaskTypeAlibabaCloudAI{"text_embedding"}

	Rerank = TaskTypeAlibabaCloudAI{"rerank"}

	Completion = TaskTypeAlibabaCloudAI{"completion"}

	Sparseembedding = TaskTypeAlibabaCloudAI{"sparse_embedding"}
)

func (t TaskTypeAlibabaCloudAI) MarshalText() (text []byte, err error) {
	return []byte(t.String()), nil
}

func (t *TaskTypeAlibabaCloudAI) UnmarshalText(text []byte) error {
	switch strings.ReplaceAll(strings.ToLower(string(text)), "\"", "") {

	case "text_embedding":
		*t = Textembedding
	case "rerank":
		*t = Rerank
	case "completion":
		*t = Completion
	case "sparse_embedding":
		*t = Sparseembedding
	default:
		*t = TaskTypeAlibabaCloudAI{string(text)}
	}

	return nil
}

func (t TaskTypeAlibabaCloudAI) String() string {
	return t.Name
}
