// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated from the elasticsearch-specification DO NOT EDIT.
// https://github.com/elastic/elasticsearch-specification/tree/470b4b9aaaa25cae633ec690e54b725c6fc939c7

package samlauthenticate

// Response holds the response body struct for the package samlauthenticate
//
// https://github.com/elastic/elasticsearch-specification/blob/470b4b9aaaa25cae633ec690e54b725c6fc939c7/specification/security/saml_authenticate/Response.ts#L22-L45
type Response struct {

	// AccessToken The access token that was generated by Elasticsearch.
	AccessToken string `json:"access_token"`
	// ExpiresIn The amount of time (in seconds) left until the token expires.
	ExpiresIn int `json:"expires_in"`
	// Realm The name of the realm where the user was authenticated.
	Realm string `json:"realm"`
	// RefreshToken The refresh token that was generated by Elasticsearch.
	RefreshToken string `json:"refresh_token"`
	// Username The authenticated user's name.
	Username string `json:"username"`
}

// NewResponse returns a Response
func NewResponse() *Response {
	r := &Response{}
	return r
}
