// Code generated by mockery v2.53.4. DO NOT EDIT.

// Regenerate this file using `make store-mocks`.

package mocks

import (
	model "github.com/mattermost/mattermost/server/public/model"
	mock "github.com/stretchr/testify/mock"
)

// GroupStore is an autogenerated mock type for the GroupStore type
type GroupStore struct {
	mock.Mock
}

// AdminRoleGroupsForSyncableMember provides a mock function with given fields: userID, syncableID, syncableType
func (_m *GroupStore) AdminRoleGroupsForSyncableMember(userID string, syncableID string, syncableType model.GroupSyncableType) ([]string, error) {
	ret := _m.Called(userID, syncableID, syncableType)

	if len(ret) == 0 {
		panic("no return value specified for AdminRoleGroupsForSyncableMember")
	}

	var r0 []string
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string, model.GroupSyncableType) ([]string, error)); ok {
		return rf(userID, syncableID, syncableType)
	}
	if rf, ok := ret.Get(0).(func(string, string, model.GroupSyncableType) []string); ok {
		r0 = rf(userID, syncableID, syncableType)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, model.GroupSyncableType) error); ok {
		r1 = rf(userID, syncableID, syncableType)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ChannelMembersMinusGroupMembers provides a mock function with given fields: channelID, groupIDs, page, perPage
func (_m *GroupStore) ChannelMembersMinusGroupMembers(channelID string, groupIDs []string, page int, perPage int) ([]*model.UserWithGroups, error) {
	ret := _m.Called(channelID, groupIDs, page, perPage)

	if len(ret) == 0 {
		panic("no return value specified for ChannelMembersMinusGroupMembers")
	}

	var r0 []*model.UserWithGroups
	var r1 error
	if rf, ok := ret.Get(0).(func(string, []string, int, int) ([]*model.UserWithGroups, error)); ok {
		return rf(channelID, groupIDs, page, perPage)
	}
	if rf, ok := ret.Get(0).(func(string, []string, int, int) []*model.UserWithGroups); ok {
		r0 = rf(channelID, groupIDs, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.UserWithGroups)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []string, int, int) error); ok {
		r1 = rf(channelID, groupIDs, page, perPage)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ChannelMembersToAdd provides a mock function with given fields: since, channelID, reAddRemovedMembers
func (_m *GroupStore) ChannelMembersToAdd(since int64, channelID *string, reAddRemovedMembers bool) ([]*model.UserChannelIDPair, error) {
	ret := _m.Called(since, channelID, reAddRemovedMembers)

	if len(ret) == 0 {
		panic("no return value specified for ChannelMembersToAdd")
	}

	var r0 []*model.UserChannelIDPair
	var r1 error
	if rf, ok := ret.Get(0).(func(int64, *string, bool) ([]*model.UserChannelIDPair, error)); ok {
		return rf(since, channelID, reAddRemovedMembers)
	}
	if rf, ok := ret.Get(0).(func(int64, *string, bool) []*model.UserChannelIDPair); ok {
		r0 = rf(since, channelID, reAddRemovedMembers)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.UserChannelIDPair)
		}
	}

	if rf, ok := ret.Get(1).(func(int64, *string, bool) error); ok {
		r1 = rf(since, channelID, reAddRemovedMembers)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ChannelMembersToRemove provides a mock function with given fields: channelID
func (_m *GroupStore) ChannelMembersToRemove(channelID *string) ([]*model.ChannelMember, error) {
	ret := _m.Called(channelID)

	if len(ret) == 0 {
		panic("no return value specified for ChannelMembersToRemove")
	}

	var r0 []*model.ChannelMember
	var r1 error
	if rf, ok := ret.Get(0).(func(*string) ([]*model.ChannelMember, error)); ok {
		return rf(channelID)
	}
	if rf, ok := ret.Get(0).(func(*string) []*model.ChannelMember); ok {
		r0 = rf(channelID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.ChannelMember)
		}
	}

	if rf, ok := ret.Get(1).(func(*string) error); ok {
		r1 = rf(channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CountChannelMembersMinusGroupMembers provides a mock function with given fields: channelID, groupIDs
func (_m *GroupStore) CountChannelMembersMinusGroupMembers(channelID string, groupIDs []string) (int64, error) {
	ret := _m.Called(channelID, groupIDs)

	if len(ret) == 0 {
		panic("no return value specified for CountChannelMembersMinusGroupMembers")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(string, []string) (int64, error)); ok {
		return rf(channelID, groupIDs)
	}
	if rf, ok := ret.Get(0).(func(string, []string) int64); ok {
		r0 = rf(channelID, groupIDs)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(string, []string) error); ok {
		r1 = rf(channelID, groupIDs)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CountGroupsByChannel provides a mock function with given fields: channelID, opts
func (_m *GroupStore) CountGroupsByChannel(channelID string, opts model.GroupSearchOpts) (int64, error) {
	ret := _m.Called(channelID, opts)

	if len(ret) == 0 {
		panic("no return value specified for CountGroupsByChannel")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(string, model.GroupSearchOpts) (int64, error)); ok {
		return rf(channelID, opts)
	}
	if rf, ok := ret.Get(0).(func(string, model.GroupSearchOpts) int64); ok {
		r0 = rf(channelID, opts)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(string, model.GroupSearchOpts) error); ok {
		r1 = rf(channelID, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CountGroupsByTeam provides a mock function with given fields: teamID, opts
func (_m *GroupStore) CountGroupsByTeam(teamID string, opts model.GroupSearchOpts) (int64, error) {
	ret := _m.Called(teamID, opts)

	if len(ret) == 0 {
		panic("no return value specified for CountGroupsByTeam")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(string, model.GroupSearchOpts) (int64, error)); ok {
		return rf(teamID, opts)
	}
	if rf, ok := ret.Get(0).(func(string, model.GroupSearchOpts) int64); ok {
		r0 = rf(teamID, opts)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(string, model.GroupSearchOpts) error); ok {
		r1 = rf(teamID, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CountTeamMembersMinusGroupMembers provides a mock function with given fields: teamID, groupIDs
func (_m *GroupStore) CountTeamMembersMinusGroupMembers(teamID string, groupIDs []string) (int64, error) {
	ret := _m.Called(teamID, groupIDs)

	if len(ret) == 0 {
		panic("no return value specified for CountTeamMembersMinusGroupMembers")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(string, []string) (int64, error)); ok {
		return rf(teamID, groupIDs)
	}
	if rf, ok := ret.Get(0).(func(string, []string) int64); ok {
		r0 = rf(teamID, groupIDs)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(string, []string) error); ok {
		r1 = rf(teamID, groupIDs)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Create provides a mock function with given fields: group
func (_m *GroupStore) Create(group *model.Group) (*model.Group, error) {
	ret := _m.Called(group)

	if len(ret) == 0 {
		panic("no return value specified for Create")
	}

	var r0 *model.Group
	var r1 error
	if rf, ok := ret.Get(0).(func(*model.Group) (*model.Group, error)); ok {
		return rf(group)
	}
	if rf, ok := ret.Get(0).(func(*model.Group) *model.Group); ok {
		r0 = rf(group)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.Group) error); ok {
		r1 = rf(group)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateGroupSyncable provides a mock function with given fields: groupSyncable
func (_m *GroupStore) CreateGroupSyncable(groupSyncable *model.GroupSyncable) (*model.GroupSyncable, error) {
	ret := _m.Called(groupSyncable)

	if len(ret) == 0 {
		panic("no return value specified for CreateGroupSyncable")
	}

	var r0 *model.GroupSyncable
	var r1 error
	if rf, ok := ret.Get(0).(func(*model.GroupSyncable) (*model.GroupSyncable, error)); ok {
		return rf(groupSyncable)
	}
	if rf, ok := ret.Get(0).(func(*model.GroupSyncable) *model.GroupSyncable); ok {
		r0 = rf(groupSyncable)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.GroupSyncable)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.GroupSyncable) error); ok {
		r1 = rf(groupSyncable)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateWithUserIds provides a mock function with given fields: group
func (_m *GroupStore) CreateWithUserIds(group *model.GroupWithUserIds) (*model.Group, error) {
	ret := _m.Called(group)

	if len(ret) == 0 {
		panic("no return value specified for CreateWithUserIds")
	}

	var r0 *model.Group
	var r1 error
	if rf, ok := ret.Get(0).(func(*model.GroupWithUserIds) (*model.Group, error)); ok {
		return rf(group)
	}
	if rf, ok := ret.Get(0).(func(*model.GroupWithUserIds) *model.Group); ok {
		r0 = rf(group)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.GroupWithUserIds) error); ok {
		r1 = rf(group)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Delete provides a mock function with given fields: groupID
func (_m *GroupStore) Delete(groupID string) (*model.Group, error) {
	ret := _m.Called(groupID)

	if len(ret) == 0 {
		panic("no return value specified for Delete")
	}

	var r0 *model.Group
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (*model.Group, error)); ok {
		return rf(groupID)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Group); ok {
		r0 = rf(groupID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(groupID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeleteGroupSyncable provides a mock function with given fields: groupID, syncableID, syncableType
func (_m *GroupStore) DeleteGroupSyncable(groupID string, syncableID string, syncableType model.GroupSyncableType) (*model.GroupSyncable, error) {
	ret := _m.Called(groupID, syncableID, syncableType)

	if len(ret) == 0 {
		panic("no return value specified for DeleteGroupSyncable")
	}

	var r0 *model.GroupSyncable
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string, model.GroupSyncableType) (*model.GroupSyncable, error)); ok {
		return rf(groupID, syncableID, syncableType)
	}
	if rf, ok := ret.Get(0).(func(string, string, model.GroupSyncableType) *model.GroupSyncable); ok {
		r0 = rf(groupID, syncableID, syncableType)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.GroupSyncable)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, model.GroupSyncableType) error); ok {
		r1 = rf(groupID, syncableID, syncableType)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeleteMember provides a mock function with given fields: groupID, userID
func (_m *GroupStore) DeleteMember(groupID string, userID string) (*model.GroupMember, error) {
	ret := _m.Called(groupID, userID)

	if len(ret) == 0 {
		panic("no return value specified for DeleteMember")
	}

	var r0 *model.GroupMember
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) (*model.GroupMember, error)); ok {
		return rf(groupID, userID)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.GroupMember); ok {
		r0 = rf(groupID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.GroupMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(groupID, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeleteMembers provides a mock function with given fields: groupID, userIDs
func (_m *GroupStore) DeleteMembers(groupID string, userIDs []string) ([]*model.GroupMember, error) {
	ret := _m.Called(groupID, userIDs)

	if len(ret) == 0 {
		panic("no return value specified for DeleteMembers")
	}

	var r0 []*model.GroupMember
	var r1 error
	if rf, ok := ret.Get(0).(func(string, []string) ([]*model.GroupMember, error)); ok {
		return rf(groupID, userIDs)
	}
	if rf, ok := ret.Get(0).(func(string, []string) []*model.GroupMember); ok {
		r0 = rf(groupID, userIDs)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.GroupMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []string) error); ok {
		r1 = rf(groupID, userIDs)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DistinctGroupMemberCount provides a mock function with no fields
func (_m *GroupStore) DistinctGroupMemberCount() (int64, error) {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for DistinctGroupMemberCount")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func() (int64, error)); ok {
		return rf()
	}
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DistinctGroupMemberCountForSource provides a mock function with given fields: source
func (_m *GroupStore) DistinctGroupMemberCountForSource(source model.GroupSource) (int64, error) {
	ret := _m.Called(source)

	if len(ret) == 0 {
		panic("no return value specified for DistinctGroupMemberCountForSource")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(model.GroupSource) (int64, error)); ok {
		return rf(source)
	}
	if rf, ok := ret.Get(0).(func(model.GroupSource) int64); ok {
		r0 = rf(source)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(model.GroupSource) error); ok {
		r1 = rf(source)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Get provides a mock function with given fields: groupID
func (_m *GroupStore) Get(groupID string) (*model.Group, error) {
	ret := _m.Called(groupID)

	if len(ret) == 0 {
		panic("no return value specified for Get")
	}

	var r0 *model.Group
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (*model.Group, error)); ok {
		return rf(groupID)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Group); ok {
		r0 = rf(groupID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(groupID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAllBySource provides a mock function with given fields: groupSource
func (_m *GroupStore) GetAllBySource(groupSource model.GroupSource) ([]*model.Group, error) {
	ret := _m.Called(groupSource)

	if len(ret) == 0 {
		panic("no return value specified for GetAllBySource")
	}

	var r0 []*model.Group
	var r1 error
	if rf, ok := ret.Get(0).(func(model.GroupSource) ([]*model.Group, error)); ok {
		return rf(groupSource)
	}
	if rf, ok := ret.Get(0).(func(model.GroupSource) []*model.Group); ok {
		r0 = rf(groupSource)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(model.GroupSource) error); ok {
		r1 = rf(groupSource)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAllGroupSyncablesByGroupId provides a mock function with given fields: groupID, syncableType
func (_m *GroupStore) GetAllGroupSyncablesByGroupId(groupID string, syncableType model.GroupSyncableType) ([]*model.GroupSyncable, error) {
	ret := _m.Called(groupID, syncableType)

	if len(ret) == 0 {
		panic("no return value specified for GetAllGroupSyncablesByGroupId")
	}

	var r0 []*model.GroupSyncable
	var r1 error
	if rf, ok := ret.Get(0).(func(string, model.GroupSyncableType) ([]*model.GroupSyncable, error)); ok {
		return rf(groupID, syncableType)
	}
	if rf, ok := ret.Get(0).(func(string, model.GroupSyncableType) []*model.GroupSyncable); ok {
		r0 = rf(groupID, syncableType)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.GroupSyncable)
		}
	}

	if rf, ok := ret.Get(1).(func(string, model.GroupSyncableType) error); ok {
		r1 = rf(groupID, syncableType)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetByIDs provides a mock function with given fields: groupIDs
func (_m *GroupStore) GetByIDs(groupIDs []string) ([]*model.Group, error) {
	ret := _m.Called(groupIDs)

	if len(ret) == 0 {
		panic("no return value specified for GetByIDs")
	}

	var r0 []*model.Group
	var r1 error
	if rf, ok := ret.Get(0).(func([]string) ([]*model.Group, error)); ok {
		return rf(groupIDs)
	}
	if rf, ok := ret.Get(0).(func([]string) []*model.Group); ok {
		r0 = rf(groupIDs)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func([]string) error); ok {
		r1 = rf(groupIDs)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetByName provides a mock function with given fields: name, opts
func (_m *GroupStore) GetByName(name string, opts model.GroupSearchOpts) (*model.Group, error) {
	ret := _m.Called(name, opts)

	if len(ret) == 0 {
		panic("no return value specified for GetByName")
	}

	var r0 *model.Group
	var r1 error
	if rf, ok := ret.Get(0).(func(string, model.GroupSearchOpts) (*model.Group, error)); ok {
		return rf(name, opts)
	}
	if rf, ok := ret.Get(0).(func(string, model.GroupSearchOpts) *model.Group); ok {
		r0 = rf(name, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(string, model.GroupSearchOpts) error); ok {
		r1 = rf(name, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetByNames provides a mock function with given fields: names, viewRestrictions
func (_m *GroupStore) GetByNames(names []string, viewRestrictions *model.ViewUsersRestrictions) ([]*model.Group, error) {
	ret := _m.Called(names, viewRestrictions)

	if len(ret) == 0 {
		panic("no return value specified for GetByNames")
	}

	var r0 []*model.Group
	var r1 error
	if rf, ok := ret.Get(0).(func([]string, *model.ViewUsersRestrictions) ([]*model.Group, error)); ok {
		return rf(names, viewRestrictions)
	}
	if rf, ok := ret.Get(0).(func([]string, *model.ViewUsersRestrictions) []*model.Group); ok {
		r0 = rf(names, viewRestrictions)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func([]string, *model.ViewUsersRestrictions) error); ok {
		r1 = rf(names, viewRestrictions)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetByRemoteID provides a mock function with given fields: remoteID, groupSource
func (_m *GroupStore) GetByRemoteID(remoteID string, groupSource model.GroupSource) (*model.Group, error) {
	ret := _m.Called(remoteID, groupSource)

	if len(ret) == 0 {
		panic("no return value specified for GetByRemoteID")
	}

	var r0 *model.Group
	var r1 error
	if rf, ok := ret.Get(0).(func(string, model.GroupSource) (*model.Group, error)); ok {
		return rf(remoteID, groupSource)
	}
	if rf, ok := ret.Get(0).(func(string, model.GroupSource) *model.Group); ok {
		r0 = rf(remoteID, groupSource)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(string, model.GroupSource) error); ok {
		r1 = rf(remoteID, groupSource)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetByUser provides a mock function with given fields: userID, opts
func (_m *GroupStore) GetByUser(userID string, opts model.GroupSearchOpts) ([]*model.Group, error) {
	ret := _m.Called(userID, opts)

	if len(ret) == 0 {
		panic("no return value specified for GetByUser")
	}

	var r0 []*model.Group
	var r1 error
	if rf, ok := ret.Get(0).(func(string, model.GroupSearchOpts) ([]*model.Group, error)); ok {
		return rf(userID, opts)
	}
	if rf, ok := ret.Get(0).(func(string, model.GroupSearchOpts) []*model.Group); ok {
		r0 = rf(userID, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(string, model.GroupSearchOpts) error); ok {
		r1 = rf(userID, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetGroupSyncable provides a mock function with given fields: groupID, syncableID, syncableType
func (_m *GroupStore) GetGroupSyncable(groupID string, syncableID string, syncableType model.GroupSyncableType) (*model.GroupSyncable, error) {
	ret := _m.Called(groupID, syncableID, syncableType)

	if len(ret) == 0 {
		panic("no return value specified for GetGroupSyncable")
	}

	var r0 *model.GroupSyncable
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string, model.GroupSyncableType) (*model.GroupSyncable, error)); ok {
		return rf(groupID, syncableID, syncableType)
	}
	if rf, ok := ret.Get(0).(func(string, string, model.GroupSyncableType) *model.GroupSyncable); ok {
		r0 = rf(groupID, syncableID, syncableType)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.GroupSyncable)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, model.GroupSyncableType) error); ok {
		r1 = rf(groupID, syncableID, syncableType)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetGroups provides a mock function with given fields: page, perPage, opts, viewRestrictions
func (_m *GroupStore) GetGroups(page int, perPage int, opts model.GroupSearchOpts, viewRestrictions *model.ViewUsersRestrictions) ([]*model.Group, error) {
	ret := _m.Called(page, perPage, opts, viewRestrictions)

	if len(ret) == 0 {
		panic("no return value specified for GetGroups")
	}

	var r0 []*model.Group
	var r1 error
	if rf, ok := ret.Get(0).(func(int, int, model.GroupSearchOpts, *model.ViewUsersRestrictions) ([]*model.Group, error)); ok {
		return rf(page, perPage, opts, viewRestrictions)
	}
	if rf, ok := ret.Get(0).(func(int, int, model.GroupSearchOpts, *model.ViewUsersRestrictions) []*model.Group); ok {
		r0 = rf(page, perPage, opts, viewRestrictions)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(int, int, model.GroupSearchOpts, *model.ViewUsersRestrictions) error); ok {
		r1 = rf(page, perPage, opts, viewRestrictions)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetGroupsAssociatedToChannelsByTeam provides a mock function with given fields: teamID, opts
func (_m *GroupStore) GetGroupsAssociatedToChannelsByTeam(teamID string, opts model.GroupSearchOpts) (map[string][]*model.GroupWithSchemeAdmin, error) {
	ret := _m.Called(teamID, opts)

	if len(ret) == 0 {
		panic("no return value specified for GetGroupsAssociatedToChannelsByTeam")
	}

	var r0 map[string][]*model.GroupWithSchemeAdmin
	var r1 error
	if rf, ok := ret.Get(0).(func(string, model.GroupSearchOpts) (map[string][]*model.GroupWithSchemeAdmin, error)); ok {
		return rf(teamID, opts)
	}
	if rf, ok := ret.Get(0).(func(string, model.GroupSearchOpts) map[string][]*model.GroupWithSchemeAdmin); ok {
		r0 = rf(teamID, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string][]*model.GroupWithSchemeAdmin)
		}
	}

	if rf, ok := ret.Get(1).(func(string, model.GroupSearchOpts) error); ok {
		r1 = rf(teamID, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetGroupsByChannel provides a mock function with given fields: channelID, opts
func (_m *GroupStore) GetGroupsByChannel(channelID string, opts model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, error) {
	ret := _m.Called(channelID, opts)

	if len(ret) == 0 {
		panic("no return value specified for GetGroupsByChannel")
	}

	var r0 []*model.GroupWithSchemeAdmin
	var r1 error
	if rf, ok := ret.Get(0).(func(string, model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, error)); ok {
		return rf(channelID, opts)
	}
	if rf, ok := ret.Get(0).(func(string, model.GroupSearchOpts) []*model.GroupWithSchemeAdmin); ok {
		r0 = rf(channelID, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.GroupWithSchemeAdmin)
		}
	}

	if rf, ok := ret.Get(1).(func(string, model.GroupSearchOpts) error); ok {
		r1 = rf(channelID, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetGroupsByTeam provides a mock function with given fields: teamID, opts
func (_m *GroupStore) GetGroupsByTeam(teamID string, opts model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, error) {
	ret := _m.Called(teamID, opts)

	if len(ret) == 0 {
		panic("no return value specified for GetGroupsByTeam")
	}

	var r0 []*model.GroupWithSchemeAdmin
	var r1 error
	if rf, ok := ret.Get(0).(func(string, model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, error)); ok {
		return rf(teamID, opts)
	}
	if rf, ok := ret.Get(0).(func(string, model.GroupSearchOpts) []*model.GroupWithSchemeAdmin); ok {
		r0 = rf(teamID, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.GroupWithSchemeAdmin)
		}
	}

	if rf, ok := ret.Get(1).(func(string, model.GroupSearchOpts) error); ok {
		r1 = rf(teamID, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMember provides a mock function with given fields: groupID, userID
func (_m *GroupStore) GetMember(groupID string, userID string) (*model.GroupMember, error) {
	ret := _m.Called(groupID, userID)

	if len(ret) == 0 {
		panic("no return value specified for GetMember")
	}

	var r0 *model.GroupMember
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) (*model.GroupMember, error)); ok {
		return rf(groupID, userID)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.GroupMember); ok {
		r0 = rf(groupID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.GroupMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(groupID, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMemberCount provides a mock function with given fields: groupID
func (_m *GroupStore) GetMemberCount(groupID string) (int64, error) {
	ret := _m.Called(groupID)

	if len(ret) == 0 {
		panic("no return value specified for GetMemberCount")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (int64, error)); ok {
		return rf(groupID)
	}
	if rf, ok := ret.Get(0).(func(string) int64); ok {
		r0 = rf(groupID)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(groupID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMemberCountWithRestrictions provides a mock function with given fields: groupID, viewRestrictions
func (_m *GroupStore) GetMemberCountWithRestrictions(groupID string, viewRestrictions *model.ViewUsersRestrictions) (int64, error) {
	ret := _m.Called(groupID, viewRestrictions)

	if len(ret) == 0 {
		panic("no return value specified for GetMemberCountWithRestrictions")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(string, *model.ViewUsersRestrictions) (int64, error)); ok {
		return rf(groupID, viewRestrictions)
	}
	if rf, ok := ret.Get(0).(func(string, *model.ViewUsersRestrictions) int64); ok {
		r0 = rf(groupID, viewRestrictions)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(string, *model.ViewUsersRestrictions) error); ok {
		r1 = rf(groupID, viewRestrictions)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMemberUsers provides a mock function with given fields: groupID
func (_m *GroupStore) GetMemberUsers(groupID string) ([]*model.User, error) {
	ret := _m.Called(groupID)

	if len(ret) == 0 {
		panic("no return value specified for GetMemberUsers")
	}

	var r0 []*model.User
	var r1 error
	if rf, ok := ret.Get(0).(func(string) ([]*model.User, error)); ok {
		return rf(groupID)
	}
	if rf, ok := ret.Get(0).(func(string) []*model.User); ok {
		r0 = rf(groupID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(groupID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMemberUsersInTeam provides a mock function with given fields: groupID, teamID
func (_m *GroupStore) GetMemberUsersInTeam(groupID string, teamID string) ([]*model.User, error) {
	ret := _m.Called(groupID, teamID)

	if len(ret) == 0 {
		panic("no return value specified for GetMemberUsersInTeam")
	}

	var r0 []*model.User
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) ([]*model.User, error)); ok {
		return rf(groupID, teamID)
	}
	if rf, ok := ret.Get(0).(func(string, string) []*model.User); ok {
		r0 = rf(groupID, teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(groupID, teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMemberUsersNotInChannel provides a mock function with given fields: groupID, channelID
func (_m *GroupStore) GetMemberUsersNotInChannel(groupID string, channelID string) ([]*model.User, error) {
	ret := _m.Called(groupID, channelID)

	if len(ret) == 0 {
		panic("no return value specified for GetMemberUsersNotInChannel")
	}

	var r0 []*model.User
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) ([]*model.User, error)); ok {
		return rf(groupID, channelID)
	}
	if rf, ok := ret.Get(0).(func(string, string) []*model.User); ok {
		r0 = rf(groupID, channelID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(groupID, channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMemberUsersPage provides a mock function with given fields: groupID, page, perPage, viewRestrictions
func (_m *GroupStore) GetMemberUsersPage(groupID string, page int, perPage int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {
	ret := _m.Called(groupID, page, perPage, viewRestrictions)

	if len(ret) == 0 {
		panic("no return value specified for GetMemberUsersPage")
	}

	var r0 []*model.User
	var r1 error
	if rf, ok := ret.Get(0).(func(string, int, int, *model.ViewUsersRestrictions) ([]*model.User, error)); ok {
		return rf(groupID, page, perPage, viewRestrictions)
	}
	if rf, ok := ret.Get(0).(func(string, int, int, *model.ViewUsersRestrictions) []*model.User); ok {
		r0 = rf(groupID, page, perPage, viewRestrictions)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int, int, *model.ViewUsersRestrictions) error); ok {
		r1 = rf(groupID, page, perPage, viewRestrictions)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMemberUsersSortedPage provides a mock function with given fields: groupID, page, perPage, viewRestrictions, teammateNameDisplay
func (_m *GroupStore) GetMemberUsersSortedPage(groupID string, page int, perPage int, viewRestrictions *model.ViewUsersRestrictions, teammateNameDisplay string) ([]*model.User, error) {
	ret := _m.Called(groupID, page, perPage, viewRestrictions, teammateNameDisplay)

	if len(ret) == 0 {
		panic("no return value specified for GetMemberUsersSortedPage")
	}

	var r0 []*model.User
	var r1 error
	if rf, ok := ret.Get(0).(func(string, int, int, *model.ViewUsersRestrictions, string) ([]*model.User, error)); ok {
		return rf(groupID, page, perPage, viewRestrictions, teammateNameDisplay)
	}
	if rf, ok := ret.Get(0).(func(string, int, int, *model.ViewUsersRestrictions, string) []*model.User); ok {
		r0 = rf(groupID, page, perPage, viewRestrictions, teammateNameDisplay)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int, int, *model.ViewUsersRestrictions, string) error); ok {
		r1 = rf(groupID, page, perPage, viewRestrictions, teammateNameDisplay)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetNonMemberUsersPage provides a mock function with given fields: groupID, page, perPage, viewRestrictions
func (_m *GroupStore) GetNonMemberUsersPage(groupID string, page int, perPage int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {
	ret := _m.Called(groupID, page, perPage, viewRestrictions)

	if len(ret) == 0 {
		panic("no return value specified for GetNonMemberUsersPage")
	}

	var r0 []*model.User
	var r1 error
	if rf, ok := ret.Get(0).(func(string, int, int, *model.ViewUsersRestrictions) ([]*model.User, error)); ok {
		return rf(groupID, page, perPage, viewRestrictions)
	}
	if rf, ok := ret.Get(0).(func(string, int, int, *model.ViewUsersRestrictions) []*model.User); ok {
		r0 = rf(groupID, page, perPage, viewRestrictions)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int, int, *model.ViewUsersRestrictions) error); ok {
		r1 = rf(groupID, page, perPage, viewRestrictions)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GroupChannelCount provides a mock function with no fields
func (_m *GroupStore) GroupChannelCount() (int64, error) {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GroupChannelCount")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func() (int64, error)); ok {
		return rf()
	}
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GroupCount provides a mock function with no fields
func (_m *GroupStore) GroupCount() (int64, error) {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GroupCount")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func() (int64, error)); ok {
		return rf()
	}
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GroupCountBySource provides a mock function with given fields: source
func (_m *GroupStore) GroupCountBySource(source model.GroupSource) (int64, error) {
	ret := _m.Called(source)

	if len(ret) == 0 {
		panic("no return value specified for GroupCountBySource")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(model.GroupSource) (int64, error)); ok {
		return rf(source)
	}
	if rf, ok := ret.Get(0).(func(model.GroupSource) int64); ok {
		r0 = rf(source)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(model.GroupSource) error); ok {
		r1 = rf(source)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GroupCountWithAllowReference provides a mock function with no fields
func (_m *GroupStore) GroupCountWithAllowReference() (int64, error) {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GroupCountWithAllowReference")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func() (int64, error)); ok {
		return rf()
	}
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GroupMemberCount provides a mock function with no fields
func (_m *GroupStore) GroupMemberCount() (int64, error) {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GroupMemberCount")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func() (int64, error)); ok {
		return rf()
	}
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GroupTeamCount provides a mock function with no fields
func (_m *GroupStore) GroupTeamCount() (int64, error) {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GroupTeamCount")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func() (int64, error)); ok {
		return rf()
	}
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// PermanentDeleteMembersByUser provides a mock function with given fields: userID
func (_m *GroupStore) PermanentDeleteMembersByUser(userID string) error {
	ret := _m.Called(userID)

	if len(ret) == 0 {
		panic("no return value specified for PermanentDeleteMembersByUser")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(userID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PermittedSyncableAdmins provides a mock function with given fields: syncableID, syncableType
func (_m *GroupStore) PermittedSyncableAdmins(syncableID string, syncableType model.GroupSyncableType) ([]string, error) {
	ret := _m.Called(syncableID, syncableType)

	if len(ret) == 0 {
		panic("no return value specified for PermittedSyncableAdmins")
	}

	var r0 []string
	var r1 error
	if rf, ok := ret.Get(0).(func(string, model.GroupSyncableType) ([]string, error)); ok {
		return rf(syncableID, syncableType)
	}
	if rf, ok := ret.Get(0).(func(string, model.GroupSyncableType) []string); ok {
		r0 = rf(syncableID, syncableType)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	if rf, ok := ret.Get(1).(func(string, model.GroupSyncableType) error); ok {
		r1 = rf(syncableID, syncableType)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Restore provides a mock function with given fields: groupID
func (_m *GroupStore) Restore(groupID string) (*model.Group, error) {
	ret := _m.Called(groupID)

	if len(ret) == 0 {
		panic("no return value specified for Restore")
	}

	var r0 *model.Group
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (*model.Group, error)); ok {
		return rf(groupID)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Group); ok {
		r0 = rf(groupID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(groupID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// TeamMembersMinusGroupMembers provides a mock function with given fields: teamID, groupIDs, page, perPage
func (_m *GroupStore) TeamMembersMinusGroupMembers(teamID string, groupIDs []string, page int, perPage int) ([]*model.UserWithGroups, error) {
	ret := _m.Called(teamID, groupIDs, page, perPage)

	if len(ret) == 0 {
		panic("no return value specified for TeamMembersMinusGroupMembers")
	}

	var r0 []*model.UserWithGroups
	var r1 error
	if rf, ok := ret.Get(0).(func(string, []string, int, int) ([]*model.UserWithGroups, error)); ok {
		return rf(teamID, groupIDs, page, perPage)
	}
	if rf, ok := ret.Get(0).(func(string, []string, int, int) []*model.UserWithGroups); ok {
		r0 = rf(teamID, groupIDs, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.UserWithGroups)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []string, int, int) error); ok {
		r1 = rf(teamID, groupIDs, page, perPage)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// TeamMembersToAdd provides a mock function with given fields: since, teamID, reAddRemovedMembers
func (_m *GroupStore) TeamMembersToAdd(since int64, teamID *string, reAddRemovedMembers bool) ([]*model.UserTeamIDPair, error) {
	ret := _m.Called(since, teamID, reAddRemovedMembers)

	if len(ret) == 0 {
		panic("no return value specified for TeamMembersToAdd")
	}

	var r0 []*model.UserTeamIDPair
	var r1 error
	if rf, ok := ret.Get(0).(func(int64, *string, bool) ([]*model.UserTeamIDPair, error)); ok {
		return rf(since, teamID, reAddRemovedMembers)
	}
	if rf, ok := ret.Get(0).(func(int64, *string, bool) []*model.UserTeamIDPair); ok {
		r0 = rf(since, teamID, reAddRemovedMembers)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.UserTeamIDPair)
		}
	}

	if rf, ok := ret.Get(1).(func(int64, *string, bool) error); ok {
		r1 = rf(since, teamID, reAddRemovedMembers)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// TeamMembersToRemove provides a mock function with given fields: teamID
func (_m *GroupStore) TeamMembersToRemove(teamID *string) ([]*model.TeamMember, error) {
	ret := _m.Called(teamID)

	if len(ret) == 0 {
		panic("no return value specified for TeamMembersToRemove")
	}

	var r0 []*model.TeamMember
	var r1 error
	if rf, ok := ret.Get(0).(func(*string) ([]*model.TeamMember, error)); ok {
		return rf(teamID)
	}
	if rf, ok := ret.Get(0).(func(*string) []*model.TeamMember); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.TeamMember)
		}
	}

	if rf, ok := ret.Get(1).(func(*string) error); ok {
		r1 = rf(teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Update provides a mock function with given fields: group
func (_m *GroupStore) Update(group *model.Group) (*model.Group, error) {
	ret := _m.Called(group)

	if len(ret) == 0 {
		panic("no return value specified for Update")
	}

	var r0 *model.Group
	var r1 error
	if rf, ok := ret.Get(0).(func(*model.Group) (*model.Group, error)); ok {
		return rf(group)
	}
	if rf, ok := ret.Get(0).(func(*model.Group) *model.Group); ok {
		r0 = rf(group)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Group)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.Group) error); ok {
		r1 = rf(group)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateGroupSyncable provides a mock function with given fields: groupSyncable
func (_m *GroupStore) UpdateGroupSyncable(groupSyncable *model.GroupSyncable) (*model.GroupSyncable, error) {
	ret := _m.Called(groupSyncable)

	if len(ret) == 0 {
		panic("no return value specified for UpdateGroupSyncable")
	}

	var r0 *model.GroupSyncable
	var r1 error
	if rf, ok := ret.Get(0).(func(*model.GroupSyncable) (*model.GroupSyncable, error)); ok {
		return rf(groupSyncable)
	}
	if rf, ok := ret.Get(0).(func(*model.GroupSyncable) *model.GroupSyncable); ok {
		r0 = rf(groupSyncable)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.GroupSyncable)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.GroupSyncable) error); ok {
		r1 = rf(groupSyncable)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpsertMember provides a mock function with given fields: groupID, userID
func (_m *GroupStore) UpsertMember(groupID string, userID string) (*model.GroupMember, error) {
	ret := _m.Called(groupID, userID)

	if len(ret) == 0 {
		panic("no return value specified for UpsertMember")
	}

	var r0 *model.GroupMember
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) (*model.GroupMember, error)); ok {
		return rf(groupID, userID)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.GroupMember); ok {
		r0 = rf(groupID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.GroupMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(groupID, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpsertMembers provides a mock function with given fields: groupID, userIDs
func (_m *GroupStore) UpsertMembers(groupID string, userIDs []string) ([]*model.GroupMember, error) {
	ret := _m.Called(groupID, userIDs)

	if len(ret) == 0 {
		panic("no return value specified for UpsertMembers")
	}

	var r0 []*model.GroupMember
	var r1 error
	if rf, ok := ret.Get(0).(func(string, []string) ([]*model.GroupMember, error)); ok {
		return rf(groupID, userIDs)
	}
	if rf, ok := ret.Get(0).(func(string, []string) []*model.GroupMember); ok {
		r0 = rf(groupID, userIDs)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.GroupMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []string) error); ok {
		r1 = rf(groupID, userIDs)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// NewGroupStore creates a new instance of GroupStore. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewGroupStore(t interface {
	mock.TestingT
	Cleanup(func())
}) *GroupStore {
	mock := &GroupStore{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
