// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated from the elasticsearch-specification DO NOT EDIT.
// https://github.com/elastic/elasticsearch-specification/tree/470b4b9aaaa25cae633ec690e54b725c6fc939c7

package types

import (
	"bytes"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"strconv"
)

// InferenceTopClassEntry type.
//
// https://github.com/elastic/elasticsearch-specification/blob/470b4b9aaaa25cae633ec690e54b725c6fc939c7/specification/_types/aggregations/Aggregate.ts#L774-L778
type InferenceTopClassEntry struct {
	ClassName        FieldValue `json:"class_name"`
	ClassProbability Float64    `json:"class_probability"`
	ClassScore       Float64    `json:"class_score"`
}

func (s *InferenceTopClassEntry) UnmarshalJSON(data []byte) error {

	dec := json.NewDecoder(bytes.NewReader(data))

	for {
		t, err := dec.Token()
		if err != nil {
			if errors.Is(err, io.EOF) {
				break
			}
			return err
		}

		switch t {

		case "class_name":
			if err := dec.Decode(&s.ClassName); err != nil {
				return fmt.Errorf("%s | %w", "ClassName", err)
			}

		case "class_probability":
			var tmp any
			dec.Decode(&tmp)
			switch v := tmp.(type) {
			case string:
				value, err := strconv.ParseFloat(v, 64)
				if err != nil {
					return fmt.Errorf("%s | %w", "ClassProbability", err)
				}
				f := Float64(value)
				s.ClassProbability = f
			case float64:
				f := Float64(v)
				s.ClassProbability = f
			}

		case "class_score":
			var tmp any
			dec.Decode(&tmp)
			switch v := tmp.(type) {
			case string:
				value, err := strconv.ParseFloat(v, 64)
				if err != nil {
					return fmt.Errorf("%s | %w", "ClassScore", err)
				}
				f := Float64(value)
				s.ClassScore = f
			case float64:
				f := Float64(v)
				s.ClassScore = f
			}

		}
	}
	return nil
}

// NewInferenceTopClassEntry returns a InferenceTopClassEntry.
func NewInferenceTopClassEntry() *InferenceTopClassEntry {
	r := &InferenceTopClassEntry{}

	return r
}
