// Code generated by mockery v2.53.4. DO NOT EDIT.

// Regenerate this file using `make store-mocks`.

package mocks

import (
	model "github.com/mattermost/mattermost/server/public/model"
	request "github.com/mattermost/mattermost/server/public/shared/request"
	mock "github.com/stretchr/testify/mock"

	store "github.com/mattermost/mattermost/server/v8/channels/store"
)

// ChannelStore is an autogenerated mock type for the ChannelStore type
type ChannelStore struct {
	mock.Mock
}

// AnalyticsCountAll provides a mock function with given fields: teamID
func (_m *ChannelStore) AnalyticsCountAll(teamID string) (map[model.ChannelType]int64, error) {
	ret := _m.Called(teamID)

	if len(ret) == 0 {
		panic("no return value specified for AnalyticsCountAll")
	}

	var r0 map[model.ChannelType]int64
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (map[model.ChannelType]int64, error)); ok {
		return rf(teamID)
	}
	if rf, ok := ret.Get(0).(func(string) map[model.ChannelType]int64); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[model.ChannelType]int64)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// AnalyticsDeletedTypeCount provides a mock function with given fields: teamID, channelType
func (_m *ChannelStore) AnalyticsDeletedTypeCount(teamID string, channelType model.ChannelType) (int64, error) {
	ret := _m.Called(teamID, channelType)

	if len(ret) == 0 {
		panic("no return value specified for AnalyticsDeletedTypeCount")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(string, model.ChannelType) (int64, error)); ok {
		return rf(teamID, channelType)
	}
	if rf, ok := ret.Get(0).(func(string, model.ChannelType) int64); ok {
		r0 = rf(teamID, channelType)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(string, model.ChannelType) error); ok {
		r1 = rf(teamID, channelType)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// AnalyticsTypeCount provides a mock function with given fields: teamID, channelType
func (_m *ChannelStore) AnalyticsTypeCount(teamID string, channelType model.ChannelType) (int64, error) {
	ret := _m.Called(teamID, channelType)

	if len(ret) == 0 {
		panic("no return value specified for AnalyticsTypeCount")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(string, model.ChannelType) (int64, error)); ok {
		return rf(teamID, channelType)
	}
	if rf, ok := ret.Get(0).(func(string, model.ChannelType) int64); ok {
		r0 = rf(teamID, channelType)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(string, model.ChannelType) error); ok {
		r1 = rf(teamID, channelType)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Autocomplete provides a mock function with given fields: rctx, userID, term, includeDeleted, isGuest
func (_m *ChannelStore) Autocomplete(rctx request.CTX, userID string, term string, includeDeleted bool, isGuest bool) (model.ChannelListWithTeamData, error) {
	ret := _m.Called(rctx, userID, term, includeDeleted, isGuest)

	if len(ret) == 0 {
		panic("no return value specified for Autocomplete")
	}

	var r0 model.ChannelListWithTeamData
	var r1 error
	if rf, ok := ret.Get(0).(func(request.CTX, string, string, bool, bool) (model.ChannelListWithTeamData, error)); ok {
		return rf(rctx, userID, term, includeDeleted, isGuest)
	}
	if rf, ok := ret.Get(0).(func(request.CTX, string, string, bool, bool) model.ChannelListWithTeamData); ok {
		r0 = rf(rctx, userID, term, includeDeleted, isGuest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelListWithTeamData)
		}
	}

	if rf, ok := ret.Get(1).(func(request.CTX, string, string, bool, bool) error); ok {
		r1 = rf(rctx, userID, term, includeDeleted, isGuest)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// AutocompleteInTeam provides a mock function with given fields: rctx, teamID, userID, term, includeDeleted, isGuest
func (_m *ChannelStore) AutocompleteInTeam(rctx request.CTX, teamID string, userID string, term string, includeDeleted bool, isGuest bool) (model.ChannelList, error) {
	ret := _m.Called(rctx, teamID, userID, term, includeDeleted, isGuest)

	if len(ret) == 0 {
		panic("no return value specified for AutocompleteInTeam")
	}

	var r0 model.ChannelList
	var r1 error
	if rf, ok := ret.Get(0).(func(request.CTX, string, string, string, bool, bool) (model.ChannelList, error)); ok {
		return rf(rctx, teamID, userID, term, includeDeleted, isGuest)
	}
	if rf, ok := ret.Get(0).(func(request.CTX, string, string, string, bool, bool) model.ChannelList); ok {
		r0 = rf(rctx, teamID, userID, term, includeDeleted, isGuest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	if rf, ok := ret.Get(1).(func(request.CTX, string, string, string, bool, bool) error); ok {
		r1 = rf(rctx, teamID, userID, term, includeDeleted, isGuest)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// AutocompleteInTeamForSearch provides a mock function with given fields: teamID, userID, term, includeDeleted
func (_m *ChannelStore) AutocompleteInTeamForSearch(teamID string, userID string, term string, includeDeleted bool) (model.ChannelList, error) {
	ret := _m.Called(teamID, userID, term, includeDeleted)

	if len(ret) == 0 {
		panic("no return value specified for AutocompleteInTeamForSearch")
	}

	var r0 model.ChannelList
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string, string, bool) (model.ChannelList, error)); ok {
		return rf(teamID, userID, term, includeDeleted)
	}
	if rf, ok := ret.Get(0).(func(string, string, string, bool) model.ChannelList); ok {
		r0 = rf(teamID, userID, term, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, string, bool) error); ok {
		r1 = rf(teamID, userID, term, includeDeleted)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ClearAllCustomRoleAssignments provides a mock function with no fields
func (_m *ChannelStore) ClearAllCustomRoleAssignments() error {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for ClearAllCustomRoleAssignments")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func() error); ok {
		r0 = rf()
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ClearCaches provides a mock function with no fields
func (_m *ChannelStore) ClearCaches() {
	_m.Called()
}

// ClearMembersForUserCache provides a mock function with no fields
func (_m *ChannelStore) ClearMembersForUserCache() {
	_m.Called()
}

// ClearSidebarOnTeamLeave provides a mock function with given fields: userID, teamID
func (_m *ChannelStore) ClearSidebarOnTeamLeave(userID string, teamID string) error {
	ret := _m.Called(userID, teamID)

	if len(ret) == 0 {
		panic("no return value specified for ClearSidebarOnTeamLeave")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string) error); ok {
		r0 = rf(userID, teamID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// CountPostsAfter provides a mock function with given fields: channelID, timestamp, excludedUserID
func (_m *ChannelStore) CountPostsAfter(channelID string, timestamp int64, excludedUserID string) (int, int, error) {
	ret := _m.Called(channelID, timestamp, excludedUserID)

	if len(ret) == 0 {
		panic("no return value specified for CountPostsAfter")
	}

	var r0 int
	var r1 int
	var r2 error
	if rf, ok := ret.Get(0).(func(string, int64, string) (int, int, error)); ok {
		return rf(channelID, timestamp, excludedUserID)
	}
	if rf, ok := ret.Get(0).(func(string, int64, string) int); ok {
		r0 = rf(channelID, timestamp, excludedUserID)
	} else {
		r0 = ret.Get(0).(int)
	}

	if rf, ok := ret.Get(1).(func(string, int64, string) int); ok {
		r1 = rf(channelID, timestamp, excludedUserID)
	} else {
		r1 = ret.Get(1).(int)
	}

	if rf, ok := ret.Get(2).(func(string, int64, string) error); ok {
		r2 = rf(channelID, timestamp, excludedUserID)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// CountUrgentPostsAfter provides a mock function with given fields: channelID, timestamp, excludedUserID
func (_m *ChannelStore) CountUrgentPostsAfter(channelID string, timestamp int64, excludedUserID string) (int, error) {
	ret := _m.Called(channelID, timestamp, excludedUserID)

	if len(ret) == 0 {
		panic("no return value specified for CountUrgentPostsAfter")
	}

	var r0 int
	var r1 error
	if rf, ok := ret.Get(0).(func(string, int64, string) (int, error)); ok {
		return rf(channelID, timestamp, excludedUserID)
	}
	if rf, ok := ret.Get(0).(func(string, int64, string) int); ok {
		r0 = rf(channelID, timestamp, excludedUserID)
	} else {
		r0 = ret.Get(0).(int)
	}

	if rf, ok := ret.Get(1).(func(string, int64, string) error); ok {
		r1 = rf(channelID, timestamp, excludedUserID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateDirectChannel provides a mock function with given fields: rctx, userID, otherUserID, channelOptions
func (_m *ChannelStore) CreateDirectChannel(rctx request.CTX, userID *model.User, otherUserID *model.User, channelOptions ...model.ChannelOption) (*model.Channel, error) {
	_va := make([]interface{}, len(channelOptions))
	for _i := range channelOptions {
		_va[_i] = channelOptions[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, rctx, userID, otherUserID)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	if len(ret) == 0 {
		panic("no return value specified for CreateDirectChannel")
	}

	var r0 *model.Channel
	var r1 error
	if rf, ok := ret.Get(0).(func(request.CTX, *model.User, *model.User, ...model.ChannelOption) (*model.Channel, error)); ok {
		return rf(rctx, userID, otherUserID, channelOptions...)
	}
	if rf, ok := ret.Get(0).(func(request.CTX, *model.User, *model.User, ...model.ChannelOption) *model.Channel); ok {
		r0 = rf(rctx, userID, otherUserID, channelOptions...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(request.CTX, *model.User, *model.User, ...model.ChannelOption) error); ok {
		r1 = rf(rctx, userID, otherUserID, channelOptions...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateInitialSidebarCategories provides a mock function with given fields: rctx, userID, teamID
func (_m *ChannelStore) CreateInitialSidebarCategories(rctx request.CTX, userID string, teamID string) (*model.OrderedSidebarCategories, error) {
	ret := _m.Called(rctx, userID, teamID)

	if len(ret) == 0 {
		panic("no return value specified for CreateInitialSidebarCategories")
	}

	var r0 *model.OrderedSidebarCategories
	var r1 error
	if rf, ok := ret.Get(0).(func(request.CTX, string, string) (*model.OrderedSidebarCategories, error)); ok {
		return rf(rctx, userID, teamID)
	}
	if rf, ok := ret.Get(0).(func(request.CTX, string, string) *model.OrderedSidebarCategories); ok {
		r0 = rf(rctx, userID, teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.OrderedSidebarCategories)
		}
	}

	if rf, ok := ret.Get(1).(func(request.CTX, string, string) error); ok {
		r1 = rf(rctx, userID, teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateSidebarCategory provides a mock function with given fields: userID, teamID, newCategory
func (_m *ChannelStore) CreateSidebarCategory(userID string, teamID string, newCategory *model.SidebarCategoryWithChannels) (*model.SidebarCategoryWithChannels, error) {
	ret := _m.Called(userID, teamID, newCategory)

	if len(ret) == 0 {
		panic("no return value specified for CreateSidebarCategory")
	}

	var r0 *model.SidebarCategoryWithChannels
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string, *model.SidebarCategoryWithChannels) (*model.SidebarCategoryWithChannels, error)); ok {
		return rf(userID, teamID, newCategory)
	}
	if rf, ok := ret.Get(0).(func(string, string, *model.SidebarCategoryWithChannels) *model.SidebarCategoryWithChannels); ok {
		r0 = rf(userID, teamID, newCategory)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.SidebarCategoryWithChannels)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, *model.SidebarCategoryWithChannels) error); ok {
		r1 = rf(userID, teamID, newCategory)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Delete provides a mock function with given fields: channelID, timestamp
func (_m *ChannelStore) Delete(channelID string, timestamp int64) error {
	ret := _m.Called(channelID, timestamp)

	if len(ret) == 0 {
		panic("no return value specified for Delete")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64) error); ok {
		r0 = rf(channelID, timestamp)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteAllSidebarChannelForChannel provides a mock function with given fields: channelID
func (_m *ChannelStore) DeleteAllSidebarChannelForChannel(channelID string) error {
	ret := _m.Called(channelID)

	if len(ret) == 0 {
		panic("no return value specified for DeleteAllSidebarChannelForChannel")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(channelID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteSidebarCategory provides a mock function with given fields: categoryID
func (_m *ChannelStore) DeleteSidebarCategory(categoryID string) error {
	ret := _m.Called(categoryID)

	if len(ret) == 0 {
		panic("no return value specified for DeleteSidebarCategory")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(categoryID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteSidebarChannelsByPreferences provides a mock function with given fields: preferences
func (_m *ChannelStore) DeleteSidebarChannelsByPreferences(preferences model.Preferences) error {
	ret := _m.Called(preferences)

	if len(ret) == 0 {
		panic("no return value specified for DeleteSidebarChannelsByPreferences")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(model.Preferences) error); ok {
		r0 = rf(preferences)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Get provides a mock function with given fields: id, allowFromCache
func (_m *ChannelStore) Get(id string, allowFromCache bool) (*model.Channel, error) {
	ret := _m.Called(id, allowFromCache)

	if len(ret) == 0 {
		panic("no return value specified for Get")
	}

	var r0 *model.Channel
	var r1 error
	if rf, ok := ret.Get(0).(func(string, bool) (*model.Channel, error)); ok {
		return rf(id, allowFromCache)
	}
	if rf, ok := ret.Get(0).(func(string, bool) *model.Channel); ok {
		r0 = rf(id, allowFromCache)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(string, bool) error); ok {
		r1 = rf(id, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAll provides a mock function with given fields: teamID
func (_m *ChannelStore) GetAll(teamID string) ([]*model.Channel, error) {
	ret := _m.Called(teamID)

	if len(ret) == 0 {
		panic("no return value specified for GetAll")
	}

	var r0 []*model.Channel
	var r1 error
	if rf, ok := ret.Get(0).(func(string) ([]*model.Channel, error)); ok {
		return rf(teamID)
	}
	if rf, ok := ret.Get(0).(func(string) []*model.Channel); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAllChannelMemberIdsByChannelId provides a mock function with given fields: id
func (_m *ChannelStore) GetAllChannelMemberIdsByChannelId(id string) ([]string, error) {
	ret := _m.Called(id)

	if len(ret) == 0 {
		panic("no return value specified for GetAllChannelMemberIdsByChannelId")
	}

	var r0 []string
	var r1 error
	if rf, ok := ret.Get(0).(func(string) ([]string, error)); ok {
		return rf(id)
	}
	if rf, ok := ret.Get(0).(func(string) []string); ok {
		r0 = rf(id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(id)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAllChannelMembersForUser provides a mock function with given fields: rctx, userID, allowFromCache, includeDeleted
func (_m *ChannelStore) GetAllChannelMembersForUser(rctx request.CTX, userID string, allowFromCache bool, includeDeleted bool) (map[string]string, error) {
	ret := _m.Called(rctx, userID, allowFromCache, includeDeleted)

	if len(ret) == 0 {
		panic("no return value specified for GetAllChannelMembersForUser")
	}

	var r0 map[string]string
	var r1 error
	if rf, ok := ret.Get(0).(func(request.CTX, string, bool, bool) (map[string]string, error)); ok {
		return rf(rctx, userID, allowFromCache, includeDeleted)
	}
	if rf, ok := ret.Get(0).(func(request.CTX, string, bool, bool) map[string]string); ok {
		r0 = rf(rctx, userID, allowFromCache, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]string)
		}
	}

	if rf, ok := ret.Get(1).(func(request.CTX, string, bool, bool) error); ok {
		r1 = rf(rctx, userID, allowFromCache, includeDeleted)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAllChannelMembersNotifyPropsForChannel provides a mock function with given fields: channelID, allowFromCache
func (_m *ChannelStore) GetAllChannelMembersNotifyPropsForChannel(channelID string, allowFromCache bool) (map[string]model.StringMap, error) {
	ret := _m.Called(channelID, allowFromCache)

	if len(ret) == 0 {
		panic("no return value specified for GetAllChannelMembersNotifyPropsForChannel")
	}

	var r0 map[string]model.StringMap
	var r1 error
	if rf, ok := ret.Get(0).(func(string, bool) (map[string]model.StringMap, error)); ok {
		return rf(channelID, allowFromCache)
	}
	if rf, ok := ret.Get(0).(func(string, bool) map[string]model.StringMap); ok {
		r0 = rf(channelID, allowFromCache)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]model.StringMap)
		}
	}

	if rf, ok := ret.Get(1).(func(string, bool) error); ok {
		r1 = rf(channelID, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAllChannels provides a mock function with given fields: page, perPage, opts
func (_m *ChannelStore) GetAllChannels(page int, perPage int, opts store.ChannelSearchOpts) (model.ChannelListWithTeamData, error) {
	ret := _m.Called(page, perPage, opts)

	if len(ret) == 0 {
		panic("no return value specified for GetAllChannels")
	}

	var r0 model.ChannelListWithTeamData
	var r1 error
	if rf, ok := ret.Get(0).(func(int, int, store.ChannelSearchOpts) (model.ChannelListWithTeamData, error)); ok {
		return rf(page, perPage, opts)
	}
	if rf, ok := ret.Get(0).(func(int, int, store.ChannelSearchOpts) model.ChannelListWithTeamData); ok {
		r0 = rf(page, perPage, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelListWithTeamData)
		}
	}

	if rf, ok := ret.Get(1).(func(int, int, store.ChannelSearchOpts) error); ok {
		r1 = rf(page, perPage, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAllChannelsCount provides a mock function with given fields: opts
func (_m *ChannelStore) GetAllChannelsCount(opts store.ChannelSearchOpts) (int64, error) {
	ret := _m.Called(opts)

	if len(ret) == 0 {
		panic("no return value specified for GetAllChannelsCount")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(store.ChannelSearchOpts) (int64, error)); ok {
		return rf(opts)
	}
	if rf, ok := ret.Get(0).(func(store.ChannelSearchOpts) int64); ok {
		r0 = rf(opts)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(store.ChannelSearchOpts) error); ok {
		r1 = rf(opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAllChannelsForExportAfter provides a mock function with given fields: limit, afterID
func (_m *ChannelStore) GetAllChannelsForExportAfter(limit int, afterID string) ([]*model.ChannelForExport, error) {
	ret := _m.Called(limit, afterID)

	if len(ret) == 0 {
		panic("no return value specified for GetAllChannelsForExportAfter")
	}

	var r0 []*model.ChannelForExport
	var r1 error
	if rf, ok := ret.Get(0).(func(int, string) ([]*model.ChannelForExport, error)); ok {
		return rf(limit, afterID)
	}
	if rf, ok := ret.Get(0).(func(int, string) []*model.ChannelForExport); ok {
		r0 = rf(limit, afterID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.ChannelForExport)
		}
	}

	if rf, ok := ret.Get(1).(func(int, string) error); ok {
		r1 = rf(limit, afterID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAllDirectChannelsForExportAfter provides a mock function with given fields: limit, afterID, includeArchivedChannels
func (_m *ChannelStore) GetAllDirectChannelsForExportAfter(limit int, afterID string, includeArchivedChannels bool) ([]*model.DirectChannelForExport, error) {
	ret := _m.Called(limit, afterID, includeArchivedChannels)

	if len(ret) == 0 {
		panic("no return value specified for GetAllDirectChannelsForExportAfter")
	}

	var r0 []*model.DirectChannelForExport
	var r1 error
	if rf, ok := ret.Get(0).(func(int, string, bool) ([]*model.DirectChannelForExport, error)); ok {
		return rf(limit, afterID, includeArchivedChannels)
	}
	if rf, ok := ret.Get(0).(func(int, string, bool) []*model.DirectChannelForExport); ok {
		r0 = rf(limit, afterID, includeArchivedChannels)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.DirectChannelForExport)
		}
	}

	if rf, ok := ret.Get(1).(func(int, string, bool) error); ok {
		r1 = rf(limit, afterID, includeArchivedChannels)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetByName provides a mock function with given fields: teamID, name, allowFromCache
func (_m *ChannelStore) GetByName(teamID string, name string, allowFromCache bool) (*model.Channel, error) {
	ret := _m.Called(teamID, name, allowFromCache)

	if len(ret) == 0 {
		panic("no return value specified for GetByName")
	}

	var r0 *model.Channel
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string, bool) (*model.Channel, error)); ok {
		return rf(teamID, name, allowFromCache)
	}
	if rf, ok := ret.Get(0).(func(string, string, bool) *model.Channel); ok {
		r0 = rf(teamID, name, allowFromCache)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, bool) error); ok {
		r1 = rf(teamID, name, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetByNameIncludeDeleted provides a mock function with given fields: teamID, name, allowFromCache
func (_m *ChannelStore) GetByNameIncludeDeleted(teamID string, name string, allowFromCache bool) (*model.Channel, error) {
	ret := _m.Called(teamID, name, allowFromCache)

	if len(ret) == 0 {
		panic("no return value specified for GetByNameIncludeDeleted")
	}

	var r0 *model.Channel
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string, bool) (*model.Channel, error)); ok {
		return rf(teamID, name, allowFromCache)
	}
	if rf, ok := ret.Get(0).(func(string, string, bool) *model.Channel); ok {
		r0 = rf(teamID, name, allowFromCache)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, bool) error); ok {
		r1 = rf(teamID, name, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetByNames provides a mock function with given fields: teamID, names, allowFromCache
func (_m *ChannelStore) GetByNames(teamID string, names []string, allowFromCache bool) ([]*model.Channel, error) {
	ret := _m.Called(teamID, names, allowFromCache)

	if len(ret) == 0 {
		panic("no return value specified for GetByNames")
	}

	var r0 []*model.Channel
	var r1 error
	if rf, ok := ret.Get(0).(func(string, []string, bool) ([]*model.Channel, error)); ok {
		return rf(teamID, names, allowFromCache)
	}
	if rf, ok := ret.Get(0).(func(string, []string, bool) []*model.Channel); ok {
		r0 = rf(teamID, names, allowFromCache)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []string, bool) error); ok {
		r1 = rf(teamID, names, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetByNamesIncludeDeleted provides a mock function with given fields: teamID, names, allowFromCache
func (_m *ChannelStore) GetByNamesIncludeDeleted(teamID string, names []string, allowFromCache bool) ([]*model.Channel, error) {
	ret := _m.Called(teamID, names, allowFromCache)

	if len(ret) == 0 {
		panic("no return value specified for GetByNamesIncludeDeleted")
	}

	var r0 []*model.Channel
	var r1 error
	if rf, ok := ret.Get(0).(func(string, []string, bool) ([]*model.Channel, error)); ok {
		return rf(teamID, names, allowFromCache)
	}
	if rf, ok := ret.Get(0).(func(string, []string, bool) []*model.Channel); ok {
		r0 = rf(teamID, names, allowFromCache)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []string, bool) error); ok {
		r1 = rf(teamID, names, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelCounts provides a mock function with given fields: teamID, userID
func (_m *ChannelStore) GetChannelCounts(teamID string, userID string) (*model.ChannelCounts, error) {
	ret := _m.Called(teamID, userID)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelCounts")
	}

	var r0 *model.ChannelCounts
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) (*model.ChannelCounts, error)); ok {
		return rf(teamID, userID)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.ChannelCounts); ok {
		r0 = rf(teamID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelCounts)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(teamID, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelMembersForExport provides a mock function with given fields: userID, teamID, includeArchivedChannel
func (_m *ChannelStore) GetChannelMembersForExport(userID string, teamID string, includeArchivedChannel bool) ([]*model.ChannelMemberForExport, error) {
	ret := _m.Called(userID, teamID, includeArchivedChannel)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelMembersForExport")
	}

	var r0 []*model.ChannelMemberForExport
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string, bool) ([]*model.ChannelMemberForExport, error)); ok {
		return rf(userID, teamID, includeArchivedChannel)
	}
	if rf, ok := ret.Get(0).(func(string, string, bool) []*model.ChannelMemberForExport); ok {
		r0 = rf(userID, teamID, includeArchivedChannel)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.ChannelMemberForExport)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, bool) error); ok {
		r1 = rf(userID, teamID, includeArchivedChannel)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelMembersTimezones provides a mock function with given fields: channelID
func (_m *ChannelStore) GetChannelMembersTimezones(channelID string) ([]model.StringMap, error) {
	ret := _m.Called(channelID)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelMembersTimezones")
	}

	var r0 []model.StringMap
	var r1 error
	if rf, ok := ret.Get(0).(func(string) ([]model.StringMap, error)); ok {
		return rf(channelID)
	}
	if rf, ok := ret.Get(0).(func(string) []model.StringMap); ok {
		r0 = rf(channelID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]model.StringMap)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelUnread provides a mock function with given fields: channelID, userID
func (_m *ChannelStore) GetChannelUnread(channelID string, userID string) (*model.ChannelUnread, error) {
	ret := _m.Called(channelID, userID)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelUnread")
	}

	var r0 *model.ChannelUnread
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) (*model.ChannelUnread, error)); ok {
		return rf(channelID, userID)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.ChannelUnread); ok {
		r0 = rf(channelID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelUnread)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(channelID, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannels provides a mock function with given fields: teamID, userID, opts
func (_m *ChannelStore) GetChannels(teamID string, userID string, opts *model.ChannelSearchOpts) (model.ChannelList, error) {
	ret := _m.Called(teamID, userID, opts)

	if len(ret) == 0 {
		panic("no return value specified for GetChannels")
	}

	var r0 model.ChannelList
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string, *model.ChannelSearchOpts) (model.ChannelList, error)); ok {
		return rf(teamID, userID, opts)
	}
	if rf, ok := ret.Get(0).(func(string, string, *model.ChannelSearchOpts) model.ChannelList); ok {
		r0 = rf(teamID, userID, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, *model.ChannelSearchOpts) error); ok {
		r1 = rf(teamID, userID, opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelsBatchForIndexing provides a mock function with given fields: startTime, startChannelID, limit
func (_m *ChannelStore) GetChannelsBatchForIndexing(startTime int64, startChannelID string, limit int) ([]*model.Channel, error) {
	ret := _m.Called(startTime, startChannelID, limit)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelsBatchForIndexing")
	}

	var r0 []*model.Channel
	var r1 error
	if rf, ok := ret.Get(0).(func(int64, string, int) ([]*model.Channel, error)); ok {
		return rf(startTime, startChannelID, limit)
	}
	if rf, ok := ret.Get(0).(func(int64, string, int) []*model.Channel); ok {
		r0 = rf(startTime, startChannelID, limit)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(int64, string, int) error); ok {
		r1 = rf(startTime, startChannelID, limit)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelsByIds provides a mock function with given fields: channelIds, includeDeleted
func (_m *ChannelStore) GetChannelsByIds(channelIds []string, includeDeleted bool) ([]*model.Channel, error) {
	ret := _m.Called(channelIds, includeDeleted)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelsByIds")
	}

	var r0 []*model.Channel
	var r1 error
	if rf, ok := ret.Get(0).(func([]string, bool) ([]*model.Channel, error)); ok {
		return rf(channelIds, includeDeleted)
	}
	if rf, ok := ret.Get(0).(func([]string, bool) []*model.Channel); ok {
		r0 = rf(channelIds, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func([]string, bool) error); ok {
		r1 = rf(channelIds, includeDeleted)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelsByScheme provides a mock function with given fields: schemeID, offset, limit
func (_m *ChannelStore) GetChannelsByScheme(schemeID string, offset int, limit int) (model.ChannelList, error) {
	ret := _m.Called(schemeID, offset, limit)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelsByScheme")
	}

	var r0 model.ChannelList
	var r1 error
	if rf, ok := ret.Get(0).(func(string, int, int) (model.ChannelList, error)); ok {
		return rf(schemeID, offset, limit)
	}
	if rf, ok := ret.Get(0).(func(string, int, int) model.ChannelList); ok {
		r0 = rf(schemeID, offset, limit)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int, int) error); ok {
		r1 = rf(schemeID, offset, limit)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelsByUser provides a mock function with given fields: userID, includeDeleted, lastDeleteAt, pageSize, fromChannelID
func (_m *ChannelStore) GetChannelsByUser(userID string, includeDeleted bool, lastDeleteAt int, pageSize int, fromChannelID string) (model.ChannelList, error) {
	ret := _m.Called(userID, includeDeleted, lastDeleteAt, pageSize, fromChannelID)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelsByUser")
	}

	var r0 model.ChannelList
	var r1 error
	if rf, ok := ret.Get(0).(func(string, bool, int, int, string) (model.ChannelList, error)); ok {
		return rf(userID, includeDeleted, lastDeleteAt, pageSize, fromChannelID)
	}
	if rf, ok := ret.Get(0).(func(string, bool, int, int, string) model.ChannelList); ok {
		r0 = rf(userID, includeDeleted, lastDeleteAt, pageSize, fromChannelID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, bool, int, int, string) error); ok {
		r1 = rf(userID, includeDeleted, lastDeleteAt, pageSize, fromChannelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelsMemberCount provides a mock function with given fields: channelIDs
func (_m *ChannelStore) GetChannelsMemberCount(channelIDs []string) (map[string]int64, error) {
	ret := _m.Called(channelIDs)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelsMemberCount")
	}

	var r0 map[string]int64
	var r1 error
	if rf, ok := ret.Get(0).(func([]string) (map[string]int64, error)); ok {
		return rf(channelIDs)
	}
	if rf, ok := ret.Get(0).(func([]string) map[string]int64); ok {
		r0 = rf(channelIDs)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]int64)
		}
	}

	if rf, ok := ret.Get(1).(func([]string) error); ok {
		r1 = rf(channelIDs)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelsWithTeamDataByIds provides a mock function with given fields: channelIds, includeDeleted
func (_m *ChannelStore) GetChannelsWithTeamDataByIds(channelIds []string, includeDeleted bool) ([]*model.ChannelWithTeamData, error) {
	ret := _m.Called(channelIds, includeDeleted)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelsWithTeamDataByIds")
	}

	var r0 []*model.ChannelWithTeamData
	var r1 error
	if rf, ok := ret.Get(0).(func([]string, bool) ([]*model.ChannelWithTeamData, error)); ok {
		return rf(channelIds, includeDeleted)
	}
	if rf, ok := ret.Get(0).(func([]string, bool) []*model.ChannelWithTeamData); ok {
		r0 = rf(channelIds, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.ChannelWithTeamData)
		}
	}

	if rf, ok := ret.Get(1).(func([]string, bool) error); ok {
		r1 = rf(channelIds, includeDeleted)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelsWithUnreadsAndWithMentions provides a mock function with given fields: rctx, channelIDs, userID, userNotifyProps
func (_m *ChannelStore) GetChannelsWithUnreadsAndWithMentions(rctx request.CTX, channelIDs []string, userID string, userNotifyProps model.StringMap) ([]string, []string, map[string]int64, error) {
	ret := _m.Called(rctx, channelIDs, userID, userNotifyProps)

	if len(ret) == 0 {
		panic("no return value specified for GetChannelsWithUnreadsAndWithMentions")
	}

	var r0 []string
	var r1 []string
	var r2 map[string]int64
	var r3 error
	if rf, ok := ret.Get(0).(func(request.CTX, []string, string, model.StringMap) ([]string, []string, map[string]int64, error)); ok {
		return rf(rctx, channelIDs, userID, userNotifyProps)
	}
	if rf, ok := ret.Get(0).(func(request.CTX, []string, string, model.StringMap) []string); ok {
		r0 = rf(rctx, channelIDs, userID, userNotifyProps)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	if rf, ok := ret.Get(1).(func(request.CTX, []string, string, model.StringMap) []string); ok {
		r1 = rf(rctx, channelIDs, userID, userNotifyProps)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).([]string)
		}
	}

	if rf, ok := ret.Get(2).(func(request.CTX, []string, string, model.StringMap) map[string]int64); ok {
		r2 = rf(rctx, channelIDs, userID, userNotifyProps)
	} else {
		if ret.Get(2) != nil {
			r2 = ret.Get(2).(map[string]int64)
		}
	}

	if rf, ok := ret.Get(3).(func(request.CTX, []string, string, model.StringMap) error); ok {
		r3 = rf(rctx, channelIDs, userID, userNotifyProps)
	} else {
		r3 = ret.Error(3)
	}

	return r0, r1, r2, r3
}

// GetDeleted provides a mock function with given fields: teamID, offset, limit, userID, skipTeamMembershipCheck
func (_m *ChannelStore) GetDeleted(teamID string, offset int, limit int, userID string, skipTeamMembershipCheck bool) (model.ChannelList, error) {
	ret := _m.Called(teamID, offset, limit, userID, skipTeamMembershipCheck)

	if len(ret) == 0 {
		panic("no return value specified for GetDeleted")
	}

	var r0 model.ChannelList
	var r1 error
	if rf, ok := ret.Get(0).(func(string, int, int, string, bool) (model.ChannelList, error)); ok {
		return rf(teamID, offset, limit, userID, skipTeamMembershipCheck)
	}
	if rf, ok := ret.Get(0).(func(string, int, int, string, bool) model.ChannelList); ok {
		r0 = rf(teamID, offset, limit, userID, skipTeamMembershipCheck)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int, int, string, bool) error); ok {
		r1 = rf(teamID, offset, limit, userID, skipTeamMembershipCheck)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetDeletedByName provides a mock function with given fields: teamID, name
func (_m *ChannelStore) GetDeletedByName(teamID string, name string) (*model.Channel, error) {
	ret := _m.Called(teamID, name)

	if len(ret) == 0 {
		panic("no return value specified for GetDeletedByName")
	}

	var r0 *model.Channel
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) (*model.Channel, error)); ok {
		return rf(teamID, name)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.Channel); ok {
		r0 = rf(teamID, name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(teamID, name)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetFileCount provides a mock function with given fields: channelID
func (_m *ChannelStore) GetFileCount(channelID string) (int64, error) {
	ret := _m.Called(channelID)

	if len(ret) == 0 {
		panic("no return value specified for GetFileCount")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (int64, error)); ok {
		return rf(channelID)
	}
	if rf, ok := ret.Get(0).(func(string) int64); ok {
		r0 = rf(channelID)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetForPost provides a mock function with given fields: postID
func (_m *ChannelStore) GetForPost(postID string) (*model.Channel, error) {
	ret := _m.Called(postID)

	if len(ret) == 0 {
		panic("no return value specified for GetForPost")
	}

	var r0 *model.Channel
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (*model.Channel, error)); ok {
		return rf(postID)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Channel); ok {
		r0 = rf(postID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(postID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetGuestCount provides a mock function with given fields: channelID, allowFromCache
func (_m *ChannelStore) GetGuestCount(channelID string, allowFromCache bool) (int64, error) {
	ret := _m.Called(channelID, allowFromCache)

	if len(ret) == 0 {
		panic("no return value specified for GetGuestCount")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(string, bool) (int64, error)); ok {
		return rf(channelID, allowFromCache)
	}
	if rf, ok := ret.Get(0).(func(string, bool) int64); ok {
		r0 = rf(channelID, allowFromCache)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(string, bool) error); ok {
		r1 = rf(channelID, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMany provides a mock function with given fields: ids, allowFromCache
func (_m *ChannelStore) GetMany(ids []string, allowFromCache bool) (model.ChannelList, error) {
	ret := _m.Called(ids, allowFromCache)

	if len(ret) == 0 {
		panic("no return value specified for GetMany")
	}

	var r0 model.ChannelList
	var r1 error
	if rf, ok := ret.Get(0).(func([]string, bool) (model.ChannelList, error)); ok {
		return rf(ids, allowFromCache)
	}
	if rf, ok := ret.Get(0).(func([]string, bool) model.ChannelList); ok {
		r0 = rf(ids, allowFromCache)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	if rf, ok := ret.Get(1).(func([]string, bool) error); ok {
		r1 = rf(ids, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMember provides a mock function with given fields: rctx, channelID, userID
func (_m *ChannelStore) GetMember(rctx request.CTX, channelID string, userID string) (*model.ChannelMember, error) {
	ret := _m.Called(rctx, channelID, userID)

	if len(ret) == 0 {
		panic("no return value specified for GetMember")
	}

	var r0 *model.ChannelMember
	var r1 error
	if rf, ok := ret.Get(0).(func(request.CTX, string, string) (*model.ChannelMember, error)); ok {
		return rf(rctx, channelID, userID)
	}
	if rf, ok := ret.Get(0).(func(request.CTX, string, string) *model.ChannelMember); ok {
		r0 = rf(rctx, channelID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	if rf, ok := ret.Get(1).(func(request.CTX, string, string) error); ok {
		r1 = rf(rctx, channelID, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMemberCount provides a mock function with given fields: channelID, allowFromCache
func (_m *ChannelStore) GetMemberCount(channelID string, allowFromCache bool) (int64, error) {
	ret := _m.Called(channelID, allowFromCache)

	if len(ret) == 0 {
		panic("no return value specified for GetMemberCount")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(string, bool) (int64, error)); ok {
		return rf(channelID, allowFromCache)
	}
	if rf, ok := ret.Get(0).(func(string, bool) int64); ok {
		r0 = rf(channelID, allowFromCache)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(string, bool) error); ok {
		r1 = rf(channelID, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMemberCountFromCache provides a mock function with given fields: channelID
func (_m *ChannelStore) GetMemberCountFromCache(channelID string) int64 {
	ret := _m.Called(channelID)

	if len(ret) == 0 {
		panic("no return value specified for GetMemberCountFromCache")
	}

	var r0 int64
	if rf, ok := ret.Get(0).(func(string) int64); ok {
		r0 = rf(channelID)
	} else {
		r0 = ret.Get(0).(int64)
	}

	return r0
}

// GetMemberCountsByGroup provides a mock function with given fields: rctx, channelID, includeTimezones
func (_m *ChannelStore) GetMemberCountsByGroup(rctx request.CTX, channelID string, includeTimezones bool) ([]*model.ChannelMemberCountByGroup, error) {
	ret := _m.Called(rctx, channelID, includeTimezones)

	if len(ret) == 0 {
		panic("no return value specified for GetMemberCountsByGroup")
	}

	var r0 []*model.ChannelMemberCountByGroup
	var r1 error
	if rf, ok := ret.Get(0).(func(request.CTX, string, bool) ([]*model.ChannelMemberCountByGroup, error)); ok {
		return rf(rctx, channelID, includeTimezones)
	}
	if rf, ok := ret.Get(0).(func(request.CTX, string, bool) []*model.ChannelMemberCountByGroup); ok {
		r0 = rf(rctx, channelID, includeTimezones)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.ChannelMemberCountByGroup)
		}
	}

	if rf, ok := ret.Get(1).(func(request.CTX, string, bool) error); ok {
		r1 = rf(rctx, channelID, includeTimezones)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMemberForPost provides a mock function with given fields: postID, userID
func (_m *ChannelStore) GetMemberForPost(postID string, userID string) (*model.ChannelMember, error) {
	ret := _m.Called(postID, userID)

	if len(ret) == 0 {
		panic("no return value specified for GetMemberForPost")
	}

	var r0 *model.ChannelMember
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) (*model.ChannelMember, error)); ok {
		return rf(postID, userID)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.ChannelMember); ok {
		r0 = rf(postID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(postID, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMemberLastViewedAt provides a mock function with given fields: rctx, channelID, userID
func (_m *ChannelStore) GetMemberLastViewedAt(rctx request.CTX, channelID string, userID string) (int64, error) {
	ret := _m.Called(rctx, channelID, userID)

	if len(ret) == 0 {
		panic("no return value specified for GetMemberLastViewedAt")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(request.CTX, string, string) (int64, error)); ok {
		return rf(rctx, channelID, userID)
	}
	if rf, ok := ret.Get(0).(func(request.CTX, string, string) int64); ok {
		r0 = rf(rctx, channelID, userID)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(request.CTX, string, string) error); ok {
		r1 = rf(rctx, channelID, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMembers provides a mock function with given fields: opts
func (_m *ChannelStore) GetMembers(opts model.ChannelMembersGetOptions) (model.ChannelMembers, error) {
	ret := _m.Called(opts)

	if len(ret) == 0 {
		panic("no return value specified for GetMembers")
	}

	var r0 model.ChannelMembers
	var r1 error
	if rf, ok := ret.Get(0).(func(model.ChannelMembersGetOptions) (model.ChannelMembers, error)); ok {
		return rf(opts)
	}
	if rf, ok := ret.Get(0).(func(model.ChannelMembersGetOptions) model.ChannelMembers); ok {
		r0 = rf(opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelMembers)
		}
	}

	if rf, ok := ret.Get(1).(func(model.ChannelMembersGetOptions) error); ok {
		r1 = rf(opts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMembersByChannelIds provides a mock function with given fields: channelIds, userID
func (_m *ChannelStore) GetMembersByChannelIds(channelIds []string, userID string) (model.ChannelMembers, error) {
	ret := _m.Called(channelIds, userID)

	if len(ret) == 0 {
		panic("no return value specified for GetMembersByChannelIds")
	}

	var r0 model.ChannelMembers
	var r1 error
	if rf, ok := ret.Get(0).(func([]string, string) (model.ChannelMembers, error)); ok {
		return rf(channelIds, userID)
	}
	if rf, ok := ret.Get(0).(func([]string, string) model.ChannelMembers); ok {
		r0 = rf(channelIds, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelMembers)
		}
	}

	if rf, ok := ret.Get(1).(func([]string, string) error); ok {
		r1 = rf(channelIds, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMembersByIds provides a mock function with given fields: channelID, userIds
func (_m *ChannelStore) GetMembersByIds(channelID string, userIds []string) (model.ChannelMembers, error) {
	ret := _m.Called(channelID, userIds)

	if len(ret) == 0 {
		panic("no return value specified for GetMembersByIds")
	}

	var r0 model.ChannelMembers
	var r1 error
	if rf, ok := ret.Get(0).(func(string, []string) (model.ChannelMembers, error)); ok {
		return rf(channelID, userIds)
	}
	if rf, ok := ret.Get(0).(func(string, []string) model.ChannelMembers); ok {
		r0 = rf(channelID, userIds)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelMembers)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []string) error); ok {
		r1 = rf(channelID, userIds)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMembersForUser provides a mock function with given fields: teamID, userID
func (_m *ChannelStore) GetMembersForUser(teamID string, userID string) (model.ChannelMembers, error) {
	ret := _m.Called(teamID, userID)

	if len(ret) == 0 {
		panic("no return value specified for GetMembersForUser")
	}

	var r0 model.ChannelMembers
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) (model.ChannelMembers, error)); ok {
		return rf(teamID, userID)
	}
	if rf, ok := ret.Get(0).(func(string, string) model.ChannelMembers); ok {
		r0 = rf(teamID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelMembers)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(teamID, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMembersForUserWithCursorPagination provides a mock function with given fields: userId, perPage, fromChanneID
func (_m *ChannelStore) GetMembersForUserWithCursorPagination(userId string, perPage int, fromChanneID string) (model.ChannelMembersWithTeamData, error) {
	ret := _m.Called(userId, perPage, fromChanneID)

	if len(ret) == 0 {
		panic("no return value specified for GetMembersForUserWithCursorPagination")
	}

	var r0 model.ChannelMembersWithTeamData
	var r1 error
	if rf, ok := ret.Get(0).(func(string, int, string) (model.ChannelMembersWithTeamData, error)); ok {
		return rf(userId, perPage, fromChanneID)
	}
	if rf, ok := ret.Get(0).(func(string, int, string) model.ChannelMembersWithTeamData); ok {
		r0 = rf(userId, perPage, fromChanneID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelMembersWithTeamData)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int, string) error); ok {
		r1 = rf(userId, perPage, fromChanneID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMembersForUserWithPagination provides a mock function with given fields: userID, page, perPage
func (_m *ChannelStore) GetMembersForUserWithPagination(userID string, page int, perPage int) (model.ChannelMembersWithTeamData, error) {
	ret := _m.Called(userID, page, perPage)

	if len(ret) == 0 {
		panic("no return value specified for GetMembersForUserWithPagination")
	}

	var r0 model.ChannelMembersWithTeamData
	var r1 error
	if rf, ok := ret.Get(0).(func(string, int, int) (model.ChannelMembersWithTeamData, error)); ok {
		return rf(userID, page, perPage)
	}
	if rf, ok := ret.Get(0).(func(string, int, int) model.ChannelMembersWithTeamData); ok {
		r0 = rf(userID, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelMembersWithTeamData)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int, int) error); ok {
		r1 = rf(userID, page, perPage)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMembersInfoByChannelIds provides a mock function with given fields: channelIDs
func (_m *ChannelStore) GetMembersInfoByChannelIds(channelIDs []string) (map[string][]*model.User, error) {
	ret := _m.Called(channelIDs)

	if len(ret) == 0 {
		panic("no return value specified for GetMembersInfoByChannelIds")
	}

	var r0 map[string][]*model.User
	var r1 error
	if rf, ok := ret.Get(0).(func([]string) (map[string][]*model.User, error)); ok {
		return rf(channelIDs)
	}
	if rf, ok := ret.Get(0).(func([]string) map[string][]*model.User); ok {
		r0 = rf(channelIDs)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string][]*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func([]string) error); ok {
		r1 = rf(channelIDs)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMoreChannels provides a mock function with given fields: teamID, userID, offset, limit
func (_m *ChannelStore) GetMoreChannels(teamID string, userID string, offset int, limit int) (model.ChannelList, error) {
	ret := _m.Called(teamID, userID, offset, limit)

	if len(ret) == 0 {
		panic("no return value specified for GetMoreChannels")
	}

	var r0 model.ChannelList
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string, int, int) (model.ChannelList, error)); ok {
		return rf(teamID, userID, offset, limit)
	}
	if rf, ok := ret.Get(0).(func(string, string, int, int) model.ChannelList); ok {
		r0 = rf(teamID, userID, offset, limit)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, int, int) error); ok {
		r1 = rf(teamID, userID, offset, limit)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetPinnedPostCount provides a mock function with given fields: channelID, allowFromCache
func (_m *ChannelStore) GetPinnedPostCount(channelID string, allowFromCache bool) (int64, error) {
	ret := _m.Called(channelID, allowFromCache)

	if len(ret) == 0 {
		panic("no return value specified for GetPinnedPostCount")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(string, bool) (int64, error)); ok {
		return rf(channelID, allowFromCache)
	}
	if rf, ok := ret.Get(0).(func(string, bool) int64); ok {
		r0 = rf(channelID, allowFromCache)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(string, bool) error); ok {
		r1 = rf(channelID, allowFromCache)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetPinnedPosts provides a mock function with given fields: channelID
func (_m *ChannelStore) GetPinnedPosts(channelID string) (*model.PostList, error) {
	ret := _m.Called(channelID)

	if len(ret) == 0 {
		panic("no return value specified for GetPinnedPosts")
	}

	var r0 *model.PostList
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (*model.PostList, error)); ok {
		return rf(channelID)
	}
	if rf, ok := ret.Get(0).(func(string) *model.PostList); ok {
		r0 = rf(channelID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PostList)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetPrivateChannelsForTeam provides a mock function with given fields: teamID, offset, limit
func (_m *ChannelStore) GetPrivateChannelsForTeam(teamID string, offset int, limit int) (model.ChannelList, error) {
	ret := _m.Called(teamID, offset, limit)

	if len(ret) == 0 {
		panic("no return value specified for GetPrivateChannelsForTeam")
	}

	var r0 model.ChannelList
	var r1 error
	if rf, ok := ret.Get(0).(func(string, int, int) (model.ChannelList, error)); ok {
		return rf(teamID, offset, limit)
	}
	if rf, ok := ret.Get(0).(func(string, int, int) model.ChannelList); ok {
		r0 = rf(teamID, offset, limit)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int, int) error); ok {
		r1 = rf(teamID, offset, limit)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetPublicChannelsByIdsForTeam provides a mock function with given fields: teamID, channelIds
func (_m *ChannelStore) GetPublicChannelsByIdsForTeam(teamID string, channelIds []string) (model.ChannelList, error) {
	ret := _m.Called(teamID, channelIds)

	if len(ret) == 0 {
		panic("no return value specified for GetPublicChannelsByIdsForTeam")
	}

	var r0 model.ChannelList
	var r1 error
	if rf, ok := ret.Get(0).(func(string, []string) (model.ChannelList, error)); ok {
		return rf(teamID, channelIds)
	}
	if rf, ok := ret.Get(0).(func(string, []string) model.ChannelList); ok {
		r0 = rf(teamID, channelIds)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []string) error); ok {
		r1 = rf(teamID, channelIds)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetPublicChannelsForTeam provides a mock function with given fields: teamID, offset, limit
func (_m *ChannelStore) GetPublicChannelsForTeam(teamID string, offset int, limit int) (model.ChannelList, error) {
	ret := _m.Called(teamID, offset, limit)

	if len(ret) == 0 {
		panic("no return value specified for GetPublicChannelsForTeam")
	}

	var r0 model.ChannelList
	var r1 error
	if rf, ok := ret.Get(0).(func(string, int, int) (model.ChannelList, error)); ok {
		return rf(teamID, offset, limit)
	}
	if rf, ok := ret.Get(0).(func(string, int, int) model.ChannelList); ok {
		r0 = rf(teamID, offset, limit)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, int, int) error); ok {
		r1 = rf(teamID, offset, limit)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetSidebarCategories provides a mock function with given fields: userID, teamID
func (_m *ChannelStore) GetSidebarCategories(userID string, teamID string) (*model.OrderedSidebarCategories, error) {
	ret := _m.Called(userID, teamID)

	if len(ret) == 0 {
		panic("no return value specified for GetSidebarCategories")
	}

	var r0 *model.OrderedSidebarCategories
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) (*model.OrderedSidebarCategories, error)); ok {
		return rf(userID, teamID)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.OrderedSidebarCategories); ok {
		r0 = rf(userID, teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.OrderedSidebarCategories)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(userID, teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetSidebarCategoriesForTeamForUser provides a mock function with given fields: userID, teamID
func (_m *ChannelStore) GetSidebarCategoriesForTeamForUser(userID string, teamID string) (*model.OrderedSidebarCategories, error) {
	ret := _m.Called(userID, teamID)

	if len(ret) == 0 {
		panic("no return value specified for GetSidebarCategoriesForTeamForUser")
	}

	var r0 *model.OrderedSidebarCategories
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) (*model.OrderedSidebarCategories, error)); ok {
		return rf(userID, teamID)
	}
	if rf, ok := ret.Get(0).(func(string, string) *model.OrderedSidebarCategories); ok {
		r0 = rf(userID, teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.OrderedSidebarCategories)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(userID, teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetSidebarCategory provides a mock function with given fields: categoryID
func (_m *ChannelStore) GetSidebarCategory(categoryID string) (*model.SidebarCategoryWithChannels, error) {
	ret := _m.Called(categoryID)

	if len(ret) == 0 {
		panic("no return value specified for GetSidebarCategory")
	}

	var r0 *model.SidebarCategoryWithChannels
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (*model.SidebarCategoryWithChannels, error)); ok {
		return rf(categoryID)
	}
	if rf, ok := ret.Get(0).(func(string) *model.SidebarCategoryWithChannels); ok {
		r0 = rf(categoryID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.SidebarCategoryWithChannels)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(categoryID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetSidebarCategoryOrder provides a mock function with given fields: userID, teamID
func (_m *ChannelStore) GetSidebarCategoryOrder(userID string, teamID string) ([]string, error) {
	ret := _m.Called(userID, teamID)

	if len(ret) == 0 {
		panic("no return value specified for GetSidebarCategoryOrder")
	}

	var r0 []string
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) ([]string, error)); ok {
		return rf(userID, teamID)
	}
	if rf, ok := ret.Get(0).(func(string, string) []string); ok {
		r0 = rf(userID, teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(userID, teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetTeamChannels provides a mock function with given fields: teamID
func (_m *ChannelStore) GetTeamChannels(teamID string) (model.ChannelList, error) {
	ret := _m.Called(teamID)

	if len(ret) == 0 {
		panic("no return value specified for GetTeamChannels")
	}

	var r0 model.ChannelList
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (model.ChannelList, error)); ok {
		return rf(teamID)
	}
	if rf, ok := ret.Get(0).(func(string) model.ChannelList); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetTeamForChannel provides a mock function with given fields: channelID
func (_m *ChannelStore) GetTeamForChannel(channelID string) (*model.Team, error) {
	ret := _m.Called(channelID)

	if len(ret) == 0 {
		panic("no return value specified for GetTeamForChannel")
	}

	var r0 *model.Team
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (*model.Team, error)); ok {
		return rf(channelID)
	}
	if rf, ok := ret.Get(0).(func(string) *model.Team); ok {
		r0 = rf(channelID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Team)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetTeamMembersForChannel provides a mock function with given fields: rctx, channelID
func (_m *ChannelStore) GetTeamMembersForChannel(rctx request.CTX, channelID string) ([]string, error) {
	ret := _m.Called(rctx, channelID)

	if len(ret) == 0 {
		panic("no return value specified for GetTeamMembersForChannel")
	}

	var r0 []string
	var r1 error
	if rf, ok := ret.Get(0).(func(request.CTX, string) ([]string, error)); ok {
		return rf(rctx, channelID)
	}
	if rf, ok := ret.Get(0).(func(request.CTX, string) []string); ok {
		r0 = rf(rctx, channelID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	if rf, ok := ret.Get(1).(func(request.CTX, string) error); ok {
		r1 = rf(rctx, channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GroupSyncedChannelCount provides a mock function with no fields
func (_m *ChannelStore) GroupSyncedChannelCount() (int64, error) {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GroupSyncedChannelCount")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func() (int64, error)); ok {
		return rf()
	}
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// IncrementMentionCount provides a mock function with given fields: channelID, userIDs, isRoot, isUrgent
func (_m *ChannelStore) IncrementMentionCount(channelID string, userIDs []string, isRoot bool, isUrgent bool) error {
	ret := _m.Called(channelID, userIDs, isRoot, isUrgent)

	if len(ret) == 0 {
		panic("no return value specified for IncrementMentionCount")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, []string, bool, bool) error); ok {
		r0 = rf(channelID, userIDs, isRoot, isUrgent)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// InvalidateAllChannelMembersForUser provides a mock function with given fields: userID
func (_m *ChannelStore) InvalidateAllChannelMembersForUser(userID string) {
	_m.Called(userID)
}

// InvalidateCacheForChannelMembersNotifyProps provides a mock function with given fields: channelID
func (_m *ChannelStore) InvalidateCacheForChannelMembersNotifyProps(channelID string) {
	_m.Called(channelID)
}

// InvalidateChannel provides a mock function with given fields: id
func (_m *ChannelStore) InvalidateChannel(id string) {
	_m.Called(id)
}

// InvalidateChannelByName provides a mock function with given fields: teamID, name
func (_m *ChannelStore) InvalidateChannelByName(teamID string, name string) {
	_m.Called(teamID, name)
}

// InvalidateGuestCount provides a mock function with given fields: channelID
func (_m *ChannelStore) InvalidateGuestCount(channelID string) {
	_m.Called(channelID)
}

// InvalidateMemberCount provides a mock function with given fields: channelID
func (_m *ChannelStore) InvalidateMemberCount(channelID string) {
	_m.Called(channelID)
}

// InvalidatePinnedPostCount provides a mock function with given fields: channelID
func (_m *ChannelStore) InvalidatePinnedPostCount(channelID string) {
	_m.Called(channelID)
}

// IsChannelReadOnlyScheme provides a mock function with given fields: schemeID
func (_m *ChannelStore) IsChannelReadOnlyScheme(schemeID string) (bool, error) {
	ret := _m.Called(schemeID)

	if len(ret) == 0 {
		panic("no return value specified for IsChannelReadOnlyScheme")
	}

	var r0 bool
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (bool, error)); ok {
		return rf(schemeID)
	}
	if rf, ok := ret.Get(0).(func(string) bool); ok {
		r0 = rf(schemeID)
	} else {
		r0 = ret.Get(0).(bool)
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(schemeID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// IsReadOnlyChannel provides a mock function with given fields: channelID
func (_m *ChannelStore) IsReadOnlyChannel(channelID string) (bool, error) {
	ret := _m.Called(channelID)

	if len(ret) == 0 {
		panic("no return value specified for IsReadOnlyChannel")
	}

	var r0 bool
	var r1 error
	if rf, ok := ret.Get(0).(func(string) (bool, error)); ok {
		return rf(channelID)
	}
	if rf, ok := ret.Get(0).(func(string) bool); ok {
		r0 = rf(channelID)
	} else {
		r0 = ret.Get(0).(bool)
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MigrateChannelMembers provides a mock function with given fields: fromChannelID, fromUserID
func (_m *ChannelStore) MigrateChannelMembers(fromChannelID string, fromUserID string) (map[string]string, error) {
	ret := _m.Called(fromChannelID, fromUserID)

	if len(ret) == 0 {
		panic("no return value specified for MigrateChannelMembers")
	}

	var r0 map[string]string
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) (map[string]string, error)); ok {
		return rf(fromChannelID, fromUserID)
	}
	if rf, ok := ret.Get(0).(func(string, string) map[string]string); ok {
		r0 = rf(fromChannelID, fromUserID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]string)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(fromChannelID, fromUserID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// PatchMultipleMembersNotifyProps provides a mock function with given fields: members, notifyProps
func (_m *ChannelStore) PatchMultipleMembersNotifyProps(members []*model.ChannelMemberIdentifier, notifyProps map[string]string) ([]*model.ChannelMember, error) {
	ret := _m.Called(members, notifyProps)

	if len(ret) == 0 {
		panic("no return value specified for PatchMultipleMembersNotifyProps")
	}

	var r0 []*model.ChannelMember
	var r1 error
	if rf, ok := ret.Get(0).(func([]*model.ChannelMemberIdentifier, map[string]string) ([]*model.ChannelMember, error)); ok {
		return rf(members, notifyProps)
	}
	if rf, ok := ret.Get(0).(func([]*model.ChannelMemberIdentifier, map[string]string) []*model.ChannelMember); ok {
		r0 = rf(members, notifyProps)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.ChannelMember)
		}
	}

	if rf, ok := ret.Get(1).(func([]*model.ChannelMemberIdentifier, map[string]string) error); ok {
		r1 = rf(members, notifyProps)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// PermanentDelete provides a mock function with given fields: rctx, channelID
func (_m *ChannelStore) PermanentDelete(rctx request.CTX, channelID string) error {
	ret := _m.Called(rctx, channelID)

	if len(ret) == 0 {
		panic("no return value specified for PermanentDelete")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(request.CTX, string) error); ok {
		r0 = rf(rctx, channelID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PermanentDeleteByTeam provides a mock function with given fields: teamID
func (_m *ChannelStore) PermanentDeleteByTeam(teamID string) error {
	ret := _m.Called(teamID)

	if len(ret) == 0 {
		panic("no return value specified for PermanentDeleteByTeam")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(teamID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PermanentDeleteMembersByChannel provides a mock function with given fields: rctx, channelID
func (_m *ChannelStore) PermanentDeleteMembersByChannel(rctx request.CTX, channelID string) error {
	ret := _m.Called(rctx, channelID)

	if len(ret) == 0 {
		panic("no return value specified for PermanentDeleteMembersByChannel")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(request.CTX, string) error); ok {
		r0 = rf(rctx, channelID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PermanentDeleteMembersByUser provides a mock function with given fields: rctx, userID
func (_m *ChannelStore) PermanentDeleteMembersByUser(rctx request.CTX, userID string) error {
	ret := _m.Called(rctx, userID)

	if len(ret) == 0 {
		panic("no return value specified for PermanentDeleteMembersByUser")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(request.CTX, string) error); ok {
		r0 = rf(rctx, userID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RemoveAllDeactivatedMembers provides a mock function with given fields: rctx, channelID
func (_m *ChannelStore) RemoveAllDeactivatedMembers(rctx request.CTX, channelID string) error {
	ret := _m.Called(rctx, channelID)

	if len(ret) == 0 {
		panic("no return value specified for RemoveAllDeactivatedMembers")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(request.CTX, string) error); ok {
		r0 = rf(rctx, channelID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RemoveMember provides a mock function with given fields: rctx, channelID, userID
func (_m *ChannelStore) RemoveMember(rctx request.CTX, channelID string, userID string) error {
	ret := _m.Called(rctx, channelID, userID)

	if len(ret) == 0 {
		panic("no return value specified for RemoveMember")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(request.CTX, string, string) error); ok {
		r0 = rf(rctx, channelID, userID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RemoveMembers provides a mock function with given fields: rctx, channelID, userIds
func (_m *ChannelStore) RemoveMembers(rctx request.CTX, channelID string, userIds []string) error {
	ret := _m.Called(rctx, channelID, userIds)

	if len(ret) == 0 {
		panic("no return value specified for RemoveMembers")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(request.CTX, string, []string) error); ok {
		r0 = rf(rctx, channelID, userIds)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ResetAllChannelSchemes provides a mock function with no fields
func (_m *ChannelStore) ResetAllChannelSchemes() error {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for ResetAllChannelSchemes")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func() error); ok {
		r0 = rf()
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Restore provides a mock function with given fields: channelID, timestamp
func (_m *ChannelStore) Restore(channelID string, timestamp int64) error {
	ret := _m.Called(channelID, timestamp)

	if len(ret) == 0 {
		panic("no return value specified for Restore")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64) error); ok {
		r0 = rf(channelID, timestamp)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Save provides a mock function with given fields: rctx, channel, maxChannelsPerTeam, channelOptions
func (_m *ChannelStore) Save(rctx request.CTX, channel *model.Channel, maxChannelsPerTeam int64, channelOptions ...model.ChannelOption) (*model.Channel, error) {
	_va := make([]interface{}, len(channelOptions))
	for _i := range channelOptions {
		_va[_i] = channelOptions[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, rctx, channel, maxChannelsPerTeam)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	if len(ret) == 0 {
		panic("no return value specified for Save")
	}

	var r0 *model.Channel
	var r1 error
	if rf, ok := ret.Get(0).(func(request.CTX, *model.Channel, int64, ...model.ChannelOption) (*model.Channel, error)); ok {
		return rf(rctx, channel, maxChannelsPerTeam, channelOptions...)
	}
	if rf, ok := ret.Get(0).(func(request.CTX, *model.Channel, int64, ...model.ChannelOption) *model.Channel); ok {
		r0 = rf(rctx, channel, maxChannelsPerTeam, channelOptions...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(request.CTX, *model.Channel, int64, ...model.ChannelOption) error); ok {
		r1 = rf(rctx, channel, maxChannelsPerTeam, channelOptions...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SaveDirectChannel provides a mock function with given fields: rctx, channel, member1, member2
func (_m *ChannelStore) SaveDirectChannel(rctx request.CTX, channel *model.Channel, member1 *model.ChannelMember, member2 *model.ChannelMember) (*model.Channel, error) {
	ret := _m.Called(rctx, channel, member1, member2)

	if len(ret) == 0 {
		panic("no return value specified for SaveDirectChannel")
	}

	var r0 *model.Channel
	var r1 error
	if rf, ok := ret.Get(0).(func(request.CTX, *model.Channel, *model.ChannelMember, *model.ChannelMember) (*model.Channel, error)); ok {
		return rf(rctx, channel, member1, member2)
	}
	if rf, ok := ret.Get(0).(func(request.CTX, *model.Channel, *model.ChannelMember, *model.ChannelMember) *model.Channel); ok {
		r0 = rf(rctx, channel, member1, member2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(request.CTX, *model.Channel, *model.ChannelMember, *model.ChannelMember) error); ok {
		r1 = rf(rctx, channel, member1, member2)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SaveMember provides a mock function with given fields: rctx, member
func (_m *ChannelStore) SaveMember(rctx request.CTX, member *model.ChannelMember) (*model.ChannelMember, error) {
	ret := _m.Called(rctx, member)

	if len(ret) == 0 {
		panic("no return value specified for SaveMember")
	}

	var r0 *model.ChannelMember
	var r1 error
	if rf, ok := ret.Get(0).(func(request.CTX, *model.ChannelMember) (*model.ChannelMember, error)); ok {
		return rf(rctx, member)
	}
	if rf, ok := ret.Get(0).(func(request.CTX, *model.ChannelMember) *model.ChannelMember); ok {
		r0 = rf(rctx, member)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	if rf, ok := ret.Get(1).(func(request.CTX, *model.ChannelMember) error); ok {
		r1 = rf(rctx, member)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SaveMultipleMembers provides a mock function with given fields: members
func (_m *ChannelStore) SaveMultipleMembers(members []*model.ChannelMember) ([]*model.ChannelMember, error) {
	ret := _m.Called(members)

	if len(ret) == 0 {
		panic("no return value specified for SaveMultipleMembers")
	}

	var r0 []*model.ChannelMember
	var r1 error
	if rf, ok := ret.Get(0).(func([]*model.ChannelMember) ([]*model.ChannelMember, error)); ok {
		return rf(members)
	}
	if rf, ok := ret.Get(0).(func([]*model.ChannelMember) []*model.ChannelMember); ok {
		r0 = rf(members)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.ChannelMember)
		}
	}

	if rf, ok := ret.Get(1).(func([]*model.ChannelMember) error); ok {
		r1 = rf(members)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SearchAllChannels provides a mock function with given fields: term, opts
func (_m *ChannelStore) SearchAllChannels(term string, opts store.ChannelSearchOpts) (model.ChannelListWithTeamData, int64, error) {
	ret := _m.Called(term, opts)

	if len(ret) == 0 {
		panic("no return value specified for SearchAllChannels")
	}

	var r0 model.ChannelListWithTeamData
	var r1 int64
	var r2 error
	if rf, ok := ret.Get(0).(func(string, store.ChannelSearchOpts) (model.ChannelListWithTeamData, int64, error)); ok {
		return rf(term, opts)
	}
	if rf, ok := ret.Get(0).(func(string, store.ChannelSearchOpts) model.ChannelListWithTeamData); ok {
		r0 = rf(term, opts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelListWithTeamData)
		}
	}

	if rf, ok := ret.Get(1).(func(string, store.ChannelSearchOpts) int64); ok {
		r1 = rf(term, opts)
	} else {
		r1 = ret.Get(1).(int64)
	}

	if rf, ok := ret.Get(2).(func(string, store.ChannelSearchOpts) error); ok {
		r2 = rf(term, opts)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// SearchForUserInTeam provides a mock function with given fields: userID, teamID, term, includeDeleted
func (_m *ChannelStore) SearchForUserInTeam(userID string, teamID string, term string, includeDeleted bool) (model.ChannelList, error) {
	ret := _m.Called(userID, teamID, term, includeDeleted)

	if len(ret) == 0 {
		panic("no return value specified for SearchForUserInTeam")
	}

	var r0 model.ChannelList
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string, string, bool) (model.ChannelList, error)); ok {
		return rf(userID, teamID, term, includeDeleted)
	}
	if rf, ok := ret.Get(0).(func(string, string, string, bool) model.ChannelList); ok {
		r0 = rf(userID, teamID, term, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, string, bool) error); ok {
		r1 = rf(userID, teamID, term, includeDeleted)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SearchGroupChannels provides a mock function with given fields: userID, term
func (_m *ChannelStore) SearchGroupChannels(userID string, term string) (model.ChannelList, error) {
	ret := _m.Called(userID, term)

	if len(ret) == 0 {
		panic("no return value specified for SearchGroupChannels")
	}

	var r0 model.ChannelList
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string) (model.ChannelList, error)); ok {
		return rf(userID, term)
	}
	if rf, ok := ret.Get(0).(func(string, string) model.ChannelList); ok {
		r0 = rf(userID, term)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(userID, term)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SearchInTeam provides a mock function with given fields: teamID, term, includeDeleted
func (_m *ChannelStore) SearchInTeam(teamID string, term string, includeDeleted bool) (model.ChannelList, error) {
	ret := _m.Called(teamID, term, includeDeleted)

	if len(ret) == 0 {
		panic("no return value specified for SearchInTeam")
	}

	var r0 model.ChannelList
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string, bool) (model.ChannelList, error)); ok {
		return rf(teamID, term, includeDeleted)
	}
	if rf, ok := ret.Get(0).(func(string, string, bool) model.ChannelList); ok {
		r0 = rf(teamID, term, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, bool) error); ok {
		r1 = rf(teamID, term, includeDeleted)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SearchMore provides a mock function with given fields: userID, teamID, term
func (_m *ChannelStore) SearchMore(userID string, teamID string, term string) (model.ChannelList, error) {
	ret := _m.Called(userID, teamID, term)

	if len(ret) == 0 {
		panic("no return value specified for SearchMore")
	}

	var r0 model.ChannelList
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string, string) (model.ChannelList, error)); ok {
		return rf(userID, teamID, term)
	}
	if rf, ok := ret.Get(0).(func(string, string, string) model.ChannelList); ok {
		r0 = rf(userID, teamID, term)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelList)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, string) error); ok {
		r1 = rf(userID, teamID, term)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SetDeleteAt provides a mock function with given fields: channelID, deleteAt, updateAt
func (_m *ChannelStore) SetDeleteAt(channelID string, deleteAt int64, updateAt int64) error {
	ret := _m.Called(channelID, deleteAt, updateAt)

	if len(ret) == 0 {
		panic("no return value specified for SetDeleteAt")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64, int64) error); ok {
		r0 = rf(channelID, deleteAt, updateAt)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SetShared provides a mock function with given fields: channelID, shared
func (_m *ChannelStore) SetShared(channelID string, shared bool) error {
	ret := _m.Called(channelID, shared)

	if len(ret) == 0 {
		panic("no return value specified for SetShared")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, bool) error); ok {
		r0 = rf(channelID, shared)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Update provides a mock function with given fields: rctx, channel
func (_m *ChannelStore) Update(rctx request.CTX, channel *model.Channel) (*model.Channel, error) {
	ret := _m.Called(rctx, channel)

	if len(ret) == 0 {
		panic("no return value specified for Update")
	}

	var r0 *model.Channel
	var r1 error
	if rf, ok := ret.Get(0).(func(request.CTX, *model.Channel) (*model.Channel, error)); ok {
		return rf(rctx, channel)
	}
	if rf, ok := ret.Get(0).(func(request.CTX, *model.Channel) *model.Channel); ok {
		r0 = rf(rctx, channel)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	if rf, ok := ret.Get(1).(func(request.CTX, *model.Channel) error); ok {
		r1 = rf(rctx, channel)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateLastViewedAt provides a mock function with given fields: channelIds, userID
func (_m *ChannelStore) UpdateLastViewedAt(channelIds []string, userID string) (map[string]int64, error) {
	ret := _m.Called(channelIds, userID)

	if len(ret) == 0 {
		panic("no return value specified for UpdateLastViewedAt")
	}

	var r0 map[string]int64
	var r1 error
	if rf, ok := ret.Get(0).(func([]string, string) (map[string]int64, error)); ok {
		return rf(channelIds, userID)
	}
	if rf, ok := ret.Get(0).(func([]string, string) map[string]int64); ok {
		r0 = rf(channelIds, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]int64)
		}
	}

	if rf, ok := ret.Get(1).(func([]string, string) error); ok {
		r1 = rf(channelIds, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateLastViewedAtPost provides a mock function with given fields: unreadPost, userID, mentionCount, mentionCountRoot, urgentMentionCount, setUnreadCountRoot
func (_m *ChannelStore) UpdateLastViewedAtPost(unreadPost *model.Post, userID string, mentionCount int, mentionCountRoot int, urgentMentionCount int, setUnreadCountRoot bool) (*model.ChannelUnreadAt, error) {
	ret := _m.Called(unreadPost, userID, mentionCount, mentionCountRoot, urgentMentionCount, setUnreadCountRoot)

	if len(ret) == 0 {
		panic("no return value specified for UpdateLastViewedAtPost")
	}

	var r0 *model.ChannelUnreadAt
	var r1 error
	if rf, ok := ret.Get(0).(func(*model.Post, string, int, int, int, bool) (*model.ChannelUnreadAt, error)); ok {
		return rf(unreadPost, userID, mentionCount, mentionCountRoot, urgentMentionCount, setUnreadCountRoot)
	}
	if rf, ok := ret.Get(0).(func(*model.Post, string, int, int, int, bool) *model.ChannelUnreadAt); ok {
		r0 = rf(unreadPost, userID, mentionCount, mentionCountRoot, urgentMentionCount, setUnreadCountRoot)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelUnreadAt)
		}
	}

	if rf, ok := ret.Get(1).(func(*model.Post, string, int, int, int, bool) error); ok {
		r1 = rf(unreadPost, userID, mentionCount, mentionCountRoot, urgentMentionCount, setUnreadCountRoot)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateMember provides a mock function with given fields: rctx, member
func (_m *ChannelStore) UpdateMember(rctx request.CTX, member *model.ChannelMember) (*model.ChannelMember, error) {
	ret := _m.Called(rctx, member)

	if len(ret) == 0 {
		panic("no return value specified for UpdateMember")
	}

	var r0 *model.ChannelMember
	var r1 error
	if rf, ok := ret.Get(0).(func(request.CTX, *model.ChannelMember) (*model.ChannelMember, error)); ok {
		return rf(rctx, member)
	}
	if rf, ok := ret.Get(0).(func(request.CTX, *model.ChannelMember) *model.ChannelMember); ok {
		r0 = rf(rctx, member)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	if rf, ok := ret.Get(1).(func(request.CTX, *model.ChannelMember) error); ok {
		r1 = rf(rctx, member)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateMemberNotifyProps provides a mock function with given fields: channelID, userID, props
func (_m *ChannelStore) UpdateMemberNotifyProps(channelID string, userID string, props map[string]string) (*model.ChannelMember, error) {
	ret := _m.Called(channelID, userID, props)

	if len(ret) == 0 {
		panic("no return value specified for UpdateMemberNotifyProps")
	}

	var r0 *model.ChannelMember
	var r1 error
	if rf, ok := ret.Get(0).(func(string, string, map[string]string) (*model.ChannelMember, error)); ok {
		return rf(channelID, userID, props)
	}
	if rf, ok := ret.Get(0).(func(string, string, map[string]string) *model.ChannelMember); ok {
		r0 = rf(channelID, userID, props)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, map[string]string) error); ok {
		r1 = rf(channelID, userID, props)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateMembersRole provides a mock function with given fields: channelID, userIDs
func (_m *ChannelStore) UpdateMembersRole(channelID string, userIDs []string) ([]*model.ChannelMember, error) {
	ret := _m.Called(channelID, userIDs)

	if len(ret) == 0 {
		panic("no return value specified for UpdateMembersRole")
	}

	var r0 []*model.ChannelMember
	var r1 error
	if rf, ok := ret.Get(0).(func(string, []string) ([]*model.ChannelMember, error)); ok {
		return rf(channelID, userIDs)
	}
	if rf, ok := ret.Get(0).(func(string, []string) []*model.ChannelMember); ok {
		r0 = rf(channelID, userIDs)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.ChannelMember)
		}
	}

	if rf, ok := ret.Get(1).(func(string, []string) error); ok {
		r1 = rf(channelID, userIDs)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateMultipleMembers provides a mock function with given fields: members
func (_m *ChannelStore) UpdateMultipleMembers(members []*model.ChannelMember) ([]*model.ChannelMember, error) {
	ret := _m.Called(members)

	if len(ret) == 0 {
		panic("no return value specified for UpdateMultipleMembers")
	}

	var r0 []*model.ChannelMember
	var r1 error
	if rf, ok := ret.Get(0).(func([]*model.ChannelMember) ([]*model.ChannelMember, error)); ok {
		return rf(members)
	}
	if rf, ok := ret.Get(0).(func([]*model.ChannelMember) []*model.ChannelMember); ok {
		r0 = rf(members)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.ChannelMember)
		}
	}

	if rf, ok := ret.Get(1).(func([]*model.ChannelMember) error); ok {
		r1 = rf(members)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateSidebarCategories provides a mock function with given fields: userID, teamID, categories
func (_m *ChannelStore) UpdateSidebarCategories(userID string, teamID string, categories []*model.SidebarCategoryWithChannels) ([]*model.SidebarCategoryWithChannels, []*model.SidebarCategoryWithChannels, error) {
	ret := _m.Called(userID, teamID, categories)

	if len(ret) == 0 {
		panic("no return value specified for UpdateSidebarCategories")
	}

	var r0 []*model.SidebarCategoryWithChannels
	var r1 []*model.SidebarCategoryWithChannels
	var r2 error
	if rf, ok := ret.Get(0).(func(string, string, []*model.SidebarCategoryWithChannels) ([]*model.SidebarCategoryWithChannels, []*model.SidebarCategoryWithChannels, error)); ok {
		return rf(userID, teamID, categories)
	}
	if rf, ok := ret.Get(0).(func(string, string, []*model.SidebarCategoryWithChannels) []*model.SidebarCategoryWithChannels); ok {
		r0 = rf(userID, teamID, categories)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.SidebarCategoryWithChannels)
		}
	}

	if rf, ok := ret.Get(1).(func(string, string, []*model.SidebarCategoryWithChannels) []*model.SidebarCategoryWithChannels); ok {
		r1 = rf(userID, teamID, categories)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).([]*model.SidebarCategoryWithChannels)
		}
	}

	if rf, ok := ret.Get(2).(func(string, string, []*model.SidebarCategoryWithChannels) error); ok {
		r2 = rf(userID, teamID, categories)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// UpdateSidebarCategoryOrder provides a mock function with given fields: userID, teamID, categoryOrder
func (_m *ChannelStore) UpdateSidebarCategoryOrder(userID string, teamID string, categoryOrder []string) error {
	ret := _m.Called(userID, teamID, categoryOrder)

	if len(ret) == 0 {
		panic("no return value specified for UpdateSidebarCategoryOrder")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string, []string) error); ok {
		r0 = rf(userID, teamID, categoryOrder)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UpdateSidebarChannelCategoryOnMove provides a mock function with given fields: channel, newTeamID
func (_m *ChannelStore) UpdateSidebarChannelCategoryOnMove(channel *model.Channel, newTeamID string) error {
	ret := _m.Called(channel, newTeamID)

	if len(ret) == 0 {
		panic("no return value specified for UpdateSidebarChannelCategoryOnMove")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(*model.Channel, string) error); ok {
		r0 = rf(channel, newTeamID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UpdateSidebarChannelsByPreferences provides a mock function with given fields: preferences
func (_m *ChannelStore) UpdateSidebarChannelsByPreferences(preferences model.Preferences) error {
	ret := _m.Called(preferences)

	if len(ret) == 0 {
		panic("no return value specified for UpdateSidebarChannelsByPreferences")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(model.Preferences) error); ok {
		r0 = rf(preferences)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UserBelongsToChannels provides a mock function with given fields: userID, channelIds
func (_m *ChannelStore) UserBelongsToChannels(userID string, channelIds []string) (bool, error) {
	ret := _m.Called(userID, channelIds)

	if len(ret) == 0 {
		panic("no return value specified for UserBelongsToChannels")
	}

	var r0 bool
	var r1 error
	if rf, ok := ret.Get(0).(func(string, []string) (bool, error)); ok {
		return rf(userID, channelIds)
	}
	if rf, ok := ret.Get(0).(func(string, []string) bool); ok {
		r0 = rf(userID, channelIds)
	} else {
		r0 = ret.Get(0).(bool)
	}

	if rf, ok := ret.Get(1).(func(string, []string) error); ok {
		r1 = rf(userID, channelIds)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// NewChannelStore creates a new instance of ChannelStore. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewChannelStore(t interface {
	mock.TestingT
	Cleanup(func())
}) *ChannelStore {
	mock := &ChannelStore{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
