// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

// Code generated by "make store-layers"
// DO NOT EDIT

package retrylayer

import (
	"context"
	timepkg "time"

	"github.com/lib/pq"
	"github.com/pkg/errors"

	"github.com/mattermost/mattermost/server/public/model"
	"github.com/mattermost/mattermost/server/public/shared/request"
	"github.com/mattermost/mattermost/server/v8/channels/store"
)

type RetryLayer struct {
	store.Store
	AccessControlPolicyStore        store.AccessControlPolicyStore
	AttributesStore                 store.AttributesStore
	AuditStore                      store.AuditStore
	BotStore                        store.BotStore
	ChannelStore                    store.ChannelStore
	ChannelBookmarkStore            store.ChannelBookmarkStore
	ChannelMemberHistoryStore       store.ChannelMemberHistoryStore
	ClusterDiscoveryStore           store.ClusterDiscoveryStore
	CommandStore                    store.CommandStore
	CommandWebhookStore             store.CommandWebhookStore
	ComplianceStore                 store.ComplianceStore
	ContentFlaggingStore            store.ContentFlaggingStore
	DesktopTokensStore              store.DesktopTokensStore
	DraftStore                      store.DraftStore
	EmojiStore                      store.EmojiStore
	FileInfoStore                   store.FileInfoStore
	GroupStore                      store.GroupStore
	JobStore                        store.JobStore
	LicenseStore                    store.LicenseStore
	LinkMetadataStore               store.LinkMetadataStore
	NotifyAdminStore                store.NotifyAdminStore
	OAuthStore                      store.OAuthStore
	OutgoingOAuthConnectionStore    store.OutgoingOAuthConnectionStore
	PluginStore                     store.PluginStore
	PostStore                       store.PostStore
	PostAcknowledgementStore        store.PostAcknowledgementStore
	PostPersistentNotificationStore store.PostPersistentNotificationStore
	PostPriorityStore               store.PostPriorityStore
	PreferenceStore                 store.PreferenceStore
	ProductNoticesStore             store.ProductNoticesStore
	PropertyFieldStore              store.PropertyFieldStore
	PropertyGroupStore              store.PropertyGroupStore
	PropertyValueStore              store.PropertyValueStore
	ReactionStore                   store.ReactionStore
	RemoteClusterStore              store.RemoteClusterStore
	RetentionPolicyStore            store.RetentionPolicyStore
	RoleStore                       store.RoleStore
	ScheduledPostStore              store.ScheduledPostStore
	SchemeStore                     store.SchemeStore
	SessionStore                    store.SessionStore
	SharedChannelStore              store.SharedChannelStore
	StatusStore                     store.StatusStore
	SystemStore                     store.SystemStore
	TeamStore                       store.TeamStore
	TermsOfServiceStore             store.TermsOfServiceStore
	ThreadStore                     store.ThreadStore
	TokenStore                      store.TokenStore
	UploadSessionStore              store.UploadSessionStore
	UserStore                       store.UserStore
	UserAccessTokenStore            store.UserAccessTokenStore
	UserTermsOfServiceStore         store.UserTermsOfServiceStore
	WebhookStore                    store.WebhookStore
}

func (s *RetryLayer) AccessControlPolicy() store.AccessControlPolicyStore {
	return s.AccessControlPolicyStore
}

func (s *RetryLayer) Attributes() store.AttributesStore {
	return s.AttributesStore
}

func (s *RetryLayer) Audit() store.AuditStore {
	return s.AuditStore
}

func (s *RetryLayer) Bot() store.BotStore {
	return s.BotStore
}

func (s *RetryLayer) Channel() store.ChannelStore {
	return s.ChannelStore
}

func (s *RetryLayer) ChannelBookmark() store.ChannelBookmarkStore {
	return s.ChannelBookmarkStore
}

func (s *RetryLayer) ChannelMemberHistory() store.ChannelMemberHistoryStore {
	return s.ChannelMemberHistoryStore
}

func (s *RetryLayer) ClusterDiscovery() store.ClusterDiscoveryStore {
	return s.ClusterDiscoveryStore
}

func (s *RetryLayer) Command() store.CommandStore {
	return s.CommandStore
}

func (s *RetryLayer) CommandWebhook() store.CommandWebhookStore {
	return s.CommandWebhookStore
}

func (s *RetryLayer) Compliance() store.ComplianceStore {
	return s.ComplianceStore
}

func (s *RetryLayer) ContentFlagging() store.ContentFlaggingStore {
	return s.ContentFlaggingStore
}

func (s *RetryLayer) DesktopTokens() store.DesktopTokensStore {
	return s.DesktopTokensStore
}

func (s *RetryLayer) Draft() store.DraftStore {
	return s.DraftStore
}

func (s *RetryLayer) Emoji() store.EmojiStore {
	return s.EmojiStore
}

func (s *RetryLayer) FileInfo() store.FileInfoStore {
	return s.FileInfoStore
}

func (s *RetryLayer) Group() store.GroupStore {
	return s.GroupStore
}

func (s *RetryLayer) Job() store.JobStore {
	return s.JobStore
}

func (s *RetryLayer) License() store.LicenseStore {
	return s.LicenseStore
}

func (s *RetryLayer) LinkMetadata() store.LinkMetadataStore {
	return s.LinkMetadataStore
}

func (s *RetryLayer) NotifyAdmin() store.NotifyAdminStore {
	return s.NotifyAdminStore
}

func (s *RetryLayer) OAuth() store.OAuthStore {
	return s.OAuthStore
}

func (s *RetryLayer) OutgoingOAuthConnection() store.OutgoingOAuthConnectionStore {
	return s.OutgoingOAuthConnectionStore
}

func (s *RetryLayer) Plugin() store.PluginStore {
	return s.PluginStore
}

func (s *RetryLayer) Post() store.PostStore {
	return s.PostStore
}

func (s *RetryLayer) PostAcknowledgement() store.PostAcknowledgementStore {
	return s.PostAcknowledgementStore
}

func (s *RetryLayer) PostPersistentNotification() store.PostPersistentNotificationStore {
	return s.PostPersistentNotificationStore
}

func (s *RetryLayer) PostPriority() store.PostPriorityStore {
	return s.PostPriorityStore
}

func (s *RetryLayer) Preference() store.PreferenceStore {
	return s.PreferenceStore
}

func (s *RetryLayer) ProductNotices() store.ProductNoticesStore {
	return s.ProductNoticesStore
}

func (s *RetryLayer) PropertyField() store.PropertyFieldStore {
	return s.PropertyFieldStore
}

func (s *RetryLayer) PropertyGroup() store.PropertyGroupStore {
	return s.PropertyGroupStore
}

func (s *RetryLayer) PropertyValue() store.PropertyValueStore {
	return s.PropertyValueStore
}

func (s *RetryLayer) Reaction() store.ReactionStore {
	return s.ReactionStore
}

func (s *RetryLayer) RemoteCluster() store.RemoteClusterStore {
	return s.RemoteClusterStore
}

func (s *RetryLayer) RetentionPolicy() store.RetentionPolicyStore {
	return s.RetentionPolicyStore
}

func (s *RetryLayer) Role() store.RoleStore {
	return s.RoleStore
}

func (s *RetryLayer) ScheduledPost() store.ScheduledPostStore {
	return s.ScheduledPostStore
}

func (s *RetryLayer) Scheme() store.SchemeStore {
	return s.SchemeStore
}

func (s *RetryLayer) Session() store.SessionStore {
	return s.SessionStore
}

func (s *RetryLayer) SharedChannel() store.SharedChannelStore {
	return s.SharedChannelStore
}

func (s *RetryLayer) Status() store.StatusStore {
	return s.StatusStore
}

func (s *RetryLayer) System() store.SystemStore {
	return s.SystemStore
}

func (s *RetryLayer) Team() store.TeamStore {
	return s.TeamStore
}

func (s *RetryLayer) TermsOfService() store.TermsOfServiceStore {
	return s.TermsOfServiceStore
}

func (s *RetryLayer) Thread() store.ThreadStore {
	return s.ThreadStore
}

func (s *RetryLayer) Token() store.TokenStore {
	return s.TokenStore
}

func (s *RetryLayer) UploadSession() store.UploadSessionStore {
	return s.UploadSessionStore
}

func (s *RetryLayer) User() store.UserStore {
	return s.UserStore
}

func (s *RetryLayer) UserAccessToken() store.UserAccessTokenStore {
	return s.UserAccessTokenStore
}

func (s *RetryLayer) UserTermsOfService() store.UserTermsOfServiceStore {
	return s.UserTermsOfServiceStore
}

func (s *RetryLayer) Webhook() store.WebhookStore {
	return s.WebhookStore
}

type RetryLayerAccessControlPolicyStore struct {
	store.AccessControlPolicyStore
	Root *RetryLayer
}

type RetryLayerAttributesStore struct {
	store.AttributesStore
	Root *RetryLayer
}

type RetryLayerAuditStore struct {
	store.AuditStore
	Root *RetryLayer
}

type RetryLayerBotStore struct {
	store.BotStore
	Root *RetryLayer
}

type RetryLayerChannelStore struct {
	store.ChannelStore
	Root *RetryLayer
}

type RetryLayerChannelBookmarkStore struct {
	store.ChannelBookmarkStore
	Root *RetryLayer
}

type RetryLayerChannelMemberHistoryStore struct {
	store.ChannelMemberHistoryStore
	Root *RetryLayer
}

type RetryLayerClusterDiscoveryStore struct {
	store.ClusterDiscoveryStore
	Root *RetryLayer
}

type RetryLayerCommandStore struct {
	store.CommandStore
	Root *RetryLayer
}

type RetryLayerCommandWebhookStore struct {
	store.CommandWebhookStore
	Root *RetryLayer
}

type RetryLayerComplianceStore struct {
	store.ComplianceStore
	Root *RetryLayer
}

type RetryLayerContentFlaggingStore struct {
	store.ContentFlaggingStore
	Root *RetryLayer
}

type RetryLayerDesktopTokensStore struct {
	store.DesktopTokensStore
	Root *RetryLayer
}

type RetryLayerDraftStore struct {
	store.DraftStore
	Root *RetryLayer
}

type RetryLayerEmojiStore struct {
	store.EmojiStore
	Root *RetryLayer
}

type RetryLayerFileInfoStore struct {
	store.FileInfoStore
	Root *RetryLayer
}

type RetryLayerGroupStore struct {
	store.GroupStore
	Root *RetryLayer
}

type RetryLayerJobStore struct {
	store.JobStore
	Root *RetryLayer
}

type RetryLayerLicenseStore struct {
	store.LicenseStore
	Root *RetryLayer
}

type RetryLayerLinkMetadataStore struct {
	store.LinkMetadataStore
	Root *RetryLayer
}

type RetryLayerNotifyAdminStore struct {
	store.NotifyAdminStore
	Root *RetryLayer
}

type RetryLayerOAuthStore struct {
	store.OAuthStore
	Root *RetryLayer
}

type RetryLayerOutgoingOAuthConnectionStore struct {
	store.OutgoingOAuthConnectionStore
	Root *RetryLayer
}

type RetryLayerPluginStore struct {
	store.PluginStore
	Root *RetryLayer
}

type RetryLayerPostStore struct {
	store.PostStore
	Root *RetryLayer
}

type RetryLayerPostAcknowledgementStore struct {
	store.PostAcknowledgementStore
	Root *RetryLayer
}

type RetryLayerPostPersistentNotificationStore struct {
	store.PostPersistentNotificationStore
	Root *RetryLayer
}

type RetryLayerPostPriorityStore struct {
	store.PostPriorityStore
	Root *RetryLayer
}

type RetryLayerPreferenceStore struct {
	store.PreferenceStore
	Root *RetryLayer
}

type RetryLayerProductNoticesStore struct {
	store.ProductNoticesStore
	Root *RetryLayer
}

type RetryLayerPropertyFieldStore struct {
	store.PropertyFieldStore
	Root *RetryLayer
}

type RetryLayerPropertyGroupStore struct {
	store.PropertyGroupStore
	Root *RetryLayer
}

type RetryLayerPropertyValueStore struct {
	store.PropertyValueStore
	Root *RetryLayer
}

type RetryLayerReactionStore struct {
	store.ReactionStore
	Root *RetryLayer
}

type RetryLayerRemoteClusterStore struct {
	store.RemoteClusterStore
	Root *RetryLayer
}

type RetryLayerRetentionPolicyStore struct {
	store.RetentionPolicyStore
	Root *RetryLayer
}

type RetryLayerRoleStore struct {
	store.RoleStore
	Root *RetryLayer
}

type RetryLayerScheduledPostStore struct {
	store.ScheduledPostStore
	Root *RetryLayer
}

type RetryLayerSchemeStore struct {
	store.SchemeStore
	Root *RetryLayer
}

type RetryLayerSessionStore struct {
	store.SessionStore
	Root *RetryLayer
}

type RetryLayerSharedChannelStore struct {
	store.SharedChannelStore
	Root *RetryLayer
}

type RetryLayerStatusStore struct {
	store.StatusStore
	Root *RetryLayer
}

type RetryLayerSystemStore struct {
	store.SystemStore
	Root *RetryLayer
}

type RetryLayerTeamStore struct {
	store.TeamStore
	Root *RetryLayer
}

type RetryLayerTermsOfServiceStore struct {
	store.TermsOfServiceStore
	Root *RetryLayer
}

type RetryLayerThreadStore struct {
	store.ThreadStore
	Root *RetryLayer
}

type RetryLayerTokenStore struct {
	store.TokenStore
	Root *RetryLayer
}

type RetryLayerUploadSessionStore struct {
	store.UploadSessionStore
	Root *RetryLayer
}

type RetryLayerUserStore struct {
	store.UserStore
	Root *RetryLayer
}

type RetryLayerUserAccessTokenStore struct {
	store.UserAccessTokenStore
	Root *RetryLayer
}

type RetryLayerUserTermsOfServiceStore struct {
	store.UserTermsOfServiceStore
	Root *RetryLayer
}

type RetryLayerWebhookStore struct {
	store.WebhookStore
	Root *RetryLayer
}

func isRepeatableError(err error) bool {
	var pqErr *pq.Error
	switch {
	case errors.As(errors.Cause(err), &pqErr):
		if pqErr.Code == "40001" || pqErr.Code == "40P01" {
			return true
		}
	}
	return false
}

func (s *RetryLayerAccessControlPolicyStore) Delete(rctx request.CTX, id string) error {

	tries := 0
	for {
		err := s.AccessControlPolicyStore.Delete(rctx, id)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerAccessControlPolicyStore) Get(rctx request.CTX, id string) (*model.AccessControlPolicy, error) {

	tries := 0
	for {
		result, err := s.AccessControlPolicyStore.Get(rctx, id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerAccessControlPolicyStore) Save(rctx request.CTX, policy *model.AccessControlPolicy) (*model.AccessControlPolicy, error) {

	tries := 0
	for {
		result, err := s.AccessControlPolicyStore.Save(rctx, policy)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerAccessControlPolicyStore) SearchPolicies(rctx request.CTX, opts model.AccessControlPolicySearch) ([]*model.AccessControlPolicy, int64, error) {

	tries := 0
	for {
		result, resultVar1, err := s.AccessControlPolicyStore.SearchPolicies(rctx, opts)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerAccessControlPolicyStore) SetActiveStatus(rctx request.CTX, id string, active bool) (*model.AccessControlPolicy, error) {

	tries := 0
	for {
		result, err := s.AccessControlPolicyStore.SetActiveStatus(rctx, id, active)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerAttributesStore) GetChannelMembersToRemove(rctx request.CTX, channelID string, opts model.SubjectSearchOptions) ([]*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.AttributesStore.GetChannelMembersToRemove(rctx, channelID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerAttributesStore) GetSubject(rctx request.CTX, ID string, groupID string) (*model.Subject, error) {

	tries := 0
	for {
		result, err := s.AttributesStore.GetSubject(rctx, ID, groupID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerAttributesStore) RefreshAttributes() error {

	tries := 0
	for {
		err := s.AttributesStore.RefreshAttributes()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerAttributesStore) SearchUsers(rctx request.CTX, opts model.SubjectSearchOptions) ([]*model.User, int64, error) {

	tries := 0
	for {
		result, resultVar1, err := s.AttributesStore.SearchUsers(rctx, opts)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerAuditStore) Get(userID string, offset int, limit int) (model.Audits, error) {

	tries := 0
	for {
		result, err := s.AuditStore.Get(userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerAuditStore) PermanentDeleteByUser(userID string) error {

	tries := 0
	for {
		err := s.AuditStore.PermanentDeleteByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerAuditStore) Save(audit *model.Audit) error {

	tries := 0
	for {
		err := s.AuditStore.Save(audit)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerBotStore) Get(userID string, includeDeleted bool) (*model.Bot, error) {

	tries := 0
	for {
		result, err := s.BotStore.Get(userID, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerBotStore) GetAll(options *model.BotGetOptions) ([]*model.Bot, error) {

	tries := 0
	for {
		result, err := s.BotStore.GetAll(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerBotStore) GetAllAfter(limit int, afterId string) ([]*model.Bot, error) {

	tries := 0
	for {
		result, err := s.BotStore.GetAllAfter(limit, afterId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerBotStore) GetByUsername(username string) (*model.Bot, error) {

	tries := 0
	for {
		result, err := s.BotStore.GetByUsername(username)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerBotStore) PermanentDelete(userID string) error {

	tries := 0
	for {
		err := s.BotStore.PermanentDelete(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerBotStore) Save(bot *model.Bot) (*model.Bot, error) {

	tries := 0
	for {
		result, err := s.BotStore.Save(bot)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerBotStore) Update(bot *model.Bot) (*model.Bot, error) {

	tries := 0
	for {
		result, err := s.BotStore.Update(bot)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) AnalyticsCountAll(teamID string) (map[model.ChannelType]int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.AnalyticsCountAll(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) AnalyticsDeletedTypeCount(teamID string, channelType model.ChannelType) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.AnalyticsDeletedTypeCount(teamID, channelType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) AnalyticsTypeCount(teamID string, channelType model.ChannelType) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.AnalyticsTypeCount(teamID, channelType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) Autocomplete(rctx request.CTX, userID string, term string, includeDeleted bool, isGuest bool) (model.ChannelListWithTeamData, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.Autocomplete(rctx, userID, term, includeDeleted, isGuest)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) AutocompleteInTeam(rctx request.CTX, teamID string, userID string, term string, includeDeleted bool, isGuest bool) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.AutocompleteInTeam(rctx, teamID, userID, term, includeDeleted, isGuest)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) AutocompleteInTeamForSearch(teamID string, userID string, term string, includeDeleted bool) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.AutocompleteInTeamForSearch(teamID, userID, term, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) ClearAllCustomRoleAssignments() error {

	tries := 0
	for {
		err := s.ChannelStore.ClearAllCustomRoleAssignments()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) ClearCaches() {

	s.ChannelStore.ClearCaches()

}

func (s *RetryLayerChannelStore) ClearMembersForUserCache() {

	s.ChannelStore.ClearMembersForUserCache()

}

func (s *RetryLayerChannelStore) ClearSidebarOnTeamLeave(userID string, teamID string) error {

	tries := 0
	for {
		err := s.ChannelStore.ClearSidebarOnTeamLeave(userID, teamID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) CountPostsAfter(channelID string, timestamp int64, excludedUserID string) (int, int, error) {

	tries := 0
	for {
		result, resultVar1, err := s.ChannelStore.CountPostsAfter(channelID, timestamp, excludedUserID)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) CountUrgentPostsAfter(channelID string, timestamp int64, excludedUserID string) (int, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.CountUrgentPostsAfter(channelID, timestamp, excludedUserID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) CreateDirectChannel(rctx request.CTX, userID *model.User, otherUserID *model.User, channelOptions ...model.ChannelOption) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.CreateDirectChannel(rctx, userID, otherUserID, channelOptions...)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) CreateInitialSidebarCategories(rctx request.CTX, userID string, teamID string) (*model.OrderedSidebarCategories, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.CreateInitialSidebarCategories(rctx, userID, teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) CreateSidebarCategory(userID string, teamID string, newCategory *model.SidebarCategoryWithChannels) (*model.SidebarCategoryWithChannels, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.CreateSidebarCategory(userID, teamID, newCategory)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) Delete(channelID string, timestamp int64) error {

	tries := 0
	for {
		err := s.ChannelStore.Delete(channelID, timestamp)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) DeleteAllSidebarChannelForChannel(channelID string) error {

	tries := 0
	for {
		err := s.ChannelStore.DeleteAllSidebarChannelForChannel(channelID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) DeleteSidebarCategory(categoryID string) error {

	tries := 0
	for {
		err := s.ChannelStore.DeleteSidebarCategory(categoryID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) DeleteSidebarChannelsByPreferences(preferences model.Preferences) error {

	tries := 0
	for {
		err := s.ChannelStore.DeleteSidebarChannelsByPreferences(preferences)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) Get(id string, allowFromCache bool) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.Get(id, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetAll(teamID string) ([]*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetAll(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetAllChannelMemberIdsByChannelId(id string) ([]string, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetAllChannelMemberIdsByChannelId(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetAllChannelMembersForUser(rctx request.CTX, userID string, allowFromCache bool, includeDeleted bool) (map[string]string, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetAllChannelMembersForUser(rctx, userID, allowFromCache, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetAllChannelMembersNotifyPropsForChannel(channelID string, allowFromCache bool) (map[string]model.StringMap, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetAllChannelMembersNotifyPropsForChannel(channelID, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetAllChannels(page int, perPage int, opts store.ChannelSearchOpts) (model.ChannelListWithTeamData, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetAllChannels(page, perPage, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetAllChannelsCount(opts store.ChannelSearchOpts) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetAllChannelsCount(opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetAllChannelsForExportAfter(limit int, afterID string) ([]*model.ChannelForExport, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetAllChannelsForExportAfter(limit, afterID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetAllDirectChannelsForExportAfter(limit int, afterID string, includeArchivedChannels bool) ([]*model.DirectChannelForExport, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetAllDirectChannelsForExportAfter(limit, afterID, includeArchivedChannels)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetByName(teamID string, name string, allowFromCache bool) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetByName(teamID, name, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetByNameIncludeDeleted(teamID string, name string, allowFromCache bool) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetByNameIncludeDeleted(teamID, name, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetByNames(teamID string, names []string, allowFromCache bool) ([]*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetByNames(teamID, names, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetByNamesIncludeDeleted(teamID string, names []string, allowFromCache bool) ([]*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetByNamesIncludeDeleted(teamID, names, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelCounts(teamID string, userID string) (*model.ChannelCounts, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelCounts(teamID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelMembersForExport(userID string, teamID string, includeArchivedChannel bool) ([]*model.ChannelMemberForExport, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelMembersForExport(userID, teamID, includeArchivedChannel)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelMembersTimezones(channelID string) ([]model.StringMap, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelMembersTimezones(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelUnread(channelID string, userID string) (*model.ChannelUnread, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelUnread(channelID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannels(teamID string, userID string, opts *model.ChannelSearchOpts) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannels(teamID, userID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelsBatchForIndexing(startTime int64, startChannelID string, limit int) ([]*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelsBatchForIndexing(startTime, startChannelID, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelsByIds(channelIds []string, includeDeleted bool) ([]*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelsByIds(channelIds, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelsByScheme(schemeID string, offset int, limit int) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelsByScheme(schemeID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelsByUser(userID string, includeDeleted bool, lastDeleteAt int, pageSize int, fromChannelID string) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelsByUser(userID, includeDeleted, lastDeleteAt, pageSize, fromChannelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelsMemberCount(channelIDs []string) (map[string]int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelsMemberCount(channelIDs)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelsWithTeamDataByIds(channelIds []string, includeDeleted bool) ([]*model.ChannelWithTeamData, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelsWithTeamDataByIds(channelIds, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelsWithUnreadsAndWithMentions(rctx request.CTX, channelIDs []string, userID string, userNotifyProps model.StringMap) ([]string, []string, map[string]int64, error) {

	tries := 0
	for {
		result, resultVar1, resultVar2, err := s.ChannelStore.GetChannelsWithUnreadsAndWithMentions(rctx, channelIDs, userID, userNotifyProps)
		if err == nil {
			return result, resultVar1, resultVar2, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, resultVar2, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, resultVar2, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetDeleted(teamID string, offset int, limit int, userID string, skipTeamMembershipCheck bool) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetDeleted(teamID, offset, limit, userID, skipTeamMembershipCheck)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetDeletedByName(teamID string, name string) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetDeletedByName(teamID, name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetFileCount(channelID string) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetFileCount(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetForPost(postID string) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetForPost(postID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetGuestCount(channelID string, allowFromCache bool) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetGuestCount(channelID, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMany(ids []string, allowFromCache bool) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMany(ids, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMember(rctx request.CTX, channelID string, userID string) (*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMember(rctx, channelID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMemberCount(channelID string, allowFromCache bool) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMemberCount(channelID, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMemberCountFromCache(channelID string) int64 {

	return s.ChannelStore.GetMemberCountFromCache(channelID)

}

func (s *RetryLayerChannelStore) GetMemberCountsByGroup(rctx request.CTX, channelID string, includeTimezones bool) ([]*model.ChannelMemberCountByGroup, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMemberCountsByGroup(rctx, channelID, includeTimezones)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMemberForPost(postID string, userID string) (*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMemberForPost(postID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMemberLastViewedAt(rctx request.CTX, channelID string, userID string) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMemberLastViewedAt(rctx, channelID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMembers(opts model.ChannelMembersGetOptions) (model.ChannelMembers, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMembers(opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMembersByChannelIds(channelIds []string, userID string) (model.ChannelMembers, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMembersByChannelIds(channelIds, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMembersByIds(channelID string, userIds []string) (model.ChannelMembers, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMembersByIds(channelID, userIds)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMembersForUser(teamID string, userID string) (model.ChannelMembers, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMembersForUser(teamID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMembersForUserWithCursorPagination(userId string, perPage int, fromChanneID string) (model.ChannelMembersWithTeamData, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMembersForUserWithCursorPagination(userId, perPage, fromChanneID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMembersForUserWithPagination(userID string, page int, perPage int) (model.ChannelMembersWithTeamData, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMembersForUserWithPagination(userID, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMembersInfoByChannelIds(channelIDs []string) (map[string][]*model.User, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMembersInfoByChannelIds(channelIDs)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMoreChannels(teamID string, userID string, offset int, limit int) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMoreChannels(teamID, userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetPinnedPostCount(channelID string, allowFromCache bool) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetPinnedPostCount(channelID, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetPinnedPosts(channelID string) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetPinnedPosts(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetPrivateChannelsForTeam(teamID string, offset int, limit int) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetPrivateChannelsForTeam(teamID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetPublicChannelsByIdsForTeam(teamID string, channelIds []string) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetPublicChannelsByIdsForTeam(teamID, channelIds)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetPublicChannelsForTeam(teamID string, offset int, limit int) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetPublicChannelsForTeam(teamID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetSidebarCategories(userID string, teamID string) (*model.OrderedSidebarCategories, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetSidebarCategories(userID, teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetSidebarCategoriesForTeamForUser(userID string, teamID string) (*model.OrderedSidebarCategories, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetSidebarCategoriesForTeamForUser(userID, teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetSidebarCategory(categoryID string) (*model.SidebarCategoryWithChannels, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetSidebarCategory(categoryID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetSidebarCategoryOrder(userID string, teamID string) ([]string, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetSidebarCategoryOrder(userID, teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetTeamChannels(teamID string) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetTeamChannels(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetTeamForChannel(channelID string) (*model.Team, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetTeamForChannel(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetTeamMembersForChannel(rctx request.CTX, channelID string) ([]string, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetTeamMembersForChannel(rctx, channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GroupSyncedChannelCount() (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GroupSyncedChannelCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) IncrementMentionCount(channelID string, userIDs []string, isRoot bool, isUrgent bool) error {

	tries := 0
	for {
		err := s.ChannelStore.IncrementMentionCount(channelID, userIDs, isRoot, isUrgent)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) InvalidateAllChannelMembersForUser(userID string) {

	s.ChannelStore.InvalidateAllChannelMembersForUser(userID)

}

func (s *RetryLayerChannelStore) InvalidateCacheForChannelMembersNotifyProps(channelID string) {

	s.ChannelStore.InvalidateCacheForChannelMembersNotifyProps(channelID)

}

func (s *RetryLayerChannelStore) InvalidateChannel(id string) {

	s.ChannelStore.InvalidateChannel(id)

}

func (s *RetryLayerChannelStore) InvalidateChannelByName(teamID string, name string) {

	s.ChannelStore.InvalidateChannelByName(teamID, name)

}

func (s *RetryLayerChannelStore) InvalidateGuestCount(channelID string) {

	s.ChannelStore.InvalidateGuestCount(channelID)

}

func (s *RetryLayerChannelStore) InvalidateMemberCount(channelID string) {

	s.ChannelStore.InvalidateMemberCount(channelID)

}

func (s *RetryLayerChannelStore) InvalidatePinnedPostCount(channelID string) {

	s.ChannelStore.InvalidatePinnedPostCount(channelID)

}

func (s *RetryLayerChannelStore) IsChannelReadOnlyScheme(schemeID string) (bool, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.IsChannelReadOnlyScheme(schemeID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) IsReadOnlyChannel(channelID string) (bool, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.IsReadOnlyChannel(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) MigrateChannelMembers(fromChannelID string, fromUserID string) (map[string]string, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.MigrateChannelMembers(fromChannelID, fromUserID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) PatchMultipleMembersNotifyProps(members []*model.ChannelMemberIdentifier, notifyProps map[string]string) ([]*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.PatchMultipleMembersNotifyProps(members, notifyProps)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) PermanentDelete(rctx request.CTX, channelID string) error {

	tries := 0
	for {
		err := s.ChannelStore.PermanentDelete(rctx, channelID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) PermanentDeleteByTeam(teamID string) error {

	tries := 0
	for {
		err := s.ChannelStore.PermanentDeleteByTeam(teamID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) PermanentDeleteMembersByChannel(rctx request.CTX, channelID string) error {

	tries := 0
	for {
		err := s.ChannelStore.PermanentDeleteMembersByChannel(rctx, channelID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) PermanentDeleteMembersByUser(rctx request.CTX, userID string) error {

	tries := 0
	for {
		err := s.ChannelStore.PermanentDeleteMembersByUser(rctx, userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) RemoveAllDeactivatedMembers(rctx request.CTX, channelID string) error {

	tries := 0
	for {
		err := s.ChannelStore.RemoveAllDeactivatedMembers(rctx, channelID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) RemoveMember(rctx request.CTX, channelID string, userID string) error {

	tries := 0
	for {
		err := s.ChannelStore.RemoveMember(rctx, channelID, userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) RemoveMembers(rctx request.CTX, channelID string, userIds []string) error {

	tries := 0
	for {
		err := s.ChannelStore.RemoveMembers(rctx, channelID, userIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) ResetAllChannelSchemes() error {

	tries := 0
	for {
		err := s.ChannelStore.ResetAllChannelSchemes()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) Restore(channelID string, timestamp int64) error {

	tries := 0
	for {
		err := s.ChannelStore.Restore(channelID, timestamp)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) Save(rctx request.CTX, channel *model.Channel, maxChannelsPerTeam int64, channelOptions ...model.ChannelOption) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.Save(rctx, channel, maxChannelsPerTeam, channelOptions...)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SaveDirectChannel(rctx request.CTX, channel *model.Channel, member1 *model.ChannelMember, member2 *model.ChannelMember) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.SaveDirectChannel(rctx, channel, member1, member2)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SaveMember(rctx request.CTX, member *model.ChannelMember) (*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.SaveMember(rctx, member)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SaveMultipleMembers(members []*model.ChannelMember) ([]*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.SaveMultipleMembers(members)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SearchAllChannels(term string, opts store.ChannelSearchOpts) (model.ChannelListWithTeamData, int64, error) {

	tries := 0
	for {
		result, resultVar1, err := s.ChannelStore.SearchAllChannels(term, opts)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SearchForUserInTeam(userID string, teamID string, term string, includeDeleted bool) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.SearchForUserInTeam(userID, teamID, term, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SearchGroupChannels(userID string, term string) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.SearchGroupChannels(userID, term)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SearchInTeam(teamID string, term string, includeDeleted bool) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.SearchInTeam(teamID, term, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SearchMore(userID string, teamID string, term string) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.SearchMore(userID, teamID, term)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SetDeleteAt(channelID string, deleteAt int64, updateAt int64) error {

	tries := 0
	for {
		err := s.ChannelStore.SetDeleteAt(channelID, deleteAt, updateAt)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SetShared(channelID string, shared bool) error {

	tries := 0
	for {
		err := s.ChannelStore.SetShared(channelID, shared)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) Update(rctx request.CTX, channel *model.Channel) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.Update(rctx, channel)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateLastViewedAt(channelIds []string, userID string) (map[string]int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.UpdateLastViewedAt(channelIds, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateLastViewedAtPost(unreadPost *model.Post, userID string, mentionCount int, mentionCountRoot int, urgentMentionCount int, setUnreadCountRoot bool) (*model.ChannelUnreadAt, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.UpdateLastViewedAtPost(unreadPost, userID, mentionCount, mentionCountRoot, urgentMentionCount, setUnreadCountRoot)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateMember(rctx request.CTX, member *model.ChannelMember) (*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.UpdateMember(rctx, member)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateMemberNotifyProps(channelID string, userID string, props map[string]string) (*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.UpdateMemberNotifyProps(channelID, userID, props)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateMembersRole(channelID string, userIDs []string) ([]*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.UpdateMembersRole(channelID, userIDs)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateMultipleMembers(members []*model.ChannelMember) ([]*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.UpdateMultipleMembers(members)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateSidebarCategories(userID string, teamID string, categories []*model.SidebarCategoryWithChannels) ([]*model.SidebarCategoryWithChannels, []*model.SidebarCategoryWithChannels, error) {

	tries := 0
	for {
		result, resultVar1, err := s.ChannelStore.UpdateSidebarCategories(userID, teamID, categories)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateSidebarCategoryOrder(userID string, teamID string, categoryOrder []string) error {

	tries := 0
	for {
		err := s.ChannelStore.UpdateSidebarCategoryOrder(userID, teamID, categoryOrder)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateSidebarChannelCategoryOnMove(channel *model.Channel, newTeamID string) error {

	tries := 0
	for {
		err := s.ChannelStore.UpdateSidebarChannelCategoryOnMove(channel, newTeamID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateSidebarChannelsByPreferences(preferences model.Preferences) error {

	tries := 0
	for {
		err := s.ChannelStore.UpdateSidebarChannelsByPreferences(preferences)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UserBelongsToChannels(userID string, channelIds []string) (bool, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.UserBelongsToChannels(userID, channelIds)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelBookmarkStore) Delete(bookmarkID string, deleteFile bool) error {

	tries := 0
	for {
		err := s.ChannelBookmarkStore.Delete(bookmarkID, deleteFile)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelBookmarkStore) ErrorIfBookmarkFileInfoAlreadyAttached(fileID string, channelID string) error {

	tries := 0
	for {
		err := s.ChannelBookmarkStore.ErrorIfBookmarkFileInfoAlreadyAttached(fileID, channelID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelBookmarkStore) Get(Id string, includeDeleted bool) (*model.ChannelBookmarkWithFileInfo, error) {

	tries := 0
	for {
		result, err := s.ChannelBookmarkStore.Get(Id, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelBookmarkStore) GetBookmarksForChannelSince(channelID string, since int64) ([]*model.ChannelBookmarkWithFileInfo, error) {

	tries := 0
	for {
		result, err := s.ChannelBookmarkStore.GetBookmarksForChannelSince(channelID, since)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelBookmarkStore) Save(bookmark *model.ChannelBookmark, increaseSortOrder bool) (*model.ChannelBookmarkWithFileInfo, error) {

	tries := 0
	for {
		result, err := s.ChannelBookmarkStore.Save(bookmark, increaseSortOrder)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelBookmarkStore) Update(bookmark *model.ChannelBookmark) error {

	tries := 0
	for {
		err := s.ChannelBookmarkStore.Update(bookmark)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelBookmarkStore) UpdateSortOrder(bookmarkID string, channelID string, newIndex int64) ([]*model.ChannelBookmarkWithFileInfo, error) {

	tries := 0
	for {
		result, err := s.ChannelBookmarkStore.UpdateSortOrder(bookmarkID, channelID, newIndex)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelMemberHistoryStore) DeleteOrphanedRows(limit int) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelMemberHistoryStore.DeleteOrphanedRows(limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelMemberHistoryStore) GetChannelsLeftSince(userID string, since int64) ([]string, error) {

	tries := 0
	for {
		result, err := s.ChannelMemberHistoryStore.GetChannelsLeftSince(userID, since)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelMemberHistoryStore) GetChannelsWithActivityDuring(startTime int64, endTime int64) ([]string, error) {

	tries := 0
	for {
		result, err := s.ChannelMemberHistoryStore.GetChannelsWithActivityDuring(startTime, endTime)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelMemberHistoryStore) GetUsersInChannelDuring(startTime int64, endTime int64, channelID []string) ([]*model.ChannelMemberHistoryResult, error) {

	tries := 0
	for {
		result, err := s.ChannelMemberHistoryStore.GetUsersInChannelDuring(startTime, endTime, channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelMemberHistoryStore) LogJoinEvent(userID string, channelID string, joinTime int64) error {

	tries := 0
	for {
		err := s.ChannelMemberHistoryStore.LogJoinEvent(userID, channelID, joinTime)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelMemberHistoryStore) LogLeaveEvent(userID string, channelID string, leaveTime int64) error {

	tries := 0
	for {
		err := s.ChannelMemberHistoryStore.LogLeaveEvent(userID, channelID, leaveTime)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelMemberHistoryStore) PermanentDeleteBatch(endTime int64, limit int64) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelMemberHistoryStore.PermanentDeleteBatch(endTime, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelMemberHistoryStore) PermanentDeleteBatchForRetentionPolicies(retentionPolicyBatchConfigs model.RetentionPolicyBatchConfigs, cursor model.RetentionPolicyCursor) (int64, model.RetentionPolicyCursor, error) {

	tries := 0
	for {
		result, resultVar1, err := s.ChannelMemberHistoryStore.PermanentDeleteBatchForRetentionPolicies(retentionPolicyBatchConfigs, cursor)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerClusterDiscoveryStore) Cleanup() error {

	tries := 0
	for {
		err := s.ClusterDiscoveryStore.Cleanup()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerClusterDiscoveryStore) Delete(discovery *model.ClusterDiscovery) (bool, error) {

	tries := 0
	for {
		result, err := s.ClusterDiscoveryStore.Delete(discovery)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerClusterDiscoveryStore) Exists(discovery *model.ClusterDiscovery) (bool, error) {

	tries := 0
	for {
		result, err := s.ClusterDiscoveryStore.Exists(discovery)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerClusterDiscoveryStore) GetAll(discoveryType string, clusterName string) ([]*model.ClusterDiscovery, error) {

	tries := 0
	for {
		result, err := s.ClusterDiscoveryStore.GetAll(discoveryType, clusterName)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerClusterDiscoveryStore) Save(discovery *model.ClusterDiscovery) error {

	tries := 0
	for {
		err := s.ClusterDiscoveryStore.Save(discovery)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerClusterDiscoveryStore) SetLastPingAt(discovery *model.ClusterDiscovery) error {

	tries := 0
	for {
		err := s.ClusterDiscoveryStore.SetLastPingAt(discovery)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) AnalyticsCommandCount(teamID string) (int64, error) {

	tries := 0
	for {
		result, err := s.CommandStore.AnalyticsCommandCount(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) Delete(commandID string, timestamp int64) error {

	tries := 0
	for {
		err := s.CommandStore.Delete(commandID, timestamp)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) Get(id string) (*model.Command, error) {

	tries := 0
	for {
		result, err := s.CommandStore.Get(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) GetByTeam(teamID string) ([]*model.Command, error) {

	tries := 0
	for {
		result, err := s.CommandStore.GetByTeam(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) GetByTrigger(teamID string, trigger string) (*model.Command, error) {

	tries := 0
	for {
		result, err := s.CommandStore.GetByTrigger(teamID, trigger)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) PermanentDeleteByTeam(teamID string) error {

	tries := 0
	for {
		err := s.CommandStore.PermanentDeleteByTeam(teamID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) PermanentDeleteByUser(userID string) error {

	tries := 0
	for {
		err := s.CommandStore.PermanentDeleteByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) Save(webhook *model.Command) (*model.Command, error) {

	tries := 0
	for {
		result, err := s.CommandStore.Save(webhook)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) Update(hook *model.Command) (*model.Command, error) {

	tries := 0
	for {
		result, err := s.CommandStore.Update(hook)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandWebhookStore) Cleanup() {

	s.CommandWebhookStore.Cleanup()

}

func (s *RetryLayerCommandWebhookStore) Get(id string) (*model.CommandWebhook, error) {

	tries := 0
	for {
		result, err := s.CommandWebhookStore.Get(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandWebhookStore) Save(webhook *model.CommandWebhook) (*model.CommandWebhook, error) {

	tries := 0
	for {
		result, err := s.CommandWebhookStore.Save(webhook)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandWebhookStore) TryUse(id string, limit int) error {

	tries := 0
	for {
		err := s.CommandWebhookStore.TryUse(id, limit)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerComplianceStore) ComplianceExport(compliance *model.Compliance, cursor model.ComplianceExportCursor, limit int) ([]*model.CompliancePost, model.ComplianceExportCursor, error) {

	tries := 0
	for {
		result, resultVar1, err := s.ComplianceStore.ComplianceExport(compliance, cursor, limit)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerComplianceStore) Get(id string) (*model.Compliance, error) {

	tries := 0
	for {
		result, err := s.ComplianceStore.Get(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerComplianceStore) GetAll(offset int, limit int) (model.Compliances, error) {

	tries := 0
	for {
		result, err := s.ComplianceStore.GetAll(offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerComplianceStore) MessageExport(rctx request.CTX, cursor model.MessageExportCursor, limit int) ([]*model.MessageExport, model.MessageExportCursor, error) {

	tries := 0
	for {
		result, resultVar1, err := s.ComplianceStore.MessageExport(rctx, cursor, limit)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerComplianceStore) Save(compliance *model.Compliance) (*model.Compliance, error) {

	tries := 0
	for {
		result, err := s.ComplianceStore.Save(compliance)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerComplianceStore) Update(compliance *model.Compliance) (*model.Compliance, error) {

	tries := 0
	for {
		result, err := s.ComplianceStore.Update(compliance)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerContentFlaggingStore) ClearCaches() {

	s.ContentFlaggingStore.ClearCaches()

}

func (s *RetryLayerContentFlaggingStore) GetReviewerSettings() (*model.ReviewerIDsSettings, error) {

	tries := 0
	for {
		result, err := s.ContentFlaggingStore.GetReviewerSettings()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerContentFlaggingStore) SaveReviewerSettings(reviewerSettings model.ReviewerIDsSettings) error {

	tries := 0
	for {
		err := s.ContentFlaggingStore.SaveReviewerSettings(reviewerSettings)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerDesktopTokensStore) Delete(token string) error {

	tries := 0
	for {
		err := s.DesktopTokensStore.Delete(token)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerDesktopTokensStore) DeleteByUserId(userID string) error {

	tries := 0
	for {
		err := s.DesktopTokensStore.DeleteByUserId(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerDesktopTokensStore) DeleteOlderThan(minCreatedAt int64) error {

	tries := 0
	for {
		err := s.DesktopTokensStore.DeleteOlderThan(minCreatedAt)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerDesktopTokensStore) GetUserId(token string, minCreatedAt int64) (*string, error) {

	tries := 0
	for {
		result, err := s.DesktopTokensStore.GetUserId(token, minCreatedAt)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerDesktopTokensStore) Insert(token string, createAt int64, userID string) error {

	tries := 0
	for {
		err := s.DesktopTokensStore.Insert(token, createAt, userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerDraftStore) Delete(userID string, channelID string, rootID string) error {

	tries := 0
	for {
		err := s.DraftStore.Delete(userID, channelID, rootID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerDraftStore) DeleteDraftsAssociatedWithPost(channelID string, rootID string) error {

	tries := 0
	for {
		err := s.DraftStore.DeleteDraftsAssociatedWithPost(channelID, rootID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerDraftStore) DeleteEmptyDraftsByCreateAtAndUserId(createAt int64, userID string) error {

	tries := 0
	for {
		err := s.DraftStore.DeleteEmptyDraftsByCreateAtAndUserId(createAt, userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerDraftStore) DeleteOrphanDraftsByCreateAtAndUserId(createAt int64, userID string) error {

	tries := 0
	for {
		err := s.DraftStore.DeleteOrphanDraftsByCreateAtAndUserId(createAt, userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerDraftStore) Get(userID string, channelID string, rootID string, includeDeleted bool) (*model.Draft, error) {

	tries := 0
	for {
		result, err := s.DraftStore.Get(userID, channelID, rootID, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerDraftStore) GetDraftsForUser(userID string, teamID string) ([]*model.Draft, error) {

	tries := 0
	for {
		result, err := s.DraftStore.GetDraftsForUser(userID, teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerDraftStore) GetLastCreateAtAndUserIdValuesForEmptyDraftsMigration(createAt int64, userID string) (int64, string, error) {

	tries := 0
	for {
		result, resultVar1, err := s.DraftStore.GetLastCreateAtAndUserIdValuesForEmptyDraftsMigration(createAt, userID)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerDraftStore) PermanentDeleteByUser(userId string) error {

	tries := 0
	for {
		err := s.DraftStore.PermanentDeleteByUser(userId)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerDraftStore) Upsert(d *model.Draft) (*model.Draft, error) {

	tries := 0
	for {
		result, err := s.DraftStore.Upsert(d)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerEmojiStore) Delete(emoji *model.Emoji, timestamp int64) error {

	tries := 0
	for {
		err := s.EmojiStore.Delete(emoji, timestamp)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerEmojiStore) Get(rctx request.CTX, id string, allowFromCache bool) (*model.Emoji, error) {

	tries := 0
	for {
		result, err := s.EmojiStore.Get(rctx, id, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerEmojiStore) GetByName(rctx request.CTX, name string, allowFromCache bool) (*model.Emoji, error) {

	tries := 0
	for {
		result, err := s.EmojiStore.GetByName(rctx, name, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerEmojiStore) GetList(offset int, limit int, sort string) ([]*model.Emoji, error) {

	tries := 0
	for {
		result, err := s.EmojiStore.GetList(offset, limit, sort)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerEmojiStore) GetMultipleByName(rctx request.CTX, names []string) ([]*model.Emoji, error) {

	tries := 0
	for {
		result, err := s.EmojiStore.GetMultipleByName(rctx, names)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerEmojiStore) Save(emoji *model.Emoji) (*model.Emoji, error) {

	tries := 0
	for {
		result, err := s.EmojiStore.Save(emoji)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerEmojiStore) Search(name string, prefixOnly bool, limit int) ([]*model.Emoji, error) {

	tries := 0
	for {
		result, err := s.EmojiStore.Search(name, prefixOnly, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) AttachToPost(rctx request.CTX, fileID string, postID string, channelID string, creatorID string) error {

	tries := 0
	for {
		err := s.FileInfoStore.AttachToPost(rctx, fileID, postID, channelID, creatorID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) ClearCaches() {

	s.FileInfoStore.ClearCaches()

}

func (s *RetryLayerFileInfoStore) CountAll() (int64, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.CountAll()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) DeleteForPost(rctx request.CTX, postID string) (string, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.DeleteForPost(rctx, postID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) DeleteForPostByIds(rctx request.CTX, postId string, fileIDs []string) error {

	tries := 0
	for {
		err := s.FileInfoStore.DeleteForPostByIds(rctx, postId, fileIDs)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) Get(id string) (*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.Get(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) GetByIds(ids []string, includeDeleted bool, allowFromCache bool) ([]*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.GetByIds(ids, includeDeleted, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) GetByPath(path string) (*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.GetByPath(path)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) GetFilesBatchForIndexing(startTime int64, startFileID string, includeDeleted bool, limit int) ([]*model.FileForIndexing, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.GetFilesBatchForIndexing(startTime, startFileID, includeDeleted, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) GetForPost(postID string, readFromMaster bool, includeDeleted bool, allowFromCache bool) ([]*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.GetForPost(postID, readFromMaster, includeDeleted, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) GetForUser(userID string) ([]*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.GetForUser(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) GetFromMaster(id string) (*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.GetFromMaster(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) GetStorageUsage(allowFromCache bool, includeDeleted bool) (int64, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.GetStorageUsage(allowFromCache, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) GetUptoNSizeFileTime(n int64) (int64, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.GetUptoNSizeFileTime(n)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) GetWithOptions(page int, perPage int, opt *model.GetFileInfosOptions) ([]*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.GetWithOptions(page, perPage, opt)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) InvalidateFileInfosForPostCache(postID string, deleted bool) {

	s.FileInfoStore.InvalidateFileInfosForPostCache(postID, deleted)

}

func (s *RetryLayerFileInfoStore) PermanentDelete(rctx request.CTX, fileID string) error {

	tries := 0
	for {
		err := s.FileInfoStore.PermanentDelete(rctx, fileID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) PermanentDeleteBatch(rctx request.CTX, endTime int64, limit int64) (int64, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.PermanentDeleteBatch(rctx, endTime, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) PermanentDeleteByUser(rctx request.CTX, userID string) (int64, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.PermanentDeleteByUser(rctx, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) PermanentDeleteForPost(rctx request.CTX, postID string) error {

	tries := 0
	for {
		err := s.FileInfoStore.PermanentDeleteForPost(rctx, postID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) RefreshFileStats() error {

	tries := 0
	for {
		err := s.FileInfoStore.RefreshFileStats()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) RestoreForPostByIds(rctx request.CTX, postId string, fileIDs []string) error {

	tries := 0
	for {
		err := s.FileInfoStore.RestoreForPostByIds(rctx, postId, fileIDs)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) Save(rctx request.CTX, info *model.FileInfo) (*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.Save(rctx, info)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) Search(rctx request.CTX, paramsList []*model.SearchParams, userID string, teamID string, page int, perPage int) (*model.FileInfoList, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.Search(rctx, paramsList, userID, teamID, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) SetContent(rctx request.CTX, fileID string, content string) error {

	tries := 0
	for {
		err := s.FileInfoStore.SetContent(rctx, fileID, content)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) Upsert(rctx request.CTX, info *model.FileInfo) (*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.Upsert(rctx, info)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) AdminRoleGroupsForSyncableMember(userID string, syncableID string, syncableType model.GroupSyncableType) ([]string, error) {

	tries := 0
	for {
		result, err := s.GroupStore.AdminRoleGroupsForSyncableMember(userID, syncableID, syncableType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) ChannelMembersMinusGroupMembers(channelID string, groupIDs []string, page int, perPage int) ([]*model.UserWithGroups, error) {

	tries := 0
	for {
		result, err := s.GroupStore.ChannelMembersMinusGroupMembers(channelID, groupIDs, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) ChannelMembersToAdd(since int64, channelID *string, reAddRemovedMembers bool) ([]*model.UserChannelIDPair, error) {

	tries := 0
	for {
		result, err := s.GroupStore.ChannelMembersToAdd(since, channelID, reAddRemovedMembers)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) ChannelMembersToRemove(channelID *string) ([]*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.GroupStore.ChannelMembersToRemove(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) CountChannelMembersMinusGroupMembers(channelID string, groupIDs []string) (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.CountChannelMembersMinusGroupMembers(channelID, groupIDs)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) CountGroupsByChannel(channelID string, opts model.GroupSearchOpts) (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.CountGroupsByChannel(channelID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) CountGroupsByTeam(teamID string, opts model.GroupSearchOpts) (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.CountGroupsByTeam(teamID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) CountTeamMembersMinusGroupMembers(teamID string, groupIDs []string) (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.CountTeamMembersMinusGroupMembers(teamID, groupIDs)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) Create(group *model.Group) (*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.Create(group)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) CreateGroupSyncable(groupSyncable *model.GroupSyncable) (*model.GroupSyncable, error) {

	tries := 0
	for {
		result, err := s.GroupStore.CreateGroupSyncable(groupSyncable)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) CreateWithUserIds(group *model.GroupWithUserIds) (*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.CreateWithUserIds(group)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) Delete(groupID string) (*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.Delete(groupID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) DeleteGroupSyncable(groupID string, syncableID string, syncableType model.GroupSyncableType) (*model.GroupSyncable, error) {

	tries := 0
	for {
		result, err := s.GroupStore.DeleteGroupSyncable(groupID, syncableID, syncableType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) DeleteMember(groupID string, userID string) (*model.GroupMember, error) {

	tries := 0
	for {
		result, err := s.GroupStore.DeleteMember(groupID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) DeleteMembers(groupID string, userIDs []string) ([]*model.GroupMember, error) {

	tries := 0
	for {
		result, err := s.GroupStore.DeleteMembers(groupID, userIDs)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) DistinctGroupMemberCount() (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.DistinctGroupMemberCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) DistinctGroupMemberCountForSource(source model.GroupSource) (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.DistinctGroupMemberCountForSource(source)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) Get(groupID string) (*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.Get(groupID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetAllBySource(groupSource model.GroupSource) ([]*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetAllBySource(groupSource)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetAllGroupSyncablesByGroupId(groupID string, syncableType model.GroupSyncableType) ([]*model.GroupSyncable, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetAllGroupSyncablesByGroupId(groupID, syncableType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetByIDs(groupIDs []string) ([]*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetByIDs(groupIDs)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetByName(name string, opts model.GroupSearchOpts) (*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetByName(name, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetByNames(names []string, viewRestrictions *model.ViewUsersRestrictions) ([]*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetByNames(names, viewRestrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetByRemoteID(remoteID string, groupSource model.GroupSource) (*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetByRemoteID(remoteID, groupSource)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetByUser(userID string, opts model.GroupSearchOpts) ([]*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetByUser(userID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetGroupSyncable(groupID string, syncableID string, syncableType model.GroupSyncableType) (*model.GroupSyncable, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetGroupSyncable(groupID, syncableID, syncableType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetGroups(page int, perPage int, opts model.GroupSearchOpts, viewRestrictions *model.ViewUsersRestrictions) ([]*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetGroups(page, perPage, opts, viewRestrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetGroupsAssociatedToChannelsByTeam(teamID string, opts model.GroupSearchOpts) (map[string][]*model.GroupWithSchemeAdmin, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetGroupsAssociatedToChannelsByTeam(teamID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetGroupsByChannel(channelID string, opts model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetGroupsByChannel(channelID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetGroupsByTeam(teamID string, opts model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetGroupsByTeam(teamID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetMember(groupID string, userID string) (*model.GroupMember, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetMember(groupID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetMemberCount(groupID string) (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetMemberCount(groupID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetMemberCountWithRestrictions(groupID string, viewRestrictions *model.ViewUsersRestrictions) (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetMemberCountWithRestrictions(groupID, viewRestrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetMemberUsers(groupID string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetMemberUsers(groupID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetMemberUsersInTeam(groupID string, teamID string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetMemberUsersInTeam(groupID, teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetMemberUsersNotInChannel(groupID string, channelID string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetMemberUsersNotInChannel(groupID, channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetMemberUsersPage(groupID string, page int, perPage int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetMemberUsersPage(groupID, page, perPage, viewRestrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetMemberUsersSortedPage(groupID string, page int, perPage int, viewRestrictions *model.ViewUsersRestrictions, teammateNameDisplay string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetMemberUsersSortedPage(groupID, page, perPage, viewRestrictions, teammateNameDisplay)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetNonMemberUsersPage(groupID string, page int, perPage int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetNonMemberUsersPage(groupID, page, perPage, viewRestrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GroupChannelCount() (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GroupChannelCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GroupCount() (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GroupCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GroupCountBySource(source model.GroupSource) (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GroupCountBySource(source)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GroupCountWithAllowReference() (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GroupCountWithAllowReference()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GroupMemberCount() (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GroupMemberCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GroupTeamCount() (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GroupTeamCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) PermanentDeleteMembersByUser(userID string) error {

	tries := 0
	for {
		err := s.GroupStore.PermanentDeleteMembersByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) PermittedSyncableAdmins(syncableID string, syncableType model.GroupSyncableType) ([]string, error) {

	tries := 0
	for {
		result, err := s.GroupStore.PermittedSyncableAdmins(syncableID, syncableType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) Restore(groupID string) (*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.Restore(groupID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) TeamMembersMinusGroupMembers(teamID string, groupIDs []string, page int, perPage int) ([]*model.UserWithGroups, error) {

	tries := 0
	for {
		result, err := s.GroupStore.TeamMembersMinusGroupMembers(teamID, groupIDs, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) TeamMembersToAdd(since int64, teamID *string, reAddRemovedMembers bool) ([]*model.UserTeamIDPair, error) {

	tries := 0
	for {
		result, err := s.GroupStore.TeamMembersToAdd(since, teamID, reAddRemovedMembers)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) TeamMembersToRemove(teamID *string) ([]*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.GroupStore.TeamMembersToRemove(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) Update(group *model.Group) (*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.Update(group)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) UpdateGroupSyncable(groupSyncable *model.GroupSyncable) (*model.GroupSyncable, error) {

	tries := 0
	for {
		result, err := s.GroupStore.UpdateGroupSyncable(groupSyncable)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) UpsertMember(groupID string, userID string) (*model.GroupMember, error) {

	tries := 0
	for {
		result, err := s.GroupStore.UpsertMember(groupID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) UpsertMembers(groupID string, userIDs []string) ([]*model.GroupMember, error) {

	tries := 0
	for {
		result, err := s.GroupStore.UpsertMembers(groupID, userIDs)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) Cleanup(expiryTime int64, batchSize int) error {

	tries := 0
	for {
		err := s.JobStore.Cleanup(expiryTime, batchSize)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) Delete(id string) (string, error) {

	tries := 0
	for {
		result, err := s.JobStore.Delete(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) Get(rctx request.CTX, id string) (*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.Get(rctx, id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetAllByStatus(rctx request.CTX, status string) ([]*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetAllByStatus(rctx, status)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetAllByType(rctx request.CTX, jobType string) ([]*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetAllByType(rctx, jobType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetAllByTypeAndStatus(rctx request.CTX, jobType string, status string) ([]*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetAllByTypeAndStatus(rctx, jobType, status)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetAllByTypePage(rctx request.CTX, jobType string, offset int, limit int) ([]*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetAllByTypePage(rctx, jobType, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetAllByTypesAndStatusesPage(rctx request.CTX, jobType []string, status []string, offset int, limit int) ([]*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetAllByTypesAndStatusesPage(rctx, jobType, status, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetAllByTypesPage(rctx request.CTX, jobTypes []string, offset int, limit int) ([]*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetAllByTypesPage(rctx, jobTypes, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetByTypeAndData(rctx request.CTX, jobType string, data map[string]string, useMaster bool, statuses ...string) ([]*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetByTypeAndData(rctx, jobType, data, useMaster, statuses...)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetCountByStatusAndType(status string, jobType string) (int64, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetCountByStatusAndType(status, jobType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetNewestJobByStatusAndType(status string, jobType string) (*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetNewestJobByStatusAndType(status, jobType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetNewestJobByStatusesAndType(statuses []string, jobType string) (*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetNewestJobByStatusesAndType(statuses, jobType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) Save(job *model.Job) (*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.Save(job)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) SaveOnce(job *model.Job) (*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.SaveOnce(job)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) UpdateOptimistically(job *model.Job, currentStatus string) (bool, error) {

	tries := 0
	for {
		result, err := s.JobStore.UpdateOptimistically(job, currentStatus)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) UpdateStatus(id string, status string) (*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.UpdateStatus(id, status)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) UpdateStatusOptimistically(id string, currentStatus string, newStatus string) (*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.UpdateStatusOptimistically(id, currentStatus, newStatus)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerLicenseStore) Get(rctx request.CTX, id string) (*model.LicenseRecord, error) {

	tries := 0
	for {
		result, err := s.LicenseStore.Get(rctx, id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerLicenseStore) GetAll() ([]*model.LicenseRecord, error) {

	tries := 0
	for {
		result, err := s.LicenseStore.GetAll()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerLicenseStore) Save(license *model.LicenseRecord) error {

	tries := 0
	for {
		err := s.LicenseStore.Save(license)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerLinkMetadataStore) Get(url string, timestamp int64) (*model.LinkMetadata, error) {

	tries := 0
	for {
		result, err := s.LinkMetadataStore.Get(url, timestamp)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerLinkMetadataStore) Save(linkMetadata *model.LinkMetadata) (*model.LinkMetadata, error) {

	tries := 0
	for {
		result, err := s.LinkMetadataStore.Save(linkMetadata)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerNotifyAdminStore) DeleteBefore(trial bool, now int64) error {

	tries := 0
	for {
		err := s.NotifyAdminStore.DeleteBefore(trial, now)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerNotifyAdminStore) Get(trial bool) ([]*model.NotifyAdminData, error) {

	tries := 0
	for {
		result, err := s.NotifyAdminStore.Get(trial)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerNotifyAdminStore) GetDataByUserIdAndFeature(userID string, feature model.MattermostFeature) ([]*model.NotifyAdminData, error) {

	tries := 0
	for {
		result, err := s.NotifyAdminStore.GetDataByUserIdAndFeature(userID, feature)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerNotifyAdminStore) Save(data *model.NotifyAdminData) (*model.NotifyAdminData, error) {

	tries := 0
	for {
		result, err := s.NotifyAdminStore.Save(data)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerNotifyAdminStore) Update(userID string, requiredPlan string, requiredFeature model.MattermostFeature, now int64) error {

	tries := 0
	for {
		err := s.NotifyAdminStore.Update(userID, requiredPlan, requiredFeature, now)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) DeleteApp(id string) error {

	tries := 0
	for {
		err := s.OAuthStore.DeleteApp(id)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetAccessData(token string) (*model.AccessData, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetAccessData(token)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetAccessDataByRefreshToken(token string) (*model.AccessData, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetAccessDataByRefreshToken(token)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetAccessDataByUserForApp(userID string, clientID string) ([]*model.AccessData, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetAccessDataByUserForApp(userID, clientID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetApp(id string) (*model.OAuthApp, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetApp(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetAppByUser(userID string, offset int, limit int) ([]*model.OAuthApp, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetAppByUser(userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetApps(offset int, limit int) ([]*model.OAuthApp, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetApps(offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetAuthData(code string) (*model.AuthData, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetAuthData(code)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetAuthorizedApps(userID string, offset int, limit int) ([]*model.OAuthApp, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetAuthorizedApps(userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetPreviousAccessData(userID string, clientID string) (*model.AccessData, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetPreviousAccessData(userID, clientID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) PermanentDeleteAuthDataByUser(userID string) error {

	tries := 0
	for {
		err := s.OAuthStore.PermanentDeleteAuthDataByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) RemoveAccessData(token string) error {

	tries := 0
	for {
		err := s.OAuthStore.RemoveAccessData(token)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) RemoveAllAccessData() error {

	tries := 0
	for {
		err := s.OAuthStore.RemoveAllAccessData()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) RemoveAuthData(code string) error {

	tries := 0
	for {
		err := s.OAuthStore.RemoveAuthData(code)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) RemoveAuthDataByClientId(clientID string, userID string) error {

	tries := 0
	for {
		err := s.OAuthStore.RemoveAuthDataByClientId(clientID, userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) RemoveAuthDataByUserId(userID string) error {

	tries := 0
	for {
		err := s.OAuthStore.RemoveAuthDataByUserId(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) SaveAccessData(accessData *model.AccessData) (*model.AccessData, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.SaveAccessData(accessData)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) SaveApp(app *model.OAuthApp) (*model.OAuthApp, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.SaveApp(app)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) SaveAuthData(authData *model.AuthData) (*model.AuthData, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.SaveAuthData(authData)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) UpdateAccessData(accessData *model.AccessData) (*model.AccessData, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.UpdateAccessData(accessData)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) UpdateApp(app *model.OAuthApp) (*model.OAuthApp, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.UpdateApp(app)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOutgoingOAuthConnectionStore) DeleteConnection(rctx request.CTX, id string) error {

	tries := 0
	for {
		err := s.OutgoingOAuthConnectionStore.DeleteConnection(rctx, id)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOutgoingOAuthConnectionStore) GetConnection(rctx request.CTX, id string) (*model.OutgoingOAuthConnection, error) {

	tries := 0
	for {
		result, err := s.OutgoingOAuthConnectionStore.GetConnection(rctx, id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOutgoingOAuthConnectionStore) GetConnections(rctx request.CTX, filters model.OutgoingOAuthConnectionGetConnectionsFilter) ([]*model.OutgoingOAuthConnection, error) {

	tries := 0
	for {
		result, err := s.OutgoingOAuthConnectionStore.GetConnections(rctx, filters)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOutgoingOAuthConnectionStore) SaveConnection(rctx request.CTX, conn *model.OutgoingOAuthConnection) (*model.OutgoingOAuthConnection, error) {

	tries := 0
	for {
		result, err := s.OutgoingOAuthConnectionStore.SaveConnection(rctx, conn)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOutgoingOAuthConnectionStore) UpdateConnection(rctx request.CTX, conn *model.OutgoingOAuthConnection) (*model.OutgoingOAuthConnection, error) {

	tries := 0
	for {
		result, err := s.OutgoingOAuthConnectionStore.UpdateConnection(rctx, conn)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) CompareAndDelete(keyVal *model.PluginKeyValue, oldValue []byte) (bool, error) {

	tries := 0
	for {
		result, err := s.PluginStore.CompareAndDelete(keyVal, oldValue)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) CompareAndSet(keyVal *model.PluginKeyValue, oldValue []byte) (bool, error) {

	tries := 0
	for {
		result, err := s.PluginStore.CompareAndSet(keyVal, oldValue)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) Delete(pluginID string, key string) error {

	tries := 0
	for {
		err := s.PluginStore.Delete(pluginID, key)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) DeleteAllExpired() error {

	tries := 0
	for {
		err := s.PluginStore.DeleteAllExpired()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) DeleteAllForPlugin(PluginID string) error {

	tries := 0
	for {
		err := s.PluginStore.DeleteAllForPlugin(PluginID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) Get(pluginID string, key string) (*model.PluginKeyValue, error) {

	tries := 0
	for {
		result, err := s.PluginStore.Get(pluginID, key)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) List(pluginID string, page int, perPage int) ([]string, error) {

	tries := 0
	for {
		result, err := s.PluginStore.List(pluginID, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) SaveOrUpdate(keyVal *model.PluginKeyValue) (*model.PluginKeyValue, error) {

	tries := 0
	for {
		result, err := s.PluginStore.SaveOrUpdate(keyVal)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) SetWithOptions(pluginID string, key string, value []byte, options model.PluginKVSetOptions) (bool, error) {

	tries := 0
	for {
		result, err := s.PluginStore.SetWithOptions(pluginID, key, value, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) AnalyticsPostCount(options *model.PostCountOptions) (int64, error) {

	tries := 0
	for {
		result, err := s.PostStore.AnalyticsPostCount(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) AnalyticsPostCountByTeam(teamID string) (int64, error) {

	tries := 0
	for {
		result, err := s.PostStore.AnalyticsPostCountByTeam(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) AnalyticsPostCountsByDay(options *model.AnalyticsPostCountsOptions) (model.AnalyticsRows, error) {

	tries := 0
	for {
		result, err := s.PostStore.AnalyticsPostCountsByDay(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) AnalyticsUserCountsWithPostsByDay(teamID string) (model.AnalyticsRows, error) {

	tries := 0
	for {
		result, err := s.PostStore.AnalyticsUserCountsWithPostsByDay(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) ClearCaches() {

	s.PostStore.ClearCaches()

}

func (s *RetryLayerPostStore) Delete(rctx request.CTX, postID string, timestamp int64, deleteByID string) error {

	tries := 0
	for {
		err := s.PostStore.Delete(rctx, postID, timestamp, deleteByID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) DeleteAllPostRemindersForPost(postId string) error {

	tries := 0
	for {
		err := s.PostStore.DeleteAllPostRemindersForPost(postId)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) Get(rctx request.CTX, id string, opts model.GetPostsOptions, userID string, sanitizeOptions map[string]bool) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.Get(rctx, id, opts, userID, sanitizeOptions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetDirectPostParentsForExportAfter(limit int, afterID string, includeArchivedChannels bool) ([]*model.DirectPostForExport, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetDirectPostParentsForExportAfter(limit, afterID, includeArchivedChannels)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetEditHistoryForPost(postID string) ([]*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetEditHistoryForPost(postID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetEtag(channelID string, allowFromCache bool, collapsedThreads bool) string {

	return s.PostStore.GetEtag(channelID, allowFromCache, collapsedThreads)

}

func (s *RetryLayerPostStore) GetFlaggedPosts(userID string, offset int, limit int) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetFlaggedPosts(userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetFlaggedPostsForChannel(userID string, channelID string, offset int, limit int) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetFlaggedPostsForChannel(userID, channelID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetFlaggedPostsForTeam(userID string, teamID string, offset int, limit int) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetFlaggedPostsForTeam(userID, teamID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetMaxPostSize() int {

	return s.PostStore.GetMaxPostSize()

}

func (s *RetryLayerPostStore) GetNthRecentPostTime(n int64) (int64, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetNthRecentPostTime(n)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetOldest() (*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetOldest()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetOldestEntityCreationTime() (int64, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetOldestEntityCreationTime()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetParentsForExportAfter(limit int, afterID string, includeArchivedChannels bool) ([]*model.PostForExport, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetParentsForExportAfter(limit, afterID, includeArchivedChannels)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostAfterTime(channelID string, timestamp int64, collapsedThreads bool) (*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostAfterTime(channelID, timestamp, collapsedThreads)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostIdAfterTime(channelID string, timestamp int64, collapsedThreads bool) (string, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostIdAfterTime(channelID, timestamp, collapsedThreads)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostIdBeforeTime(channelID string, timestamp int64, collapsedThreads bool) (string, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostIdBeforeTime(channelID, timestamp, collapsedThreads)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostReminderMetadata(postID string) (*store.PostReminderMetadata, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostReminderMetadata(postID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostReminders(now int64) ([]*model.PostReminder, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostReminders(now)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPosts(rctx request.CTX, options model.GetPostsOptions, allowFromCache bool, sanitizeOptions map[string]bool) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPosts(rctx, options, allowFromCache, sanitizeOptions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostsAfter(rctx request.CTX, options model.GetPostsOptions, sanitizeOptions map[string]bool) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostsAfter(rctx, options, sanitizeOptions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostsBatchForIndexing(startTime int64, startPostID string, limit int) ([]*model.PostForIndexing, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostsBatchForIndexing(startTime, startPostID, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostsBefore(rctx request.CTX, options model.GetPostsOptions, sanitizeOptions map[string]bool) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostsBefore(rctx, options, sanitizeOptions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostsByIds(postIds []string) ([]*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostsByIds(postIds)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostsByThread(threadID string, since int64) ([]*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostsByThread(threadID, since)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostsCreatedAt(channelID string, timestamp int64) ([]*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostsCreatedAt(channelID, timestamp)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostsSince(rctx request.CTX, options model.GetPostsSinceOptions, allowFromCache bool, sanitizeOptions map[string]bool) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostsSince(rctx, options, allowFromCache, sanitizeOptions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostsSinceForSync(options model.GetPostsSinceForSyncOptions, cursor model.GetPostsSinceForSyncCursor, limit int) ([]*model.Post, model.GetPostsSinceForSyncCursor, error) {

	tries := 0
	for {
		result, resultVar1, err := s.PostStore.GetPostsSinceForSync(options, cursor, limit)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetRepliesForExport(parentID string) ([]*model.ReplyForExport, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetRepliesForExport(parentID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetSingle(rctx request.CTX, id string, inclDeleted bool) (*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetSingle(rctx, id, inclDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) HasAutoResponsePostByUserSince(options model.GetPostsSinceOptions, userID string) (bool, error) {

	tries := 0
	for {
		result, err := s.PostStore.HasAutoResponsePostByUserSince(options, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) InvalidateLastPostTimeCache(channelID string) {

	s.PostStore.InvalidateLastPostTimeCache(channelID)

}

func (s *RetryLayerPostStore) Overwrite(rctx request.CTX, post *model.Post) (*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.Overwrite(rctx, post)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) OverwriteMultiple(rctx request.CTX, posts []*model.Post) ([]*model.Post, int, error) {

	tries := 0
	for {
		result, resultVar1, err := s.PostStore.OverwriteMultiple(rctx, posts)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) PermanentDelete(rctx request.CTX, postID string) error {

	tries := 0
	for {
		err := s.PostStore.PermanentDelete(rctx, postID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) PermanentDeleteBatch(endTime int64, limit int64) (int64, error) {

	tries := 0
	for {
		result, err := s.PostStore.PermanentDeleteBatch(endTime, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) PermanentDeleteBatchForRetentionPolicies(retentionPolicyBatchConfigs model.RetentionPolicyBatchConfigs, cursor model.RetentionPolicyCursor) (int64, model.RetentionPolicyCursor, error) {

	tries := 0
	for {
		result, resultVar1, err := s.PostStore.PermanentDeleteBatchForRetentionPolicies(retentionPolicyBatchConfigs, cursor)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) PermanentDeleteByChannel(rctx request.CTX, channelID string) error {

	tries := 0
	for {
		err := s.PostStore.PermanentDeleteByChannel(rctx, channelID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) PermanentDeleteByUser(rctx request.CTX, userID string) error {

	tries := 0
	for {
		err := s.PostStore.PermanentDeleteByUser(rctx, userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) RefreshPostStats() error {

	tries := 0
	for {
		err := s.PostStore.RefreshPostStats()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) RestoreContentFlaggedPost(post *model.Post, deletedBy string, statusFieldId string) error {

	tries := 0
	for {
		err := s.PostStore.RestoreContentFlaggedPost(post, deletedBy, statusFieldId)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) Save(rctx request.CTX, post *model.Post) (*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.Save(rctx, post)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) SaveMultiple(rctx request.CTX, posts []*model.Post) ([]*model.Post, int, error) {

	tries := 0
	for {
		result, resultVar1, err := s.PostStore.SaveMultiple(rctx, posts)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) Search(teamID string, userID string, params *model.SearchParams) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.Search(teamID, userID, params)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) SearchPostsForUser(rctx request.CTX, paramsList []*model.SearchParams, userID string, teamID string, page int, perPage int) (*model.PostSearchResults, error) {

	tries := 0
	for {
		result, err := s.PostStore.SearchPostsForUser(rctx, paramsList, userID, teamID, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) SetPostReminder(reminder *model.PostReminder) error {

	tries := 0
	for {
		err := s.PostStore.SetPostReminder(reminder)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) Update(rctx request.CTX, newPost *model.Post, oldPost *model.Post) (*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.Update(rctx, newPost, oldPost)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostAcknowledgementStore) BatchDelete(acknowledgements []*model.PostAcknowledgement) error {

	tries := 0
	for {
		err := s.PostAcknowledgementStore.BatchDelete(acknowledgements)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostAcknowledgementStore) BatchSave(acknowledgements []*model.PostAcknowledgement) ([]*model.PostAcknowledgement, error) {

	tries := 0
	for {
		result, err := s.PostAcknowledgementStore.BatchSave(acknowledgements)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostAcknowledgementStore) Delete(acknowledgement *model.PostAcknowledgement) error {

	tries := 0
	for {
		err := s.PostAcknowledgementStore.Delete(acknowledgement)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostAcknowledgementStore) DeleteAllForPost(postID string) error {

	tries := 0
	for {
		err := s.PostAcknowledgementStore.DeleteAllForPost(postID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostAcknowledgementStore) Get(postID string, userID string) (*model.PostAcknowledgement, error) {

	tries := 0
	for {
		result, err := s.PostAcknowledgementStore.Get(postID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostAcknowledgementStore) GetForPost(postID string) ([]*model.PostAcknowledgement, error) {

	tries := 0
	for {
		result, err := s.PostAcknowledgementStore.GetForPost(postID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostAcknowledgementStore) GetForPostSince(postID string, since int64, excludeRemoteID string, inclDeleted bool) ([]*model.PostAcknowledgement, error) {

	tries := 0
	for {
		result, err := s.PostAcknowledgementStore.GetForPostSince(postID, since, excludeRemoteID, inclDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostAcknowledgementStore) GetForPosts(postIds []string) ([]*model.PostAcknowledgement, error) {

	tries := 0
	for {
		result, err := s.PostAcknowledgementStore.GetForPosts(postIds)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostAcknowledgementStore) GetSingle(userID string, postID string, remoteID string) (*model.PostAcknowledgement, error) {

	tries := 0
	for {
		result, err := s.PostAcknowledgementStore.GetSingle(userID, postID, remoteID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostAcknowledgementStore) SaveWithModel(acknowledgement *model.PostAcknowledgement) (*model.PostAcknowledgement, error) {

	tries := 0
	for {
		result, err := s.PostAcknowledgementStore.SaveWithModel(acknowledgement)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostPersistentNotificationStore) Delete(postIds []string) error {

	tries := 0
	for {
		err := s.PostPersistentNotificationStore.Delete(postIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostPersistentNotificationStore) DeleteByChannel(channelIds []string) error {

	tries := 0
	for {
		err := s.PostPersistentNotificationStore.DeleteByChannel(channelIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostPersistentNotificationStore) DeleteByTeam(teamIds []string) error {

	tries := 0
	for {
		err := s.PostPersistentNotificationStore.DeleteByTeam(teamIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostPersistentNotificationStore) DeleteExpired(maxSentCount int16) error {

	tries := 0
	for {
		err := s.PostPersistentNotificationStore.DeleteExpired(maxSentCount)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostPersistentNotificationStore) Get(params model.GetPersistentNotificationsPostsParams) ([]*model.PostPersistentNotifications, error) {

	tries := 0
	for {
		result, err := s.PostPersistentNotificationStore.Get(params)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostPersistentNotificationStore) GetSingle(postID string) (*model.PostPersistentNotifications, error) {

	tries := 0
	for {
		result, err := s.PostPersistentNotificationStore.GetSingle(postID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostPersistentNotificationStore) UpdateLastActivity(postIds []string) error {

	tries := 0
	for {
		err := s.PostPersistentNotificationStore.UpdateLastActivity(postIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostPriorityStore) Delete(postID string) error {

	tries := 0
	for {
		err := s.PostPriorityStore.Delete(postID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostPriorityStore) GetForPost(postID string) (*model.PostPriority, error) {

	tries := 0
	for {
		result, err := s.PostPriorityStore.GetForPost(postID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostPriorityStore) GetForPosts(ids []string) ([]*model.PostPriority, error) {

	tries := 0
	for {
		result, err := s.PostPriorityStore.GetForPosts(ids)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostPriorityStore) Save(priority *model.PostPriority) (*model.PostPriority, error) {

	tries := 0
	for {
		result, err := s.PostPriorityStore.Save(priority)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) CleanupFlagsBatch(limit int64) (int64, error) {

	tries := 0
	for {
		result, err := s.PreferenceStore.CleanupFlagsBatch(limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) Delete(userID string, category string, name string) error {

	tries := 0
	for {
		err := s.PreferenceStore.Delete(userID, category, name)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) DeleteCategory(userID string, category string) error {

	tries := 0
	for {
		err := s.PreferenceStore.DeleteCategory(userID, category)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) DeleteCategoryAndName(category string, name string) error {

	tries := 0
	for {
		err := s.PreferenceStore.DeleteCategoryAndName(category, name)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) DeleteInvalidVisibleDmsGms() (int64, error) {

	tries := 0
	for {
		result, err := s.PreferenceStore.DeleteInvalidVisibleDmsGms()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) DeleteOrphanedRows(limit int) (int64, error) {

	tries := 0
	for {
		result, err := s.PreferenceStore.DeleteOrphanedRows(limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) Get(userID string, category string, name string) (*model.Preference, error) {

	tries := 0
	for {
		result, err := s.PreferenceStore.Get(userID, category, name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) GetAll(userID string) (model.Preferences, error) {

	tries := 0
	for {
		result, err := s.PreferenceStore.GetAll(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) GetCategory(userID string, category string) (model.Preferences, error) {

	tries := 0
	for {
		result, err := s.PreferenceStore.GetCategory(userID, category)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) GetCategoryAndName(category string, name string) (model.Preferences, error) {

	tries := 0
	for {
		result, err := s.PreferenceStore.GetCategoryAndName(category, name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) PermanentDeleteByUser(userID string) error {

	tries := 0
	for {
		err := s.PreferenceStore.PermanentDeleteByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) Save(preferences model.Preferences) error {

	tries := 0
	for {
		err := s.PreferenceStore.Save(preferences)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerProductNoticesStore) Clear(notices []string) error {

	tries := 0
	for {
		err := s.ProductNoticesStore.Clear(notices)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerProductNoticesStore) ClearOldNotices(currentNotices model.ProductNotices) error {

	tries := 0
	for {
		err := s.ProductNoticesStore.ClearOldNotices(currentNotices)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerProductNoticesStore) GetViews(userID string) ([]model.ProductNoticeViewState, error) {

	tries := 0
	for {
		result, err := s.ProductNoticesStore.GetViews(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerProductNoticesStore) View(userID string, notices []string) error {

	tries := 0
	for {
		err := s.ProductNoticesStore.View(userID, notices)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyFieldStore) CountForGroup(groupID string, includeDeleted bool) (int64, error) {

	tries := 0
	for {
		result, err := s.PropertyFieldStore.CountForGroup(groupID, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyFieldStore) CountForTarget(groupID string, targetType string, targetID string, includeDeleted bool) (int64, error) {

	tries := 0
	for {
		result, err := s.PropertyFieldStore.CountForTarget(groupID, targetType, targetID, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyFieldStore) Create(field *model.PropertyField) (*model.PropertyField, error) {

	tries := 0
	for {
		result, err := s.PropertyFieldStore.Create(field)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyFieldStore) Delete(groupID string, id string) error {

	tries := 0
	for {
		err := s.PropertyFieldStore.Delete(groupID, id)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyFieldStore) Get(groupID string, id string) (*model.PropertyField, error) {

	tries := 0
	for {
		result, err := s.PropertyFieldStore.Get(groupID, id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyFieldStore) GetFieldByName(groupID string, targetID string, name string) (*model.PropertyField, error) {

	tries := 0
	for {
		result, err := s.PropertyFieldStore.GetFieldByName(groupID, targetID, name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyFieldStore) GetMany(groupID string, ids []string) ([]*model.PropertyField, error) {

	tries := 0
	for {
		result, err := s.PropertyFieldStore.GetMany(groupID, ids)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyFieldStore) SearchPropertyFields(opts model.PropertyFieldSearchOpts) ([]*model.PropertyField, error) {

	tries := 0
	for {
		result, err := s.PropertyFieldStore.SearchPropertyFields(opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyFieldStore) Update(groupID string, fields []*model.PropertyField) ([]*model.PropertyField, error) {

	tries := 0
	for {
		result, err := s.PropertyFieldStore.Update(groupID, fields)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyGroupStore) Get(name string) (*model.PropertyGroup, error) {

	tries := 0
	for {
		result, err := s.PropertyGroupStore.Get(name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyGroupStore) Register(name string) (*model.PropertyGroup, error) {

	tries := 0
	for {
		result, err := s.PropertyGroupStore.Register(name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyValueStore) Create(value *model.PropertyValue) (*model.PropertyValue, error) {

	tries := 0
	for {
		result, err := s.PropertyValueStore.Create(value)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyValueStore) CreateMany(values []*model.PropertyValue) ([]*model.PropertyValue, error) {

	tries := 0
	for {
		result, err := s.PropertyValueStore.CreateMany(values)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyValueStore) Delete(groupID string, id string) error {

	tries := 0
	for {
		err := s.PropertyValueStore.Delete(groupID, id)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyValueStore) DeleteForField(groupID string, fieldID string) error {

	tries := 0
	for {
		err := s.PropertyValueStore.DeleteForField(groupID, fieldID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyValueStore) DeleteForTarget(groupID string, targetType string, targetID string) error {

	tries := 0
	for {
		err := s.PropertyValueStore.DeleteForTarget(groupID, targetType, targetID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyValueStore) Get(groupID string, id string) (*model.PropertyValue, error) {

	tries := 0
	for {
		result, err := s.PropertyValueStore.Get(groupID, id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyValueStore) GetMany(groupID string, ids []string) ([]*model.PropertyValue, error) {

	tries := 0
	for {
		result, err := s.PropertyValueStore.GetMany(groupID, ids)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyValueStore) SearchPropertyValues(opts model.PropertyValueSearchOpts) ([]*model.PropertyValue, error) {

	tries := 0
	for {
		result, err := s.PropertyValueStore.SearchPropertyValues(opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyValueStore) Update(groupID string, values []*model.PropertyValue) ([]*model.PropertyValue, error) {

	tries := 0
	for {
		result, err := s.PropertyValueStore.Update(groupID, values)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPropertyValueStore) Upsert(values []*model.PropertyValue) ([]*model.PropertyValue, error) {

	tries := 0
	for {
		result, err := s.PropertyValueStore.Upsert(values)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) BulkGetForPosts(postIds []string) ([]*model.Reaction, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.BulkGetForPosts(postIds)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) Delete(reaction *model.Reaction) (*model.Reaction, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.Delete(reaction)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) DeleteAllWithEmojiName(emojiName string) error {

	tries := 0
	for {
		err := s.ReactionStore.DeleteAllWithEmojiName(emojiName)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) DeleteOrphanedRowsByIds(r *model.RetentionIdsForDeletion) (int64, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.DeleteOrphanedRowsByIds(r)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) ExistsOnPost(postID string, emojiName string) (bool, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.ExistsOnPost(postID, emojiName)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) GetForPost(postID string, allowFromCache bool) ([]*model.Reaction, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.GetForPost(postID, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) GetForPostSince(postID string, since int64, excludeRemoteID string, inclDeleted bool) ([]*model.Reaction, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.GetForPostSince(postID, since, excludeRemoteID, inclDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) GetSingle(userID string, postID string, remoteID string, emojiName string) (*model.Reaction, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.GetSingle(userID, postID, remoteID, emojiName)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) GetUniqueCountForPost(postID string) (int, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.GetUniqueCountForPost(postID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) PermanentDeleteBatch(endTime int64, limit int64) (int64, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.PermanentDeleteBatch(endTime, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) PermanentDeleteByUser(userID string) error {

	tries := 0
	for {
		err := s.ReactionStore.PermanentDeleteByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) Save(reaction *model.Reaction) (*model.Reaction, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.Save(reaction)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRemoteClusterStore) Delete(remoteClusterID string) (bool, error) {

	tries := 0
	for {
		result, err := s.RemoteClusterStore.Delete(remoteClusterID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRemoteClusterStore) Get(remoteClusterID string, includeDeleted bool) (*model.RemoteCluster, error) {

	tries := 0
	for {
		result, err := s.RemoteClusterStore.Get(remoteClusterID, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRemoteClusterStore) GetAll(offset int, limit int, filter model.RemoteClusterQueryFilter) ([]*model.RemoteCluster, error) {

	tries := 0
	for {
		result, err := s.RemoteClusterStore.GetAll(offset, limit, filter)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRemoteClusterStore) GetByPluginID(pluginID string) (*model.RemoteCluster, error) {

	tries := 0
	for {
		result, err := s.RemoteClusterStore.GetByPluginID(pluginID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRemoteClusterStore) Save(rc *model.RemoteCluster) (*model.RemoteCluster, error) {

	tries := 0
	for {
		result, err := s.RemoteClusterStore.Save(rc)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRemoteClusterStore) SetLastPingAt(remoteClusterID string) error {

	tries := 0
	for {
		err := s.RemoteClusterStore.SetLastPingAt(remoteClusterID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRemoteClusterStore) Update(rc *model.RemoteCluster) (*model.RemoteCluster, error) {

	tries := 0
	for {
		result, err := s.RemoteClusterStore.Update(rc)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRemoteClusterStore) UpdateLastGlobalUserSyncAt(remoteID string, syncAt int64) error {

	tries := 0
	for {
		err := s.RemoteClusterStore.UpdateLastGlobalUserSyncAt(remoteID, syncAt)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRemoteClusterStore) UpdateTopics(remoteClusterID string, topics string) (*model.RemoteCluster, error) {

	tries := 0
	for {
		result, err := s.RemoteClusterStore.UpdateTopics(remoteClusterID, topics)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) AddChannels(policyID string, channelIds []string) error {

	tries := 0
	for {
		err := s.RetentionPolicyStore.AddChannels(policyID, channelIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) AddTeams(policyID string, teamIds []string) error {

	tries := 0
	for {
		err := s.RetentionPolicyStore.AddTeams(policyID, teamIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) Delete(id string) error {

	tries := 0
	for {
		err := s.RetentionPolicyStore.Delete(id)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) DeleteOrphanedRows(limit int) (int64, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.DeleteOrphanedRows(limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) Get(id string) (*model.RetentionPolicyWithTeamAndChannelCounts, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.Get(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetAll(offset int, limit int) ([]*model.RetentionPolicyWithTeamAndChannelCounts, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetAll(offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetChannelPoliciesCountForUser(userID string) (int64, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetChannelPoliciesCountForUser(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetChannelPoliciesForUser(userID string, offset int, limit int) ([]*model.RetentionPolicyForChannel, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetChannelPoliciesForUser(userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetChannels(policyID string, offset int, limit int) (model.ChannelListWithTeamData, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetChannels(policyID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetChannelsCount(policyID string) (int64, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetChannelsCount(policyID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetCount() (int64, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetIdsForDeletionByTableName(tableName string, limit int) ([]*model.RetentionIdsForDeletion, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetIdsForDeletionByTableName(tableName, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetTeamPoliciesCountForUser(userID string) (int64, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetTeamPoliciesCountForUser(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetTeamPoliciesForUser(userID string, offset int, limit int) ([]*model.RetentionPolicyForTeam, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetTeamPoliciesForUser(userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetTeams(policyID string, offset int, limit int) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetTeams(policyID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetTeamsCount(policyID string) (int64, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetTeamsCount(policyID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) Patch(patch *model.RetentionPolicyWithTeamAndChannelIDs) (*model.RetentionPolicyWithTeamAndChannelCounts, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.Patch(patch)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) RemoveChannels(policyID string, channelIds []string) error {

	tries := 0
	for {
		err := s.RetentionPolicyStore.RemoveChannels(policyID, channelIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) RemoveTeams(policyID string, teamIds []string) error {

	tries := 0
	for {
		err := s.RetentionPolicyStore.RemoveTeams(policyID, teamIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) Save(policy *model.RetentionPolicyWithTeamAndChannelIDs) (*model.RetentionPolicyWithTeamAndChannelCounts, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.Save(policy)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) AllChannelSchemeRoles() ([]*model.Role, error) {

	tries := 0
	for {
		result, err := s.RoleStore.AllChannelSchemeRoles()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) ChannelHigherScopedPermissions(roleNames []string) (map[string]*model.RolePermissions, error) {

	tries := 0
	for {
		result, err := s.RoleStore.ChannelHigherScopedPermissions(roleNames)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) ChannelRolesUnderTeamRole(roleName string) ([]*model.Role, error) {

	tries := 0
	for {
		result, err := s.RoleStore.ChannelRolesUnderTeamRole(roleName)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) Delete(roleID string) (*model.Role, error) {

	tries := 0
	for {
		result, err := s.RoleStore.Delete(roleID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) Get(roleID string) (*model.Role, error) {

	tries := 0
	for {
		result, err := s.RoleStore.Get(roleID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) GetAll() ([]*model.Role, error) {

	tries := 0
	for {
		result, err := s.RoleStore.GetAll()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) GetByName(ctx context.Context, name string) (*model.Role, error) {

	tries := 0
	for {
		result, err := s.RoleStore.GetByName(ctx, name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) GetByNames(names []string) ([]*model.Role, error) {

	tries := 0
	for {
		result, err := s.RoleStore.GetByNames(names)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) PermanentDeleteAll() error {

	tries := 0
	for {
		err := s.RoleStore.PermanentDeleteAll()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) Save(role *model.Role) (*model.Role, error) {

	tries := 0
	for {
		result, err := s.RoleStore.Save(role)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerScheduledPostStore) CreateScheduledPost(scheduledPost *model.ScheduledPost) (*model.ScheduledPost, error) {

	tries := 0
	for {
		result, err := s.ScheduledPostStore.CreateScheduledPost(scheduledPost)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerScheduledPostStore) Get(scheduledPostId string) (*model.ScheduledPost, error) {

	tries := 0
	for {
		result, err := s.ScheduledPostStore.Get(scheduledPostId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerScheduledPostStore) GetMaxMessageSize() int {

	return s.ScheduledPostStore.GetMaxMessageSize()

}

func (s *RetryLayerScheduledPostStore) GetPendingScheduledPosts(beforeTime int64, afterTime int64, lastScheduledPostId string, perPage uint64) ([]*model.ScheduledPost, error) {

	tries := 0
	for {
		result, err := s.ScheduledPostStore.GetPendingScheduledPosts(beforeTime, afterTime, lastScheduledPostId, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerScheduledPostStore) GetScheduledPostsForUser(userId string, teamId string) ([]*model.ScheduledPost, error) {

	tries := 0
	for {
		result, err := s.ScheduledPostStore.GetScheduledPostsForUser(userId, teamId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerScheduledPostStore) PermanentDeleteByUser(userId string) error {

	tries := 0
	for {
		err := s.ScheduledPostStore.PermanentDeleteByUser(userId)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerScheduledPostStore) PermanentlyDeleteScheduledPosts(scheduledPostIDs []string) error {

	tries := 0
	for {
		err := s.ScheduledPostStore.PermanentlyDeleteScheduledPosts(scheduledPostIDs)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerScheduledPostStore) UpdateOldScheduledPosts(beforeTime int64) error {

	tries := 0
	for {
		err := s.ScheduledPostStore.UpdateOldScheduledPosts(beforeTime)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerScheduledPostStore) UpdatedScheduledPost(scheduledPost *model.ScheduledPost) error {

	tries := 0
	for {
		err := s.ScheduledPostStore.UpdatedScheduledPost(scheduledPost)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSchemeStore) CountByScope(scope string) (int64, error) {

	tries := 0
	for {
		result, err := s.SchemeStore.CountByScope(scope)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSchemeStore) CountWithoutPermission(scope string, permissionID string, roleScope model.RoleScope, roleType model.RoleType) (int64, error) {

	tries := 0
	for {
		result, err := s.SchemeStore.CountWithoutPermission(scope, permissionID, roleScope, roleType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSchemeStore) Delete(schemeID string) (*model.Scheme, error) {

	tries := 0
	for {
		result, err := s.SchemeStore.Delete(schemeID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSchemeStore) Get(schemeID string) (*model.Scheme, error) {

	tries := 0
	for {
		result, err := s.SchemeStore.Get(schemeID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSchemeStore) GetAllPage(scope string, offset int, limit int) ([]*model.Scheme, error) {

	tries := 0
	for {
		result, err := s.SchemeStore.GetAllPage(scope, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSchemeStore) GetByName(schemeName string) (*model.Scheme, error) {

	tries := 0
	for {
		result, err := s.SchemeStore.GetByName(schemeName)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSchemeStore) PermanentDeleteAll() error {

	tries := 0
	for {
		err := s.SchemeStore.PermanentDeleteAll()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSchemeStore) Save(scheme *model.Scheme) (*model.Scheme, error) {

	tries := 0
	for {
		result, err := s.SchemeStore.Save(scheme)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) AnalyticsSessionCount() (int64, error) {

	tries := 0
	for {
		result, err := s.SessionStore.AnalyticsSessionCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) Cleanup(expiryTime int64, batchSize int64) error {

	tries := 0
	for {
		err := s.SessionStore.Cleanup(expiryTime, batchSize)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) Get(rctx request.CTX, sessionIDOrToken string) (*model.Session, error) {

	tries := 0
	for {
		result, err := s.SessionStore.Get(rctx, sessionIDOrToken)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) GetLRUSessions(rctx request.CTX, userID string, limit uint64, offset uint64) ([]*model.Session, error) {

	tries := 0
	for {
		result, err := s.SessionStore.GetLRUSessions(rctx, userID, limit, offset)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) GetMobileSessionMetadata() ([]*model.MobileSessionMetadata, error) {

	tries := 0
	for {
		result, err := s.SessionStore.GetMobileSessionMetadata()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) GetSessions(rctx request.CTX, userID string) ([]*model.Session, error) {

	tries := 0
	for {
		result, err := s.SessionStore.GetSessions(rctx, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) GetSessionsExpired(thresholdMillis int64, mobileOnly bool, unnotifiedOnly bool) ([]*model.Session, error) {

	tries := 0
	for {
		result, err := s.SessionStore.GetSessionsExpired(thresholdMillis, mobileOnly, unnotifiedOnly)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) GetSessionsWithActiveDeviceIds(userID string) ([]*model.Session, error) {

	tries := 0
	for {
		result, err := s.SessionStore.GetSessionsWithActiveDeviceIds(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) PermanentDeleteSessionsByUser(teamID string) error {

	tries := 0
	for {
		err := s.SessionStore.PermanentDeleteSessionsByUser(teamID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) Remove(sessionIDOrToken string) error {

	tries := 0
	for {
		err := s.SessionStore.Remove(sessionIDOrToken)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) RemoveAllSessions() error {

	tries := 0
	for {
		err := s.SessionStore.RemoveAllSessions()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) Save(rctx request.CTX, session *model.Session) (*model.Session, error) {

	tries := 0
	for {
		result, err := s.SessionStore.Save(rctx, session)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) UpdateDeviceId(id string, deviceID string, expiresAt int64) (string, error) {

	tries := 0
	for {
		result, err := s.SessionStore.UpdateDeviceId(id, deviceID, expiresAt)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) UpdateExpiredNotify(sessionid string, notified bool) error {

	tries := 0
	for {
		err := s.SessionStore.UpdateExpiredNotify(sessionid, notified)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) UpdateExpiresAt(sessionID string, timestamp int64) error {

	tries := 0
	for {
		err := s.SessionStore.UpdateExpiresAt(sessionID, timestamp)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) UpdateLastActivityAt(sessionID string, timestamp int64) error {

	tries := 0
	for {
		err := s.SessionStore.UpdateLastActivityAt(sessionID, timestamp)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) UpdateProps(session *model.Session) error {

	tries := 0
	for {
		err := s.SessionStore.UpdateProps(session)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) UpdateRoles(userID string, roles string) (string, error) {

	tries := 0
	for {
		result, err := s.SessionStore.UpdateRoles(userID, roles)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) Delete(channelID string) (bool, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.Delete(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) DeleteRemote(remoteID string) (bool, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.DeleteRemote(remoteID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) Get(channelID string) (*model.SharedChannel, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.Get(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetAll(offset int, limit int, opts model.SharedChannelFilterOpts) ([]*model.SharedChannel, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetAll(offset, limit, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetAllCount(opts model.SharedChannelFilterOpts) (int64, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetAllCount(opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetAttachment(fileID string, remoteID string) (*model.SharedChannelAttachment, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetAttachment(fileID, remoteID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetRemote(id string) (*model.SharedChannelRemote, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetRemote(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetRemoteByIds(channelID string, remoteID string) (*model.SharedChannelRemote, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetRemoteByIds(channelID, remoteID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetRemoteForUser(remoteID string, userID string) (*model.RemoteCluster, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetRemoteForUser(remoteID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetRemotes(offset int, limit int, opts model.SharedChannelRemoteFilterOpts) ([]*model.SharedChannelRemote, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetRemotes(offset, limit, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetRemotesStatus(channelID string) ([]*model.SharedChannelRemoteStatus, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetRemotesStatus(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetSingleUser(userID string, channelID string, remoteID string) (*model.SharedChannelUser, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetSingleUser(userID, channelID, remoteID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetUserChanges(userID string, channelID string, afterTime int64) ([]*model.SharedChannelUser, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetUserChanges(userID, channelID, afterTime)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetUsersForSync(filter model.GetUsersForSyncFilter) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetUsersForSync(filter)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetUsersForUser(userID string) ([]*model.SharedChannelUser, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetUsersForUser(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) HasChannel(channelID string) (bool, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.HasChannel(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) HasRemote(channelID string, remoteID string) (bool, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.HasRemote(channelID, remoteID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) Save(sc *model.SharedChannel) (*model.SharedChannel, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.Save(sc)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) SaveAttachment(remote *model.SharedChannelAttachment) (*model.SharedChannelAttachment, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.SaveAttachment(remote)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) SaveRemote(remote *model.SharedChannelRemote) (*model.SharedChannelRemote, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.SaveRemote(remote)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) SaveUser(remote *model.SharedChannelUser) (*model.SharedChannelUser, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.SaveUser(remote)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) Update(sc *model.SharedChannel) (*model.SharedChannel, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.Update(sc)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) UpdateAttachmentLastSyncAt(id string, syncTime int64) error {

	tries := 0
	for {
		err := s.SharedChannelStore.UpdateAttachmentLastSyncAt(id, syncTime)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) UpdateRemote(remote *model.SharedChannelRemote) (*model.SharedChannelRemote, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.UpdateRemote(remote)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) UpdateRemoteCursor(id string, cursor model.GetPostsSinceForSyncCursor) error {

	tries := 0
	for {
		err := s.SharedChannelStore.UpdateRemoteCursor(id, cursor)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) UpdateRemoteMembershipCursor(id string, syncTime int64) error {

	tries := 0
	for {
		err := s.SharedChannelStore.UpdateRemoteMembershipCursor(id, syncTime)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) UpdateUserLastMembershipSyncAt(userID string, channelID string, remoteID string, syncTime int64) error {

	tries := 0
	for {
		err := s.SharedChannelStore.UpdateUserLastMembershipSyncAt(userID, channelID, remoteID, syncTime)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) UpdateUserLastSyncAt(userID string, channelID string, remoteID string) error {

	tries := 0
	for {
		err := s.SharedChannelStore.UpdateUserLastSyncAt(userID, channelID, remoteID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) UpsertAttachment(remote *model.SharedChannelAttachment) (string, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.UpsertAttachment(remote)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerStatusStore) Get(userID string) (*model.Status, error) {

	tries := 0
	for {
		result, err := s.StatusStore.Get(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerStatusStore) GetByIds(userIds []string) ([]*model.Status, error) {

	tries := 0
	for {
		result, err := s.StatusStore.GetByIds(userIds)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerStatusStore) GetTotalActiveUsersCount() (int64, error) {

	tries := 0
	for {
		result, err := s.StatusStore.GetTotalActiveUsersCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerStatusStore) ResetAll() error {

	tries := 0
	for {
		err := s.StatusStore.ResetAll()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerStatusStore) SaveOrUpdate(status *model.Status) error {

	tries := 0
	for {
		err := s.StatusStore.SaveOrUpdate(status)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerStatusStore) SaveOrUpdateMany(statuses map[string]*model.Status) error {

	tries := 0
	for {
		err := s.StatusStore.SaveOrUpdateMany(statuses)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerStatusStore) UpdateExpiredDNDStatuses() ([]*model.Status, error) {

	tries := 0
	for {
		result, err := s.StatusStore.UpdateExpiredDNDStatuses()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerStatusStore) UpdateLastActivityAt(userID string, lastActivityAt int64) error {

	tries := 0
	for {
		err := s.StatusStore.UpdateLastActivityAt(userID, lastActivityAt)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSystemStore) Get() (model.StringMap, error) {

	tries := 0
	for {
		result, err := s.SystemStore.Get()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSystemStore) GetByName(name string) (*model.System, error) {

	tries := 0
	for {
		result, err := s.SystemStore.GetByName(name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSystemStore) InsertIfExists(system *model.System) (*model.System, error) {

	tries := 0
	for {
		result, err := s.SystemStore.InsertIfExists(system)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSystemStore) PermanentDeleteByName(name string) (*model.System, error) {

	tries := 0
	for {
		result, err := s.SystemStore.PermanentDeleteByName(name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSystemStore) Save(system *model.System) error {

	tries := 0
	for {
		err := s.SystemStore.Save(system)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSystemStore) SaveOrUpdate(system *model.System) error {

	tries := 0
	for {
		err := s.SystemStore.SaveOrUpdate(system)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSystemStore) Update(system *model.System) error {

	tries := 0
	for {
		err := s.SystemStore.Update(system)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) AnalyticsGetTeamCountForScheme(schemeID string) (int64, error) {

	tries := 0
	for {
		result, err := s.TeamStore.AnalyticsGetTeamCountForScheme(schemeID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) AnalyticsTeamCount(opts *model.TeamSearch) (int64, error) {

	tries := 0
	for {
		result, err := s.TeamStore.AnalyticsTeamCount(opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) ClearAllCustomRoleAssignments() error {

	tries := 0
	for {
		err := s.TeamStore.ClearAllCustomRoleAssignments()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) ClearCaches() {

	s.TeamStore.ClearCaches()

}

func (s *RetryLayerTeamStore) Get(id string) (*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.Get(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetActiveMemberCount(teamID string, restrictions *model.ViewUsersRestrictions) (int64, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetActiveMemberCount(teamID, restrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetAll() ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetAll()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetAllForExportAfter(limit int, afterID string) ([]*model.TeamForExport, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetAllForExportAfter(limit, afterID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetAllPage(offset int, limit int, opts *model.TeamSearch) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetAllPage(offset, limit, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetAllPrivateTeamListing() ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetAllPrivateTeamListing()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetAllTeamListing() ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetAllTeamListing()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetByEmptyInviteID() ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetByEmptyInviteID()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetByInviteId(inviteID string) (*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetByInviteId(inviteID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetByName(name string) (*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetByName(name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetByNames(name []string) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetByNames(name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetChannelUnreadsForAllTeams(excludeTeamID string, userID string) ([]*model.ChannelUnread, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetChannelUnreadsForAllTeams(excludeTeamID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetChannelUnreadsForTeam(teamID string, userID string) ([]*model.ChannelUnread, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetChannelUnreadsForTeam(teamID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetCommonTeamIDsForMultipleUsers(userIDs []string) ([]string, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetCommonTeamIDsForMultipleUsers(userIDs)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetCommonTeamIDsForTwoUsers(userID string, otherUserID string) ([]string, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetCommonTeamIDsForTwoUsers(userID, otherUserID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetMany(ids []string) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetMany(ids)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetMember(rctx request.CTX, teamID string, userID string) (*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetMember(rctx, teamID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetMembers(teamID string, offset int, limit int, teamMembersGetOptions *model.TeamMembersGetOptions) ([]*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetMembers(teamID, offset, limit, teamMembersGetOptions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetMembersByIds(teamID string, userIds []string, restrictions *model.ViewUsersRestrictions) ([]*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetMembersByIds(teamID, userIds, restrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetTeamMembersForExport(userID string) ([]*model.TeamMemberForExport, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetTeamMembersForExport(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetTeamsByScheme(schemeID string, offset int, limit int) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetTeamsByScheme(schemeID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetTeamsByUserId(userID string) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetTeamsByUserId(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetTeamsForUser(rctx request.CTX, userID string, excludeTeamID string, includeDeleted bool) ([]*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetTeamsForUser(rctx, userID, excludeTeamID, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetTeamsForUserWithPagination(userID string, page int, perPage int) ([]*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetTeamsForUserWithPagination(userID, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetTotalMemberCount(teamID string, restrictions *model.ViewUsersRestrictions) (int64, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetTotalMemberCount(teamID, restrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetUserTeamIds(userID string, allowFromCache bool) ([]string, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetUserTeamIds(userID, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GroupSyncedTeamCount() (int64, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GroupSyncedTeamCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) InvalidateAllTeamIdsForUser(userID string) {

	s.TeamStore.InvalidateAllTeamIdsForUser(userID)

}

func (s *RetryLayerTeamStore) MigrateTeamMembers(fromTeamID string, fromUserID string) (map[string]string, error) {

	tries := 0
	for {
		result, err := s.TeamStore.MigrateTeamMembers(fromTeamID, fromUserID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) PermanentDelete(teamID string) error {

	tries := 0
	for {
		err := s.TeamStore.PermanentDelete(teamID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) RemoveAllMembersByTeam(teamID string) error {

	tries := 0
	for {
		err := s.TeamStore.RemoveAllMembersByTeam(teamID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) RemoveAllMembersByUser(rctx request.CTX, userID string) error {

	tries := 0
	for {
		err := s.TeamStore.RemoveAllMembersByUser(rctx, userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) RemoveMember(rctx request.CTX, teamID string, userID string) error {

	tries := 0
	for {
		err := s.TeamStore.RemoveMember(rctx, teamID, userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) RemoveMembers(rctx request.CTX, teamID string, userIds []string) error {

	tries := 0
	for {
		err := s.TeamStore.RemoveMembers(rctx, teamID, userIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) ResetAllTeamSchemes() error {

	tries := 0
	for {
		err := s.TeamStore.ResetAllTeamSchemes()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) Save(team *model.Team) (*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.Save(team)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) SaveMember(rctx request.CTX, member *model.TeamMember, maxUsersPerTeam int) (*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.SaveMember(rctx, member, maxUsersPerTeam)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) SaveMultipleMembers(members []*model.TeamMember, maxUsersPerTeam int) ([]*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.SaveMultipleMembers(members, maxUsersPerTeam)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) SearchAll(opts *model.TeamSearch) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.SearchAll(opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) SearchAllPaged(opts *model.TeamSearch) ([]*model.Team, int64, error) {

	tries := 0
	for {
		result, resultVar1, err := s.TeamStore.SearchAllPaged(opts)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) SearchOpen(opts *model.TeamSearch) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.SearchOpen(opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) SearchPrivate(opts *model.TeamSearch) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.SearchPrivate(opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) Update(team *model.Team) (*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.Update(team)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) UpdateLastTeamIconUpdate(teamID string, curTime int64) error {

	tries := 0
	for {
		err := s.TeamStore.UpdateLastTeamIconUpdate(teamID, curTime)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) UpdateMember(rctx request.CTX, member *model.TeamMember) (*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.UpdateMember(rctx, member)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) UpdateMembersRole(teamID string, adminIDs []string) ([]*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.UpdateMembersRole(teamID, adminIDs)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) UpdateMultipleMembers(members []*model.TeamMember) ([]*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.UpdateMultipleMembers(members)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) UserBelongsToTeams(userID string, teamIds []string) (bool, error) {

	tries := 0
	for {
		result, err := s.TeamStore.UserBelongsToTeams(userID, teamIds)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTermsOfServiceStore) Get(id string, allowFromCache bool) (*model.TermsOfService, error) {

	tries := 0
	for {
		result, err := s.TermsOfServiceStore.Get(id, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTermsOfServiceStore) GetLatest(allowFromCache bool) (*model.TermsOfService, error) {

	tries := 0
	for {
		result, err := s.TermsOfServiceStore.GetLatest(allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTermsOfServiceStore) Save(termsOfService *model.TermsOfService) (*model.TermsOfService, error) {

	tries := 0
	for {
		result, err := s.TermsOfServiceStore.Save(termsOfService)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) DeleteMembershipForUser(userID string, postID string) error {

	tries := 0
	for {
		err := s.ThreadStore.DeleteMembershipForUser(userID, postID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) DeleteMembershipsForChannel(userID string, channelID string) error {

	tries := 0
	for {
		err := s.ThreadStore.DeleteMembershipsForChannel(userID, channelID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) DeleteOrphanedRows(limit int) (int64, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.DeleteOrphanedRows(limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) Get(id string) (*model.Thread, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.Get(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetMembershipForUser(userID string, postID string) (*model.ThreadMembership, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetMembershipForUser(userID, postID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetMembershipsForUser(userID string, teamID string) ([]*model.ThreadMembership, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetMembershipsForUser(userID, teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetTeamsUnreadForUser(userID string, teamIDs []string, includeUrgentMentionCount bool) (map[string]*model.TeamUnread, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetTeamsUnreadForUser(userID, teamIDs, includeUrgentMentionCount)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetThreadFollowers(threadID string, fetchOnlyActive bool) ([]string, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetThreadFollowers(threadID, fetchOnlyActive)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetThreadForUser(rctx request.CTX, threadMembership *model.ThreadMembership, extended bool, postPriorityIsEnabled bool) (*model.ThreadResponse, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetThreadForUser(rctx, threadMembership, extended, postPriorityIsEnabled)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetThreadMembershipsForExport(postID string) ([]*model.ThreadMembershipForExport, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetThreadMembershipsForExport(postID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetThreadUnreadReplyCount(threadMembership *model.ThreadMembership) (int64, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetThreadUnreadReplyCount(threadMembership)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetThreadsForUser(rctx request.CTX, userID string, teamID string, opts model.GetUserThreadsOpts) ([]*model.ThreadResponse, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetThreadsForUser(rctx, userID, teamID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetTotalThreads(userID string, teamID string, opts model.GetUserThreadsOpts) (int64, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetTotalThreads(userID, teamID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetTotalUnreadMentions(userID string, teamID string, opts model.GetUserThreadsOpts) (int64, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetTotalUnreadMentions(userID, teamID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetTotalUnreadThreads(userID string, teamID string, opts model.GetUserThreadsOpts) (int64, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetTotalUnreadThreads(userID, teamID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetTotalUnreadUrgentMentions(userID string, teamID string, opts model.GetUserThreadsOpts) (int64, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetTotalUnreadUrgentMentions(userID, teamID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) MaintainMembership(userID string, postID string, opts store.ThreadMembershipOpts) (*model.ThreadMembership, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.MaintainMembership(userID, postID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) MaintainMultipleFromImport(memberships []*model.ThreadMembership) ([]*model.ThreadMembership, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.MaintainMultipleFromImport(memberships)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) MarkAllAsRead(userID string, threadIds []string) error {

	tries := 0
	for {
		err := s.ThreadStore.MarkAllAsRead(userID, threadIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) MarkAllAsReadByChannels(userID string, channelIDs []string) error {

	tries := 0
	for {
		err := s.ThreadStore.MarkAllAsReadByChannels(userID, channelIDs)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) MarkAllAsReadByTeam(userID string, teamID string) error {

	tries := 0
	for {
		err := s.ThreadStore.MarkAllAsReadByTeam(userID, teamID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) MarkAsRead(userID string, threadID string, timestamp int64) error {

	tries := 0
	for {
		err := s.ThreadStore.MarkAsRead(userID, threadID, timestamp)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) PermanentDeleteBatchForRetentionPolicies(retentionPolicyBatchConfigs model.RetentionPolicyBatchConfigs, cursor model.RetentionPolicyCursor) (int64, model.RetentionPolicyCursor, error) {

	tries := 0
	for {
		result, resultVar1, err := s.ThreadStore.PermanentDeleteBatchForRetentionPolicies(retentionPolicyBatchConfigs, cursor)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) PermanentDeleteBatchThreadMembershipsForRetentionPolicies(retentionPolicyBatchConfigs model.RetentionPolicyBatchConfigs, cursor model.RetentionPolicyCursor) (int64, model.RetentionPolicyCursor, error) {

	tries := 0
	for {
		result, resultVar1, err := s.ThreadStore.PermanentDeleteBatchThreadMembershipsForRetentionPolicies(retentionPolicyBatchConfigs, cursor)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) SaveMultipleMemberships(memberships []*model.ThreadMembership) ([]*model.ThreadMembership, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.SaveMultipleMemberships(memberships)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) UpdateMembership(membership *model.ThreadMembership) (*model.ThreadMembership, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.UpdateMembership(membership)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) UpdateTeamIdForChannelThreads(channelId string, teamId string) error {

	tries := 0
	for {
		err := s.ThreadStore.UpdateTeamIdForChannelThreads(channelId, teamId)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTokenStore) Cleanup(expiryTime int64) {

	s.TokenStore.Cleanup(expiryTime)

}

func (s *RetryLayerTokenStore) ConsumeOnce(tokenType string, tokenStr string) (*model.Token, error) {

	tries := 0
	for {
		result, err := s.TokenStore.ConsumeOnce(tokenType, tokenStr)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTokenStore) Delete(token string) error {

	tries := 0
	for {
		err := s.TokenStore.Delete(token)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTokenStore) GetAllTokensByType(tokenType string) ([]*model.Token, error) {

	tries := 0
	for {
		result, err := s.TokenStore.GetAllTokensByType(tokenType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTokenStore) GetByToken(token string) (*model.Token, error) {

	tries := 0
	for {
		result, err := s.TokenStore.GetByToken(token)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTokenStore) RemoveAllTokensByType(tokenType string) error {

	tries := 0
	for {
		err := s.TokenStore.RemoveAllTokensByType(tokenType)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTokenStore) Save(recovery *model.Token) error {

	tries := 0
	for {
		err := s.TokenStore.Save(recovery)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUploadSessionStore) Delete(id string) error {

	tries := 0
	for {
		err := s.UploadSessionStore.Delete(id)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUploadSessionStore) Get(rctx request.CTX, id string) (*model.UploadSession, error) {

	tries := 0
	for {
		result, err := s.UploadSessionStore.Get(rctx, id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUploadSessionStore) GetForUser(userID string) ([]*model.UploadSession, error) {

	tries := 0
	for {
		result, err := s.UploadSessionStore.GetForUser(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUploadSessionStore) Save(session *model.UploadSession) (*model.UploadSession, error) {

	tries := 0
	for {
		result, err := s.UploadSessionStore.Save(session)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUploadSessionStore) Update(session *model.UploadSession) error {

	tries := 0
	for {
		err := s.UploadSessionStore.Update(session)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) AnalyticsActiveCount(timestamp int64, options model.UserCountOptions) (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.AnalyticsActiveCount(timestamp, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) AnalyticsActiveCountForPeriod(startTime int64, endTime int64, options model.UserCountOptions) (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.AnalyticsActiveCountForPeriod(startTime, endTime, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) AnalyticsGetExternalUsers(hostDomain string) (bool, error) {

	tries := 0
	for {
		result, err := s.UserStore.AnalyticsGetExternalUsers(hostDomain)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) AnalyticsGetGuestCount() (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.AnalyticsGetGuestCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) AnalyticsGetInactiveUsersCount() (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.AnalyticsGetInactiveUsersCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) AnalyticsGetSystemAdminCount() (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.AnalyticsGetSystemAdminCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) AutocompleteUsersInChannel(rctx request.CTX, teamID string, channelID string, term string, options *model.UserSearchOptions) (*model.UserAutocompleteInChannel, error) {

	tries := 0
	for {
		result, err := s.UserStore.AutocompleteUsersInChannel(rctx, teamID, channelID, term, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) ClearAllCustomRoleAssignments() error {

	tries := 0
	for {
		err := s.UserStore.ClearAllCustomRoleAssignments()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) ClearCaches() {

	s.UserStore.ClearCaches()

}

func (s *RetryLayerUserStore) Count(options model.UserCountOptions) (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.Count(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) DeactivateGuests() ([]string, error) {

	tries := 0
	for {
		result, err := s.UserStore.DeactivateGuests()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) DemoteUserToGuest(userID string) (*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.DemoteUserToGuest(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) Get(ctx context.Context, id string) (*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.Get(ctx, id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetAll() ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetAll()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetAllAfter(limit int, afterID string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetAllAfter(limit, afterID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetAllNotInAuthService(authServices []string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetAllNotInAuthService(authServices)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetAllProfiles(options *model.UserGetOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetAllProfiles(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetAllProfilesInChannel(ctx context.Context, channelID string, allowFromCache bool) (map[string]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetAllProfilesInChannel(ctx, channelID, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetAllUsingAuthService(authService string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetAllUsingAuthService(authService)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetAnyUnreadPostCountForChannel(userID string, channelID string) (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetAnyUnreadPostCountForChannel(userID, channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetByAuth(authData *string, authService string) (*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetByAuth(authData, authService)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetByEmail(email string) (*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetByEmail(email)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetByRemoteID(remoteID string) (*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetByRemoteID(remoteID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetByUsername(username string) (*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetByUsername(username)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetChannelGroupUsers(channelID string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetChannelGroupUsers(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetEtagForAllProfiles() string {

	return s.UserStore.GetEtagForAllProfiles()

}

func (s *RetryLayerUserStore) GetEtagForProfiles(teamID string) string {

	return s.UserStore.GetEtagForProfiles(teamID)

}

func (s *RetryLayerUserStore) GetEtagForProfilesNotInTeam(teamID string) string {

	return s.UserStore.GetEtagForProfilesNotInTeam(teamID)

}

func (s *RetryLayerUserStore) GetForLogin(loginID string, allowSignInWithUsername bool, allowSignInWithEmail bool) (*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetForLogin(loginID, allowSignInWithUsername, allowSignInWithEmail)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetKnownUsers(userID string) ([]string, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetKnownUsers(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetMany(rctx request.CTX, ids []string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetMany(rctx, ids)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetMfaUsedTimestamps(userID string) ([]int, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetMfaUsedTimestamps(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetNewUsersForTeam(teamID string, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetNewUsersForTeam(teamID, offset, limit, viewRestrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfileByGroupChannelIdsForUser(userID string, channelIds []string) (map[string][]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfileByGroupChannelIdsForUser(userID, channelIds)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfileByIds(rctx request.CTX, userIds []string, options *store.UserGetByIdsOpts, allowFromCache bool) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfileByIds(rctx, userIds, options, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfiles(options *model.UserGetOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfiles(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfilesByUsernames(usernames []string, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfilesByUsernames(usernames, viewRestrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfilesInChannel(options *model.UserGetOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfilesInChannel(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfilesInChannelByAdmin(options *model.UserGetOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfilesInChannelByAdmin(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfilesInChannelByStatus(options *model.UserGetOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfilesInChannelByStatus(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfilesNotInChannel(teamID string, channelID string, groupConstrained bool, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfilesNotInChannel(teamID, channelID, groupConstrained, offset, limit, viewRestrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfilesNotInTeam(teamID string, groupConstrained bool, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfilesNotInTeam(teamID, groupConstrained, offset, limit, viewRestrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfilesWithoutTeam(options *model.UserGetOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfilesWithoutTeam(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetRecentlyActiveUsersForTeam(teamID string, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetRecentlyActiveUsersForTeam(teamID, offset, limit, viewRestrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetSystemAdminProfiles() (map[string]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetSystemAdminProfiles()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetTeamGroupUsers(teamID string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetTeamGroupUsers(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetUnreadCount(userID string, isCRTEnabled bool) (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetUnreadCount(userID, isCRTEnabled)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetUnreadCountForChannel(userID string, channelID string) (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetUnreadCountForChannel(userID, channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetUserCountForReport(filter *model.UserReportOptions) (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetUserCountForReport(filter)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetUserReport(filter *model.UserReportOptions) ([]*model.UserReportQuery, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetUserReport(filter)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetUsersBatchForIndexing(startTime int64, startFileID string, limit int) ([]*model.UserForIndexing, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetUsersBatchForIndexing(startTime, startFileID, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetUsersWithInvalidEmails(page int, perPage int, restrictedDomains string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetUsersWithInvalidEmails(page, perPage, restrictedDomains)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) InferSystemInstallDate() (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.InferSystemInstallDate()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) InsertUsers(users []*model.User) error {

	tries := 0
	for {
		err := s.UserStore.InsertUsers(users)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) InvalidateProfileCacheForUser(userID string) {

	s.UserStore.InvalidateProfileCacheForUser(userID)

}

func (s *RetryLayerUserStore) InvalidateProfilesInChannelCache(channelID string) {

	s.UserStore.InvalidateProfilesInChannelCache(channelID)

}

func (s *RetryLayerUserStore) InvalidateProfilesInChannelCacheByUser(userID string) {

	s.UserStore.InvalidateProfilesInChannelCacheByUser(userID)

}

func (s *RetryLayerUserStore) IsEmpty(excludeBots bool) (bool, error) {

	tries := 0
	for {
		result, err := s.UserStore.IsEmpty(excludeBots)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) PermanentDelete(rctx request.CTX, userID string) error {

	tries := 0
	for {
		err := s.UserStore.PermanentDelete(rctx, userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) PromoteGuestToUser(userID string) error {

	tries := 0
	for {
		err := s.UserStore.PromoteGuestToUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) RefreshPostStatsForUsers() error {

	tries := 0
	for {
		err := s.UserStore.RefreshPostStatsForUsers()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) ResetAuthDataToEmailForUsers(service string, userIDs []string, includeDeleted bool, dryRun bool) (int, error) {

	tries := 0
	for {
		result, err := s.UserStore.ResetAuthDataToEmailForUsers(service, userIDs, includeDeleted, dryRun)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) ResetLastPictureUpdate(userID string) error {

	tries := 0
	for {
		err := s.UserStore.ResetLastPictureUpdate(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) Save(rctx request.CTX, user *model.User) (*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.Save(rctx, user)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) Search(rctx request.CTX, teamID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.Search(rctx, teamID, term, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) SearchCommonContentFlaggingReviewers(term string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.SearchCommonContentFlaggingReviewers(term)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) SearchInChannel(channelID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.SearchInChannel(channelID, term, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) SearchInGroup(groupID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.SearchInGroup(groupID, term, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) SearchNotInChannel(teamID string, channelID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.SearchNotInChannel(teamID, channelID, term, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) SearchNotInGroup(groupID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.SearchNotInGroup(groupID, term, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) SearchNotInTeam(notInTeamID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.SearchNotInTeam(notInTeamID, term, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) SearchTeamContentFlaggingReviewers(teamId string, term string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.SearchTeamContentFlaggingReviewers(teamId, term)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) SearchWithoutTeam(term string, options *model.UserSearchOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.SearchWithoutTeam(term, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) StoreMfaUsedTimestamps(userID string, ts []int) error {

	tries := 0
	for {
		err := s.UserStore.StoreMfaUsedTimestamps(userID, ts)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) Update(rctx request.CTX, user *model.User, allowRoleUpdate bool) (*model.UserUpdate, error) {

	tries := 0
	for {
		result, err := s.UserStore.Update(rctx, user, allowRoleUpdate)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) UpdateAuthData(userID string, service string, authData *string, email string, resetMfa bool) (string, error) {

	tries := 0
	for {
		result, err := s.UserStore.UpdateAuthData(userID, service, authData, email, resetMfa)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) UpdateFailedPasswordAttempts(userID string, attempts int) error {

	tries := 0
	for {
		err := s.UserStore.UpdateFailedPasswordAttempts(userID, attempts)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) UpdateLastLogin(userID string, lastLogin int64) error {

	tries := 0
	for {
		err := s.UserStore.UpdateLastLogin(userID, lastLogin)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) UpdateLastPictureUpdate(userID string) error {

	tries := 0
	for {
		err := s.UserStore.UpdateLastPictureUpdate(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) UpdateMfaActive(userID string, active bool) error {

	tries := 0
	for {
		err := s.UserStore.UpdateMfaActive(userID, active)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) UpdateMfaSecret(userID string, secret string) error {

	tries := 0
	for {
		err := s.UserStore.UpdateMfaSecret(userID, secret)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) UpdateNotifyProps(userID string, props map[string]string) error {

	tries := 0
	for {
		err := s.UserStore.UpdateNotifyProps(userID, props)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) UpdatePassword(userID string, newPassword string) error {

	tries := 0
	for {
		err := s.UserStore.UpdatePassword(userID, newPassword)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) UpdateUpdateAt(userID string) (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.UpdateUpdateAt(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) VerifyEmail(userID string, email string) (string, error) {

	tries := 0
	for {
		result, err := s.UserStore.VerifyEmail(userID, email)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) Delete(tokenID string) error {

	tries := 0
	for {
		err := s.UserAccessTokenStore.Delete(tokenID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) DeleteAllForUser(userID string) error {

	tries := 0
	for {
		err := s.UserAccessTokenStore.DeleteAllForUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) Get(tokenID string) (*model.UserAccessToken, error) {

	tries := 0
	for {
		result, err := s.UserAccessTokenStore.Get(tokenID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) GetAll(offset int, limit int) ([]*model.UserAccessToken, error) {

	tries := 0
	for {
		result, err := s.UserAccessTokenStore.GetAll(offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) GetByToken(tokenString string) (*model.UserAccessToken, error) {

	tries := 0
	for {
		result, err := s.UserAccessTokenStore.GetByToken(tokenString)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) GetByUser(userID string, page int, perPage int) ([]*model.UserAccessToken, error) {

	tries := 0
	for {
		result, err := s.UserAccessTokenStore.GetByUser(userID, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) Save(token *model.UserAccessToken) (*model.UserAccessToken, error) {

	tries := 0
	for {
		result, err := s.UserAccessTokenStore.Save(token)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) Search(term string) ([]*model.UserAccessToken, error) {

	tries := 0
	for {
		result, err := s.UserAccessTokenStore.Search(term)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) UpdateTokenDisable(tokenID string) error {

	tries := 0
	for {
		err := s.UserAccessTokenStore.UpdateTokenDisable(tokenID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) UpdateTokenEnable(tokenID string) error {

	tries := 0
	for {
		err := s.UserAccessTokenStore.UpdateTokenEnable(tokenID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserTermsOfServiceStore) Delete(userID string, termsOfServiceID string) error {

	tries := 0
	for {
		err := s.UserTermsOfServiceStore.Delete(userID, termsOfServiceID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserTermsOfServiceStore) GetByUser(userID string) (*model.UserTermsOfService, error) {

	tries := 0
	for {
		result, err := s.UserTermsOfServiceStore.GetByUser(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserTermsOfServiceStore) Save(userTermsOfService *model.UserTermsOfService) (*model.UserTermsOfService, error) {

	tries := 0
	for {
		result, err := s.UserTermsOfServiceStore.Save(userTermsOfService)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) AnalyticsIncomingCount(teamID string, userID string) (int64, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.AnalyticsIncomingCount(teamID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) AnalyticsOutgoingCount(teamID string) (int64, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.AnalyticsOutgoingCount(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) ClearCaches() {

	s.WebhookStore.ClearCaches()

}

func (s *RetryLayerWebhookStore) DeleteIncoming(webhookID string, timestamp int64) error {

	tries := 0
	for {
		err := s.WebhookStore.DeleteIncoming(webhookID, timestamp)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) DeleteOutgoing(webhookID string, timestamp int64) error {

	tries := 0
	for {
		err := s.WebhookStore.DeleteOutgoing(webhookID, timestamp)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetIncoming(id string, allowFromCache bool) (*model.IncomingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetIncoming(id, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetIncomingByChannel(channelID string) ([]*model.IncomingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetIncomingByChannel(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetIncomingByTeam(teamID string, offset int, limit int) ([]*model.IncomingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetIncomingByTeam(teamID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetIncomingByTeamByUser(teamID string, userID string, offset int, limit int) ([]*model.IncomingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetIncomingByTeamByUser(teamID, userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetIncomingList(offset int, limit int) ([]*model.IncomingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetIncomingList(offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetIncomingListByUser(userID string, offset int, limit int) ([]*model.IncomingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetIncomingListByUser(userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetOutgoing(id string) (*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetOutgoing(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetOutgoingByChannel(channelID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetOutgoingByChannel(channelID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetOutgoingByChannelByUser(channelID string, userID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetOutgoingByChannelByUser(channelID, userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetOutgoingByTeam(teamID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetOutgoingByTeam(teamID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetOutgoingByTeamByUser(teamID string, userID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetOutgoingByTeamByUser(teamID, userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetOutgoingList(offset int, limit int) ([]*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetOutgoingList(offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetOutgoingListByUser(userID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetOutgoingListByUser(userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) InvalidateWebhookCache(webhook string) {

	s.WebhookStore.InvalidateWebhookCache(webhook)

}

func (s *RetryLayerWebhookStore) PermanentDeleteIncomingByChannel(channelID string) error {

	tries := 0
	for {
		err := s.WebhookStore.PermanentDeleteIncomingByChannel(channelID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) PermanentDeleteIncomingByUser(userID string) error {

	tries := 0
	for {
		err := s.WebhookStore.PermanentDeleteIncomingByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) PermanentDeleteOutgoingByChannel(channelID string) error {

	tries := 0
	for {
		err := s.WebhookStore.PermanentDeleteOutgoingByChannel(channelID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) PermanentDeleteOutgoingByUser(userID string) error {

	tries := 0
	for {
		err := s.WebhookStore.PermanentDeleteOutgoingByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) SaveIncoming(webhook *model.IncomingWebhook) (*model.IncomingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.SaveIncoming(webhook)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) SaveOutgoing(webhook *model.OutgoingWebhook) (*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.SaveOutgoing(webhook)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) UpdateIncoming(webhook *model.IncomingWebhook) (*model.IncomingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.UpdateIncoming(webhook)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) UpdateOutgoing(hook *model.OutgoingWebhook) (*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.UpdateOutgoing(hook)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayer) Close() {
	s.Store.Close()
}

func (s *RetryLayer) DropAllTables() {
	s.Store.DropAllTables()
}

func (s *RetryLayer) LockToMaster() {
	s.Store.LockToMaster()
}

func (s *RetryLayer) MarkSystemRanUnitTests() {
	s.Store.MarkSystemRanUnitTests()
}

func (s *RetryLayer) SetContext(context context.Context) {
	s.Store.SetContext(context)
}

func (s *RetryLayer) TotalMasterDbConnections() int {
	return s.Store.TotalMasterDbConnections()
}

func (s *RetryLayer) TotalReadDbConnections() int {
	return s.Store.TotalReadDbConnections()
}

func (s *RetryLayer) TotalSearchDbConnections() int {
	return s.Store.TotalSearchDbConnections()
}

func (s *RetryLayer) UnlockFromMaster() {
	s.Store.UnlockFromMaster()
}

func New(childStore store.Store) *RetryLayer {
	newStore := RetryLayer{
		Store: childStore,
	}

	newStore.AccessControlPolicyStore = &RetryLayerAccessControlPolicyStore{AccessControlPolicyStore: childStore.AccessControlPolicy(), Root: &newStore}
	newStore.AttributesStore = &RetryLayerAttributesStore{AttributesStore: childStore.Attributes(), Root: &newStore}
	newStore.AuditStore = &RetryLayerAuditStore{AuditStore: childStore.Audit(), Root: &newStore}
	newStore.BotStore = &RetryLayerBotStore{BotStore: childStore.Bot(), Root: &newStore}
	newStore.ChannelStore = &RetryLayerChannelStore{ChannelStore: childStore.Channel(), Root: &newStore}
	newStore.ChannelBookmarkStore = &RetryLayerChannelBookmarkStore{ChannelBookmarkStore: childStore.ChannelBookmark(), Root: &newStore}
	newStore.ChannelMemberHistoryStore = &RetryLayerChannelMemberHistoryStore{ChannelMemberHistoryStore: childStore.ChannelMemberHistory(), Root: &newStore}
	newStore.ClusterDiscoveryStore = &RetryLayerClusterDiscoveryStore{ClusterDiscoveryStore: childStore.ClusterDiscovery(), Root: &newStore}
	newStore.CommandStore = &RetryLayerCommandStore{CommandStore: childStore.Command(), Root: &newStore}
	newStore.CommandWebhookStore = &RetryLayerCommandWebhookStore{CommandWebhookStore: childStore.CommandWebhook(), Root: &newStore}
	newStore.ComplianceStore = &RetryLayerComplianceStore{ComplianceStore: childStore.Compliance(), Root: &newStore}
	newStore.ContentFlaggingStore = &RetryLayerContentFlaggingStore{ContentFlaggingStore: childStore.ContentFlagging(), Root: &newStore}
	newStore.DesktopTokensStore = &RetryLayerDesktopTokensStore{DesktopTokensStore: childStore.DesktopTokens(), Root: &newStore}
	newStore.DraftStore = &RetryLayerDraftStore{DraftStore: childStore.Draft(), Root: &newStore}
	newStore.EmojiStore = &RetryLayerEmojiStore{EmojiStore: childStore.Emoji(), Root: &newStore}
	newStore.FileInfoStore = &RetryLayerFileInfoStore{FileInfoStore: childStore.FileInfo(), Root: &newStore}
	newStore.GroupStore = &RetryLayerGroupStore{GroupStore: childStore.Group(), Root: &newStore}
	newStore.JobStore = &RetryLayerJobStore{JobStore: childStore.Job(), Root: &newStore}
	newStore.LicenseStore = &RetryLayerLicenseStore{LicenseStore: childStore.License(), Root: &newStore}
	newStore.LinkMetadataStore = &RetryLayerLinkMetadataStore{LinkMetadataStore: childStore.LinkMetadata(), Root: &newStore}
	newStore.NotifyAdminStore = &RetryLayerNotifyAdminStore{NotifyAdminStore: childStore.NotifyAdmin(), Root: &newStore}
	newStore.OAuthStore = &RetryLayerOAuthStore{OAuthStore: childStore.OAuth(), Root: &newStore}
	newStore.OutgoingOAuthConnectionStore = &RetryLayerOutgoingOAuthConnectionStore{OutgoingOAuthConnectionStore: childStore.OutgoingOAuthConnection(), Root: &newStore}
	newStore.PluginStore = &RetryLayerPluginStore{PluginStore: childStore.Plugin(), Root: &newStore}
	newStore.PostStore = &RetryLayerPostStore{PostStore: childStore.Post(), Root: &newStore}
	newStore.PostAcknowledgementStore = &RetryLayerPostAcknowledgementStore{PostAcknowledgementStore: childStore.PostAcknowledgement(), Root: &newStore}
	newStore.PostPersistentNotificationStore = &RetryLayerPostPersistentNotificationStore{PostPersistentNotificationStore: childStore.PostPersistentNotification(), Root: &newStore}
	newStore.PostPriorityStore = &RetryLayerPostPriorityStore{PostPriorityStore: childStore.PostPriority(), Root: &newStore}
	newStore.PreferenceStore = &RetryLayerPreferenceStore{PreferenceStore: childStore.Preference(), Root: &newStore}
	newStore.ProductNoticesStore = &RetryLayerProductNoticesStore{ProductNoticesStore: childStore.ProductNotices(), Root: &newStore}
	newStore.PropertyFieldStore = &RetryLayerPropertyFieldStore{PropertyFieldStore: childStore.PropertyField(), Root: &newStore}
	newStore.PropertyGroupStore = &RetryLayerPropertyGroupStore{PropertyGroupStore: childStore.PropertyGroup(), Root: &newStore}
	newStore.PropertyValueStore = &RetryLayerPropertyValueStore{PropertyValueStore: childStore.PropertyValue(), Root: &newStore}
	newStore.ReactionStore = &RetryLayerReactionStore{ReactionStore: childStore.Reaction(), Root: &newStore}
	newStore.RemoteClusterStore = &RetryLayerRemoteClusterStore{RemoteClusterStore: childStore.RemoteCluster(), Root: &newStore}
	newStore.RetentionPolicyStore = &RetryLayerRetentionPolicyStore{RetentionPolicyStore: childStore.RetentionPolicy(), Root: &newStore}
	newStore.RoleStore = &RetryLayerRoleStore{RoleStore: childStore.Role(), Root: &newStore}
	newStore.ScheduledPostStore = &RetryLayerScheduledPostStore{ScheduledPostStore: childStore.ScheduledPost(), Root: &newStore}
	newStore.SchemeStore = &RetryLayerSchemeStore{SchemeStore: childStore.Scheme(), Root: &newStore}
	newStore.SessionStore = &RetryLayerSessionStore{SessionStore: childStore.Session(), Root: &newStore}
	newStore.SharedChannelStore = &RetryLayerSharedChannelStore{SharedChannelStore: childStore.SharedChannel(), Root: &newStore}
	newStore.StatusStore = &RetryLayerStatusStore{StatusStore: childStore.Status(), Root: &newStore}
	newStore.SystemStore = &RetryLayerSystemStore{SystemStore: childStore.System(), Root: &newStore}
	newStore.TeamStore = &RetryLayerTeamStore{TeamStore: childStore.Team(), Root: &newStore}
	newStore.TermsOfServiceStore = &RetryLayerTermsOfServiceStore{TermsOfServiceStore: childStore.TermsOfService(), Root: &newStore}
	newStore.ThreadStore = &RetryLayerThreadStore{ThreadStore: childStore.Thread(), Root: &newStore}
	newStore.TokenStore = &RetryLayerTokenStore{TokenStore: childStore.Token(), Root: &newStore}
	newStore.UploadSessionStore = &RetryLayerUploadSessionStore{UploadSessionStore: childStore.UploadSession(), Root: &newStore}
	newStore.UserStore = &RetryLayerUserStore{UserStore: childStore.User(), Root: &newStore}
	newStore.UserAccessTokenStore = &RetryLayerUserAccessTokenStore{UserAccessTokenStore: childStore.UserAccessToken(), Root: &newStore}
	newStore.UserTermsOfServiceStore = &RetryLayerUserTermsOfServiceStore{UserTermsOfServiceStore: childStore.UserTermsOfService(), Root: &newStore}
	newStore.WebhookStore = &RetryLayerWebhookStore{WebhookStore: childStore.Webhook(), Root: &newStore}
	return &newStore
}
