package matchers

import (
	"fmt"
	"reflect"

	"github.com/splitio/go-toolkit/v5/datastructures/set"
)

// ContainsAllOfSetMatcher matches if the set supplied to the getTreatment is a superset of the one in the feature flag
type ContainsAllOfSetMatcher struct {
	Matcher
	comparisonSet *set.ThreadUnsafeSet
}

// Match returns true if the set provided is a superset of the one in the feature flag
func (m *ContainsAllOfSetMatcher) Match(key string, attributes map[string]interface{}, bucketingKey *string) bool {
	matchingKey, err := m.matchingKey(key, attributes)
	if err != nil {
		m.logger.Warning(fmt.Sprintf("AllOfSetMatcher: %s", err.Error()))
		return false
	}

	conv, ok := matchingKey.([]string)
	if !ok {
		m.logger.Error(
			"AllOfSetMatcher: Attribute passed is not a slice of strings. ",
			fmt.Sprintf("Key is of type %s\n", reflect.TypeOf(matchingKey).String()),
		)
		return false
	}

	matchingSet := set.NewSet()
	for _, x := range conv {
		matchingSet.Add(x)
	}

	res := m.comparisonSet.IsSuperset(matchingSet)
	return res

}

// NewContainsAllOfSetMatcher returns a pointer to a new instance of ContainsAllOfSetMatcher
func NewContainsAllOfSetMatcher(negate bool, setItems []string, attributeName *string) *ContainsAllOfSetMatcher {
	setObj := set.NewSet()
	for _, item := range setItems {
		setObj.Add(item)
	}

	return &ContainsAllOfSetMatcher{
		Matcher: Matcher{
			negate:        negate,
			attributeName: attributeName,
		},
		comparisonSet: setObj,
	}
}
