// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated from the elasticsearch-specification DO NOT EDIT.
// https://github.com/elastic/elasticsearch-specification/tree/f6a370d0fba975752c644fc730f7c45610e28f36

package types

import (
	"bytes"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"strconv"
)

// WatcherWatchTriggerSchedule type.
//
// https://github.com/elastic/elasticsearch-specification/blob/f6a370d0fba975752c644fc730f7c45610e28f36/specification/xpack/usage/types.ts#L476-L479
type WatcherWatchTriggerSchedule struct {
	Active int64   `json:"active"`
	All_   Counter `json:"_all"`
	Cron   Counter `json:"cron"`
	Total  int64   `json:"total"`
}

func (s *WatcherWatchTriggerSchedule) UnmarshalJSON(data []byte) error {

	dec := json.NewDecoder(bytes.NewReader(data))

	for {
		t, err := dec.Token()
		if err != nil {
			if errors.Is(err, io.EOF) {
				break
			}
			return err
		}

		switch t {

		case "active":
			var tmp any
			dec.Decode(&tmp)
			switch v := tmp.(type) {
			case string:
				value, err := strconv.ParseInt(v, 10, 64)
				if err != nil {
					return fmt.Errorf("%s | %w", "Active", err)
				}
				s.Active = value
			case float64:
				f := int64(v)
				s.Active = f
			}

		case "_all":
			if err := dec.Decode(&s.All_); err != nil {
				return fmt.Errorf("%s | %w", "All_", err)
			}

		case "cron":
			if err := dec.Decode(&s.Cron); err != nil {
				return fmt.Errorf("%s | %w", "Cron", err)
			}

		case "total":
			var tmp any
			dec.Decode(&tmp)
			switch v := tmp.(type) {
			case string:
				value, err := strconv.ParseInt(v, 10, 64)
				if err != nil {
					return fmt.Errorf("%s | %w", "Total", err)
				}
				s.Total = value
			case float64:
				f := int64(v)
				s.Total = f
			}

		}
	}
	return nil
}

// NewWatcherWatchTriggerSchedule returns a WatcherWatchTriggerSchedule.
func NewWatcherWatchTriggerSchedule() *WatcherWatchTriggerSchedule {
	r := &WatcherWatchTriggerSchedule{}

	return r
}

// false
