// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated from the elasticsearch-specification DO NOT EDIT.
// https://github.com/elastic/elasticsearch-specification/tree/f6a370d0fba975752c644fc730f7c45610e28f36

package types

import (
	"bytes"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"strconv"
)

// RuleRetriever type.
//
// https://github.com/elastic/elasticsearch-specification/blob/f6a370d0fba975752c644fc730f7c45610e28f36/specification/_types/Retriever.ts#L106-L115
type RuleRetriever struct {
	// Filter Query to filter the documents that can match.
	Filter []Query `json:"filter,omitempty"`
	// MatchCriteria The match criteria that will determine if a rule in the provided rulesets
	// should be applied.
	MatchCriteria json.RawMessage `json:"match_criteria,omitempty"`
	// MinScore Minimum _score for matching documents. Documents with a lower _score are not
	// included in the top documents.
	MinScore *float32 `json:"min_score,omitempty"`
	// RankWindowSize This value determines the size of the individual result set.
	RankWindowSize *int `json:"rank_window_size,omitempty"`
	// Retriever The retriever whose results rules should be applied to.
	Retriever RetrieverContainer `json:"retriever"`
	// RulesetIds The ruleset IDs containing the rules this retriever is evaluating against.
	RulesetIds []string `json:"ruleset_ids"`
}

func (s *RuleRetriever) UnmarshalJSON(data []byte) error {

	dec := json.NewDecoder(bytes.NewReader(data))

	for {
		t, err := dec.Token()
		if err != nil {
			if errors.Is(err, io.EOF) {
				break
			}
			return err
		}

		switch t {

		case "filter":
			rawMsg := json.RawMessage{}
			dec.Decode(&rawMsg)
			if !bytes.HasPrefix(rawMsg, []byte("[")) {
				o := NewQuery()
				if err := json.NewDecoder(bytes.NewReader(rawMsg)).Decode(&o); err != nil {
					return fmt.Errorf("%s | %w", "Filter", err)
				}

				s.Filter = append(s.Filter, *o)
			} else {
				if err := json.NewDecoder(bytes.NewReader(rawMsg)).Decode(&s.Filter); err != nil {
					return fmt.Errorf("%s | %w", "Filter", err)
				}
			}

		case "match_criteria":
			if err := dec.Decode(&s.MatchCriteria); err != nil {
				return fmt.Errorf("%s | %w", "MatchCriteria", err)
			}

		case "min_score":
			var tmp any
			dec.Decode(&tmp)
			switch v := tmp.(type) {
			case string:
				value, err := strconv.ParseFloat(v, 32)
				if err != nil {
					return fmt.Errorf("%s | %w", "MinScore", err)
				}
				f := float32(value)
				s.MinScore = &f
			case float64:
				f := float32(v)
				s.MinScore = &f
			}

		case "rank_window_size":

			var tmp any
			dec.Decode(&tmp)
			switch v := tmp.(type) {
			case string:
				value, err := strconv.Atoi(v)
				if err != nil {
					return fmt.Errorf("%s | %w", "RankWindowSize", err)
				}
				s.RankWindowSize = &value
			case float64:
				f := int(v)
				s.RankWindowSize = &f
			}

		case "retriever":
			if err := dec.Decode(&s.Retriever); err != nil {
				return fmt.Errorf("%s | %w", "Retriever", err)
			}

		case "ruleset_ids":
			if err := dec.Decode(&s.RulesetIds); err != nil {
				return fmt.Errorf("%s | %w", "RulesetIds", err)
			}

		}
	}
	return nil
}

// NewRuleRetriever returns a RuleRetriever.
func NewRuleRetriever() *RuleRetriever {
	r := &RuleRetriever{}

	return r
}

// true

type RuleRetrieverVariant interface {
	RuleRetrieverCaster() *RuleRetriever
}

func (s *RuleRetriever) RuleRetrieverCaster() *RuleRetriever {
	return s
}
