// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated from the elasticsearch-specification DO NOT EDIT.
// https://github.com/elastic/elasticsearch-specification/tree/f6a370d0fba975752c644fc730f7c45610e28f36

package types

import (
	"bytes"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"strconv"
)

// MistralServiceSettings type.
//
// https://github.com/elastic/elasticsearch-specification/blob/f6a370d0fba975752c644fc730f7c45610e28f36/specification/inference/_types/CommonTypes.ts#L976-L1003
type MistralServiceSettings struct {
	// ApiKey A valid API key of your Mistral account.
	// You can find your Mistral API keys or you can create a new one on the API
	// Keys page.
	//
	// IMPORTANT: You need to provide the API key only once, during the inference
	// model creation.
	// The get inference endpoint API does not retrieve your API key.
	// After creating the inference model, you cannot change the associated API key.
	// If you want to use a different API key, delete the inference model and
	// recreate it with the same name and the updated API key.
	ApiKey string `json:"api_key"`
	// MaxInputTokens The maximum number of tokens per input before chunking occurs.
	MaxInputTokens *int `json:"max_input_tokens,omitempty"`
	// Model The name of the model to use for the inference task.
	// Refer to the Mistral models documentation for the list of available text
	// embedding models.
	Model string `json:"model"`
	// RateLimit This setting helps to minimize the number of rate limit errors returned from
	// the Mistral API.
	// By default, the `mistral` service sets the number of requests allowed per
	// minute to 240.
	RateLimit *RateLimitSetting `json:"rate_limit,omitempty"`
}

func (s *MistralServiceSettings) UnmarshalJSON(data []byte) error {

	dec := json.NewDecoder(bytes.NewReader(data))

	for {
		t, err := dec.Token()
		if err != nil {
			if errors.Is(err, io.EOF) {
				break
			}
			return err
		}

		switch t {

		case "api_key":
			var tmp json.RawMessage
			if err := dec.Decode(&tmp); err != nil {
				return fmt.Errorf("%s | %w", "ApiKey", err)
			}
			o := string(tmp[:])
			o, err = strconv.Unquote(o)
			if err != nil {
				o = string(tmp[:])
			}
			s.ApiKey = o

		case "max_input_tokens":

			var tmp any
			dec.Decode(&tmp)
			switch v := tmp.(type) {
			case string:
				value, err := strconv.Atoi(v)
				if err != nil {
					return fmt.Errorf("%s | %w", "MaxInputTokens", err)
				}
				s.MaxInputTokens = &value
			case float64:
				f := int(v)
				s.MaxInputTokens = &f
			}

		case "model":
			var tmp json.RawMessage
			if err := dec.Decode(&tmp); err != nil {
				return fmt.Errorf("%s | %w", "Model", err)
			}
			o := string(tmp[:])
			o, err = strconv.Unquote(o)
			if err != nil {
				o = string(tmp[:])
			}
			s.Model = o

		case "rate_limit":
			if err := dec.Decode(&s.RateLimit); err != nil {
				return fmt.Errorf("%s | %w", "RateLimit", err)
			}

		}
	}
	return nil
}

// NewMistralServiceSettings returns a MistralServiceSettings.
func NewMistralServiceSettings() *MistralServiceSettings {
	r := &MistralServiceSettings{}

	return r
}

// true

type MistralServiceSettingsVariant interface {
	MistralServiceSettingsCaster() *MistralServiceSettings
}

func (s *MistralServiceSettings) MistralServiceSettingsCaster() *MistralServiceSettings {
	return s
}
