// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated from the elasticsearch-specification DO NOT EDIT.
// https://github.com/elastic/elasticsearch-specification/tree/f6a370d0fba975752c644fc730f7c45610e28f36

package types

import (
	"bytes"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"strconv"
)

// IngestPipelineParams type.
//
// https://github.com/elastic/elasticsearch-specification/blob/f6a370d0fba975752c644fc730f7c45610e28f36/specification/connector/_types/Connector.ts#L148-L153
type IngestPipelineParams struct {
	ExtractBinaryContent bool   `json:"extract_binary_content"`
	Name                 string `json:"name"`
	ReduceWhitespace     bool   `json:"reduce_whitespace"`
	RunMlInference       bool   `json:"run_ml_inference"`
}

func (s *IngestPipelineParams) UnmarshalJSON(data []byte) error {

	dec := json.NewDecoder(bytes.NewReader(data))

	for {
		t, err := dec.Token()
		if err != nil {
			if errors.Is(err, io.EOF) {
				break
			}
			return err
		}

		switch t {

		case "extract_binary_content":
			var tmp any
			dec.Decode(&tmp)
			switch v := tmp.(type) {
			case string:
				value, err := strconv.ParseBool(v)
				if err != nil {
					return fmt.Errorf("%s | %w", "ExtractBinaryContent", err)
				}
				s.ExtractBinaryContent = value
			case bool:
				s.ExtractBinaryContent = v
			}

		case "name":
			var tmp json.RawMessage
			if err := dec.Decode(&tmp); err != nil {
				return fmt.Errorf("%s | %w", "Name", err)
			}
			o := string(tmp[:])
			o, err = strconv.Unquote(o)
			if err != nil {
				o = string(tmp[:])
			}
			s.Name = o

		case "reduce_whitespace":
			var tmp any
			dec.Decode(&tmp)
			switch v := tmp.(type) {
			case string:
				value, err := strconv.ParseBool(v)
				if err != nil {
					return fmt.Errorf("%s | %w", "ReduceWhitespace", err)
				}
				s.ReduceWhitespace = value
			case bool:
				s.ReduceWhitespace = v
			}

		case "run_ml_inference":
			var tmp any
			dec.Decode(&tmp)
			switch v := tmp.(type) {
			case string:
				value, err := strconv.ParseBool(v)
				if err != nil {
					return fmt.Errorf("%s | %w", "RunMlInference", err)
				}
				s.RunMlInference = value
			case bool:
				s.RunMlInference = v
			}

		}
	}
	return nil
}

// NewIngestPipelineParams returns a IngestPipelineParams.
func NewIngestPipelineParams() *IngestPipelineParams {
	r := &IngestPipelineParams{}

	return r
}

// true

type IngestPipelineParamsVariant interface {
	IngestPipelineParamsCaster() *IngestPipelineParams
}

func (s *IngestPipelineParams) IngestPipelineParamsCaster() *IngestPipelineParams {
	return s
}
