// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated from the elasticsearch-specification DO NOT EDIT.
// https://github.com/elastic/elasticsearch-specification/tree/f6a370d0fba975752c644fc730f7c45610e28f36

// Package syncjobtype
package syncjobtype

import "strings"

// https://github.com/elastic/elasticsearch-specification/blob/f6a370d0fba975752c644fc730f7c45610e28f36/specification/connector/_types/SyncJob.ts#L42-L46
type SyncJobType struct {
	Name string
}

var (
	Full = SyncJobType{"full"}

	Incremental = SyncJobType{"incremental"}

	Accesscontrol = SyncJobType{"access_control"}
)

func (s SyncJobType) MarshalText() (text []byte, err error) {
	return []byte(s.String()), nil
}

func (s *SyncJobType) UnmarshalText(text []byte) error {
	switch strings.ReplaceAll(strings.ToLower(string(text)), "\"", "") {

	case "full":
		*s = Full
	case "incremental":
		*s = Incremental
	case "access_control":
		*s = Accesscontrol
	default:
		*s = SyncJobType{string(text)}
	}

	return nil
}

func (s SyncJobType) String() string {
	return s.Name
}
