// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated from the elasticsearch-specification DO NOT EDIT.
// https://github.com/elastic/elasticsearch-specification/tree/f6a370d0fba975752c644fc730f7c45610e28f36

package types

import (
	"bytes"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"strconv"
)

// DiskUsage type.
//
// https://github.com/elastic/elasticsearch-specification/blob/f6a370d0fba975752c644fc730f7c45610e28f36/specification/cluster/allocation_explain/types.ts#L63-L70
type DiskUsage struct {
	FreeBytes       int64   `json:"free_bytes"`
	FreeDiskPercent Float64 `json:"free_disk_percent"`
	Path            string  `json:"path"`
	TotalBytes      int64   `json:"total_bytes"`
	UsedBytes       int64   `json:"used_bytes"`
	UsedDiskPercent Float64 `json:"used_disk_percent"`
}

func (s *DiskUsage) UnmarshalJSON(data []byte) error {

	dec := json.NewDecoder(bytes.NewReader(data))

	for {
		t, err := dec.Token()
		if err != nil {
			if errors.Is(err, io.EOF) {
				break
			}
			return err
		}

		switch t {

		case "free_bytes":
			var tmp any
			dec.Decode(&tmp)
			switch v := tmp.(type) {
			case string:
				value, err := strconv.ParseInt(v, 10, 64)
				if err != nil {
					return fmt.Errorf("%s | %w", "FreeBytes", err)
				}
				s.FreeBytes = value
			case float64:
				f := int64(v)
				s.FreeBytes = f
			}

		case "free_disk_percent":
			var tmp any
			dec.Decode(&tmp)
			switch v := tmp.(type) {
			case string:
				value, err := strconv.ParseFloat(v, 64)
				if err != nil {
					return fmt.Errorf("%s | %w", "FreeDiskPercent", err)
				}
				f := Float64(value)
				s.FreeDiskPercent = f
			case float64:
				f := Float64(v)
				s.FreeDiskPercent = f
			}

		case "path":
			var tmp json.RawMessage
			if err := dec.Decode(&tmp); err != nil {
				return fmt.Errorf("%s | %w", "Path", err)
			}
			o := string(tmp[:])
			o, err = strconv.Unquote(o)
			if err != nil {
				o = string(tmp[:])
			}
			s.Path = o

		case "total_bytes":
			var tmp any
			dec.Decode(&tmp)
			switch v := tmp.(type) {
			case string:
				value, err := strconv.ParseInt(v, 10, 64)
				if err != nil {
					return fmt.Errorf("%s | %w", "TotalBytes", err)
				}
				s.TotalBytes = value
			case float64:
				f := int64(v)
				s.TotalBytes = f
			}

		case "used_bytes":
			var tmp any
			dec.Decode(&tmp)
			switch v := tmp.(type) {
			case string:
				value, err := strconv.ParseInt(v, 10, 64)
				if err != nil {
					return fmt.Errorf("%s | %w", "UsedBytes", err)
				}
				s.UsedBytes = value
			case float64:
				f := int64(v)
				s.UsedBytes = f
			}

		case "used_disk_percent":
			var tmp any
			dec.Decode(&tmp)
			switch v := tmp.(type) {
			case string:
				value, err := strconv.ParseFloat(v, 64)
				if err != nil {
					return fmt.Errorf("%s | %w", "UsedDiskPercent", err)
				}
				f := Float64(value)
				s.UsedDiskPercent = f
			case float64:
				f := Float64(v)
				s.UsedDiskPercent = f
			}

		}
	}
	return nil
}

// NewDiskUsage returns a DiskUsage.
func NewDiskUsage() *DiskUsage {
	r := &DiskUsage{}

	return r
}

// false
