// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated from the elasticsearch-specification DO NOT EDIT.
// https://github.com/elastic/elasticsearch-specification/tree/f6a370d0fba975752c644fc730f7c45610e28f36

package types

import (
	"bytes"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"strconv"
)

// CompletionToolFunction type.
//
// https://github.com/elastic/elasticsearch-specification/blob/f6a370d0fba975752c644fc730f7c45610e28f36/specification/inference/_types/CommonTypes.ts#L182-L203
type CompletionToolFunction struct {
	// Description A description of what the function does.
	// This is used by the model to choose when and how to call the function.
	Description *string `json:"description,omitempty"`
	// Name The name of the function.
	Name string `json:"name"`
	// Parameters The parameters the functional accepts. This should be formatted as a JSON
	// object.
	Parameters json.RawMessage `json:"parameters,omitempty"`
	// Strict Whether to enable schema adherence when generating the function call.
	Strict *bool `json:"strict,omitempty"`
}

func (s *CompletionToolFunction) UnmarshalJSON(data []byte) error {

	dec := json.NewDecoder(bytes.NewReader(data))

	for {
		t, err := dec.Token()
		if err != nil {
			if errors.Is(err, io.EOF) {
				break
			}
			return err
		}

		switch t {

		case "description":
			var tmp json.RawMessage
			if err := dec.Decode(&tmp); err != nil {
				return fmt.Errorf("%s | %w", "Description", err)
			}
			o := string(tmp[:])
			o, err = strconv.Unquote(o)
			if err != nil {
				o = string(tmp[:])
			}
			s.Description = &o

		case "name":
			var tmp json.RawMessage
			if err := dec.Decode(&tmp); err != nil {
				return fmt.Errorf("%s | %w", "Name", err)
			}
			o := string(tmp[:])
			o, err = strconv.Unquote(o)
			if err != nil {
				o = string(tmp[:])
			}
			s.Name = o

		case "parameters":
			if err := dec.Decode(&s.Parameters); err != nil {
				return fmt.Errorf("%s | %w", "Parameters", err)
			}

		case "strict":
			var tmp any
			dec.Decode(&tmp)
			switch v := tmp.(type) {
			case string:
				value, err := strconv.ParseBool(v)
				if err != nil {
					return fmt.Errorf("%s | %w", "Strict", err)
				}
				s.Strict = &value
			case bool:
				s.Strict = &v
			}

		}
	}
	return nil
}

// NewCompletionToolFunction returns a CompletionToolFunction.
func NewCompletionToolFunction() *CompletionToolFunction {
	r := &CompletionToolFunction{}

	return r
}

// true

type CompletionToolFunctionVariant interface {
	CompletionToolFunctionCaster() *CompletionToolFunction
}

func (s *CompletionToolFunction) CompletionToolFunctionCaster() *CompletionToolFunction {
	return s
}
