// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated from the elasticsearch-specification DO NOT EDIT.
// https://github.com/elastic/elasticsearch-specification/tree/f6a370d0fba975752c644fc730f7c45610e28f36

package types

import (
	"bytes"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"strconv"
)

// ApplicationPrivileges type.
//
// https://github.com/elastic/elasticsearch-specification/blob/f6a370d0fba975752c644fc730f7c45610e28f36/specification/security/_types/Privileges.ts#L27-L40
type ApplicationPrivileges struct {
	// Application The name of the application to which this entry applies.
	Application string `json:"application"`
	// Privileges A list of strings, where each element is the name of an application privilege
	// or action.
	Privileges []string `json:"privileges"`
	// Resources A list resources to which the privileges are applied.
	Resources []string `json:"resources"`
}

func (s *ApplicationPrivileges) UnmarshalJSON(data []byte) error {

	dec := json.NewDecoder(bytes.NewReader(data))

	for {
		t, err := dec.Token()
		if err != nil {
			if errors.Is(err, io.EOF) {
				break
			}
			return err
		}

		switch t {

		case "application":
			var tmp json.RawMessage
			if err := dec.Decode(&tmp); err != nil {
				return fmt.Errorf("%s | %w", "Application", err)
			}
			o := string(tmp[:])
			o, err = strconv.Unquote(o)
			if err != nil {
				o = string(tmp[:])
			}
			s.Application = o

		case "privileges":
			if err := dec.Decode(&s.Privileges); err != nil {
				return fmt.Errorf("%s | %w", "Privileges", err)
			}

		case "resources":
			if err := dec.Decode(&s.Resources); err != nil {
				return fmt.Errorf("%s | %w", "Resources", err)
			}

		}
	}
	return nil
}

// NewApplicationPrivileges returns a ApplicationPrivileges.
func NewApplicationPrivileges() *ApplicationPrivileges {
	r := &ApplicationPrivileges{}

	return r
}

// true

type ApplicationPrivilegesVariant interface {
	ApplicationPrivilegesCaster() *ApplicationPrivileges
}

func (s *ApplicationPrivileges) ApplicationPrivilegesCaster() *ApplicationPrivileges {
	return s
}
