// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/mattermost/mattermost/server/v8/cmd/mmctl/client (interfaces: Client)

// Package mocks is a generated GoMock package.
package mocks

import (
	context "context"
	io "io"
	http "net/http"
	reflect "reflect"

	gomock "github.com/golang/mock/gomock"
	model "github.com/mattermost/mattermost/server/public/model"
)

// MockClient is a mock of Client interface.
type MockClient struct {
	ctrl     *gomock.Controller
	recorder *MockClientMockRecorder
}

// MockClientMockRecorder is the mock recorder for MockClient.
type MockClientMockRecorder struct {
	mock *MockClient
}

// NewMockClient creates a new mock instance.
func NewMockClient(ctrl *gomock.Controller) *MockClient {
	mock := &MockClient{ctrl: ctrl}
	mock.recorder = &MockClientMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockClient) EXPECT() *MockClientMockRecorder {
	return m.recorder
}

// AddChannelMember mocks base method.
func (m *MockClient) AddChannelMember(arg0 context.Context, arg1, arg2 string) (*model.ChannelMember, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddChannelMember", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.ChannelMember)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddChannelMember indicates an expected call of AddChannelMember.
func (mr *MockClientMockRecorder) AddChannelMember(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddChannelMember", reflect.TypeOf((*MockClient)(nil).AddChannelMember), arg0, arg1, arg2)
}

// AddTeamMember mocks base method.
func (m *MockClient) AddTeamMember(arg0 context.Context, arg1, arg2 string) (*model.TeamMember, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddTeamMember", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.TeamMember)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddTeamMember indicates an expected call of AddTeamMember.
func (mr *MockClientMockRecorder) AddTeamMember(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddTeamMember", reflect.TypeOf((*MockClient)(nil).AddTeamMember), arg0, arg1, arg2)
}

// AssignBot mocks base method.
func (m *MockClient) AssignBot(arg0 context.Context, arg1, arg2 string) (*model.Bot, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssignBot", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Bot)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AssignBot indicates an expected call of AssignBot.
func (mr *MockClientMockRecorder) AssignBot(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssignBot", reflect.TypeOf((*MockClient)(nil).AssignBot), arg0, arg1, arg2)
}

// CancelJob mocks base method.
func (m *MockClient) CancelJob(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CancelJob", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CancelJob indicates an expected call of CancelJob.
func (mr *MockClientMockRecorder) CancelJob(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CancelJob", reflect.TypeOf((*MockClient)(nil).CancelJob), arg0, arg1)
}

// CheckIntegrity mocks base method.
func (m *MockClient) CheckIntegrity(arg0 context.Context) ([]model.IntegrityCheckResult, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CheckIntegrity", arg0)
	ret0, _ := ret[0].([]model.IntegrityCheckResult)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CheckIntegrity indicates an expected call of CheckIntegrity.
func (mr *MockClientMockRecorder) CheckIntegrity(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CheckIntegrity", reflect.TypeOf((*MockClient)(nil).CheckIntegrity), arg0)
}

// ClearServerBusy mocks base method.
func (m *MockClient) ClearServerBusy(arg0 context.Context) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ClearServerBusy", arg0)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ClearServerBusy indicates an expected call of ClearServerBusy.
func (mr *MockClientMockRecorder) ClearServerBusy(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ClearServerBusy", reflect.TypeOf((*MockClient)(nil).ClearServerBusy), arg0)
}

// ConvertBotToUser mocks base method.
func (m *MockClient) ConvertBotToUser(arg0 context.Context, arg1 string, arg2 *model.UserPatch, arg3 bool) (*model.User, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ConvertBotToUser", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*model.User)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// ConvertBotToUser indicates an expected call of ConvertBotToUser.
func (mr *MockClientMockRecorder) ConvertBotToUser(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ConvertBotToUser", reflect.TypeOf((*MockClient)(nil).ConvertBotToUser), arg0, arg1, arg2, arg3)
}

// ConvertUserToBot mocks base method.
func (m *MockClient) ConvertUserToBot(arg0 context.Context, arg1 string) (*model.Bot, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ConvertUserToBot", arg0, arg1)
	ret0, _ := ret[0].(*model.Bot)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// ConvertUserToBot indicates an expected call of ConvertUserToBot.
func (mr *MockClientMockRecorder) ConvertUserToBot(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ConvertUserToBot", reflect.TypeOf((*MockClient)(nil).ConvertUserToBot), arg0, arg1)
}

// CreateBot mocks base method.
func (m *MockClient) CreateBot(arg0 context.Context, arg1 *model.Bot) (*model.Bot, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateBot", arg0, arg1)
	ret0, _ := ret[0].(*model.Bot)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CreateBot indicates an expected call of CreateBot.
func (mr *MockClientMockRecorder) CreateBot(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateBot", reflect.TypeOf((*MockClient)(nil).CreateBot), arg0, arg1)
}

// CreateChannel mocks base method.
func (m *MockClient) CreateChannel(arg0 context.Context, arg1 *model.Channel) (*model.Channel, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateChannel", arg0, arg1)
	ret0, _ := ret[0].(*model.Channel)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CreateChannel indicates an expected call of CreateChannel.
func (mr *MockClientMockRecorder) CreateChannel(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateChannel", reflect.TypeOf((*MockClient)(nil).CreateChannel), arg0, arg1)
}

// CreateCommand mocks base method.
func (m *MockClient) CreateCommand(arg0 context.Context, arg1 *model.Command) (*model.Command, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateCommand", arg0, arg1)
	ret0, _ := ret[0].(*model.Command)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CreateCommand indicates an expected call of CreateCommand.
func (mr *MockClientMockRecorder) CreateCommand(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateCommand", reflect.TypeOf((*MockClient)(nil).CreateCommand), arg0, arg1)
}

// CreateIncomingWebhook mocks base method.
func (m *MockClient) CreateIncomingWebhook(arg0 context.Context, arg1 *model.IncomingWebhook) (*model.IncomingWebhook, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateIncomingWebhook", arg0, arg1)
	ret0, _ := ret[0].(*model.IncomingWebhook)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CreateIncomingWebhook indicates an expected call of CreateIncomingWebhook.
func (mr *MockClientMockRecorder) CreateIncomingWebhook(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateIncomingWebhook", reflect.TypeOf((*MockClient)(nil).CreateIncomingWebhook), arg0, arg1)
}

// CreateJob mocks base method.
func (m *MockClient) CreateJob(arg0 context.Context, arg1 *model.Job) (*model.Job, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateJob", arg0, arg1)
	ret0, _ := ret[0].(*model.Job)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CreateJob indicates an expected call of CreateJob.
func (mr *MockClientMockRecorder) CreateJob(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateJob", reflect.TypeOf((*MockClient)(nil).CreateJob), arg0, arg1)
}

// CreateOutgoingWebhook mocks base method.
func (m *MockClient) CreateOutgoingWebhook(arg0 context.Context, arg1 *model.OutgoingWebhook) (*model.OutgoingWebhook, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateOutgoingWebhook", arg0, arg1)
	ret0, _ := ret[0].(*model.OutgoingWebhook)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CreateOutgoingWebhook indicates an expected call of CreateOutgoingWebhook.
func (mr *MockClientMockRecorder) CreateOutgoingWebhook(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateOutgoingWebhook", reflect.TypeOf((*MockClient)(nil).CreateOutgoingWebhook), arg0, arg1)
}

// CreatePost mocks base method.
func (m *MockClient) CreatePost(arg0 context.Context, arg1 *model.Post) (*model.Post, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreatePost", arg0, arg1)
	ret0, _ := ret[0].(*model.Post)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CreatePost indicates an expected call of CreatePost.
func (mr *MockClientMockRecorder) CreatePost(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreatePost", reflect.TypeOf((*MockClient)(nil).CreatePost), arg0, arg1)
}

// CreateTeam mocks base method.
func (m *MockClient) CreateTeam(arg0 context.Context, arg1 *model.Team) (*model.Team, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateTeam", arg0, arg1)
	ret0, _ := ret[0].(*model.Team)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CreateTeam indicates an expected call of CreateTeam.
func (mr *MockClientMockRecorder) CreateTeam(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateTeam", reflect.TypeOf((*MockClient)(nil).CreateTeam), arg0, arg1)
}

// CreateUpload mocks base method.
func (m *MockClient) CreateUpload(arg0 context.Context, arg1 *model.UploadSession) (*model.UploadSession, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateUpload", arg0, arg1)
	ret0, _ := ret[0].(*model.UploadSession)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CreateUpload indicates an expected call of CreateUpload.
func (mr *MockClientMockRecorder) CreateUpload(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateUpload", reflect.TypeOf((*MockClient)(nil).CreateUpload), arg0, arg1)
}

// CreateUser mocks base method.
func (m *MockClient) CreateUser(arg0 context.Context, arg1 *model.User) (*model.User, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateUser", arg0, arg1)
	ret0, _ := ret[0].(*model.User)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CreateUser indicates an expected call of CreateUser.
func (mr *MockClientMockRecorder) CreateUser(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateUser", reflect.TypeOf((*MockClient)(nil).CreateUser), arg0, arg1)
}

// CreateUserAccessToken mocks base method.
func (m *MockClient) CreateUserAccessToken(arg0 context.Context, arg1, arg2 string) (*model.UserAccessToken, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateUserAccessToken", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.UserAccessToken)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// CreateUserAccessToken indicates an expected call of CreateUserAccessToken.
func (mr *MockClientMockRecorder) CreateUserAccessToken(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateUserAccessToken", reflect.TypeOf((*MockClient)(nil).CreateUserAccessToken), arg0, arg1, arg2)
}

// DeleteChannel mocks base method.
func (m *MockClient) DeleteChannel(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteChannel", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteChannel indicates an expected call of DeleteChannel.
func (mr *MockClientMockRecorder) DeleteChannel(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteChannel", reflect.TypeOf((*MockClient)(nil).DeleteChannel), arg0, arg1)
}

// DeleteCommand mocks base method.
func (m *MockClient) DeleteCommand(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteCommand", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteCommand indicates an expected call of DeleteCommand.
func (mr *MockClientMockRecorder) DeleteCommand(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteCommand", reflect.TypeOf((*MockClient)(nil).DeleteCommand), arg0, arg1)
}

// DeleteExport mocks base method.
func (m *MockClient) DeleteExport(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteExport", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteExport indicates an expected call of DeleteExport.
func (mr *MockClientMockRecorder) DeleteExport(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteExport", reflect.TypeOf((*MockClient)(nil).DeleteExport), arg0, arg1)
}

// DeleteImport mocks base method.
func (m *MockClient) DeleteImport(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteImport", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteImport indicates an expected call of DeleteImport.
func (mr *MockClientMockRecorder) DeleteImport(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteImport", reflect.TypeOf((*MockClient)(nil).DeleteImport), arg0, arg1)
}

// DeleteIncomingWebhook mocks base method.
func (m *MockClient) DeleteIncomingWebhook(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteIncomingWebhook", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteIncomingWebhook indicates an expected call of DeleteIncomingWebhook.
func (mr *MockClientMockRecorder) DeleteIncomingWebhook(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteIncomingWebhook", reflect.TypeOf((*MockClient)(nil).DeleteIncomingWebhook), arg0, arg1)
}

// DeleteOutgoingWebhook mocks base method.
func (m *MockClient) DeleteOutgoingWebhook(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteOutgoingWebhook", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeleteOutgoingWebhook indicates an expected call of DeleteOutgoingWebhook.
func (mr *MockClientMockRecorder) DeleteOutgoingWebhook(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteOutgoingWebhook", reflect.TypeOf((*MockClient)(nil).DeleteOutgoingWebhook), arg0, arg1)
}

// DeletePost mocks base method.
func (m *MockClient) DeletePost(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeletePost", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeletePost indicates an expected call of DeletePost.
func (mr *MockClientMockRecorder) DeletePost(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeletePost", reflect.TypeOf((*MockClient)(nil).DeletePost), arg0, arg1)
}

// DeletePreferences mocks base method.
func (m *MockClient) DeletePreferences(arg0 context.Context, arg1 string, arg2 model.Preferences) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeletePreferences", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DeletePreferences indicates an expected call of DeletePreferences.
func (mr *MockClientMockRecorder) DeletePreferences(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeletePreferences", reflect.TypeOf((*MockClient)(nil).DeletePreferences), arg0, arg1, arg2)
}

// DemoteUserToGuest mocks base method.
func (m *MockClient) DemoteUserToGuest(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DemoteUserToGuest", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DemoteUserToGuest indicates an expected call of DemoteUserToGuest.
func (mr *MockClientMockRecorder) DemoteUserToGuest(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DemoteUserToGuest", reflect.TypeOf((*MockClient)(nil).DemoteUserToGuest), arg0, arg1)
}

// DisableBot mocks base method.
func (m *MockClient) DisableBot(arg0 context.Context, arg1 string) (*model.Bot, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisableBot", arg0, arg1)
	ret0, _ := ret[0].(*model.Bot)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// DisableBot indicates an expected call of DisableBot.
func (mr *MockClientMockRecorder) DisableBot(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableBot", reflect.TypeOf((*MockClient)(nil).DisableBot), arg0, arg1)
}

// DisablePlugin mocks base method.
func (m *MockClient) DisablePlugin(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DisablePlugin", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DisablePlugin indicates an expected call of DisablePlugin.
func (mr *MockClientMockRecorder) DisablePlugin(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisablePlugin", reflect.TypeOf((*MockClient)(nil).DisablePlugin), arg0, arg1)
}

// DoAPIPost mocks base method.
func (m *MockClient) DoAPIPost(arg0 context.Context, arg1, arg2 string) (*http.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DoAPIPost", arg0, arg1, arg2)
	ret0, _ := ret[0].(*http.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DoAPIPost indicates an expected call of DoAPIPost.
func (mr *MockClientMockRecorder) DoAPIPost(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DoAPIPost", reflect.TypeOf((*MockClient)(nil).DoAPIPost), arg0, arg1, arg2)
}

// DownloadComplianceExport mocks base method.
func (m *MockClient) DownloadComplianceExport(arg0 context.Context, arg1 string, arg2 io.Writer) (string, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DownloadComplianceExport", arg0, arg1, arg2)
	ret0, _ := ret[0].(string)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DownloadComplianceExport indicates an expected call of DownloadComplianceExport.
func (mr *MockClientMockRecorder) DownloadComplianceExport(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DownloadComplianceExport", reflect.TypeOf((*MockClient)(nil).DownloadComplianceExport), arg0, arg1, arg2)
}

// DownloadExport mocks base method.
func (m *MockClient) DownloadExport(arg0 context.Context, arg1 string, arg2 io.Writer, arg3 int64) (int64, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DownloadExport", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// DownloadExport indicates an expected call of DownloadExport.
func (mr *MockClientMockRecorder) DownloadExport(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DownloadExport", reflect.TypeOf((*MockClient)(nil).DownloadExport), arg0, arg1, arg2, arg3)
}

// EnableBot mocks base method.
func (m *MockClient) EnableBot(arg0 context.Context, arg1 string) (*model.Bot, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnableBot", arg0, arg1)
	ret0, _ := ret[0].(*model.Bot)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// EnableBot indicates an expected call of EnableBot.
func (mr *MockClientMockRecorder) EnableBot(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableBot", reflect.TypeOf((*MockClient)(nil).EnableBot), arg0, arg1)
}

// EnablePlugin mocks base method.
func (m *MockClient) EnablePlugin(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EnablePlugin", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// EnablePlugin indicates an expected call of EnablePlugin.
func (mr *MockClientMockRecorder) EnablePlugin(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnablePlugin", reflect.TypeOf((*MockClient)(nil).EnablePlugin), arg0, arg1)
}

// GeneratePresignedURL mocks base method.
func (m *MockClient) GeneratePresignedURL(arg0 context.Context, arg1 string) (*model.PresignURLResponse, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GeneratePresignedURL", arg0, arg1)
	ret0, _ := ret[0].(*model.PresignURLResponse)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GeneratePresignedURL indicates an expected call of GeneratePresignedURL.
func (mr *MockClientMockRecorder) GeneratePresignedURL(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GeneratePresignedURL", reflect.TypeOf((*MockClient)(nil).GeneratePresignedURL), arg0, arg1)
}

// GenerateSupportPacket mocks base method.
func (m *MockClient) GenerateSupportPacket(arg0 context.Context) (io.ReadCloser, string, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GenerateSupportPacket", arg0)
	ret0, _ := ret[0].(io.ReadCloser)
	ret1, _ := ret[1].(string)
	ret2, _ := ret[2].(*model.Response)
	ret3, _ := ret[3].(error)
	return ret0, ret1, ret2, ret3
}

// GenerateSupportPacket indicates an expected call of GenerateSupportPacket.
func (mr *MockClientMockRecorder) GenerateSupportPacket(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GenerateSupportPacket", reflect.TypeOf((*MockClient)(nil).GenerateSupportPacket), arg0)
}

// GetAllTeams mocks base method.
func (m *MockClient) GetAllTeams(arg0 context.Context, arg1 string, arg2, arg3 int) ([]*model.Team, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAllTeams", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].([]*model.Team)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetAllTeams indicates an expected call of GetAllTeams.
func (mr *MockClientMockRecorder) GetAllTeams(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAllTeams", reflect.TypeOf((*MockClient)(nil).GetAllTeams), arg0, arg1, arg2, arg3)
}

// GetBots mocks base method.
func (m *MockClient) GetBots(arg0 context.Context, arg1, arg2 int, arg3 string) ([]*model.Bot, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetBots", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].([]*model.Bot)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetBots indicates an expected call of GetBots.
func (mr *MockClientMockRecorder) GetBots(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetBots", reflect.TypeOf((*MockClient)(nil).GetBots), arg0, arg1, arg2, arg3)
}

// GetBotsIncludeDeleted mocks base method.
func (m *MockClient) GetBotsIncludeDeleted(arg0 context.Context, arg1, arg2 int, arg3 string) ([]*model.Bot, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetBotsIncludeDeleted", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].([]*model.Bot)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetBotsIncludeDeleted indicates an expected call of GetBotsIncludeDeleted.
func (mr *MockClientMockRecorder) GetBotsIncludeDeleted(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetBotsIncludeDeleted", reflect.TypeOf((*MockClient)(nil).GetBotsIncludeDeleted), arg0, arg1, arg2, arg3)
}

// GetBotsOrphaned mocks base method.
func (m *MockClient) GetBotsOrphaned(arg0 context.Context, arg1, arg2 int, arg3 string) ([]*model.Bot, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetBotsOrphaned", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].([]*model.Bot)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetBotsOrphaned indicates an expected call of GetBotsOrphaned.
func (mr *MockClientMockRecorder) GetBotsOrphaned(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetBotsOrphaned", reflect.TypeOf((*MockClient)(nil).GetBotsOrphaned), arg0, arg1, arg2, arg3)
}

// GetChannel mocks base method.
func (m *MockClient) GetChannel(arg0 context.Context, arg1, arg2 string) (*model.Channel, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetChannel", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Channel)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetChannel indicates an expected call of GetChannel.
func (mr *MockClientMockRecorder) GetChannel(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetChannel", reflect.TypeOf((*MockClient)(nil).GetChannel), arg0, arg1, arg2)
}

// GetChannelByName mocks base method.
func (m *MockClient) GetChannelByName(arg0 context.Context, arg1, arg2, arg3 string) (*model.Channel, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetChannelByName", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*model.Channel)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetChannelByName indicates an expected call of GetChannelByName.
func (mr *MockClientMockRecorder) GetChannelByName(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetChannelByName", reflect.TypeOf((*MockClient)(nil).GetChannelByName), arg0, arg1, arg2, arg3)
}

// GetChannelByNameIncludeDeleted mocks base method.
func (m *MockClient) GetChannelByNameIncludeDeleted(arg0 context.Context, arg1, arg2, arg3 string) (*model.Channel, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetChannelByNameIncludeDeleted", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*model.Channel)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetChannelByNameIncludeDeleted indicates an expected call of GetChannelByNameIncludeDeleted.
func (mr *MockClientMockRecorder) GetChannelByNameIncludeDeleted(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetChannelByNameIncludeDeleted", reflect.TypeOf((*MockClient)(nil).GetChannelByNameIncludeDeleted), arg0, arg1, arg2, arg3)
}

// GetChannelMembers mocks base method.
func (m *MockClient) GetChannelMembers(arg0 context.Context, arg1 string, arg2, arg3 int, arg4 string) (model.ChannelMembers, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetChannelMembers", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].(model.ChannelMembers)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetChannelMembers indicates an expected call of GetChannelMembers.
func (mr *MockClientMockRecorder) GetChannelMembers(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetChannelMembers", reflect.TypeOf((*MockClient)(nil).GetChannelMembers), arg0, arg1, arg2, arg3, arg4)
}

// GetChannelsForTeamForUser mocks base method.
func (m *MockClient) GetChannelsForTeamForUser(arg0 context.Context, arg1, arg2 string, arg3 bool, arg4 string) ([]*model.Channel, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetChannelsForTeamForUser", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].([]*model.Channel)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetChannelsForTeamForUser indicates an expected call of GetChannelsForTeamForUser.
func (mr *MockClientMockRecorder) GetChannelsForTeamForUser(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetChannelsForTeamForUser", reflect.TypeOf((*MockClient)(nil).GetChannelsForTeamForUser), arg0, arg1, arg2, arg3, arg4)
}

// GetCommandById mocks base method.
func (m *MockClient) GetCommandById(arg0 context.Context, arg1 string) (*model.Command, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetCommandById", arg0, arg1)
	ret0, _ := ret[0].(*model.Command)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetCommandById indicates an expected call of GetCommandById.
func (mr *MockClientMockRecorder) GetCommandById(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetCommandById", reflect.TypeOf((*MockClient)(nil).GetCommandById), arg0, arg1)
}

// GetConfig mocks base method.
func (m *MockClient) GetConfig(arg0 context.Context) (*model.Config, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetConfig", arg0)
	ret0, _ := ret[0].(*model.Config)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetConfig indicates an expected call of GetConfig.
func (mr *MockClientMockRecorder) GetConfig(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetConfig", reflect.TypeOf((*MockClient)(nil).GetConfig), arg0)
}

// GetConfigWithOptions mocks base method.
func (m *MockClient) GetConfigWithOptions(arg0 context.Context, arg1 model.GetConfigOptions) (map[string]interface{}, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetConfigWithOptions", arg0, arg1)
	ret0, _ := ret[0].(map[string]interface{})
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetConfigWithOptions indicates an expected call of GetConfigWithOptions.
func (mr *MockClientMockRecorder) GetConfigWithOptions(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetConfigWithOptions", reflect.TypeOf((*MockClient)(nil).GetConfigWithOptions), arg0, arg1)
}

// GetDeletedChannelsForTeam mocks base method.
func (m *MockClient) GetDeletedChannelsForTeam(arg0 context.Context, arg1 string, arg2, arg3 int, arg4 string) ([]*model.Channel, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetDeletedChannelsForTeam", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].([]*model.Channel)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetDeletedChannelsForTeam indicates an expected call of GetDeletedChannelsForTeam.
func (mr *MockClientMockRecorder) GetDeletedChannelsForTeam(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetDeletedChannelsForTeam", reflect.TypeOf((*MockClient)(nil).GetDeletedChannelsForTeam), arg0, arg1, arg2, arg3, arg4)
}

// GetGroupsByChannel mocks base method.
func (m *MockClient) GetGroupsByChannel(arg0 context.Context, arg1 string, arg2 model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, int, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetGroupsByChannel", arg0, arg1, arg2)
	ret0, _ := ret[0].([]*model.GroupWithSchemeAdmin)
	ret1, _ := ret[1].(int)
	ret2, _ := ret[2].(*model.Response)
	ret3, _ := ret[3].(error)
	return ret0, ret1, ret2, ret3
}

// GetGroupsByChannel indicates an expected call of GetGroupsByChannel.
func (mr *MockClientMockRecorder) GetGroupsByChannel(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetGroupsByChannel", reflect.TypeOf((*MockClient)(nil).GetGroupsByChannel), arg0, arg1, arg2)
}

// GetGroupsByTeam mocks base method.
func (m *MockClient) GetGroupsByTeam(arg0 context.Context, arg1 string, arg2 model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, int, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetGroupsByTeam", arg0, arg1, arg2)
	ret0, _ := ret[0].([]*model.GroupWithSchemeAdmin)
	ret1, _ := ret[1].(int)
	ret2, _ := ret[2].(*model.Response)
	ret3, _ := ret[3].(error)
	return ret0, ret1, ret2, ret3
}

// GetGroupsByTeam indicates an expected call of GetGroupsByTeam.
func (mr *MockClientMockRecorder) GetGroupsByTeam(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetGroupsByTeam", reflect.TypeOf((*MockClient)(nil).GetGroupsByTeam), arg0, arg1, arg2)
}

// GetIncomingWebhook mocks base method.
func (m *MockClient) GetIncomingWebhook(arg0 context.Context, arg1, arg2 string) (*model.IncomingWebhook, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetIncomingWebhook", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.IncomingWebhook)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetIncomingWebhook indicates an expected call of GetIncomingWebhook.
func (mr *MockClientMockRecorder) GetIncomingWebhook(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetIncomingWebhook", reflect.TypeOf((*MockClient)(nil).GetIncomingWebhook), arg0, arg1, arg2)
}

// GetIncomingWebhooks mocks base method.
func (m *MockClient) GetIncomingWebhooks(arg0 context.Context, arg1, arg2 int, arg3 string) ([]*model.IncomingWebhook, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetIncomingWebhooks", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].([]*model.IncomingWebhook)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetIncomingWebhooks indicates an expected call of GetIncomingWebhooks.
func (mr *MockClientMockRecorder) GetIncomingWebhooks(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetIncomingWebhooks", reflect.TypeOf((*MockClient)(nil).GetIncomingWebhooks), arg0, arg1, arg2, arg3)
}

// GetIncomingWebhooksForTeam mocks base method.
func (m *MockClient) GetIncomingWebhooksForTeam(arg0 context.Context, arg1 string, arg2, arg3 int, arg4 string) ([]*model.IncomingWebhook, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetIncomingWebhooksForTeam", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].([]*model.IncomingWebhook)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetIncomingWebhooksForTeam indicates an expected call of GetIncomingWebhooksForTeam.
func (mr *MockClientMockRecorder) GetIncomingWebhooksForTeam(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetIncomingWebhooksForTeam", reflect.TypeOf((*MockClient)(nil).GetIncomingWebhooksForTeam), arg0, arg1, arg2, arg3, arg4)
}

// GetJob mocks base method.
func (m *MockClient) GetJob(arg0 context.Context, arg1 string) (*model.Job, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetJob", arg0, arg1)
	ret0, _ := ret[0].(*model.Job)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetJob indicates an expected call of GetJob.
func (mr *MockClientMockRecorder) GetJob(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetJob", reflect.TypeOf((*MockClient)(nil).GetJob), arg0, arg1)
}

// GetJobs mocks base method.
func (m *MockClient) GetJobs(arg0 context.Context, arg1, arg2 string, arg3, arg4 int) ([]*model.Job, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetJobs", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].([]*model.Job)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetJobs indicates an expected call of GetJobs.
func (mr *MockClientMockRecorder) GetJobs(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetJobs", reflect.TypeOf((*MockClient)(nil).GetJobs), arg0, arg1, arg2, arg3, arg4)
}

// GetJobsByType mocks base method.
func (m *MockClient) GetJobsByType(arg0 context.Context, arg1 string, arg2, arg3 int) ([]*model.Job, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetJobsByType", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].([]*model.Job)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetJobsByType indicates an expected call of GetJobsByType.
func (mr *MockClientMockRecorder) GetJobsByType(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetJobsByType", reflect.TypeOf((*MockClient)(nil).GetJobsByType), arg0, arg1, arg2, arg3)
}

// GetLdapGroups mocks base method.
func (m *MockClient) GetLdapGroups(arg0 context.Context) ([]*model.Group, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetLdapGroups", arg0)
	ret0, _ := ret[0].([]*model.Group)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetLdapGroups indicates an expected call of GetLdapGroups.
func (mr *MockClientMockRecorder) GetLdapGroups(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLdapGroups", reflect.TypeOf((*MockClient)(nil).GetLdapGroups), arg0)
}

// GetLogs mocks base method.
func (m *MockClient) GetLogs(arg0 context.Context, arg1, arg2 int) ([]string, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetLogs", arg0, arg1, arg2)
	ret0, _ := ret[0].([]string)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetLogs indicates an expected call of GetLogs.
func (mr *MockClientMockRecorder) GetLogs(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLogs", reflect.TypeOf((*MockClient)(nil).GetLogs), arg0, arg1, arg2)
}

// GetMarketplacePlugins mocks base method.
func (m *MockClient) GetMarketplacePlugins(arg0 context.Context, arg1 *model.MarketplacePluginFilter) ([]*model.MarketplacePlugin, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetMarketplacePlugins", arg0, arg1)
	ret0, _ := ret[0].([]*model.MarketplacePlugin)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetMarketplacePlugins indicates an expected call of GetMarketplacePlugins.
func (mr *MockClientMockRecorder) GetMarketplacePlugins(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetMarketplacePlugins", reflect.TypeOf((*MockClient)(nil).GetMarketplacePlugins), arg0, arg1)
}

// GetOAuthApps mocks base method.
func (m *MockClient) GetOAuthApps(arg0 context.Context, arg1, arg2 int) ([]*model.OAuthApp, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetOAuthApps", arg0, arg1, arg2)
	ret0, _ := ret[0].([]*model.OAuthApp)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetOAuthApps indicates an expected call of GetOAuthApps.
func (mr *MockClientMockRecorder) GetOAuthApps(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOAuthApps", reflect.TypeOf((*MockClient)(nil).GetOAuthApps), arg0, arg1, arg2)
}

// GetOldClientConfig mocks base method.
func (m *MockClient) GetOldClientConfig(arg0 context.Context, arg1 string) (map[string]string, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetOldClientConfig", arg0, arg1)
	ret0, _ := ret[0].(map[string]string)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetOldClientConfig indicates an expected call of GetOldClientConfig.
func (mr *MockClientMockRecorder) GetOldClientConfig(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOldClientConfig", reflect.TypeOf((*MockClient)(nil).GetOldClientConfig), arg0, arg1)
}

// GetOutgoingWebhook mocks base method.
func (m *MockClient) GetOutgoingWebhook(arg0 context.Context, arg1 string) (*model.OutgoingWebhook, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetOutgoingWebhook", arg0, arg1)
	ret0, _ := ret[0].(*model.OutgoingWebhook)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetOutgoingWebhook indicates an expected call of GetOutgoingWebhook.
func (mr *MockClientMockRecorder) GetOutgoingWebhook(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOutgoingWebhook", reflect.TypeOf((*MockClient)(nil).GetOutgoingWebhook), arg0, arg1)
}

// GetOutgoingWebhooks mocks base method.
func (m *MockClient) GetOutgoingWebhooks(arg0 context.Context, arg1, arg2 int, arg3 string) ([]*model.OutgoingWebhook, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetOutgoingWebhooks", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].([]*model.OutgoingWebhook)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetOutgoingWebhooks indicates an expected call of GetOutgoingWebhooks.
func (mr *MockClientMockRecorder) GetOutgoingWebhooks(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOutgoingWebhooks", reflect.TypeOf((*MockClient)(nil).GetOutgoingWebhooks), arg0, arg1, arg2, arg3)
}

// GetOutgoingWebhooksForChannel mocks base method.
func (m *MockClient) GetOutgoingWebhooksForChannel(arg0 context.Context, arg1 string, arg2, arg3 int, arg4 string) ([]*model.OutgoingWebhook, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetOutgoingWebhooksForChannel", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].([]*model.OutgoingWebhook)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetOutgoingWebhooksForChannel indicates an expected call of GetOutgoingWebhooksForChannel.
func (mr *MockClientMockRecorder) GetOutgoingWebhooksForChannel(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOutgoingWebhooksForChannel", reflect.TypeOf((*MockClient)(nil).GetOutgoingWebhooksForChannel), arg0, arg1, arg2, arg3, arg4)
}

// GetOutgoingWebhooksForTeam mocks base method.
func (m *MockClient) GetOutgoingWebhooksForTeam(arg0 context.Context, arg1 string, arg2, arg3 int, arg4 string) ([]*model.OutgoingWebhook, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetOutgoingWebhooksForTeam", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].([]*model.OutgoingWebhook)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetOutgoingWebhooksForTeam indicates an expected call of GetOutgoingWebhooksForTeam.
func (mr *MockClientMockRecorder) GetOutgoingWebhooksForTeam(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOutgoingWebhooksForTeam", reflect.TypeOf((*MockClient)(nil).GetOutgoingWebhooksForTeam), arg0, arg1, arg2, arg3, arg4)
}

// GetPing mocks base method.
func (m *MockClient) GetPing(arg0 context.Context) (string, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPing", arg0)
	ret0, _ := ret[0].(string)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetPing indicates an expected call of GetPing.
func (mr *MockClientMockRecorder) GetPing(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPing", reflect.TypeOf((*MockClient)(nil).GetPing), arg0)
}

// GetPingWithFullServerStatus mocks base method.
func (m *MockClient) GetPingWithFullServerStatus(arg0 context.Context) (map[string]string, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPingWithFullServerStatus", arg0)
	ret0, _ := ret[0].(map[string]string)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetPingWithFullServerStatus indicates an expected call of GetPingWithFullServerStatus.
func (mr *MockClientMockRecorder) GetPingWithFullServerStatus(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPingWithFullServerStatus", reflect.TypeOf((*MockClient)(nil).GetPingWithFullServerStatus), arg0)
}

// GetPingWithOptions mocks base method.
func (m *MockClient) GetPingWithOptions(arg0 context.Context, arg1 model.SystemPingOptions) (map[string]string, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPingWithOptions", arg0, arg1)
	ret0, _ := ret[0].(map[string]string)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetPingWithOptions indicates an expected call of GetPingWithOptions.
func (mr *MockClientMockRecorder) GetPingWithOptions(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPingWithOptions", reflect.TypeOf((*MockClient)(nil).GetPingWithOptions), arg0, arg1)
}

// GetPlugins mocks base method.
func (m *MockClient) GetPlugins(arg0 context.Context) (*model.PluginsResponse, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPlugins", arg0)
	ret0, _ := ret[0].(*model.PluginsResponse)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetPlugins indicates an expected call of GetPlugins.
func (mr *MockClientMockRecorder) GetPlugins(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPlugins", reflect.TypeOf((*MockClient)(nil).GetPlugins), arg0)
}

// GetPost mocks base method.
func (m *MockClient) GetPost(arg0 context.Context, arg1, arg2 string) (*model.Post, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPost", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Post)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetPost indicates an expected call of GetPost.
func (mr *MockClientMockRecorder) GetPost(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPost", reflect.TypeOf((*MockClient)(nil).GetPost), arg0, arg1, arg2)
}

// GetPostsForChannel mocks base method.
func (m *MockClient) GetPostsForChannel(arg0 context.Context, arg1 string, arg2, arg3 int, arg4 string, arg5, arg6 bool) (*model.PostList, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPostsForChannel", arg0, arg1, arg2, arg3, arg4, arg5, arg6)
	ret0, _ := ret[0].(*model.PostList)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetPostsForChannel indicates an expected call of GetPostsForChannel.
func (mr *MockClientMockRecorder) GetPostsForChannel(arg0, arg1, arg2, arg3, arg4, arg5, arg6 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPostsForChannel", reflect.TypeOf((*MockClient)(nil).GetPostsForChannel), arg0, arg1, arg2, arg3, arg4, arg5, arg6)
}

// GetPostsSince mocks base method.
func (m *MockClient) GetPostsSince(arg0 context.Context, arg1 string, arg2 int64, arg3 bool) (*model.PostList, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPostsSince", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*model.PostList)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetPostsSince indicates an expected call of GetPostsSince.
func (mr *MockClientMockRecorder) GetPostsSince(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPostsSince", reflect.TypeOf((*MockClient)(nil).GetPostsSince), arg0, arg1, arg2, arg3)
}

// GetPreferenceByCategoryAndName mocks base method.
func (m *MockClient) GetPreferenceByCategoryAndName(arg0 context.Context, arg1, arg2, arg3 string) (*model.Preference, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPreferenceByCategoryAndName", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*model.Preference)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetPreferenceByCategoryAndName indicates an expected call of GetPreferenceByCategoryAndName.
func (mr *MockClientMockRecorder) GetPreferenceByCategoryAndName(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPreferenceByCategoryAndName", reflect.TypeOf((*MockClient)(nil).GetPreferenceByCategoryAndName), arg0, arg1, arg2, arg3)
}

// GetPreferences mocks base method.
func (m *MockClient) GetPreferences(arg0 context.Context, arg1 string) (model.Preferences, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPreferences", arg0, arg1)
	ret0, _ := ret[0].(model.Preferences)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetPreferences indicates an expected call of GetPreferences.
func (mr *MockClientMockRecorder) GetPreferences(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPreferences", reflect.TypeOf((*MockClient)(nil).GetPreferences), arg0, arg1)
}

// GetPreferencesByCategory mocks base method.
func (m *MockClient) GetPreferencesByCategory(arg0 context.Context, arg1, arg2 string) (model.Preferences, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPreferencesByCategory", arg0, arg1, arg2)
	ret0, _ := ret[0].(model.Preferences)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetPreferencesByCategory indicates an expected call of GetPreferencesByCategory.
func (mr *MockClientMockRecorder) GetPreferencesByCategory(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPreferencesByCategory", reflect.TypeOf((*MockClient)(nil).GetPreferencesByCategory), arg0, arg1, arg2)
}

// GetPrivateChannelsForTeam mocks base method.
func (m *MockClient) GetPrivateChannelsForTeam(arg0 context.Context, arg1 string, arg2, arg3 int, arg4 string) ([]*model.Channel, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPrivateChannelsForTeam", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].([]*model.Channel)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetPrivateChannelsForTeam indicates an expected call of GetPrivateChannelsForTeam.
func (mr *MockClientMockRecorder) GetPrivateChannelsForTeam(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPrivateChannelsForTeam", reflect.TypeOf((*MockClient)(nil).GetPrivateChannelsForTeam), arg0, arg1, arg2, arg3, arg4)
}

// GetPublicChannelsForTeam mocks base method.
func (m *MockClient) GetPublicChannelsForTeam(arg0 context.Context, arg1 string, arg2, arg3 int, arg4 string) ([]*model.Channel, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetPublicChannelsForTeam", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].([]*model.Channel)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetPublicChannelsForTeam indicates an expected call of GetPublicChannelsForTeam.
func (mr *MockClientMockRecorder) GetPublicChannelsForTeam(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetPublicChannelsForTeam", reflect.TypeOf((*MockClient)(nil).GetPublicChannelsForTeam), arg0, arg1, arg2, arg3, arg4)
}

// GetRoleByName mocks base method.
func (m *MockClient) GetRoleByName(arg0 context.Context, arg1 string) (*model.Role, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetRoleByName", arg0, arg1)
	ret0, _ := ret[0].(*model.Role)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetRoleByName indicates an expected call of GetRoleByName.
func (mr *MockClientMockRecorder) GetRoleByName(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetRoleByName", reflect.TypeOf((*MockClient)(nil).GetRoleByName), arg0, arg1)
}

// GetServerBusy mocks base method.
func (m *MockClient) GetServerBusy(arg0 context.Context) (*model.ServerBusyState, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetServerBusy", arg0)
	ret0, _ := ret[0].(*model.ServerBusyState)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetServerBusy indicates an expected call of GetServerBusy.
func (mr *MockClientMockRecorder) GetServerBusy(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetServerBusy", reflect.TypeOf((*MockClient)(nil).GetServerBusy), arg0)
}

// GetTeam mocks base method.
func (m *MockClient) GetTeam(arg0 context.Context, arg1, arg2 string) (*model.Team, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTeam", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Team)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetTeam indicates an expected call of GetTeam.
func (mr *MockClientMockRecorder) GetTeam(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTeam", reflect.TypeOf((*MockClient)(nil).GetTeam), arg0, arg1, arg2)
}

// GetTeamByName mocks base method.
func (m *MockClient) GetTeamByName(arg0 context.Context, arg1, arg2 string) (*model.Team, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetTeamByName", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Team)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetTeamByName indicates an expected call of GetTeamByName.
func (mr *MockClientMockRecorder) GetTeamByName(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetTeamByName", reflect.TypeOf((*MockClient)(nil).GetTeamByName), arg0, arg1, arg2)
}

// GetUpload mocks base method.
func (m *MockClient) GetUpload(arg0 context.Context, arg1 string) (*model.UploadSession, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUpload", arg0, arg1)
	ret0, _ := ret[0].(*model.UploadSession)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetUpload indicates an expected call of GetUpload.
func (mr *MockClientMockRecorder) GetUpload(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUpload", reflect.TypeOf((*MockClient)(nil).GetUpload), arg0, arg1)
}

// GetUploadsForUser mocks base method.
func (m *MockClient) GetUploadsForUser(arg0 context.Context, arg1 string) ([]*model.UploadSession, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUploadsForUser", arg0, arg1)
	ret0, _ := ret[0].([]*model.UploadSession)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetUploadsForUser indicates an expected call of GetUploadsForUser.
func (mr *MockClientMockRecorder) GetUploadsForUser(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUploadsForUser", reflect.TypeOf((*MockClient)(nil).GetUploadsForUser), arg0, arg1)
}

// GetUser mocks base method.
func (m *MockClient) GetUser(arg0 context.Context, arg1, arg2 string) (*model.User, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUser", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.User)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetUser indicates an expected call of GetUser.
func (mr *MockClientMockRecorder) GetUser(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUser", reflect.TypeOf((*MockClient)(nil).GetUser), arg0, arg1, arg2)
}

// GetUserAccessTokensForUser mocks base method.
func (m *MockClient) GetUserAccessTokensForUser(arg0 context.Context, arg1 string, arg2, arg3 int) ([]*model.UserAccessToken, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUserAccessTokensForUser", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].([]*model.UserAccessToken)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetUserAccessTokensForUser indicates an expected call of GetUserAccessTokensForUser.
func (mr *MockClientMockRecorder) GetUserAccessTokensForUser(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUserAccessTokensForUser", reflect.TypeOf((*MockClient)(nil).GetUserAccessTokensForUser), arg0, arg1, arg2, arg3)
}

// GetUserByEmail mocks base method.
func (m *MockClient) GetUserByEmail(arg0 context.Context, arg1, arg2 string) (*model.User, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUserByEmail", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.User)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetUserByEmail indicates an expected call of GetUserByEmail.
func (mr *MockClientMockRecorder) GetUserByEmail(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUserByEmail", reflect.TypeOf((*MockClient)(nil).GetUserByEmail), arg0, arg1, arg2)
}

// GetUserByUsername mocks base method.
func (m *MockClient) GetUserByUsername(arg0 context.Context, arg1, arg2 string) (*model.User, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUserByUsername", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.User)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetUserByUsername indicates an expected call of GetUserByUsername.
func (mr *MockClientMockRecorder) GetUserByUsername(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUserByUsername", reflect.TypeOf((*MockClient)(nil).GetUserByUsername), arg0, arg1, arg2)
}

// GetUsers mocks base method.
func (m *MockClient) GetUsers(arg0 context.Context, arg1, arg2 int, arg3 string) ([]*model.User, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUsers", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].([]*model.User)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetUsers indicates an expected call of GetUsers.
func (mr *MockClientMockRecorder) GetUsers(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUsers", reflect.TypeOf((*MockClient)(nil).GetUsers), arg0, arg1, arg2, arg3)
}

// GetUsersByIds mocks base method.
func (m *MockClient) GetUsersByIds(arg0 context.Context, arg1 []string) ([]*model.User, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUsersByIds", arg0, arg1)
	ret0, _ := ret[0].([]*model.User)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetUsersByIds indicates an expected call of GetUsersByIds.
func (mr *MockClientMockRecorder) GetUsersByIds(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUsersByIds", reflect.TypeOf((*MockClient)(nil).GetUsersByIds), arg0, arg1)
}

// GetUsersInTeam mocks base method.
func (m *MockClient) GetUsersInTeam(arg0 context.Context, arg1 string, arg2, arg3 int, arg4 string) ([]*model.User, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUsersInTeam", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].([]*model.User)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetUsersInTeam indicates an expected call of GetUsersInTeam.
func (mr *MockClientMockRecorder) GetUsersInTeam(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUsersInTeam", reflect.TypeOf((*MockClient)(nil).GetUsersInTeam), arg0, arg1, arg2, arg3, arg4)
}

// GetUsersWithCustomQueryParameters mocks base method.
func (m *MockClient) GetUsersWithCustomQueryParameters(arg0 context.Context, arg1, arg2 int, arg3, arg4 string) ([]*model.User, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUsersWithCustomQueryParameters", arg0, arg1, arg2, arg3, arg4)
	ret0, _ := ret[0].([]*model.User)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetUsersWithCustomQueryParameters indicates an expected call of GetUsersWithCustomQueryParameters.
func (mr *MockClientMockRecorder) GetUsersWithCustomQueryParameters(arg0, arg1, arg2, arg3, arg4 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUsersWithCustomQueryParameters", reflect.TypeOf((*MockClient)(nil).GetUsersWithCustomQueryParameters), arg0, arg1, arg2, arg3, arg4)
}

// InstallMarketplacePlugin mocks base method.
func (m *MockClient) InstallMarketplacePlugin(arg0 context.Context, arg1 *model.InstallMarketplacePluginRequest) (*model.Manifest, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InstallMarketplacePlugin", arg0, arg1)
	ret0, _ := ret[0].(*model.Manifest)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// InstallMarketplacePlugin indicates an expected call of InstallMarketplacePlugin.
func (mr *MockClientMockRecorder) InstallMarketplacePlugin(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InstallMarketplacePlugin", reflect.TypeOf((*MockClient)(nil).InstallMarketplacePlugin), arg0, arg1)
}

// InstallPluginFromURL mocks base method.
func (m *MockClient) InstallPluginFromURL(arg0 context.Context, arg1 string, arg2 bool) (*model.Manifest, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InstallPluginFromURL", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Manifest)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// InstallPluginFromURL indicates an expected call of InstallPluginFromURL.
func (mr *MockClientMockRecorder) InstallPluginFromURL(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InstallPluginFromURL", reflect.TypeOf((*MockClient)(nil).InstallPluginFromURL), arg0, arg1, arg2)
}

// InviteUsersToTeam mocks base method.
func (m *MockClient) InviteUsersToTeam(arg0 context.Context, arg1 string, arg2 []string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InviteUsersToTeam", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// InviteUsersToTeam indicates an expected call of InviteUsersToTeam.
func (mr *MockClientMockRecorder) InviteUsersToTeam(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InviteUsersToTeam", reflect.TypeOf((*MockClient)(nil).InviteUsersToTeam), arg0, arg1, arg2)
}

// ListCommands mocks base method.
func (m *MockClient) ListCommands(arg0 context.Context, arg1 string, arg2 bool) ([]*model.Command, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListCommands", arg0, arg1, arg2)
	ret0, _ := ret[0].([]*model.Command)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// ListCommands indicates an expected call of ListCommands.
func (mr *MockClientMockRecorder) ListCommands(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListCommands", reflect.TypeOf((*MockClient)(nil).ListCommands), arg0, arg1, arg2)
}

// ListExports mocks base method.
func (m *MockClient) ListExports(arg0 context.Context) ([]string, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListExports", arg0)
	ret0, _ := ret[0].([]string)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// ListExports indicates an expected call of ListExports.
func (mr *MockClientMockRecorder) ListExports(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListExports", reflect.TypeOf((*MockClient)(nil).ListExports), arg0)
}

// ListImports mocks base method.
func (m *MockClient) ListImports(arg0 context.Context) ([]string, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListImports", arg0)
	ret0, _ := ret[0].([]string)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// ListImports indicates an expected call of ListImports.
func (mr *MockClientMockRecorder) ListImports(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListImports", reflect.TypeOf((*MockClient)(nil).ListImports), arg0)
}

// MigrateAuthToLdap mocks base method.
func (m *MockClient) MigrateAuthToLdap(arg0 context.Context, arg1, arg2 string, arg3 bool) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MigrateAuthToLdap", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// MigrateAuthToLdap indicates an expected call of MigrateAuthToLdap.
func (mr *MockClientMockRecorder) MigrateAuthToLdap(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MigrateAuthToLdap", reflect.TypeOf((*MockClient)(nil).MigrateAuthToLdap), arg0, arg1, arg2, arg3)
}

// MigrateAuthToSaml mocks base method.
func (m *MockClient) MigrateAuthToSaml(arg0 context.Context, arg1 string, arg2 map[string]string, arg3 bool) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MigrateAuthToSaml", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// MigrateAuthToSaml indicates an expected call of MigrateAuthToSaml.
func (mr *MockClientMockRecorder) MigrateAuthToSaml(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MigrateAuthToSaml", reflect.TypeOf((*MockClient)(nil).MigrateAuthToSaml), arg0, arg1, arg2, arg3)
}

// MigrateConfig mocks base method.
func (m *MockClient) MigrateConfig(arg0 context.Context, arg1, arg2 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MigrateConfig", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// MigrateConfig indicates an expected call of MigrateConfig.
func (mr *MockClientMockRecorder) MigrateConfig(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MigrateConfig", reflect.TypeOf((*MockClient)(nil).MigrateConfig), arg0, arg1, arg2)
}

// MigrateIdLdap mocks base method.
func (m *MockClient) MigrateIdLdap(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MigrateIdLdap", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// MigrateIdLdap indicates an expected call of MigrateIdLdap.
func (mr *MockClientMockRecorder) MigrateIdLdap(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MigrateIdLdap", reflect.TypeOf((*MockClient)(nil).MigrateIdLdap), arg0, arg1)
}

// MoveChannel mocks base method.
func (m *MockClient) MoveChannel(arg0 context.Context, arg1, arg2 string, arg3 bool) (*model.Channel, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MoveChannel", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*model.Channel)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// MoveChannel indicates an expected call of MoveChannel.
func (mr *MockClientMockRecorder) MoveChannel(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MoveChannel", reflect.TypeOf((*MockClient)(nil).MoveChannel), arg0, arg1, arg2, arg3)
}

// MoveCommand mocks base method.
func (m *MockClient) MoveCommand(arg0 context.Context, arg1, arg2 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MoveCommand", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// MoveCommand indicates an expected call of MoveCommand.
func (mr *MockClientMockRecorder) MoveCommand(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MoveCommand", reflect.TypeOf((*MockClient)(nil).MoveCommand), arg0, arg1, arg2)
}

// PatchBot mocks base method.
func (m *MockClient) PatchBot(arg0 context.Context, arg1 string, arg2 *model.BotPatch) (*model.Bot, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PatchBot", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Bot)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// PatchBot indicates an expected call of PatchBot.
func (mr *MockClientMockRecorder) PatchBot(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PatchBot", reflect.TypeOf((*MockClient)(nil).PatchBot), arg0, arg1, arg2)
}

// PatchChannel mocks base method.
func (m *MockClient) PatchChannel(arg0 context.Context, arg1 string, arg2 *model.ChannelPatch) (*model.Channel, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PatchChannel", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Channel)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// PatchChannel indicates an expected call of PatchChannel.
func (mr *MockClientMockRecorder) PatchChannel(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PatchChannel", reflect.TypeOf((*MockClient)(nil).PatchChannel), arg0, arg1, arg2)
}

// PatchConfig mocks base method.
func (m *MockClient) PatchConfig(arg0 context.Context, arg1 *model.Config) (*model.Config, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PatchConfig", arg0, arg1)
	ret0, _ := ret[0].(*model.Config)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// PatchConfig indicates an expected call of PatchConfig.
func (mr *MockClientMockRecorder) PatchConfig(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PatchConfig", reflect.TypeOf((*MockClient)(nil).PatchConfig), arg0, arg1)
}

// PatchRole mocks base method.
func (m *MockClient) PatchRole(arg0 context.Context, arg1 string, arg2 *model.RolePatch) (*model.Role, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PatchRole", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Role)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// PatchRole indicates an expected call of PatchRole.
func (mr *MockClientMockRecorder) PatchRole(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PatchRole", reflect.TypeOf((*MockClient)(nil).PatchRole), arg0, arg1, arg2)
}

// PatchTeam mocks base method.
func (m *MockClient) PatchTeam(arg0 context.Context, arg1 string, arg2 *model.TeamPatch) (*model.Team, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PatchTeam", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Team)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// PatchTeam indicates an expected call of PatchTeam.
func (mr *MockClientMockRecorder) PatchTeam(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PatchTeam", reflect.TypeOf((*MockClient)(nil).PatchTeam), arg0, arg1, arg2)
}

// PermanentDeleteAllUsers mocks base method.
func (m *MockClient) PermanentDeleteAllUsers(arg0 context.Context) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PermanentDeleteAllUsers", arg0)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PermanentDeleteAllUsers indicates an expected call of PermanentDeleteAllUsers.
func (mr *MockClientMockRecorder) PermanentDeleteAllUsers(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PermanentDeleteAllUsers", reflect.TypeOf((*MockClient)(nil).PermanentDeleteAllUsers), arg0)
}

// PermanentDeleteChannel mocks base method.
func (m *MockClient) PermanentDeleteChannel(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PermanentDeleteChannel", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PermanentDeleteChannel indicates an expected call of PermanentDeleteChannel.
func (mr *MockClientMockRecorder) PermanentDeleteChannel(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PermanentDeleteChannel", reflect.TypeOf((*MockClient)(nil).PermanentDeleteChannel), arg0, arg1)
}

// PermanentDeletePost mocks base method.
func (m *MockClient) PermanentDeletePost(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PermanentDeletePost", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PermanentDeletePost indicates an expected call of PermanentDeletePost.
func (mr *MockClientMockRecorder) PermanentDeletePost(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PermanentDeletePost", reflect.TypeOf((*MockClient)(nil).PermanentDeletePost), arg0, arg1)
}

// PermanentDeleteTeam mocks base method.
func (m *MockClient) PermanentDeleteTeam(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PermanentDeleteTeam", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PermanentDeleteTeam indicates an expected call of PermanentDeleteTeam.
func (mr *MockClientMockRecorder) PermanentDeleteTeam(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PermanentDeleteTeam", reflect.TypeOf((*MockClient)(nil).PermanentDeleteTeam), arg0, arg1)
}

// PermanentDeleteUser mocks base method.
func (m *MockClient) PermanentDeleteUser(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PermanentDeleteUser", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PermanentDeleteUser indicates an expected call of PermanentDeleteUser.
func (mr *MockClientMockRecorder) PermanentDeleteUser(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PermanentDeleteUser", reflect.TypeOf((*MockClient)(nil).PermanentDeleteUser), arg0, arg1)
}

// PromoteGuestToUser mocks base method.
func (m *MockClient) PromoteGuestToUser(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PromoteGuestToUser", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PromoteGuestToUser indicates an expected call of PromoteGuestToUser.
func (mr *MockClientMockRecorder) PromoteGuestToUser(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PromoteGuestToUser", reflect.TypeOf((*MockClient)(nil).PromoteGuestToUser), arg0, arg1)
}

// RegenOutgoingHookToken mocks base method.
func (m *MockClient) RegenOutgoingHookToken(arg0 context.Context, arg1 string) (*model.OutgoingWebhook, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RegenOutgoingHookToken", arg0, arg1)
	ret0, _ := ret[0].(*model.OutgoingWebhook)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// RegenOutgoingHookToken indicates an expected call of RegenOutgoingHookToken.
func (mr *MockClientMockRecorder) RegenOutgoingHookToken(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RegenOutgoingHookToken", reflect.TypeOf((*MockClient)(nil).RegenOutgoingHookToken), arg0, arg1)
}

// ReloadConfig mocks base method.
func (m *MockClient) ReloadConfig(arg0 context.Context) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReloadConfig", arg0)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReloadConfig indicates an expected call of ReloadConfig.
func (mr *MockClientMockRecorder) ReloadConfig(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReloadConfig", reflect.TypeOf((*MockClient)(nil).ReloadConfig), arg0)
}

// RemoveLicenseFile mocks base method.
func (m *MockClient) RemoveLicenseFile(arg0 context.Context) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RemoveLicenseFile", arg0)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RemoveLicenseFile indicates an expected call of RemoveLicenseFile.
func (mr *MockClientMockRecorder) RemoveLicenseFile(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RemoveLicenseFile", reflect.TypeOf((*MockClient)(nil).RemoveLicenseFile), arg0)
}

// RemovePlugin mocks base method.
func (m *MockClient) RemovePlugin(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RemovePlugin", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RemovePlugin indicates an expected call of RemovePlugin.
func (mr *MockClientMockRecorder) RemovePlugin(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RemovePlugin", reflect.TypeOf((*MockClient)(nil).RemovePlugin), arg0, arg1)
}

// RemoveTeamMember mocks base method.
func (m *MockClient) RemoveTeamMember(arg0 context.Context, arg1, arg2 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RemoveTeamMember", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RemoveTeamMember indicates an expected call of RemoveTeamMember.
func (mr *MockClientMockRecorder) RemoveTeamMember(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RemoveTeamMember", reflect.TypeOf((*MockClient)(nil).RemoveTeamMember), arg0, arg1, arg2)
}

// RemoveUserFromChannel mocks base method.
func (m *MockClient) RemoveUserFromChannel(arg0 context.Context, arg1, arg2 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RemoveUserFromChannel", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RemoveUserFromChannel indicates an expected call of RemoveUserFromChannel.
func (mr *MockClientMockRecorder) RemoveUserFromChannel(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RemoveUserFromChannel", reflect.TypeOf((*MockClient)(nil).RemoveUserFromChannel), arg0, arg1, arg2)
}

// ResetSamlAuthDataToEmail mocks base method.
func (m *MockClient) ResetSamlAuthDataToEmail(arg0 context.Context, arg1, arg2 bool, arg3 []string) (int64, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ResetSamlAuthDataToEmail", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// ResetSamlAuthDataToEmail indicates an expected call of ResetSamlAuthDataToEmail.
func (mr *MockClientMockRecorder) ResetSamlAuthDataToEmail(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ResetSamlAuthDataToEmail", reflect.TypeOf((*MockClient)(nil).ResetSamlAuthDataToEmail), arg0, arg1, arg2, arg3)
}

// RestoreChannel mocks base method.
func (m *MockClient) RestoreChannel(arg0 context.Context, arg1 string) (*model.Channel, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RestoreChannel", arg0, arg1)
	ret0, _ := ret[0].(*model.Channel)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// RestoreChannel indicates an expected call of RestoreChannel.
func (mr *MockClientMockRecorder) RestoreChannel(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RestoreChannel", reflect.TypeOf((*MockClient)(nil).RestoreChannel), arg0, arg1)
}

// RestoreGroup mocks base method.
func (m *MockClient) RestoreGroup(arg0 context.Context, arg1, arg2 string) (*model.Group, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RestoreGroup", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Group)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// RestoreGroup indicates an expected call of RestoreGroup.
func (mr *MockClientMockRecorder) RestoreGroup(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RestoreGroup", reflect.TypeOf((*MockClient)(nil).RestoreGroup), arg0, arg1, arg2)
}

// RestoreTeam mocks base method.
func (m *MockClient) RestoreTeam(arg0 context.Context, arg1 string) (*model.Team, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RestoreTeam", arg0, arg1)
	ret0, _ := ret[0].(*model.Team)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// RestoreTeam indicates an expected call of RestoreTeam.
func (mr *MockClientMockRecorder) RestoreTeam(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RestoreTeam", reflect.TypeOf((*MockClient)(nil).RestoreTeam), arg0, arg1)
}

// RevokeUserAccessToken mocks base method.
func (m *MockClient) RevokeUserAccessToken(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RevokeUserAccessToken", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RevokeUserAccessToken indicates an expected call of RevokeUserAccessToken.
func (mr *MockClientMockRecorder) RevokeUserAccessToken(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RevokeUserAccessToken", reflect.TypeOf((*MockClient)(nil).RevokeUserAccessToken), arg0, arg1)
}

// SearchTeams mocks base method.
func (m *MockClient) SearchTeams(arg0 context.Context, arg1 *model.TeamSearch) ([]*model.Team, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SearchTeams", arg0, arg1)
	ret0, _ := ret[0].([]*model.Team)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// SearchTeams indicates an expected call of SearchTeams.
func (mr *MockClientMockRecorder) SearchTeams(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SearchTeams", reflect.TypeOf((*MockClient)(nil).SearchTeams), arg0, arg1)
}

// SendPasswordResetEmail mocks base method.
func (m *MockClient) SendPasswordResetEmail(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SendPasswordResetEmail", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SendPasswordResetEmail indicates an expected call of SendPasswordResetEmail.
func (mr *MockClientMockRecorder) SendPasswordResetEmail(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SendPasswordResetEmail", reflect.TypeOf((*MockClient)(nil).SendPasswordResetEmail), arg0, arg1)
}

// SetServerBusy mocks base method.
func (m *MockClient) SetServerBusy(arg0 context.Context, arg1 int) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetServerBusy", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SetServerBusy indicates an expected call of SetServerBusy.
func (mr *MockClientMockRecorder) SetServerBusy(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetServerBusy", reflect.TypeOf((*MockClient)(nil).SetServerBusy), arg0, arg1)
}

// SoftDeleteTeam mocks base method.
func (m *MockClient) SoftDeleteTeam(arg0 context.Context, arg1 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SoftDeleteTeam", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SoftDeleteTeam indicates an expected call of SoftDeleteTeam.
func (mr *MockClientMockRecorder) SoftDeleteTeam(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SoftDeleteTeam", reflect.TypeOf((*MockClient)(nil).SoftDeleteTeam), arg0, arg1)
}

// SyncLdap mocks base method.
func (m *MockClient) SyncLdap(arg0 context.Context, arg1 *bool) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SyncLdap", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SyncLdap indicates an expected call of SyncLdap.
func (mr *MockClientMockRecorder) SyncLdap(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SyncLdap", reflect.TypeOf((*MockClient)(nil).SyncLdap), arg0, arg1)
}

// UpdateChannelPrivacy mocks base method.
func (m *MockClient) UpdateChannelPrivacy(arg0 context.Context, arg1 string, arg2 model.ChannelType) (*model.Channel, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateChannelPrivacy", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Channel)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// UpdateChannelPrivacy indicates an expected call of UpdateChannelPrivacy.
func (mr *MockClientMockRecorder) UpdateChannelPrivacy(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateChannelPrivacy", reflect.TypeOf((*MockClient)(nil).UpdateChannelPrivacy), arg0, arg1, arg2)
}

// UpdateCommand mocks base method.
func (m *MockClient) UpdateCommand(arg0 context.Context, arg1 *model.Command) (*model.Command, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateCommand", arg0, arg1)
	ret0, _ := ret[0].(*model.Command)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// UpdateCommand indicates an expected call of UpdateCommand.
func (mr *MockClientMockRecorder) UpdateCommand(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateCommand", reflect.TypeOf((*MockClient)(nil).UpdateCommand), arg0, arg1)
}

// UpdateConfig mocks base method.
func (m *MockClient) UpdateConfig(arg0 context.Context, arg1 *model.Config) (*model.Config, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateConfig", arg0, arg1)
	ret0, _ := ret[0].(*model.Config)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// UpdateConfig indicates an expected call of UpdateConfig.
func (mr *MockClientMockRecorder) UpdateConfig(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateConfig", reflect.TypeOf((*MockClient)(nil).UpdateConfig), arg0, arg1)
}

// UpdateIncomingWebhook mocks base method.
func (m *MockClient) UpdateIncomingWebhook(arg0 context.Context, arg1 *model.IncomingWebhook) (*model.IncomingWebhook, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateIncomingWebhook", arg0, arg1)
	ret0, _ := ret[0].(*model.IncomingWebhook)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// UpdateIncomingWebhook indicates an expected call of UpdateIncomingWebhook.
func (mr *MockClientMockRecorder) UpdateIncomingWebhook(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateIncomingWebhook", reflect.TypeOf((*MockClient)(nil).UpdateIncomingWebhook), arg0, arg1)
}

// UpdateJobStatus mocks base method.
func (m *MockClient) UpdateJobStatus(arg0 context.Context, arg1, arg2 string, arg3 bool) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateJobStatus", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateJobStatus indicates an expected call of UpdateJobStatus.
func (mr *MockClientMockRecorder) UpdateJobStatus(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateJobStatus", reflect.TypeOf((*MockClient)(nil).UpdateJobStatus), arg0, arg1, arg2, arg3)
}

// UpdateOutgoingWebhook mocks base method.
func (m *MockClient) UpdateOutgoingWebhook(arg0 context.Context, arg1 *model.OutgoingWebhook) (*model.OutgoingWebhook, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateOutgoingWebhook", arg0, arg1)
	ret0, _ := ret[0].(*model.OutgoingWebhook)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// UpdateOutgoingWebhook indicates an expected call of UpdateOutgoingWebhook.
func (mr *MockClientMockRecorder) UpdateOutgoingWebhook(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateOutgoingWebhook", reflect.TypeOf((*MockClient)(nil).UpdateOutgoingWebhook), arg0, arg1)
}

// UpdatePreferences mocks base method.
func (m *MockClient) UpdatePreferences(arg0 context.Context, arg1 string, arg2 model.Preferences) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdatePreferences", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdatePreferences indicates an expected call of UpdatePreferences.
func (mr *MockClientMockRecorder) UpdatePreferences(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdatePreferences", reflect.TypeOf((*MockClient)(nil).UpdatePreferences), arg0, arg1, arg2)
}

// UpdateTeam mocks base method.
func (m *MockClient) UpdateTeam(arg0 context.Context, arg1 *model.Team) (*model.Team, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateTeam", arg0, arg1)
	ret0, _ := ret[0].(*model.Team)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// UpdateTeam indicates an expected call of UpdateTeam.
func (mr *MockClientMockRecorder) UpdateTeam(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateTeam", reflect.TypeOf((*MockClient)(nil).UpdateTeam), arg0, arg1)
}

// UpdateTeamPrivacy mocks base method.
func (m *MockClient) UpdateTeamPrivacy(arg0 context.Context, arg1, arg2 string) (*model.Team, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateTeamPrivacy", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Team)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// UpdateTeamPrivacy indicates an expected call of UpdateTeamPrivacy.
func (mr *MockClientMockRecorder) UpdateTeamPrivacy(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateTeamPrivacy", reflect.TypeOf((*MockClient)(nil).UpdateTeamPrivacy), arg0, arg1, arg2)
}

// UpdateUser mocks base method.
func (m *MockClient) UpdateUser(arg0 context.Context, arg1 *model.User) (*model.User, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateUser", arg0, arg1)
	ret0, _ := ret[0].(*model.User)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// UpdateUser indicates an expected call of UpdateUser.
func (mr *MockClientMockRecorder) UpdateUser(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateUser", reflect.TypeOf((*MockClient)(nil).UpdateUser), arg0, arg1)
}

// UpdateUserActive mocks base method.
func (m *MockClient) UpdateUserActive(arg0 context.Context, arg1 string, arg2 bool) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateUserActive", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateUserActive indicates an expected call of UpdateUserActive.
func (mr *MockClientMockRecorder) UpdateUserActive(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateUserActive", reflect.TypeOf((*MockClient)(nil).UpdateUserActive), arg0, arg1, arg2)
}

// UpdateUserHashedPassword mocks base method.
func (m *MockClient) UpdateUserHashedPassword(arg0 context.Context, arg1, arg2 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateUserHashedPassword", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateUserHashedPassword indicates an expected call of UpdateUserHashedPassword.
func (mr *MockClientMockRecorder) UpdateUserHashedPassword(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateUserHashedPassword", reflect.TypeOf((*MockClient)(nil).UpdateUserHashedPassword), arg0, arg1, arg2)
}

// UpdateUserMfa mocks base method.
func (m *MockClient) UpdateUserMfa(arg0 context.Context, arg1, arg2 string, arg3 bool) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateUserMfa", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateUserMfa indicates an expected call of UpdateUserMfa.
func (mr *MockClientMockRecorder) UpdateUserMfa(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateUserMfa", reflect.TypeOf((*MockClient)(nil).UpdateUserMfa), arg0, arg1, arg2, arg3)
}

// UpdateUserPassword mocks base method.
func (m *MockClient) UpdateUserPassword(arg0 context.Context, arg1, arg2, arg3 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateUserPassword", arg0, arg1, arg2, arg3)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateUserPassword indicates an expected call of UpdateUserPassword.
func (mr *MockClientMockRecorder) UpdateUserPassword(arg0, arg1, arg2, arg3 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateUserPassword", reflect.TypeOf((*MockClient)(nil).UpdateUserPassword), arg0, arg1, arg2, arg3)
}

// UpdateUserRoles mocks base method.
func (m *MockClient) UpdateUserRoles(arg0 context.Context, arg1, arg2 string) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateUserRoles", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UpdateUserRoles indicates an expected call of UpdateUserRoles.
func (mr *MockClientMockRecorder) UpdateUserRoles(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateUserRoles", reflect.TypeOf((*MockClient)(nil).UpdateUserRoles), arg0, arg1, arg2)
}

// UploadData mocks base method.
func (m *MockClient) UploadData(arg0 context.Context, arg1 string, arg2 io.Reader) (*model.FileInfo, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UploadData", arg0, arg1, arg2)
	ret0, _ := ret[0].(*model.FileInfo)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// UploadData indicates an expected call of UploadData.
func (mr *MockClientMockRecorder) UploadData(arg0, arg1, arg2 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UploadData", reflect.TypeOf((*MockClient)(nil).UploadData), arg0, arg1, arg2)
}

// UploadLicenseFile mocks base method.
func (m *MockClient) UploadLicenseFile(arg0 context.Context, arg1 []byte) (*model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UploadLicenseFile", arg0, arg1)
	ret0, _ := ret[0].(*model.Response)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// UploadLicenseFile indicates an expected call of UploadLicenseFile.
func (mr *MockClientMockRecorder) UploadLicenseFile(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UploadLicenseFile", reflect.TypeOf((*MockClient)(nil).UploadLicenseFile), arg0, arg1)
}

// UploadPlugin mocks base method.
func (m *MockClient) UploadPlugin(arg0 context.Context, arg1 io.Reader) (*model.Manifest, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UploadPlugin", arg0, arg1)
	ret0, _ := ret[0].(*model.Manifest)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// UploadPlugin indicates an expected call of UploadPlugin.
func (mr *MockClientMockRecorder) UploadPlugin(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UploadPlugin", reflect.TypeOf((*MockClient)(nil).UploadPlugin), arg0, arg1)
}

// UploadPluginForced mocks base method.
func (m *MockClient) UploadPluginForced(arg0 context.Context, arg1 io.Reader) (*model.Manifest, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UploadPluginForced", arg0, arg1)
	ret0, _ := ret[0].(*model.Manifest)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// UploadPluginForced indicates an expected call of UploadPluginForced.
func (mr *MockClientMockRecorder) UploadPluginForced(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UploadPluginForced", reflect.TypeOf((*MockClient)(nil).UploadPluginForced), arg0, arg1)
}

// VerifyUserEmailWithoutToken mocks base method.
func (m *MockClient) VerifyUserEmailWithoutToken(arg0 context.Context, arg1 string) (*model.User, *model.Response, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "VerifyUserEmailWithoutToken", arg0, arg1)
	ret0, _ := ret[0].(*model.User)
	ret1, _ := ret[1].(*model.Response)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// VerifyUserEmailWithoutToken indicates an expected call of VerifyUserEmailWithoutToken.
func (mr *MockClientMockRecorder) VerifyUserEmailWithoutToken(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "VerifyUserEmailWithoutToken", reflect.TypeOf((*MockClient)(nil).VerifyUserEmailWithoutToken), arg0, arg1)
}
