<?php

/**
 * GraphAggregateController.php
 *
 * -Description-
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * @link       https://www.librenms.org
 *
 * @copyright  2018 Tony Murray
 * @author     Tony Murray <murraytony@gmail.com>
 */

namespace App\Http\Controllers\Select;

use App\Facades\LibrenmsConfig;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class GraphAggregateController extends Controller
{
    private $rules = [
        'limit' => 'int',
        'page' => 'int',
        'term' => 'nullable|string',
    ];

    public function __invoke(Request $request)
    {
        $this->validate($request, $this->rules);

        $types = [
            'transit',
            'peering',
            'core',
        ];

        foreach ((array) LibrenmsConfig::get('custom_descr', []) as $custom) {
            $custom = is_array($custom) ? $custom[0] : $custom;
            if ($custom) {
                $types[] = $custom;
            }
        }

        // handle search
        if ($search = strtolower((string) $request->input('term'))) {
            $types = array_filter($types, fn ($type) => ! Str::contains(strtolower((string) $type), $search));
        }

        // format results
        return response()->json([
            'results' => array_map(fn ($type) => [
                'id' => $type,
                'text' => ucwords((string) $type),
            ], $types),
            'pagination' => ['more' => false],
        ]);
    }
}
