/*
 * # https://github.com/hughsie/passim/blob/main/.clang-format
 * ---
 * AlignAfterOpenBracket: 'Align'
 * AlignConsecutiveAssignments: 'false'
 * AlignConsecutiveDeclarations: 'false'
 * AlignConsecutiveMacros: 'true'
 * AlignOperands: 'true'
 * AlignTrailingComments: 'true'
 * AllowAllArgumentsOnNextLine: 'false'
 * AllowAllParametersOfDeclarationOnNextLine: 'false'
 * AllowShortBlocksOnASingleLine: 'false'
 * AllowShortCaseLabelsOnASingleLine: 'false'
 * AllowShortFunctionsOnASingleLine: 'Inline'
 * AllowShortIfStatementsOnASingleLine: 'false'
 * AlwaysBreakAfterReturnType: 'All'
 * BinPackParameters: 'false'
 * BinPackArguments: 'false'
 * BreakBeforeBraces: 'Linux'
 * ColumnLimit: '100'
 * DerivePointerAlignment: 'false'
 * IndentCaseLabels: 'false'
 * IndentWidth: '8'
 * IncludeBlocks: 'Regroup'
 * KeepEmptyLinesAtTheStartOfBlocks: 'false'
 * MaxEmptyLinesToKeep: '1'
 * PointerAlignment: 'Right'
 * SortIncludes: 'true'
 * SpaceAfterCStyleCast: 'false'
 * SpaceBeforeAssignmentOperators : 'true'
 * SpaceBeforeParens: 'ControlStatements'
 * SpaceInEmptyParentheses: 'false'
 * SpacesInSquareBrackets: 'false'
 * TabWidth: '8'
 * UseTab: 'Always'
 * PenaltyBreakAssignment: '3'
 * PenaltyBreakBeforeFirstCallParameter: '15'
 * ---
 * Language: 'Proto'
 * ---
 * Language: 'Cpp'
 * IncludeCategories:
 *   - Regex:           '^"config.h"$'
 *     Priority:        '0'
 *   - Regex:           '^<'
 *     Priority:        '2'
 *   - Regex:           '.*'
 *     Priority:        '4'
 * ---
 * Language: 'Cpp'
 * IncludeGuards:
 *   - Regex:           'include/.*\.h$'
 *     PathComponents:  2
 *   - Regex:           '.*\.h$'
 *     PathComponents:  1
 * ...
 */
