/*
 * Copyright (c) 2023 Anton Lindqvist <anton@basename.se>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef LIBKS_ARENA_BUFFER_H
#define LIBKS_ARENA_BUFFER_H

#include <stddef.h>	/* size_t */

struct arena_scope;
struct buffer_getline;

struct buffer	*arena_buffer_alloc(struct arena_scope *, size_t);
struct buffer	*arena_buffer_read(struct arena_scope *, const char *);
struct buffer	*arena_buffer_read_fd(struct arena_scope *, int);
const char	*arena_buffer_getline(struct arena_scope *,
    const struct buffer *, struct buffer_getline *);

#endif /* !LIBKS_ARENA_BUFFER_H */
