/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.cache;

import java.security.Principal;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.RealmIdentity;

public interface RealmIdentityCache {
    public void put(Principal var1, RealmIdentity var2);

    default public RealmIdentity computeIfAbsent(Principal principal, Function<Principal, RealmIdentity> mappingFunction) {
        RealmIdentity newValue;
        Assert.checkNotNullParam((String)"principal", (Object)principal);
        Assert.checkNotNullParam((String)"mappingFunction", mappingFunction);
        RealmIdentity v = this.get(principal);
        if (v == null && (newValue = mappingFunction.apply(principal)) != null) {
            this.put(principal, newValue);
            return newValue;
        }
        return v;
    }

    public RealmIdentity get(Principal var1);

    public void remove(Principal var1);

    public void clear();
}

