/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AbstractPagedArray<E> {
    private static final int PAGE_CAPACITY = 32;
    protected final ArrayList<Page<E>> elementPages = new ArrayList();

    protected static int toPageIndex(int index) {
        return index / 32;
    }

    protected static int toPageOffset(int index) {
        return index % 32;
    }

    protected Page<E> getPage(int index) {
        int pageIndex = AbstractPagedArray.toPageIndex(index);
        if (pageIndex < this.elementPages.size()) {
            return this.elementPages.get(pageIndex);
        }
        return null;
    }

    protected E get(int index) {
        Page<E> page = this.getPage(index);
        return page != null ? (E)page.get(AbstractPagedArray.toPageOffset(index)) : null;
    }

    protected E set(int index, E element) {
        Page<E> page = this.getOrCreateEntryPage(index);
        return page.set(AbstractPagedArray.toPageOffset(index), element);
    }

    protected Page<E> getOrCreateEntryPage(int index) {
        int pages = this.elementPages.size();
        int pageIndex = AbstractPagedArray.toPageIndex(index);
        if (pageIndex < pages) {
            Page<E> page = this.elementPages.get(pageIndex);
            if (page != null) {
                return page;
            }
            Page newPage = new Page();
            this.elementPages.set(pageIndex, newPage);
            return newPage;
        }
        this.elementPages.ensureCapacity(pageIndex + 1);
        for (int i = pages; i < pageIndex; ++i) {
            this.elementPages.add(null);
        }
        Page page = new Page();
        this.elementPages.add(page);
        return page;
    }

    public void clear() {
        for (Page<E> entryPage : this.elementPages) {
            if (entryPage == null) continue;
            entryPage.clear();
        }
        this.elementPages.clear();
        this.elementPages.trimToSize();
    }

    protected static final class Page<E> {
        private final Object[] elements = new Object[32];
        private int lastNotEmptyOffset = -1;

        public void clear() {
            Arrays.fill(this.elements, 0, this.lastNotEmptyOffset + 1, null);
            this.lastNotEmptyOffset = -1;
        }

        public E set(int offset, Object element) {
            if (offset >= 32) {
                throw new IllegalArgumentException("The required offset is beyond page capacity");
            }
            Object old = this.elements[offset];
            if (element != null) {
                if (offset > this.lastNotEmptyOffset) {
                    this.lastNotEmptyOffset = offset;
                }
            } else if (this.lastNotEmptyOffset == offset && old != null) {
                int i;
                for (i = offset; i >= 0 && this.elements[i] == null; --i) {
                }
                this.lastNotEmptyOffset = i;
            }
            this.elements[offset] = element;
            return (E)old;
        }

        public E get(int offset) {
            if (offset >= 32) {
                throw new IllegalArgumentException("The required offset is beyond page capacity");
            }
            if (offset > this.lastNotEmptyOffset) {
                return null;
            }
            return (E)this.elements[offset];
        }

        int lastNotEmptyOffset() {
            return this.lastNotEmptyOffset;
        }
    }

    protected abstract class PagedArrayIterator<T>
    implements Iterator<T> {
        int index;
        boolean indexValid;

        protected PagedArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            for (int i = AbstractPagedArray.toPageIndex(this.index); i < AbstractPagedArray.this.elementPages.size(); ++i) {
                Page page = AbstractPagedArray.this.elementPages.get(i);
                if (page == null) continue;
                for (int j = AbstractPagedArray.toPageOffset(this.index); j <= page.lastNotEmptyOffset; ++j) {
                    if (page.get(j) == null) continue;
                    this.index = i * 32 + j;
                    this.indexValid = true;
                    return true;
                }
            }
            this.index = AbstractPagedArray.this.elementPages.size() * 32;
            return false;
        }

        protected int nextIndex() {
            if (!this.indexValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexValid = false;
            int lastReturnedIndex = this.index++;
            return lastReturnedIndex;
        }
    }
}

