require "spec"

require "../src/exfetch/**"

def with_computed_stdout(&)
  io = IO::Memory.new
  original_stdout = STDOUT
  redirect_stdout = IO::Memory.new
  yield redirect_stdout
  redirect_stdout.to_s
end

# Patch Manip to allow mocking
module Exfetch::Manip
  @@mocks = Hash(String, String).new
  @@file_mocks = Hash(String, String).new

  def self.mock(cmd : String, output : String)
    @@mocks[cmd] = output
  end

  def self.mock_file(path : String, content : String)
    @@file_mocks[path] = content
  end

  def self.clear_mocks
    @@mocks.clear
    @@file_mocks.clear
  end
end
