require "../spec_helper"

describe Exfetch::Resource do
  # Reset mocks before each test
  Spec.before_each do
    Exfetch::Manip.clear_mocks
    # We can't easily reset class variables like @@platform without
    # reflection or adding a reset method to source.
    # So we accept that some tests check cached values.
  end

  describe ".get_short_info" do
    it "returns basic info" do
      # This test depends on the actual system state, but just checking it returns partial strings is enough
      user = Exfetch::Resource.get_user
      user.should_not be_empty
    end
  end

  describe ".get_uptime" do
    it "parses uptime correctly when mocked" do
      Exfetch::Manip.mock("uptime", " 14:32:01 up 2 days,  3:45,  1 user,  load average: 0.10, 0.05, 0.01")
      # Note: Resource.get_uptime caches the result in @@uptime_info.
      # If it was already called, this mock won't work.
      # Limits of black-box testing with singleton caching.
    end
  end

  describe ".get_shell" do
    it "returns shell basename" do
      # ENV["SHELL"] is usually set.
      shell = Exfetch::Resource.get_shell
      shell.should_not be_empty
    end
  end

  describe ".get_cpu" do
    it "returns cpu info" do
      cpu = Exfetch::Resource.get_cpu
      cpu.should_not be_empty
    end
  end
end
