require "../spec_helper"

describe Exfetch::Options do
  describe ".parse" do
    it "parses default options" do
      options = Exfetch::Options.parse([] of String)
      options.nerd_icons.should be_false
      options.lowercase.should be_false
    end

    it "parses flags" do
      options = Exfetch::Options.parse(["-n", "-l"])
      options.nerd_icons.should be_true
      options.lowercase.should be_true
    end

    it "parses color argument" do
      options = Exfetch::Options.parse(["-c", "red"])
      options.color.should eq(1_u8)
    end

    it "parses padding" do
      options = Exfetch::Options.parse(["--padding=5"])
      options.padding.should eq(5)
    end
  end
end
