require "../spec_helper"

describe Exfetch::Manip do
  describe ".bytes_to_mebibytes" do
    it "converts bytes to mebibytes string" do
      # 1024 * 1024 = 1 MiB
      Exfetch::Manip.bytes_to_mebibytes(1048576_i64).should eq("1.00")
      Exfetch::Manip.bytes_to_mebibytes(0_i64).should eq("0.00")
      Exfetch::Manip.bytes_to_mebibytes(1572864_i64).should eq("1.50") # 1.5 MiB
    end
  end

  describe ".sanitize" do
    it "removes newlines and strips whitespace" do
      Exfetch::Manip.sanitize("  hello world  \n").should eq("hello world")
      Exfetch::Manip.sanitize("\nhello\n").should eq("hello")
    end
  end

  describe ".has_command?" do
    it "returns true for existing commands" do
      # Assuming 'sh' exists on all POSIX systems
      Exfetch::Manip.has_command?("sh").should be_true
    end

    it "returns false for non-existing commands" do
      Exfetch::Manip.has_command?("non_existent_command_12345").should be_false
    end
  end

  describe ".run_command" do
    it "runs a command and returns output" do
      Exfetch::Manip.run_command("echo", ["hello"]).strip.should eq("hello")
    end

    it "returns empty string on failure" do
      Exfetch::Manip.run_command("false").should eq("")
    end
  end

  describe ".dir_size" do
    # Hard to test without a known directory structure, but we can test on a dummy tmp dir hopefully
    it "returns 0 for non-existent dir" do
      Exfetch::Manip.dir_size("/non/existent/path/123").should eq(0)
    end
  end
end
