require "../spec_helper"

describe Exfetch::CLI do
  describe ".colorize" do
    it "wraps text in ansi codes" do
      text = Exfetch::CLI.colorize("hello", 1_u8) # Red
      text.should contain("\e[31mhello\e[0m")
    end

    it "handles bright colors" do
      text = Exfetch::CLI.colorize("hello", 9_u8) # Bright Red
      text.should contain("\e[1;31mhello\e[0m")
    end
  end

  describe ".render" do
    it "renders output string" do
      opts = Exfetch::Options.new
      opts.ascii = "Tear"
      opts.order = [:user, :os] # Set explicit order to match fake data size (2)
      ascii = ["  ,  ", " / \\ "]
      labels = ["USER", "OS"]
      results = ["testuser", "Linux"]
      max_label = 6

      output = Exfetch::CLI.render(ascii, labels, results, opts, max_label)
      output.should contain("USER")
      output.should contain("testuser")
      output.should contain("  ,  ")
    end
  end
end
