{
  description = "exfetch is a shell-extensible fetching utility, written in crystal";

  inputs = {
    nixpkgs.url = "github:nixos/nixpkgs?ref=master";
    flake-parts.url = "github:hercules-ci/flake-parts";
    self.submodules = true;
  };

  outputs = { self, nixpkgs, flake-parts, ... }@inputs:
    flake-parts.lib.mkFlake { inherit inputs; } (
      { lib, ... }:
      let
        version = self.sourceInfo.dirtyShortRev or self.sourceInfo.shortRev;
      in
      {
        systems = lib.intersectLists lib.systems.flakeExposed (
            lib.platforms.linux ++
            lib.platforms.freebsd ++
            lib.platforms.netbsd ++
            lib.platforms.openbsd
          );

        perSystem = { self', pkgs, ... }: {
          packages = {
            exfetch = pkgs.callPackage ./default.nix { inherit version; };
            default = self'.packages.exfetch;
          };
        };
      }
    );
}
