module Exfetch
  module Manip
    extend self

    MEBIBYTE = 1024_i64 ** 2

    @@commands = Hash(String, Bool).new

    def bytes_to_mebibytes(bytes : Int64) : String
      "%.2f" % (bytes.to_f / MEBIBYTE)
    rescue
      "0.00"
    end

    def sanitize(str)
      str.gsub(/[\n\r]/, "").strip
    end

    def has_command?(cmd : String) : Bool
      @@commands[cmd] ||= !!Process.find_executable(cmd)
    end

    def run_command(cmd : String, args : Array(String)? = nil) : String
      io = IO::Memory.new
      begin
        status = Process.run(cmd, args, output: io)
        return "" unless status.success?
        io.to_s
      rescue ex : Exception
        ""
      end
    end

    def scrape_file(key, path)
      return "" unless File.exists?(path)
      File.read(path).lines.find(&.starts_with?(key)).try(&.split('=', 2).last.tr("\"", "").strip) || ""
    end

    def command_lines_len(cmd : String, args : Array(String)? = nil) : Int32
      Process.run(cmd, args) do |process|
        process.output.each_line.size
      end
    rescue
      0
    end

    def dir_size(path : String, recursive : Bool = false)
      Dir.glob("#{path}/#{recursive ? "**/" : "*"}").size
    rescue
      0
    end
  end
end
