# Version 2.7.2

## Bugfixes

### Editor

 - support importing DXF files with non-ASCII filenames on Windows ([726d856](https://github.com/horizon-eda/horizon/commit/726d856071037bc650463e482fe9882c0c3b9cf4))

### Board Editor

 - properly smash silkscreen arcs for packages on bottom side ([5ef382a](https://github.com/horizon-eda/horizon/commit/5ef382a94af59049a725205d3408bee951a369fe))
 - properly export arcs in bottom packages ([87de222](https://github.com/horizon-eda/horizon/commit/87de2225fe2dfc037f7a72eb6543e18e3279e930))

### Pool Manager

 - don't crash if default via or frame are not found ([4e07ce9](https://github.com/horizon-eda/horizon/commit/4e07ce934745a0b4a2d72d4e26f1e0de4a850dce))

### Editors

 - export pictures in PDFs ([8eeed28](https://github.com/horizon-eda/horizon/commit/8eeed2818855757926ba9a555bb92196ed25c1cd))
 - export PDFs at x1 scale instead of x10 ([03220cb](https://github.com/horizon-eda/horizon/commit/03220cbba7cb7020c3e61a71ba9db5e7fd20a396))

# Version 2.7.1

## Bugfixes

## Board Editor

- don't crash when deleting smashed silkscreen text ([bb764f5](https://github.com/horizon-eda/horizon/commit/bb764f53dc4046fdbdc286f668b3525300f1d891))

# Version 2.7.0

## New Features

### Editors

 - make it easier to update the project pool cache from schematic and board editor ([afaea53](https://github.com/horizon-eda/horizon/commit/afaea53834e56d95f024dec94b168d8b8c9cc3ab))

### Board Editor

 - Add save and load for PnP export ([40bd730](https://github.com/horizon-eda/horizon/commit/40bd7309f90be258b9e1748d9bcd7d051f539182))

### Package Editor

 - Allow packages to fix parameters ([596ac13](https://github.com/horizon-eda/horizon/commit/596ac13f776536d5cc24b78fce991c01c18a110d))

## Enhancements

### Symbol Editor

 - make pins selectable at their name ([22e640c](https://github.com/horizon-eda/horizon/commit/22e640cb004b04c9b7da463f8ac50beb8a8e29ee))

### Schematic Editor

 - select net line to place bus ripper ([3547c81](https://github.com/horizon-eda/horizon/commit/3547c81335072c35479113681653dd1a6a425338))

### Board Editor

 - add pick&place customisation reset button ([6a0a996](https://github.com/horizon-eda/horizon/commit/6a0a9963d209a20702b116f4d53d2d806b8c71bd))
 - improve rendering performance of polygon pads ([250ee06](https://github.com/horizon-eda/horizon/commit/250ee069b953d8c9f54954b0644d2b8fdff9a364))
 - highlight selected component from unplaced list in schematic ([11297b8](https://github.com/horizon-eda/horizon/commit/11297b818bb0dab816774c56b2106567f508c8a1))

### Project Manager

 - improve performance of recently-used lists ([dd61301](https://github.com/horizon-eda/horizon/commit/dd613010d89e2f2c2437a657f186528a0b10f3a3))

## Bugfixes

### Pool Manager

 - correctly handle derived parts in partial pool update ([3eb2708](https://github.com/horizon-eda/horizon/commit/3eb2708dcac899a5d0fa13b9269952e021c5871d))
 - properly import kicad symbols using double angles ([bfbe5b1](https://github.com/horizon-eda/horizon/commit/bfbe5b12b6441390e1ce3a517a05a6d496be4509))

### Board Editor

 - properly assign nets when pasting vias that have a set net ([65d99ec](https://github.com/horizon-eda/horizon/commit/65d99ecce1916ab6d8c1ac7211a28da9c4097ca8))
 - show via preview in correct size ([9b181c1](https://github.com/horizon-eda/horizon/commit/9b181c12b5994e85dc094564e52a75dd319dc868))
 - don't crash when deleting an inner layer for which a blind/buried drill export entry exists ([5004975](https://github.com/horizon-eda/horizon/commit/500497593ccf7daa578c7d59f967c74748cacdef))
 - use sensible defaults for pick&place customisation (only applies to new projects) ([f7fc2eb](https://github.com/horizon-eda/horizon/commit/f7fc2ebf82c4f8711b1500ccd872d59253ce39a0))
 - Draw Track Tool: fix crash when drawing arc tracks connected to pads ([977ddc0](https://github.com/horizon-eda/horizon/commit/977ddc08307887ee4192ac2fc8746253dc99ebf7))

### Schematic Editor

 - allow reassigning bussed net segments ([44495f4](https://github.com/horizon-eda/horizon/commit/44495f45cb3387b8d99cf8cd8be97b0d5fce83ea))

### Package Editor

 - don't fail clearance check if there is no copper layer at all ([87c4e9c](https://github.com/horizon-eda/horizon/commit/87c4e9cb90483de242546fe3f0cef3b096bfa2c1))

### Editor

 - PDF export: correctly render backwards text ([90bf26e](https://github.com/horizon-eda/horizon/commit/90bf26e2117b4140af30eec3654a8f3cc633b993))
 - prevent window from becoming transparent in transparent objects ([1e41cde](https://github.com/horizon-eda/horizon/commit/1e41cde0ddd0e445db17434350e103e2c8101809))

### Padstack Editor

 - set needs save when toggling required in parameter editor ([b979731](https://github.com/horizon-eda/horizon/commit/b979731880c390a91e9d5fb182b96a21010632a8))

# Version 2.6.0

## New Features

### Board Editor

 - add user layers ([d3039e1](https://github.com/horizon-eda/horizon/commit/d3039e130710a62ab0dda4f58b1f8ed7de99e0b8))

### Editors

 - add undo/redo selection ([a61938d](https://github.com/horizon-eda/horizon/commit/a61938d6e8bc79f3482aed37720f4a10944c02ea))
 
## Enhancements

### Editors

 - draw line tool: connect to junctions in non-arbitrary restrict modes ([d0da4e8](https://github.com/horizon-eda/horizon/commit/d0da4e878ad05e81ffb97f24e0988ff65c28e380))
 - add sticky selection option ([d1ef847](https://github.com/horizon-eda/horizon/commit/d1ef8470276291823a11574c4e66bdd4c8c508f7))
 - make selection modifier action configurable ([d54da98](https://github.com/horizon-eda/horizon/commit/d54da9803740de2f8882c564b850f9b6766e7f6c))

### Pool Manager

 - support git integration even if the pool isn't at the root of the repo ([4a96f0c](https://github.com/horizon-eda/horizon/commit/4a96f0cf133b5cb096e060e90350fe90e9fff938))

### Board Editor

 - add reset button and package column to parts window ([8a262c9](https://github.com/horizon-eda/horizon/commit/8a262c902129359c67374108a2200edcb7a8c17e))
 - highlighting a net also highlights planes ([31c757d](https://github.com/horizon-eda/horizon/commit/31c757ddc7e9d9127eb8a079c58ec7635bc82947))

## Bugfixes

### Kicad Symbol Import

 - properly handle single-unit symbols ([ee08688](https://github.com/horizon-eda/horizon/commit/ee0868807336c394af6ecf7fe3f83346557db981))

### Schematic Editor

 - don't throw an exception when changing sheets while string property has focus ([7f66c86](https://github.com/horizon-eda/horizon/commit/7f66c869b79299961078761cfdefb4e82664103a))
 - disallow changing power net netclasses in non-top blocks ([5c1a25a](https://github.com/horizon-eda/horizon/commit/5c1a25ad7b3975729192e2e9f18acb0101ee510a))

### Board Editor

 - keep invalid board panels selectable ([79704c7](https://github.com/horizon-eda/horizon/commit/79704c7bad3e25e77cb0589ed22f31bc04c1c218))
 - line loop to polygon: properly handle paths with only two vertices ([d2631ab](https://github.com/horizon-eda/horizon/commit/d2631abcc2f3d4a96e736e6dea705a9a3e905a5a))
 - don't crash when opening a board with missing plane nets ([7085323](https://github.com/horizon-eda/horizon/commit/70853236ac233df229bd28160c6f02acc4382440))
 - router: don't crash when walking around arcs ([49973c6](https://github.com/horizon-eda/horizon/commit/49973c6ed1fb68b48dffa9645e5aa515d8596af1))
 - ODB++ export: don't crash if libc doesn't support transliteration ([4af3f8d](https://github.com/horizon-eda/horizon/commit/4af3f8da78f51c5437ea801062e8877ba49d0c46))

### Part Editor

 - don't crash if there are no parametric tables and columns ([a0e3a82](https://github.com/horizon-eda/horizon/commit/a0e3a82bcc5454c61023d2d4f82eb75a03f3ea65))

### Package Editor

 - properly import KiCad packages with digit-only names and decimal angles ([9ae80a7](https://github.com/horizon-eda/horizon/commit/9ae80a744775c76f84561941aff6b5cdb3e3a259))

# Version 2.5.0

## New Features

### Board Editor

 - add support for blind and buried vias ([57007a0](https://github.com/horizon-eda/horizon/commit/57007a0131083e8a73581b1c2e050a689267d5e3), [ba2553f](https://github.com/horizon-eda/horizon/commit/ba2553f07a375c07d3f32e8a809d80bb963e779a))

### Editors

 - add undo/redo that never forgets ([f1c6797](https://github.com/horizon-eda/horizon/commit/f1c6797175ea586a6a9a38dd274613c867af51a3))

### Pool Manager

 - undo/redo for Unit, Entity and Part editors ([74ba93d](https://github.com/horizon-eda/horizon/commit/74ba93db6b39a722e3e320ef647f692947d63025))

## Enhancements

### Project Manager

 - set default via and frame in new project pools ([7d05a8c](https://github.com/horizon-eda/horizon/commit/7d05a8c8f378421550c8efd5a1a6372dd1971802))

### Pool Manager

 - scroll to top when sorting most recently modified first ([2a51a8a](https://github.com/horizon-eda/horizon/commit/2a51a8a28981f5a2af69dfa2371826c1af825b96))
 - Add shortcuts in editors ([f5a1546](https://github.com/horizon-eda/horizon/commit/f5a15466b889d2aedf0dd0994764b1617e1acfd7))

### Schematic Editor

 - new tool for pasting part ([8e4761c](https://github.com/horizon-eda/horizon/commit/8e4761cb9e2e728c013c785d563f2a43895fca0c))
 - support search in pin names window ([b703038](https://github.com/horizon-eda/horizon/commit/b7030384ccd3b864d474129f2ff529c8c8b7b6c7))
 - Increase bus sequence limits to 1000 ([80168d3](https://github.com/horizon-eda/horizon/commit/80168d3e1e8af1bb821e631949dee40837e061d2))


### Board Editor

 - support up to 8 inner layers ([a94294e](https://github.com/horizon-eda/horizon/commit/a94294e189dca24673bee109d2581f78982de719))
 - action for selecting plane at cursor ([f0a1b7c](https://github.com/horizon-eda/horizon/commit/f0a1b7cda6ab1a6f5a231467b51946c249675332))

### Editors

 - don't clear undo/redo history when reloading the pool ([4dd2fec](https://github.com/horizon-eda/horizon/commit/4dd2fec5197593607c3c5b8d701f4b8dc6895086))

### Part Editor

 - add context menu for editing linked items ([a25bf9c](https://github.com/horizon-eda/horizon/commit/a25bf9c96d97c1f3547978b29eb63ab34894b0f9))
 - support creating base part from current part ([b58e542](https://github.com/horizon-eda/horizon/commit/b58e542cafdabdffac91bebf5a8bae6e2d998772))
 - support changing base part ([e290d6e](https://github.com/horizon-eda/horizon/commit/e290d6eea00ad60617d0e999c4ce7e69dd00bf05))
 - improve visual stability of parametric editor ([bbea900](https://github.com/horizon-eda/horizon/commit/bbea90004da48c874dbea12e171232678d4b75b1))

### Pool And Project Manager

 - automatically add newly-added pools to recent list ([c2962c4](https://github.com/horizon-eda/horizon/commit/c2962c48c96391bfe6a60500b55cc28c2e342857))
 - add search for recent pools and projects ([bf6bbbd](https://github.com/horizon-eda/horizon/commit/bf6bbbde478909d0a920c4a8ddf976f4f331794c))

### Symbol Editor

 - support changing pin name orientation while placing pin ([71748b5](https://github.com/horizon-eda/horizon/commit/71748b59acfb1120bb9b9da8625db070e451c117))

## Bugfixes

### Board Editor

 - properly handle decals on panels ([3f5e09d](https://github.com/horizon-eda/horizon/commit/3f5e09d77f42846f540318c67197fcce7f1e9273))
 - Gerber export: fix arcs in JLCPCB's gerber preview ([c3bf67e](https://github.com/horizon-eda/horizon/commit/c3bf67ec43b80c9b5f797aca694eb8e485c8509f))
 - properly set visibility of inner layers when opening a board for the first time ([7ca7252](https://github.com/horizon-eda/horizon/commit/7ca72524cc7c84bad110ad499b42f0585c94bda8))
 - omit zero-diameter holes in STEP export to avoid error ([602a878](https://github.com/horizon-eda/horizon/commit/602a87825e5018eaf0be896fc5929e1a3316c90f))
 - update airwires after dragging track ([a6cf447](https://github.com/horizon-eda/horizon/commit/a6cf447c8a42ce33ab942cc9653fa20367700df2))
 - correctly export planes in panels ([b29af19](https://github.com/horizon-eda/horizon/commit/b29af1995a6dc095eb3afa0b4898acc5720dafff))
 - fix gerber zip file genreation for non-ASCII paths ([baeb9c7](https://github.com/horizon-eda/horizon/commit/baeb9c7c94ec5a9a7fd540916e2b10429189fbb3))
 - don't set zero track width on newly created inner layers ([5c89a23](https://github.com/horizon-eda/horizon/commit/5c89a23d08642452c42fbc91fbb6ad2172e347d2))
 - don't crash on on PTH-PTH clearance violation ([b630cc5](https://github.com/horizon-eda/horizon/commit/b630cc5dc92f08c02e5102e280e61cb6e3ec3e37))
 - properly export gerber for plane fragments in holes of enclosed planes ([1c2c713](https://github.com/horizon-eda/horizon/commit/1c2c7134939a5ff9a1c1d875190c945cf7e37bf8))
 - don't select vias in work layer only mode if work layer isn't in via layers ([d0e5d40](https://github.com/horizon-eda/horizon/commit/d0e5d405f0fb8585279cf46e3de1d5cdc465c857))
 - don't start routing tracks by dragging if tracks aren't selectable ([29b5623](https://github.com/horizon-eda/horizon/commit/29b562343fc3d007caaebef9da0c63648889dc19))

### Editors

 - focus canvas when opening editor so that shortcuts work right away ([4078fef](https://github.com/horizon-eda/horizon/commit/4078fef4fdc77df1d504e4b4aade845ee6571b65))
 - don't crash on exception in tool constructor ([c4cc669](https://github.com/horizon-eda/horizon/commit/c4cc669d2363f3e61f83b1a69fb391367da76995))
 - open preferences window in foreground ([eee4fd2](https://github.com/horizon-eda/horizon/commit/eee4fd232165da794958309ddc97c5993eb18988))

### Schematic Editor

 - correctly manage buses in hierarchy ([611e3e7](https://github.com/horizon-eda/horizon/commit/611e3e72e67ce1fc386ca6fcb845f17e2a5e1f8e))
 - properly handle switching to outside-of-hierarchy sheets ([0658dea](https://github.com/horizon-eda/horizon/commit/0658deacb848755e63addc3761ddbbe04e20f3e4))
 - show correct symbol refdes in properties in hierachies ([898de12](https://github.com/horizon-eda/horizon/commit/898de125d58d4f0f2b72c8f7d406aac6758ec1d9))
 - properly set smashed reference designators in instances ([56e43ed](https://github.com/horizon-eda/horizon/commit/56e43edcf2150447498d53452256b4b3c7ab0650))
 - don't create one-member net without net line when clicking on starting pin ([7d0d63d](https://github.com/horizon-eda/horizon/commit/7d0d63d5655e8561dd1414859bd2e1ff62076c68))
 - properly delete unused nets after assigning nets ([c07b834](https://github.com/horizon-eda/horizon/commit/c07b83402b5659a3cb3c3abf5b8a38f2205c6d52))
 - reduce lag when switching sheets ([efac86b](https://github.com/horizon-eda/horizon/commit/efac86b06155c8c0eddfab9e0a88689574c21b56))

### Part Browser

 - fix resizing tags column ([e6e1a98](https://github.com/horizon-eda/horizon/commit/e6e1a98c7ab40f1152c3a26e7ebcd73706f08eaf))

### Pool And Project Manager

 - don't crash when oping a pool that includes unusable included pools ([d29df7e](https://github.com/horizon-eda/horizon/commit/d29df7e12ec95248978b0eb8f3dbd956b5be9256))

### Part Editor

 - don't crash when changing parametric table in some circumstances ([9334183](https://github.com/horizon-eda/horizon/commit/93341833b039b12152d2148e05b36b25f9c5708e))
 - enable saving when toggling parametric N/A value ([9a014ec](https://github.com/horizon-eda/horizon/commit/9a014ec3bf206551af538cae662014c82647c9cc))
 - improve layout to make window less tall ([ed26cf2](https://github.com/horizon-eda/horizon/commit/ed26cf20c228ea7a692ab85c91be3a52df95bf1b))


## For packagers

 - Boost is no longer a dependency ([60a4f9e](https://github.com/horizon-eda/horizon/commit/60a4f9ece25233ae3a49ad0c03152ca9f98d8564))
 
# Version 2.4.0

## New Features

### Board Editor

 - Support for curved tracks ([05c31ef](https://github.com/horizon-eda/horizon/commit/05c31efabccd3496a44f61e2eaccf2ab1cb0e230))
 - Tools for copying package placement and other items across projects ([f5821be](https://github.com/horizon-eda/horizon/commit/f5821bec5159cc6e4b8beaf8c848d0d3fe2286d5), [f5821be](https://github.com/horizon-eda/horizon/commit/f5821bec5159cc6e4b8beaf8c848d0d3fe2286d5))

### Schematic Editor

 - BOM format customisation ([2ad36a6](https://github.com/horizon-eda/horizon/commit/2ad36a68f1a2aafc650b0f553e70265f75bb92e4))

## Enhancements

### Board Editor

 - save plane fragments to separate file ([2305470](https://github.com/horizon-eda/horizon/commit/2305470d9027c10d23fd7219e0f77692a5ec63fb))
 - check for zero-length edges in outline polygons ([0c3b1ea](https://github.com/horizon-eda/horizon/commit/0c3b1ea234215ded41d117c620fc8490d324170e))
 - add action for opening project of included board ([da88ab5](https://github.com/horizon-eda/horizon/commit/da88ab542888c93229c4d1f57e59a01bdc7a424d))
 - support relative paths for including boards ([2a1b80a](https://github.com/horizon-eda/horizon/commit/2a1b80a3d746900514d81b04c41daac2934160d3))
 - rename add plane/keepout tool to asssign plane/keepout for better discoverability ([1751de3](https://github.com/horizon-eda/horizon/commit/1751de31cfed70a8accd90f6a3eac90444fe487f))
 - gerber output: output arcs as such ([0429203](https://github.com/horizon-eda/horizon/commit/04292035d693e3708c59d21025fcee0be3a89a89))

### Schematic Editor

 - copy pool items from source when pasting from other project ([0b747db](https://github.com/horizon-eda/horizon/commit/0b747dbad5bd3a9e534552d8de4d618e1b66d064))
 - support moving pictures to other sheet ([4e2dec1](https://github.com/horizon-eda/horizon/commit/4e2dec13aac1a9a8aff1e363fb267e0f5bfe3bba))
 - new tool for setting tags based on reference designators ([2acc6c0](https://github.com/horizon-eda/horizon/commit/2acc6c06244c0f6b983e49cb9f4152f34dc66ec4))
 - copy/paste diffpairs across projects ([5d9836b](https://github.com/horizon-eda/horizon/commit/5d9836b0e4cae2cb4a0e9fd18d8ac6a6ad07dcdb))
 - copy/paste group and tag names ([84fcec7](https://github.com/horizon-eda/horizon/commit/84fcec768395e0a11e18ee0ca82f6aae17582a39))
 - include datasheet links in exported PDF ([e9de499](https://github.com/horizon-eda/horizon/commit/e9de49915208335e65839049b9eb13c996cd57fe))
 - take arcs in symbols into account for selection box ([cc5a9d3](https://github.com/horizon-eda/horizon/commit/cc5a9d31c5dd954de12160ac26843b3504dd3eeb))
 - use part browser for assigning parts ([b7dc846](https://github.com/horizon-eda/horizon/commit/b7dc846f239a59a0a2e4a8da4b9d5775b800a72f))

### Symbol Editor

 - remember pin orientation across invocations of place pin tool ([206df68](https://github.com/horizon-eda/horizon/commit/206df6844fdac089fd298b69b8957feeb5fb2d99))
 - rename preview to text placement ([8279060](https://github.com/horizon-eda/horizon/commit/82790600e4983b45ed7990cc0961d8a81ec3f086))
 - automatically fit symbol previews ([e3e998f](https://github.com/horizon-eda/horizon/commit/e3e998f1835e4fd964c3bc6fa5d15752a7dcf9e6))
 - make bounding box color configurable ([6305e9b](https://github.com/horizon-eda/horizon/commit/6305e9b166990f611084e57a8193e40304239c4e))

### Package Editor

 - support snapping to pad corners ([6e94636](https://github.com/horizon-eda/horizon/commit/6e946362f271264ab49b857f2b5398a3488fbb73))
 - take holes into account for pad bounding box calculation ([d81981f](https://github.com/horizon-eda/horizon/commit/d81981f59d53e15967de557a68ddc148b689ca0a))

### Editors

 - Draw polygon tool: don't create zero-length edges ([c25582e](https://github.com/horizon-eda/horizon/commit/c25582e4e444b78218fe0537468c75d61c09234a))
 - Action for cycling layer display mode ([6d332fb](https://github.com/horizon-eda/horizon/commit/6d332fb4ece06d25b8cc7b632482fa0d7723877d))
 - improved handling of arrow keys in tool popover ([04da67c](https://github.com/horizon-eda/horizon/commit/04da67c8db459213c51e6532e0d027da7b758f4b))
 - lower drag threshold to 10px ([17eb3f5](https://github.com/horizon-eda/horizon/commit/17eb3f56038a10fec45bb027c6c40b3a2d21580c))
 - Action for opening datasheet on symbols and packages ([9eaf02c](https://github.com/horizon-eda/horizon/commit/9eaf02c5330dc4b27e9e9d3e1043333feaaa9ae8))
 - Option for vertical tool bar in preferences ([dd36b44](https://github.com/horizon-eda/horizon/commit/dd36b4435cef502bf6f94649699a6abbf0648691))

### Pool Manager

 - make check messages in editors more clear ([a5a278b](https://github.com/horizon-eda/horizon/commit/a5a278b42c3854de6465b848f0c779ee015020cc))
 - don't ask for filename when creating pool items ([fd06c2b](https://github.com/horizon-eda/horizon/commit/fd06c2ba44f0c281959a0acfe5e79170c4fe4f68))
 - Part wizard: use column headers ([91360cd](https://github.com/horizon-eda/horizon/commit/91360cd25ea1477fa6dedb8a5244bb0b4bda1602))
 - make lists in Unit and Entity editors sortable by clicking on headers ([6df7e3d](https://github.com/horizon-eda/horizon/commit/6df7e3d298a10577aa29a80327065c43c5700c07))
 - show check status in button label ([f380a73](https://github.com/horizon-eda/horizon/commit/f380a73c991f2f4c36b678a35dda5a535b59c631))
 - automatically reload list of available pools ([10c253e](https://github.com/horizon-eda/horizon/commit/10c253eed75d24f48c429562cfdadcd1fa0e96d4))

### Pool And Project Manager

 - prevent saving items to the wrong directory ([fd88e2c](https://github.com/horizon-eda/horizon/commit/fd88e2c499763ad9ad3ca216b404289019434285))

### Project Manager

 - remember selected project pool ([1b5b50f](https://github.com/horizon-eda/horizon/commit/1b5b50ffc51f13f239c27c38fb157d80f00a54b8))

### Digi-Key Stock Info

 - show pricing for alternate packagings ([f15ad64](https://github.com/horizon-eda/horizon/commit/f15ad6410ca299f30edf042ab3ae9ffd19c2f270))

### Python Module

 - support using planes as saved instead of updating them ([456fbbc](https://github.com/horizon-eda/horizon/commit/456fbbc315204c2dcdf811947bfb49af2f6664ea))

## Bugfixes

### Board Editor

 - PDF export: correctly export small arcs as encountered on padstacks with rounded corners ([16ac7d9](https://github.com/horizon-eda/horizon/commit/16ac7d984809b6b3e106ecf5bd142ed2e067aa0f))
 - correctly represent polygon arcs in PDF export if the arc's center isn't on the perpendicular bisector ([49d4151](https://github.com/horizon-eda/horizon/commit/49d41516948c4e72adc6244fcfedeeb370e7052f))
 - Fabrication output: set modification time for improved compatibility with board manufacturers ([7a0db52](https://github.com/horizon-eda/horizon/commit/7a0db52ecbf5c0c45f1d96dc60f36223fc95bf28))
 - properly copy junctions for tracks connected to pad and junction ([c9e3101](https://github.com/horizon-eda/horizon/commit/c9e310116962a560f4308b299b27b26566448bc5))
 - STEP Export: copy step models to project pool if needed ([fedcf8a](https://github.com/horizon-eda/horizon/commit/fedcf8afe7df68fd806d932b9ce7245ad5230d46))
 - STEP export: don't crash on zero-length edges in outline polygons ([b36d297](https://github.com/horizon-eda/horizon/commit/b36d297f30607afe42875a71fc9cbbeabc92be44))
 - PDF Export: properly close paths used for planes ([372cd80](https://github.com/horizon-eda/horizon/commit/372cd800f8c3cd4c23f2c35400260052c5a26976))
 - prevent cursor from disappearing after updating planes ([83b8dd7](https://github.com/horizon-eda/horizon/commit/83b8dd77d3ffba3eee0a9d190c4c8badb1b52d2a))
 - properly show meander tuning status ([c1d3386](https://github.com/horizon-eda/horizon/commit/c1d3386ec04d5080637dd682646fe8e0ecb61d78))
 - ODB++ output: correctly draw mirrored arcs ([5df1814](https://github.com/horizon-eda/horizon/commit/5df1814d94ad0943052b2b1488d266fe82337e8f))
 - gerber output: correctly draw outline arcs  in mirrored packages ([0429203](https://github.com/horizon-eda/horizon/commit/04292035d693e3708c59d21025fcee0be3a89a89))
 - don't crash on unfilled planes ([91e9293](https://github.com/horizon-eda/horizon/commit/91e9293f492f6748155a6412f494679bba33f9b0))

### Schematic Editor

 - don't crash when deleting one leg of a diffpair and saving ([fd624da](https://github.com/horizon-eda/horizon/commit/fd624da21ff73220b51ac68337c5028d099c9c73))
 - don't crash when deleting bus ripper and attached net line ([ae92db2](https://github.com/horizon-eda/horizon/commit/ae92db2a902d2f50f169e7330f3a6b6521f1f52b))
 - properly handle pools that are installed while the editor is running ([c4bfb89](https://github.com/horizon-eda/horizon/commit/c4bfb893a2c26edad5da29780254ec3304655ca8))
 - don't crash if unplaced pin is not connected ([f906b24](https://github.com/horizon-eda/horizon/commit/f906b24c83be2189ccbb47868e92e65df6ffdb25))

### Package Editor

 - don't crash in edit pad dialog when changing pads with the mouse wheel while ther's still a pending edit in a spinbutton in one of the parameters ([b69b251](https://github.com/horizon-eda/horizon/commit/b69b25162e8c6c25840306eb092b908014fa2422))
 - properly handle pads with empty bounding box ([89ac96b](https://github.com/horizon-eda/horizon/commit/89ac96b6252067b67449c3389b5cc4a5dfa891b5))

### Symbol Editor

 - support merging junctions ([25434a1](https://github.com/horizon-eda/horizon/commit/25434a16e14693b51a39f92f69ec76b6f55b5104))

### Editors

 - don't accidentally cache dependencies when opening items in a project pool ([cd62c70](https://github.com/horizon-eda/horizon/commit/cd62c70bd4651a90a0f5fdb51659869ad836b4ec))
 - don't crash when pressing escape in non-modal tool windows if there's a pending edit in a spinbutton ([e8ab00b](https://github.com/horizon-eda/horizon/commit/e8ab00bb84929c5c4f5469ca7696f2ed7ca7a771))
 - don't try to paste objects into editors that don't support them ([9fac140](https://github.com/horizon-eda/horizon/commit/9fac140b92536ab6e68a805d6426aac243df70f1))
 - fix pasting polygons on non-existing layers ([23a3b1c](https://github.com/horizon-eda/horizon/commit/23a3b1c533f2488d520ecc585af68162150cc138))
 - allow toggling pictures when a tool is active ([a73dd76](https://github.com/horizon-eda/horizon/commit/a73dd7600fd4acf01b50c6ecbfa81c5b3cb17594))
 - properly draw arcs with overlapping ends ([76e68fe](https://github.com/horizon-eda/horizon/commit/76e68fe4426e0fb91b23c0434ecf08a5344d956a))

### Pool Manager

 - don't crash in symbol editor launched from part wizard if in a project pool ([95ce0bc](https://github.com/horizon-eda/horizon/commit/95ce0bc8639d0a3b5c1449170cb7d018dae3b415))
 - prevent long names in the where used box from making the info panel to wide ([d5cf85d](https://github.com/horizon-eda/horizon/commit/d5cf85d64a8acdf755906526d8f2c757f70554d9))
 - ellipsize paths in settings tab if needed ([11e02a1](https://github.com/horizon-eda/horizon/commit/11e02a1fc8f186764a677f0997efb79ac324a145))
 - support sorting padstacks by last modified time ([167c354](https://github.com/horizon-eda/horizon/commit/167c3542e8d5d8f10469c7f3a767fae996158f8c))
 - Tags editor: don't add empty tags ([6aa6a3f](https://github.com/horizon-eda/horizon/commit/6aa6a3f504825dca6bce5b594e358f35a3901639))

### Part Editor

 - ellipsize package and 3D model name to prevent window from getting too wide ([675f183](https://github.com/horizon-eda/horizon/commit/675f183e0a8738c5fda44319dae678eac77a81bf))

### Project Manager

 - don't update pool when opening a project after a new item has been added to the project pool ([1766df2](https://github.com/horizon-eda/horizon/commit/1766df2702e34113caaa2bc91c55679442189931))

### Pool and Project Manager

 - automatically append .json when moving/renaming pool items ([9819146](https://github.com/horizon-eda/horizon/commit/9819146e551102ac3d8986d9799ac50b6b28a13a))
 - support adding keybinding for Select connected lines tool ([015ba35](https://github.com/horizon-eda/horizon/commit/015ba35cf6ea3fe6793be7efffe741e6ea1010bf))
 - don't crash when closing windows that don't have an open pool/project ([3b08073](https://github.com/horizon-eda/horizon/commit/3b080737428eeb310834a8417fae33bb8329f202))

### Digi-Key Stock Info

 - take stock from all packagings into account ([9376eac](https://github.com/horizon-eda/horizon/commit/9376eac80439efadfa5d4945940e7476d59c8997))
 - show currency on first search ([2364c31](https://github.com/horizon-eda/horizon/commit/2364c3150fe99c80407c9c9ad77a575799db5d47))

# Version 2.3.1

## Bugfixes

### Board Editor

 - Clearance checks: don't crash on unfilled planes ([418f15d](https://github.com/horizon-eda/horizon/commit/418f15d550621f098f1304e62013da5ace59debd))
 - prevent cursor from disappearing after updating planes ([c4a8411](https://github.com/horizon-eda/horizon/commit/c4a8411187c9d2404f05c99401ba8f1175230e07))

### Schematic Editor

 - Connectivity checks: don't crash if unplaced pin is not connected ([1cf64d0](https://github.com/horizon-eda/horizon/commit/1cf64d051e756c387f2bf657d923e1443699594f))

### Pool and proejct manager

 - don't crash when closing windows that don't have an open pool/project ([268b2f5](https://github.com/horizon-eda/horizon/commit/268b2f5df253f3d93cb57abdde834ad841ca8223))

# Version 2.3.0

## New features

### Schematic Editor

 - Net ties ([9eaad29](https://github.com/horizon-eda/horizon/commit/9eaad29ea0b5834c061d43ee52a2215bdead6beb))

### Board editor

 - Support connecting tracks to pads with offset ([21840a7](https://github.com/horizon-eda/horizon/commit/21840a725e6010098f8c3d6b17ad8dfe5c78a70b))
 - ODB++ output ([d84af5e](https://github.com/horizon-eda/horizon/commit/d84af5ed4dd0b25dcf2dd889365cf3e00c21dc5d))
 - Thermal relief spoke customisation ([c1a568f](https://github.com/horizon-eda/horizon/commit/c1a568fc514d58d7688eede7723a8634e5986ab2))
 - Thermal relief rules for overriding thermal style ([7e880dc](https://github.com/horizon-eda/horizon/commit/7e880dc091a5f429ec219b29c94f6a7b5d9bd24e))
 - Board connectivity check to check that all copper features of a net are connected ([42eba6a](https://github.com/horizon-eda/horizon/commit/42eba6acd31ec3322314633f98d974f7811b288c))

### Editors

 - Tools for cleaning up imported geometry ([9e5dec5](https://github.com/horizon-eda/horizon/commit/9e5dec528e00000655bf830a185392b152a57e98))
 - View at actual size action ([310f974](https://github.com/horizon-eda/horizon/commit/310f9749af17809ce66720052fd611edb45646a1))

### Pool manager

 - Individual directions for alternate pin names ([496129d](https://github.com/horizon-eda/horizon/commit/496129da3d1c7102605f37c155d5f115d577a334))

### 3D preview

 - Support 3D input devices via spacenav ([30951a4](https://github.com/horizon-eda/horizon/commit/30951a4d77827de90dc21317f33f227c2407b5c8))

## Enhancements

### Board Editor

 - Faster copper clearance checks ([2718b88](https://github.com/horizon-eda/horizon/commit/2718b88614eb1106e8acf2314ebcad2633508848))
 - Update planes without blocking the UI and show progress ([421e610](https://github.com/horizon-eda/horizon/commit/421e6103195dc1fc62fb1e933559cadf3f3f13a9), [5b490df](https://github.com/horizon-eda/horizon/commit/5b490dfe49fa3f8841018ea3d6979c1391ae997f), [deab5f2](https://github.com/horizon-eda/horizon/commit/deab5f22f5a93642350b856a36e2c3942159c901))
 - STEP export: export arcs in board outline as such ([9c3c740](https://github.com/horizon-eda/horizon/commit/9c3c740e5eff82cdd703b88bb3b3944b2556894c))
 - Rules: support matching multiple nets ([d2da4b6](https://github.com/horizon-eda/horizon/commit/d2da4b6d4e62c4c6c93a2507f1a42e4e272656f5))
 - Rules: support matching multiple components ([50ecfa8](https://github.com/horizon-eda/horizon/commit/50ecfa87fba67e810668aa54b5fce945ad69dac8))
 - Show layer in check results ([ac470c9](https://github.com/horizon-eda/horizon/commit/ac470c95daba4616917ce124b15ca979f761a810))
 - Edit plane: support picking net ([bac09fd](https://github.com/horizon-eda/horizon/commit/bac09fde8c033371fa5bc952964358314a1fc466))
 - Fab output window: show message when export is done ([1ace3c5](https://github.com/horizon-eda/horizon/commit/1ace3c5f461617e10d9c7f96f217be74131898c1))
 - STEP export: improved error reporting ([545ca3e](https://github.com/horizon-eda/horizon/commit/545ca3e5b05aa625b9426484135732f465b063f6))

### Editors
 
 - Rules: support cancelling checks ([9d96698](https://github.com/horizon-eda/horizon/commit/9d966988298868f25c61f9a3f2446974b3a72438), [8338a74](https://github.com/horizon-eda/horizon/commit/8338a746255f585e16a446168c9203304ae22217), [e22f1af](https://github.com/horizon-eda/horizon/commit/e22f1af537b0e5c3c0f4764c8518142203ffb58f))
 - Rules: support checking just a single rule ([90b24ac](https://github.com/horizon-eda/horizon/commit/90b24ace6635622adac144420850538cb543ceeb))
 - Rules: add option for only showing errors on work layer ([c5259b3](https://github.com/horizon-eda/horizon/commit/c5259b3c9dc173ba936de47163c7c3e2dd9acf07))
 - Rules: only show markers and error polygons for visible rows ([25e6838](https://github.com/horizon-eda/horizon/commit/25e6838be6c719178fc5b7a8af8d7a4f262e6c5d))
 - Reflow actions in tool bar if ther are too many ([b08b6fc](https://github.com/horizon-eda/horizon/commit/b08b6fcc4bfa0ee49377347de9412d4041a6b5a3))
 - Show tooltips on markers ([e3d999a](https://github.com/horizon-eda/horizon/commit/e3d999a1b0617a112fb93d8d65127dae3b400031))
 - Non-modal text editing ([2d0ac2f](https://github.com/horizon-eda/horizon/commit/2d0ac2fdd3efcf346cfd20124af0f16ccd2f34bc))
 - Support German umlauts in texts ([969d8d5](https://github.com/horizon-eda/horizon/commit/969d8d574cb2272b0de5154b3e24fe0348424155))
 - Rules: optimize layout ([2e6e510](https://github.com/horizon-eda/horizon/commit/2e6e510ffda57de2d3ffb368d76e71ee170f58f4), [1843c6a](https://github.com/horizon-eda/horizon/commit/1843c6a3d705dff8b3cd3d4b485910c9392ba5cf), [a29d84f](https://github.com/horizon-eda/horizon/commit/a29d84f0506a775bdc1f8d1f96295aacb4599c2f), [d457c78](https://github.com/horizon-eda/horizon/commit/d457c782a89e8d8435bb1237720c42242349c05c), [15ed61e](https://github.com/horizon-eda/horizon/commit/15ed61ebc39e36e8fa6bf0757b9c38f4cb4dd4b6), [3883361](https://github.com/horizon-eda/horizon/commit/38833610667d769a661a94c08eb34e2fb6bbdeb6))
 - Option for hiding pictures ([bbc4815](https://github.com/horizon-eda/horizon/commit/bbc48152bf60b9d8a70589806cbcac27ddb3afc2))

### 3D preview

 - Don't block while rendering layers ([e44d858](https://github.com/horizon-eda/horizon/commit/e44d858e9b781d7319333dce5ea53ac034b32751))
 - Improved touchpad and trackpoint navigation ([197620c](https://github.com/horizon-eda/horizon/commit/197620cddac104e6e5dcc1b64341114324374c41))
 - Animate transitions ([8360c01](https://github.com/horizon-eda/horizon/commit/8360c0133a0b39dd180b8d218a1ef41472e10075))
 - Toggle projection action ([0f7ef03](https://github.com/horizon-eda/horizon/commit/0f7ef03cfc7f3c0b20392041ac71b9d689fe19f9))

### Schematic editor

 - Draw net line tool: use correct bend mode when starting from power symbols ([8d5b13f](https://github.com/horizon-eda/horizon/commit/8d5b13f53c333464d8cbd0cb923d5ceed2253ece))
 - Place on board can place all components of a block ([c92eabd](https://github.com/horizon-eda/horizon/commit/c92eabd9ee0c75987ec3777b02a7dc9ab0423da7))
 - Automatically move junctions connected power symbols ([670d962](https://github.com/horizon-eda/horizon/commit/670d962de452708d362bfb79e19420161caecb39))
 - Schematic properties dialog is now separate from project properties ([1fc6fb6](https://github.com/horizon-eda/horizon/commit/1fc6fb68670c571813d48b37aad8a54e81b96139))
 - Show sheet in undo/redo popup ([c0a1a04](https://github.com/horizon-eda/horizon/commit/c0a1a042509e1e76e95b37b145d574ebeb20ef6e))
 - Place power symbol tool: open manage power nets dialog if there are none ([fd4872d](https://github.com/horizon-eda/horizon/commit/fd4872d37d945a481821243f726632a3157addf4))
 - More checks ([fa257a5](https://github.com/horizon-eda/horizon/commit/fa257a5d9129d2545adc408bae0a3584d697d262))
 - Warn about netlist/schematic connection mismatch ([7e0785e](https://github.com/horizon-eda/horizon/commit/7e0785ec5bfb6868edd168ab6245fb1a46b77792))

### Package editor

 - Show inner layers in 3D preview ([a7ad28f](https://github.com/horizon-eda/horizon/commit/a7ad28f78b79171647c9fea43412449dd80d1a7a))

### Padstack editor

 - Support setting hole position in parameter program ([dec4200](https://github.com/horizon-eda/horizon/commit/dec4200bcf36bc1dd6105dffdcafcf39a32749ae))

### Pool and project manager

 - Also show progress for first pool update by estimating number of files ([6e58cf4](https://github.com/horizon-eda/horizon/commit/6e58cf489cea31d8bbe15631a41ad4621ac745e2))
 - Automatically update pool if any item has changed after the last pool update ([1b691d1](https://github.com/horizon-eda/horizon/commit/1b691d141d28be18392742f41476335452be5f4b))

### Pool manager

 - Perform complete pool update when overwriting existing item ([bae8ce0](https://github.com/horizon-eda/horizon/commit/bae8ce00e62fd76e928a0db8a1f29dba3d6f3015))
 - KiCad symbol import: support s-expression symbols from KiCad 6 ([3d834e6](https://github.com/horizon-eda/horizon/commit/3d834e6ea63cbaa15799f06b683f96f32967d31f))
 - KiCad package import: support KiCad version 6 packages ([ee37598](https://github.com/horizon-eda/horizon/commit/ee37598b98da131f692d0792eb36f3a23addb270))
 - Add option for changing default frame/via ([4a6074d](https://github.com/horizon-eda/horizon/commit/4a6074d404bdeee1f75a1be7657e4750c54a617d), [1c6cee7](https://github.com/horizon-eda/horizon/commit/1c6cee73afbc8eb0e6d368549d3c72975540cc6d))

### Project manager

 - Show project's pools ([e9b326d](https://github.com/horizon-eda/horizon/commit/e9b326d2c0e00876404d55af9afb3f0fb1c25d90))
 - Show spinner while opening schematic/board ([09c6818](https://github.com/horizon-eda/horizon/commit/09c68186c4bf27cfead49f1d7c83785ade2e6650))
 - Remember author and base path when creating new project ([b897b0b](https://github.com/horizon-eda/horizon/commit/b897b0b0cdf461c75d0e813f1cfa7ec65772cba1))
 - Provide suggestion for project name based on title ([5923ca7](https://github.com/horizon-eda/horizon/commit/5923ca72bc45f2ee0d400f0f10d434dca94a9d7c))

### Symbol editor

 - Hide junctions and hidden text by default ([20c6ab9](https://github.com/horizon-eda/horizon/commit/20c6ab904fcebc5acca32f4c6fb283654bd5270d))

## Bugfixes

### General

 - Prevent logger from getting stuck under high load  ([10dcbc9](https://github.com/horizon-eda/horizon/commit/10dcbc9c3c70ed5b0b174f85e52e828f244b1279))

### Board editor

 - Router: handle pads with holes in them ([b6c0c8a](https://github.com/horizon-eda/horizon/commit/b6c0c8a901f424d5c50c1eea41962f278df0f95c))
 - Gerber export: don't write newline after aperture macro primitive ([1a3a6b6](https://github.com/horizon-eda/horizon/commit/1a3a6b6b6c8ef01ddd10f7697132a4349071e13e))
 - Gerber export: support polygons with arcs in padstacks ([0efe0ac](https://github.com/horizon-eda/horizon/commit/0efe0ac3f9da85b9b6235e3942380f5c001ed18a))
 - Update airwires after pasting via ([edcd404](https://github.com/horizon-eda/horizon/commit/edcd404dba144d7bc34439dda5c03f54cb158f2c))
 - Edit stackup: don't crash if there are airwires on deleted layers ([2cdc9b3](https://github.com/horizon-eda/horizon/commit/2cdc9b36e21cb7c453ab39cfe3062bb5fdc42f62))
 - Correctly handle zero-width lines in checks ([0e4597a](https://github.com/horizon-eda/horizon/commit/0e4597a494aa075799b4ce6521a880814d2ae775))

### Schematic editor

 - Move tool: automatically connect extra junctions ([172c0c4](https://github.com/horizon-eda/horizon/commit/172c0c4ec78f5ea6192ee4b0c1f5cc5da703c33e))
 - Correctly detect changes in project pool ([9290159](https://github.com/horizon-eda/horizon/commit/929015967a4c5c6d21d6a6641fc2864eab8d3ce8))
 - Connect power symbol placed on pin ([f87c896](https://github.com/horizon-eda/horizon/commit/f87c896f0897393d8f5b5220189ca956edbe6b42))

### Editors

 - Round off vertex tool: fix arc orientation for non-convex corners ([e21595d](https://github.com/horizon-eda/horizon/commit/e21595d0a3a103d3841eb546faa97e8347d39cd7))
 - Drag polygon edge tool: properly handle circles ([ec8b4d6](https://github.com/horizon-eda/horizon/commit/ec8b4d6df58338680d46d959f8247cbf41534dd6))
 - Don't try to warp cursor on wayland ([ab41b47](https://github.com/horizon-eda/horizon/commit/ab41b470a7f312f9766a8751660345000c0825e3))
 - More graceful behavior if a tool doesn't end if requested ([5066148](https://github.com/horizon-eda/horizon/commit/5066148c47d8d5924c43a6cf0fd950e603039000))
 - Properly escape net names in head-up display ([c7c38fc](https://github.com/horizon-eda/horizon/commit/c7c38fcda2246db8c8db6d732feed716687b13d5))
 - Align and distribute tool: properly handle texts ([ddb3120](https://github.com/horizon-eda/horizon/commit/ddb3120dcd328d50a56a61737b4a6d73966e1742))
 - Improve handling of non-ASCII characters when editing texts ([fa3318d](https://github.com/horizon-eda/horizon/commit/fa3318d04bc55c661795dfdf222654c6decec2f7))
 - Rules: prevent UI from locking up while checks are running ([db6d567](https://github.com/horizon-eda/horizon/commit/db6d5673b9d9b1a77670d14b525fb3fb89ad3c2d))
 - Rules: don't keep result rows expanded while checks are running ([7c98c01](https://github.com/horizon-eda/horizon/commit/7c98c01c94c497adb2c15c5903ee5739a55896e4))
 - Rules: compute cache once ([9052052](https://github.com/horizon-eda/horizon/commit/90520520992f852548d846fcc1801da101e7fd7b))

### Package editor

 - Footprint generator: ensure correct placement of entries with buggy librsvg ([282bdec](https://github.com/horizon-eda/horizon/commit/282bdec037f4e9865df02581d2ab204b15c177b1))

### Symbol editor

 - Support going to check errors ([9b8a9a5](https://github.com/horizon-eda/horizon/commit/9b8a9a5d8c9d79ce80245c95d835f68f8249d110))

### Pool/project manager

 - Correctly handle opening files form argv ([56b3f08](https://github.com/horizon-eda/horizon/commit/56b3f086c7799bbf0bb042e5bb9bc50004b7c5ee))
 - Correctly open directories in external file browser ([972cf17](https://github.com/horizon-eda/horizon/commit/972cf174bc03a59de127b1add98cc3be99169b7e))

### Project manager

 - Digi-Key stock info provider: properly escape text ([eb691cb](https://github.com/horizon-eda/horizon/commit/eb691cb52058ad65ebcbc6aa414d363a74c2482f))
 - Don't crash if a pool update happens on opening a project ([351bcd9](https://github.com/horizon-eda/horizon/commit/351bcd928e0a29bb2424a8fa0d7849e2376669a8))

## For packagers

 - Replace libzip dependency with libarchive ([06b7a64](https://github.com/horizon-eda/horizon/commit/06b7a64f8daed65a33a09478a37c4bb4f1170463))
 - New dependency libspnav, if your distribution doesn't include it, you can disable spacenav support by passing `WITH_SPNAV=0` to make

# Version 2.2.0

## New features

### Schematic Editor

 - Hierarchical schematics ([16b925a](https://github.com/horizon-eda/horizon/commit/16b925a3605fbac0f77c9b453131df6e3dda0ad0))
 - Exchange gates tool ([6df1b9f](https://github.com/horizon-eda/horizon/commit/6df1b9f9412099eb0673026cd8a7d3e603f5f638))

### Editors

 - Align & distribute tool ([30615c8](https://github.com/horizon-eda/horizon/commit/30615c8014407c8cac9f099e858cac1190cc32d2))
 - Show what's been undone/redone ([ecab1de](https://github.com/horizon-eda/horizon/commit/ecab1deea642c2f138b8a97a61c9e9fb27dbf604))
 - Dotted layer display mode ([1c4eea6](https://github.com/horizon-eda/horizon/commit/1c4eea61f590549ea29d801215f2e15fe532fa70) by [@rroohhh](https://github.com/rroohhh))

### Pool manager

 - Part: add prefix override ([c209c8a](https://github.com/horizon-eda/horizon/commit/c209c8a7206b84079956c753abf17f53a55a8793))

### Board editor

 - Shorted pads rule ([f57c1f5](https://github.com/horizon-eda/horizon/commit/f57c1f5bde600bdbb1ad48ce86a99de3adbd7ec2) by [@guserav](https://github.com/guserav))

## Enhancements

### General

 - Dark theme option in preferences ([b2bfa20](https://github.com/horizon-eda/horizon/commit/b2bfa20b3e6cad837906cf3aea2812e387b861e4))
 - Closing a project also closes the project's pool manager ([93e52cd](https://github.com/horizon-eda/horizon/commit/93e52cd01ce38c2aeadbc0c9b09cdba840963dcf))
 - EditorWindow: improve version update warning ([5578faa](https://github.com/horizon-eda/horizon/commit/5578faa4dcf33522e4f44d76e04b189943723eab))
 - Prevent using pools from other installations ([21133cd](https://github.com/horizon-eda/horizon/commit/21133cd3cf6ad9211b90b9e7a51b4a1c8fbde1df))
 - Pool browsers support sorting by modification time ([1491988](https://github.com/horizon-eda/horizon/commit/14919887743feef58abb7f01707fcec49bccf433))

### Security

 - Validate parametric column and table names to protect against SQL injections ([437000a](https://github.com/horizon-eda/horizon/commit/437000ad41b3276372d2cb855cde8e7c5b822869))
 - Authenticate inter-process communication ([42b8b79](https://github.com/horizon-eda/horizon/commit/42b8b79eacbfa0faa844816721e064b758722144))

### Editors

 - Drag polygon edge tool properly handles arc edges ([d2158ab](https://github.com/horizon-eda/horizon/commit/d2158ab7be097398da27b3a916537463f295382c))
 - Add 45 degree restrict to draw line & polygon tools ([b48a344](https://github.com/horizon-eda/horizon/commit/b48a3443468f1546539396d831c524e2202d5d2b) by [@kamtar](https://github.com/kamtar))
 - Slightly faster rendering ([987724c](https://github.com/horizon-eda/horizon/commit/987724c79949204b095990db0fae6349dabe1ac6), [fa2a6d4](https://github.com/horizon-eda/horizon/commit/fa2a6d4a206c40de4692b5263908f274278cdda8), [56358df](https://github.com/horizon-eda/horizon/commit/56358df96761f7a75aebef5854b4fb905167c253), [e776237](https://github.com/horizon-eda/horizon/commit/e77623774a5e2bc287a10a068e4a7e8f86ddc3ec))
 - Faster colored nets ([02edcc3](https://github.com/horizon-eda/horizon/commit/02edcc308d096721537df8d011b78c3b0f7a1fba) by [@rroohhh](https://github.com/rroohhh))
 - Make undo/redo depth configurable ([1f7a6e9](https://github.com/horizon-eda/horizon/commit/1f7a6e9aab40369df4a7084ec6812ac80088f1d4))
 - Show part in project pool manager action ([848f149](https://github.com/horizon-eda/horizon/commit/848f1495b7ab187ddf162fa4ddedf95103a05c34))
 - Go to project manager action ([7fdc1fa](https://github.com/horizon-eda/horizon/commit/7fdc1fa1d4f3c691c0b651a75ed42be13991a593))

### Schematic editor

 - Pressing escape in the part browser goes back to schematic ([49e0ae7](https://github.com/horizon-eda/horizon/commit/49e0ae7fac482adbcdd3ae93d75ea98049ad9595))

### Board Editor

 - Place package tool remembers flipped state ([9823b8d](https://github.com/horizon-eda/horizon/commit/9823b8dd28689f434a3ec4fbaffaa155e738f2f2))
 - Display keepouts in outline mode by default ([4f84530](https://github.com/horizon-eda/horizon/commit/4f84530afc7d24dad9dda3d51725d44a2cbe80d7))
 - Actually implement silkscreen/exposed copper clearance ([df003e5](https://github.com/horizon-eda/horizon/commit/df003e59f3a01d856eb079f5a2804882ac95983a) by [@guserav](https://github.com/guserav))

### Package editor

 - Footprint generator graphics matches light/dark theme ([d559b75](https://github.com/horizon-eda/horizon/commit/d559b754aeaeae49fd3c77629d8ee57ec3354896))


### Pool manager

 - Pool settings tab: prevent circular dependencies ([0fb3508](https://github.com/horizon-eda/horizon/commit/0fb3508207357f1e6a694b1d3b875c724bf25388), [83a198e](https://github.com/horizon-eda/horizon/commit/83a198eeaab009c868d1b78826e4e6e8cad1a5f7))
 - Prevent duplicate filenames ([45c7296](https://github.com/horizon-eda/horizon/commit/45c729616fc589b18af3a92a8ee873f96141e807))
 - Unit pool browser: store column widths ([b830ef9](https://github.com/horizon-eda/horizon/commit/b830ef970be819d8a01be9ce4d4269c45c5fff6f))


### Windows-specific

 - Correct version in executable metadata ([1bb2faf](https://github.com/horizon-eda/horizon/commit/1bb2faf517ea828d9202ee601dfc9877ba04a1e7))
 - All network operations use the system's certificate store ([6994969](https://github.com/horizon-eda/horizon/commit/6994969a25ac22395b7abf0dd0b29bf191b7c50c))

## Bugfixes

### Board editor

 - Store from rules option in planes ([ea54322](https://github.com/horizon-eda/horizon/commit/ea543228387eacbf5a0e079f5a011cf63f3af47c))
 - Edit stackup dialog: don't crash on certain interactions ([e7f2d30](https://github.com/horizon-eda/horizon/commit/e7f2d300223f4459b55d7a7d0391ea018c92f561))
 - Fix 3D models not being found in some cases ([584e972](https://github.com/horizon-eda/horizon/commit/584e9721becf4fa3933f864bcded1d30de4c72fd))
 - PartsWindow: don't show unpopulated parts ([f5b0c8a](https://github.com/horizon-eda/horizon/commit/f5b0c8a4f9b3440edbba1c4d8c4d80eeaa6bd2b6))
 - STEP export: don't crash if there are no holes ([81d0fb8](https://github.com/horizon-eda/horizon/commit/81d0fb83c740dd0812e132f334969640d58ff097))
 - Handle invalid projects in panelization more gracefully ([c826026](https://github.com/horizon-eda/horizon/commit/c8260262218d99a1a7b2d7d9458aabb74fd1b84a))
 - 3D preview: correctly render silkscreen over tented vias ([3f20f51](https://github.com/horizon-eda/horizon/commit/3f20f510636196a99ea177c6a7abd956f580fa95) by [@frmdstryr](https://github.com/frmdstryr))
 - Don't display notes layer by default ([702a510](https://github.com/horizon-eda/horizon/commit/702a510042ea324c432388a41d362c2d13ee5e1e))
 - Copy placement tool: properly handle flipped packages ([3b7ce85](https://github.com/horizon-eda/horizon/commit/3b7ce85ecf6917bd6dd592dc7e2b28fe67a94703))
 - Don't crash if net used in plane is gone ([4a389f0](https://github.com/horizon-eda/horizon/commit/4a389f0eaefbb7b375f112dc6b71c26a0026caac))
 - Update selection when reloading netlist ([ed241bd](https://github.com/horizon-eda/horizon/commit/ed241bd0eb46e0189113ebfa5d2c4ed372395eae))
 - Fix crash when opening 3D view after selecting an alternate package ([d171ca6](https://github.com/horizon-eda/horizon/commit/d171ca6d0f045c0fead4ec8000187f9839007fc6))
 - Fix crash in PDF export when exporting certain arcs ([ff47cbb](https://github.com/horizon-eda/horizon/commit/ff47cbb3d385141433111696b0cef75366fcc696))

### Schematic editor

 - Copy/paste: keep NC pins ([f9d6774](https://github.com/horizon-eda/horizon/commit/f9d67741fca37077ff3182915e924a23e6dec035))


### Editors

 - Don't break undo/redo when a tool crashes ([465edcc](https://github.com/horizon-eda/horizon/commit/465edcc0bf5eaf1be0a02db44a24c58bdd36f697))
 - Don't clear selection after tool in hover select mode ([8d9f62a](https://github.com/horizon-eda/horizon/commit/8d9f62abbd90ca3a8a9b440eafb25f289ae1b5df))
 - Rule export: check for filename ending in .json ([67a1513](https://github.com/horizon-eda/horizon/commit/67a15138c61d25b34b2f5d75c6621cd382899d14))
 - Measure tool: don't require cursor movement ([2d03580](https://github.com/horizon-eda/horizon/commit/2d03580e0548543fd9b780cda284ee5cdd757de2))
 - Correctly rotate mirrored text ([536ea35](https://github.com/horizon-eda/horizon/commit/536ea3525529ba898b3622b3fae07bb798c8b2b1))
 - Really use tabular figures in view hints ([b79bbbe](https://github.com/horizon-eda/horizon/commit/b79bbbe31260ead2eae7367070ab8538872314d2))


### Pool manager

 - Pools window: update pool if needed before using it ([6c47b05](https://github.com/horizon-eda/horizon/commit/6c47b05efe05328a1d4fc9486c4cfc8985a3b458))
 - Fix KiCad symbol import on Windows by treating coordinates as signed ([5677df4](https://github.com/horizon-eda/horizon/commit/5677df46b33a2476c4271ba886552a73f2c98c18))
 - Entity pool browser: add tooltip to name column ([a70fdd7](https://github.com/horizon-eda/horizon/commit/a70fdd74b5b7bd56697b83fc34cd5fd9da3c3fa3))
 - Pools window: don't crash if pool is not compatible ([a940f03](https://github.com/horizon-eda/horizon/commit/a940f0310ed38d93883fdf6e33125bba21f14261))
 - Part wizard: validate entity filename ([e52e0c2](https://github.com/horizon-eda/horizon/commit/e52e0c287cf7e05a7bbfc7ab4fc8dada558b99a9))
 - Move to other pool window: really check if filenames end in .json ([1626787](https://github.com/horizon-eda/horizon/commit/162678740c0f10dabb11b9a5d61cb65945bc7209))
 - Move to other pool window: show names instead of UUIDs and make it work for items other than parts ([e5582ed](https://github.com/horizon-eda/horizon/commit/e5582edf9a6040cfac53122b9c2b577d21cbdbd5))
 - Symbol pool browser: correctly store treeview column widths ([3ca8b80](https://github.com/horizon-eda/horizon/commit/3ca8b80f447ff0b301c967bc7729470b1c5ad1ca))
 - Show item status tooltip also if there's a row tooltip ([b6e6045](https://github.com/horizon-eda/horizon/commit/b6e60451c809172818d2397cf31ffb7a5db04a73))


### Project manager

 - Don't crash if included pool isn't usable ([362b7ca](https://github.com/horizon-eda/horizon/commit/362b7cad1e348072770481feaaa857af6e4a46db))

### Windows-specific

 - Avoid crashes when network drives are inaccessible ([d44f402](https://github.com/horizon-eda/horizon/commit/d44f402efe9e4f3a7e626805598a67858dd4751b))

# Version 2.1.0

## New features

### Editors

 - Add support for saving and recalling grids ([52fb1fc](https://github.com/horizon-eda/horizon/commit/52fb1fc563c8cf6cc5b961eefdaff2a0c24cf958))
 - Add option for upside-down text ([76d7cec](https://github.com/horizon-eda/horizon/commit/76d7cec6a5d1b7332d9c05e2a28b3e5fbc6d5c12))
 - Show popup with available key sequences ([8d9ac5f](https://github.com/horizon-eda/horizon/commit/8d9ac5f415f96e9ceac6e72b14aeb5143f029ec9))
 - Show spacebar menu hint in status bar ([aaa3d63](https://github.com/horizon-eda/horizon/commit/aaa3d63a315dba6cc5e7757977015022308fbbab))

### 3D preview

 - Support for keyboard shortcuts ([54d3eb1](https://github.com/horizon-eda/horizon/commit/54d3eb17e8c9857c71958a6ab7b2ceaaaafebd3b))

## Enhancements

### Project manager

 - Add option for fixing gitignore ([88f3d2a](https://github.com/horizon-eda/horizon/commit/88f3d2a119be517958253c0fd18128894bfe6d91))
 - Duplicate window: only duplicate if all filenames are valid ([064dd87](https://github.com/horizon-eda/horizon/commit/064dd877c4f6a45241d20bdafa1fa9f6dd00db6b))
 - LocationEntry: automatically append .json from file chooser if needed ([31ee359](https://github.com/horizon-eda/horizon/commit/31ee35911e751ac679692d83f56a8834866ffb5a))

### Board editor

 - Add checks for plane fill order assignment ([39f937a](https://github.com/horizon-eda/horizon/commit/39f937a7e7b11a6b6c25f46f7b072743de498233), [644e2c8](https://github.com/horizon-eda/horizon/commit/644e2c8d8d5f1e79015636f706a9c05c4fc573ea), [cf0f435](https://github.com/horizon-eda/horizon/commit/cf0f4352e5c364967123567c2c95c4a19061450c))
 - Include plane in polygon display name ([ce2aa0e](https://github.com/horizon-eda/horizon/commit/ce2aa0ee704403e525012fa31d8211282cc46d75))
 - Improved appearance of composite pads (such as rounded rectangle) ([782917a](https://github.com/horizon-eda/horizon/commit/782917a25a0e08831ab6c044d38879c874b039c7))
 - New tool: set track width ([69f8791](https://github.com/horizon-eda/horizon/commit/69f8791dae9f8436b922f3b5ef274d41e288c4ed))
 - Show track spacing in HUD ([6ac5172](https://github.com/horizon-eda/horizon/commit/6ac517257df007787715b7c8a66d87d092196a98))
 - Automatically create top/bottom layer pair for new boards ([7c54653](https://github.com/horizon-eda/horizon/commit/7c54653cc70ea0e65991a819ceeb3b90fb68bccb))
 - Enter datum tool supports tracks ([8366cf1](https://github.com/horizon-eda/horizon/commit/8366cf1dbe9d6ffafe0200e6d0e87607453eb415))
 - Rules check: show layer for copper clearance violation ([f868a42](https://github.com/horizon-eda/horizon/commit/f868a42b589b9c992bbf81b2c79d69e9a013cb53))
 - Rules check: don't check non-copper layers of plated holes ([6e9b081](https://github.com/horizon-eda/horizon/commit/6e9b08177e46258b4ccb5f1833e7c6e2de8fa4cc))

### Editors

 - Draw line rectangle tool remembers mode ([87f42f9](https://github.com/horizon-eda/horizon/commit/87f42f9d33eba19a178844f6ebcdbd3219fcd441))
 - Use arcs for polygons when exporting to pdf (#609) ([09e0e85](https://github.com/horizon-eda/horizon/commit/09e0e854d730a0f8dff635681139fd3f981bca9c))
 - Improved arc selection ([31013c2](https://github.com/horizon-eda/horizon/commit/31013c2535c4fecc12d7405496344c4f8e5dddfa))
 - DXF import: support circles ([f07b2c6](https://github.com/horizon-eda/horizon/commit/f07b2c6758fb768af9dfda17bd1713581cc4cc7f))
 - Show deltas in HUD when various items are selected ([60a0b16](https://github.com/horizon-eda/horizon/commit/60a0b169f1f84a1c92a7348bb8661eabcb948358))
 - Draw arc tool: add set center, radius, angles mode ([6fc2160](https://github.com/horizon-eda/horizon/commit/6fc2160e296a2826e8e649d01bcd54fe51f16521))

### Schematic editor

 - Place bus ripper tool: sort members by bus ripper count ([f75da40](https://github.com/horizon-eda/horizon/commit/f75da40176c1170b6bb32723c76a27dac38af6ea))
 - Manage buses tool: remember sequence settings ([0d43d3a](https://github.com/horizon-eda/horizon/commit/0d43d3a94827ab4261aa407398d18d325d9d733a))
 - Duplicate net name warning now is case insensitive ([993ca88](https://github.com/horizon-eda/horizon/commit/993ca885f004a1aa166d8bb804069f7838d27fe5))

### Package editor

 - Set default corner radius in dual inline footprint generator ([10acf4d](https://github.com/horizon-eda/horizon/commit/10acf4d3db5ebcc675218475389e4984b30ee15f))

## Bugfixes

### Board editor

 - Make sure warnings don't end up in gerber files ([91ad430](https://github.com/horizon-eda/horizon/commit/91ad4308574db68e803aa6c4670037f06e375658), [3865ea7](https://github.com/horizon-eda/horizon/commit/3865ea73237ef75083b9f7d8cb894e16485702cb))
 - Don't crash when rendering panels ([623ff02](https://github.com/horizon-eda/horizon/commit/623ff023fa757ee89b7b89cad9add15ff6a763bb))
 - Only show "Smash package outline" tool if package has an outline ([6b867b7](https://github.com/horizon-eda/horizon/commit/6b867b7f7371a7188e6e7ff99fbdcdccc30b34bc))
 - Update junction layers when mirroring ([a7e023d](https://github.com/horizon-eda/horizon/commit/a7e023d791d4f03eb5df4483e3abf67e549ffb02))
 - Interactive router: remove airwires connected to deleted junction ([6fa6252](https://github.com/horizon-eda/horizon/commit/6fa6252242c6e83192df292f23f1ee18ebf5a19d))

### Editors

 - Fix integer truncation errors in PDF export ([fbf7305](https://github.com/horizon-eda/horizon/commit/fbf73054d99809259699905311cb1c33ef752f61))
 - Enter datum tool: don't begin with empty selection ([056e4e3](https://github.com/horizon-eda/horizon/commit/056e4e3a3bb77410c7a8bc456b6d1e03fa3a50bc))
 - Enter datum tool: enable set line length relative to junction ([df14f3b](https://github.com/horizon-eda/horizon/commit/df14f3b3db61f6d85385c434621e112266fa8ec3))

### Project pools

 - Always use forward slashes in 3d model paths ([3d29746](https://github.com/horizon-eda/horizon/commit/3d297464ebca0fb899f427ad040dfb15bbdda0cd))

# Version 2.0.0

## New features

### Project pools

 - Support recursively included pools ([e7922eb](https://github.com/horizon-eda/horizon/commit/e7922ebed3a8aa2d18db4be070f4632c57ff0ff7))
 - Add project pools ([702b9e6](https://github.com/horizon-eda/horizon/commit/702b9e6154defbe87a9853875c5caf7b64285a2f))
 - Add pools window ([0a9e467](https://github.com/horizon-eda/horizon/commit/0a9e46795068f1b908b258d6c955be5c76fc55dc))
 - Pool manager settings tab: support reordering pools ([b284194](https://github.com/horizon-eda/horizon/commit/b28419470006465335c2fd980861dfebfaad01b9))
 - Pool manager settings tab: show all included pools ([0699f0c](https://github.com/horizon-eda/horizon/commit/0699f0c66870fad1fadda19c27646da861a523ee))
 - Show show project title in project pool manager ([4e4b522](https://github.com/horizon-eda/horizon/commit/4e4b52226a74c05c9415e5c457baf2893dabfae3))
 - Pool browsers: add pool filter ([15fd49f](https://github.com/horizon-eda/horizon/commit/15fd49f23a011792e7111bcd1ae52f9502606288))
 - Automatically update project pool if included pools were updated ([a8301ff](https://github.com/horizon-eda/horizon/commit/a8301ffbd41f3ecdf938e2223b19178db6e07f55))
 - Item duplication window handles duplicating items from included pool ([1d74fb0](https://github.com/horizon-eda/horizon/commit/1d74fb0a165fb1354b4aabeb6b5d4ddcc01e481d), [04be26b](https://github.com/horizon-eda/horizon/commit/04be26bf5f1637a237541659a1fd4217339ca916), [5241f57](https://github.com/horizon-eda/horizon/commit/5241f57081bb4c316a3e93e93d77ad023d7dcfb8))
 - Migrate legacy cache-based projects to project pools ([6736135](https://github.com/horizon-eda/horizon/commit/6736135f2f1101d5c2df13913fcfb1ab6d33c31d))
 - Pool manager: support incrementally updating items from included pools ([cb31616](https://github.com/horizon-eda/horizon/commit/cb31616c142f4df4260b80f5cb9a6d1172eaf433), [bc0bf03](https://github.com/horizon-eda/horizon/commit/bc0bf03fc6e44dde1f1546fe939f29641c241183))
 - Project pool cache tab: update multiple items at once ([0606c74](https://github.com/horizon-eda/horizon/commit/0606c742cce9d4dded71ff93a7e24b6425e5f50a))
 - Correctly handle included pools for download and merge operations ([961d7f2](https://github.com/horizon-eda/horizon/commit/961d7f2a07a7fe4d329e185169b6852fbd3db9d6))

### 3D preview

 - Add 3D model alignment ([7ac5480](https://github.com/horizon-eda/horizon/commit/7ac5480ebfc7684272d7f8c3183d362a71eef611))
 - Add 3D model projection ([7a6586f](https://github.com/horizon-eda/horizon/commit/7a6586f211b86743fb06379cf5cab4abf5bcf235))
 - Add button for centering 3D models ([bebc51f](https://github.com/horizon-eda/horizon/commit/bebc51f074e364acf94b4eecdcc60848cec0a723))
 - Clicking on a model selects it ([14a72de](https://github.com/horizon-eda/horizon/commit/14a72de8e991a70b62056739f902dd1bd68e2203))

### Schematic editor

 - Add custom value to symbols ([4404dcf](https://github.com/horizon-eda/horizon/commit/4404dcf6c9bb4f56b82bab1e72b150006ab2328d))

### Editors

 - Show tool icon near cursor ([02c56cc](https://github.com/horizon-eda/horizon/commit/02c56ccb84cd4c2c0ad7e8c42041a5e646995953))
 - Use tilde in texts to draw an overbar ([1d43914](https://github.com/horizon-eda/horizon/commit/1d43914e520c79e3ea54b353ddd4dbbcc8539299), [01a995b](https://github.com/horizon-eda/horizon/commit/01a995b30b93755036d5159470fe5fc46e2c9855))

### Pool manager

 - Add part flags for excluding from BOM or pick and place export or specifying that the part is a base part ([e2c1442](https://github.com/horizon-eda/horizon/commit/e2c14429d49897e13dd6edbbf7b503ec551495b1))

### Part browser

 - Add Digi-Key API stock info provider ([d437f87](https://github.com/horizon-eda/horizon/commit/d437f87e1356f7e4f6c9f76cde4d40b07e461965), [979a41a](https://github.com/horizon-eda/horizon/commit/979a41a08ff3df28ff47abb5be23482b1c431cfd), [d25ea85](https://github.com/horizon-eda/horizon/commit/d25ea85f6d2bd58ede39cda61a0c77074bda5bbc), [6bfb98a](https://github.com/horizon-eda/horizon/commit/6bfb98a9c52294b297c29e75527884aed6698abe))
 - Filter by base part flag ([a1b2cfe](https://github.com/horizon-eda/horizon/commit/a1b2cfe4cfb49a5ac62a33aec95947ea62292022))


### Symbol editor

 - Place dot tool for placing junctions ([a1c776c](https://github.com/horizon-eda/horizon/commit/a1c776c0a627fae0c17ec71f9a0edfc771191aeb))
 
### Board editor

 - Rules: add net class regex matching ([f2e83ac](https://github.com/horizon-eda/horizon/commit/f2e83ac5c5e80ef598cdaea02bb61b32df0a75b9))


## Enhancements

### Editors

 - Show layer colors in property panel and rule editors ([eeeb2d7](https://github.com/horizon-eda/horizon/commit/eeeb2d762ad864053402b2149f6f976b5f274c7e), [ef09509](https://github.com/horizon-eda/horizon/commit/ef09509a679626343afbbed9d29a7b98f085afc4))
 - Make apply all button in property panel smaller ([9a24e5e](https://github.com/horizon-eda/horizon/commit/9a24e5eac4c32f84ca89537df25156681624c642))
 - Add option for zooming to cursor using keyboard ([89c3e67](https://github.com/horizon-eda/horizon/commit/89c3e67fc268e9a333b9a505be2d0fb46dd57bb9))
 - Smooth keyboard zooming as well ([dfd9ab8](https://github.com/horizon-eda/horizon/commit/dfd9ab82ebb06f80dc451789ba0f3d8f83f07d4d))
 - Add option for disabling drag-to-move ([3ac2d4e](https://github.com/horizon-eda/horizon/commit/3ac2d4e32ffdc1ee152a5e69410e3e823ee10f1d))
 - Head up display shows polygon vertex position ([1ab69c4](https://github.com/horizon-eda/horizon/commit/1ab69c4e2bc916efe299ecde9fd1f960a4d0d99e))
 - Rotate arbitrary / scale tool now handles pictures ([dc7526b](https://github.com/horizon-eda/horizon/commit/dc7526ba1b4e97be0b06b1c6bb046c443380b6e8))
 - Add set increment context menu to all dimension entries ([058c2c7](https://github.com/horizon-eda/horizon/commit/058c2c7854aab38948736754061afd23d6908e53))
 - Only use multiline text editor in property panel if needed ([d51f606](https://github.com/horizon-eda/horizon/commit/d51f606438157746797715076751477d7c7e02f4))
 - Hide Layer editor in property panel if there's only one layer ([e1ad213](https://github.com/horizon-eda/horizon/commit/e1ad2133302a11d4f9f66d2013d43f23759faf1e))
 - PDF export includes pictures ([a45916b](https://github.com/horizon-eda/horizon/commit/a45916bfab65e57e276ed6df219a922c170a1508))
 - Improve picture appearance by using mipmaps ([f26360d](https://github.com/horizon-eda/horizon/commit/f26360d08143b16d8b9393adcec673a977378927))
 - Head up display shows more descriptive names for unnamed nets ([1342214](https://github.com/horizon-eda/horizon/commit/13422141bf89eeee6d07d9ac0fc6e9b302e43ef1))
 - Always focus search entry in pool browsers ([51f347d](https://github.com/horizon-eda/horizon/commit/51f347dab2554b4c087ad38ab0e76229124bf628))


### Schematic editor

 - Add part/map symbol tool: remember unit to symbol mapping ([6bbfb8c](https://github.com/horizon-eda/horizon/commit/6bbfb8c820a6c9bdf407416c6c7a056c487aaae9), [30975bd](https://github.com/horizon-eda/horizon/commit/30975bd3055c2b986b14ab8fa426aa03057f1537))
 - Add next/previous sheet action ([c2f0bce](https://github.com/horizon-eda/horizon/commit/c2f0bcec3095083b74ab1ad9548bb3241ee44781))
 - Switch sheets using navigation buttons ([6c58a4f](https://github.com/horizon-eda/horizon/commit/6c58a4f99a8d3243379a04e46e43fefc437aee0e))
 - Keep name on dangling net segments when placing a bipole on a net line ([84308bc](https://github.com/horizon-eda/horizon/commit/84308bc5c396986c418cabc4af8fb0b4165a0711))
 - Preserve unconnected nets during copy/paste ([78d6780](https://github.com/horizon-eda/horizon/commit/78d6780151b94025d9f1622fc22b12f77397fbc1))
 - Moving a junction onto a pin connects it ([3103905](https://github.com/horizon-eda/horizon/commit/3103905cc2d040e9ac96474436e92ce752008a5a))
 - Moving a symbol automatically moves connected lines and junctions ([b8ce4f0](https://github.com/horizon-eda/horizon/commit/b8ce4f0e5ed870c4acbe4405e1ef58795dc92707))


### Board editor

 - Explain plane priority ([a354614](https://github.com/horizon-eda/horizon/commit/a354614f488342e435964fdeb884b5024e213798))
 - STEP export now is significantly faster ([7e0c460](https://github.com/horizon-eda/horizon/commit/7e0c46026365e0488c3ef11108a2843cb8c58f8e))
 - Add via position properties ([4f00674](https://github.com/horizon-eda/horizon/commit/4f00674dd68cc48907828f84600c6571eadb9a18))
 - Nets window: focus search entry when showing it ([04a4c4c](https://github.com/horizon-eda/horizon/commit/04a4c4c3eaac71bb97d2392e57299fea4621bf60))
 - Explain routing offset ([e7fef83](https://github.com/horizon-eda/horizon/commit/e7fef83f5ce223f92bc129039b647d7024bc7271))
 - Cursor snaps to board holes ([0b3c2af](https://github.com/horizon-eda/horizon/commit/0b3c2afb9d7890a11d8dc6bf635eb6f9d5acf636))


### Symbol editor

 - Warn about setting text placements if the symbol has more than 4 pins ([f421c9b](https://github.com/horizon-eda/horizon/commit/f421c9b19223bd140156eac8f8f46bf5ae192277))

### Pool manager

 - Improve sizing for smaller window widths ([2f07c91](https://github.com/horizon-eda/horizon/commit/2f07c91f89d1afee0af1eb527cb09b25d42f9197))
 - Persistently store positions of tree views and panes ([7201d65](https://github.com/horizon-eda/horizon/commit/7201d6512cb8d418f71f1398e5001f4db3c3c000), [bbc2df4](https://github.com/horizon-eda/horizon/commit/bbc2df4195e384d9c25b810b9348431c1d767378), [f6fac84](https://github.com/horizon-eda/horizon/commit/f6fac84da0793f6d8b449d8d2f5503073c4cbeb0))
 - Remote tab: show number of items to be merged ([f14240e](https://github.com/horizon-eda/horizon/commit/f14240e6a11e0eb2227478457b7b1a85ac851188))
 - Remote tab: show check result ([a786965](https://github.com/horizon-eda/horizon/commit/a78696539ee416ed8ce9325985634cfca90aaebe))
 - Git tab: show check result ([7397a0f](https://github.com/horizon-eda/horizon/commit/7397a0ffb31b8cc67f261563773c3d2e9b2d52d7))
 - Part wizard: show package preview ([18e1299](https://github.com/horizon-eda/horizon/commit/18e1299469a80a8e48900a276d13ce0a3119bc42))
 - Add button for KiCad package import ([8cbd93c](https://github.com/horizon-eda/horizon/commit/8cbd93cefe1a006200e4ec53daf3305fcfbc2e57))
 - Settings tab: double click to open pool ([b86c920](https://github.com/horizon-eda/horizon/commit/b86c9209ad1e435e8037ee71d39ab5d958d48c7f))
 - Add open in included pool context menu item ([1e9a474](https://github.com/horizon-eda/horizon/commit/1e9a4746f5609c867dfc06a674a6f0e90b1a6824))
 - Automatically run update if editing included item ([4be36a8](https://github.com/horizon-eda/horizon/commit/4be36a8c74c8d0d77f35a4e90df6a96f2eeb708e))
 - Add 'move to other pool' context menu ([13f4efb](https://github.com/horizon-eda/horizon/commit/13f4efbc9c6131f792493b7f422aaaccb6c05644))

### Pool/project manager

 - Log errors during forced pool update ([12a5b70](https://github.com/horizon-eda/horizon/commit/12a5b70ef8cbdd124ef13cdad0e2dc471137a7c2))

### Project manager

 - Create `.gitignore` when creating project ([d5a6e1e](https://github.com/horizon-eda/horizon/commit/d5a6e1ed1777110c0e6704bf61587bcb5c43201f))
 - Don't create pictures directory, it'll be created as needed ([dde3e6a](https://github.com/horizon-eda/horizon/commit/dde3e6a6d6c165649feda95ec23c62ce78ffb0f5))
 - Reload part browser after pool update ([1921c81](https://github.com/horizon-eda/horizon/commit/1921c816f14add2d2af14069995991c3f4cd6d58))

### Package editor

 - Improve performance of 3D model placement adjustments ([dfb6686](https://github.com/horizon-eda/horizon/commit/dfb6686ad9f7a85006f5f43d3f3d1e005e929eb8))
 - Show overlay for mechanical pads ([35ea40b](https://github.com/horizon-eda/horizon/commit/35ea40b3586cc16c0e85b4d0df10a7602c33e798))
 - Change default polygon rectangle decoration size to be in line with pool convention ([4860ae6](https://github.com/horizon-eda/horizon/commit/4860ae683b174db5494d3ec6c6051ce2e354f978))

### 3D Preview

 - Support cursor warping ([4da5e2a](https://github.com/horizon-eda/horizon/commit/4da5e2ab02c9b76fff0b11116fb16e3f18566e34))
 - Add option for hiding copper ([e4a8876](https://github.com/horizon-eda/horizon/commit/e4a88760630322abf1b7f442edc55948029a0459))
 - Add axes arrows ([f2eb902](https://github.com/horizon-eda/horizon/commit/f2eb902efc02dacc9993c36737b182b726cfa78a))
 - Add option for changing silkscreen color ([f126381](https://github.com/horizon-eda/horizon/commit/f126381c22287934f1fbf9a3c86dc5c6de263fab))

### For packagers

 - There now are manpages, use `install-man` for installing ([3e436b4](https://github.com/horizon-eda/horizon/commit/3e436b46c553d558c0dab84068f09c98f93170d1))

## Bugfixes

### Editors

 - Only select line if there are zero points under the cursor ([c143881](https://github.com/horizon-eda/horizon/commit/c143881c8b6334fe7fce2417ebd1e8b262fb6536))
 - Avoid "pool has changed message" after some tools ([c5b6f5f](https://github.com/horizon-eda/horizon/commit/c5b6f5ff39f1543432d174dfd65c0c19514de54d))
 - Update cross probe selection when in tool ([ed479ac](https://github.com/horizon-eda/horizon/commit/ed479ac02b7c5d1c705f7eb5a740d8c9a7feb707))
 - Update colors in layer box when adding layers ([209f879](https://github.com/horizon-eda/horizon/commit/209f8791c40da4ccdf829ad3868623d67500e175))
 - Always redraw when changing canvas scale/offset ([edfe7ed](https://github.com/horizon-eda/horizon/commit/edfe7ed75de62c20f83597c671b7a15fd6391978))
 - Wrap text version info bar ([087ce70](https://github.com/horizon-eda/horizon/commit/087ce70cc2edd4ba906351211943cebcb0f40232))
 - Make enter key work in integer property editors ([31f296d](https://github.com/horizon-eda/horizon/commit/31f296de5a913d030671de5d4a53b27f3960159a))
 - Store "on top" state of pictures ([86c32cb](https://github.com/horizon-eda/horizon/commit/86c32cb5932a92d51db7b38e9efd47e129d7eb75))
 - Store opacity of pictures ([7924664](https://github.com/horizon-eda/horizon/commit/7924664cc0622bef179315ccb891aca14777c8f7))
 - Keep pictures on pool reload in board an schematic ([5f38371](https://github.com/horizon-eda/horizon/commit/5f38371195a1506f41ff4e2b97a7b55222068d5c))
 - Interactive router: handle overriding routing offset for all clearances ([bf209fe](https://github.com/horizon-eda/horizon/commit/bf209fe984e63c23219f6f777d298713c9bdb30c))
 - Paste tool: properly handle via nets ([5a6826f](https://github.com/horizon-eda/horizon/commit/5a6826f6ea29eacb08937691488b107866775708))
 - Proplerly preserve semitransparent area in pictures ([2ad75b1](https://github.com/horizon-eda/horizon/commit/2ad75b1fd6847a35ccdb13a7a0975b983698078e))
 - Catch errors while loading/saving pictures ([1febfd3](https://github.com/horizon-eda/horizon/commit/1febfd3357e3bce53e06048af8d2deb0630adba0))


### Schematic editor

 - Don't crash when reloading pool if there are specific parts set ([ebbda39](https://github.com/horizon-eda/horizon/commit/ebbda390842947d445f062cec9034e5a395330f4))
 - Only swap gates of selected component ([6c60078](https://github.com/horizon-eda/horizon/commit/6c60078f03c4eb3d86603d28f85cf3da3a1be945))
 - Don't render junctions connected to lines/arcs ([9621e73](https://github.com/horizon-eda/horizon/commit/9621e73ee0b0f96e6756b9575b01f14e965fb328))
 - Fix memory corruption when placing a bipole on a net line ([d97b4c6](https://github.com/horizon-eda/horizon/commit/d97b4c66c4722f3cac75a7c7b5a9074aa1fc1e64))
 - Only set modified flag if sheet name was changed ([d65101c](https://github.com/horizon-eda/horizon/commit/d65101c9b9702af18553e9b3cbd2bab78c37f8dd))


### Board editor

 - Pick&place export: don't use custom dimension format if not using custom format ([721bfba](https://github.com/horizon-eda/horizon/commit/721bfba4c32c9a863c806cf195e6120722580d2a))
 - Diffpair router: don't crash when routing unconnected pin ([57fbd19](https://github.com/horizon-eda/horizon/commit/57fbd193d23d110b78a00663d0f8067f1fdaf9b5))
 - Account for outline on parts when calculating bbox. ([67a842b](https://github.com/horizon-eda/horizon/commit/67a842b0a425fbc343004280fb8d765e4bd58766))
 - Fix draw connection line on pins on package origin. ([25a8688](https://github.com/horizon-eda/horizon/commit/25a868855c962d528adc74749dfcd3e7814a06b6))
 - STEP export: don't export non-populated models ([db49f75](https://github.com/horizon-eda/horizon/commit/db49f75dbfc070c72e35daec2301e3f6fdd86d8d))
 - Fix arcs in decals ([fb422c9](https://github.com/horizon-eda/horizon/commit/fb422c979dc70c53643c1962700d950c136485d8))
 - Save layer pair rules ([ce726d8](https://github.com/horizon-eda/horizon/commit/ce726d83a8ecee22e8904a6585800e33bae8d236))
 - Holes automatically receive all required parameters ([5890dbe](https://github.com/horizon-eda/horizon/commit/5890dbe45b5eeb74d00b4f0c5a5ce07e7d6c8cdd))
 - New planes use settings from rules ([2885d96](https://github.com/horizon-eda/horizon/commit/2885d961a176840f2be4e59e4312085d94080951))

### Package editor

 - Rules: honor enabled flag ([19869bc](https://github.com/horizon-eda/horizon/commit/19869bc7d595aae6b4ebc46bb761ae6bfb41adea))
 - Don't crash when a pad has no name ([bce1922](https://github.com/horizon-eda/horizon/commit/bce19221b5ddf19e1b6a9a1554f1e745426507c1))

### Pool manager

 - Git tab: don't add ignored items ([406c8e4](https://github.com/horizon-eda/horizon/commit/406c8e4018adbe3a24b63da0d8ce61aa21a2b9ca))
 - Remote tab: fix updating pull requests ([7ccfaaa](https://github.com/horizon-eda/horizon/commit/7ccfaaafec6a81d5c95b45c0b1783b05450ca0cd))
 - Remote tab: include symbols when adding items ([09df02e](https://github.com/horizon-eda/horizon/commit/09df02e0357dd2d87c797cce21d2dbf0f836e4f0))
 - Remote tab: validate user-provided signature ([0dd63b4](https://github.com/horizon-eda/horizon/commit/0dd63b4d4e90b048b76000318ea58ad93d4cce1f))
 - Don't try to save read-only documents ([9e16a7d](https://github.com/horizon-eda/horizon/commit/9e16a7d2915a87ed38974f84783ea138331fe25f))
 - Git tab: make "add with dependencies" work as intended ([0e7cd62](https://github.com/horizon-eda/horizon/commit/0e7cd6282576e03360079eeac8396cd39b60f6f2))
 - Pool update: ignore missing directories ([4360661](https://github.com/horizon-eda/horizon/commit/43606614907e2ea53930a6c9c24def2ce7177c64))
 - Pool update: don't update parametric data for skipped parts ([4daba6e](https://github.com/horizon-eda/horizon/commit/4daba6e78acc975bab1a8bc1670084560b2207f6))


### Pool/project manager

 - Confirm close dialog: only save selected items if clicking on save ([3c796ae](https://github.com/horizon-eda/horizon/commit/3c796ae61090a3f8d1f809bc3ab6ec0fc6620918))
 - Add SQLite and other temp files to pool and project .gitignore ([15e3228](https://github.com/horizon-eda/horizon/commit/15e3228b486420bbb063572e0dc79f6c4c3f29f3), [170b44d](https://github.com/horizon-eda/horizon/commit/170b44d23a2505872cbf30dedc8e3a5f4c2f5009))

### Windows-specific

 - Fix opening directories in file browser ([577f300](https://github.com/horizon-eda/horizon/commit/577f300395e6c7aa5b938a6b485ef6ee64469f95))

## Removed features

 - ViaPadstackProvider and `vias` directory in projects is replaced by project pools ([0912085](https://github.com/horizon-eda/horizon/commit/091208558c42c26ae2515c417428f39eb1c53303))


# Version 1.4.0

## New features

### Board Editor

 - Aribtrary view rotation ([d69b69c](https://github.com/horizon-eda/horizon/commit/d69b69c5359adae77ea2af388b1a5e0fea802a7e))
 - Rule export/import ([5f33144](https://github.com/horizon-eda/horizon/commit/5f33144c20fc00555be300de432dd32378640a28))
 - Pick&place export format can be be customized ([3ecc1bf](https://github.com/horizon-eda/horizon/commit/3ecc1bfe11efa193392d353a12f95c4f781d3ac8))

### Editors (interactive manipulator)

 - Measurement tool ([478bc50](https://github.com/horizon-eda/horizon/commit/478bc5063899eb2803d0a2a080af369668c7eb81))
 - Drag polygon edge tool ([084ac07](https://github.com/horizon-eda/horizon/commit/084ac072a957ca779e38421b6d437e4438a54d11))
 - Support pool reload in schematic and board ([f5214b2](https://github.com/horizon-eda/horizon/commit/f5214b21b36b2b27adc8fe1932f20a8d8ad416e2))

## Enhancements

### Board editor

 - Thermals in planes follow minimum width setting ([43c1928](https://github.com/horizon-eda/horizon/commit/43c1928869f090d5db59985191d5474577b6d2b4))
 - Place decal tool: Scale is adjustable from tool ([d351448](https://github.com/horizon-eda/horizon/commit/d351448d51fb292eeb8e60f17b4dca48fce64402))
 - Show holes in PDF export ([8de3dab](https://github.com/horizon-eda/horizon/commit/8de3dabb660e3cc9e1f7be3b5ce9e69ff5f7ac9a))
 - Improved rebuild performance after tools ([06fcd68](https://github.com/horizon-eda/horizon/commit/06fcd68829cf6acd62b2285efac9d8260444d6a6))
 - Draw plane/keepout tools for drawing planes/keepouts in one step ([e53f200](https://github.com/horizon-eda/horizon/commit/e53f200bdf3339abf1d8fedb1048fdc749354e2c))
 - Highlighting a package also highlights smashed texts ([1aedb43](https://github.com/horizon-eda/horizon/commit/1aedb433591823380a536d49e03e894aab64e484))
 - Show show more descriptive net names in preflight check ([3088cc8](https://github.com/horizon-eda/horizon/commit/3088cc8eb51891a9e8699e3ff5b0d2a54dd7dcaf))

### Editors (interactive manipulator)
 - Draw dimension tool: Label size is adjustable from tool ([07e0310](https://github.com/horizon-eda/horizon/commit/07e0310a338d9ef23c6337c0ebe9c9cc5c550cc9))
 - View can be flipped if a tool is active ([e213caf](https://github.com/horizon-eda/horizon/commit/e213caf18917ba46fb954183d8aa34a785f1e2b4))
 - Non modal enter datum windows don't immediately close after entering value ([bdc84fb](https://github.com/horizon-eda/horizon/commit/bdc84fb8ce0a6f2cfe9a5bfc7291ca2dbd3a38e3))
 - Arcs are drawn as such, not as line segments ([1367178](https://github.com/horizon-eda/horizon/commit/13671785b4b07f77c681a075163b8645ad85aeb1))
 - Rotate arbitrary/scale tool uses non modal dialogs ([b14e5f4](https://github.com/horizon-eda/horizon/commit/b14e5f438bdff38a5d0df7567b2f625aaf7846a0))
 - Rotate arbitrary/scale tool supports decals ([e8cc033](https://github.com/horizon-eda/horizon/commit/e8cc033b90476a3645896605ae40b846bd1f3c98))
 - Draw polygon tool: finish by closing polygon ([4707cc2](https://github.com/horizon-eda/horizon/commit/4707cc2b7e43944c0c4547148da3408b90f7e407))
 - Parameters window: add insert parameter button ([4d137c3](https://github.com/horizon-eda/horizon/commit/4d137c37b408bb4bc0277942021d01a5e2dc915d))
 - Use navigation buttons (back/forward) to switch layers ([f871566](https://github.com/horizon-eda/horizon/commit/f8715665467e0b348ebb16090d308faffd9ab858))

### Package editor

 - Edit pad tool uses non modal dialog ([e2bf3b2](https://github.com/horizon-eda/horizon/commit/e2bf3b2dcce2c3e276be9f0924dc67b82a303ba1))

### Symbol editor

 - Symbol preview window remembers window size ([f483d2c](https://github.com/horizon-eda/horizon/commit/f483d2cf55d87c5d617059742148ec4632a535a5))
 - Preview for expanded symbols ([1b32099](https://github.com/horizon-eda/horizon/commit/1b32099ca1dfe4a4231dad197cccde9d084222aa))

### 3D preview

 - Render gamma-correct background gradient ([67e0c4b](https://github.com/horizon-eda/horizon/commit/67e0c4b642dfd286aa88de03bf652c553c13af45))
 - Use gamma-correct shading ([693942f](https://github.com/horizon-eda/horizon/commit/693942f43774e55f7f02eb69ddbf5eb37c5dad2a))
 - Render models with smooth normals ([6395e2e](https://github.com/horizon-eda/horizon/commit/6395e2e61b3950bc848c4654e43e468d0d71923f))

### Pool manager

 - Improved progress reporting during pool download ([0781a51](https://github.com/horizon-eda/horizon/commit/0781a511497f68795348b2b7c7db968e94e2c2e4))
 - Git tab performance enhancements ([7c6a02f](https://github.com/horizon-eda/horizon/commit/7c6a02fb24e640872f3eb8cbb15cef4174d42c0b))
 - "Where used" list performance enhancements ([4e7dc29](https://github.com/horizon-eda/horizon/commit/4e7dc293ae1517a5c7a4c16a195fd2d8f0b14194))
 - Pool update is 2× to 5× times faster ([bd95955](https://github.com/horizon-eda/horizon/commit/bd95955f4f2e4e3a8f12823d3e0cba757dab3cc6), [b5603e3](https://github.com/horizon-eda/horizon/commit/b5603e3da80e817418a8116a4cc45bcfbc5f3d42), [acb4124](https://github.com/horizon-eda/horizon/commit/acb4124e37267a6fed2c3e2fdc5214a017bbac3d), [2806973](https://github.com/horizon-eda/horizon/commit/28069739a0d79e0df370339956f43c6f2da85f70))
 - Properly update pool after duplicating part with package ([f64af58](https://github.com/horizon-eda/horizon/commit/f64af586dcf39286ee5f30321a2bb6e9b55a7a48))
 - Partinfo searches by MPN prefix rather than exact match ([ac48399](https://github.com/horizon-eda/horizon/commit/ac48399234f0073d8701275ff488a86dc326f00b))


## Bugfixes

### Board editor

 - Make decals only selectable on used layers ([cb34b24](https://github.com/horizon-eda/horizon/commit/cb34b24e7b70e11df2e8f9333822e9c33bb09dbf))
 - Place decal tool: Support mirroring decal ([5f7a85d](https://github.com/horizon-eda/horizon/commit/5f7a85d334b87867363d7e8eb17ff5db554a1ff0))
 - Via overlay stays readable in bottom view ([bd8b7db](https://github.com/horizon-eda/horizon/commit/bd8b7db4fac45f5f4bffff7941c8dc5fee5f4b4a))
 - Decals are actually mirrored if mirrored ([435dde1](https://github.com/horizon-eda/horizon/commit/435dde1547e0406f39b70c1093e8d74280e0d995))
 - Add plane cutout for PTH barrels ([f3e813e](https://github.com/horizon-eda/horizon/commit/f3e813e0b74bae763aa12179f36dd0640f720f76))
 - Ignore irrelevant layer during plane updated ([8fb868b](https://github.com/horizon-eda/horizon/commit/8fb868bfb8df60f6b0ada62843071efb8f6aee12))
 - Properly handle zero length airwires ([d4f8ffe](https://github.com/horizon-eda/horizon/commit/d4f8ffee8649caf3bdc31f671929b390365bf39f))
 - Properly display nets with no airwires in nets window ([dad6c71](https://github.com/horizon-eda/horizon/commit/dad6c714cc43df72c877024f552134d3d3345bb0))

### Schematic editor

 - Don't crash if connected symbol pin is deleted in symbol ([9cf9a52](https://github.com/horizon-eda/horizon/commit/9cf9a528318b3b5f3b1c2084d8ebb25ac8316d3c))

### Editors

 - Multiline text edit dialog: insert newline at cursor ([5780aff](https://github.com/horizon-eda/horizon/commit/5780affd9a3fed4e89c7ca58691459752755e98a))
 - Load select polygon action keybindings on startup ([88d0bbc](https://github.com/horizon-eda/horizon/commit/88d0bbc10942708369586147a5ac9a460fafa65b))
 - Don't show action button menu if clicked the wrong way ([47654f3](https://github.com/horizon-eda/horizon/commit/47654f33852957b3870d48ee5ab0343775d7ceb6))
 - Avoid rendering empty buffers potentially leading to crashes ([69ac4b5](https://github.com/horizon-eda/horizon/commit/69ac4b50678daf822636c4cffc11d2114a7409f0), [438e65c](https://github.com/horizon-eda/horizon/commit/438e65c3f064f09cee358a50c09f321009f705aa))

### Pool manager

 - Remote tab: Don't crash if there's no local branch when updating a pull request ([88ca981](https://github.com/horizon-eda/horizon/commit/88ca98115bd32a99fc48cc4c812b44c75d3e6334))

### Windows builds

 - Use patched Gtk to work around Intel GPU driver bug ([84a1837](https://github.com/horizon-eda/horizon/commit/84a18373d3fc3c234bc35086d5e0eb7c261f9e15))
 
## Removed features

### Editors

 - Pasting as SVG isn't supported anymore ([13f2428](https://github.com/horizon-eda/horizon/commit/13f2428f6f22a44bc3edb648244f8de6c87acbd9))

# Version 1.3.0

## New features

### Board editor

 - Decals for putting logos and symbols on boards ([d2e88d7](https://github.com/horizon-eda/horizon/commit/d2e88d71601604c82a7ba680fe3da3dfe694ead1))
 - "Add text" tool for adding text linked to packages ([6fbfb78](https://github.com/horizon-eda/horizon/commit/6fbfb786172c339867845a6bf199ec404218bd0f))
 - Same net clearance check ([46c2156](https://github.com/horizon-eda/horizon/commit/46c2156b1cdc57d885a5c343216e92bd43c6f7cb))
 - Support highlight collisions and DRC off mode in router ([078d543](https://github.com/horizon-eda/horizon/commit/078d54340f4ccaa8cb1718d10780265a01cc803f))

### Editors (interactive manipulator)

 - Actions for pan and zoom ([1d57d9c](https://github.com/horizon-eda/horizon/commit/1d57d9c6f63466698e4935e002032efb3a744026))
 - Draw circle tool ([b63a8c1](https://github.com/horizon-eda/horizon/commit/b63a8c1f2f70083c4ac80926382a70e90aa1f321))
 - Highlight net class action in schematic and board ([9f1a240](https://github.com/horizon-eda/horizon/commit/9f1a24093cc1aa8c3c815a0a225f0d4ee86f1f3a))

### Pool manager

 - Support moving and renaming pool items ([14de320](https://github.com/horizon-eda/horizon/commit/14de3200d7e3e43df879dfd05cb4cfa2eae11d27))
 - Pull request review tool (needs to be enabled in `prefs.json`) ([e2d4cd2](https://github.com/horizon-eda/horizon/commit/e2d4cd2b9194dffba13a8bffd83254f118e6adc7))
 - Checks for Units/Entities/Parts ([76c596c](https://github.com/horizon-eda/horizon/commit/76c596ca5d08e7f43ac33b26d8b48e1b90025d33))

### Symbol editor

 - Symbol checks ([a873327](https://github.com/horizon-eda/horizon/commit/a873327f7fe02fec1b43612b3e3dca3da6e7cfea))

### 3D preview

 - Add option for hiding "do not populate" components ([d7d6a9c](https://github.com/horizon-eda/horizon/commit/d7d6a9cacac6fc9bc72417b2434d68458f3dc530))

### Package editor

 - Clearance checks ([a448a3c](https://github.com/horizon-eda/horizon/commit/a448a3c383d3a0af29d65e6e256b8388c860feb5))

### Misc

 - Store application version information in pool items and projects ([9f5cc52](https://github.com/horizon-eda/horizon/commit/9f5cc52a3e65389ad2ea6f4af63753876543b3ff))

## Enhancements

### Internals

 - Check object type when loading pool items ([b961e7a](https://github.com/horizon-eda/horizon/commit/b961e7af71fd3afc3671d4e9101445c29dcac559))

### Package editor

 - Avoid dependency cycles when setting alternate package ([2c3efac](https://github.com/horizon-eda/horizon/commit/2c3efac5212af11fc89d1e22d575437179490989))

### Editors (interactive manipulator)

 - Tell user about conflicting key sequences ([b63a8c1](https://github.com/horizon-eda/horizon/commit/b63a8c1f2f70083c4ac80926382a70e90aa1f321))
 - Make zoom factor configurable ([b5303b4](https://github.com/horizon-eda/horizon/commit/b5303b460d9ef79b73a7cbee5e490f7b472617e6))
 - Add action for entering click select mode ([da13af6](https://github.com/horizon-eda/horizon/commit/da13af6b4bde5f3b73b6b6bce638471f30c81eef))
 - Use layer ranges for improved selection usability in work layer only selection filter mode ([ed7d975](https://github.com/horizon-eda/horizon/commit/ed7d975a1dce767b4a2e0a82e96cea0d3cb37e76))
 - The "add polygon vertex" tool supports adding more than one vertex per invocation ([2129b75](https://github.com/horizon-eda/horizon/commit/2129b758796b228c35ee24033d90862ddb6991e2))
 - Only show apply rules button where applicable ([22fdd70](https://github.com/horizon-eda/horizon/commit/22fdd70578eb8e5a5f2be0d95df4a752731c541f))
 - Bottom view also flips arrow keys ([6a44ebe](https://github.com/horizon-eda/horizon/commit/6a44ebe04d60d6aa0f1efa33a73dce4331148b74))
 - Rotate arbitrary tool uses reference angle ([cccf0bd](https://github.com/horizon-eda/horizon/commit/cccf0bd0ab48ddad31b169b2035375a2f1753eb2))
 - Current tool is ended before starting tools triggered externally (such as placing part) ([cf70e2a](https://github.com/horizon-eda/horizon/commit/cf70e2a2c2c4e6d73fa831081e7fcc42b1811fd0))
 - Option for showing action bar if tool is active ([8d46953](https://github.com/horizon-eda/horizon/commit/8d4695396d49bbc88afb7e829d7eb6697083c1e4))

### Schematic editor

 - Support unsetting frame ([f4491d3](https://github.com/horizon-eda/horizon/commit/f4491d3284fe3ef7cfd4ce994ff8cc2bd198d828))
 - Use more sensible shift when placing power symbols on pins ([4bc6da5](https://github.com/horizon-eda/horizon/commit/4bc6da5fc9f257f1143538a92b0aa379df3d8fdf))

### Board editor

 - Router respects find grid key ([70f2f85](https://github.com/horizon-eda/horizon/commit/70f2f8531742f884054a18df2d4f469673afaf8c))

### Pool update

 - Improved detection of cycles among pool items ([6c8a184](https://github.com/horizon-eda/horizon/commit/6c8a1840b6cb929ff7ce8ec0aef7f53a6101db45))

### Preferences

 - Search for actions by substring rather than prefix ([14aa7d7](https://github.com/horizon-eda/horizon/commit/14aa7d752a871734417eef702303399e6e66d73d))

### Pool manager

 - Only enable save button in Unit/Entity/Part editor if needed ([994927c](https://github.com/horizon-eda/horizon/commit/994927c6d1b732b2551ac3caa96804680bb083fa))
 - Use device authentication in remote tab ([69c8b92](https://github.com/horizon-eda/horizon/commit/69c8b92a455e494179ea76e86d2de5d1458ef97b))
 - Option for only showing pull requests of signed in user ([eda6b5f](https://github.com/horizon-eda/horizon/commit/eda6b5f32dcc3630a5d72084a53b153fe3a85b75))
 - It's now possible to update pull requests opened with the pool manager ([b406423](https://github.com/horizon-eda/horizon/commit/b406423a6a3182ce2d8e56fcb5c80a1f84997eb6))
 - Log window in pool/project manager ([6720349](https://github.com/horizon-eda/horizon/commit/67203496641814bd754a46c094860f55548d280b))

## Bugfixes

### Board Editor

 - DRC doesn't ignore barrel of PTH holes without pads ([5490eae](https://github.com/horizon-eda/horizon/commit/5490eae5bf79397828c6da50a8bf2c9788e75c75))
 - Use 3D model from alternate package if it has only one model ([96cf811](https://github.com/horizon-eda/horizon/commit/96cf811793915ccb2157095dcf99d1f9a4691308))
 - Parts window doesn't crash if component has no part ([cbf9df3](https://github.com/horizon-eda/horizon/commit/cbf9df3af5350a65e72ea1511c8bb095eb381a53))
 - Update refdes in unplaced list when reloading netlist ([d42e44e](https://github.com/horizon-eda/horizon/commit/d42e44e0a94c8bcb21cb8a6cc696290c56be4b1b))
 - Don't load nonexistent nets in airwire filter ([1a14686](https://github.com/horizon-eda/horizon/commit/1a146869375354bee6daeb0e990a0e0b97507c93))
 - Router doesn't crash on pads with zero polygons ([e43a830](https://github.com/horizon-eda/horizon/commit/e43a8309cb2e697318596401d54bf478c709a41d))

### Canvas

 - Fix grid rendering on some platforms ([8e457c1](https://github.com/horizon-eda/horizon/commit/8e457c1d277b857fb24dbe5ff97f33ab485e682e))

### Editors (interactive manipulator)

 - Also save on exit if a tool is active ([12bc268](https://github.com/horizon-eda/horizon/commit/12bc268785771fe17fef301e36fd978614d2cb29)) 
 - Make cursor work near head-up display ([cae3fe2](https://github.com/horizon-eda/horizon/commit/cae3fe282de3f504a51441f7940b9a24c128973a))

### Schematic editor

 - Remove nonexistent connections in copy/paste ([0ceaf2e](https://github.com/horizon-eda/horizon/commit/0ceaf2ef9686bb83af3217ca0ec4e17f7ae3b37b))
 - Update symbol text placement while placing symbol ([431f7e6](https://github.com/horizon-eda/horizon/commit/431f7e63accfd007766ba39bd9f36d739b3abc35))

### Pool/project manager

 - Increase recent list refresh interval for reduced idle CPU usage ([3570e85](https://github.com/horizon-eda/horizon/commit/3570e859e6e6ecf82e493cc5a513edcac0c03c6a))
 - Catch errors in local pool update during pool upgrade ([86e6476](https://github.com/horizon-eda/horizon/commit/86e6476b258ecbeb48066a3e33fe88a2f9ade5b9))

### Part wizard

 - Update duplicate pad name warning after linking pads ([c0d7756](https://github.com/horizon-eda/horizon/commit/c0d7756957fafda420349d18c3936473564728eb))
 - Properly check for `.json` suffix in filenames ([6598cc3](https://github.com/horizon-eda/horizon/commit/6598cc33a4f57a6634b029fac46f45ae895a70c2))

## Changed behavior

### Editors (interactive manipulator)

 - Only exit hover select mode if actually clicking one something ([a17b450](https://github.com/horizon-eda/horizon/commit/a17b4504f797d0cd6b95e4377cc1e840b2119dd1))

### Board editor

 - Plane styles got renamed to reduce confusion ([7ec340e](https://github.com/horizon-eda/horizon/commit/7ec340e30753c1eaa93ee437f10b8e9bd9589646))

# Version 1.2.1

## Bugfixes

 - Fix crash in router due to undefined behaviour ([37882e0](https://github.com/horizon-eda/horizon/commit/37882e0f9619f634d7681932f0e2b72c4ec20a93))

## Misc

 - Makefile: allow gold linker to be disabled ([6113054](https://github.com/horizon-eda/horizon/commit/6113054dc674e508ca018debabe1974c1cc994a4))

# Version 1.2.0

## Added features

 - Action bar for easy access to commonly-used actions ([136cf03](https://github.com/horizon-eda/horizon/commit/136cf038e599570819297cffe84ac951bcf61cc1))
 - Bitmap picture import for schematic, package, board ([6f7edd7](https://github.com/horizon-eda/horizon/commit/6f7edd75e634a512f669d3ba17973f4b146a7f32))
 - KiCad symbol import ([8f10971](https://github.com/horizon-eda/horizon/commit/8f109717fe4b0a59973c38b089c9d049fce79177))
 - Searchable airwire filter window ([e4842ca](https://github.com/horizon-eda/horizon/commit/e4842cae282bf63f514b199e848397dcfedb61c1))
 - Color by net in board editor ([3accc33](https://github.com/horizon-eda/horizon/commit/3accc33cafbb1808f7c699c75cb1ddc71cc69b00))
 - Configurable in-tool key sequences ([07283ce](https://github.com/horizon-eda/horizon/commit/07283ce78fce6679e0d12c158742fa759bc25ced))
 - Grid supports non-zero offset and non-square spacing ([9d96d21](https://github.com/horizon-eda/horizon/commit/9d96d2114c290a8dd9f6e00596b57265837f3c37))
 - Gate swapping ([47a5a6e](https://github.com/horizon-eda/horizon/commit/47a5a6e3336259f2e5ccab3d33f71e73a50947ab))
 - Symbol to unit cross probing ([d1f81db](https://github.com/horizon-eda/horizon/commit/d1f81db235220fb6317317bf841b5f3fe03639c1))
 - Layer pairs for switching layers after placing vias ([176b8e2](https://github.com/horizon-eda/horizon/commit/176b8e2ff2a62efa9aaeb2c5cc42da7af6beb29e))
 - Distraction-free mode ([111309c](https://github.com/horizon-eda/horizon/commit/111309c6be1d0193664dae6a93e4fa113a9d7a83))
 - References to sheets in schematic ([ca23d34](https://github.com/horizon-eda/horizon/commit/ca23d34aecde221f0c5c4c90348bc7fe2aebca53))
 
## Enhancements

 - Progressive model loading in 3D preview ([10d52d7](https://github.com/horizon-eda/horizon/commit/10d52d749d1eb931fd1b384640b093966aa5a17e))
 - Show scale bar in preview canvas ([edaa964](https://github.com/horizon-eda/horizon/commit/edaa9649d105ba6a981887534d860c0b852209bc))
 - Show placeholder in length tuning window ([38044b2](https://github.com/horizon-eda/horizon/commit/38044b2b99d795f05f3f359866f9a388b6de3851))
 - Show key sequences in context menu ([3441ff5](https://github.com/horizon-eda/horizon/commit/3441ff5ae7015e3e9e9e8d729c68b2f927e712b8))
 - Selection qualifier is remembered when switching selection tools ([9af4a65](https://github.com/horizon-eda/horizon/commit/9af4a659f144e9434f0bef1dc9a0321bc4d82743))
 - Selection is is remembered for each sheet ([273c9bc](https://github.com/horizon-eda/horizon/commit/273c9bc64080e42ea461a485898a22035712a961))
 - Make minimum line width configurable ([309e41f](https://github.com/horizon-eda/horizon/commit/309e41f2357aa9c06ee1fe5c87dcbd06b2909604))
 - Search can do exact matching rather than substring search ([266fe7a](https://github.com/horizon-eda/horizon/commit/266fe7af05ba217a2ef755cf488e5996fc63f457))
 - Show placeholder in unit editor ([8fa9452](https://github.com/horizon-eda/horizon/commit/8fa9452b467b62227f17a281bbb05a8a9029f74e))
 - Add link to pool in project manager ([66e66c6](https://github.com/horizon-eda/horizon/commit/66e66c6f1fe7dd349155813114dc96c705c1732c))
 - Move Part wizard button to Parts tab ([6ae9361](https://github.com/horizon-eda/horizon/commit/6ae93615ab72be615892730fcba99edb320293e7))
 - Improve layout of unit and entity editors ([810fdba](https://github.com/horizon-eda/horizon/commit/810fdbad87a9059446556f5b9fda855f67730836), [0119cb8](https://github.com/horizon-eda/horizon/commit/0119cb8782c998464d43bae34675a0756f4d3c20), [555f2ff](https://github.com/horizon-eda/horizon/commit/555f2ff65ecaa427db01d1ad6ce1b063af357760))
 - Make sure symbol is in view when placing symbol ([c61afdb](https://github.com/horizon-eda/horizon/commit/c61afdb6e1b1fdec9738531fc480e8583922754d))
 - Tool popover is resizable ([1240fb8](https://github.com/horizon-eda/horizon/commit/1240fb8b81549176888e25af8783c0148d0ca0fb))
 - Hint for reloading the netlist in board editor ([94e82b7](https://github.com/horizon-eda/horizon/commit/94e82b77e686c49a1b00daa9db5f1be96dc88b59))
 - Kicad package import handles circular pads ([b5125e3](https://github.com/horizon-eda/horizon/commit/b5125e3d1793f71213cdd3d0ba521ac93f5f7a2b))
 - View options menu ([4e2fb33](https://github.com/horizon-eda/horizon/commit/4e2fb333bb23a7fbb6f10a7216f073ab10f03a71))
 - Package browser can sort by pad count ([e53098d](https://github.com/horizon-eda/horizon/commit/e53098d481488b49ca6912fb4b40b46d04aebae5))
 - Show pin names in pads ([4318650](https://github.com/horizon-eda/horizon/commit/43186500bd916a77f0f44ff2f84747cc46af8de9))
 - Show net names in vias ([9adf7ca](https://github.com/horizon-eda/horizon/commit/9adf7ca6447ef575ff7c8caa076b8e9fb04ccad3))
 - Deleting a track chain also deletes vias on the way ([24e9904](https://github.com/horizon-eda/horizon/commit/24e990440851097be05a457dcab3571e4503dfc7))
 - Kicad package import handles rectangular pads with round corners ([6eb90ba](https://github.com/horizon-eda/horizon/commit/6eb90ba3b455d19f08606254e562b09aec0e1516))
 - Kicad package import handles obround pads ([27d3d7e](https://github.com/horizon-eda/horizon/commit/27d3d7eba01b7b39c5ee248c3fda967564a276b3))
 - Place via tool asks for net rather than padstack ([a1b0e49](https://github.com/horizon-eda/horizon/commit/a1b0e4955842e61ed105d1555e2599326d6dd920))
 - Draw polygon rectangle tool rememberes mode ([092fec9](https://github.com/horizon-eda/horizon/commit/092fec906916aecbe73217bb1923ff9511c0b123))
 - Rules window position is stored for each editor type ([ecb51e0](https://github.com/horizon-eda/horizon/commit/ecb51e0a2d49bb9582ade37ed9d14ce69d659a76))
 - Grid snaps to pixel grid for improved sharpness ([017049d](https://github.com/horizon-eda/horizon/commit/017049d57ad5c8f081c77166011cff2bc2fab412))
 - Update KiCad router to 5.1.6 ([9e107c6](https://github.com/horizon-eda/horizon/commit/9e107c65024dbc9d43004489b1cd013c86fd6bd9))
 - Option for moving single tracks with router ([956d8f5](https://github.com/horizon-eda/horizon/commit/956d8f5fa6dc2637449a3cad666eb86575c368b4))
 - Add router settings window ([bf00701](https://github.com/horizon-eda/horizon/commit/bf007017473129dfb036e0a6309e2fe2905a3dd0))
 - Improve router performance ([1f86cf3](https://github.com/horizon-eda/horizon/commit/1f86cf35f82c650fe3cedd8abc2532ec1eac1548), [651475c](https://github.com/horizon-eda/horizon/commit/651475c9b73faec6f4e9174fc2549c5334a9a55a), [f68df85](https://github.com/horizon-eda/horizon/commit/f68df8534fb8e7bd85a32c1e9c9f8d86f204d307))
 - Button for copying logs to clipboard ([7b9e8d8](https://github.com/horizon-eda/horizon/commit/7b9e8d840ea75a463026016f7cab0ef4db01837f))
 - Work layer only display modes ([703ea35](https://github.com/horizon-eda/horizon/commit/703ea35ef8274dacca82f778fd6d879a2d9f2372))
 - Allow changing net while placing via ([e04d8f3](https://github.com/horizon-eda/horizon/commit/e04d8f33786e57185b808e1f06fcc17027162f20))
 - Make zero-width selectables smaller ([6c8fd8e](https://github.com/horizon-eda/horizon/commit/6c8fd8ef8b769e7f61fc83a59caefddebdf15fd9))
 - Show all polygon edges when selecting polygon ([20b14f0](https://github.com/horizon-eda/horizon/commit/20b14f0541026f3224958e00d1c032cf1cdc4f63))
 - Adjust plane priorities from property sidebar ([1ad4b04](https://github.com/horizon-eda/horizon/commit/1ad4b04de230608b27e72528a631b5bd9589c23d))
 - Show planes in head-up display ([ebb804f](https://github.com/horizon-eda/horizon/commit/ebb804f6e2f495d7f9dfcaa2bc55749075589e49))
 - Don't show clarify selection menu if there's only one line/point among the selection candidates ([ab058c3](https://github.com/horizon-eda/horizon/commit/ab058c3af2793cd4b374a3f51e639775b9b8e4a3))
 - Make minimum selectable size and target snap radius configurable ([96be373](https://github.com/horizon-eda/horizon/commit/96be373247bcbde5488e70a3c5c1aef62c7e342c))
 - Add option for snapping to targets on schematic ([bff1bbf](https://github.com/horizon-eda/horizon/commit/bff1bbfca3f4687ea22ef2338378de14954a0c8a))
 - Enable scale and rotate arbitrary tool in schematic ([685469b](https://github.com/horizon-eda/horizon/commit/685469b72b4e84efd9d61dc2524233a688eb55cb))
 - Make length tuning window sortable by length ([23136ad](https://github.com/horizon-eda/horizon/commit/23136ad244e1152fcefa5cdc9e639700335c6f01))
 - Length tuning tool uses reference from length tuning window ([0d0340e](https://github.com/horizon-eda/horizon/commit/0d0340e466f5ec6d83973d2b4e9cc634e819189d))
 - Optionally bend non-orthogonal net lines when dragging ([e0eb9e3](https://github.com/horizon-eda/horizon/commit/e0eb9e3fbce1c1a8f9177d9f86935149ccd1627d))
 - Show more information when deleting a pool item ([9d813cb](https://github.com/horizon-eda/horizon/commit/9d813cba76cc72bfd2b5f0c442168c477b691b03))
 - Show infor bar with links to docs in pool manager ([5c42c2a](https://github.com/horizon-eda/horizon/commit/5c42c2ac2cfd694be3c181a0a23f1439c53231ba))

## Bugfixes

 - Resize symbol tool respects quadrant the tool was started in ([80b2b67](https://github.com/horizon-eda/horizon/commit/80b2b672d4ee5244d41fe9f6f3ece7bbf7ec4ed8))
 - Don't show empty groups in tool popover ([3f6d528](https://github.com/horizon-eda/horizon/commit/3f6d5285b92fd6c07ff8c23425a5ef412b080555))
 - Fix copying frame of current sheet to new sheet ([c437557](https://github.com/horizon-eda/horizon/commit/c437557e98dd4522dcf2e223d7e66cf0e1e28604))
 - Properly set button sensitivity in part editor ([3009711](https://github.com/horizon-eda/horizon/commit/3009711842cf8549195d98dce917cea948b8be91))
 - Annotations: Fix gap filling for multi page components ([75139e8](https://github.com/horizon-eda/horizon/commit/75139e8a24cf1484ac8373f622f68f4d692530ee))
 - Don't crash when deleting junction attached to bus ripper ([bd1e9ae](https://github.com/horizon-eda/horizon/commit/bd1e9ae5975f1257ca43c4e3b3ffb2216261c84c))
 - Ignore mechanical pads for alternate package compatibility check ([5ee3cf6](https://github.com/horizon-eda/horizon/commit/5ee3cf6e9464e259f33ea62fc6753a3fd236fed3))
 - Don't draw connection lines from no-net junctions and mechanical pads ([0328bd4](https://github.com/horizon-eda/horizon/commit/0328bd42fc7a2cf48857bf2720950c955a81b91a))
 - Copy/paste copies tracks attached to pads ([0328bd4](https://github.com/horizon-eda/horizon/commit/0328bd42fc7a2cf48857bf2720950c955a81b91a))
 - Save no parametric data in part editor ([c2795bb](https://github.com/horizon-eda/horizon/commit/c2795bb3bdfe4ffe8ac7248e58d706343ab243d2))
 - Fix pool update if not duplicating symbol ([6eb90ba](https://github.com/horizon-eda/horizon/commit/6eb90ba3b455d19f08606254e562b09aec0e1516))
 - Properly implement target snap filter in tools ([cc5c029](https://github.com/horizon-eda/horizon/commit/cc5c029e630a70fb9e3423c278a397758d998058))
 - Don't render invisible annotations ([3816fd0](https://github.com/horizon-eda/horizon/commit/3816fd0f4b23d1cbc7fed2825046256f052f0ec2))
 - Git tab doesn't crash if 3D model is used in more than one package ([867e7ec](https://github.com/horizon-eda/horizon/commit/867e7ec51a84e6098cccf944837c5d7c8c986271))
 - Update catch-all warning in rules window when switching rules ([2eb90b3](https://github.com/horizon-eda/horizon/commit/2eb90b3bcc4cdd0973fa00495df1051e04f4465a))
 - Only show catch-all warning in rules window if actually required ([2eb90b3](https://github.com/horizon-eda/horizon/commit/2eb90b3bcc4cdd0973fa00495df1051e04f4465a))
 - Show pad name overlay at the right position of pad's bounding box center isn't at origin ([ab0272d](https://github.com/horizon-eda/horizon/commit/ab0272d43c6fccfe26402f17c3daeee0d9beead8))
 - Fix pointer warping while panning ([4f963c5](https://github.com/horizon-eda/horizon/commit/4f963c5c72ceb9f1829e3c7aceb804e6edda9d3a))
 - Don't snap to invisible SMD pads ([02539c7](https://github.com/horizon-eda/horizon/commit/02539c741d6daa8410035876814386fda4259d50))
 - Avoid drive not ready errors on win32 ([9b0d1e9](https://github.com/horizon-eda/horizon/commit/9b0d1e94f7b616009bb5a81f4301bdd840b15292))
 - Prevent errors during triangulation for 3D preview ([7f1ba24](https://github.com/horizon-eda/horizon/commit/7f1ba24ebbe7bbfcdb8918afab16b57f41356281))
 - Fade unhighlighted objects to background color rather than black in dim mode ([edcdb97](https://github.com/horizon-eda/horizon/commit/edcdb97eef3d8f1ea09b3350cbf350f2dc9bd0f0))
 - Refresh units after updating pool ([2c6655a](https://github.com/horizon-eda/horizon/commit/2c6655a3f114533b77120c6303afc801299d8573))
 - Avoid exception when loading keys for unavailable tool ([182c967](https://github.com/horizon-eda/horizon/commit/182c967daf7417fc8295ec1521d07b4b898f141c))
 - Avoid crashes by using `json::at` rather than `[]` ([55505e6](https://github.com/horizon-eda/horizon/commit/55505e6c343949d262f29fa8121256ce88e051cf))
 - Use multiline text editor when placing text ([bebd57a](https://github.com/horizon-eda/horizon/commit/bebd57a8bfc9570931c66a602ae5494d9d853d69))
 - Use menu rather than cropped popover in parameter set editor ([935c270](https://github.com/horizon-eda/horizon/commit/935c270155391af9ac96e88c3fa91374ab7e86ca))
 - Keep scrolling position in unplaced box ([83ec1be](https://github.com/horizon-eda/horizon/commit/83ec1bead7e47b78596a6c080e53ad03e1636e4e))
 - Incrementally update pool when duplicating items ([8a978bf](https://github.com/horizon-eda/horizon/commit/8a978bf4a0752dedb13e1365cf3f0d37678c96c6))
 - Fix symbol pin UUID when changing a symbol's unit ([494f19a](https://github.com/horizon-eda/horizon/commit/494f19aed7cc1e061f0caa8750859a3dcf887daf))
 - Don't trigger drag when holding shift for pan ([397757d](https://github.com/horizon-eda/horizon/commit/397757d240d830d88292c326a07d47943143482d))

## Changed behavior

 - Move some actions to more appropriate groups ([e29462e](https://github.com/horizon-eda/horizon/commit/e29462e49a00974ae964e1116d0530049974cbef), [e29462e](https://github.com/horizon-eda/horizon/commit/e29462e49a00974ae964e1116d0530049974cbef))
 - Pool is updated when saving parts, not after closing the editor ([e9305b3](https://github.com/horizon-eda/horizon/commit/e9305b327022187b9ad63c928eeb7911a439e4a3))
 - Widgets in unit/entity editor rows don't receive scroll events anymore ([6e15a9e](https://github.com/horizon-eda/horizon/commit/6e15a9e02234651a7a9dca721ffa7700ea299663))
 - Center of polygon arcs and arcs gets projected onto the perpendicular bisector of start and end point to force constant radius ([ae7b293](https://github.com/horizon-eda/horizon/commit/ae7b2938e314492890dbf9a56a66c091dd888242))

## Removals

 - Place package button is gone since the same functionality is available from the unplaced list ([ac7d7c1](https://github.com/horizon-eda/horizon/commit/ac7d7c1ce24922f830432f9627bbf3c434b76146))
 - Homegrown old router tool ([079530f](https://github.com/horizon-eda/horizon/commit/079530f636117e76472c017548cfd7896b94ff53))

## Misc

 - Combine low-content pages in preferences dialog ([45770af](https://github.com/horizon-eda/horizon/commit/45770afeac6cc9a3f9a82db25bf981e19a5955c1))
 - Bump C++ version to C++17 ([35faeda](https://github.com/horizon-eda/horizon/commit/35faedad9609db0c8432ac589bdd52157e093446))

# Version 1.1.1

## Bugfixes

 - Makefile: don't build during make install ([e991aff](https://github.com/horizon-eda/horizon/commit/e991aff73919b6b0d05ea22ed7ecc2c61d8a0c0b))
 - win32: regenerate gdk pixbuf loader cache during build ([b7a128b](https://github.com/horizon-eda/horizon/commit/b7a128bed12da74accec4231baf01caa333323fe))

# Version 1.1.0

## Added features

 - Pick&place export ([bdb0af8](https://github.com/horizon-eda/horizon/commit/bdb0af86c26d50d027a2013cf52e1eaf56543af4))
 - Support replacing project metadata variables on board ([c1293e2](https://github.com/horizon-eda/horizon/commit/c1293e25a04d62c7e7a520c8b3ec3f944e6664c5))
 - Airwire filter ([145bcb1](https://github.com/horizon-eda/horizon/commit/145bcb1b9b54efed4aee7cb50b62fbf6724bf8a2))
 - Support for touchscreen pan and zoom gestures ([38ff613](https://github.com/horizon-eda/horizon/commit/38ff6139d6e8ceba7ccc2bdf234168984fc5a528), [ca1b832](https://github.com/horizon-eda/horizon/commit/ca1b8321cb7cce845eaabec28ae467e59f8c9aa9))
 - Support for "dot not populate" components ([8cf32eb](https://github.com/horizon-eda/horizon/commit/8cf32ebdecc5f6bd73578b1b5ff07c331336bec9))
 - Action for selecting all vertices of a polygon ([5d2571f](https://github.com/horizon-eda/horizon/commit/5d2571fd76ca4eb33372810dfe4897aabe16cf5a))
 - Panelisation ([188802f](https://github.com/horizon-eda/horizon/commit/188802f1e94ed23777f89c778d422b2ec6fa461f))
 - Outline layer in packages ([03f29b5](https://github.com/horizon-eda/horizon/commit/03f29b5701f9f915d777a78eb0ad74d17e875bad))
 - Automatic update of pool cache status and hint when placing out of date part ([655c084](https://github.com/horizon-eda/horizon/commit/655c08476cd14726f6d2433938d1ae9b30cd8801))
 - Recursive `git add` from git tab in pool manager ([ea5bcb4](https://github.com/horizon-eda/horizon/commit/ea5bcb420ab32d6937b76cdcf378dcc296ddcbd1))
 - Tool for resizing symbols ([21763df](https://github.com/horizon-eda/horizon/commit/21763df7d0d46a4a55b7f1a154684fe489cd5371))
 - Tool for generating silkscreen ([c314592](https://github.com/horizon-eda/horizon/commit/c314592ec88b757f0355bd6fd95ea81122ff252c))
 - Run board checks from python module ([e47e579](https://github.com/horizon-eda/horizon/commit/e47e5798957282490aa0af93cb8818a45f2a0f60))
 - Tool for rounding off polygon vertices ([b028dbe](https://github.com/horizon-eda/horizon/commit/b028dbe8c297853873521308a8d801da526106e6), [1b9a801](https://github.com/horizon-eda/horizon/commit/1b9a801a9f587501ce96cfc4de972d778e97a09e))
 - Pool update from python module ([7cd5cc2](https://github.com/horizon-eda/horizon/commit/7cd5cc2e00b78e85a29ffd7f88065ac81ce01c84))
 - Package python module as docker image ([3b047c3](https://github.com/horizon-eda/horizon/commit/3b047c3a61dfe3daf69b0612261f893c5eb384a9))
 - Export 3D rendering from python module ([619b74b](https://github.com/horizon-eda/horizon/commit/619b74b6fe1abd6f7c7c9bc835cbb8e90b3e7a1c))

## Enhancements

 - Show list of unplaced symbols in schematic ([c237eeb](https://github.com/horizon-eda/horizon/commit/c237eeb2a7f53a69f2dbc9237709b033cc6a36b6))
 - Show list of unplaced packages in board ([fabbd65](https://github.com/horizon-eda/horizon/commit/fabbd65657a2b10836c62180874695b061d70094))
 - Copy placement tool copies silkscreen ([55a3226](https://github.com/horizon-eda/horizon/commit/55a322619d57340d054a153a277df05dcf4982f2))
 - Make pool download cancellable and show download progress ([fd943ae](https://github.com/horizon-eda/horizon/commit/fd943aeddb34bbaf8902ac0a4c70b2583ce16c3e))
 - Save board display options ([fd943ae](https://github.com/horizon-eda/horizon/commit/fd943aeddb34bbaf8902ac0a4c70b2583ce16c3e))
 - Increase 3D model offset range to ±1000 mm ([fd943ae](https://github.com/horizon-eda/horizon/commit/fd943aeddb34bbaf8902ac0a4c70b2583ce16c3e))
 - Edit via tool can edit multiple vias at once ([fd943ae](https://github.com/horizon-eda/horizon/commit/fd943aeddb34bbaf8902ac0a4c70b2583ce16c3e))
 - Move project metadata such as title and author to netlist rather than having them in schematic and project file ([ef6f647](https://github.com/horizon-eda/horizon/commit/ef6f647282f759d11ee66ed86f1e103ff3fd3e2b))
 - Show name of current document in interactive manipulator window title for pool items ([72e4eec](https://github.com/horizon-eda/horizon/commit/72e4eeca2c5374e440d82a492c573a5b3e09aaed))
 - Show project title in window title of project manager, schematic and board interactive manipulator ([71e69cc](https://github.com/horizon-eda/horizon/commit/71e69ccf0713ec92504f0a93d7241b08eabf9940))
 - Show package in component head-up display ([6214fa1](https://github.com/horizon-eda/horizon/commit/6214fa1c6d90ab35bfb7f343be0e84285fd23603))
 - Support degree sign (U+00B0) in texts ([5875829](https://github.com/horizon-eda/horizon/commit/587582958876ef160f6866aaac04bc515a1f073d))
 - Support plus/minus sign (U+00B1) in texts ([3f90d8f](https://github.com/horizon-eda/horizon/commit/3f90d8f6503ced3f73d37c6a19b251d4c07de060))
 - Show status of selection filter, airwire filter and flipped view in status bar ([162a679](https://github.com/horizon-eda/horizon/commit/162a6793302870ae84c5f66fb1e3b6c8002a5270))
 - Make URLs in text clickable in head-up display ([6fd2652](https://github.com/horizon-eda/horizon/commit/6fd26526f170eee3f52c06a6a5e36a1d0e8eba7d))
 - Support for mirroring/rotating around cursor in move tool ([455599e](https://github.com/horizon-eda/horizon/commit/455599e7fa696cedd4bb68cb51ff448ca95ba7c2))
 - Search for MPNs and pin/pad names ([819687c](https://github.com/horizon-eda/horizon/commit/819687c46b466a3621cf6c4ffc9b7fa98ae564ee))
 - Support circular renumbering in renumber pads tool ([6626585](https://github.com/horizon-eda/horizon/commit/6626585e14c147c9897dafc7426f8a4c85b115e0))
 - Place pin tool can place all remaining pins at once ([97540ca](https://github.com/horizon-eda/horizon/commit/97540cac0ce71fd23438de45bfe9da97e4a4ff54))
 - Place pin tool shows preview of next autoplaced pin ([8e5335f](https://github.com/horizon-eda/horizon/commit/8e5335f2ea242040a13bc10795d62ba4e2a2da64))
 - Show pin bounding box in symbol interactive manipulator ([24a8f4b](https://github.com/horizon-eda/horizon/commit/24a8f4be5a340825a35d71a37609999c0cbe0828))
 - Selection filter dialog can be closed by escape key ([c2b169c](https://github.com/horizon-eda/horizon/commit/c2b169c48f7ffffb672a48e15bd7951bafbb569c))
 - Add context menu to recent pools and projects for opening in file browser and deleting ([040bdc7](https://github.com/horizon-eda/horizon/commit/040bdc7ae6354b85b69a89d26bfcbaa600ec4e1a))
 - Only enable export buttons if all filenames are provided ([eb2698b](https://github.com/horizon-eda/horizon/commit/eb2698bb55bff8605d53eeb6ea97b7e5e86e4f7f), [04de328](https://github.com/horizon-eda/horizon/commit/04de32871dfbbfd3af3f7d2185082d3d206da7f0), [b3b51a7](https://github.com/horizon-eda/horizon/commit/b3b51a7219390ef27a9994e64c4adcff418772c4), [2325742](https://github.com/horizon-eda/horizon/commit/2325742cacfbc9f392c301b5d8ac10d1eb9cc066), [9ac1c59](https://github.com/horizon-eda/horizon/commit/9ac1c59b2268888dc9dd6f4871064d87a5a7d917))
 - Copy paste for bus labels and bus rippers in a schematic ([3cc5375](https://github.com/horizon-eda/horizon/commit/3cc5375b98012d94cb99fffb15e2831b009ffa79))
 - Make lists in git tab sortable ([ed27677](https://github.com/horizon-eda/horizon/commit/ed2767709b670311697339343fdb96f0c5e26b21))
 - Courtyard generated by IPC footprint generator has `courtyard` parameter class ([fa9b793](https://github.com/horizon-eda/horizon/commit/fa9b793220ab053446fb6e27f61f2f73f3a05377))
 - Use tabular figures in STEP export window's progress view ([2a5cc95](https://github.com/horizon-eda/horizon/commit/2a5cc956f5e454e99af783c115aa8526a76c5dd0))
 - Improve typesetting in dimension inputs ([058fdb8](https://github.com/horizon-eda/horizon/commit/058fdb8d9a0305f88b22d6aa2c8e6b9c0c00656b))
 - Export STEP from python module ([ea5e8b2](https://github.com/horizon-eda/horizon/commit/ea5e8b2c780ab8e5b138efe468f2a664ffc30c64))
 - Support `file://` schema in Links ([fedc6f6](https://github.com/horizon-eda/horizon/commit/fedc6f6ef2a4c92bac5f4398ea376230f1c29e91))
 - Add "Work layer only" checkbox to selection filter dialog ([e464ec4](https://github.com/horizon-eda/horizon/commit/e464ec4b6266d2a0ff835af8db57cfd7b817a18f))

## Bugfixes

 - Fix copy placement tool for packages on the bottom side ([53f3ac4](https://github.com/horizon-eda/horizon/commit/53f3ac46b30d63e4d630c37bdfd1584bc849e7b7))
 - Properly escape project/pool title in recent chooser ([7777ada](https://github.com/horizon-eda/horizon/commit/7777adaed0987d524bba0f0371ef78e3ea2aa53f))
 - Fix crash when autoconnecting more than one pin per symbol ([e0567f2](https://github.com/horizon-eda/horizon/commit/e0567f2513244b503f7662cf57c20de9895a3a4b)
 - Reduce idle CPU usage in 3D preview ([162a679](https://github.com/horizon-eda/horizon/commit/162a6793302870ae84c5f66fb1e3b6c8002a5270))
 - Don't crash when encountering layer not found in layer display settings ([c11c6d9](https://github.com/horizon-eda/horizon/commit/c11c6d9d0e817fad71a80e01698a95aa1c0aa855))
 - Always remove autosaved files when exiting cleanly ([ba881b8](https://github.com/horizon-eda/horizon/commit/ba881b8fa0c3a4b2b319a02cbe38ea89f6fce008))
 - Avoid superfluous line breaks in head-up display ([5f90eaa](https://github.com/horizon-eda/horizon/commit/5f90eaae0ef3d31248a736a69133524822115e00))
 - Increase interactive manipulator to project manager socket timeout to 5 seconds to prevent socket breakage on slow machines ([ec08ec7](https://github.com/horizon-eda/horizon/commit/ec08ec7346c70db83221175e885202a9ed420cda))
 - Fix windows not getting raised on X11 and wayland when switching between project manager and interactive manipulator ([50841e5](https://github.com/horizon-eda/horizon/commit/50841e572f025c6263bffef30ce5750d0d52f932))
 - Make it possible to select polygon vertices by hover select ([3c86273](https://github.com/horizon-eda/horizon/commit/3c86273bfd84f717e9e68bff3d9f6fe4402fe002))
 - Don't smash silkscreen again if it's already omitted ([11a4c50](https://github.com/horizon-eda/horizon/commit/11a4c50c99bde77bb0da0bb21f5dc27686059e8a))
 - Delete smashed texts if package is gone during startup or netlist reload ([4f64739](https://github.com/horizon-eda/horizon/commit/4f64739468f4c20c1cd90e287e4245a7fd48ea8d))
 - Apply smooth zoom setting to all canvases ([025a46b](https://github.com/horizon-eda/horizon/commit/025a46bad0e92a77be3a67abfa41a8d2633da214), [1e6539a](https://github.com/horizon-eda/horizon/commit/1e6539a0202cd260f9560d75f979e892bb23cd2b))
 - Connect bipoles the right way round when placing them on a net line ([cf709a2](https://github.com/horizon-eda/horizon/commit/cf709a230279e2648b3434b5bde5e534f8c9925c))
 - Use WAL mode for pool databases to prevent crashes due to locked database ([4cfbe5c](https://github.com/horizon-eda/horizon/commit/4cfbe5c200a857571c593e94577bbd8fb9a7342b))
 - Automatically set window title for export file choosers based on action ([24281f3](https://github.com/horizon-eda/horizon/commit/24281f3b3b19965507e7ec6c3285a79f8cb3854a))
 - Copy/paste copies net lines attached to pins ([41c5d1e](https://github.com/horizon-eda/horizon/commit/41c5d1e117f017207c45ea802bdaff183fe69ce8))
 - Fix possible crash when copy/pasting diffpairs ([6534e8f](https://github.com/horizon-eda/horizon/commit/6534e8faebf38b8c5196dffbe73817b1fa879b3f))
 - Fix STEP export for too short slot holes ([9e3c594](https://github.com/horizon-eda/horizon/commit/9e3c59474e42fed87809f3e5d2d88544ef0c40d4))
 - Update property panels after undo/redo ([cb29541](https://github.com/horizon-eda/horizon/commit/cb29541418fb2546a3470b0d013729a61ff2b7df))
 - Use proper window title in open pool/project file chooser ([93998c0](https://github.com/horizon-eda/horizon/commit/93998c05983d17dfcb3ab63c3dc02c3fe9df6d05))
 - Fix selection preview in selection clarification menu on win32 ([db61b45](https://github.com/horizon-eda/horizon/commit/db61b4542b8f8abc51e29b50c0a9dac80f0b7e3d))
 - Fix focus passing from project manager to editor on win32 ([940aa17](https://github.com/horizon-eda/horizon/commit/940aa17dfa77869e5cbc37110b7302656b5f3998))

## Changed behavior

 - Deleting the last gate's symbol of a component in a schematic will automatically delete the entire component without the option to keep the component with no symbols visible ([f34e006](https://github.com/horizon-eda/horizon/commit/f34e006e7ddee06c1b4126611b9695c0d4498ef5))
 - Save interactive manipulator metadata such as layer visibility and grid spacing to a separate file such as `board.json.imp_meta` rather than to the board file itself ([bb1aa8c](https://github.com/horizon-eda/horizon/commit/bb1aa8c398f051d272c9576dbd783091e3a95a35))
 - Package interactive manipulator automatically deletes floating junctions and shows junctions only if selected ([acd5c44](https://github.com/horizon-eda/horizon/commit/acd5c4498f9c1d5ed4c16a0f43fba86d53bc87ad))
 - Actions in tool popover are activated with a single click rather than a double click ([576da12](https://github.com/horizon-eda/horizon/commit/576da12accf2176a836ed4634ae7feda8303efcd))

## Removals

 - `make all` doesn't include `horizon-pool` and `horizon-prj` ([12da19f](https://github.com/horizon-eda/horizon/commit/12da19f5e007891e2613015d35435c2df186b960))
 - Remove `crontab -e` style editors from `horizon-pool` ([2edd506](https://github.com/horizon-eda/horizon/commit/2edd5063f7ed4e474f22f99f6a579a4375757057))

## Misc

 - Refactor core ([fd943ae](https://github.com/horizon-eda/horizon/commit/fd943aeddb34bbaf8902ac0a4c70b2583ce16c3e))
 - Factor out search from core ([819687c](https://github.com/horizon-eda/horizon/commit/819687c46b466a3621cf6c4ffc9b7fa98ae564ee))
 - Make board rebuild a bit faster by storing a shallow copy (no expanded packages) of the board rather than a json serialisation for undo/redo ([0ffb118](https://github.com/horizon-eda/horizon/commit/0ffb11885a8176c1265d9cafafa3360ecb5721d4))
 - Make mesh generation for 3D preview independent of UI ([005ed87](https://github.com/horizon-eda/horizon/commit/005ed87d1fcef6bbedddf1f2cfe057642316d0c4))

# Version 1.0.0

No change log since this is the first versioned release.
