

; TOP LEVEL DEFINITIONS

	TRUE-VALUE=1
	FALSE-VALUE=0

	O?ANY=1

	PS?OBJECT=128
	PS?VERB=64
	PS?ADJECTIVE=32
	PS?DIRECTION=16
	PS?PREPOSITION=8
	PS?BUZZ-WORD=4

	P1?NONE=0
	P1?OBJECT=0
	P1?VERB=1
	P1?ADJECTIVE=2
	P1?DIRECTION=3


; OBJECT FLAGS ARE DEFINED HERE


	NONLANDBIT=1
	FX?NONLANDBIT=16384

	SACREDBIT=2
	FX?SACREDBIT=8192

	WEARBIT=3
	FX?WEARBIT=4096

	STAGGERED=4
	FX?STAGGERED=2048

	FIGHTBIT=5
	FX?FIGHTBIT=1024

	TRANSBIT=6
	FX?TRANSBIT=512

	SEARCHBIT=7
	FX?SEARCHBIT=256

	SURFACEBIT=8
	FX?SURFACEBIT=128

	TOUCHBIT=9
	FX?TOUCHBIT=64

	INVISIBLE=10
	FX?INVISIBLE=32

	OPENBIT=11
	FX?OPENBIT=16

	RLANDBIT=12
	FX?RLANDBIT=8

	TRYTAKEBIT=13
	FX?TRYTAKEBIT=4

	NDESCBIT=14
	FX?NDESCBIT=2

	TURNBIT=15
	FX?TURNBIT=1

	READBIT=16
	FX?READBIT=32768

	TAKEBIT=17
	FX?TAKEBIT=16384

	CONTBIT=18
	FX?CONTBIT=8192

	ONBIT=19
	FX?ONBIT=4096

	FOODBIT=20
	FX?FOODBIT=2048

	DRINKBIT=21
	FX?DRINKBIT=1024

	DOORBIT=22
	FX?DOORBIT=512

	CLIMBBIT=23
	FX?CLIMBBIT=256

	RMUNGBIT=24
	FX?RMUNGBIT=128

	FLAMEBIT=25
	FX?FLAMEBIT=64

	BURNBIT=26
	FX?BURNBIT=32

	VEHBIT=27
	FX?VEHBIT=16

	TOOLBIT=28
	FX?TOOLBIT=8

	WEAPONBIT=29
	FX?WEAPONBIT=4

	ACTORBIT=30
	FX?ACTORBIT=2

	LIGHTBIT=31
	FX?LIGHTBIT=1

; ACTION IDENTIFIERS ARE ASSIGNED HERE

	V?VERBOSE=0
	V?BRIEF=1
	V?SUPER-BRIEF=2
	V?DIAGNOSE=3
	V?INVENTORY=4
	V?QUIT=5
	V?RESTART=6
	V?RESTORE=7
	V?SAVE=8
	V?SCORE=9
	V?SCRIPT=10
	V?UNSCRIPT=11
	V?VERSION=12
	V?VERIFY=13
	V?RANDOM=14
	V?COMMAND-FILE=15
	V?RECORD=16
	V?UNRECORD=17
	V?LAMP-ON=18
	V?ANSWER=19
	V?REPLY=20
	V?PUT=21
	V?ATTACK=22
	V?BACK=23
	V?BLAST=24
	V?LAMP-OFF=25
	V?INFLATE=26
	V?BREATHE=27
	V?BOARD=28
	V?BRUSH=29
	V?BUG=30
	V?BURN=31
	V?CHOMP=32
	V?CLIMB-UP=33
	V?CLIMB-DOWN=34
	V?CLIMB-FOO=35
	V?CLIMB-ON=36
	V?THROUGH=37
	V?CLOSE=38
	V?COMMAND=39
	V?COUNT=40
	V?CROSS=41
	V?CUT=42
	V?CURSES=43
	V?DEFLATE=44
	V?MUNG=45
	V?OPEN=46
	V?DIG=47
	V?DISEMBARK=48
	V?DISENCHANT=49
	V?DRINK=50
	V?DRINK-FROM=51
	V?DROP=52
	V?PUT-ON=53
	V?EAT=54
	V?ECHO=55
	V?ENCHANT=56
	V?ENTER=57
	V?EXIT=58
	V?EXAMINE=59
	V?LOOK-INSIDE=60
	V?EXORCISE=61
	V?FILL=62
	V?FIND=63
	V?FOLLOW=64
	V?FROBOZZ=65
	V?GIVE=66
	V?SGIVE=67
	V?HATCH=68
	V?HELLO=69
	V?INCANT=70
	V?LEAP=71
	V?KICK=72
	V?STAB=73
	V?KISS=74
	V?KNOCK=75
	V?LAUNCH=76
	V?LEAN-ON=77
	V?LEAVE=78
	V?LISTEN=79
	V?LOCK=80
	V?LOOK=81
	V?LOOK-ON=82
	V?LOOK-UNDER=83
	V?LOOK-BEHIND=84
	V?READ=85
	V?LOWER=86
	V?OIL=87
	V?MAKE=88
	V?MELT=89
	V?MOVE=90
	V?PUSH-TO=91
	V?TURN=92
	V?MUMBLE=93
	V?ODYSSEUS=94
	V?PICK=95
	V?TAKE=96
	V?PLAY=97
	V?PLUG=98
	V?ADVENT=99
	V?POUR-ON=100
	V?PRAY=101
	V?PUMP=102
	V?PUSH=103
	V?PUT-UNDER=104
	V?WEAR=105
	V?PUT-BEHIND=106
	V?RAISE=107
	V?RAPE=108
	V?READ-PAGE=109
	V?REPENT=110
	V?RING=111
	V?RUB=112
	V?TELL=113
	V?SAY=114
	V?SEARCH=115
	V?SEND=116
	V?SHAKE=117
	V?SKIP=118
	V?SMELL=119
	V?SPIN=120
	V?SPRAY=121
	V?SSPRAY=122
	V?SQUEEZE=123
	V?STAND=124
	V?STAY=125
	V?STRIKE=126
	V?SWIM=127
	V?SWING=128
	V?THROW=129
	V?OVERBOARD=130
	V?THROW-OFF=131
	V?TIE=132
	V?TIE-UP=133
	V?TREASURE=134
	V?UNLOCK=135
	V?UNTIE=136
	V?WAIT=137
	V?ALARM=138
	V?WALK-AROUND=139
	V?WALK=140
	V?WALK-TO=141
	V?WAVE=142
	V?WIN=143
	V?WIND=144
	V?WISH=145
	V?YELL=146
	V?ZORK=147

; PROPERTIES ARE DEFINED HERE

	P?NORTH=31
	P?EAST=30
	P?WEST=29
	P?SOUTH=28
	P?NE=27
	P?NW=26
	P?SE=25
	P?SW=24
	P?UP=23
	P?DOWN=22
	P?IN=21
	P?OUT=20
	P?LAND=19
	P?CROSS=18
	P?SYNONYM=17
	P?ADJECTIVE=16
	P?ACTION=15
	P?LDESC=14
	P?SIZE=13
	P?FDESC=12
	P?VALUE=11
	P?GLOBAL=10
	P?TEXT=9
	P?CAPACITY=8
	P?ENTER=7
	P?PSEUDO=6
	P?DESCFCN=5
	P?ADVFCN=4
	P?CONTFCN=3
	P?VTYPE=2
	P?STRENGTH=1

; ADJECTIVES ARE DEFINED HERE

	A?ROCKY=255
	A?DEEP=254
	A?DARK=253
	A?SMOKY=252
	A?EAST=251
	A?EASTERN=250
	A?SOUTH=249
	A?SOUTHE=248
	A?WEST=247
	A?WESTERN=246
	A?NORTH=245
	A?NORTHE=244
	A?BROKEN=243
	A?BRASS=242
	A?ELVISH=241
	A?OLD=240
	A?ANTIQUE=239
	A?WARNING=238
	A?SMALL=237
	A?STEEL=236
	A?METAL=235
	A?LORE=234
	A?STRANGE=233
	A?COMPASS=232
	A?DUNGEON=231
	A?STONE=230
	A?WOOD=229
	A?WOODEN=228
	A?CARVED=227
	A?BLACK=226
	A?BRONZE=225
	A?CELL=224
	A?LARGE=223
	A?LOCKED=222
	A?LONG=221
	A?CENTER=220
	A?MAHOGANY=219
	A?FIERY=218
	A?FLAMING=217
	A?PINE=216
	A?RED=215
	A?SHORT=214
	A?HAND=213
	A?INDICATOR=212
	A?SUN=211
	A?YELLOW=210
	A?WHITE=209
	A?SECRET=208
	A?ROUND=207
	A?MARBLE=206
	A?FORBIDDING=205
	A?STEEP=204
	A?LURKING=203
	A?SINISTER=202
	A?HUNGRY=201
	A?SILENT=200
	A?FOREST=199
	A?NARROW=198
	A?WINDING=197
	A?BARE=196
	A?ARMED=195
	A?ROYAL=194
	A?TIME=193
	A?GOLD=192
	A?GOLDEN=191
	A?GRAY=190
	A?GREY=189
	A?WASHING=188
	A?HOLLOW=187
	A?IRON=186
	A?CROWN=185
	A?JEWELLED=184
	A?HOODED=183
	A?CLOAKED=182
	A?SICKLY=181
	A?VIEWING=180
	A?BURNED=179
	A?DEAD=178
	A?MASSIVE=177
	A?SHINY=176
	A?WIDE=175
	A?WAY=174
	A?FRESH=173
	A?DANGLING=172
	A?TALL=171
	A?ASSORTED=170
	A?RICKETY=169
	A?GRUE=168
	A?MAGIC=167
	A?WATER=166
	A?MANHOLE=165
	A?RUSTY=164
	A?HEAVY=163
	A?THIN=162
	A?SHARP=161
	A?POINTED=160
	A?VIKING=159
	A?SWEET=158
	A?INVISIBLE=157
	A?SMELLING=156
	A?FLATHEAD=155
	A?GREAT=154

; BUZZ WORDS ARE DEFINED HERE

	B?AGAIN=255
	B?G=254
	B?OOPS=253
	B?A=252
	B?AN=251
	B?THE=250
	B?IS=249
	B?AND=248
	B?OF=247
	B?THEN=246
	B?ALL=245
	B?ONE=244
	B?BUT=243
	B?EXCEPT=242
	B?PERIOD=241
	B?COMMA=240
	B?QUOTE=239
	B?YES=238
	B?NO=237
	B?Y=236
	B?HERE=235
	B?FROTZ=234
	B?OZMOO=233

; PREPOSITIONS ARE DEFINED HERE

	PR?TO=255
	PR?WITH=254
	PR?OUT=253
	PR?UP=252
	PR?IN=251
	PR?DOWN=250
	PR?ON=249
	PR?FROM=248
	PR?AWAY=247
	PR?OVER=246
	PR?ACROSS=245
	PR?OFF=244
	PR?AT=243
	PR?FOR=242
	PR?AROUND=241
	PR?UNDER=240
	PR?BEHIND=239
	PR?ABOUT=238

; DIRECTIONS ARE DEFINED HERE


; ACTIONS ARE DEFINED HERE

	ACT?KISS=255
	ACT?SKIP=254
	ACT?INFLAT=253
	ACT?STAY=252
	ACT?PULL=251
	ACT?PUT=250
	ACT?RAPE=249
	ACT?VERBOSE=248
	ACT?WALK=247
	ACT?QUIT=246
	ACT?FIND=245
	ACT?DESTROY=244
	ACT?UNLOCK=243
	ACT?READ=242
	ACT?SAY=241
	ACT?PUNCTURE=240
	ACT?JUMP=239
	ACT?POUR=238
	ACT?WAIT=237
	ACT?TAKE=236
	ACT?COUNT=235
	ACT?RAISE=234
	ACT?FOLLOW=233
	ACT?VERSION=232
	ACT?WIND=231
	ACT?#UNRECORD=230
	ACT?LIGHT=229
	ACT?MOVE=228
	ACT?CHOMP=227
	ACT?PLAY=226
	ACT?OPEN=225
	ACT?#COMMAND=224
	ACT?BLOW=223
	ACT?KNOCK=222
	ACT?PICK=221
	ACT?DEFLATE=220
	ACT?BOARD=219
	ACT?#RANDOM=218
	ACT?APPLY=217
	ACT?PRAY=216
	ACT?STAND=215
	ACT?ENCHANT=214
	ACT?LISTEN=213
	ACT?TIE=212
	ACT?SAVE=211
	ACT?TELL=210
	ACT?THROW=209
	ACT?ZORK=208
	ACT?LOWER=207
	ACT?COMMAND=206
	ACT?TALK=205
	ACT?SHAKE=204
	ACT?INVENTORY=203
	ACT?ATTACK=202
	ACT?KILL=201
	ACT?ENTER=200
	ACT?SEARCH=199
	ACT?WEAR=198
	ACT?FROBOZZ=197
	ACT?DISEMBARK=196
	ACT?SWIM=195
	ACT?LUBRICATE=194
	ACT?PLUG=193
	ACT?UNTIE=192
	ACT?PUMP=191
	ACT?CUT=190
	ACT?UNSCRIPT=189
	ACT?MELT=188
	ACT?BRUSH=187
	ACT?RING=186
	ACT?PUSH=185
	ACT?RUB=184
	ACT?SUPER=183
	ACT?BLAST=182
	ACT?DIG=181
	ACT?WISH=180
	ACT?INCANT=179
	ACT?SEND=178
	ACT?SCORE=177
	ACT?EXORCISE=176
	ACT?HATCH=175
	ACT?WIN=174
	ACT?LOOK=173
	ACT?ODYSSEUS=172
	ACT?SPRAY=171
	ACT?DROP=170
	ACT?BACK=169
	ACT?ROLL=168
	ACT?LEAVE=167
	ACT?CURSE=166
	ACT?SCRIPT=165
	ACT?REPENT=164
	ACT?SPIN=163
	ACT?$VERIFY=162
	ACT?EXTINGUISH=161
	ACT?SWING=160
	ACT?RESTART=159
	ACT?POKE=158
	ACT?SMELL=157
	ACT?BRIEF=156
	ACT?ECHO=155
	ACT?DIAGNOSE=154
	ACT?GIVE=153
	ACT?WAKE=152
	ACT?DRINK=151
	ACT?ANSWER=150
	ACT?MUMBLE=149
	ACT?YELL=148
	ACT?LOCK=147
	ACT?ACTIVATE=146
	ACT?BURN=145
	ACT?KICK=144
	ACT?PLUGH=143
	ACT?TURN=142
	ACT?#RECORD=141
	ACT?CROSS=140
	ACT?STAB=139
	ACT?MAKE=138
	ACT?RESTORE=137
	ACT?CLOSE=136
	ACT?STRIKE=135
	ACT?SLIDE=134
	ACT?WAVE=133
	ACT?EXIT=132
	ACT?EXAMINE=131
	ACT?DISENCHANT=130
	ACT?EAT=129
	ACT?FILL=128
	ACT?LEAN=127
	ACT?SQUEEZE=126
	ACT?BUG=125
	ACT?CLIMB=124
	ACT?LAUNCH=123
	ACT?TREASURE=122
	ACT?HELLO=121

; USER DEFINED CONSTANTS ARE INITIALIZED HERE

	SOG=16
	SIR=32
	DEXITSTR=1
	XEQUAL?=4
	P-ITBLLEN=9
	P-SYNLEN=8
	P-SRCTOP=0
	C-INTLEN=6
	O-START=1
	DEXITOBJ=1
	P-P1OFF=5
	O-PTR=0
	O-LENGTH=2
	C-TABLELEN=180
	P-NC2=8
	P-NC1=6
	P-WORDLEN=4
	SERIAL=0
	P-VERBN=1
	P-P1BITS=3
	FEXIT=3
	CC-SEPTR=1
	ZORKID=1
	P-SPREP1=1
	GCARDLOC=168
	CC-SBPTR=0
	P-PREP1=2
	M-BEG=1
	XDIV=3
	M-FATAL=2
	REAL-YEAR-CLOSED=883
	XGRTR?=5
	NEXITSTR=0
	P-SLOC2=6
	NEXIT=2
	SC=64
	P-PREP1N=3
	P-PSOFF=4
	XLESS?=6
	P-VERB=0
	M-HANDLED=1
	M-ENTER=2
	CC-DEPTR=3
	SHAVE=2
	DEXIT=5
	P-SRCBOT=2
	M-OBJDESC=5
	CC-DBPTR=2
	SMANY=4
	STAKE=8
	P-SPREP2=2
	XSUB=1
	XADD=0
	CEXIT=4
	P-LEXSTART=1
	M-LOOK=3
	UEXIT=1
	O-END=3
	P-LEXELEN=2
	P-LEXWORDS=1
	P-ALL=1
	XMUL=2
	P-SFWIM1=3
	P-INHIBIT=4
	CEXITFLAG=1
	YEAR-PRESENT=948
	M-FLASH=4
	YEAR-BUILT=776
	M-OBJECT=0
	FEXITFCN=0
	P-SBITS=0
	M-NOT-HANDLED=0
	P-SRCALL=1
	CEXITSTR=1
	P-SLOC1=5
	M-END=6
	P-PREP2=4
	LOW-DIRECTION=18
	P-SONUMS=3
	C-TICK=1
	P-NC2L=9
	P-NC1L=7
	P-ONE=2
	YEAR-CAGED=777
	P-SACTION=7
	P-PREP2N=5
	P-SFWIM2=4
	C-ENABLED?=0
	REXIT=0
	SH=128
	C-RTN=2

; PROPERTY DEFAULTS AND OBJECTS ARE DEFINED HERE

OBJECT::.TABLE 
	0			;(P?STRENGTH)
	0			;(P?VTYPE)
	0			;(P?CONTFCN)
	0			;(P?ADVFCN)
	0			;(P?DESCFCN)
	0			;(P?PSEUDO)
	0			;(P?ENTER)
	0			;(P?CAPACITY)
	0			;(P?TEXT)
	0			;(P?GLOBAL)
	0			;(P?VALUE)
	0			;(P?FDESC)
	5			;(P?SIZE)
	0			;(P?LDESC)
	0			;(P?ACTION)
	0			;(P?ADJECTIVE)
	0			;(P?SYNONYM)
	0			;(P?CROSS)
	0			;(P?LAND)
	0			;(P?OUT)
	0			;(P?IN)
	0			;(P?DOWN)
	0			;(P?UP)
	0			;(P?SW)
	0			;(P?SE)
	0			;(P?NW)
	0			;(P?NE)
	0			;(P?SOUTH)
	0			;(P?WEST)
	0			;(P?EAST)
	0			;(P?NORTH)
	.OBJECT DUNGEON-MASTER,0,FX?ACTORBIT,BEHIND-DOOR,0,0,T?DUNGEON-MASTER
	.OBJECT SHORT-POLE,FX?NDESCBIT,0,IN-MIRROR,RED-PANEL,0,T?SHORT-POLE
	.OBJECT VIEW-INDICATOR,FX?NDESCBIT,FX?READBIT,VIEW-ROOM,TORCH,0,T?VIEW-INDICATOR
	.OBJECT FLAMING-PIT,FX?NDESCBIT,0,LOCAL-GLOBALS,LOCKED-DOOR,0,T?FLAMING-PIT
	.OBJECT MID-TECH-MUSEUM,FX?RLANDBIT,FX?ONBIT,ROOMS,MID-JEWEL-ROOM,0,T?MID-TECH-MUSEUM
	.OBJECT MREYE,FX?RLANDBIT,FX?ONBIT,ROOMS,MR-ANTE,BEAM,T?MREYE
	.OBJECT GLOBAL-WATER,0,FX?DRINKBIT,LOCAL-GLOBALS,CHASM,0,T?GLOBAL-WATER
	.OBJECT MRDW,FX?RLANDBIT,FX?ONBIT,ROOMS,MRDE,0,T?MRDW
	.OBJECT HANDS,FX?NDESCBIT,FX?TOOLBIT,GLOBAL-OBJECTS,ZORKMID,0,T?HANDS
	.OBJECT CAGE,FX?SURFACEBIT+FX?OPENBIT+FX?NDESCBIT,FX?CONTBIT,JEWEL-ROOM,PEDESTAL,PLAQUE,T?CAGE
	.OBJECT MASTER,0,FX?ACTORBIT,LOCAL-GLOBALS,ROSE,0,T?MASTER
	.OBJECT IN-LAKE,FX?NONLANDBIT+FX?RLANDBIT,FX?ONBIT,ROOMS,ON-LAKE,SHINY-OBJECT,T?IN-LAKE
	.OBJECT KEY,0,FX?TAKEBIT,KEY-ROOM,COVER,0,T?KEY
	.OBJECT RUBBLE,FX?NDESCBIT,0,LOCAL-GLOBALS,0,0,T?RUBBLE
	.OBJECT TIMBER-ROOM,FX?RLANDBIT,0,ROOMS,DEAD-END-5,TIMBERS,T?TIMBER-ROOM
	.OBJECT MID-JEWEL-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,MID-MUSEUM-ENTRANCE,0,T?MID-JEWEL-ROOM
	.OBJECT VIEWING-TABLE,FX?NDESCBIT,0,VIEW-ROOM,0,0,T?VIEWING-TABLE
	.OBJECT TORCH,0,FX?FLAMEBIT+FX?ONBIT+FX?TAKEBIT+FX?LIGHTBIT,VIEW-ROOM,VIEWING-TABLE,0,T?TORCH
	.OBJECT NORTH-CORRIDOR,FX?RLANDBIT,FX?ONBIT,ROOMS,FRONT-DOOR,0,T?NORTH-CORRIDOR
	.OBJECT LADDER-TOP,FX?RLANDBIT,0,ROOMS,VIEW-ROOM,0,T?LADDER-TOP
	.OBJECT VOICES,FX?NDESCBIT,0,GLOBAL-OBJECTS,HANDS,0,T?VOICES
	.OBJECT VIAL,0,FX?CONTBIT+FX?TAKEBIT,0,0,POTION,T?VIAL
	.OBJECT SHADOW-5,FX?RLANDBIT,0,ROOMS,SHADOW-4,0,T?SHADOW-5
	.OBJECT ME,0,FX?ACTORBIT,GLOBAL-OBJECTS,LUNGS,0,T?ME
	.OBJECT TM-HOLLOW,FX?OPENBIT+FX?NDESCBIT,FX?CONTBIT,TIME-MACHINE,TM-BUTTON,0,T?TM-HOLLOW
	.OBJECT VALUABLES,FX?NDESCBIT,FX?TAKEBIT,MAN,0,0,T?VALUABLES
	.OBJECT BEAM,FX?OPENBIT+FX?NDESCBIT,FX?CONTBIT,MREYE,0,0,T?BEAM
	.OBJECT OLD-MUSEUM-ENTRANCE,FX?RLANDBIT,FX?ONBIT,ROOMS,OLD-JEWEL-ROOM,0,T?OLD-MUSEUM-ENTRANCE
	.OBJECT PANEL,0,0,LOCAL-GLOBALS,MIRROR,0,T?PANEL
	.OBJECT SHADOW-1,FX?RLANDBIT,0,ROOMS,CREEPY-CRAWL,0,T?SHADOW-1
	.OBJECT LEDGE,FX?NDESCBIT,0,LOCAL-GLOBALS,LAKE,0,T?LEDGE
	.OBJECT RUNES,FX?NDESCBIT,FX?READBIT,MSTAIRS,0,0,T?RUNES
	.OBJECT INTDIR,0,FX?TOOLBIT,GLOBAL-OBJECTS,CPLADDER,0,T?INTDIR
	.OBJECT ROOMS,0,0,0,0,AQ-3,T?ROOMS
	.OBJECT ADVENTURER,FX?SACREDBIT+FX?INVISIBLE+FX?NDESCBIT,FX?ACTORBIT,0,0,0,T?ADVENTURER
	.OBJECT PARAPET,FX?RLANDBIT,FX?ONBIT,ROOMS,NORTH-CORRIDOR,SUNDIAL,T?PARAPET
	.OBJECT MAHOGANY-PANEL,FX?NDESCBIT,0,IN-MIRROR,LONG-POLE,0,T?MAHOGANY-PANEL
	.OBJECT ROYAL-SEAL,FX?NDESCBIT,FX?READBIT,WIDE-HALL,0,0,T?ROYAL-SEAL
	.OBJECT KEY-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,DARK-2,KEY,T?KEY-ROOM
	.OBJECT TIGHT-SQUEEZE,FX?RLANDBIT,0,ROOMS,NIRVANA,0,T?TIGHT-SQUEEZE
	.OBJECT LOCAL-GLOBALS,0,0,GLOBAL-OBJECTS,INTDIR,FISH,T?LOCAL-GLOBALS
	.OBJECT CPEWL,FX?NDESCBIT,0,LOCAL-GLOBALS,CPDOOR,0,T?CPEWL
	.OBJECT EAST-CORRIDOR,FX?RLANDBIT,FX?ONBIT,ROOMS,DAMP-PASSAGE,0,T?EAST-CORRIDOR
	.OBJECT MRG,FX?RLANDBIT,FX?ONBIT,ROOMS,MRD,0,T?MRG
	.OBJECT CELL,FX?RLANDBIT,FX?ONBIT,ROOMS,PARAPET,0,T?CELL
	.OBJECT NIRVANA,FX?RLANDBIT,FX?ONBIT,ROOMS,GOOD-CELL,0,T?NIRVANA
	.OBJECT ROPE,FX?TRYTAKEBIT+FX?NDESCBIT,0,CLIFF,WAYBREAD,0,T?ROPE
	.OBJECT MRGW,FX?RLANDBIT,FX?ONBIT,ROOMS,MRGE,0,T?MRGW
	.OBJECT GLOBAL-OBJECTS,FX?WEARBIT+FX?STAGGERED+FX?FIGHTBIT+FX?RLANDBIT+FX?TRANSBIT+FX?SEARCHBIT+FX?OPENBIT+FX?TRYTAKEBIT+FX?SURFACEBIT+FX?TOUCHBIT+FX?INVISIBLE,FX?ONBIT+FX?RMUNGBIT,0,0,OCEAN,T?GLOBAL-OBJECTS
	.OBJECT CRYSTALS,FX?NDESCBIT,0,ROCKY-ROOM,0,0,T?CRYSTALS
	.OBJECT MRAE,FX?RLANDBIT,FX?ONBIT,ROOMS,MRBW,0,T?MRAE
	.OBJECT WHITE-PANEL,FX?NDESCBIT,0,IN-MIRROR,YELLOW-PANEL,0,T?WHITE-PANEL
	.OBJECT IT,FX?TOUCHBIT+FX?NDESCBIT,0,GLOBAL-OBJECTS,INTNUM,0,T?IT
	.OBJECT MRC,FX?RLANDBIT,FX?ONBIT,ROOMS,MRG,0,T?MRC
	.OBJECT CREEPY-CRAWL,FX?RLANDBIT,0,ROOMS,OLD-MUSEUM-ENTRANCE,0,T?CREEPY-CRAWL
	.OBJECT PATHOBJ,FX?NDESCBIT,0,GLOBAL-OBJECTS,ME,0,T?PATHOBJ
	.OBJECT LADDER-BOTTOM,FX?RLANDBIT,0,ROOMS,LADDER-TOP,0,T?LADDER-BOTTOM
	.OBJECT MRCW,FX?RLANDBIT,FX?ONBIT,ROOMS,MRCE,0,T?MRCW
	.OBJECT CLOAK,FX?WEARBIT+FX?TRYTAKEBIT+FX?NDESCBIT,FX?TAKEBIT,SHADOW,HOOD,0,T?CLOAK
	.OBJECT DIAL-BUTTON,FX?NDESCBIT,0,PARAPET,0,0,T?DIAL-BUTTON
	.OBJECT PEDESTAL,FX?SURFACEBIT+FX?OPENBIT+FX?NDESCBIT,FX?CONTBIT,JEWEL-ROOM,0,RING,T?PEDESTAL
	.OBJECT PINE-PANEL,FX?NDESCBIT,0,IN-MIRROR,MAHOGANY-PANEL,0,T?PINE-PANEL
	.OBJECT SHADOW-6,FX?RLANDBIT,0,ROOMS,SHADOW-5,0,T?SHADOW-6
	.OBJECT FOGGY-ROOM,FX?RLANDBIT,0,ROOMS,CLIFF-LEDGE,0,T?FOGGY-ROOM
	.OBJECT CHEST,0,FX?CONTBIT+FX?TAKEBIT,CLIFF-LEDGE,0,0,T?CHEST
	.OBJECT OLD-TECH-MUSEUM,FX?RLANDBIT,FX?ONBIT,ROOMS,MID-TECH-MUSEUM,0,T?OLD-TECH-MUSEUM
	.OBJECT REEDS,FX?NDESCBIT,0,FAR-SHORE,0,0,T?REEDS
	.OBJECT LADDER,FX?NDESCBIT,FX?CLIMBBIT,LOCAL-GLOBALS,GLOBAL-MAN,0,T?LADDER
	.OBJECT SHADOW-2,FX?RLANDBIT,0,ROOMS,SHADOW-1,0,T?SHADOW-2
	.OBJECT MACHINE-ROOM,FX?RLANDBIT,0,ROOMS,LOWER-SHAFT,0,T?MACHINE-ROOM
	.OBJECT WATER-CHANNEL,0,0,LOCAL-GLOBALS,AQUEDUCT,0,T?WATER-CHANNEL
	.OBJECT LOCKED-DOOR,FX?NDESCBIT,0,LOCAL-GLOBALS,GOOD-LOCKED-DOOR,0,T?LOCKED-DOOR
	.OBJECT CLIFF-BASE,FX?RLANDBIT,FX?ONBIT,ROOMS,SLOPE,0,T?CLIFF-BASE
	.OBJECT SOUTH-WALL,FX?NDESCBIT,0,GLOBAL-OBJECTS,EAST-WALL,0,T?SOUTH-WALL
	.OBJECT AQ-VIEW,FX?RLANDBIT,FX?ONBIT,ROOMS,LAKE-SHORE,0,T?AQ-VIEW
	.OBJECT TM-DIAL,FX?TURNBIT+FX?NDESCBIT,0,TIME-MACHINE,TM-SEAT,0,T?TM-DIAL
	.OBJECT LORE-BOOK,0,FX?READBIT+FX?TAKEBIT,0,0,0,T?LORE-BOOK
	.OBJECT SLOPE,FX?RLANDBIT,0,ROOMS,CLEARING,0,T?SLOPE
	.OBJECT ROBOT,0,0,LOCAL-GLOBALS,WOODEN-DOOR,0,T?ROBOT
	.OBJECT WOODEN-WALL,0,0,LOCAL-GLOBALS,CHANNEL,0,T?WOODEN-WALL
	.OBJECT ROCKY-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,TIGHT-SQUEEZE,CRYSTALS,T?ROCKY-ROOM
	.OBJECT WOODEN-DOOR,FX?OPENBIT,FX?CONTBIT+FX?DOORBIT,LOCAL-GLOBALS,JEWEL-DOOR,0,T?WOODEN-DOOR
	.OBJECT BROKEN-STAFF,0,FX?TAKEBIT,0,0,0,T?BROKEN-STAFF
	.OBJECT MID-CP-ANTE,FX?RLANDBIT,FX?ONBIT,ROOMS,TECH-MUSEUM,0,T?MID-CP-ANTE
	.OBJECT CPLADDER,0,0,GLOBAL-OBJECTS,NORTH-WALL,0,T?CPLADDER
	.OBJECT DEAD-END,FX?RLANDBIT,0,ROOMS,MSTAIRS,0,T?DEAD-END
	.OBJECT BLACK-PANEL,FX?NDESCBIT,0,IN-MIRROR,T-BAR,0,T?BLACK-PANEL
	.OBJECT SUNDIAL,FX?TURNBIT+FX?NDESCBIT,0,PARAPET,DIAL-BUTTON,0,T?SUNDIAL
	.OBJECT CLEFT,FX?INVISIBLE+FX?OPENBIT,FX?DOORBIT,LOCAL-GLOBALS,STAIRS,0,T?CLEFT
	.OBJECT AMULET,FX?NDESCBIT+FX?WEARBIT,FX?TAKEBIT,0,0,0,T?AMULET
	.OBJECT CHASM,FX?NDESCBIT,0,LOCAL-GLOBALS,RUBBLE,0,T?CHASM
	.OBJECT PRESSURIZER,0,0,TECH-MUSEUM,TIME-MACHINE,0,T?PRESSURIZER
	.OBJECT DAMP-PASSAGE,FX?RLANDBIT,0,ROOMS,DEAD-END,0,T?DAMP-PASSAGE
	.OBJECT FISH,FX?NDESCBIT,0,LOCAL-GLOBALS,MOSS,0,T?FISH
	.OBJECT TREE,FX?NDESCBIT,0,CLIFF,ROPE,0,T?TREE
	.OBJECT ROSE,0,0,LOCAL-GLOBALS,GUARDIAN,0,T?ROSE
	.OBJECT OLD-MAN,0,FX?ACTORBIT,0,0,0,T?OLD-MAN
	.OBJECT MR-ANTE,FX?RLANDBIT,FX?ONBIT,ROOMS,IN-MIRROR,RED-BUTTON,T?MR-ANTE
	.OBJECT WAYBREAD,0,FX?FOODBIT+FX?TAKEBIT,CLIFF,0,0,T?WAYBREAD
	.OBJECT MRDE,FX?RLANDBIT,FX?ONBIT,ROOMS,MRA,0,T?MRDE
	.OBJECT ZORKMID,0,0,GLOBAL-OBJECTS,PATHOBJ,0,T?ZORKMID
	.OBJECT LAKE-SHORE,FX?RLANDBIT,FX?ONBIT,ROOMS,FOGGY-ROOM,0,T?LAKE-SHORE
	.OBJECT JEWEL-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,MUSEUM-ENTRANCE,CAGE,T?JEWEL-ROOM
	.OBJECT CPWWL,FX?NDESCBIT,0,LOCAL-GLOBALS,CPEWL,0,T?CPWWL
	.OBJECT FRONT-DOOR,FX?RLANDBIT,FX?ONBIT,ROOMS,BEHIND-DOOR,0,T?FRONT-DOOR
	.OBJECT MIRROR,0,0,LOCAL-GLOBALS,MASTER,0,T?MIRROR
	.OBJECT CHANNEL,0,0,LOCAL-GLOBALS,PANEL,0,T?CHANNEL
	.OBJECT SAILOR,FX?NDESCBIT,0,GLOBAL-OBJECTS,BLESSINGS,0,T?SAILOR
	.OBJECT CLIFF,FX?RLANDBIT,FX?ONBIT,ROOMS,CLIFF-BASE,TREE,T?CLIFF
	.OBJECT SHADOW,FX?OPENBIT+FX?TRANSBIT,FX?CONTBIT+FX?ACTORBIT,0,0,CLOAK,T?SHADOW
	.OBJECT RING,FX?WEARBIT+FX?TRYTAKEBIT+FX?NDESCBIT,FX?TAKEBIT,PEDESTAL,JEWELLED-KNIFE,0,T?RING
	.OBJECT CLEARING,FX?RLANDBIT,0,ROOMS,JUNCTION,0,T?CLEARING
	.OBJECT MRB,FX?RLANDBIT,FX?ONBIT,ROOMS,MRC,0,T?MRB
	.OBJECT SAND,FX?NDESCBIT,0,IN-LAKE,0,0,T?SAND
	.OBJECT CPSWL,FX?NDESCBIT,0,LOCAL-GLOBALS,CPWWL,0,T?CPSWL
	.OBJECT WIDE-HALL,FX?RLANDBIT,0,ROOMS,ROCKY-ROOM,ROYAL-SEAL,T?WIDE-HALL
	.OBJECT CPDOOR,FX?NDESCBIT,0,LOCAL-GLOBALS,GLOBAL-WATER,0,T?CPDOOR
	.OBJECT DEBRIS,FX?NDESCBIT,0,GLOBAL-OBJECTS,0,0,T?DEBRIS
	.OBJECT MRBW,FX?RLANDBIT,FX?ONBIT,ROOMS,MRBE,0,T?MRBW
	.OBJECT TM-BUTTON,FX?NDESCBIT,0,TIME-MACHINE,0,0,T?TM-BUTTON
	.OBJECT TM-SEAT,FX?SURFACEBIT+FX?OPENBIT+FX?NDESCBIT,FX?CONTBIT,TIME-MACHINE,TM-HOLLOW,0,T?TM-SEAT
	.OBJECT TIME-MACHINE,FX?OPENBIT,FX?CONTBIT+FX?VEHBIT,TECH-MUSEUM,0,TM-DIAL,T?TIME-MACHINE
	.OBJECT SHADOW-7,FX?RLANDBIT,0,ROOMS,SHADOW-6,0,T?SHADOW-7
	.OBJECT VIEW-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,FAR-SHORE,VIEW-INDICATOR,T?VIEW-ROOM
	.OBJECT NORTH-WALL,FX?NDESCBIT,0,GLOBAL-OBJECTS,WEST-WALL,0,T?NORTH-WALL
	.OBJECT LAMP,0,FX?LIGHTBIT+FX?TAKEBIT,CP-ANTE,0,0,T?LAMP
	.OBJECT COMPASS-ARROW,FX?NDESCBIT,0,IN-MIRROR,BLACK-PANEL,0,T?COMPASS-ARROW
	.OBJECT BLESSINGS,FX?NDESCBIT,0,GLOBAL-OBJECTS,IT,0,T?BLESSINGS
	.OBJECT SHINY-OBJECT,FX?NDESCBIT+FX?TRYTAKEBIT,0,IN-LAKE,ALGAE,0,T?SHINY-OBJECT
	.OBJECT MID-CP-OUT,FX?RLANDBIT,FX?ONBIT,ROOMS,MID-CP-ANTE,0,T?MID-CP-OUT
	.OBJECT PLAQUE,FX?NDESCBIT,FX?READBIT,CAGE,0,0,T?PLAQUE
	.OBJECT SPINNER,0,0,TECH-MUSEUM,PRESSURIZER,0,T?SPINNER
	.OBJECT EAST-WALL,FX?NDESCBIT,0,GLOBAL-OBJECTS,TUNNEL,0,T?EAST-WALL
	.OBJECT SHADOW-3,FX?RLANDBIT,0,ROOMS,SHADOW-2,0,T?SHADOW-3
	.OBJECT COVER,FX?NDESCBIT,0,KEY-ROOM,0,0,T?COVER
	.OBJECT MUSEUM-ANTE,FX?RLANDBIT,0,ROOMS,WIDE-HALL,0,T?MUSEUM-ANTE
	.OBJECT GLOBAL-ROPE,0,0,LOCAL-GLOBALS,LEDGE,0,T?GLOBAL-ROPE
	.OBJECT DEAD-END-5,FX?RLANDBIT,0,ROOMS,LADDER-BOTTOM,0,T?DEAD-END-5
	.OBJECT MAN,FX?OPENBIT,FX?CONTBIT+FX?ACTORBIT,0,0,VALUABLES,T?MAN
	.OBJECT FAR-SHORE,FX?RLANDBIT,FX?ONBIT,ROOMS,IN-LAKE,REEDS,T?FAR-SHORE
	.OBJECT LUNGS,FX?NDESCBIT,0,GLOBAL-OBJECTS,GRUE,0,T?LUNGS
	.OBJECT WEST-WALL,FX?NDESCBIT,0,GLOBAL-OBJECTS,SOUTH-WALL,0,T?WEST-WALL
	.OBJECT CP-ANTE,FX?RLANDBIT,FX?ONBIT,ROOMS,0,CP-HOLE,T?CP-ANTE
	.OBJECT ALGAE,FX?NDESCBIT,0,IN-LAKE,SAND,0,T?ALGAE
	.OBJECT BROKEN-LAMP,0,FX?TAKEBIT,0,0,0,T?BROKEN-LAMP
	.OBJECT STONE,FX?OPENBIT,FX?CONTBIT,JUNCTION,0,SWORD,T?STONE
	.OBJECT DUNGEON-PANEL,FX?NDESCBIT,0,LOCAL-GLOBALS,PARAPET-OBJ,0,T?DUNGEON-PANEL
	.OBJECT HOOD,FX?WEARBIT+FX?TRYTAKEBIT+FX?NDESCBIT,FX?TAKEBIT,SHADOW,0,0,T?HOOD
	.OBJECT CP-SLOT,FX?OPENBIT+FX?NDESCBIT,0,0,0,0,T?CP-SLOT
	.OBJECT GRUE,0,0,GLOBAL-OBJECTS,GROUND,0,T?GRUE
	.OBJECT MRGE,FX?RLANDBIT,FX?ONBIT,ROOMS,MRDW,0,T?MRGE
	.OBJECT GUARDIAN,0,FX?ACTORBIT,LOCAL-GLOBALS,CPNWL,0,T?GUARDIAN
	.OBJECT GOOD-LOCKED-DOOR,FX?NDESCBIT,0,LOCAL-GLOBALS,CELL-DOOR,0,T?GOOD-LOCKED-DOOR
	.OBJECT STAIRS,FX?NDESCBIT,FX?CLIMBBIT,LOCAL-GLOBALS,PSEUDO-OBJECT,0,T?STAIRS
	.OBJECT DARK-2,FX?RLANDBIT,0,ROOMS,DARK-1,0,T?DARK-2
	.OBJECT AQUEDUCT,0,0,LOCAL-GLOBALS,LADDER,0,T?AQUEDUCT
	.OBJECT WOODEN-BAR,FX?NDESCBIT,0,IN-MIRROR,WHITE-PANEL,0,T?WOODEN-BAR
	.OBJECT TIMBERS,0,FX?TAKEBIT,TIMBER-ROOM,0,0,T?TIMBERS
	.OBJECT BEHIND-DOOR,FX?RLANDBIT,FX?ONBIT,ROOMS,SOUTH-CORRIDOR,DUNGEON-MASTER,T?BEHIND-DOOR
	.OBJECT IN-MIRROR,FX?RLANDBIT,FX?ONBIT,ROOMS,MRAW,WOODEN-BAR,T?IN-MIRROR
	.OBJECT MRCE,FX?RLANDBIT,FX?ONBIT,ROOMS,MRGW,0,T?MRCE
	.OBJECT WEST-CORRIDOR,FX?RLANDBIT,FX?ONBIT,ROOMS,EAST-CORRIDOR,0,T?WEST-CORRIDOR
	.OBJECT AQ-3,FX?RLANDBIT,FX?ONBIT,ROOMS,AQ-2,0,T?AQ-3
	.OBJECT WATER,0,FX?DRINKBIT+FX?TAKEBIT,0,0,0,T?WATER
	.OBJECT GROUND,0,0,GLOBAL-OBJECTS,SAILOR,0,T?GROUND
	.OBJECT NOT-HERE-OBJECT,0,0,0,0,0,T?NOT-HERE-OBJECT
	.OBJECT INTNUM,0,FX?TOOLBIT,GLOBAL-OBJECTS,LOCAL-GLOBALS,0,T?INTNUM
	.OBJECT FRIED-TORCH,0,FX?TAKEBIT,0,0,0,T?FRIED-TORCH
	.OBJECT MRA,FX?RLANDBIT,FX?ONBIT,ROOMS,MRB,0,T?MRA
	.OBJECT SHADOW-8,FX?RLANDBIT,0,ROOMS,SHADOW-7,0,T?SHADOW-8
	.OBJECT WARNING-NOTE,0,FX?BURNBIT+FX?READBIT+FX?TAKEBIT,CP-ANTE,LAMP,0,T?WARNING-NOTE
	.OBJECT MSTAIRS,FX?RLANDBIT,0,ROOMS,MREYE,RUNES,T?MSTAIRS
	.OBJECT MID-MUSEUM-ENTRANCE,FX?RLANDBIT,FX?ONBIT,ROOMS,MID-CP-OUT,0,T?MID-MUSEUM-ENTRANCE
	.OBJECT JEWELLED-KNIFE,FX?TRYTAKEBIT+FX?NDESCBIT,FX?TAKEBIT,PEDESTAL,SCEPTRE,0,T?JEWELLED-KNIFE
	.OBJECT T-BAR,FX?NDESCBIT,0,IN-MIRROR,0,0,T?T-BAR
	.OBJECT TECH-MUSEUM,FX?RLANDBIT,FX?ONBIT,ROOMS,JEWEL-ROOM,TECH-PLAQUE,T?TECH-MUSEUM
	.OBJECT DARK-1,FX?RLANDBIT,0,ROOMS,SOUTH-SHORE,0,T?DARK-1
	.OBJECT MRAW,FX?RLANDBIT,FX?ONBIT,ROOMS,MRAE,0,T?MRAW
	.OBJECT OLD-JEWEL-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,OLD-TECH-MUSEUM,0,T?OLD-JEWEL-ROOM
	.OBJECT SCEPTRE,FX?TRYTAKEBIT+FX?NDESCBIT,FX?TAKEBIT,PEDESTAL,0,0,T?SCEPTRE
	.OBJECT FLATHEAD-OCEAN,FX?RLANDBIT,FX?ONBIT,ROOMS,SHADOW-8,VIKING-SHIP,T?FLATHEAD-OCEAN
	.OBJECT AQ-2,FX?RLANDBIT,FX?ONBIT,ROOMS,AQ-1,0,T?AQ-2
	.OBJECT CELL-DOOR,0,FX?DOORBIT+FX?CONTBIT,LOCAL-GLOBALS,BRONZE-DOOR,0,T?CELL-DOOR
	.OBJECT ON-LAKE,FX?NONLANDBIT+FX?RLANDBIT,FX?ONBIT,ROOMS,AQ-VIEW,0,T?ON-LAKE
	.OBJECT FRIED-LAMP,0,FX?TAKEBIT,0,0,0,T?FRIED-LAMP
	.OBJECT SHADOW-4,FX?RLANDBIT,0,ROOMS,SHADOW-3,0,T?SHADOW-4
	.OBJECT CPNWL,FX?NDESCBIT,0,LOCAL-GLOBALS,CPSWL,0,T?CPNWL
	.OBJECT CP-OUT,FX?RLANDBIT,FX?ONBIT,ROOMS,CP-ANTE,0,T?CP-OUT
	.OBJECT GLOBAL-MAN,0,FX?ACTORBIT,LOCAL-GLOBALS,GLOBAL-ROPE,0,T?GLOBAL-MAN
	.OBJECT SOUTH-CORRIDOR,FX?RLANDBIT,FX?ONBIT,ROOMS,WEST-CORRIDOR,0,T?SOUTH-CORRIDOR
	.OBJECT RED-BUTTON,FX?NDESCBIT,0,MR-ANTE,0,0,T?RED-BUTTON
	.OBJECT ROOM-8,FX?RLANDBIT,0,ROOMS,MACHINE-ROOM,REPELLENT,T?ROOM-8
	.OBJECT STONE-WALL,FX?NDESCBIT,0,LOCAL-GLOBALS,CLIFF-OBJECT,0,T?STONE-WALL
	.OBJECT CP,FX?RLANDBIT,FX?ONBIT,ROOMS,CP-OUT,0,T?CP
	.OBJECT REPELLENT,0,FX?READBIT+FX?TAKEBIT,ROOM-8,0,0,T?REPELLENT
	.OBJECT LONG-POLE,FX?NDESCBIT,0,IN-MIRROR,COMPASS-ARROW,0,T?LONG-POLE
	.OBJECT RED-PANEL,FX?NDESCBIT,0,IN-MIRROR,PINE-PANEL,0,T?RED-PANEL
	.OBJECT MOSS,0,0,LOCAL-GLOBALS,WATER-CHANNEL,0,T?MOSS
	.OBJECT IRON-DOOR,0,FX?CONTBIT+FX?DOORBIT,LOCAL-GLOBALS,CLEFT,0,T?IRON-DOOR
	.OBJECT TUNNEL,FX?NDESCBIT,0,GLOBAL-OBJECTS,DEBRIS,0,T?TUNNEL
	.OBJECT POTION,0,0,VIAL,0,0,T?POTION
	.OBJECT SWORD,FX?TRYTAKEBIT,FX?WEAPONBIT+FX?TAKEBIT,STONE,0,0,T?SWORD
	.OBJECT AQ-1,FX?RLANDBIT,FX?ONBIT,ROOMS,KEY-ROOM,0,T?AQ-1
	.OBJECT GOOD-CELL,FX?RLANDBIT,FX?ONBIT,ROOMS,PRISON-CELL,0,T?GOOD-CELL
	.OBJECT JEWEL-DOOR,0,FX?CONTBIT+FX?DOORBIT,LOCAL-GLOBALS,IRON-DOOR,0,T?JEWEL-DOOR
	.OBJECT PARAPET-OBJ,FX?NDESCBIT,0,LOCAL-GLOBALS,FLAMING-PIT,0,T?PARAPET-OBJ
	.OBJECT DUNGEON-DOOR,FX?NDESCBIT,FX?CONTBIT+FX?DOORBIT,LOCAL-GLOBALS,DUNGEON-PANEL,0,T?DUNGEON-DOOR
	.OBJECT OCEAN,FX?NDESCBIT,0,GLOBAL-OBJECTS,VOICES,0,T?OCEAN
	.OBJECT BRONZE-DOOR,FX?INVISIBLE,FX?DOORBIT+FX?CONTBIT,LOCAL-GLOBALS,WOODEN-WALL,0,T?BRONZE-DOOR
	.OBJECT ZORK-IV,FX?RLANDBIT,FX?ONBIT,ROOMS,ROOM-8,0,T?ZORK-IV
	.OBJECT ZORK2-STAIR,FX?RLANDBIT,FX?ONBIT,ROOMS,FLATHEAD-OCEAN,0,T?ZORK2-STAIR
	.OBJECT YELLOW-PANEL,FX?NDESCBIT,0,IN-MIRROR,SHORT-POLE,0,T?YELLOW-PANEL
	.OBJECT STAFF,0,FX?TAKEBIT,0,0,0,T?STAFF
	.OBJECT VIKING-SHIP,FX?INVISIBLE+FX?NDESCBIT,0,FLATHEAD-OCEAN,0,0,T?VIKING-SHIP
	.OBJECT CP-HOLE,FX?NDESCBIT,0,CP-ANTE,WARNING-NOTE,0,T?CP-HOLE
	.OBJECT SOUTH-SHORE,FX?RLANDBIT,FX?ONBIT,ROOMS,ZORK-IV,0,T?SOUTH-SHORE
	.OBJECT JUNCTION,FX?RLANDBIT,0,ROOMS,ZORK2-STAIR,STONE,T?JUNCTION
	.OBJECT CLIFF-LEDGE,FX?RLANDBIT,FX?ONBIT,ROOMS,CLIFF,CHEST,T?CLIFF-LEDGE
	.OBJECT TECH-PLAQUE,FX?NDESCBIT,FX?READBIT,TECH-MUSEUM,SPINNER,0,T?TECH-PLAQUE
	.OBJECT CLIFF-OBJECT,0,0,LOCAL-GLOBALS,ROBOT,0,T?CLIFF-OBJECT
	.OBJECT MRBE,FX?RLANDBIT,FX?ONBIT,ROOMS,MRCW,0,T?MRBE
	.OBJECT SECRET-DOOR,FX?INVISIBLE,FX?CONTBIT+FX?DOORBIT,LOCAL-GLOBALS,DUNGEON-DOOR,0,T?SECRET-DOOR
	.OBJECT LAKE,0,0,LOCAL-GLOBALS,STONE-WALL,0,T?LAKE
	.OBJECT MRD,FX?RLANDBIT,FX?ONBIT,ROOMS,CP,0,T?MRD
	.OBJECT PRISON-CELL,FX?RLANDBIT,FX?ONBIT,ROOMS,CELL,0,T?PRISON-CELL
	.OBJECT PSEUDO-OBJECT,0,0,LOCAL-GLOBALS,SECRET-DOOR,0,T?PSEUDO-OBJECT
	.OBJECT MUSEUM-ENTRANCE,FX?RLANDBIT,FX?ONBIT,ROOMS,MUSEUM-ANTE,0,T?MUSEUM-ENTRANCE
	.OBJECT LOWER-SHAFT,FX?RLANDBIT,0,ROOMS,TIMBER-ROOM,0,T?LOWER-SHAFT
	.ENDT

; OBJECT PROPERTY TABLES ARE DEFINED HERE

OBJPRP::

T?DUNGEON-MASTER::	.TABLE			; TABLE FOR OBJECT DUNGEON-MASTER
	.STRL "dungeon master"
	.PROP 6,P?SYNONYM
	W?MASTER
	W?DUNGEON
	W?MAN
	.PROP 1,P?ADJECTIVE
	.BYTE A?DUNGEON
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DUNGEON-MASTER-F
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?9
	.BYTE	0
	.ENDT

T?SHORT-POLE::	.TABLE			; TABLE FOR OBJECT SHORT-POLE
	.STRL "short pole"
	.PROP 8,P?SYNONYM
	W?POLE
	W?POST
	W?HANDGRIP
	W?GRIP
	.PROP 3,P?ADJECTIVE
	.BYTE A?SHORT
	.BYTE A?SMALL
	.BYTE A?HAND
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SHORT-POLE-F
	.BYTE	0
	.ENDT

T?VIEW-INDICATOR::	.TABLE			; TABLE FOR OBJECT VIEW-INDICATOR
	.STRL "indicator"
	.PROP 4,P?SYNONYM
	W?INDICATOR
	W?DIAL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	VIEW-INDICATOR-F
	.BYTE	0
	.ENDT

T?FLAMING-PIT::	.TABLE			; TABLE FOR OBJECT FLAMING-PIT
	.STRL "flaming pit"
	.PROP 4,P?SYNONYM
	W?PIT
	W?ABYSS
	.PROP 2,P?ADJECTIVE
	.BYTE A?FIERY
	.BYTE A?FLAMING
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	FLAMING-PIT-F
	.BYTE	0
	.ENDT

T?MID-TECH-MUSEUM::	.TABLE			; TABLE FOR OBJECT MID-TECH-MUSEUM
	.STRL "Technology Museum"
	.PROP 5,P?SOUTH			; DOOR EXIT
	.BYTE MID-MUSEUM-ENTRANCE				; ROOM NAME
	.BYTE WOODEN-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 5,P?OUT			; DOOR EXIT
	.BYTE MID-MUSEUM-ENTRANCE				; ROOM NAME
	.BYTE WOODEN-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TECH-MUSEUM-F
	.PROP 1,P?GLOBAL
	.BYTE WOODEN-DOOR
	.BYTE	0
	.ENDT

T?MREYE::	.TABLE			; TABLE FOR OBJECT MREYE
	.STRL "Beam Room"
	.PROP 3,P?NORTH
	.WORD MRGO
	.BYTE 0
	.PROP 1,P?SOUTH
	.BYTE MR-ANTE
	.PROP 3,P?NE
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?NW
	.WORD MRGO
	.BYTE 0
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MREYE-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.BYTE	0
	.ENDT

T?GLOBAL-WATER::	.TABLE			; TABLE FOR OBJECT GLOBAL-WATER
	.STRL "water"
	.PROP 4,P?SYNONYM
	W?WATER
	W?QUANTITY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WATER-FCN
	.BYTE	0
	.ENDT

T?MRDW::	.TABLE			; TABLE FOR OBJECT MRDW
	.STRL "Narrow Room"
	.PROP 1,P?NORTH
	.BYTE FRONT-DOOR
	.PROP 3,P?WEST
	.WORD MIRIN
	.BYTE 0
	.PROP 1,P?SOUTH
	.BYTE MRG
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MRDEW
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 3,P?GLOBAL
	.BYTE MIRROR
	.BYTE PANEL
	.BYTE GUARDIAN
	.PROP 3,P?ENTER
	.WORD MIRIN
	.BYTE 0
	.BYTE	0
	.ENDT

T?HANDS::	.TABLE			; TABLE FOR OBJECT HANDS
	.STRL "pair of hands"
	.PROP 6,P?SYNONYM
	W?PAIR
	W?HANDS
	W?HAND
	.PROP 1,P?ADJECTIVE
	.BYTE A?BARE
	.BYTE	0
	.ENDT

T?CAGE::	.TABLE			; TABLE FOR OBJECT CAGE
	.STRL "steel cage"
	.PROP 2,P?SYNONYM
	W?CAGE
	.PROP 1,P?ADJECTIVE
	.BYTE A?STEEL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CAGE-F
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	5
	.BYTE	0
	.ENDT

T?MASTER::	.TABLE			; TABLE FOR OBJECT MASTER
	.STRL "dungeon master"
	.PROP 4,P?SYNONYM
	W?MASTER
	W?MAN
	.PROP 1,P?ADJECTIVE
	.BYTE A?DUNGEON
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MASTER-F
	.BYTE	0
	.ENDT

T?IN-LAKE::	.TABLE			; TABLE FOR OBJECT IN-LAKE
	.STRL "Underwater"
	.PROP 1,P?NORTH
	.BYTE IN-LAKE
	.PROP 1,P?EAST
	.BYTE IN-LAKE
	.PROP 1,P?WEST
	.BYTE IN-LAKE
	.PROP 1,P?SOUTH
	.BYTE IN-LAKE
	.PROP 1,P?NE
	.BYTE IN-LAKE
	.PROP 1,P?NW
	.BYTE IN-LAKE
	.PROP 1,P?SE
	.BYTE IN-LAKE
	.PROP 1,P?SW
	.BYTE IN-LAKE
	.PROP 1,P?UP
	.BYTE ON-LAKE
	.PROP 2,P?DOWN			; STRING PROPERTY
	STR?194
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	IN-LAKE-F
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?193
	.PROP 2,P?GLOBAL
	.BYTE LAKE
	.BYTE FISH
	.BYTE	0
	.ENDT

T?KEY::	.TABLE			; TABLE FOR OBJECT KEY
	.STRL "strange key"
	.PROP 2,P?SYNONYM
	W?KEY
	.PROP 8,P?ADJECTIVE
	.BYTE A?STRANGE
	.BYTE A?RUSTY
	.BYTE A?LONG
	.BYTE A?SHORT
	.BYTE A?HEAVY
	.BYTE A?THIN
	.BYTE A?SHARP
	.BYTE A?POINTED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	KEY-F
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	10
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?242
	.BYTE	0
	.ENDT

T?RUBBLE::	.TABLE			; TABLE FOR OBJECT RUBBLE
	.STRL "rubble"
	.PROP 8,P?SYNONYM
	W?ROCK
	W?ROCKS
	W?BOULDER
	W?RUBBLE
	.BYTE	0
	.ENDT

T?TIMBER-ROOM::	.TABLE			; TABLE FOR OBJECT TIMBER-ROOM
	.STRL "Timber Room"
	.PROP 1,P?EAST
	.BYTE LADDER-BOTTOM
	.PROP 4,P?WEST			; CONDITIONAL EXIT
	.BYTE LOWER-SHAFT				; ROOM NAME
	.BYTE EMPTY-HANDED				; FLAG NAME
	STR?224			; STRING
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	NO-OBJS
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?223
	.BYTE	0
	.ENDT

T?MID-JEWEL-ROOM::	.TABLE			; TABLE FOR OBJECT MID-JEWEL-ROOM
	.STRL "Jewel Room"
	.PROP 5,P?WEST			; DOOR EXIT
	.BYTE MID-MUSEUM-ENTRANCE				; ROOM NAME
	.BYTE JEWEL-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 5,P?OUT			; DOOR EXIT
	.BYTE MID-MUSEUM-ENTRANCE				; ROOM NAME
	.BYTE JEWEL-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	JEWEL-ROOM-F
	.PROP 1,P?GLOBAL
	.BYTE JEWEL-DOOR
	.BYTE	0
	.ENDT

T?VIEWING-TABLE::	.TABLE			; TABLE FOR OBJECT VIEWING-TABLE
	.STRL "viewing table"
	.PROP 4,P?SYNONYM
	W?TABLE
	W?SURFACE
	.PROP 1,P?ADJECTIVE
	.BYTE A?VIEWING
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	VIEWING-TABLE-F
	.BYTE	0
	.ENDT

T?TORCH::	.TABLE			; TABLE FOR OBJECT TORCH
	.STRL "torch"
	.PROP 2,P?SYNONYM
	W?TORCH
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TORCH-F
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?197
	.BYTE	0
	.ENDT

T?NORTH-CORRIDOR::	.TABLE			; TABLE FOR OBJECT NORTH-CORRIDOR
	.STRL "North Corridor"
	.PROP 1,P?NORTH
	.BYTE PARAPET
	.PROP 1,P?EAST
	.BYTE EAST-CORRIDOR
	.PROP 1,P?WEST
	.BYTE WEST-CORRIDOR
	.PROP 5,P?SOUTH			; DOOR EXIT
	.BYTE CELL				; ROOM NAME
	.BYTE CELL-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	NORTH-CORRIDOR-F
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 4,P?GLOBAL
	.BYTE MASTER
	.BYTE CELL-DOOR
	.BYTE PARAPET-OBJ
	.BYTE FLAMING-PIT
	.PROP 5,P?ENTER			; DOOR EXIT
	.BYTE CELL				; ROOM NAME
	.BYTE CELL-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.BYTE	0
	.ENDT

T?LADDER-TOP::	.TABLE			; TABLE FOR OBJECT LADDER-TOP
	.STRL "Ladder Top"
	.PROP 1,P?DOWN
	.BYTE LADDER-BOTTOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?220
	.PROP 2,P?GLOBAL
	.BYTE LADDER
	.BYTE STAIRS
	.BYTE	0
	.ENDT

T?VOICES::	.TABLE			; TABLE FOR OBJECT VOICES
	.STRL "voices"
	.PROP 8,P?SYNONYM
	W?VOICE
	W?VOICES
	W?GUARDS
	W?OFFICI
	.PROP 1,P?ADJECTIVE
	.BYTE A?ARMED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	VOICES-F
	.BYTE	0
	.ENDT

T?VIAL::	.TABLE			; TABLE FOR OBJECT VIAL
	.STRL "vial"
	.PROP 6,P?SYNONYM
	W?VIAL
	W?ODOR
	W?GIFT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	VIAL-F
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	3
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	3
	.BYTE	0
	.ENDT

T?SHADOW-5::	.TABLE			; TABLE FOR OBJECT SHADOW-5
	.STRL "Land of Shadow"
	.PROP 1,P?NORTH
	.BYTE SHADOW-4
	.PROP 2,P?EAST			; STRING PROPERTY
	STR?145
	.PROP 2,P?WEST			; STRING PROPERTY
	STR?145
	.PROP 2,P?SOUTH			; STRING PROPERTY
	STR?145
	.PROP 1,P?NE
	.BYTE SHADOW-1
	.PROP 1,P?NW
	.BYTE SHADOW-6
	.PROP 2,P?SE			; STRING PROPERTY
	STR?145
	.PROP 2,P?SW			; STRING PROPERTY
	STR?145
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SHADOW-ROOMS
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?144
	.PROP 4,P?PSEUDO
	W?QUICKS
	QUICKSAND-PSEUDO
	.BYTE	0
	.ENDT

T?ME::	.TABLE			; TABLE FOR OBJECT ME
	.STRL "you"
	.PROP 8,P?SYNONYM
	W?ME
	W?MYSELF
	W?SELF
	W?CRETIN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CRETIN-FCN
	.BYTE	0
	.ENDT

T?TM-HOLLOW::	.TABLE			; TABLE FOR OBJECT TM-HOLLOW
	.STRL "seat"
	.PROP 2,P?SYNONYM
	W?AREA
	.PROP 2,P?ADJECTIVE
	.BYTE A?SMALL
	.BYTE A?HOLLOW
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TM-HOLLOW-F
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	20
	.BYTE	0
	.ENDT

T?VALUABLES::	.TABLE			; TABLE FOR OBJECT VALUABLES
	.STRL "pile of assorted valuables"
	.PROP 6,P?SYNONYM
	W?VALUABLES
	W?TREASURE
	W?PILE
	.PROP 1,P?ADJECTIVE
	.BYTE A?ASSORTED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	VALUABLES-F
	.BYTE	0
	.ENDT

T?BEAM::	.TABLE			; TABLE FOR OBJECT BEAM
	.STRL "red beam of light"
	.PROP 4,P?SYNONYM
	W?BEAM
	W?LIGHT
	.PROP 1,P?ADJECTIVE
	.BYTE A?RED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	BEAM-FUNCTION
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	100
	.BYTE	0
	.ENDT

T?OLD-MUSEUM-ENTRANCE::	.TABLE			; TABLE FOR OBJECT OLD-MUSEUM-ENTRANCE
	.STRL "Museum Entrance"
	.PROP 5,P?NORTH			; DOOR EXIT
	.BYTE OLD-TECH-MUSEUM				; ROOM NAME
	.BYTE WOODEN-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 5,P?EAST			; DOOR EXIT
	.BYTE OLD-JEWEL-ROOM				; ROOM NAME
	.BYTE JEWEL-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?WEST			; STRING PROPERTY
	STR?115
	.PROP 2,P?SOUTH			; STRING PROPERTY
	STR?116
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	OLD-TECH-MUSEUM-F
	.PROP 4,P?GLOBAL
	.BYTE WOODEN-DOOR
	.BYTE JEWEL-DOOR
	.BYTE IRON-DOOR
	.BYTE ROBOT
	.BYTE	0
	.ENDT

T?PANEL::	.TABLE			; TABLE FOR OBJECT PANEL
	.STRL "panel"
	.PROP 2,P?SYNONYM
	W?PANEL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PANEL-FUNCTION
	.BYTE	0
	.ENDT

T?SHADOW-1::	.TABLE			; TABLE FOR OBJECT SHADOW-1
	.STRL "Land of Shadow"
	.PROP 2,P?NORTH			; STRING PROPERTY
	STR?138
	.PROP 1,P?EAST
	.BYTE CREEPY-CRAWL
	.PROP 1,P?WEST
	.BYTE SHADOW-3
	.PROP 1,P?SOUTH
	.BYTE SHADOW-5
	.PROP 2,P?NE			; STRING PROPERTY
	STR?138
	.PROP 1,P?NW
	.BYTE SHADOW-2
	.PROP 1,P?SE
	.BYTE FOGGY-ROOM
	.PROP 1,P?SW
	.BYTE SHADOW-4
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SHADOW-ROOMS
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?137
	.BYTE	0
	.ENDT

T?LEDGE::	.TABLE			; TABLE FOR OBJECT LEDGE
	.STRL "ledge"
	.PROP 2,P?SYNONYM
	W?LEDGE
	.PROP 1,P?ADJECTIVE
	.BYTE A?WIDE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	LEDGE-F
	.BYTE	0
	.ENDT

T?RUNES::	.TABLE			; TABLE FOR OBJECT RUNES
	.STRL "runes"
	.PROP 8,P?SYNONYM
	W?ENGRAV
	W?TEXT
	W?WALL
	W?RUNES
	.PROP 1,P?ADJECTIVE
	.BYTE A?CARVED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	RUNES-F
	.BYTE	0
	.ENDT

T?INTDIR::	.TABLE			; TABLE FOR OBJECT INTDIR
	.STRL "direction"
	.PROP 2,P?SYNONYM
	W?INTDIR
	.BYTE	0
	.ENDT

T?ROOMS::	.TABLE			; TABLE FOR OBJECT ROOMS
	.STRL ""
	.PROP 1,P?IN
	.BYTE ROOMS
	.BYTE	0
	.ENDT

T?ADVENTURER::	.TABLE			; TABLE FOR OBJECT ADVENTURER
	.STRL "cretin"
	.PROP 2,P?SYNONYM
	W?ADVENTURER
	.PROP 2,P?ACTION			; INTEGER/CONSTANT PROPERTY

	0
	.PROP 2,P?STRENGTH			; INTEGER/CONSTANT PROPERTY

	0
	.BYTE	0
	.ENDT

T?PARAPET::	.TABLE			; TABLE FOR OBJECT PARAPET
	.STRL "Parapet"
	.PROP 2,P?NORTH			; STRING PROPERTY
	STR?19
	.PROP 1,P?SOUTH
	.BYTE NORTH-CORRIDOR
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PARAPET-F
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 3,P?GLOBAL
	.BYTE MASTER
	.BYTE PARAPET-OBJ
	.BYTE FLAMING-PIT
	.BYTE	0
	.ENDT

T?MAHOGANY-PANEL::	.TABLE			; TABLE FOR OBJECT MAHOGANY-PANEL
	.STRL "mahogany panel"
	.PROP 4,P?SYNONYM
	W?WALL
	W?PANEL
	.PROP 1,P?ADJECTIVE
	.BYTE A?MAHOGANY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MENDS
	.BYTE	0
	.ENDT

T?ROYAL-SEAL::	.TABLE			; TABLE FOR OBJECT ROYAL-SEAL
	.STRL "Royal Seal of Dimwit Flathead"
	.PROP 6,P?SYNONYM
	W?SEAL
	W?CARVIN
	W?RENDER
	.PROP 2,P?ADJECTIVE
	.BYTE A?LARGE
	.BYTE A?ROYAL
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?112
	.BYTE	0
	.ENDT

T?KEY-ROOM::	.TABLE			; TABLE FOR OBJECT KEY-ROOM
	.STRL "Key Room"
	.PROP 1,P?WEST
	.BYTE DARK-2
	.PROP 4,P?DOWN			; CONDITIONAL EXIT
	.BYTE AQ-1				; ROOM NAME
	.BYTE COVER-MOVED				; FLAG NAME
	STR?234			; STRING
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	KEY-ROOM-F
	.BYTE	0
	.ENDT

T?TIGHT-SQUEEZE::	.TABLE			; TABLE FOR OBJECT TIGHT-SQUEEZE
	.STRL "Tight Squeeze"
	.PROP 1,P?EAST
	.BYTE ROCKY-ROOM
	.PROP 1,P?WEST
	.BYTE CREEPY-CRAWL
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?109
	.BYTE	0
	.ENDT

T?LOCAL-GLOBALS::	.TABLE			; TABLE FOR OBJECT LOCAL-GLOBALS
	.STRL ""
	.PROP 2,P?SYNONYM
	W?ZZMGCK
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?23
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	0
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?23
	.PROP 1,P?GLOBAL
	.BYTE GLOBAL-OBJECTS
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	0
	.PROP 4,P?PSEUDO
	W?FOOBAR
	V-WALK
	.PROP 2,P?DESCFCN			; ATOM (CONSTANT) PROPERTY

	PATH-OBJECT
	.PROP 2,P?ADVFCN			; INTEGER/CONSTANT PROPERTY

	0
	.PROP 2,P?CONTFCN			; INTEGER/CONSTANT PROPERTY

	0
	.PROP 2,P?VTYPE			; INTEGER/CONSTANT PROPERTY

	1
	.BYTE	0
	.ENDT

T?CPEWL::	.TABLE			; TABLE FOR OBJECT CPEWL
	.STRL "eastern wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 2,P?ADJECTIVE
	.BYTE A?EAST
	.BYTE A?EASTERN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CPWALL-OBJECT
	.BYTE	0
	.ENDT

T?EAST-CORRIDOR::	.TABLE			; TABLE FOR OBJECT EAST-CORRIDOR
	.STRL "East Corridor"
	.PROP 1,P?NORTH
	.BYTE NORTH-CORRIDOR
	.PROP 1,P?SOUTH
	.BYTE SOUTH-CORRIDOR
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?17
	.BYTE	0
	.ENDT

T?MRG::	.TABLE			; TABLE FOR OBJECT MRG
	.STRL "Hallway"
	.PROP 3,P?NORTH
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?SOUTH
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?NE
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?NW
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?SE
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?SW
	.WORD MRGO
	.BYTE 0
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GUARDIANS
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 1,P?GLOBAL
	.BYTE GUARDIAN
	.PROP 3,P?ENTER
	.WORD MIRIN
	.BYTE 0
	.BYTE	0
	.ENDT

T?CELL::	.TABLE			; TABLE FOR OBJECT CELL
	.STRL "Prison Cell"
	.PROP 5,P?NORTH			; DOOR EXIT
	.BYTE NORTH-CORRIDOR				; ROOM NAME
	.BYTE CELL-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 5,P?OUT			; DOOR EXIT
	.BYTE NORTH-CORRIDOR				; ROOM NAME
	.BYTE CELL-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CELL-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 5,P?GLOBAL
	.BYTE MASTER
	.BYTE BRONZE-DOOR
	.BYTE CELL-DOOR
	.BYTE PARAPET-OBJ
	.BYTE FLAMING-PIT
	.BYTE	0
	.ENDT

T?NIRVANA::	.TABLE			; TABLE FOR OBJECT NIRVANA
	.STRL "Treasury of Zork"
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	NIRVANA-F
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?22
	.BYTE	0
	.ENDT

T?ROPE::	.TABLE			; TABLE FOR OBJECT ROPE
	.STRL "rope"
	.PROP 2,P?SYNONYM
	W?ROPE
	.PROP 1,P?ADJECTIVE
	.BYTE A?LONG
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	ROPE-F
	.BYTE	0
	.ENDT

T?MRGW::	.TABLE			; TABLE FOR OBJECT MRGW
	.STRL "Narrow Room"
	.PROP 1,P?NORTH
	.BYTE MRD
	.PROP 3,P?EAST
	.WORD MIRIN
	.BYTE 0
	.PROP 1,P?SOUTH
	.BYTE MRC
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GUARDIANS
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 3,P?GLOBAL
	.BYTE MIRROR
	.BYTE PANEL
	.BYTE GUARDIAN
	.PROP 3,P?ENTER
	.WORD MIRIN
	.BYTE 0
	.BYTE	0
	.ENDT

T?GLOBAL-OBJECTS::	.TABLE			; TABLE FOR OBJECT GLOBAL-OBJECTS
	.STRL ""
	.BYTE	0
	.ENDT

T?CRYSTALS::	.TABLE			; TABLE FOR OBJECT CRYSTALS
	.STRL "rock structure"
	.PROP 4,P?SYNONYM
	W?CRYSTAL
	W?STALAG
	.BYTE	0
	.ENDT

T?MRAE::	.TABLE			; TABLE FOR OBJECT MRAE
	.STRL "Narrow Room"
	.PROP 1,P?NORTH
	.BYTE MRB
	.PROP 3,P?WEST
	.WORD MIRIN
	.BYTE 0
	.PROP 1,P?SOUTH
	.BYTE MREYE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MRAEW
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 3,P?GLOBAL
	.BYTE MIRROR
	.BYTE PANEL
	.BYTE GUARDIAN
	.PROP 3,P?ENTER
	.WORD MIRIN
	.BYTE 0
	.BYTE	0
	.ENDT

T?WHITE-PANEL::	.TABLE			; TABLE FOR OBJECT WHITE-PANEL
	.STRL "white panel"
	.PROP 4,P?SYNONYM
	W?PANEL
	W?WALL
	.PROP 1,P?ADJECTIVE
	.BYTE A?WHITE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MPANELS
	.BYTE	0
	.ENDT

T?IT::	.TABLE			; TABLE FOR OBJECT IT
	.STRL "random object"
	.PROP 8,P?SYNONYM
	W?IT
	W?THEM
	W?HER
	W?HIM
	.BYTE	0
	.ENDT

T?MRC::	.TABLE			; TABLE FOR OBJECT MRC
	.STRL "Hallway"
	.PROP 3,P?NORTH
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?SOUTH
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?NE
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?NW
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?SE
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?SW
	.WORD MRGO
	.BYTE 0
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MRCF
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 6,P?GLOBAL
	.BYTE MIRROR
	.BYTE PANEL
	.BYTE ROSE
	.BYTE CHANNEL
	.BYTE GUARDIAN
	.BYTE WOODEN-WALL
	.PROP 3,P?ENTER
	.WORD MIRIN
	.BYTE 0
	.BYTE	0
	.ENDT

T?CREEPY-CRAWL::	.TABLE			; TABLE FOR OBJECT CREEPY-CRAWL
	.STRL "Creepy Crawl"
	.PROP 1,P?NORTH
	.BYTE JUNCTION
	.PROP 1,P?EAST
	.BYTE TIGHT-SQUEEZE
	.PROP 1,P?SOUTH
	.BYTE FOGGY-ROOM
	.PROP 1,P?SW
	.BYTE SHADOW-1
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CREEPY-CRAWL-F
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?136
	.BYTE	0
	.ENDT

T?PATHOBJ::	.TABLE			; TABLE FOR OBJECT PATHOBJ
	.STRL "passage"
	.PROP 4,P?SYNONYM
	W?TRAIL
	W?PATH
	.PROP 4,P?ADJECTIVE
	.BYTE A?FOREST
	.BYTE A?NARROW
	.BYTE A?LONG
	.BYTE A?WINDING
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PATH-OBJECT
	.BYTE	0
	.ENDT

T?LADDER-BOTTOM::	.TABLE			; TABLE FOR OBJECT LADDER-BOTTOM
	.STRL "Ladder Bottom"
	.PROP 1,P?WEST
	.BYTE TIMBER-ROOM
	.PROP 1,P?SOUTH
	.BYTE DEAD-END-5
	.PROP 1,P?UP
	.BYTE LADDER-TOP
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?221
	.PROP 1,P?GLOBAL
	.BYTE LADDER
	.BYTE	0
	.ENDT

T?MRCW::	.TABLE			; TABLE FOR OBJECT MRCW
	.STRL "Narrow Room"
	.PROP 1,P?NORTH
	.BYTE MRG
	.PROP 3,P?EAST
	.WORD MIRIN
	.BYTE 0
	.PROP 1,P?SOUTH
	.BYTE MRB
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MRCEW
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 3,P?GLOBAL
	.BYTE MIRROR
	.BYTE PANEL
	.BYTE GUARDIAN
	.PROP 3,P?ENTER
	.WORD MIRIN
	.BYTE 0
	.BYTE	0
	.ENDT

T?CLOAK::	.TABLE			; TABLE FOR OBJECT CLOAK
	.STRL "cloak"
	.PROP 2,P?SYNONYM
	W?CLOAK
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CLOAK-F
	.BYTE	0
	.ENDT

T?DIAL-BUTTON::	.TABLE			; TABLE FOR OBJECT DIAL-BUTTON
	.STRL "large button"
	.PROP 2,P?SYNONYM
	W?BUTTON
	.PROP 1,P?ADJECTIVE
	.BYTE A?LARGE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DIALBUTTON
	.BYTE	0
	.ENDT

T?PEDESTAL::	.TABLE			; TABLE FOR OBJECT PEDESTAL
	.STRL "pedestal"
	.PROP 2,P?SYNONYM
	W?PEDESTAL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PEDESTAL-F
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	50
	.BYTE	0
	.ENDT

T?PINE-PANEL::	.TABLE			; TABLE FOR OBJECT PINE-PANEL
	.STRL "pine panel"
	.PROP 4,P?SYNONYM
	W?PANEL
	W?WALL
	.PROP 1,P?ADJECTIVE
	.BYTE A?PINE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MENDS
	.BYTE	0
	.ENDT

T?SHADOW-6::	.TABLE			; TABLE FOR OBJECT SHADOW-6
	.STRL "Land of Shadow"
	.PROP 1,P?NORTH
	.BYTE SHADOW-7
	.PROP 1,P?EAST
	.BYTE SHADOW-4
	.PROP 1,P?WEST
	.BYTE FLATHEAD-OCEAN
	.PROP 2,P?SOUTH			; STRING PROPERTY
	STR?145
	.PROP 1,P?NE
	.BYTE SHADOW-3
	.PROP 1,P?NW
	.BYTE FLATHEAD-OCEAN
	.PROP 1,P?SE
	.BYTE SHADOW-5
	.PROP 2,P?SW			; STRING PROPERTY
	STR?145
	.PROP 1,P?DOWN
	.BYTE FLATHEAD-OCEAN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SHADOW-ROOMS
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?146
	.PROP 4,P?PSEUDO
	W?QUICKS
	QUICKSAND-PSEUDO
	.BYTE	0
	.ENDT

T?FOGGY-ROOM::	.TABLE			; TABLE FOR OBJECT FOGGY-ROOM
	.STRL "Foggy Room"
	.PROP 1,P?NORTH
	.BYTE CREEPY-CRAWL
	.PROP 1,P?WEST
	.BYTE SHADOW-1
	.PROP 1,P?SOUTH
	.BYTE LAKE-SHORE
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?185
	.BYTE	0
	.ENDT

T?CHEST::	.TABLE			; TABLE FOR OBJECT CHEST
	.STRL "chest"
	.PROP 2,P?SYNONYM
	W?CHEST
	.PROP 1,P?ADJECTIVE
	.BYTE A?LOCKED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CHEST-F
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	40
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?201
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	20
	.BYTE	0
	.ENDT

T?OLD-TECH-MUSEUM::	.TABLE			; TABLE FOR OBJECT OLD-TECH-MUSEUM
	.STRL "Technology Museum"
	.PROP 5,P?SOUTH			; DOOR EXIT
	.BYTE OLD-MUSEUM-ENTRANCE				; ROOM NAME
	.BYTE WOODEN-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 5,P?OUT			; DOOR EXIT
	.BYTE OLD-MUSEUM-ENTRANCE				; ROOM NAME
	.BYTE WOODEN-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	OLD-TECH-MUSEUM-F
	.PROP 2,P?GLOBAL
	.BYTE WOODEN-DOOR
	.BYTE ROBOT
	.BYTE	0
	.ENDT

T?REEDS::	.TABLE			; TABLE FOR OBJECT REEDS
	.STRL "reeds"
	.PROP 2,P?SYNONYM
	W?REEDS
	.PROP 1,P?ADJECTIVE
	.BYTE A?SICKLY
	.BYTE	0
	.ENDT

T?LADDER::	.TABLE			; TABLE FOR OBJECT LADDER
	.STRL "wooden ladder"
	.PROP 2,P?SYNONYM
	W?LADDER
	.PROP 3,P?ADJECTIVE
	.BYTE A?WOODEN
	.BYTE A?RICKETY
	.BYTE A?NARROW
	.BYTE	0
	.ENDT

T?SHADOW-2::	.TABLE			; TABLE FOR OBJECT SHADOW-2
	.STRL "Land of Shadow"
	.PROP 1,P?NORTH
	.BYTE CLEARING
	.PROP 1,P?EAST
	.BYTE SHADOW-1
	.PROP 1,P?WEST
	.BYTE SHADOW-8
	.PROP 1,P?SOUTH
	.BYTE SHADOW-3
	.PROP 2,P?NE			; STRING PROPERTY
	STR?140
	.PROP 2,P?NW			; STRING PROPERTY
	STR?140
	.PROP 1,P?SE
	.BYTE SHADOW-1
	.PROP 1,P?SW
	.BYTE SHADOW-7
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SHADOW-ROOMS
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?139
	.PROP 2,P?GLOBAL
	.BYTE RUBBLE
	.BYTE STONE-WALL
	.BYTE	0
	.ENDT

T?MACHINE-ROOM::	.TABLE			; TABLE FOR OBJECT MACHINE-ROOM
	.STRL "Machine Room"
	.BYTE	0
	.ENDT

T?WATER-CHANNEL::	.TABLE			; TABLE FOR OBJECT WATER-CHANNEL
	.STRL "channel"
	.PROP 2,P?SYNONYM
	W?CHANNEL
	.PROP 1,P?ADJECTIVE
	.BYTE A?WATER
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WATER-CHANNEL-F
	.BYTE	0
	.ENDT

T?LOCKED-DOOR::	.TABLE			; TABLE FOR OBJECT LOCKED-DOOR
	.STRL "cell door"
	.PROP 2,P?SYNONYM
	W?DOOR
	.PROP 4,P?ADJECTIVE
	.BYTE A?LOCKED
	.BYTE A?WOOD
	.BYTE A?WOODEN
	.BYTE A?CELL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	LOCKED-DOOR-F
	.BYTE	0
	.ENDT

T?CLIFF-BASE::	.TABLE			; TABLE FOR OBJECT CLIFF-BASE
	.STRL "Cliff Base"
	.PROP 1,P?SOUTH
	.BYTE FLATHEAD-OCEAN
	.PROP 1,P?NE
	.BYTE SLOPE
	.PROP 2,P?UP			; STRING PROPERTY
	STR?181
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CLIFF-BASE-F
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?180
	.PROP 1,P?GLOBAL
	.BYTE LEDGE
	.BYTE	0
	.ENDT

T?SOUTH-WALL::	.TABLE			; TABLE FOR OBJECT SOUTH-WALL
	.STRL "southern wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 2,P?ADJECTIVE
	.BYTE A?SOUTH
	.BYTE A?SOUTHE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	RANDOM-WALL
	.BYTE	0
	.ENDT

T?AQ-VIEW::	.TABLE			; TABLE FOR OBJECT AQ-VIEW
	.STRL "Aqueduct View"
	.PROP 1,P?NW
	.BYTE LAKE-SHORE
	.PROP 1,P?UP
	.BYTE LAKE-SHORE
	.PROP 2,P?DOWN			; STRING PROPERTY
	STR?190
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?189
	.PROP 2,P?GLOBAL
	.BYTE AQUEDUCT
	.BYTE STAIRS
	.BYTE	0
	.ENDT

T?TM-DIAL::	.TABLE			; TABLE FOR OBJECT TM-DIAL
	.STRL "dial"
	.PROP 6,P?SYNONYM
	W?DIAL
	W?CONSOLE
	W?DISPLAY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TM-DIAL-F
	.BYTE	0
	.ENDT

T?LORE-BOOK::	.TABLE			; TABLE FOR OBJECT LORE-BOOK
	.STRL "very ancient book"
	.PROP 6,P?SYNONYM
	W?BOOK
	W?LORE
	W?TEXT
	.PROP 3,P?ADJECTIVE
	.BYTE A?LORE
	.BYTE A?OLD
	.BYTE A?STRANGE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	LORE-BOOK-F
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?6
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	4
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?7
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?8
	.BYTE	0
	.ENDT

T?SLOPE::	.TABLE			; TABLE FOR OBJECT SLOPE
	.STRL "Hairpin Loop"
	.PROP 1,P?SE
	.BYTE CLEARING
	.PROP 1,P?SW
	.BYTE CLIFF-BASE
	.PROP 1,P?UP
	.BYTE CLEARING
	.PROP 1,P?DOWN
	.BYTE CLIFF-BASE
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?179
	.PROP 1,P?GLOBAL
	.BYTE RUBBLE
	.BYTE	0
	.ENDT

T?ROBOT::	.TABLE			; TABLE FOR OBJECT ROBOT
	.STRL "robot"
	.PROP 4,P?SYNONYM
	W?ROBOT
	W?DEVICE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	ROBOT-F
	.BYTE	0
	.ENDT

T?WOODEN-WALL::	.TABLE			; TABLE FOR OBJECT WOODEN-WALL
	.STRL "wooden wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 2,P?ADJECTIVE
	.BYTE A?WOOD
	.BYTE A?WOODEN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WOODEN-WALL-F
	.BYTE	0
	.ENDT

T?ROCKY-ROOM::	.TABLE			; TABLE FOR OBJECT ROCKY-ROOM
	.STRL "Crystal Grotto"
	.PROP 1,P?WEST
	.BYTE TIGHT-SQUEEZE
	.PROP 1,P?SOUTH
	.BYTE WIDE-HALL
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?110
	.PROP 2,P?GLOBAL
	.BYTE MOSS
	.BYTE CRYSTALS
	.BYTE	0
	.ENDT

T?WOODEN-DOOR::	.TABLE			; TABLE FOR OBJECT WOODEN-DOOR
	.STRL "wooden door"
	.PROP 2,P?SYNONYM
	W?DOOR
	.PROP 3,P?ADJECTIVE
	.BYTE A?WOODEN
	.BYTE A?WOOD
	.BYTE A?NORTH
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WOODEN-DOOR-F
	.BYTE	0
	.ENDT

T?BROKEN-STAFF::	.TABLE			; TABLE FOR OBJECT BROKEN-STAFF
	.STRL "broken staff"
	.PROP 2,P?SYNONYM
	W?STAFF
	.PROP 1,P?ADJECTIVE
	.BYTE A?BROKEN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	STAFF-F
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	10
	.BYTE	0
	.ENDT

T?MID-CP-ANTE::	.TABLE			; TABLE FOR OBJECT MID-CP-ANTE
	.STRL "Royal Puzzle Entrance"
	.PROP 1,P?NORTH
	.BYTE MID-MUSEUM-ENTRANCE
	.PROP 1,P?WEST
	.BYTE MID-CP-OUT
	.PROP 1,P?UP
	.BYTE MID-MUSEUM-ENTRANCE
	.PROP 3,P?DOWN
	.WORD CPENTER
	.BYTE 0
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CPANT-ROOM
	.PROP 1,P?GLOBAL
	.BYTE STAIRS
	.BYTE	0
	.ENDT

T?CPLADDER::	.TABLE			; TABLE FOR OBJECT CPLADDER
	.STRL "ladder"
	.PROP 2,P?SYNONYM
	W?LADDER
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CPLADDER-OBJECT
	.BYTE	0
	.ENDT

T?DEAD-END::	.TABLE			; TABLE FOR OBJECT DEAD-END
	.STRL "Dead End"
	.PROP 1,P?WEST
	.BYTE DAMP-PASSAGE
	.PROP 1,P?NW
	.BYTE MSTAIRS
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?13
	.BYTE	0
	.ENDT

T?BLACK-PANEL::	.TABLE			; TABLE FOR OBJECT BLACK-PANEL
	.STRL "black panel"
	.PROP 4,P?SYNONYM
	W?WALL
	W?PANEL
	.PROP 1,P?ADJECTIVE
	.BYTE A?BLACK
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MPANELS
	.BYTE	0
	.ENDT

T?SUNDIAL::	.TABLE			; TABLE FOR OBJECT SUNDIAL
	.STRL "sundial"
	.PROP 8,P?SYNONYM
	W?DIAL
	W?INDICATOR
	W?ARROW
	W?SUNDIAL
	.PROP 2,P?ADJECTIVE
	.BYTE A?INDICATOR
	.BYTE A?SUN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DIAL
	.BYTE	0
	.ENDT

T?CLEFT::	.TABLE			; TABLE FOR OBJECT CLEFT
	.STRL "cleft"
	.PROP 2,P?SYNONYM
	W?CLEFT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CLEFT-F
	.BYTE	0
	.ENDT

T?AMULET::	.TABLE			; TABLE FOR OBJECT AMULET
	.STRL "golden amulet"
	.PROP 4,P?SYNONYM
	W?AMULET
	W?OBJECT
	.PROP 3,P?ADJECTIVE
	.BYTE A?GOLD
	.BYTE A?GOLDEN
	.BYTE A?SHINY
	.BYTE	0
	.ENDT

T?CHASM::	.TABLE			; TABLE FOR OBJECT CHASM
	.STRL "chasm"
	.PROP 6,P?SYNONYM
	W?CHASM
	W?GORGE
	W?RAVINE
	.PROP 2,P?ADJECTIVE
	.BYTE A?ROCKY
	.BYTE A?DEEP
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CHASM-FCN
	.BYTE	0
	.ENDT

T?PRESSURIZER::	.TABLE			; TABLE FOR OBJECT PRESSURIZER
	.STRL "grey machine"
	.PROP 6,P?SYNONYM
	W?MACHINE
	W?DRYER
	W?PRESSURIZER
	.PROP 3,P?ADJECTIVE
	.BYTE A?GRAY
	.BYTE A?GREY
	.BYTE A?WASHING
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MUSEUM-PIECES
	.PROP 2,P?DESCFCN			; ATOM (CONSTANT) PROPERTY

	MUSEUM-PIECES
	.BYTE	0
	.ENDT

T?DAMP-PASSAGE::	.TABLE			; TABLE FOR OBJECT DAMP-PASSAGE
	.STRL "Damp Passage"
	.PROP 2,P?NORTH			; STRING PROPERTY
	STR?15
	.PROP 1,P?EAST
	.BYTE DEAD-END
	.PROP 1,P?WEST
	.BYTE JUNCTION
	.PROP 2,P?SOUTH			; STRING PROPERTY
	STR?16
	.PROP 1,P?NE
	.BYTE MSTAIRS
	.PROP 2,P?UP			; STRING PROPERTY
	STR?16
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?14
	.PROP 3,P?GLOBAL
	.BYTE MOSS
	.BYTE RUBBLE
	.BYTE WATER-CHANNEL
	.BYTE	0
	.ENDT

T?FISH::	.TABLE			; TABLE FOR OBJECT FISH
	.STRL "fish"
	.PROP 2,P?SYNONYM
	W?FISH
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	FISH-F
	.BYTE	0
	.ENDT

T?TREE::	.TABLE			; TABLE FOR OBJECT TREE
	.STRL "tree"
	.PROP 4,P?SYNONYM
	W?TREE
	W?TREES
	.PROP 2,P?ADJECTIVE
	.BYTE A?LARGE
	.BYTE A?TALL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TREE-F
	.BYTE	0
	.ENDT

T?ROSE::	.TABLE			; TABLE FOR OBJECT ROSE
	.STRL "compass rose"
	.PROP 2,P?SYNONYM
	W?ROSE
	.PROP 1,P?ADJECTIVE
	.BYTE A?COMPASS
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	ROSE-F
	.BYTE	0
	.ENDT

T?OLD-MAN::	.TABLE			; TABLE FOR OBJECT OLD-MAN
	.STRL "old man"
	.PROP 2,P?SYNONYM
	W?MAN
	.PROP 1,P?ADJECTIVE
	.BYTE A?OLD
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	OLD-MAN-F
	.PROP 2,P?DESCFCN			; ATOM (CONSTANT) PROPERTY

	OLD-MAN-F
	.BYTE	0
	.ENDT

T?MR-ANTE::	.TABLE			; TABLE FOR OBJECT MR-ANTE
	.STRL "Button Room"
	.PROP 1,P?NORTH
	.BYTE MREYE
	.PROP 5,P?SOUTH			; DOOR EXIT
	.BYTE MSTAIRS				; ROOM NAME
	.BYTE SECRET-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 5,P?UP			; DOOR EXIT
	.BYTE MSTAIRS				; ROOM NAME
	.BYTE SECRET-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?11
	.PROP 2,P?GLOBAL
	.BYTE SECRET-DOOR
	.BYTE STAIRS
	.PROP 8,P?PSEUDO
	W?TORCH
	TORCH-PSEUDO
	W?TORCHE
	TORCH-PSEUDO
	.BYTE	0
	.ENDT

T?WAYBREAD::	.TABLE			; TABLE FOR OBJECT WAYBREAD
	.STRL "piece of waybread"
	.PROP 6,P?SYNONYM
	W?BREAD
	W?WAYBREAD
	W?PIECE
	.PROP 2,P?ADJECTIVE
	.BYTE A?WAY
	.BYTE A?FRESH
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WAYBREAD-F
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?198
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	3
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?199
	.BYTE	0
	.ENDT

T?MRDE::	.TABLE			; TABLE FOR OBJECT MRDE
	.STRL "Narrow Room"
	.PROP 1,P?NORTH
	.BYTE FRONT-DOOR
	.PROP 3,P?WEST
	.WORD MIRIN
	.BYTE 0
	.PROP 1,P?SOUTH
	.BYTE MRG
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MRDEW
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 3,P?GLOBAL
	.BYTE MIRROR
	.BYTE PANEL
	.BYTE GUARDIAN
	.PROP 3,P?ENTER
	.WORD MIRIN
	.BYTE 0
	.BYTE	0
	.ENDT

T?ZORKMID::	.TABLE			; TABLE FOR OBJECT ZORKMID
	.STRL "zorkmid"
	.PROP 2,P?SYNONYM
	W?ZORKMID
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	ZORKMID-FUNCTION
	.BYTE	0
	.ENDT

T?LAKE-SHORE::	.TABLE			; TABLE FOR OBJECT LAKE-SHORE
	.STRL "Lake Shore"
	.PROP 1,P?NORTH
	.BYTE FOGGY-ROOM
	.PROP 2,P?SOUTH			; STRING PROPERTY
	STR?187
	.PROP 1,P?SE
	.BYTE AQ-VIEW
	.PROP 2,P?SW			; STRING PROPERTY
	STR?188
	.PROP 1,P?DOWN
	.BYTE AQ-VIEW
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?186
	.PROP 2,P?GLOBAL
	.BYTE LAKE
	.BYTE STAIRS
	.PROP 8,P?PSEUDO
	W?SHORE
	SHORE-PSEUDO
	W?BEACH
	SHORE-PSEUDO
	.BYTE	0
	.ENDT

T?JEWEL-ROOM::	.TABLE			; TABLE FOR OBJECT JEWEL-ROOM
	.STRL "Jewel Room"
	.PROP 5,P?WEST			; DOOR EXIT
	.BYTE MUSEUM-ENTRANCE				; ROOM NAME
	.BYTE JEWEL-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 5,P?OUT			; DOOR EXIT
	.BYTE MUSEUM-ENTRANCE				; ROOM NAME
	.BYTE JEWEL-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	JEWEL-ROOM-F
	.PROP 1,P?GLOBAL
	.BYTE JEWEL-DOOR
	.BYTE	0
	.ENDT

T?CPWWL::	.TABLE			; TABLE FOR OBJECT CPWWL
	.STRL "western wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 2,P?ADJECTIVE
	.BYTE A?WEST
	.BYTE A?WESTERN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CPWALL-OBJECT
	.BYTE	0
	.ENDT

T?FRONT-DOOR::	.TABLE			; TABLE FOR OBJECT FRONT-DOOR
	.STRL "Dungeon Entrance"
	.PROP 5,P?NORTH			; DOOR EXIT
	.BYTE BEHIND-DOOR				; ROOM NAME
	.BYTE DUNGEON-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 3,P?SOUTH
	.WORD MRGO
	.BYTE 0
	.PROP 1,P?SE
	.BYTE MRDE
	.PROP 1,P?SW
	.BYTE MRDW
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	FRONT-DOOR-F
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 4,P?GLOBAL
	.BYTE MASTER
	.BYTE DUNGEON-DOOR
	.BYTE DUNGEON-PANEL
	.BYTE WOODEN-WALL
	.PROP 5,P?ENTER			; DOOR EXIT
	.BYTE BEHIND-DOOR				; ROOM NAME
	.BYTE DUNGEON-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.BYTE	0
	.ENDT

T?MIRROR::	.TABLE			; TABLE FOR OBJECT MIRROR
	.STRL "mirror"
	.PROP 4,P?SYNONYM
	W?MIRROR
	W?STRUCTURE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MIRROR-FUNCTION
	.BYTE	0
	.ENDT

T?CHANNEL::	.TABLE			; TABLE FOR OBJECT CHANNEL
	.STRL "stone channel"
	.PROP 4,P?SYNONYM
	W?CHANNEL
	W?HOLE
	.PROP 1,P?ADJECTIVE
	.BYTE A?STONE
	.BYTE	0
	.ENDT

T?SAILOR::	.TABLE			; TABLE FOR OBJECT SAILOR
	.STRL "sailor"
	.PROP 6,P?SYNONYM
	W?SAILOR
	W?FOOTPAD
	W?AVIATOR
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SAILOR-FCN
	.BYTE	0
	.ENDT

T?CLIFF::	.TABLE			; TABLE FOR OBJECT CLIFF
	.STRL "Cliff"
	.PROP 1,P?EAST
	.BYTE CLEARING
	.PROP 1,P?SW
	.BYTE SHADOW-8
	.PROP 2,P?UP			; STRING PROPERTY
	STR?183
	.PROP 4,P?DOWN			; CONDITIONAL EXIT
	.BYTE CLIFF-LEDGE				; ROOM NAME
	.BYTE ROPE-FLAG				; FLAG NAME
	STR?182			; STRING
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CLIFF-F
	.PROP 4,P?GLOBAL
	.BYTE GLOBAL-MAN
	.BYTE RUBBLE
	.BYTE STONE-WALL
	.BYTE CLIFF-OBJECT
	.PROP 4,P?PSEUDO
	W?MIST
	MIST-PSEUDO
	.BYTE	0
	.ENDT

T?SHADOW::	.TABLE			; TABLE FOR OBJECT SHADOW
	.STRL "hooded figure"
	.PROP 8,P?SYNONYM
	W?SHADOW
	W?FIGURE
	W?MAN
	W?WOMAN
	.PROP 2,P?ADJECTIVE
	.BYTE A?HOODED
	.BYTE A?CLOAKED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SHADOW-F
	.PROP 2,P?DESCFCN			; ATOM (CONSTANT) PROPERTY

	SHADOW-F
	.BYTE	0
	.ENDT

T?RING::	.TABLE			; TABLE FOR OBJECT RING
	.STRL "golden ring"
	.PROP 4,P?SYNONYM
	W?RING
	W?JEWELS
	.PROP 2,P?ADJECTIVE
	.BYTE A?GOLDEN
	.BYTE A?CROWN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CROWN-JEWELS-F
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	5
	.BYTE	0
	.ENDT

T?CLEARING::	.TABLE			; TABLE FOR OBJECT CLEARING
	.STRL "Barren Area"
	.PROP 1,P?EAST
	.BYTE JUNCTION
	.PROP 1,P?WEST
	.BYTE CLIFF
	.PROP 2,P?SOUTH			; STRING PROPERTY
	STR?178
	.PROP 1,P?NW
	.BYTE SLOPE
	.PROP 2,P?SE			; STRING PROPERTY
	STR?178
	.PROP 1,P?SW
	.BYTE SHADOW-2
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?177
	.PROP 2,P?GLOBAL
	.BYTE RUBBLE
	.BYTE STONE-WALL
	.PROP 4,P?PSEUDO
	W?MIST
	MIST-PSEUDO
	.BYTE	0
	.ENDT

T?MRB::	.TABLE			; TABLE FOR OBJECT MRB
	.STRL "Hallway"
	.PROP 3,P?NORTH
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?SOUTH
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?NE
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?NW
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?SE
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?SW
	.WORD MRGO
	.BYTE 0
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MRBF
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 5,P?GLOBAL
	.BYTE MIRROR
	.BYTE PANEL
	.BYTE ROSE
	.BYTE CHANNEL
	.BYTE WOODEN-WALL
	.PROP 3,P?ENTER
	.WORD MIRIN
	.BYTE 0
	.BYTE	0
	.ENDT

T?SAND::	.TABLE			; TABLE FOR OBJECT SAND
	.STRL "sand"
	.PROP 6,P?SYNONYM
	W?SAND
	W?FLOOR
	W?BOTTOM
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SAND-F
	.BYTE	0
	.ENDT

T?CPSWL::	.TABLE			; TABLE FOR OBJECT CPSWL
	.STRL "southern wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 1,P?ADJECTIVE
	.BYTE A?SOUTH
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CPWALL-OBJECT
	.BYTE	0
	.ENDT

T?WIDE-HALL::	.TABLE			; TABLE FOR OBJECT WIDE-HALL
	.STRL "Royal Hall"
	.PROP 1,P?NORTH
	.BYTE ROCKY-ROOM
	.PROP 1,P?SOUTH
	.BYTE MUSEUM-ANTE
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?111
	.BYTE	0
	.ENDT

T?CPDOOR::	.TABLE			; TABLE FOR OBJECT CPDOOR
	.STRL "steel door"
	.PROP 2,P?SYNONYM
	W?DOOR
	.PROP 2,P?ADJECTIVE
	.BYTE A?STEEL
	.BYTE A?METAL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CPDOOR-F
	.BYTE	0
	.ENDT

T?DEBRIS::	.TABLE			; TABLE FOR OBJECT DEBRIS
	.STRL "dust and debris"
	.PROP 4,P?SYNONYM
	W?DUST
	W?DEBRIS
	.BYTE	0
	.ENDT

T?MRBW::	.TABLE			; TABLE FOR OBJECT MRBW
	.STRL "Narrow Room"
	.PROP 1,P?NORTH
	.BYTE MRC
	.PROP 3,P?EAST
	.WORD MIRIN
	.BYTE 0
	.PROP 1,P?SOUTH
	.BYTE MRA
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MRBEW
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 3,P?GLOBAL
	.BYTE MIRROR
	.BYTE PANEL
	.BYTE GUARDIAN
	.PROP 3,P?ENTER
	.WORD MIRIN
	.BYTE 0
	.BYTE	0
	.ENDT

T?TM-BUTTON::	.TABLE			; TABLE FOR OBJECT TM-BUTTON
	.STRL "button"
	.PROP 2,P?SYNONYM
	W?BUTTON
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TM-BUTTON-F
	.BYTE	0
	.ENDT

T?TM-SEAT::	.TABLE			; TABLE FOR OBJECT TM-SEAT
	.STRL "seat"
	.PROP 4,P?SYNONYM
	W?SEAT
	W?CHAIR
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TM-SEAT-F
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	20
	.BYTE	0
	.ENDT

T?TIME-MACHINE::	.TABLE			; TABLE FOR OBJECT TIME-MACHINE
	.STRL "gold machine"
	.PROP 4,P?SYNONYM
	W?MACHINE
	W?TEMPORIZER
	.PROP 3,P?ADJECTIVE
	.BYTE A?TIME
	.BYTE A?GOLD
	.BYTE A?GOLDEN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TIME-MACHINE-F
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	100
	.PROP 2,P?DESCFCN			; ATOM (CONSTANT) PROPERTY

	TIME-MACHINE-F
	.BYTE	0
	.ENDT

T?SHADOW-7::	.TABLE			; TABLE FOR OBJECT SHADOW-7
	.STRL "Land of Shadow"
	.PROP 1,P?NORTH
	.BYTE SHADOW-8
	.PROP 1,P?EAST
	.BYTE SHADOW-3
	.PROP 1,P?WEST
	.BYTE FLATHEAD-OCEAN
	.PROP 1,P?SOUTH
	.BYTE SHADOW-6
	.PROP 1,P?NE
	.BYTE SHADOW-2
	.PROP 1,P?NW
	.BYTE FLATHEAD-OCEAN
	.PROP 1,P?SE
	.BYTE SHADOW-4
	.PROP 1,P?SW
	.BYTE FLATHEAD-OCEAN
	.PROP 1,P?DOWN
	.BYTE FLATHEAD-OCEAN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SHADOW-ROOMS
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?147
	.BYTE	0
	.ENDT

T?VIEW-ROOM::	.TABLE			; TABLE FOR OBJECT VIEW-ROOM
	.STRL "Scenic Vista"
	.PROP 1,P?NORTH
	.BYTE FAR-SHORE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	VIEW-ROOM-F
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?197
	.BYTE	0
	.ENDT

T?NORTH-WALL::	.TABLE			; TABLE FOR OBJECT NORTH-WALL
	.STRL "northern wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 2,P?ADJECTIVE
	.BYTE A?NORTH
	.BYTE A?NORTHE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	RANDOM-WALL
	.BYTE	0
	.ENDT

T?LAMP::	.TABLE			; TABLE FOR OBJECT LAMP
	.STRL "lamp"
	.PROP 4,P?SYNONYM
	W?LAMP
	W?LANTERN
	.PROP 1,P?ADJECTIVE
	.BYTE A?BRASS
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	LANTERN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	15
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?2
	.BYTE	0
	.ENDT

T?COMPASS-ARROW::	.TABLE			; TABLE FOR OBJECT COMPASS-ARROW
	.STRL "compass arrow"
	.PROP 2,P?SYNONYM
	W?ARROW
	.PROP 1,P?ADJECTIVE
	.BYTE A?COMPASS
	.BYTE	0
	.ENDT

T?BLESSINGS::	.TABLE			; TABLE FOR OBJECT BLESSINGS
	.STRL "blessings"
	.PROP 4,P?SYNONYM
	W?BLESSINGS
	W?GRACES
	.BYTE	0
	.ENDT

T?SHINY-OBJECT::	.TABLE			; TABLE FOR OBJECT SHINY-OBJECT
	.STRL "shiny object"
	.PROP 4,P?SYNONYM
	W?OBJECT
	W?AMULET
	.PROP 1,P?ADJECTIVE
	.BYTE A?SHINY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SHINY-OBJECT-F
	.BYTE	0
	.ENDT

T?MID-CP-OUT::	.TABLE			; TABLE FOR OBJECT MID-CP-OUT
	.STRL "Side Room"
	.PROP 1,P?NORTH
	.BYTE MID-CP-ANTE
	.PROP 2,P?EAST			; STRING PROPERTY
	STR?3
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CPOUT-ROOM
	.PROP 2,P?GLOBAL
	.BYTE CPDOOR
	.BYTE STAIRS
	.BYTE	0
	.ENDT

T?PLAQUE::	.TABLE			; TABLE FOR OBJECT PLAQUE
	.STRL "bronze plaque"
	.PROP 4,P?SYNONYM
	W?PLAQUE
	W?TEXT
	.PROP 1,P?ADJECTIVE
	.BYTE A?BRONZE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PLAQUE-F
	.BYTE	0
	.ENDT

T?SPINNER::	.TABLE			; TABLE FOR OBJECT SPINNER
	.STRL "black machine"
	.PROP 8,P?SYNONYM
	W?MACHINE
	W?PIPES
	W?WIRES
	W?MOTORS
	.PROP 1,P?ADJECTIVE
	.BYTE A?BLACK
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MUSEUM-PIECES
	.PROP 2,P?DESCFCN			; ATOM (CONSTANT) PROPERTY

	MUSEUM-PIECES
	.BYTE	0
	.ENDT

T?EAST-WALL::	.TABLE			; TABLE FOR OBJECT EAST-WALL
	.STRL "eastern wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 2,P?ADJECTIVE
	.BYTE A?EAST
	.BYTE A?EASTERN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	RANDOM-WALL
	.BYTE	0
	.ENDT

T?SHADOW-3::	.TABLE			; TABLE FOR OBJECT SHADOW-3
	.STRL "Land of Shadow"
	.PROP 1,P?NORTH
	.BYTE SHADOW-2
	.PROP 1,P?EAST
	.BYTE SHADOW-1
	.PROP 1,P?WEST
	.BYTE SHADOW-7
	.PROP 1,P?SOUTH
	.BYTE SHADOW-4
	.PROP 1,P?NE
	.BYTE SHADOW-1
	.PROP 1,P?NW
	.BYTE SHADOW-8
	.PROP 1,P?SE
	.BYTE SHADOW-1
	.PROP 1,P?SW
	.BYTE SHADOW-6
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SHADOW-ROOMS
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?141
	.PROP 4,P?PSEUDO
	W?MIST
	MIST-PSEUDO
	.BYTE	0
	.ENDT

T?COVER::	.TABLE			; TABLE FOR OBJECT COVER
	.STRL "manhole cover"
	.PROP 2,P?SYNONYM
	W?COVER
	.PROP 2,P?ADJECTIVE
	.BYTE A?MANHOLE
	.BYTE A?LARGE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	COVER-F
	.BYTE	0
	.ENDT

T?MUSEUM-ANTE::	.TABLE			; TABLE FOR OBJECT MUSEUM-ANTE
	.STRL "Great Door"
	.PROP 1,P?NORTH
	.BYTE WIDE-HALL
	.PROP 4,P?EAST			; CONDITIONAL EXIT
	.BYTE MUSEUM-ENTRANCE				; ROOM NAME
	.BYTE CLEFT-FLAG				; FLAG NAME
	STR?113			; STRING
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MUSEUM-ANTE-F
	.PROP 2,P?GLOBAL
	.BYTE IRON-DOOR
	.BYTE CLEFT
	.BYTE	0
	.ENDT

T?GLOBAL-ROPE::	.TABLE			; TABLE FOR OBJECT GLOBAL-ROPE
	.STRL "rope"
	.PROP 2,P?SYNONYM
	W?ROPE
	.PROP 1,P?ADJECTIVE
	.BYTE A?DANGLING
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GLOBAL-ROPE-F
	.BYTE	0
	.ENDT

T?DEAD-END-5::	.TABLE			; TABLE FOR OBJECT DEAD-END-5
	.STRL "Dead End"
	.PROP 1,P?NORTH
	.BYTE LADDER-BOTTOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?222
	.BYTE	0
	.ENDT

T?MAN::	.TABLE			; TABLE FOR OBJECT MAN
	.STRL "man"
	.PROP 4,P?SYNONYM
	W?MAN
	W?FRIEND
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MAN-F
	.BYTE	0
	.ENDT

T?FAR-SHORE::	.TABLE			; TABLE FOR OBJECT FAR-SHORE
	.STRL "Western Shore"
	.PROP 2,P?EAST			; STRING PROPERTY
	STR?196
	.PROP 1,P?SOUTH
	.BYTE VIEW-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?195
	.PROP 1,P?GLOBAL
	.BYTE LAKE
	.PROP 8,P?PSEUDO
	W?SHORE
	SHORE-PSEUDO
	W?BEACH
	SHORE-PSEUDO
	.BYTE	0
	.ENDT

T?LUNGS::	.TABLE			; TABLE FOR OBJECT LUNGS
	.STRL "blast of air"
	.PROP 8,P?SYNONYM
	W?LUNGS
	W?AIR
	W?MOUTH
	W?BREATH
	.BYTE	0
	.ENDT

T?WEST-WALL::	.TABLE			; TABLE FOR OBJECT WEST-WALL
	.STRL "western wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 2,P?ADJECTIVE
	.BYTE A?WEST
	.BYTE A?WESTERN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	RANDOM-WALL
	.BYTE	0
	.ENDT

T?CP-ANTE::	.TABLE			; TABLE FOR OBJECT CP-ANTE
	.STRL "Royal Puzzle Entrance"
	.PROP 1,P?NORTH
	.BYTE MUSEUM-ENTRANCE
	.PROP 1,P?WEST
	.BYTE CP-OUT
	.PROP 1,P?UP
	.BYTE MUSEUM-ENTRANCE
	.PROP 3,P?DOWN
	.WORD CPENTER
	.BYTE 0
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CPANT-ROOM
	.PROP 1,P?GLOBAL
	.BYTE STAIRS
	.BYTE	0
	.ENDT

T?ALGAE::	.TABLE			; TABLE FOR OBJECT ALGAE
	.STRL "plants and algae"
	.PROP 6,P?SYNONYM
	W?PLANT
	W?PLANTS
	W?ALGAE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	ALGAE-F
	.BYTE	0
	.ENDT

T?BROKEN-LAMP::	.TABLE			; TABLE FOR OBJECT BROKEN-LAMP
	.STRL "broken lantern"
	.PROP 4,P?SYNONYM
	W?LAMP
	W?LANTERN
	.PROP 2,P?ADJECTIVE
	.BYTE A?BROKEN
	.BYTE A?BRASS
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	15
	.BYTE	0
	.ENDT

T?STONE::	.TABLE			; TABLE FOR OBJECT STONE
	.STRL "great rock"
	.PROP 4,P?SYNONYM
	W?ROCK
	W?STONE
	.PROP 1,P?ADJECTIVE
	.BYTE A?GREAT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	STONE-F
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	30
	.PROP 2,P?DESCFCN			; ATOM (CONSTANT) PROPERTY

	STONE-DESC
	.BYTE	0
	.ENDT

T?DUNGEON-PANEL::	.TABLE			; TABLE FOR OBJECT DUNGEON-PANEL
	.STRL "panel"
	.PROP 2,P?SYNONYM
	W?PANEL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DUNGEON-PANEL-F
	.BYTE	0
	.ENDT

T?HOOD::	.TABLE			; TABLE FOR OBJECT HOOD
	.STRL "hood"
	.PROP 2,P?SYNONYM
	W?HOOD
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	HOOD-F
	.BYTE	0
	.ENDT

T?CP-SLOT::	.TABLE			; TABLE FOR OBJECT CP-SLOT
	.STRL "small slot"
	.PROP 6,P?SYNONYM
	W?CPSLT
	W?SLIT
	W?SLOT
	.PROP 1,P?ADJECTIVE
	.BYTE A?SMALL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CP-SLOT-FCN
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	4
	.BYTE	0
	.ENDT

T?GRUE::	.TABLE			; TABLE FOR OBJECT GRUE
	.STRL "lurking grue"
	.PROP 2,P?SYNONYM
	W?GRUE
	.PROP 4,P?ADJECTIVE
	.BYTE A?LURKING
	.BYTE A?SINISTER
	.BYTE A?HUNGRY
	.BYTE A?SILENT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GRUE-FUNCTION
	.BYTE	0
	.ENDT

T?MRGE::	.TABLE			; TABLE FOR OBJECT MRGE
	.STRL "Narrow Room"
	.PROP 1,P?NORTH
	.BYTE MRD
	.PROP 3,P?WEST
	.WORD MIRIN
	.BYTE 0
	.PROP 1,P?SOUTH
	.BYTE MRC
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GUARDIANS
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 3,P?GLOBAL
	.BYTE MIRROR
	.BYTE PANEL
	.BYTE GUARDIAN
	.PROP 3,P?ENTER
	.WORD MIRIN
	.BYTE 0
	.BYTE	0
	.ENDT

T?GUARDIAN::	.TABLE			; TABLE FOR OBJECT GUARDIAN
	.STRL "Guardians of Zork"
	.PROP 8,P?SYNONYM
	W?STATUE
	W?GUARDIAN
	W?GUARD
	W?GUARDS
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GUARDIANS
	.BYTE	0
	.ENDT

T?GOOD-LOCKED-DOOR::	.TABLE			; TABLE FOR OBJECT GOOD-LOCKED-DOOR
	.STRL "cell door"
	.PROP 2,P?SYNONYM
	W?DOOR
	.PROP 4,P?ADJECTIVE
	.BYTE A?LOCKED
	.BYTE A?WOOD
	.BYTE A?WOODEN
	.BYTE A?CELL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	LOCKED-DOOR-F
	.BYTE	0
	.ENDT

T?STAIRS::	.TABLE			; TABLE FOR OBJECT STAIRS
	.STRL "stairs"
	.PROP 8,P?SYNONYM
	W?STAIRS
	W?STEPS
	W?STAIRCASE
	W?STAIRWAY
	.PROP 5,P?ADJECTIVE
	.BYTE A?STONE
	.BYTE A?DARK
	.BYTE A?MARBLE
	.BYTE A?FORBIDDING
	.BYTE A?STEEP
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	STAIRS-F
	.BYTE	0
	.ENDT

T?DARK-2::	.TABLE			; TABLE FOR OBJECT DARK-2
	.STRL "Dark Place"
	.PROP 1,P?NORTH
	.BYTE DARK-1
	.PROP 1,P?EAST
	.BYTE KEY-ROOM
	.PROP 1,P?UP
	.BYTE KEY-ROOM
	.PROP 1,P?DOWN
	.BYTE DARK-1
	.BYTE	0
	.ENDT

T?AQUEDUCT::	.TABLE			; TABLE FOR OBJECT AQUEDUCT
	.STRL "aqueduct"
	.PROP 6,P?SYNONYM
	W?AQUEDUCT
	W?DUCT
	W?CHASM
	.PROP 1,P?ADJECTIVE
	.BYTE A?STONE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	AQUEDUCT-F
	.BYTE	0
	.ENDT

T?WOODEN-BAR::	.TABLE			; TABLE FOR OBJECT WOODEN-BAR
	.STRL "wooden bar"
	.PROP 2,P?SYNONYM
	W?BAR
	.PROP 2,P?ADJECTIVE
	.BYTE A?WOOD
	.BYTE A?WOODEN
	.BYTE	0
	.ENDT

T?TIMBERS::	.TABLE			; TABLE FOR OBJECT TIMBERS
	.STRL "broken timber"
	.PROP 4,P?SYNONYM
	W?TIMBERS
	W?PILE
	.PROP 2,P?ADJECTIVE
	.BYTE A?WOODEN
	.BYTE A?BROKEN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	50
	.BYTE	0
	.ENDT

T?BEHIND-DOOR::	.TABLE			; TABLE FOR OBJECT BEHIND-DOOR
	.STRL "Narrow Corridor"
	.PROP 1,P?NORTH
	.BYTE SOUTH-CORRIDOR
	.PROP 5,P?SOUTH			; DOOR EXIT
	.BYTE FRONT-DOOR				; ROOM NAME
	.BYTE DUNGEON-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	BEHIND-DOOR-F
	.PROP 2,P?GLOBAL
	.BYTE DUNGEON-DOOR
	.BYTE DUNGEON-PANEL
	.BYTE	0
	.ENDT

T?IN-MIRROR::	.TABLE			; TABLE FOR OBJECT IN-MIRROR
	.STRL "Inside Mirror"
	.PROP 3,P?NORTH
	.WORD MIROUT
	.BYTE 0
	.PROP 3,P?EAST
	.WORD MIROUT
	.BYTE 0
	.PROP 3,P?WEST
	.WORD MIROUT
	.BYTE 0
	.PROP 3,P?SOUTH
	.WORD MIROUT
	.BYTE 0
	.PROP 3,P?NE
	.WORD MIROUT
	.BYTE 0
	.PROP 3,P?NW
	.WORD MIROUT
	.BYTE 0
	.PROP 3,P?SE
	.WORD MIROUT
	.BYTE 0
	.PROP 3,P?SW
	.WORD MIROUT
	.BYTE 0
	.PROP 3,P?OUT
	.WORD MIROUT
	.BYTE 0
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MAGIC-MIRROR
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 3,P?GLOBAL
	.BYTE ROSE
	.BYTE CHANNEL
	.BYTE GUARDIAN
	.BYTE	0
	.ENDT

T?MRCE::	.TABLE			; TABLE FOR OBJECT MRCE
	.STRL "Narrow Room"
	.PROP 1,P?NORTH
	.BYTE MRG
	.PROP 3,P?WEST
	.WORD MIRIN
	.BYTE 0
	.PROP 1,P?SOUTH
	.BYTE MRB
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MRCEW
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 3,P?GLOBAL
	.BYTE MIRROR
	.BYTE PANEL
	.BYTE GUARDIAN
	.PROP 3,P?ENTER
	.WORD MIRIN
	.BYTE 0
	.BYTE	0
	.ENDT

T?WEST-CORRIDOR::	.TABLE			; TABLE FOR OBJECT WEST-CORRIDOR
	.STRL "West Corridor"
	.PROP 1,P?NORTH
	.BYTE NORTH-CORRIDOR
	.PROP 1,P?SOUTH
	.BYTE SOUTH-CORRIDOR
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?18
	.BYTE	0
	.ENDT

T?AQ-3::	.TABLE			; TABLE FOR OBJECT AQ-3
	.STRL "Water Slide"
	.PROP 1,P?NORTH
	.BYTE DAMP-PASSAGE
	.PROP 4,P?SOUTH			; CONDITIONAL EXIT
	.BYTE AQ-2				; ROOM NAME
	.BYTE AQ-FLAG				; FLAG NAME
	STR?240			; STRING
	.PROP 1,P?DOWN
	.BYTE DAMP-PASSAGE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	AQ-3-F
	.PROP 3,P?GLOBAL
	.BYTE AQUEDUCT
	.BYTE WATER-CHANNEL
	.BYTE MOSS
	.PROP 4,P?PSEUDO
	W?ARCH
	ARCH-PSEUDO
	.BYTE	0
	.ENDT

T?WATER::	.TABLE			; TABLE FOR OBJECT WATER
	.STRL "quantity of water"
	.PROP 8,P?SYNONYM
	W?WATER
	W?QUANTITY
	W?LIQUID
	W?H2O
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WATER-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?1
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	4
	.BYTE	0
	.ENDT

T?GROUND::	.TABLE			; TABLE FOR OBJECT GROUND
	.STRL "ground"
	.PROP 8,P?SYNONYM
	W?GROUND
	W?SAND
	W?DIRT
	W?FLOOR
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GROUND-FUNCTION
	.BYTE	0
	.ENDT

T?NOT-HERE-OBJECT::	.TABLE			; TABLE FOR OBJECT NOT-HERE-OBJECT
	.STRL "such thing"
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	NOT-HERE-OBJECT-F
	.BYTE	0
	.ENDT

T?INTNUM::	.TABLE			; TABLE FOR OBJECT INTNUM
	.STRL "number"
	.PROP 2,P?SYNONYM
	W?INTNUM
	.BYTE	0
	.ENDT

T?FRIED-TORCH::	.TABLE			; TABLE FOR OBJECT FRIED-TORCH
	.STRL "burned-out torch"
	.PROP 2,P?SYNONYM
	W?TORCH
	.PROP 2,P?ADJECTIVE
	.BYTE A?BURNED
	.BYTE A?DEAD
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	FRIED-TORCH-F
	.BYTE	0
	.ENDT

T?MRA::	.TABLE			; TABLE FOR OBJECT MRA
	.STRL "Hallway"
	.PROP 3,P?NORTH
	.WORD MRGO
	.BYTE 0
	.PROP 1,P?SOUTH
	.BYTE MREYE
	.PROP 3,P?NE
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?NW
	.WORD MRGO
	.BYTE 0
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MRAF
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 5,P?GLOBAL
	.BYTE MIRROR
	.BYTE PANEL
	.BYTE ROSE
	.BYTE CHANNEL
	.BYTE WOODEN-WALL
	.PROP 3,P?ENTER
	.WORD MIRIN
	.BYTE 0
	.BYTE	0
	.ENDT

T?SHADOW-8::	.TABLE			; TABLE FOR OBJECT SHADOW-8
	.STRL "Land of Shadow"
	.PROP 1,P?NORTH
	.BYTE CLIFF
	.PROP 1,P?EAST
	.BYTE SHADOW-2
	.PROP 1,P?WEST
	.BYTE FLATHEAD-OCEAN
	.PROP 1,P?SOUTH
	.BYTE SHADOW-7
	.PROP 2,P?NE			; STRING PROPERTY
	STR?140
	.PROP 2,P?NW			; STRING PROPERTY
	STR?140
	.PROP 1,P?SE
	.BYTE SHADOW-3
	.PROP 1,P?SW
	.BYTE FLATHEAD-OCEAN
	.PROP 1,P?DOWN
	.BYTE FLATHEAD-OCEAN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SHADOW-ROOMS
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?148
	.PROP 2,P?GLOBAL
	.BYTE RUBBLE
	.BYTE STONE-WALL
	.BYTE	0
	.ENDT

T?WARNING-NOTE::	.TABLE			; TABLE FOR OBJECT WARNING-NOTE
	.STRL "warning note"
	.PROP 6,P?SYNONYM
	W?NOTE
	W?WARNING
	W?TEXT
	.PROP 2,P?ADJECTIVE
	.BYTE A?WARNING
	.BYTE A?SMALL
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	2
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?4
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?5
	.BYTE	0
	.ENDT

T?MSTAIRS::	.TABLE			; TABLE FOR OBJECT MSTAIRS
	.STRL "Engravings Room"
	.PROP 5,P?NORTH			; DOOR EXIT
	.BYTE MR-ANTE				; ROOM NAME
	.BYTE SECRET-DOOR			; DOOR NAME
	STR?12
	.BYTE 0				; STRING TO PRINT
	.PROP 1,P?SE
	.BYTE DEAD-END
	.PROP 1,P?SW
	.BYTE DAMP-PASSAGE
	.PROP 5,P?DOWN			; DOOR EXIT
	.BYTE MR-ANTE				; ROOM NAME
	.BYTE SECRET-DOOR			; DOOR NAME
	STR?12
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MSTAIRS-F
	.PROP 2,P?GLOBAL
	.BYTE SECRET-DOOR
	.BYTE STAIRS
	.BYTE	0
	.ENDT

T?MID-MUSEUM-ENTRANCE::	.TABLE			; TABLE FOR OBJECT MID-MUSEUM-ENTRANCE
	.STRL "Museum Entrance"
	.PROP 5,P?NORTH			; DOOR EXIT
	.BYTE MID-TECH-MUSEUM				; ROOM NAME
	.BYTE WOODEN-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 5,P?EAST			; DOOR EXIT
	.BYTE MID-JEWEL-ROOM				; ROOM NAME
	.BYTE JEWEL-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?WEST			; STRING PROPERTY
	STR?114
	.PROP 1,P?SOUTH
	.BYTE MID-CP-ANTE
	.PROP 1,P?DOWN
	.BYTE MID-CP-ANTE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MUSEUM-ENTRANCE-F
	.PROP 4,P?GLOBAL
	.BYTE IRON-DOOR
	.BYTE JEWEL-DOOR
	.BYTE WOODEN-DOOR
	.BYTE STAIRS
	.BYTE	0
	.ENDT

T?JEWELLED-KNIFE::	.TABLE			; TABLE FOR OBJECT JEWELLED-KNIFE
	.STRL "jewelled knife"
	.PROP 4,P?SYNONYM
	W?KNIFE
	W?JEWELS
	.PROP 2,P?ADJECTIVE
	.BYTE A?JEWELLED
	.BYTE A?CROWN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CROWN-JEWELS-F
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	20
	.BYTE	0
	.ENDT

T?T-BAR::	.TABLE			; TABLE FOR OBJECT T-BAR
	.STRL "T-bar"
	.PROP 4,P?SYNONYM
	W?T-BAR
	W?BAR
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	T-BAR-F
	.BYTE	0
	.ENDT

T?TECH-MUSEUM::	.TABLE			; TABLE FOR OBJECT TECH-MUSEUM
	.STRL "Technology Museum"
	.PROP 5,P?SOUTH			; DOOR EXIT
	.BYTE MUSEUM-ENTRANCE				; ROOM NAME
	.BYTE WOODEN-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 5,P?OUT			; DOOR EXIT
	.BYTE MUSEUM-ENTRANCE				; ROOM NAME
	.BYTE WOODEN-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TECH-MUSEUM-F
	.PROP 1,P?GLOBAL
	.BYTE WOODEN-DOOR
	.BYTE	0
	.ENDT

T?DARK-1::	.TABLE			; TABLE FOR OBJECT DARK-1
	.STRL "Dark Place"
	.PROP 1,P?NORTH
	.BYTE SOUTH-SHORE
	.PROP 1,P?SOUTH
	.BYTE DARK-2
	.PROP 1,P?UP
	.BYTE DARK-2
	.PROP 1,P?DOWN
	.BYTE SOUTH-SHORE
	.BYTE	0
	.ENDT

T?MRAW::	.TABLE			; TABLE FOR OBJECT MRAW
	.STRL "Narrow Room"
	.PROP 1,P?NORTH
	.BYTE MRB
	.PROP 3,P?EAST
	.WORD MIRIN
	.BYTE 0
	.PROP 1,P?SOUTH
	.BYTE MREYE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MRAEW
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 3,P?GLOBAL
	.BYTE MIRROR
	.BYTE PANEL
	.BYTE GUARDIAN
	.PROP 3,P?ENTER
	.WORD MIRIN
	.BYTE 0
	.BYTE	0
	.ENDT

T?OLD-JEWEL-ROOM::	.TABLE			; TABLE FOR OBJECT OLD-JEWEL-ROOM
	.STRL "Jewel Room"
	.PROP 5,P?WEST			; DOOR EXIT
	.BYTE OLD-MUSEUM-ENTRANCE				; ROOM NAME
	.BYTE JEWEL-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 5,P?OUT			; DOOR EXIT
	.BYTE OLD-MUSEUM-ENTRANCE				; ROOM NAME
	.BYTE JEWEL-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	OLD-TECH-MUSEUM-F
	.PROP 2,P?GLOBAL
	.BYTE JEWEL-DOOR
	.BYTE ROBOT
	.BYTE	0
	.ENDT

T?SCEPTRE::	.TABLE			; TABLE FOR OBJECT SCEPTRE
	.STRL "sceptre"
	.PROP 4,P?SYNONYM
	W?SCEPTRE
	W?JEWELS
	.PROP 1,P?ADJECTIVE
	.BYTE A?CROWN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CROWN-JEWELS-F
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	30
	.BYTE	0
	.ENDT

T?FLATHEAD-OCEAN::	.TABLE			; TABLE FOR OBJECT FLATHEAD-OCEAN
	.STRL "Flathead Ocean"
	.PROP 1,P?NORTH
	.BYTE CLIFF-BASE
	.PROP 1,P?EAST
	.BYTE SHADOW-7
	.PROP 2,P?WEST			; STRING PROPERTY
	STR?149
	.PROP 2,P?SOUTH			; STRING PROPERTY
	STR?150
	.PROP 1,P?NE
	.BYTE SHADOW-8
	.PROP 2,P?NW			; STRING PROPERTY
	STR?149
	.PROP 1,P?SE
	.BYTE SHADOW-6
	.PROP 2,P?SW			; STRING PROPERTY
	STR?149
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	FLATHEAD-OCEAN-F
	.PROP 2,P?ENTER			; STRING PROPERTY
	STR?149
	.PROP 8,P?PSEUDO
	W?QUICKS
	QUICKSAND-PSEUDO
	W?MIST
	MIST-PSEUDO
	.BYTE	0
	.ENDT

T?AQ-2::	.TABLE			; TABLE FOR OBJECT AQ-2
	.STRL "High Arch"
	.PROP 4,P?NORTH			; CONDITIONAL EXIT
	.BYTE AQ-3				; ROOM NAME
	.BYTE AQ-FLAG				; FLAG NAME
	STR?238			; STRING
	.PROP 1,P?SOUTH
	.BYTE AQ-1
	.PROP 2,P?DOWN			; STRING PROPERTY
	STR?239
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	AQ-2-F
	.PROP 3,P?GLOBAL
	.BYTE AQUEDUCT
	.BYTE WATER-CHANNEL
	.BYTE MOSS
	.PROP 4,P?PSEUDO
	W?ARCH
	ARCH-PSEUDO
	.BYTE	0
	.ENDT

T?CELL-DOOR::	.TABLE			; TABLE FOR OBJECT CELL-DOOR
	.STRL "cell door"
	.PROP 2,P?SYNONYM
	W?DOOR
	.PROP 3,P?ADJECTIVE
	.BYTE A?WOOD
	.BYTE A?WOODEN
	.BYTE A?CELL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CELL-DOOR-F
	.BYTE	0
	.ENDT

T?ON-LAKE::	.TABLE			; TABLE FOR OBJECT ON-LAKE
	.STRL "On the Lake"
	.PROP 1,P?NORTH
	.BYTE LAKE-SHORE
	.PROP 2,P?EAST			; STRING PROPERTY
	STR?192
	.PROP 1,P?WEST
	.BYTE FAR-SHORE
	.PROP 1,P?SOUTH
	.BYTE SOUTH-SHORE
	.PROP 2,P?NE			; STRING PROPERTY
	STR?192
	.PROP 1,P?NW
	.BYTE FAR-SHORE
	.PROP 2,P?SE			; STRING PROPERTY
	STR?192
	.PROP 1,P?SW
	.BYTE SOUTH-SHORE
	.PROP 1,P?DOWN
	.BYTE IN-LAKE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	ON-LAKE-F
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?191
	.PROP 2,P?GLOBAL
	.BYTE LAKE
	.BYTE FISH
	.PROP 4,P?PSEUDO
	W?SWAMP
	SWAMP-PSEUDO
	.BYTE	0
	.ENDT

T?FRIED-LAMP::	.TABLE			; TABLE FOR OBJECT FRIED-LAMP
	.STRL "lamp"
	.PROP 4,P?SYNONYM
	W?LAMP
	W?LANTERN
	.PROP 1,P?ADJECTIVE
	.BYTE A?BRASS
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	FRIED-LAMP-F
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	10
	.BYTE	0
	.ENDT

T?SHADOW-4::	.TABLE			; TABLE FOR OBJECT SHADOW-4
	.STRL "Land of Shadow"
	.PROP 1,P?NORTH
	.BYTE SHADOW-3
	.PROP 1,P?EAST
	.BYTE SHADOW-1
	.PROP 1,P?WEST
	.BYTE SHADOW-6
	.PROP 1,P?SOUTH
	.BYTE SHADOW-5
	.PROP 1,P?NE
	.BYTE SHADOW-1
	.PROP 1,P?NW
	.BYTE SHADOW-7
	.PROP 1,P?SE
	.BYTE SHADOW-5
	.PROP 2,P?SW			; STRING PROPERTY
	STR?143
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SHADOW-ROOMS
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?142
	.BYTE	0
	.ENDT

T?CPNWL::	.TABLE			; TABLE FOR OBJECT CPNWL
	.STRL "northern wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 1,P?ADJECTIVE
	.BYTE A?NORTH
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CPWALL-OBJECT
	.BYTE	0
	.ENDT

T?CP-OUT::	.TABLE			; TABLE FOR OBJECT CP-OUT
	.STRL "Side Room"
	.PROP 1,P?NORTH
	.BYTE CP-ANTE
	.PROP 4,P?EAST			; CONDITIONAL EXIT
	.BYTE CP				; ROOM NAME
	.BYTE CP-FLAG				; FLAG NAME
	STR?3			; STRING
	.PROP 1,P?UP
	.BYTE CP-ANTE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CPOUT-ROOM
	.PROP 2,P?GLOBAL
	.BYTE CPDOOR
	.BYTE STAIRS
	.BYTE	0
	.ENDT

T?GLOBAL-MAN::	.TABLE			; TABLE FOR OBJECT GLOBAL-MAN
	.STRL "man"
	.PROP 4,P?SYNONYM
	W?MAN
	W?FRIEND
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GLOBAL-MAN-F
	.BYTE	0
	.ENDT

T?SOUTH-CORRIDOR::	.TABLE			; TABLE FOR OBJECT SOUTH-CORRIDOR
	.STRL "South Corridor"
	.PROP 3,P?NORTH
	.WORD BRONZE-DOOR-EXIT
	.BYTE 0
	.PROP 1,P?EAST
	.BYTE EAST-CORRIDOR
	.PROP 1,P?WEST
	.BYTE WEST-CORRIDOR
	.PROP 1,P?SOUTH
	.BYTE BEHIND-DOOR
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SOUTH-CORRIDOR-F
	.PROP 1,P?GLOBAL
	.BYTE BRONZE-DOOR
	.BYTE	0
	.ENDT

T?RED-BUTTON::	.TABLE			; TABLE FOR OBJECT RED-BUTTON
	.STRL "red button"
	.PROP 2,P?SYNONYM
	W?BUTTON
	.PROP 1,P?ADJECTIVE
	.BYTE A?RED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MRSWITCH
	.BYTE	0
	.ENDT

T?ROOM-8::	.TABLE			; TABLE FOR OBJECT ROOM-8
	.STRL "Room 8"
	.PROP 2,P?EAST			; STRING PROPERTY
	STR?226
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?225
	.BYTE	0
	.ENDT

T?STONE-WALL::	.TABLE			; TABLE FOR OBJECT STONE-WALL
	.STRL "stone wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 2,P?ADJECTIVE
	.BYTE A?STONE
	.BYTE A?MASSIVE
	.BYTE	0
	.ENDT

T?CP::	.TABLE			; TABLE FOR OBJECT CP
	.STRL "Room in a Puzzle"
	.PROP 3,P?NORTH
	.WORD CPEXIT
	.BYTE 0
	.PROP 3,P?EAST
	.WORD CPEXIT
	.BYTE 0
	.PROP 3,P?WEST
	.WORD CPEXIT
	.BYTE 0
	.PROP 3,P?SOUTH
	.WORD CPEXIT
	.BYTE 0
	.PROP 3,P?NE
	.WORD CPEXIT
	.BYTE 0
	.PROP 3,P?NW
	.WORD CPEXIT
	.BYTE 0
	.PROP 3,P?SE
	.WORD CPEXIT
	.BYTE 0
	.PROP 3,P?SW
	.WORD CPEXIT
	.BYTE 0
	.PROP 3,P?UP
	.WORD CPEXIT
	.BYTE 0
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CP-ROOM
	.PROP 6,P?GLOBAL
	.BYTE CPLADDER
	.BYTE CPDOOR
	.BYTE CPEWL
	.BYTE CPWWL
	.BYTE CPNWL
	.BYTE CPSWL
	.BYTE	0
	.ENDT

T?REPELLENT::	.TABLE			; TABLE FOR OBJECT REPELLENT
	.STRL "Frobozz Magic Grue Repellent"
	.PROP 4,P?SYNONYM
	W?REPELLENT
	W?CAN
	.PROP 2,P?ADJECTIVE
	.BYTE A?GRUE
	.BYTE A?MAGIC
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	REPELLENT-FCN
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?227
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?228
	.BYTE	0
	.ENDT

T?LONG-POLE::	.TABLE			; TABLE FOR OBJECT LONG-POLE
	.STRL "long pole"
	.PROP 2,P?SYNONYM
	W?POLE
	.PROP 2,P?ADJECTIVE
	.BYTE A?LONG
	.BYTE A?CENTER
	.BYTE	0
	.ENDT

T?RED-PANEL::	.TABLE			; TABLE FOR OBJECT RED-PANEL
	.STRL "red panel"
	.PROP 4,P?SYNONYM
	W?PANEL
	W?WALL
	.PROP 1,P?ADJECTIVE
	.BYTE A?RED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MPANELS
	.BYTE	0
	.ENDT

T?MOSS::	.TABLE			; TABLE FOR OBJECT MOSS
	.STRL "moss and lichen"
	.PROP 4,P?SYNONYM
	W?MOSS
	W?LICHEN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MOSS-F
	.BYTE	0
	.ENDT

T?IRON-DOOR::	.TABLE			; TABLE FOR OBJECT IRON-DOOR
	.STRL "iron door"
	.PROP 2,P?SYNONYM
	W?DOOR
	.PROP 1,P?ADJECTIVE
	.BYTE A?IRON
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	IRON-DOOR-F
	.BYTE	0
	.ENDT

T?TUNNEL::	.TABLE			; TABLE FOR OBJECT TUNNEL
	.STRL "tunnel"
	.PROP 4,P?SYNONYM
	W?PASSAGE
	W?CRAWLWAY
	.PROP 2,P?ADJECTIVE
	.BYTE A?DARK
	.BYTE A?SMOKY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TUNNEL-OBJECT
	.BYTE	0
	.ENDT

T?POTION::	.TABLE			; TABLE FOR OBJECT POTION
	.STRL "heavy but invisible liquid"
	.PROP 8,P?SYNONYM
	W?POTION
	W?LIQUID
	W?CONTENTS
	W?FLUID
	.PROP 4,P?ADJECTIVE
	.BYTE A?HEAVY
	.BYTE A?SWEET
	.BYTE A?INVISIBLE
	.BYTE A?SMELLING
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	POTION-F
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	2
	.BYTE	0
	.ENDT

T?SWORD::	.TABLE			; TABLE FOR OBJECT SWORD
	.STRL "sword"
	.PROP 8,P?SYNONYM
	W?SWORD
	W?ORCRIST
	W?GLAMDRING
	W?BLADE
	.PROP 3,P?ADJECTIVE
	.BYTE A?ELVISH
	.BYTE A?OLD
	.BYTE A?ANTIQUE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SWORD-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	25
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	0
	.BYTE	0
	.ENDT

T?AQ-1::	.TABLE			; TABLE FOR OBJECT AQ-1
	.STRL "Aqueduct"
	.PROP 1,P?NORTH
	.BYTE AQ-2
	.PROP 2,P?SOUTH			; STRING PROPERTY
	STR?237
	.PROP 2,P?UP			; STRING PROPERTY
	STR?235
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?236
	.PROP 3,P?GLOBAL
	.BYTE AQUEDUCT
	.BYTE WATER-CHANNEL
	.BYTE MOSS
	.PROP 4,P?PSEUDO
	W?WATERF
	WATERFALL-PSEUDO
	.BYTE	0
	.ENDT

T?GOOD-CELL::	.TABLE			; TABLE FOR OBJECT GOOD-CELL
	.STRL "Prison Cell"
	.PROP 5,P?SOUTH			; DOOR EXIT
	.BYTE NIRVANA				; ROOM NAME
	.BYTE BRONZE-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 5,P?OUT			; DOOR EXIT
	.BYTE NIRVANA				; ROOM NAME
	.BYTE BRONZE-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	NCELL-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 4,P?GLOBAL
	.BYTE GOOD-LOCKED-DOOR
	.BYTE MASTER
	.BYTE BRONZE-DOOR
	.BYTE FLAMING-PIT
	.BYTE	0
	.ENDT

T?JEWEL-DOOR::	.TABLE			; TABLE FOR OBJECT JEWEL-DOOR
	.STRL "stone door"
	.PROP 2,P?SYNONYM
	W?DOOR
	.PROP 2,P?ADJECTIVE
	.BYTE A?STONE
	.BYTE A?EAST
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	JEWEL-DOOR-F
	.BYTE	0
	.ENDT

T?PARAPET-OBJ::	.TABLE			; TABLE FOR OBJECT PARAPET-OBJ
	.STRL "parapet"
	.PROP 2,P?SYNONYM
	W?PARAPET
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PARAPET-OBJ-F
	.BYTE	0
	.ENDT

T?DUNGEON-DOOR::	.TABLE			; TABLE FOR OBJECT DUNGEON-DOOR
	.STRL "wooden door"
	.PROP 2,P?SYNONYM
	W?DOOR
	.PROP 2,P?ADJECTIVE
	.BYTE A?WOOD
	.BYTE A?WOODEN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DUNGEON-DOOR-F
	.BYTE	0
	.ENDT

T?OCEAN::	.TABLE			; TABLE FOR OBJECT OCEAN
	.STRL "Flathead Ocean"
	.PROP 4,P?SYNONYM
	W?OCEAN
	W?WATER
	.PROP 1,P?ADJECTIVE
	.BYTE A?FLATHEAD
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	OCEAN-F
	.BYTE	0
	.ENDT

T?BRONZE-DOOR::	.TABLE			; TABLE FOR OBJECT BRONZE-DOOR
	.STRL "bronze door"
	.PROP 2,P?SYNONYM
	W?DOOR
	.PROP 1,P?ADJECTIVE
	.BYTE A?BRONZE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	BRONZE-DOOR-F
	.BYTE	0
	.ENDT

T?ZORK-IV::	.TABLE			; TABLE FOR OBJECT ZORK-IV
	.STRL "Sacrificial Altar"
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	ZORK-IV-F
	.BYTE	0
	.ENDT

T?ZORK2-STAIR::	.TABLE			; TABLE FOR OBJECT ZORK2-STAIR
	.STRL "Endless Stair"
	.PROP 2,P?NORTH			; STRING PROPERTY
	STR?175
	.PROP 1,P?SOUTH
	.BYTE JUNCTION
	.PROP 2,P?UP			; STRING PROPERTY
	STR?175
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?174
	.PROP 1,P?GLOBAL
	.BYTE STAIRS
	.BYTE	0
	.ENDT

T?YELLOW-PANEL::	.TABLE			; TABLE FOR OBJECT YELLOW-PANEL
	.STRL "yellow panel"
	.PROP 4,P?SYNONYM
	W?PANEL
	W?WALL
	.PROP 1,P?ADJECTIVE
	.BYTE A?YELLOW
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MPANELS
	.BYTE	0
	.ENDT

T?STAFF::	.TABLE			; TABLE FOR OBJECT STAFF
	.STRL "wooden staff"
	.PROP 2,P?SYNONYM
	W?STAFF
	.PROP 1,P?ADJECTIVE
	.BYTE A?WOODEN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	STAFF-F
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	10
	.BYTE	0
	.ENDT

T?VIKING-SHIP::	.TABLE			; TABLE FOR OBJECT VIKING-SHIP
	.STRL "Viking Ship"
	.PROP 6,P?SYNONYM
	W?BOAT
	W?SHIP
	W?CRAFT
	.PROP 1,P?ADJECTIVE
	.BYTE A?VIKING
	.BYTE	0
	.ENDT

T?CP-HOLE::	.TABLE			; TABLE FOR OBJECT CP-HOLE
	.STRL "hole"
	.PROP 2,P?SYNONYM
	W?HOLE
	.PROP 1,P?ADJECTIVE
	.BYTE A?ROUND
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CP-HOLE-F
	.BYTE	0
	.ENDT

T?SOUTH-SHORE::	.TABLE			; TABLE FOR OBJECT SOUTH-SHORE
	.STRL "Southern Shore"
	.PROP 2,P?NORTH			; STRING PROPERTY
	STR?233
	.PROP 2,P?EAST			; STRING PROPERTY
	STR?232
	.PROP 1,P?SOUTH
	.BYTE DARK-1
	.PROP 1,P?UP
	.BYTE DARK-1
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?231
	.PROP 1,P?GLOBAL
	.BYTE LAKE
	.PROP 8,P?PSEUDO
	W?BEACH
	SHORE-PSEUDO
	W?SWAMP
	SWAMP-PSEUDO
	.BYTE	0
	.ENDT

T?JUNCTION::	.TABLE			; TABLE FOR OBJECT JUNCTION
	.STRL "Junction"
	.PROP 1,P?NORTH
	.BYTE ZORK2-STAIR
	.PROP 1,P?EAST
	.BYTE DAMP-PASSAGE
	.PROP 1,P?WEST
	.BYTE CLEARING
	.PROP 1,P?SOUTH
	.BYTE CREEPY-CRAWL
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?176
	.BYTE	0
	.ENDT

T?CLIFF-LEDGE::	.TABLE			; TABLE FOR OBJECT CLIFF-LEDGE
	.STRL "Cliff Ledge"
	.PROP 2,P?UP			; STRING PROPERTY
	STR?184
	.PROP 1,P?DOWN
	.BYTE CLIFF-BASE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CLIFF-LEDGE-F
	.PROP 5,P?GLOBAL
	.BYTE RUBBLE
	.BYTE GLOBAL-ROPE
	.BYTE GLOBAL-MAN
	.BYTE LEDGE
	.BYTE CLIFF-OBJECT
	.BYTE	0
	.ENDT

T?TECH-PLAQUE::	.TABLE			; TABLE FOR OBJECT TECH-PLAQUE
	.STRL "plaque"
	.PROP 4,P?SYNONYM
	W?PLAQUE
	W?TEXT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TECH-PLAQUE-F
	.BYTE	0
	.ENDT

T?CLIFF-OBJECT::	.TABLE			; TABLE FOR OBJECT CLIFF-OBJECT
	.STRL "cliff"
	.PROP 2,P?SYNONYM
	W?CLIFF
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CLIFF-OBJECT-F
	.BYTE	0
	.ENDT

T?MRBE::	.TABLE			; TABLE FOR OBJECT MRBE
	.STRL "Narrow Room"
	.PROP 1,P?NORTH
	.BYTE MRC
	.PROP 3,P?WEST
	.WORD MIRIN
	.BYTE 0
	.PROP 1,P?SOUTH
	.BYTE MRA
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MRBEW
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 3,P?GLOBAL
	.BYTE MIRROR
	.BYTE PANEL
	.BYTE GUARDIAN
	.PROP 3,P?ENTER
	.WORD MIRIN
	.BYTE 0
	.BYTE	0
	.ENDT

T?SECRET-DOOR::	.TABLE			; TABLE FOR OBJECT SECRET-DOOR
	.STRL "secret door"
	.PROP 2,P?SYNONYM
	W?DOOR
	.PROP 1,P?ADJECTIVE
	.BYTE A?SECRET
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SECRET-DOOR-F
	.BYTE	0
	.ENDT

T?LAKE::	.TABLE			; TABLE FOR OBJECT LAKE
	.STRL "lake"
	.PROP 6,P?SYNONYM
	W?LAKE
	W?WATER
	W?SURFACE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	LAKE-F
	.BYTE	0
	.ENDT

T?MRD::	.TABLE			; TABLE FOR OBJECT MRD
	.STRL "Hallway"
	.PROP 1,P?NORTH
	.BYTE FRONT-DOOR
	.PROP 3,P?SOUTH
	.WORD MRGO
	.BYTE 0
	.PROP 1,P?NE
	.BYTE FRONT-DOOR
	.PROP 1,P?NW
	.BYTE FRONT-DOOR
	.PROP 3,P?SE
	.WORD MRGO
	.BYTE 0
	.PROP 3,P?SW
	.WORD MRGO
	.BYTE 0
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MRDF
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.PROP 4,P?GLOBAL
	.BYTE ROSE
	.BYTE CHANNEL
	.BYTE GUARDIAN
	.BYTE WOODEN-WALL
	.BYTE	0
	.ENDT

T?PRISON-CELL::	.TABLE			; TABLE FOR OBJECT PRISON-CELL
	.STRL "Prison Cell"
	.PROP 2,P?OUT			; STRING PROPERTY
	STR?21
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?20
	.PROP 3,P?GLOBAL
	.BYTE LOCKED-DOOR
	.BYTE MASTER
	.BYTE FLAMING-PIT
	.BYTE	0
	.ENDT

T?PSEUDO-OBJECT::	.TABLE			; TABLE FOR OBJECT PSEUDO-OBJECT
	.STRL "pseudo"
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CRETIN-FCN
	.BYTE	0
	.ENDT

T?MUSEUM-ENTRANCE::	.TABLE			; TABLE FOR OBJECT MUSEUM-ENTRANCE
	.STRL "Museum Entrance"
	.PROP 5,P?NORTH			; DOOR EXIT
	.BYTE TECH-MUSEUM				; ROOM NAME
	.BYTE WOODEN-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 5,P?EAST			; DOOR EXIT
	.BYTE JEWEL-ROOM				; ROOM NAME
	.BYTE JEWEL-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 4,P?WEST			; CONDITIONAL EXIT
	.BYTE MUSEUM-ANTE				; ROOM NAME
	.BYTE CLEFT-FLAG				; FLAG NAME
	STR?114			; STRING
	.PROP 1,P?SOUTH
	.BYTE CP-ANTE
	.PROP 1,P?DOWN
	.BYTE CP-ANTE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MUSEUM-ENTRANCE-F
	.PROP 5,P?GLOBAL
	.BYTE IRON-DOOR
	.BYTE JEWEL-DOOR
	.BYTE WOODEN-DOOR
	.BYTE STAIRS
	.BYTE CLEFT
	.BYTE	0
	.ENDT

T?LOWER-SHAFT::	.TABLE			; TABLE FOR OBJECT LOWER-SHAFT
	.STRL "Drafty Room"
	.PROP 1,P?EAST
	.BYTE TIMBER-ROOM
	.PROP 1,P?SOUTH
	.BYTE MACHINE-ROOM
	.PROP 1,P?OUT
	.BYTE TIMBER-ROOM
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	NO-OBJS
	.BYTE	0
	.ENDT


; THE GLOBAL VARIABLES ARE ALL LOCATED HERE

GLOBAL::.TABLE
	.GVAR HERE=0
	.GVAR SCORE=0
	.GVAR MOVES=0
	.GVAR P-END-ON-PREP=0
	.GVAR SUPER-BRIEF=0
	.GVAR CLEFT-FLAG=0
	.GVAR MINUS-SEVEN=-7
	.GVAR DIRS=T?43,TABLE
	.GVAR HOLDING-ROPE=0
	.GVAR CURRENT-LAMP=LAMP
	.GVAR GUARDS-PRESENT=1
	.GVAR VERBOSE=0
	.GVAR P-BUTS=T?15,TABLE
	.GVAR P-DIR=0
	.GVAR P-ACLAUSE=0
	.GVAR P-SLOCBITS=0
	.GVAR S-STRENGTH=5
	.GVAR BEAM-BREAKER=0
	.GVAR P-MATCHLEN=0
	.GVAR P-ADVERB=0
	.GVAR INVIS=0
	.GVAR BASE-SCORE=0
	.GVAR CPPUSH-FLAG=0
	.GVAR CLOCK-WAIT=0
	.GVAR P-MULT=0
	.GVAR P-OTBL=T?10,TABLE
	.GVAR S-MISSES=T?49,TABLE
	.GVAR P-NAM=0
	.GVAR ALWAYS-LIT=0
	.GVAR C-TABLE=T?1,TABLE
	.GVAR LUCKY=1
	.GVAR DIR-TBL=T?44,TABLE
	.GVAR P-XNAM=0
	.GVAR TM-YEAR=948
	.GVAR MAN-WAITS=T?50,TABLE
	.GVAR COVER-MOVED=0
	.GVAR OOPS-TABLE=T?8,TABLE
	.GVAR P-WALK-DIR=0
	.GVAR POLEUP-FLAG=0
	.GVAR P-ANAM=0
	.GVAR PLAYER=0
	.GVAR SHADOW-DIAG=T?45,TABLE
	.GVAR CP-MOVED=0
	.GVAR YEAR=948
	.GVAR GUARDSTR=STR?71,STRING
	.GVAR P-CONT=0
	.GVAR P-STRENGTH=5
	.GVAR R-WESTS=T?34,TABLE
	.GVAR FOLFLAG=1
	.GVAR SURROUNDINGS-CHANGED=STR?120,STRING
	.GVAR P-PRSI=T?14,TABLE
	.GVAR AGAIN-LEXV=T?4,TABLE
	.GVAR CLUMSY-ROBBERY=0
	.GVAR P-DIRECTION=0
	.GVAR R-EASTS=T?33,TABLE
	.GVAR FUMBLE-NUMBER=7
	.GVAR DUMMY=T?24,TABLE
	.GVAR DESC-OBJECT=0
	.GVAR RING-STOLEN=0
	.GVAR VIEW-POINT=1
	.GVAR RING-CONCEALED=0
	.GVAR R-SOUTHS=T?31,TABLE
	.GVAR LIT=0
	.GVAR CPWALLS=T?29,TABLE
	.GVAR CHEST-OPENED=0
	.GVAR CPEXITS=T?30,TABLE
	.GVAR AQ-FLAG=1
	.GVAR P-VTBL=T?11,TABLE
	.GVAR P-XADJN=0
	.GVAR DEAD-OBJ-LOCS=T?40,TABLE
	.GVAR KEY-DESCS=T?54,TABLE
	.GVAR RESERVE-LEXV=T?5,TABLE
	.GVAR LAMP-TABLE=T?26,TABLE
	.GVAR P-ACT=0
	.GVAR P-ADJ=0
	.GVAR BLATHER=T?42,TABLE
	.GVAR CHEST-TIED=0
	.GVAR CPSOLVE-FLAG=0
	.GVAR P-LEN=0
	.GVAR MAN-FLAG=0
	.GVAR C-INTS=180
	.GVAR P-CCTBL=T?2,TABLE
	.GVAR P-LEXV=T?3,TABLE
	.GVAR LOAD-ALLOWED=100
	.GVAR SCORE-MAX=7
	.GVAR ROPE-FLAG=1
	.GVAR LAST-MOVES=0
	.GVAR CPBLOCK-FLAG=0
	.GVAR LCELL=1
	.GVAR HEAR-VOICES=STR?125,STRING
	.GVAR SPRAYED?=0
	.GVAR CHEST-LIFTED=0
	.GVAR PRSO=0
	.GVAR MAN-GONE=0
	.GVAR CPTABLE=T?28,TABLE
	.GVAR SHADOW-GONE=0
	.GVAR DM-SEEN=0
	.GVAR PNUMB=1
	.GVAR P-MERGED=0
	.GVAR SWORD-IN-STONE?=1
	.GVAR P-GWIMBIT=0
	.GVAR P-HITS=T?46,TABLE
	.GVAR VIEWS=T?53,TABLE
	.GVAR DIAG=T?39,TABLE
	.GVAR C-DEMONS=180
	.GVAR P-OCLAUSE=T?17,TABLE
	.GVAR CPHERE=1
	.GVAR MIRROR-OPEN-FLAG=0
	.GVAR P-SYNTAX=0
	.GVAR P-XADJ=0
	.GVAR SHIP-GONE=0
	.GVAR P-AADJ=0
	.GVAR MAN-POINT=0
	.GVAR LONGDIRS=T?36,TABLE
	.GVAR PRSA=0
	.GVAR LAKE-TIME=0
	.GVAR OLD-MAN-AWAKE=0
	.GVAR IN-DUNGEON=0
	.GVAR CLEFT-QUEUED?=0
	.GVAR WHEEEEE=T?19,TABLE
	.GVAR P-PRSO=T?13,TABLE
	.GVAR OLD-MAN-GONE=0
	.GVAR MYSTERY=0
	.GVAR P-AND=0
	.GVAR P-ONEOBJ=0
	.GVAR CP-FLAG=0
	.GVAR MINUS-ONE=-1
	.GVAR MIRROR-OPENED=0
	.GVAR BLOCKED-DIR=0
	.GVAR MR1-FLAG=1
	.GVAR P-INBUF=T?6,TABLE
	.GVAR DEAD=0
	.GVAR TM-POINT=0
	.GVAR JUMPLOSS=T?18,TABLE
	.GVAR SPRAY-USED?=0
	.GVAR WOOD-OPEN-FLAG=0
	.GVAR P-MERGE=T?16,TABLE
	.GVAR DEATHS=0
	.GVAR P-WON=0
	.GVAR MLOC=0
	.GVAR P-OVTBL=T?12,TABLE
	.GVAR GUARD-KILLERS=T?41,TABLE
	.GVAR WON-FLAG=0
	.GVAR P-ITBL=T?9,TABLE
	.GVAR LAKE-POINT=0
	.GVAR QUOTE-FLAG=0
	.GVAR MRSWPUSH-FLAG=0
	.GVAR P-TABLE=0
	.GVAR R-NORTHS=T?32,TABLE
	.GVAR YEAR-CLOSED=883
	.GVAR LOAD-MAX=100
	.GVAR P-GETFLAGS=0
	.GVAR SHADOW-POINT-1=0
	.GVAR YUKS=T?25,TABLE
	.GVAR CELLOBJS=T?38,TABLE
	.GVAR EMPTY-HANDED=0
	.GVAR MIRROR-FIRST=STR?81,STRING
	.GVAR OOPS-INBUF=T?7,TABLE
	.GVAR MACHINE-DAMAGED=0
	.GVAR FUMBLE-PROB=8
	.GVAR INDENTS=T?20,TABLE
	.GVAR S-HITS=T?48,TABLE
	.GVAR P-NUMBER=0
	.GVAR SECRET-DOOR-DESC=STR?102,STRING
	.GVAR BOAT-SEEN=0
	.GVAR P-OFLAG=0
	.GVAR BRONZE-DOOR-LOCKED=1
	.GVAR WINNER=0
	.GVAR P-ADJN=0
	.GVAR SNAP-LOC=0
	.GVAR AGAIN-DIR=0
	.GVAR P-MISSES=T?47,TABLE
	.GVAR SHADOW-POINT-2=0
	.GVAR FLATHEAD-HEARD=0
	.GVAR OLD-MAN-FED=0
	.GVAR DM-REASONS=T?37,TABLE
	.GVAR CPOBJS=T?27,TABLE
	.GVAR HS=0
	.GVAR LIFT-WAIT=0
	.GVAR P-IT-OBJECT=0
	.GVAR HO-HUM=T?21,TABLE
	.GVAR ACTIVE-VIEW=1
	.GVAR SWORD-STATE=0
	.GVAR MR2-FLAG=1
	.GVAR MAN-SEEN=0
	.GVAR VIEW-ROMANS=T?51,TABLE
	.GVAR DIRVEC=T?35,TABLE
	.GVAR MAN-WAITING=0
	.GVAR VIEW-ROOMS=T?52,TABLE
	.GVAR PRSI=0
	.GVAR RESERVE-PTR=0
	.GVAR MDIR=270
	.GVAR HELLOS=T?22,TABLE
	.GVAR ATTACK-MODE=0
	.GVAR GUARDIANS-SEEN=0
	.GVAR MINUS-FOUR=-4
	.GVAR P-NOT-HERE=0
	.GVAR MINUS-FIVE=-5
	.GVAR P-NCN=0
	.GVAR PREPOSITIONS=PRTBL,TABLE
	.GVAR ACTIONS=ATBL,TABLE
	.GVAR PREACTIONS=PATBL,TABLE
	.GVAR VERBS=VTBL,TABLE
	.ENDT

GLOEND::


; IMPURE TABLES ARE DEFINED HERE

IMPTBL::

T?1::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?2::	.TABLE
	0
	0
	0
	0
	.ENDT

T?3::	.TABLE
	.BYTE 59
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	.ENDT

T?4::	.TABLE
	.BYTE 59
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	.ENDT

T?5::	.TABLE
	.BYTE 59
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	.ENDT

T?6::	.TABLE
	.BYTE 120
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.ENDT

T?7::	.TABLE
	.BYTE 120
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.ENDT

T?8::	.TABLE
	0
	0
	0
	0
	.ENDT

T?9::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?10::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?11::	.TABLE
	0
	0
	0
	0
	.ENDT

T?12::	.TABLE
	0
	.BYTE 0
	.BYTE 0
	.ENDT

T?13::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?14::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?15::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?16::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?17::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?18::	.TABLE
	4
	0
	STR?27
	STR?28
	STR?29
	.ENDT

T?19::	.TABLE
	5
	0
	STR?33
	STR?34
	STR?35
	STR?36
	.ENDT

T?20::	.TABLE
	STR?41
	STR?41
	STR?42
	STR?43
	STR?44
	STR?45
	.ENDT

T?21::	.TABLE
	4
	0
	STR?46
	STR?47
	STR?48
	.ENDT

T?22::	.TABLE
	5
	0
	STR?51
	STR?52
	STR?53
	STR?54
	.ENDT

T?23::	.TABLE
	5
	0
	STR?55
	STR?56
	STR?57
	STR?58
	.ENDT

T?24::	.TABLE
	4
	0
	STR?59
	STR?60
	STR?61
	.ENDT

T?25::	.TABLE
	4
	STR?55
	STR?56
	STR?57
	STR?58
	.ENDT

T?26::	.TABLE
	300
	STR?62
	100
	STR?63
	50
	STR?64
	0
	.ENDT

T?27::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?28::	.TABLE
	1
	0
	-1
	0
	0
	-1
	0
	-1
	0
	1
	0
	-2
	0
	0
	0
	0
	0
	1
	0
	-3
	0
	0
	-1
	-1
	0
	0
	0
	-1
	0
	0
	0
	1
	1
	0
	0
	0
	1
	.ENDT

T?29::	.TABLE
	8
	CPSWL
	6
	CPNWL
	-6
	CPEWL
	1
	CPWWL
	-1
	.ENDT

T?30::	.TABLE
	16
	P?NORTH
	-6
	P?SOUTH
	6
	P?EAST
	1
	P?WEST
	-1
	P?NE
	-5
	P?NW
	-7
	P?SE
	7
	P?SW
	5
	.ENDT

T?31::	.TABLE
	7
	FRONT-DOOR
	MRD
	MRG
	MRC
	MRB
	MRA
	MREYE
	.ENDT

T?32::	.TABLE
	6
	MREYE
	MRA
	MRB
	MRC
	MRG
	MRD
	.ENDT

T?33::	.TABLE
	10
	MRA
	MRAE
	MRB
	MRBE
	MRC
	MRCE
	MRG
	MRGE
	MRD
	MRDE
	.ENDT

T?34::	.TABLE
	10
	MRA
	MRAW
	MRB
	MRBW
	MRC
	MRCW
	MRG
	MRGW
	MRD
	MRDW
	.ENDT

T?35::	.TABLE
	16
	P?NORTH
	0
	P?NE
	45
	P?EAST
	90
	P?SE
	135
	P?SOUTH
	180
	P?SW
	225
	P?WEST
	270
	P?NW
	315
	.ENDT

T?36::	.TABLE
	STR?82
	STR?83
	STR?66
	STR?84
	STR?85
	STR?86
	STR?65
	STR?87
	.ENDT

T?37::	.TABLE
	STR?95
	STR?96
	STR?97
	STR?98
	STR?99
	STR?100
	STR?101
	.ENDT

T?38::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?39::	.TABLE
	STR?103
	STR?104
	STR?105
	STR?106
	STR?107
	STR?108
	.ENDT

T?40::	.TABLE
	7
	JUNCTION
	CLEARING
	DAMP-PASSAGE
	CREEPY-CRAWL
	TIGHT-SQUEEZE
	FOGGY-ROOM
	DEAD-END
	.ENDT

T?41::	.TABLE
	4
	0
	STR?121
	STR?122
	STR?123
	.ENDT

T?42::	.TABLE
	7
	0
	STR?130
	STR?131
	STR?132
	STR?133
	STR?134
	STR?135
	.ENDT

T?43::	.TABLE
	20
	P?NORTH
	STR?82
	P?SOUTH
	STR?85
	P?EAST
	STR?66
	P?WEST
	STR?65
	P?NW
	STR?87
	P?NE
	STR?83
	P?SE
	STR?84
	P?SW
	STR?86
	P?UP
	STR?151
	P?DOWN
	STR?151
	.ENDT

T?44::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?45::	.TABLE
	STR?152
	STR?153
	STR?154
	STR?155
	STR?156
	STR?157
	.ENDT

T?46::	.TABLE
	4
	0
	STR?158
	STR?159
	STR?160
	.ENDT

T?47::	.TABLE
	6
	0
	STR?161
	STR?162
	STR?163
	STR?164
	STR?165
	.ENDT

T?48::	.TABLE
	4
	0
	STR?166
	STR?167
	STR?168
	.ENDT

T?49::	.TABLE
	5
	0
	STR?170
	STR?171
	STR?172
	STR?173
	.ENDT

T?50::	.TABLE
	7
	0
	STR?202
	STR?203
	STR?204
	STR?205
	STR?206
	STR?207
	.ENDT

T?51::	.TABLE
	0
	STR?211
	STR?212
	STR?213
	STR?214
	.ENDT

T?52::	.TABLE
	4
	TIMBER-ROOM
	ROOM-8
	DAMP-PASSAGE
	ZORK-IV
	.ENDT

T?53::	.TABLE
	4
	STR?215
	STR?216
	STR?217
	STR?218
	.ENDT

T?54::	.TABLE
	6
	0
	STR?243
	STR?244
	STR?245
	STR?246
	STR?247
	.ENDT


; END OF PURENESS

IMPURE::



; VERB TABLE IS DEFINED HERE

VTBL::	.TABLE
	ST?KISS
	ST?SKIP
	ST?INFLAT
	ST?STAY
	ST?PULL
	ST?PUT
	ST?RAPE
	ST?VERBOSE
	ST?WALK
	ST?QUIT
	ST?FIND
	ST?DESTROY
	ST?UNLOCK
	ST?READ
	ST?SAY
	ST?PUNCTURE
	ST?JUMP
	ST?POUR
	ST?WAIT
	ST?TAKE
	ST?COUNT
	ST?RAISE
	ST?FOLLOW
	ST?VERSION
	ST?WIND
	ST?#UNRECORD
	ST?LIGHT
	ST?MOVE
	ST?CHOMP
	ST?PLAY
	ST?OPEN
	ST?#COMMAND
	ST?BLOW
	ST?KNOCK
	ST?PICK
	ST?DEFLATE
	ST?BOARD
	ST?#RANDOM
	ST?APPLY
	ST?PRAY
	ST?STAND
	ST?ENCHANT
	ST?LISTEN
	ST?TIE
	ST?SAVE
	ST?TELL
	ST?THROW
	ST?ZORK
	ST?LOWER
	ST?COMMAND
	ST?TALK
	ST?SHAKE
	ST?INVENTORY
	ST?ATTACK
	ST?KILL
	ST?ENTER
	ST?SEARCH
	ST?WEAR
	ST?FROBOZZ
	ST?DISEMBARK
	ST?SWIM
	ST?LUBRICATE
	ST?PLUG
	ST?UNTIE
	ST?PUMP
	ST?CUT
	ST?UNSCRIPT
	ST?MELT
	ST?BRUSH
	ST?RING
	ST?PUSH
	ST?RUB
	ST?SUPER
	ST?BLAST
	ST?DIG
	ST?WISH
	ST?INCANT
	ST?SEND
	ST?SCORE
	ST?EXORCISE
	ST?HATCH
	ST?WIN
	ST?LOOK
	ST?ODYSSEUS
	ST?SPRAY
	ST?DROP
	ST?BACK
	ST?ROLL
	ST?LEAVE
	ST?CURSE
	ST?SCRIPT
	ST?REPENT
	ST?SPIN
	ST?$VERIFY
	ST?EXTINGUISH
	ST?SWING
	ST?RESTART
	ST?POKE
	ST?SMELL
	ST?BRIEF
	ST?ECHO
	ST?DIAGNOSE
	ST?GIVE
	ST?WAKE
	ST?DRINK
	ST?ANSWER
	ST?MUMBLE
	ST?YELL
	ST?LOCK
	ST?ACTIVATE
	ST?BURN
	ST?KICK
	ST?PLUGH
	ST?TURN
	ST?#RECORD
	ST?CROSS
	ST?STAB
	ST?MAKE
	ST?RESTORE
	ST?CLOSE
	ST?STRIKE
	ST?SLIDE
	ST?WAVE
	ST?EXIT
	ST?EXAMINE
	ST?DISENCHANT
	ST?EAT
	ST?FILL
	ST?LEAN
	ST?SQUEEZE
	ST?BUG
	ST?CLIMB
	ST?LAUNCH
	ST?TREASURE
	ST?HELLO
	.ENDT

; SYNTAX DEFINITION TABLES ARE DEFINED HERE

ST?KISS::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?KISS
	.ENDT

ST?SKIP::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SKIP
	.ENDT

ST?INFLAT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE TOOLBIT
	.BYTE 0
	.BYTE SOG+SIR+SH+SC
	.BYTE V?INFLATE
	.ENDT

ST?STAY::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?STAY
	.ENDT

ST?PULL::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?MOVE
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?MOVE
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?MOVE
	.ENDT

ST?PUT::	.TABLE
	.BYTE 7	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?BEHIND
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY+SHAVE
	.BYTE 0
	.BYTE V?PUT-BEHIND
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SIR+SOG+SC+SMANY
	.BYTE 0
	.BYTE V?WEAR
	.BYTE 1	;OBJECTS
	.BYTE PR?OUT
	.BYTE 0
	.BYTE ONBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE+SHAVE
	.BYTE 0
	.BYTE V?LAMP-OFF
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?UNDER
	.BYTE 0
	.BYTE 0
	.BYTE SH+SHAVE
	.BYTE 0
	.BYTE V?PUT-UNDER
	.BYTE 1	;OBJECTS
	.BYTE PR?DOWN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY
	.BYTE 0
	.BYTE V?DROP
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY+SHAVE
	.BYTE 0
	.BYTE V?PUT-ON
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY+SHAVE
	.BYTE 0
	.BYTE V?PUT
	.ENDT

ST?RAPE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RAPE
	.ENDT

ST?VERBOSE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?VERBOSE
	.ENDT

ST?WALK::	.TABLE
	.BYTE 11	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?DOWN
	.BYTE 0
	.BYTE CLIMBBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?CLIMB-DOWN
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE CLIMBBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?CLIMB-UP
	.BYTE 1	;OBJECTS
	.BYTE PR?AROUND
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WALK-AROUND
	.BYTE 1	;OBJECTS
	.BYTE PR?TO
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WALK-TO
	.BYTE 1	;OBJECTS
	.BYTE PR?OVER
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LEAP
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?THROUGH
	.BYTE 1	;OBJECTS
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?THROUGH
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?THROUGH
	.BYTE 1	;OBJECTS
	.BYTE PR?AWAY
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WALK
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WALK
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WALK-AROUND
	.ENDT

ST?QUIT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?QUIT
	.ENDT

ST?FIND::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?FIND
	.ENDT

ST?DESTROY::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR+SH+SC
	.BYTE 0
	.BYTE V?OPEN
	.BYTE 2	;OBJECTS
	.BYTE PR?DOWN
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR+SH+SC
	.BYTE SH+SC+STAKE
	.BYTE V?MUNG
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR+SH+SC
	.BYTE SH+SC+STAKE
	.BYTE V?MUNG
	.ENDT

ST?UNLOCK::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE TOOLBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SOG+SIR+STAKE
	.BYTE V?UNLOCK
	.ENDT

ST?READ::	.TABLE
	.BYTE 4	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE READBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE
	.BYTE 0
	.BYTE V?READ-PAGE
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE READBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE
	.BYTE 0
	.BYTE V?READ
	.BYTE 1	;OBJECTS
	.BYTE PR?FROM
	.BYTE 0
	.BYTE READBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE
	.BYTE 0
	.BYTE V?READ
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE READBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE
	.BYTE 0
	.BYTE V?READ
	.ENDT

ST?SAY::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SAY
	.ENDT

ST?PUNCTURE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE ACTORBIT
	.BYTE WEAPONBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SHAVE
	.BYTE V?MUNG
	.ENDT

ST?JUMP::	.TABLE
	.BYTE 6	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?OFF
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LEAP
	.BYTE 1	;OBJECTS
	.BYTE PR?FROM
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LEAP
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LEAP
	.BYTE 1	;OBJECTS
	.BYTE PR?ACROSS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LEAP
	.BYTE 1	;OBJECTS
	.BYTE PR?OVER
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LEAP
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LEAP
	.ENDT

ST?POUR::	.TABLE
	.BYTE 4	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?FROM
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC
	.BYTE 0
	.BYTE V?DROP
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC
	.BYTE 0
	.BYTE V?POUR-ON
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC
	.BYTE 0
	.BYTE V?DROP
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC
	.BYTE 0
	.BYTE V?DROP
	.ENDT

ST?WAIT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WAIT
	.ENDT

ST?TAKE::	.TABLE
	.BYTE 8	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?FROM
	.BYTE TAKEBIT
	.BYTE 0
	.BYTE SIR+SC+SMANY
	.BYTE 0
	.BYTE V?TAKE
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?OFF
	.BYTE TAKEBIT
	.BYTE 0
	.BYTE SC+SIR+SMANY
	.BYTE 0
	.BYTE V?TAKE
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?OUT
	.BYTE TAKEBIT
	.BYTE 0
	.BYTE SC+SIR+SMANY
	.BYTE 0
	.BYTE V?TAKE
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE RMUNGBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?STAND
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE VEHBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?CLIMB-ON
	.BYTE 1	;OBJECTS
	.BYTE PR?OUT
	.BYTE 0
	.BYTE RMUNGBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?DISEMBARK
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE VEHBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?BOARD
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE TAKEBIT
	.BYTE 0
	.BYTE SOG+SIR+SMANY
	.BYTE 0
	.BYTE V?TAKE
	.ENDT

ST?COUNT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?COUNT
	.ENDT

ST?RAISE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RAISE
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RAISE
	.ENDT

ST?FOLLOW::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?FOLLOW
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?FOLLOW
	.ENDT

ST?VERSION::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?VERSION
	.ENDT

ST?WIND::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WIND
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WIND
	.ENDT

ST?#UNRECORD::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?UNRECORD
	.ENDT

ST?LIGHT::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE LIGHTBIT
	.BYTE FLAMEBIT
	.BYTE SH+SC+SOG+SIR
	.BYTE SH+SC+STAKE+SHAVE
	.BYTE V?BURN
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE LIGHTBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE+SHAVE
	.BYTE 0
	.BYTE V?LAMP-ON
	.ENDT

ST?MOVE::	.TABLE
	.BYTE 5	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE TOOLBIT
	.BYTE 0
	.BYTE 0
	.BYTE V?TURN
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY+SHAVE
	.BYTE 0
	.BYTE V?PUT
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?TO
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?PUSH-TO
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?PUSH-TO
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?MOVE
	.ENDT

ST?CHOMP::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?CHOMP
	.ENDT

ST?PLAY::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PLAY
	.ENDT

ST?OPEN::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE DOORBIT
	.BYTE TOOLBIT
	.BYTE SH+SC+SOG+SIR
	.BYTE SOG+SIR+SH+SC+SHAVE
	.BYTE V?OPEN
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE DOORBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?OPEN
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE DOORBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?OPEN
	.ENDT

ST?#COMMAND::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?COMMAND-FILE
	.ENDT

ST?BLOW::	.TABLE
	.BYTE 4	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?BREATHE
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?BLAST
	.BYTE 2	;OBJECTS
	.BYTE PR?UP
	.BYTE PR?WITH
	.BYTE 0
	.BYTE TOOLBIT
	.BYTE 0
	.BYTE SOG+SIR+SH+SC
	.BYTE V?INFLATE
	.BYTE 1	;OBJECTS
	.BYTE PR?OUT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LAMP-OFF
	.ENDT

ST?KNOCK::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?DOWN
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?ATTACK
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?KNOCK
	.BYTE 1	;OBJECTS
	.BYTE PR?AT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?KNOCK
	.ENDT

ST?PICK::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE TAKEBIT
	.BYTE 0
	.BYTE SOG+SMANY
	.BYTE 0
	.BYTE V?TAKE
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PICK
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PICK
	.ENDT

ST?DEFLATE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?DEFLATE
	.ENDT

ST?BOARD::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE VEHBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?BOARD
	.ENDT

ST?#RANDOM::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RANDOM
	.ENDT

ST?APPLY::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?TO
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PUT
	.ENDT

ST?PRAY::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PRAY
	.ENDT

ST?STAND::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE RMUNGBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?STAND
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?STAND
	.ENDT

ST?ENCHANT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?ENCHANT
	.ENDT

ST?LISTEN::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?FOR
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LISTEN
	.BYTE 1	;OBJECTS
	.BYTE PR?TO
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LISTEN
	.ENDT

ST?TIE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE PR?UP
	.BYTE PR?WITH
	.BYTE ACTORBIT
	.BYTE TOOLBIT
	.BYTE SOG+SIR
	.BYTE SOG+SIR+SH+SC+SHAVE
	.BYTE V?TIE-UP
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?TO
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?TIE
	.ENDT

ST?SAVE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SAVE
	.ENDT

ST?TELL::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?ABOUT
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SIR
	.BYTE 0
	.BYTE V?TELL
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SIR
	.BYTE 0
	.BYTE V?TELL
	.ENDT

ST?THROW::	.TABLE
	.BYTE 7	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?OVER
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SHAVE
	.BYTE 0
	.BYTE V?THROW-OFF
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?OFF
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SHAVE
	.BYTE 0
	.BYTE V?THROW-OFF
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SHAVE
	.BYTE 0
	.BYTE V?PUT-ON
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SHAVE
	.BYTE 0
	.BYTE V?PUT
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?OVERBOARD
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE SH+SC+SHAVE
	.BYTE SOG+SIR
	.BYTE V?THROW
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?AT
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE SH+SC+SHAVE
	.BYTE SOG+SIR
	.BYTE V?THROW
	.ENDT

ST?ZORK::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?ZORK
	.ENDT

ST?LOWER::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LOWER
	.ENDT

ST?COMMAND::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?COMMAND
	.ENDT

ST?TALK::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?TO
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SIR
	.BYTE 0
	.BYTE V?TELL
	.ENDT

ST?SHAKE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SHAVE
	.BYTE 0
	.BYTE V?SHAKE
	.ENDT

ST?INVENTORY::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?INVENTORY
	.ENDT

ST?ATTACK::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE ACTORBIT
	.BYTE WEAPONBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SHAVE
	.BYTE V?ATTACK
	.ENDT

ST?KILL::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE ACTORBIT
	.BYTE WEAPONBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SHAVE
	.BYTE V?ATTACK
	.ENDT

ST?ENTER::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?THROUGH
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?ENTER
	.ENDT

ST?SEARCH::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?FOR
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?FIND
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SEARCH
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SEARCH
	.ENDT

ST?WEAR::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WEAR
	.ENDT

ST?FROBOZZ::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?FROBOZZ
	.ENDT

ST?DISEMBARK::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE VEHBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?DISEMBARK
	.ENDT

ST?SWIM::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?ACROSS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SWIM
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SWIM
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SWIM
	.ENDT

ST?LUBRICATE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC
	.BYTE V?OIL
	.ENDT

ST?PLUG::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PLUG
	.ENDT

ST?UNTIE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?FROM
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR+SH+SC
	.BYTE 0
	.BYTE V?UNTIE
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR+SH+SC
	.BYTE 0
	.BYTE V?UNTIE
	.ENDT

ST?PUMP::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE PR?UP
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PUMP
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PUMP
	.ENDT

ST?CUT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE WEAPONBIT
	.BYTE 0
	.BYTE SC+SH
	.BYTE V?CUT
	.ENDT

ST?UNSCRIPT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?UNSCRIPT
	.ENDT

ST?MELT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE FLAMEBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE V?MELT
	.ENDT

ST?BRUSH::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?BRUSH
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?BRUSH
	.ENDT

ST?RING::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE STAKE
	.BYTE 0
	.BYTE V?RING
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE STAKE
	.BYTE 0
	.BYTE V?RING
	.ENDT

ST?PUSH::	.TABLE
	.BYTE 6	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?UNDER
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PUT-UNDER
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE TOOLBIT
	.BYTE 0
	.BYTE 0
	.BYTE V?TURN
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SIR+SOG+SMANY
	.BYTE 0
	.BYTE V?PUSH
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SIR+SOG+SMANY
	.BYTE 0
	.BYTE V?PUSH
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?TO
	.BYTE 0
	.BYTE 0
	.BYTE SIR+SOG
	.BYTE 0
	.BYTE V?PUSH-TO
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SIR+SOG
	.BYTE 0
	.BYTE V?PUSH-TO
	.ENDT

ST?RUB::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RUB
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RUB
	.ENDT

ST?SUPER::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SUPER-BRIEF
	.ENDT

ST?BLAST::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?BLAST
	.ENDT

ST?DIG::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE TOOLBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SHAVE
	.BYTE V?DIG
	.BYTE 2	;OBJECTS
	.BYTE PR?IN
	.BYTE PR?WITH
	.BYTE 0
	.BYTE TOOLBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SHAVE
	.BYTE V?DIG
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?DIG
	.ENDT

ST?WISH::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WISH
	.ENDT

ST?INCANT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?INCANT
	.ENDT

ST?SEND::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?FOR
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SEND
	.ENDT

ST?SCORE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SCORE
	.ENDT

ST?EXORCISE::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?AWAY
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?EXORCISE
	.BYTE 1	;OBJECTS
	.BYTE PR?OUT
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?EXORCISE
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?EXORCISE
	.ENDT

ST?HATCH::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?HATCH
	.ENDT

ST?WIN::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WIN
	.ENDT

ST?LOOK::	.TABLE
	.BYTE 12	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?FOR
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?FIND
	.BYTE 2	;OBJECTS
	.BYTE PR?AT
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?READ
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+SMANY
	.BYTE 0
	.BYTE V?LOOK-INSIDE
	.BYTE 1	;OBJECTS
	.BYTE PR?BEHIND
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LOOK-BEHIND
	.BYTE 1	;OBJECTS
	.BYTE PR?UNDER
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LOOK-UNDER
	.BYTE 1	;OBJECTS
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+SMANY
	.BYTE 0
	.BYTE V?LOOK-INSIDE
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LOOK-ON
	.BYTE 1	;OBJECTS
	.BYTE PR?AT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+SMANY
	.BYTE 0
	.BYTE V?EXAMINE
	.BYTE 1	;OBJECTS
	.BYTE PR?DOWN
	.BYTE 0
	.BYTE RMUNGBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LOOK
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE RMUNGBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LOOK
	.BYTE 1	;OBJECTS
	.BYTE PR?AROUND
	.BYTE 0
	.BYTE RMUNGBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LOOK
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LOOK
	.ENDT

ST?ODYSSEUS::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?ODYSSEUS
	.ENDT

ST?SPRAY::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SSPRAY
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SPRAY
	.ENDT

ST?DROP::	.TABLE
	.BYTE 4	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY+SHAVE
	.BYTE 0
	.BYTE V?PUT-ON
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY+SHAVE
	.BYTE 0
	.BYTE V?PUT
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?DOWN
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY+SHAVE
	.BYTE 0
	.BYTE V?PUT
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY+SHAVE
	.BYTE 0
	.BYTE V?DROP
	.ENDT

ST?BACK::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?BACK
	.ENDT

ST?ROLL::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?MOVE
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?MOVE
	.ENDT

ST?LEAVE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?DROP
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LEAVE
	.ENDT

ST?CURSE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?CURSES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?CURSES
	.ENDT

ST?SCRIPT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SCRIPT
	.ENDT

ST?REPENT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?REPENT
	.ENDT

ST?SPIN::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SPIN
	.ENDT

ST?$VERIFY::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?VERIFY
	.ENDT

ST?EXTINGUISH::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ONBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE+SHAVE
	.BYTE 0
	.BYTE V?LAMP-OFF
	.ENDT

ST?SWING::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?AT
	.BYTE WEAPONBIT
	.BYTE ACTORBIT
	.BYTE SH+SC+SHAVE
	.BYTE SOG+SIR
	.BYTE V?SWING
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE WEAPONBIT
	.BYTE 0
	.BYTE SH+SC+SHAVE
	.BYTE 0
	.BYTE V?SWING
	.ENDT

ST?RESTART::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RESTART
	.ENDT

ST?POKE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE ACTORBIT
	.BYTE WEAPONBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SHAVE
	.BYTE V?MUNG
	.ENDT

ST?SMELL::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SMELL
	.ENDT

ST?BRIEF::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?BRIEF
	.ENDT

ST?ECHO::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?ECHO
	.ENDT

ST?DIAGNOSE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?DIAGNOSE
	.ENDT

ST?GIVE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SOG
	.BYTE SMANY+SH+SHAVE
	.BYTE V?SGIVE
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?TO
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE SMANY+SH+SHAVE
	.BYTE SOG
	.BYTE V?GIVE
	.ENDT

ST?WAKE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?ALARM
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?ALARM
	.ENDT

ST?DRINK::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?FROM
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC
	.BYTE 0
	.BYTE V?DRINK-FROM
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE DRINKBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?DRINK
	.ENDT

ST?ANSWER::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?REPLY
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?ANSWER
	.ENDT

ST?MUMBLE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?MUMBLE
	.ENDT

ST?YELL::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?YELL
	.ENDT

ST?LOCK::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE TOOLBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SOG+SIR+STAKE
	.BYTE V?LOCK
	.ENDT

ST?ACTIVATE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE LIGHTBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?LAMP-ON
	.ENDT

ST?BURN::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE PR?DOWN
	.BYTE PR?WITH
	.BYTE BURNBIT
	.BYTE FLAMEBIT
	.BYTE SH+SC+SOG+SIR
	.BYTE SH+SC+SOG+SIR+SHAVE
	.BYTE V?BURN
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE BURNBIT
	.BYTE FLAMEBIT
	.BYTE SH+SC+SOG+SIR
	.BYTE SH+SC+SOG+SIR+SHAVE
	.BYTE V?BURN
	.ENDT

ST?KICK::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?KICK
	.ENDT

ST?PLUGH::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?ADVENT
	.ENDT

ST?TURN::	.TABLE
	.BYTE 6	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?FOR
	.BYTE TURNBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?TURN
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?TO
	.BYTE TURNBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?TURN
	.BYTE 1	;OBJECTS
	.BYTE PR?OFF
	.BYTE 0
	.BYTE ONBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE+SHAVE
	.BYTE 0
	.BYTE V?LAMP-OFF
	.BYTE 2	;OBJECTS
	.BYTE PR?ON
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SHAVE
	.BYTE V?LAMP-ON
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE LIGHTBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?LAMP-ON
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE TURNBIT
	.BYTE RMUNGBIT
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?TURN
	.ENDT

ST?#RECORD::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RECORD
	.ENDT

ST?CROSS::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?CROSS
	.ENDT

ST?STAB::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE ACTORBIT
	.BYTE WEAPONBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SHAVE
	.BYTE V?ATTACK
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?STAB
	.ENDT

ST?MAKE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?MAKE
	.ENDT

ST?RESTORE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RESTORE
	.ENDT

ST?CLOSE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE DOORBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?CLOSE
	.ENDT

ST?STRIKE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR+SH+SC
	.BYTE 0
	.BYTE V?STRIKE
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE ACTORBIT
	.BYTE WEAPONBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SOG+SIR+SHAVE
	.BYTE V?ATTACK
	.ENDT

ST?SLIDE::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?TO
	.BYTE 0
	.BYTE 0
	.BYTE SIR+SOG
	.BYTE 0
	.BYTE V?PUSH-TO
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SIR+SOG
	.BYTE 0
	.BYTE V?PUSH-TO
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?UNDER
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PUT-UNDER
	.ENDT

ST?WAVE::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?AT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WAVE
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?AT
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+STAKE+SHAVE
	.BYTE 0
	.BYTE V?WAVE
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+STAKE+SHAVE
	.BYTE 0
	.BYTE V?WAVE
	.ENDT

ST?EXIT::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?EXIT
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?EXIT
	.ENDT

ST?EXAMINE::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SIR+SOG+SMANY
	.BYTE 0
	.BYTE V?LOOK-INSIDE
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SIR+SOG+SMANY
	.BYTE 0
	.BYTE V?LOOK-INSIDE
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SMANY
	.BYTE 0
	.BYTE V?EXAMINE
	.ENDT

ST?DISENCHANT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?DISENCHANT
	.ENDT

ST?EAT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE FOODBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE
	.BYTE 0
	.BYTE V?EAT
	.ENDT

ST?FILL::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE CONTBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?FILL
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE CONTBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?FILL
	.ENDT

ST?LEAN::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SHAVE
	.BYTE 0
	.BYTE V?LEAN-ON
	.ENDT

ST?SQUEEZE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PUT
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SQUEEZE
	.ENDT

ST?BUG::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?BUG
	.ENDT

ST?CLIMB::	.TABLE
	.BYTE 8	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?THROUGH
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE VEHBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?CLIMB-ON
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE VEHBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?BOARD
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE CLIMBBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?CLIMB-FOO
	.BYTE 1	;OBJECTS
	.BYTE PR?DOWN
	.BYTE 0
	.BYTE CLIMBBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?CLIMB-DOWN
	.BYTE 1	;OBJECTS
	.BYTE PR?DOWN
	.BYTE 0
	.BYTE RMUNGBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?CLIMB-DOWN
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE CLIMBBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?CLIMB-UP
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE RMUNGBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?CLIMB-UP
	.ENDT

ST?LAUNCH::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE VEHBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LAUNCH
	.ENDT

ST?TREASURE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?TREASURE
	.ENDT

ST?HELLO::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?HELLO
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?HELLO
	.ENDT


; THE ACTION CALLING TABLE IS DEFINED HERE

ATBL::	.TABLE
	V-VERBOSE
	V-BRIEF
	V-SUPER-BRIEF
	V-DIAGNOSE
	V-INVENTORY
	V-QUIT
	V-RESTART
	V-RESTORE
	V-SAVE
	V-SCORE
	V-SCRIPT
	V-UNSCRIPT
	V-VERSION
	V-VERIFY
	V-RANDOM
	V-COMMAND-FILE
	V-RECORD
	V-UNRECORD
	V-LAMP-ON
	V-ANSWER
	V-REPLY
	V-PUT
	V-ATTACK
	V-BACK
	V-BLAST
	V-LAMP-OFF
	V-INFLATE
	V-BREATHE
	V-BOARD
	V-BRUSH
	V-BUG
	V-BURN
	V-CHOMP
	V-CLIMB-UP
	V-CLIMB-DOWN
	V-CLIMB-FOO
	V-CLIMB-ON
	V-THROUGH
	V-CLOSE
	V-COMMAND
	V-COUNT
	V-CROSS
	V-CUT
	V-CURSES
	V-DEFLATE
	V-MUNG
	V-OPEN
	V-DIG
	V-DISEMBARK
	V-DISENCHANT
	V-DRINK
	V-DRINK-FROM
	V-DROP
	V-PUT-ON
	V-EAT
	V-ECHO
	V-ENCHANT
	V-ENTER
	V-EXIT
	V-EXAMINE
	V-LOOK-INSIDE
	V-EXORCISE
	V-FILL
	V-FIND
	V-FOLLOW
	V-FROBOZZ
	V-GIVE
	V-SGIVE
	V-HATCH
	V-HELLO
	V-INCANT
	V-LEAP
	V-KICK
	V-STAB
	V-KISS
	V-KNOCK
	V-LAUNCH
	V-LEAN-ON
	V-LEAVE
	V-LISTEN
	V-LOCK
	V-LOOK
	V-LOOK-ON
	V-LOOK-UNDER
	V-LOOK-BEHIND
	V-READ
	V-LOWER
	V-OIL
	V-MAKE
	V-MELT
	V-MOVE
	V-PUSH-TO
	V-TURN
	V-MUMBLE
	V-ODYSSEUS
	V-PICK
	V-TAKE
	V-PLAY
	V-PLUG
	V-ADVENT
	V-POUR-ON
	V-PRAY
	V-PUMP
	V-PUSH
	V-PUT-UNDER
	V-WEAR
	V-PUT-BEHIND
	V-RAISE
	V-RAPE
	V-READ-PAGE
	V-REPENT
	V-RING
	V-RUB
	V-TELL
	V-SAY
	V-SEARCH
	V-SEND
	V-SHAKE
	V-SKIP
	V-SMELL
	V-SPIN
	V-SPRAY
	V-SSPRAY
	V-SQUEEZE
	V-STAND
	V-STAY
	V-STRIKE
	V-SWIM
	V-SWING
	V-THROW
	V-OVERBOARD
	V-THROW-OFF
	V-TIE
	V-TIE-UP
	V-TREASURE
	V-UNLOCK
	V-UNTIE
	V-WAIT
	V-ALARM
	V-WALK-AROUND
	V-WALK
	V-WALK-TO
	V-WAVE
	V-WIN
	V-WIND
	V-WISH
	V-YELL
	V-ZORK
	.ENDT

; THE PREACTION CALLING TABLE IS DEFINED HERE

PATBL::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	PRE-PUT
	0
	0
	0
	0
	0
	0
	PRE-BOARD
	0
	0
	PRE-BURN
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	PRE-MUNG
	0
	0
	0
	0
	0
	0
	PRE-DROP
	PRE-PUT
	0
	0
	0
	0
	0
	0
	0
	0
	PRE-FILL
	0
	0
	0
	PRE-GIVE
	PRE-SGIVE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	PRE-READ
	0
	0
	0
	0
	PRE-MOVE
	0
	PRE-TURN
	0
	0
	0
	PRE-TAKE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT


; PREPOSITION TABLE IS DEFINED HERE

PRTBL::	.TABLE
	.WORD 18
	W?ABOUT
	PR?ABOUT
	W?BEHIND
	PR?BEHIND
	W?UNDER
	PR?UNDER
	W?AROUND
	PR?AROUND
	W?FOR
	PR?FOR
	W?AT
	PR?AT
	W?OFF
	PR?OFF
	W?ACROSS
	PR?ACROSS
	W?OVER
	PR?OVER
	W?AWAY
	PR?AWAY
	W?FROM
	PR?FROM
	W?ON
	PR?ON
	W?DOWN
	PR?DOWN
	W?IN
	PR?IN
	W?UP
	PR?UP
	W?OUT
	PR?OUT
	W?WITH
	PR?WITH
	W?TO
	PR?TO
	.ENDT


; VOCABULARY TABLE IS HERE

VOCAB::	.TABLE
	.BYTE 3
	.BYTE 46
	.BYTE 44
	.BYTE 34
	.BYTE 7
	600
W?$VERIFY::	.ZWORD "$verif"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?$VERIFY
	.BYTE 0
W?PERIOD::	.ZWORD "."
	.BYTE PS?BUZZ-WORD
	.BYTE B?PERIOD
	.BYTE 0
W?COMMA::	.ZWORD ","
	.BYTE PS?BUZZ-WORD
	.BYTE B?COMMA
	.BYTE 0
W?#COMMAND::	.ZWORD "#comma"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?#COMMAND
	.BYTE 0
W?#RANDOM::	.ZWORD "#rando"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?#RANDOM
	.BYTE 0
W?#RECORD::	.ZWORD "#recor"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?#RECORD
	.BYTE 0
W?#UNRECORD::	.ZWORD "#unrec"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?#UNRECORD
	.BYTE 0
W?QUOTE::	.ZWORD """"
	.BYTE PS?BUZZ-WORD
	.BYTE B?QUOTE
	.BYTE 0
W?A::	.ZWORD "a"
	.BYTE PS?BUZZ-WORD
	.BYTE B?A
	.BYTE 0
W?ABOUT::	.ZWORD "about"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?ABOUT
	.BYTE 0
W?ABYSS::	.ZWORD "abyss"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ACROSS::	.ZWORD "across"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?ACROSS
	.BYTE 0
W?ACTIVATE::	.ZWORD "activa"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ACTIVATE
	.BYTE 0
W?ADVENTURER::	.ZWORD "advent"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?AGAIN::	.ZWORD "again"
	.BYTE PS?BUZZ-WORD
	.BYTE B?AGAIN
	.BYTE 0
W?AIR::	.ZWORD "air"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ALGAE::	.ZWORD "algae"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ALL::	.ZWORD "all"
	.BYTE PS?BUZZ-WORD
	.BYTE B?ALL
	.BYTE 0
W?AMULET::	.ZWORD "amulet"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?AN::	.ZWORD "an"
	.BYTE PS?BUZZ-WORD
	.BYTE B?AN
	.BYTE 0
W?AND::	.ZWORD "and"
	.BYTE PS?BUZZ-WORD
	.BYTE B?AND
	.BYTE 0
W?ANSWER::	.ZWORD "answer"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ANSWER
	.BYTE 0
W?ANTIQUE::	.ZWORD "antiqu"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?ANTIQUE
	.BYTE 0
W?APPLY::	.ZWORD "apply"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?APPLY
	.BYTE 0
W?AQUEDUCT::	.ZWORD "aquedu"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ARCH::	.ZWORD "arch"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?AREA::	.ZWORD "area"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ARMED::	.ZWORD "armed"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?ARMED
	.BYTE 0
W?AROUND::	.ZWORD "around"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?AROUND
	.BYTE 0
W?ARROW::	.ZWORD "arrow"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ASK::	.ZWORD "ask"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TELL
	.BYTE 0
W?ASSORTED::	.ZWORD "assort"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?ASSORTED
	.BYTE 0
W?AT::	.ZWORD "at"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?AT
	.BYTE 0
W?ATTACH::	.ZWORD "attach"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TIE
	.BYTE 0
W?ATTACK::	.ZWORD "attack"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ATTACK
	.BYTE 0
W?AVIATOR::	.ZWORD "aviato"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?AWAKE::	.ZWORD "awake"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WAKE
	.BYTE 0
W?AWAY::	.ZWORD "away"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?AWAY
	.BYTE 0
W?BACK::	.ZWORD "back"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BACK
	.BYTE 0
W?BANISH::	.ZWORD "banish"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXORCISE
	.BYTE 0
W?BAR::	.ZWORD "bar"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BARE::	.ZWORD "bare"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?BARE
	.BYTE 0
W?BARF::	.ZWORD "barf"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CHOMP
	.BYTE 0
W?BATHE::	.ZWORD "bathe"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SWIM
	.BYTE 0
W?BEACH::	.ZWORD "beach"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BEAM::	.ZWORD "beam"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BEGONE::	.ZWORD "begone"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXORCISE
	.BYTE 0
W?BEHIND::	.ZWORD "behind"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?BEHIND
	.BYTE 0
W?BELOW::	.ZWORD "below"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?UNDER
	.BYTE 0
W?BENEATH::	.ZWORD "beneat"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?UNDER
	.BYTE 0
W?BITE::	.ZWORD "bite"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EAT
	.BYTE 0
W?BLACK::	.ZWORD "black"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?BLACK
	.BYTE 0
W?BLADE::	.ZWORD "blade"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BLAST::	.ZWORD "blast"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BLAST
	.BYTE 0
W?BLESSINGS::	.ZWORD "blessi"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BLOCK::	.ZWORD "block"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DESTROY
	.BYTE 0
W?BLOW::	.ZWORD "blow"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BLOW
	.BYTE 0
W?BOARD::	.ZWORD "board"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BOARD
	.BYTE 0
W?BOAT::	.ZWORD "boat"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BOOK::	.ZWORD "book"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BOTTOM::	.ZWORD "bottom"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BOULDER::	.ZWORD "boulde"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BRANDISH::	.ZWORD "brandi"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WAVE
	.BYTE 0
W?BRASS::	.ZWORD "brass"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?BRASS
	.BYTE 0
W?BREAD::	.ZWORD "bread"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BREAK::	.ZWORD "break"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DESTROY
	.BYTE 0
W?BREATH::	.ZWORD "breath"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BRIEF::	.ZWORD "brief"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BRIEF
	.BYTE 0
W?BROKEN::	.ZWORD "broken"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?BROKEN
	.BYTE 0
W?BRONZE::	.ZWORD "bronze"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?BRONZE
	.BYTE 0
W?BRUSH::	.ZWORD "brush"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BRUSH
	.BYTE 0
W?BUG::	.ZWORD "bug"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BUG
	.BYTE 0
W?BURN::	.ZWORD "burn"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BURN
	.BYTE 0
W?BURNED::	.ZWORD "burned"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?BURNED
	.BYTE 0
W?BUT::	.ZWORD "but"
	.BYTE PS?BUZZ-WORD
	.BYTE B?BUT
	.BYTE 0
W?BUTTON::	.ZWORD "button"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CAGE::	.ZWORD "cage"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CAN::	.ZWORD "can"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CARRY::	.ZWORD "carry"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TAKE
	.BYTE 0
W?CARVED::	.ZWORD "carved"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?CARVED
	.BYTE 0
W?CARVIN::	.ZWORD "carvin"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CAST::	.ZWORD "cast"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXORCISE
	.BYTE 0
W?CATCH::	.ZWORD "catch"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TAKE
	.BYTE 0
W?CELL::	.ZWORD "cell"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?CELL
	.BYTE 0
W?CENTER::	.ZWORD "center"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?CENTER
	.BYTE 0
W?CHAIR::	.ZWORD "chair"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CHANNEL::	.ZWORD "channe"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CHANT::	.ZWORD "chant"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?INCANT
	.BYTE 0
W?CHASE::	.ZWORD "chase"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FOLLOW
	.BYTE 0
W?CHASM::	.ZWORD "chasm"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CHEST::	.ZWORD "chest"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CHOMP::	.ZWORD "chomp"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CHOMP
	.BYTE 0
W?CHUCK::	.ZWORD "chuck"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?THROW
	.BYTE 0
W?CLEAN::	.ZWORD "clean"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BRUSH
	.BYTE 0
W?CLEFT::	.ZWORD "cleft"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CLIFF::	.ZWORD "cliff"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CLIMB::	.ZWORD "climb"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CLIMB
	.BYTE 0
W?CLOAK::	.ZWORD "cloak"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CLOAKED::	.ZWORD "cloake"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?CLOAKED
	.BYTE 0
W?CLOSE::	.ZWORD "close"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CLOSE
	.BYTE 0
W?COME::	.ZWORD "come"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FOLLOW
	.BYTE 0
W?COMMAND::	.ZWORD "comman"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?COMMAND
	.BYTE 0
W?COMPASS::	.ZWORD "compas"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?COMPASS
	.BYTE 0
W?CONSOLE::	.ZWORD "consol"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CONSUME::	.ZWORD "consum"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EAT
	.BYTE 0
W?CONTENTS::	.ZWORD "conten"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?COUNT::	.ZWORD "count"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?COUNT
	.BYTE 0
W?COVER::	.ZWORD "cover"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CPSLT::	.ZWORD "cpslt"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CRAFT::	.ZWORD "craft"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CRAWLWAY::	.ZWORD "crawlw"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CRETIN::	.ZWORD "cretin"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CROSS::	.ZWORD "cross"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CROSS
	.BYTE 0
W?CROWN::	.ZWORD "crown"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?CROWN
	.BYTE 0
W?CRYSTAL::	.ZWORD "crysta"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CURSE::	.ZWORD "curse"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CURSE
	.BYTE 0
W?CUT::	.ZWORD "cut"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CUT
	.BYTE 0
W?D::	.ZWORD "d"
	.BYTE PS?DIRECTION+PS?PREPOSITION+P1?OBJECT
	.BYTE PR?DOWN
	.BYTE 22
W?DAMAGE::	.ZWORD "damage"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DESTROY
	.BYTE 0
W?DAMN::	.ZWORD "damn"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CURSE
	.BYTE 0
W?DANGLING::	.ZWORD "dangli"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?DANGLING
	.BYTE 0
W?DARK::	.ZWORD "dark"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?DARK
	.BYTE 0
W?DEAD::	.ZWORD "dead"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?DEAD
	.BYTE 0
W?DEBRIS::	.ZWORD "debris"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?DEEP::	.ZWORD "deep"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?DEEP
	.BYTE 0
W?DEFLATE::	.ZWORD "deflat"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DEFLATE
	.BYTE 0
W?DESCRIBE::	.ZWORD "descri"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXAMINE
	.BYTE 0
W?DESTROY::	.ZWORD "destro"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DESTROY
	.BYTE 0
W?DEVICE::	.ZWORD "device"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?DIAGNOSE::	.ZWORD "diagno"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DIAGNOSE
	.BYTE 0
W?DIAL::	.ZWORD "dial"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?DIG::	.ZWORD "dig"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DIG
	.BYTE 0
W?DIRT::	.ZWORD "dirt"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?DISEMBARK::	.ZWORD "disemb"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DISEMBARK
	.BYTE 0
W?DISENCHANT::	.ZWORD "disenc"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DISENCHANT
	.BYTE 0
W?DISPATCH::	.ZWORD "dispat"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KILL
	.BYTE 0
W?DISPLAY::	.ZWORD "displa"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?DIVE::	.ZWORD "dive"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?JUMP
	.BYTE 0
W?DONATE::	.ZWORD "donate"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?GIVE
	.BYTE 0
W?DOOR::	.ZWORD "door"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?DOUSE::	.ZWORD "douse"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXTINGUISH
	.BYTE 0
W?DOWN::	.ZWORD "down"
	.BYTE PS?DIRECTION+PS?PREPOSITION+P1?OBJECT
	.BYTE PR?DOWN
	.BYTE 22
W?DRINK::	.ZWORD "drink"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DRINK
	.BYTE 0
W?DRIVE::	.ZWORD "drive"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXORCISE
	.BYTE 0
W?DROP::	.ZWORD "drop"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DROP
	.BYTE 0
W?DRYER::	.ZWORD "dryer"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?DUCT::	.ZWORD "duct"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?DUNGEON::	.ZWORD "dungeo"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?DUNGEON
	.BYTE O?ANY
W?DUST::	.ZWORD "dust"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?E::	.ZWORD "e"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?EAST
	.BYTE 30
W?EAST::	.ZWORD "east"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?EAST
	.BYTE 30
W?EASTERN::	.ZWORD "easter"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?EASTERN
	.BYTE 0
W?EAT::	.ZWORD "eat"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EAT
	.BYTE 0
W?ECHO::	.ZWORD "echo"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ECHO
	.BYTE 0
W?ELVISH::	.ZWORD "elvish"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?ELVISH
	.BYTE 0
W?ENCHANT::	.ZWORD "enchan"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ENCHANT
	.BYTE 0
W?ENGRAV::	.ZWORD "engrav"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ENTER::	.ZWORD "enter"
	.BYTE PS?VERB+PS?DIRECTION+P1?DIRECTION
	.BYTE 7
	.BYTE ACT?ENTER
W?EXAMINE::	.ZWORD "examin"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXAMINE
	.BYTE 0
W?EXCEPT::	.ZWORD "except"
	.BYTE PS?BUZZ-WORD
	.BYTE B?EXCEPT
	.BYTE 0
W?EXIT::	.ZWORD "exit"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXIT
	.BYTE 0
W?EXORCISE::	.ZWORD "exorci"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXORCISE
	.BYTE 0
W?EXTINGUISH::	.ZWORD "exting"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXTINGUISH
	.BYTE 0
W?FASTEN::	.ZWORD "fasten"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TIE
	.BYTE 0
W?FEED::	.ZWORD "feed"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?GIVE
	.BYTE 0
W?FEEL::	.ZWORD "feel"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RUB
	.BYTE 0
W?FIERY::	.ZWORD "fiery"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?FIERY
	.BYTE 0
W?FIGHT::	.ZWORD "fight"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ATTACK
	.BYTE 0
W?FIGURE::	.ZWORD "figure"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?FILL::	.ZWORD "fill"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FILL
	.BYTE 0
W?FIND::	.ZWORD "find"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FIND
	.BYTE 0
W?FISH::	.ZWORD "fish"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?FIX::	.ZWORD "fix"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PLUG
	.BYTE 0
W?FLAMING::	.ZWORD "flamin"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?FLAMING
	.BYTE 0
W?FLATHEAD::	.ZWORD "flathe"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?FLATHEAD
	.BYTE 0
W?FLIP::	.ZWORD "flip"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TURN
	.BYTE 0
W?FLOOR::	.ZWORD "floor"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?FLUID::	.ZWORD "fluid"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?FOLLOW::	.ZWORD "follow"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FOLLOW
	.BYTE 0
W?FOOBAR::	.ZWORD "foobar"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?FOOTPAD::	.ZWORD "footpa"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?FOR::	.ZWORD "for"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?FOR
	.BYTE 0
W?FORBIDDING::	.ZWORD "forbid"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?FORBIDDING
	.BYTE 0
W?FORD::	.ZWORD "ford"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CROSS
	.BYTE 0
W?FOREST::	.ZWORD "forest"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?FOREST
	.BYTE 0
W?FREE::	.ZWORD "free"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?UNTIE
	.BYTE 0
W?FRESH::	.ZWORD "fresh"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?FRESH
	.BYTE 0
W?FRIEND::	.ZWORD "friend"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?FROBOZZ::	.ZWORD "froboz"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FROBOZZ
	.BYTE 0
W?FROM::	.ZWORD "from"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?FROM
	.BYTE 0
W?FROTZ::	.ZWORD "frotz"
	.BYTE PS?BUZZ-WORD
	.BYTE B?FROTZ
	.BYTE 0
W?FUCK::	.ZWORD "fuck"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CURSE
	.BYTE 0
W?G::	.ZWORD "g"
	.BYTE PS?BUZZ-WORD
	.BYTE B?G
	.BYTE 0
W?GAZE::	.ZWORD "gaze"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LOOK
	.BYTE 0
W?GET::	.ZWORD "get"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TAKE
	.BYTE 0
W?GIFT::	.ZWORD "gift"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?GIVE::	.ZWORD "give"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?GIVE
	.BYTE 0
W?GLAMDRING::	.ZWORD "glamdr"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?GLUE::	.ZWORD "glue"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PLUG
	.BYTE 0
W?GO::	.ZWORD "go"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WALK
	.BYTE 0
W?GOLD::	.ZWORD "gold"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?GOLD
	.BYTE 0
W?GOLDEN::	.ZWORD "golden"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?GOLDEN
	.BYTE 0
W?GORGE::	.ZWORD "gorge"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?GRAB::	.ZWORD "grab"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TAKE
	.BYTE 0
W?GRACES::	.ZWORD "graces"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?GRAY::	.ZWORD "gray"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?GRAY
	.BYTE 0
W?GREASE::	.ZWORD "grease"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LUBRICATE
	.BYTE 0
W?GREAT::	.ZWORD "great"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?GREAT
	.BYTE 0
W?GREY::	.ZWORD "grey"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?GREY
	.BYTE 0
W?GRIP::	.ZWORD "grip"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?GROUND::	.ZWORD "ground"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?GRUE::	.ZWORD "grue"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?OBJECT
	.BYTE O?ANY
	.BYTE A?GRUE
W?GUARD::	.ZWORD "guard"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?GUARDIAN::	.ZWORD "guardi"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?GUARDS::	.ZWORD "guards"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?H2O::	.ZWORD "h2o"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HAND::	.ZWORD "hand"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?HAND
	.BYTE O?ANY
W?HANDGRIP::	.ZWORD "handgr"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HANDS::	.ZWORD "hands"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HATCH::	.ZWORD "hatch"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?HATCH
	.BYTE 0
W?HEAVY::	.ZWORD "heavy"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?HEAVY
	.BYTE 0
W?HELLO::	.ZWORD "hello"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?HELLO
	.BYTE 0
W?HER::	.ZWORD "her"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HERE::	.ZWORD "here"
	.BYTE PS?BUZZ-WORD
	.BYTE B?HERE
	.BYTE 0
W?HI::	.ZWORD "hi"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?HELLO
	.BYTE 0
W?HIDE::	.ZWORD "hide"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PUT
	.BYTE 0
W?HIM::	.ZWORD "him"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HIT::	.ZWORD "hit"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ATTACK
	.BYTE 0
W?HOLD::	.ZWORD "hold"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TAKE
	.BYTE 0
W?HOLE::	.ZWORD "hole"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HOLLOW::	.ZWORD "hollow"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?HOLLOW
	.BYTE 0
W?HOOD::	.ZWORD "hood"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HOODED::	.ZWORD "hooded"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?HOODED
	.BYTE 0
W?HOP::	.ZWORD "hop"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SKIP
	.BYTE 0
W?HUNGRY::	.ZWORD "hungry"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?HUNGRY
	.BYTE 0
W?HURL::	.ZWORD "hurl"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?THROW
	.BYTE 0
W?HURT::	.ZWORD "hurt"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ATTACK
	.BYTE 0
W?I::	.ZWORD "i"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?INVENTORY
	.BYTE 0
W?IGNITE::	.ZWORD "ignite"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BURN
	.BYTE 0
W?IMBIBE::	.ZWORD "imbibe"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DRINK
	.BYTE 0
W?IN::	.ZWORD "in"
	.BYTE PS?DIRECTION+PS?PREPOSITION+P1?OBJECT
	.BYTE PR?IN
	.BYTE 21
W?INCANT::	.ZWORD "incant"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?INCANT
	.BYTE 0
W?INCINERATE::	.ZWORD "incine"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BURN
	.BYTE 0
W?INDICATOR::	.ZWORD "indica"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?OBJECT
	.BYTE O?ANY
	.BYTE A?INDICATOR
W?INFLAT::	.ZWORD "inflat"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?INFLAT
	.BYTE 0
W?INJURE::	.ZWORD "injure"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ATTACK
	.BYTE 0
W?INSERT::	.ZWORD "insert"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PUT
	.BYTE 0
W?INSIDE::	.ZWORD "inside"
	.BYTE PS?DIRECTION+PS?PREPOSITION+P1?OBJECT
	.BYTE PR?IN
	.BYTE 21
W?INTDIR::	.ZWORD "intdir"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?INTNUM::	.ZWORD "intnum"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?INTO::	.ZWORD "into"
	.BYTE PS?DIRECTION+PS?PREPOSITION+P1?OBJECT
	.BYTE PR?IN
	.BYTE 21
W?INVENTORY::	.ZWORD "invent"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?INVENTORY
	.BYTE 0
W?INVISIBLE::	.ZWORD "invisi"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?INVISIBLE
	.BYTE 0
W?IRON::	.ZWORD "iron"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?IRON
	.BYTE 0
W?IS::	.ZWORD "is"
	.BYTE PS?BUZZ-WORD
	.BYTE B?IS
	.BYTE 0
W?IT::	.ZWORD "it"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?JEWELLED::	.ZWORD "jewell"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?JEWELLED
	.BYTE 0
W?JEWELS::	.ZWORD "jewels"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?JUMP::	.ZWORD "jump"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?JUMP
	.BYTE 0
W?KEY::	.ZWORD "key"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?KICK::	.ZWORD "kick"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KICK
	.BYTE 0
W?KILL::	.ZWORD "kill"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KILL
	.BYTE 0
W?KISS::	.ZWORD "kiss"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KISS
	.BYTE 0
W?KNIFE::	.ZWORD "knife"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?KNOCK::	.ZWORD "knock"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KNOCK
	.BYTE 0
W?L::	.ZWORD "l"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LOOK
	.BYTE 0
W?LADDER::	.ZWORD "ladder"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?LAKE::	.ZWORD "lake"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?LAMP::	.ZWORD "lamp"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?LANTERN::	.ZWORD "lanter"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?LARGE::	.ZWORD "large"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?LARGE
	.BYTE 0
W?LAUNCH::	.ZWORD "launch"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LAUNCH
	.BYTE 0
W?LEAN::	.ZWORD "lean"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LEAN
	.BYTE 0
W?LEAP::	.ZWORD "leap"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?JUMP
	.BYTE 0
W?LEAVE::	.ZWORD "leave"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LEAVE
	.BYTE 0
W?LEDGE::	.ZWORD "ledge"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?LICHEN::	.ZWORD "lichen"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?LIFT::	.ZWORD "lift"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RAISE
	.BYTE 0
W?LIGHT::	.ZWORD "light"
	.BYTE PS?OBJECT+PS?VERB+P1?OBJECT
	.BYTE O?ANY
	.BYTE ACT?LIGHT
W?LIQUID::	.ZWORD "liquid"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?LIQUIFY::	.ZWORD "liquif"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?MELT
	.BYTE 0
W?LISTEN::	.ZWORD "listen"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LISTEN
	.BYTE 0
W?LOCK::	.ZWORD "lock"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LOCK
	.BYTE 0
W?LOCKED::	.ZWORD "locked"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?LOCKED
	.BYTE 0
W?LONG::	.ZWORD "long"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?LONG
	.BYTE 0
W?LOOK::	.ZWORD "look"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LOOK
	.BYTE 0
W?LORE::	.ZWORD "lore"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?OBJECT
	.BYTE O?ANY
	.BYTE A?LORE
W?LOSE::	.ZWORD "lose"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CHOMP
	.BYTE 0
W?LOWER::	.ZWORD "lower"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LOWER
	.BYTE 0
W?LUBRICATE::	.ZWORD "lubric"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LUBRICATE
	.BYTE 0
W?LUNGS::	.ZWORD "lungs"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?LURKING::	.ZWORD "lurkin"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?LURKING
	.BYTE 0
W?MACHINE::	.ZWORD "machin"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MAGIC::	.ZWORD "magic"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?MAGIC
	.BYTE 0
W?MAHOGANY::	.ZWORD "mahoga"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?MAHOGANY
	.BYTE 0
W?MAKE::	.ZWORD "make"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?MAKE
	.BYTE 0
W?MAN::	.ZWORD "man"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MANHOLE::	.ZWORD "manhol"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?MANHOLE
	.BYTE 0
W?MARBLE::	.ZWORD "marble"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?MARBLE
	.BYTE 0
W?MASSIVE::	.ZWORD "massiv"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?MASSIVE
	.BYTE 0
W?MASTER::	.ZWORD "master"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ME::	.ZWORD "me"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MELT::	.ZWORD "melt"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?MELT
	.BYTE 0
W?METAL::	.ZWORD "metal"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?METAL
	.BYTE 0
W?MIRROR::	.ZWORD "mirror"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MIST::	.ZWORD "mist"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MOLEST::	.ZWORD "molest"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RAPE
	.BYTE 0
W?MOSS::	.ZWORD "moss"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MOTORS::	.ZWORD "motors"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MOUTH::	.ZWORD "mouth"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MOVE::	.ZWORD "move"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?MOVE
	.BYTE 0
W?MUMBLE::	.ZWORD "mumble"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?MUMBLE
	.BYTE 0
W?MURDER::	.ZWORD "murder"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KILL
	.BYTE 0
W?MYSELF::	.ZWORD "myself"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?N::	.ZWORD "n"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?NORTH
	.BYTE 31
W?NARROW::	.ZWORD "narrow"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?NARROW
	.BYTE 0
W?NE::	.ZWORD "ne"
	.BYTE PS?DIRECTION+P1?DIRECTION
	.BYTE 27
	.BYTE 0
W?NO::	.ZWORD "no"
	.BYTE PS?BUZZ-WORD
	.BYTE B?NO
	.BYTE 0
W?NORTH::	.ZWORD "north"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?NORTH
	.BYTE 31
W?NORTHE::	.ZWORD "northe"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?NORTHE
	.BYTE 27
W?NORTHWEST::	.ZWORD "northw"
	.BYTE PS?DIRECTION+P1?DIRECTION
	.BYTE 26
	.BYTE 0
W?NOTE::	.ZWORD "note"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?NW::	.ZWORD "nw"
	.BYTE PS?DIRECTION+P1?DIRECTION
	.BYTE 26
	.BYTE 0
W?OBJECT::	.ZWORD "object"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?OCEAN::	.ZWORD "ocean"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ODOR::	.ZWORD "odor"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ODYSSEUS::	.ZWORD "odysse"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ODYSSEUS
	.BYTE 0
W?OF::	.ZWORD "of"
	.BYTE PS?BUZZ-WORD
	.BYTE B?OF
	.BYTE 0
W?OFF::	.ZWORD "off"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?OFF
	.BYTE 0
W?OFFER::	.ZWORD "offer"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?GIVE
	.BYTE 0
W?OFFICI::	.ZWORD "offici"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?OIL::	.ZWORD "oil"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LUBRICATE
	.BYTE 0
W?OLD::	.ZWORD "old"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?OLD
	.BYTE 0
W?ON::	.ZWORD "on"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?ON
	.BYTE 0
W?ONE::	.ZWORD "one"
	.BYTE PS?BUZZ-WORD
	.BYTE B?ONE
	.BYTE 0
W?ONTO::	.ZWORD "onto"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?ON
	.BYTE 0
W?OOPS::	.ZWORD "oops"
	.BYTE PS?BUZZ-WORD
	.BYTE B?OOPS
	.BYTE 0
W?OPEN::	.ZWORD "open"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?OPEN
	.BYTE 0
W?ORCRIST::	.ZWORD "orcris"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?OUT::	.ZWORD "out"
	.BYTE PS?DIRECTION+PS?PREPOSITION+P1?OBJECT
	.BYTE PR?OUT
	.BYTE 20
W?OVER::	.ZWORD "over"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?OVER
	.BYTE 0
W?OZMOO::	.ZWORD "ozmoo"
	.BYTE PS?BUZZ-WORD
	.BYTE B?OZMOO
	.BYTE 0
W?PAIR::	.ZWORD "pair"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PANEL::	.ZWORD "panel"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PARAPET::	.ZWORD "parape"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PASSAGE::	.ZWORD "passag"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PAT::	.ZWORD "pat"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RUB
	.BYTE 0
W?PATCH::	.ZWORD "patch"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PLUG
	.BYTE 0
W?PATH::	.ZWORD "path"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PEAL::	.ZWORD "peal"
	.BYTE PS?OBJECT+PS?VERB+P1?OBJECT
	.BYTE O?ANY
	.BYTE ACT?RING
W?PEDESTAL::	.ZWORD "pedest"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PET::	.ZWORD "pet"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RUB
	.BYTE 0
W?PICK::	.ZWORD "pick"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PICK
	.BYTE 0
W?PIECE::	.ZWORD "piece"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PIERCE::	.ZWORD "pierce"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CUT
	.BYTE 0
W?PILE::	.ZWORD "pile"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PINE::	.ZWORD "pine"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?PINE
	.BYTE 0
W?PIPES::	.ZWORD "pipes"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PIT::	.ZWORD "pit"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PLACE::	.ZWORD "place"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PUT
	.BYTE 0
W?PLANT::	.ZWORD "plant"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PLANTS::	.ZWORD "plants"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PLAQUE::	.ZWORD "plaque"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PLAY::	.ZWORD "play"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PLAY
	.BYTE 0
W?PLUG::	.ZWORD "plug"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PLUG
	.BYTE 0
W?PLUGH::	.ZWORD "plugh"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PLUGH
	.BYTE 0
W?POINTED::	.ZWORD "pointe"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?POINTED
	.BYTE 0
W?POKE::	.ZWORD "poke"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?POKE
	.BYTE 0
W?POLE::	.ZWORD "pole"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?POST::	.ZWORD "post"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?POTION::	.ZWORD "potion"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?POUR::	.ZWORD "pour"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?POUR
	.BYTE 0
W?PRAY::	.ZWORD "pray"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PRAY
	.BYTE 0
W?PRESS::	.ZWORD "press"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PUSH
	.BYTE 0
W?PRESSURIZER::	.ZWORD "pressu"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PROCEED::	.ZWORD "procee"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WALK
	.BYTE 0
W?PULL::	.ZWORD "pull"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PULL
	.BYTE 0
W?PUMP::	.ZWORD "pump"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PUMP
	.BYTE 0
W?PUNCTURE::	.ZWORD "punctu"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PUNCTURE
	.BYTE 0
W?PURSUE::	.ZWORD "pursue"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FOLLOW
	.BYTE 0
W?PUSH::	.ZWORD "push"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PUSH
	.BYTE 0
W?PUT::	.ZWORD "put"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PUT
	.BYTE 0
W?Q::	.ZWORD "q"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?QUIT
	.BYTE 0
W?QUANTITY::	.ZWORD "quanti"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?QUICKS::	.ZWORD "quicks"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?QUIT::	.ZWORD "quit"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?QUIT
	.BYTE 0
W?RAISE::	.ZWORD "raise"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RAISE
	.BYTE 0
W?RAP::	.ZWORD "rap"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KNOCK
	.BYTE 0
W?RAPE::	.ZWORD "rape"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RAPE
	.BYTE 0
W?RAVINE::	.ZWORD "ravine"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?READ::	.ZWORD "read"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?READ
	.BYTE 0
W?RED::	.ZWORD "red"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?RED
	.BYTE 0
W?REEDS::	.ZWORD "reeds"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?RELEASE::	.ZWORD "releas"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?UNTIE
	.BYTE 0
W?REMOVE::	.ZWORD "remove"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TAKE
	.BYTE 0
W?RENDER::	.ZWORD "render"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?REPAIR::	.ZWORD "repair"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PLUG
	.BYTE 0
W?REPELLENT::	.ZWORD "repell"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?REPENT::	.ZWORD "repent"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?REPENT
	.BYTE 0
W?REPLY::	.ZWORD "reply"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ANSWER
	.BYTE 0
W?RESTART::	.ZWORD "restar"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RESTART
	.BYTE 0
W?RESTORE::	.ZWORD "restor"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RESTORE
	.BYTE 0
W?RICKETY::	.ZWORD "ricket"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?RICKETY
	.BYTE 0
W?RING::	.ZWORD "ring"
	.BYTE PS?OBJECT+PS?VERB+P1?OBJECT
	.BYTE O?ANY
	.BYTE ACT?RING
W?ROBOT::	.ZWORD "robot"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ROCK::	.ZWORD "rock"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ROCKS::	.ZWORD "rocks"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ROCKY::	.ZWORD "rocky"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?ROCKY
	.BYTE 0
W?ROLL::	.ZWORD "roll"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ROLL
	.BYTE 0
W?ROPE::	.ZWORD "rope"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ROSE::	.ZWORD "rose"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ROUND::	.ZWORD "round"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?ROUND
	.BYTE 0
W?ROYAL::	.ZWORD "royal"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?ROYAL
	.BYTE 0
W?RUB::	.ZWORD "rub"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RUB
	.BYTE 0
W?RUBBLE::	.ZWORD "rubble"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?RUN::	.ZWORD "run"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WALK
	.BYTE 0
W?RUNES::	.ZWORD "runes"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?RUSTY::	.ZWORD "rusty"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?RUSTY
	.BYTE 0
W?S::	.ZWORD "s"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?SOUTH
	.BYTE 28
W?SAILOR::	.ZWORD "sailor"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SAND::	.ZWORD "sand"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SAVE::	.ZWORD "save"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SAVE
	.BYTE 0
W?SAY::	.ZWORD "say"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SAY
	.BYTE 0
W?SCEPTRE::	.ZWORD "sceptr"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SCORE::	.ZWORD "score"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SCORE
	.BYTE 0
W?SCREAM::	.ZWORD "scream"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?YELL
	.BYTE 0
W?SCRIPT::	.ZWORD "script"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SCRIPT
	.BYTE 0
W?SE::	.ZWORD "se"
	.BYTE PS?DIRECTION+P1?DIRECTION
	.BYTE 25
	.BYTE 0
W?SEAL::	.ZWORD "seal"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SEARCH::	.ZWORD "search"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SEARCH
	.BYTE 0
W?SEAT::	.ZWORD "seat"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SECRET::	.ZWORD "secret"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SECRET
	.BYTE 0
W?SECURE::	.ZWORD "secure"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TIE
	.BYTE 0
W?SEE::	.ZWORD "see"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FIND
	.BYTE 0
W?SEEK::	.ZWORD "seek"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FIND
	.BYTE 0
W?SELF::	.ZWORD "self"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SEND::	.ZWORD "send"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SEND
	.BYTE 0
W?SET::	.ZWORD "set"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TURN
	.BYTE 0
W?SHADOW::	.ZWORD "shadow"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SHAKE::	.ZWORD "shake"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SHAKE
	.BYTE 0
W?SHARP::	.ZWORD "sharp"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SHARP
	.BYTE 0
W?SHINY::	.ZWORD "shiny"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SHINY
	.BYTE 0
W?SHIP::	.ZWORD "ship"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SHIT::	.ZWORD "shit"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CURSE
	.BYTE 0
W?SHORE::	.ZWORD "shore"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SHORT::	.ZWORD "short"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SHORT
	.BYTE 0
W?SHOUT::	.ZWORD "shout"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?YELL
	.BYTE 0
W?SHUT::	.ZWORD "shut"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TURN
	.BYTE 0
W?SICKLY::	.ZWORD "sickly"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SICKLY
	.BYTE 0
W?SIGH::	.ZWORD "sigh"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?MUMBLE
	.BYTE 0
W?SILENT::	.ZWORD "silent"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SILENT
	.BYTE 0
W?SINISTER::	.ZWORD "sinist"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SINISTER
	.BYTE 0
W?SIT::	.ZWORD "sit"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CLIMB
	.BYTE 0
W?SKIM::	.ZWORD "skim"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?READ
	.BYTE 0
W?SKIP::	.ZWORD "skip"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SKIP
	.BYTE 0
W?SLAY::	.ZWORD "slay"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KILL
	.BYTE 0
W?SLICE::	.ZWORD "slice"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CUT
	.BYTE 0
W?SLIDE::	.ZWORD "slide"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SLIDE
	.BYTE 0
W?SLIT::	.ZWORD "slit"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SLOT::	.ZWORD "slot"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SMALL::	.ZWORD "small"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SMALL
	.BYTE 0
W?SMASH::	.ZWORD "smash"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DESTROY
	.BYTE 0
W?SMELL::	.ZWORD "smell"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SMELL
	.BYTE 0
W?SMELLING::	.ZWORD "smelli"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SMELLING
	.BYTE 0
W?SMOKY::	.ZWORD "smoky"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SMOKY
	.BYTE 0
W?SNIFF::	.ZWORD "sniff"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SMELL
	.BYTE 0
W?SOUTH::	.ZWORD "south"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?SOUTH
	.BYTE 28
W?SOUTHE::	.ZWORD "southe"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?SOUTHE
	.BYTE 25
W?SOUTHWEST::	.ZWORD "southw"
	.BYTE PS?DIRECTION+P1?DIRECTION
	.BYTE 24
	.BYTE 0
W?SPILL::	.ZWORD "spill"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?POUR
	.BYTE 0
W?SPIN::	.ZWORD "spin"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SPIN
	.BYTE 0
W?SPRAY::	.ZWORD "spray"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SPRAY
	.BYTE 0
W?SQUEEZE::	.ZWORD "squeez"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SQUEEZE
	.BYTE 0
W?STAB::	.ZWORD "stab"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?STAB
	.BYTE 0
W?STAFF::	.ZWORD "staff"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STAIRCASE::	.ZWORD "stairc"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STAIRS::	.ZWORD "stairs"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STAIRWAY::	.ZWORD "stairw"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STALAG::	.ZWORD "stalag"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STAND::	.ZWORD "stand"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?STAND
	.BYTE 0
W?STARE::	.ZWORD "stare"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LOOK
	.BYTE 0
W?STARTLE::	.ZWORD "startl"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WAKE
	.BYTE 0
W?STATUE::	.ZWORD "statue"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STAY::	.ZWORD "stay"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?STAY
	.BYTE 0
W?STEEL::	.ZWORD "steel"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?STEEL
	.BYTE 0
W?STEEP::	.ZWORD "steep"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?STEEP
	.BYTE 0
W?STEP::	.ZWORD "step"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WALK
	.BYTE 0
W?STEPS::	.ZWORD "steps"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STONE::	.ZWORD "stone"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?STONE
	.BYTE O?ANY
W?STRANGE::	.ZWORD "strang"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?STRANGE
	.BYTE 0
W?STRIKE::	.ZWORD "strike"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?STRIKE
	.BYTE 0
W?STRUCTURE::	.ZWORD "struct"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STUFF::	.ZWORD "stuff"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PUT
	.BYTE 0
W?SUN::	.ZWORD "sun"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SUN
	.BYTE 0
W?SUNDIAL::	.ZWORD "sundia"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SUPER::	.ZWORD "super"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SUPER
	.BYTE 0
W?SUPERBRIEF::	.ZWORD "superb"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SUPER
	.BYTE 0
W?SURFACE::	.ZWORD "surfac"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SURPRISE::	.ZWORD "surpri"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WAKE
	.BYTE 0
W?SW::	.ZWORD "sw"
	.BYTE PS?DIRECTION+P1?DIRECTION
	.BYTE 24
	.BYTE 0
W?SWALLOW::	.ZWORD "swallo"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DRINK
	.BYTE 0
W?SWAMP::	.ZWORD "swamp"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SWEET::	.ZWORD "sweet"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SWEET
	.BYTE 0
W?SWIM::	.ZWORD "swim"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SWIM
	.BYTE 0
W?SWING::	.ZWORD "swing"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SWING
	.BYTE 0
W?SWORD::	.ZWORD "sword"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?T-BAR::	.ZWORD "t-bar"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?TABLE::	.ZWORD "table"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?TAKE::	.ZWORD "take"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TAKE
	.BYTE 0
W?TALK::	.ZWORD "talk"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TALK
	.BYTE 0
W?TALL::	.ZWORD "tall"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?TALL
	.BYTE 0
W?TASTE::	.ZWORD "taste"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EAT
	.BYTE 0
W?TAUNT::	.ZWORD "taunt"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KICK
	.BYTE 0
W?TELL::	.ZWORD "tell"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TELL
	.BYTE 0
W?TEMPLE::	.ZWORD "temple"
	.BYTE PS?OBJECT+PS?VERB+P1?OBJECT
	.BYTE O?ANY
	.BYTE ACT?TREASURE
W?TEMPORIZER::	.ZWORD "tempor"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?TEXT::	.ZWORD "text"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?THE::	.ZWORD "the"
	.BYTE PS?BUZZ-WORD
	.BYTE B?THE
	.BYTE 0
W?THEM::	.ZWORD "them"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?THEN::	.ZWORD "then"
	.BYTE PS?BUZZ-WORD
	.BYTE B?THEN
	.BYTE 0
W?THIN::	.ZWORD "thin"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?THIN
	.BYTE 0
W?THROUGH::	.ZWORD "throug"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?WITH
	.BYTE 0
W?THROW::	.ZWORD "throw"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?THROW
	.BYTE 0
W?THRU::	.ZWORD "thru"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?WITH
	.BYTE 0
W?THRUST::	.ZWORD "thrust"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SWING
	.BYTE 0
W?TIE::	.ZWORD "tie"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TIE
	.BYTE 0
W?TIMBERS::	.ZWORD "timber"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?TIME::	.ZWORD "time"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?TIME
	.BYTE 0
W?TO::	.ZWORD "to"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?TO
	.BYTE 0
W?TORCH::	.ZWORD "torch"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?TORCHE::	.ZWORD "torche"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?TOSS::	.ZWORD "toss"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?THROW
	.BYTE 0
W?TOUCH::	.ZWORD "touch"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RUB
	.BYTE 0
W?TRAIL::	.ZWORD "trail"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?TREASURE::	.ZWORD "treasu"
	.BYTE PS?OBJECT+PS?VERB+P1?OBJECT
	.BYTE O?ANY
	.BYTE ACT?TREASURE
W?TREE::	.ZWORD "tree"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?TREES::	.ZWORD "trees"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?TUG::	.ZWORD "tug"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PULL
	.BYTE 0
W?TURN::	.ZWORD "turn"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TURN
	.BYTE 0
W?U::	.ZWORD "u"
	.BYTE PS?DIRECTION+PS?PREPOSITION+P1?OBJECT
	.BYTE PR?UP
	.BYTE 23
W?ULYSSES::	.ZWORD "ulysse"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ODYSSEUS
	.BYTE 0
W?UNATTACH::	.ZWORD "unatta"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?UNTIE
	.BYTE 0
W?UNDER::	.ZWORD "under"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?UNDER
	.BYTE 0
W?UNDERNEATH::	.ZWORD "undern"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?UNDER
	.BYTE 0
W?UNFASTEN::	.ZWORD "unfast"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?UNTIE
	.BYTE 0
W?UNHOOK::	.ZWORD "unhook"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?UNTIE
	.BYTE 0
W?UNLOCK::	.ZWORD "unlock"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?UNLOCK
	.BYTE 0
W?UNSCRIPT::	.ZWORD "unscri"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?UNSCRIPT
	.BYTE 0
W?UNTIE::	.ZWORD "untie"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?UNTIE
	.BYTE 0
W?UP::	.ZWORD "up"
	.BYTE PS?DIRECTION+PS?PREPOSITION+P1?OBJECT
	.BYTE PR?UP
	.BYTE 23
W?USING::	.ZWORD "using"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?WITH
	.BYTE 0
W?VALUABLES::	.ZWORD "valuab"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?VERBOSE::	.ZWORD "verbos"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?VERBOSE
	.BYTE 0
W?VERSION::	.ZWORD "versio"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?VERSION
	.BYTE 0
W?VIAL::	.ZWORD "vial"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?VIEWING::	.ZWORD "viewin"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?VIEWING
	.BYTE 0
W?VIKING::	.ZWORD "viking"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?VIKING
	.BYTE 0
W?VOICE::	.ZWORD "voice"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?VOICES::	.ZWORD "voices"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?W::	.ZWORD "w"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?WEST
	.BYTE 29
W?WADE::	.ZWORD "wade"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SWIM
	.BYTE 0
W?WAIT::	.ZWORD "wait"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WAIT
	.BYTE 0
W?WAKE::	.ZWORD "wake"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WAKE
	.BYTE 0
W?WALK::	.ZWORD "walk"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WALK
	.BYTE 0
W?WALL::	.ZWORD "wall"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?WARNING::	.ZWORD "warnin"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?OBJECT
	.BYTE O?ANY
	.BYTE A?WARNING
W?WASHING::	.ZWORD "washin"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WASHING
	.BYTE 0
W?WATER::	.ZWORD "water"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?OBJECT
	.BYTE O?ANY
	.BYTE A?WATER
W?WATERF::	.ZWORD "waterf"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?WAVE::	.ZWORD "wave"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WAVE
	.BYTE 0
W?WAY::	.ZWORD "way"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WAY
	.BYTE 0
W?WAYBREAD::	.ZWORD "waybre"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?WEAR::	.ZWORD "wear"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WEAR
	.BYTE 0
W?WEST::	.ZWORD "west"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?WEST
	.BYTE 29
W?WESTERN::	.ZWORD "wester"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WESTERN
	.BYTE 0
W?WHAT::	.ZWORD "what"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXAMINE
	.BYTE 0
W?WHATS::	.ZWORD "whats"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXAMINE
	.BYTE 0
W?WHERE::	.ZWORD "where"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FIND
	.BYTE 0
W?WHITE::	.ZWORD "white"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WHITE
	.BYTE 0
W?WIDE::	.ZWORD "wide"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WIDE
	.BYTE 0
W?WIN::	.ZWORD "win"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WIN
	.BYTE 0
W?WIND::	.ZWORD "wind"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WIND
	.BYTE 0
W?WINDING::	.ZWORD "windin"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WINDING
	.BYTE 0
W?WINNAGE::	.ZWORD "winnag"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WIN
	.BYTE 0
W?WIRES::	.ZWORD "wires"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?WISH::	.ZWORD "wish"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WISH
	.BYTE 0
W?WITH::	.ZWORD "with"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?WITH
	.BYTE 0
W?WOMAN::	.ZWORD "woman"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?WOOD::	.ZWORD "wood"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WOOD
	.BYTE 0
W?WOODEN::	.ZWORD "wooden"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WOODEN
	.BYTE 0
W?XYZZY::	.ZWORD "xyzzy"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PLUGH
	.BYTE 0
W?Y::	.ZWORD "y"
	.BYTE PS?BUZZ-WORD
	.BYTE B?Y
	.BYTE 0
W?YANK::	.ZWORD "yank"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PULL
	.BYTE 0
W?YELL::	.ZWORD "yell"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?YELL
	.BYTE 0
W?YELLOW::	.ZWORD "yellow"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?YELLOW
	.BYTE 0
W?YES::	.ZWORD "yes"
	.BYTE PS?BUZZ-WORD
	.BYTE B?YES
	.BYTE 0
W?Z::	.ZWORD "z"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WAIT
	.BYTE 0
W?ZORK::	.ZWORD "zork"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ZORK
	.BYTE 0
W?ZORKMID::	.ZWORD "zorkmi"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ZZMGCK::	.ZWORD "zzmgck"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
	.ENDT


; END LOAD

ENDLOD::



; PURE TABLES ARE DEFINED HERE

PURTBL::

	.ENDI
