

; TOP LEVEL DEFINITIONS

	TRUE-VALUE=1
	FALSE-VALUE=0

	O?ANY=1

	PS?OBJECT=128
	PS?VERB=64
	PS?ADJECTIVE=32
	PS?DIRECTION=16
	PS?PREPOSITION=8
	PS?BUZZ-WORD=4

	P1?NONE=0
	P1?OBJECT=0
	P1?VERB=1
	P1?ADJECTIVE=2
	P1?DIRECTION=3


; OBJECT FLAGS ARE DEFINED HERE


	SACREDBIT=0
	FX?SACREDBIT=32768

	FIGHTBIT=1
	FX?FIGHTBIT=16384

	TOUCHBIT=2
	FX?TOUCHBIT=8192

	WEARBIT=3
	FX?WEARBIT=4096

	SEARCHBIT=4
	FX?SEARCHBIT=2048

	NWALLBIT=5
	FX?NWALLBIT=1024

	NONLANDBIT=6
	FX?NONLANDBIT=512

	TRANSBIT=7
	FX?TRANSBIT=256

	SURFACEBIT=8
	FX?SURFACEBIT=128

	INVISIBLE=9
	FX?INVISIBLE=64

	STAGGERED=10
	FX?STAGGERED=32

	OPENBIT=11
	FX?OPENBIT=16

	RLANDBIT=12
	FX?RLANDBIT=8

	TRYTAKEBIT=13
	FX?TRYTAKEBIT=4

	NDESCBIT=14
	FX?NDESCBIT=2

	TURNBIT=15
	FX?TURNBIT=1

	READBIT=16
	FX?READBIT=32768

	TAKEBIT=17
	FX?TAKEBIT=16384

	CONTBIT=18
	FX?CONTBIT=8192

	ONBIT=19
	FX?ONBIT=4096

	FOODBIT=20
	FX?FOODBIT=2048

	DRINKBIT=21
	FX?DRINKBIT=1024

	DOORBIT=22
	FX?DOORBIT=512

	CLIMBBIT=23
	FX?CLIMBBIT=256

	RMUNGBIT=24
	FX?RMUNGBIT=128

	FLAMEBIT=25
	FX?FLAMEBIT=64

	BURNBIT=26
	FX?BURNBIT=32

	VEHBIT=27
	FX?VEHBIT=16

	TOOLBIT=28
	FX?TOOLBIT=8

	WEAPONBIT=29
	FX?WEAPONBIT=4

	ACTORBIT=30
	FX?ACTORBIT=2

	LIGHTBIT=31
	FX?LIGHTBIT=1

; ACTION IDENTIFIERS ARE ASSIGNED HERE

	V?VERBOSE=0
	V?BRIEF=1
	V?SUPER-BRIEF=2
	V?DIAGNOSE=3
	V?INVENTORY=4
	V?QUIT=5
	V?RESTART=6
	V?RESTORE=7
	V?SAVE=8
	V?SCORE=9
	V?SCRIPT=10
	V?UNSCRIPT=11
	V?VERSION=12
	V?VERIFY=13
	V?RANDOM=14
	V?COMMAND-FILE=15
	V?RECORD=16
	V?UNRECORD=17
	V?LAMP-ON=18
	V?ANSWER=19
	V?REPLY=20
	V?PUT=21
	V?ATTACK=22
	V?BACK=23
	V?BLAST=24
	V?LAMP-OFF=25
	V?INFLATE=26
	V?BREATHE=27
	V?BOARD=28
	V?BRUSH=29
	V?BUG=30
	V?BURN=31
	V?CHOMP=32
	V?CLIMB-UP=33
	V?CLIMB-DOWN=34
	V?CLIMB-FOO=35
	V?CLIMB-ON=36
	V?THROUGH=37
	V?CLOSE=38
	V?COMMAND=39
	V?COUNT=40
	V?CROSS=41
	V?CUT=42
	V?CURSES=43
	V?DEFLATE=44
	V?MUNG=45
	V?OPEN=46
	V?DIG=47
	V?DISEMBARK=48
	V?DISENCHANT=49
	V?DRINK=50
	V?DRINK-FROM=51
	V?DROP=52
	V?PUT-ON=53
	V?EAT=54
	V?ECHO=55
	V?ENCHANT=56
	V?ENTER=57
	V?EXIT=58
	V?EXAMINE=59
	V?LOOK-INSIDE=60
	V?EXORCISE=61
	V?FILL=62
	V?FIND=63
	V?FOLLOW=64
	V?FROBOZZ=65
	V?GIVE=66
	V?SGIVE=67
	V?HATCH=68
	V?HELLO=69
	V?INCANT=70
	V?LEAP=71
	V?KICK=72
	V?STAB=73
	V?KISS=74
	V?KNOCK=75
	V?LAUNCH=76
	V?LEAN-ON=77
	V?LEAVE=78
	V?LISTEN=79
	V?LOCK=80
	V?LOOK=81
	V?LOOK-ON=82
	V?LOOK-UNDER=83
	V?LOOK-BEHIND=84
	V?READ=85
	V?LOWER=86
	V?OIL=87
	V?MAKE=88
	V?MELT=89
	V?MOVE=90
	V?PUSH-TO=91
	V?TURN=92
	V?MUMBLE=93
	V?ODYSSEUS=94
	V?PICK=95
	V?TAKE=96
	V?PLAY=97
	V?PLUG=98
	V?ADVENT=99
	V?POUR-ON=100
	V?PRAY=101
	V?PUMP=102
	V?PUSH=103
	V?PUT-UNDER=104
	V?WEAR=105
	V?PUT-BEHIND=106
	V?RAISE=107
	V?RAPE=108
	V?READ-PAGE=109
	V?REPENT=110
	V?RING=111
	V?RUB=112
	V?TELL=113
	V?SAY=114
	V?SEARCH=115
	V?SEND=116
	V?SHAKE=117
	V?SKIP=118
	V?SMELL=119
	V?SPIN=120
	V?SPRAY=121
	V?SSPRAY=122
	V?SQUEEZE=123
	V?STAND=124
	V?STAY=125
	V?STRIKE=126
	V?SWIM=127
	V?SWING=128
	V?THROW=129
	V?OVERBOARD=130
	V?THROW-OFF=131
	V?TIE=132
	V?TIE-UP=133
	V?TREASURE=134
	V?UNLOCK=135
	V?UNTIE=136
	V?WAIT=137
	V?ALARM=138
	V?WALK-AROUND=139
	V?WALK=140
	V?WALK-TO=141
	V?WAVE=142
	V?WIN=143
	V?WIND=144
	V?WISH=145
	V?YELL=146
	V?ZORK=147

; PROPERTIES ARE DEFINED HERE

	P?NORTH=31
	P?EAST=30
	P?WEST=29
	P?SOUTH=28
	P?NE=27
	P?NW=26
	P?SE=25
	P?SW=24
	P?UP=23
	P?DOWN=22
	P?IN=21
	P?OUT=20
	P?LAND=19
	P?CROSS=18
	P?SYNONYM=17
	P?ADJECTIVE=16
	P?ACTION=15
	P?SIZE=14
	P?LDESC=13
	P?GLOBAL=12
	P?PSEUDO=11
	P?FDESC=10
	P?CAPACITY=9
	P?VALUE=8
	P?TEXT=7
	P?DESCFCN=6
	P?VTYPE=5
	P?CONTFCN=4
	P?ADVFCN=3
	P?STRENGTH=2

; ADJECTIVES ARE DEFINED HERE

	A?FLOWING=255
	A?SMALL=254
	A?DEEP=253
	A?GLOWING=252
	A?PHOSPHORESCENT=251
	A?ROSE=250
	A?STONE=249
	A?WOODEN=248
	A?RICKETY=247
	A?DARK=246
	A?SMOKY=245
	A?EAST=244
	A?EASTERN=243
	A?SOUTH=242
	A?SOUTHE=241
	A?WEST=240
	A?WESTERN=239
	A?NORTH=238
	A?NORTHE=237
	A?MAGIC=236
	A?BEAUTIFUL=235
	A?WHITE=234
	A?OLD=233
	A?ROTTEN=232
	A?GOLD=231
	A?RED=230
	A?HUGE=229
	A?DEAD=228
	A?YOUNG=227
	A?COBWEBBED=226
	A?OAK=225
	A?HEAVY=224
	A?ENORMOUS=223
	A?GIANT=222
	A?DOG=221
	A?BASEBALL=220
	A?DIAMOND=219
	A?THREE=218
	A?HEADED=217
	A?MARBLE=216
	A?CRYPT=215
	A?F=214
	A?DIMLY=213
	A?SECRET=212
	A?NASTY=211
	A?WAX=210
	A?WORK=209
	A?WIZARD=208
	A?CRYSTAL=207
	A?RUBY=206
	A?SAPPHIRE=205
	A?OBSIDIAN=204
	A?BLACK=203
	A?STRANGE=202
	A?WORN=201
	A?USED=200
	A?DULL=199
	A?NICKED=198
	A?WARNING=197
	A?TROPHY=196
	A?BROKEN=195
	A?GREAT=194
	A?CHALK=193
	A?CLEAR=192
	A?BABY=191
	A?SEA=190
	A?ZORK=189
	A?VOLCANO=188
	A?WICKER=187
	A?BLUE=186
	A?STEEL=185
	A?RUSTY=184
	A?BRAIDED=183
	A?SQUARE=182
	A?CLAY=181
	A?ROUND=180
	A?TRIANGULAR=179
	A?CLOTH=178
	A?GAUDY=177
	A?FANCY=176
	A?COLD=175
	A?ICY=174
	A?GLASS=173
	A?GREEN=172
	A?BRASS=171
	A?LARGE=170
	A?OBLONG=169
	A?MANGLED=168
	A?PEARL=167
	A?FROSTED=166
	A?ORANGE=165
	A?PRICELESS=164
	A?FLATHEAD=163
	A?HANDSOME=162
	A?LEATHER=161
	A?GLOSSY=160
	A?PURPLE=159
	A?METAL=158
	A?MOBY=157
	A?DENTED=156
	A?SOLID=155
	A?CANDIED=154
	A?RARE=153
	A?THIN=152
	A?NEAT=151
	A?MANY=150
	A?ZORKMID=149
	A?BANK=148
	A?SHIMMERING=147
	A?ZURICH=146
	A?DEPOSIT=145
	A?SAFETY=144
	A?BARRED=143
	A?DUSTY=142
	A?NARROW=141
	A?LETTER=140
	A?IRON=139
	A?TEA=138
	A?NEWS=137
	A?NEWSPAPER=136
	A?PLACE=135
	A?CHINA=134
	A?DELICATE=133
	A?VELVET=132
	A?SATIN=131
	A?PERFECT=130
	A?LITTLE=129
	A?FROBOZZ=128
	A?ELVISH=127
	A?ANTIQUE=126
	A?GRUE=125
	A?FORBIDDING=124
	A?STEEP=123
	A?LURKING=122
	A?SINISTER=121
	A?HUNGRY=120
	A?SILENT=119
	A?FOREST=118
	A?LONG=117
	A?WINDING=116
	A?BARE=115

; BUZZ WORDS ARE DEFINED HERE

	B?AGAIN=255
	B?G=254
	B?OOPS=253
	B?A=252
	B?AN=251
	B?THE=250
	B?IS=249
	B?AND=248
	B?OF=247
	B?THEN=246
	B?ALL=245
	B?ONE=244
	B?BUT=243
	B?EXCEPT=242
	B?PERIOD=241
	B?COMMA=240
	B?QUOTE=239
	B?YES=238
	B?NO=237
	B?Y=236
	B?HERE=235
	B?FEEBLE=234
	B?FUMBLE=233
	B?FEAR=232
	B?FILCH=231
	B?FREEZE=230
	B?FALL=229
	B?FRY=228
	B?FLUORESCE=227
	B?FERMENT=226
	B?FIERCE=225
	B?FLOAT=224
	B?FIREPROOF=223
	B?FENCE=222
	B?FUDGE=221
	B?FANTASIZE=220
	B?FROTZ=219
	B?OZMOO=218

; PREPOSITIONS ARE DEFINED HERE

	PR?TO=255
	PR?WITH=254
	PR?OUT=253
	PR?UP=252
	PR?IN=251
	PR?DOWN=250
	PR?ON=249
	PR?FROM=248
	PR?AWAY=247
	PR?OVER=246
	PR?ACROSS=245
	PR?OFF=244
	PR?AT=243
	PR?FOR=242
	PR?AROUND=241
	PR?UNDER=240
	PR?BEHIND=239
	PR?ABOUT=238

; DIRECTIONS ARE DEFINED HERE


; ACTIONS ARE DEFINED HERE

	ACT?KISS=255
	ACT?SKIP=254
	ACT?INFLAT=253
	ACT?STAY=252
	ACT?PULL=251
	ACT?PUT=250
	ACT?RAPE=249
	ACT?VERBOSE=248
	ACT?WALK=247
	ACT?QUIT=246
	ACT?FIND=245
	ACT?DESTROY=244
	ACT?UNLOCK=243
	ACT?READ=242
	ACT?SAY=241
	ACT?PUNCTURE=240
	ACT?JUMP=239
	ACT?POUR=238
	ACT?WAIT=237
	ACT?TAKE=236
	ACT?COUNT=235
	ACT?RAISE=234
	ACT?FOLLOW=233
	ACT?VERSION=232
	ACT?WIND=231
	ACT?#UNRECORD=230
	ACT?LIGHT=229
	ACT?MOVE=228
	ACT?CHOMP=227
	ACT?PLAY=226
	ACT?OPEN=225
	ACT?#COMMAND=224
	ACT?BLOW=223
	ACT?KNOCK=222
	ACT?PICK=221
	ACT?DEFLATE=220
	ACT?BOARD=219
	ACT?#RANDOM=218
	ACT?APPLY=217
	ACT?PRAY=216
	ACT?STAND=215
	ACT?ENCHANT=214
	ACT?LISTEN=213
	ACT?TIE=212
	ACT?SAVE=211
	ACT?TELL=210
	ACT?THROW=209
	ACT?ZORK=208
	ACT?LOWER=207
	ACT?COMMAND=206
	ACT?TALK=205
	ACT?SHAKE=204
	ACT?INVENTORY=203
	ACT?ATTACK=202
	ACT?KILL=201
	ACT?ENTER=200
	ACT?SEARCH=199
	ACT?WEAR=198
	ACT?FROBOZZ=197
	ACT?DISEMBARK=196
	ACT?SWIM=195
	ACT?LUBRICATE=194
	ACT?PLUG=193
	ACT?UNTIE=192
	ACT?PUMP=191
	ACT?CUT=190
	ACT?UNSCRIPT=189
	ACT?MELT=188
	ACT?BRUSH=187
	ACT?RING=186
	ACT?PUSH=185
	ACT?RUB=184
	ACT?SUPER=183
	ACT?BLAST=182
	ACT?DIG=181
	ACT?WISH=180
	ACT?INCANT=179
	ACT?SEND=178
	ACT?SCORE=177
	ACT?EXORCISE=176
	ACT?HATCH=175
	ACT?WIN=174
	ACT?LOOK=173
	ACT?ODYSSEUS=172
	ACT?SPRAY=171
	ACT?DROP=170
	ACT?BACK=169
	ACT?ROLL=168
	ACT?LEAVE=167
	ACT?CURSE=166
	ACT?SCRIPT=165
	ACT?REPENT=164
	ACT?SPIN=163
	ACT?$VERIFY=162
	ACT?EXTINGUISH=161
	ACT?SWING=160
	ACT?RESTART=159
	ACT?POKE=158
	ACT?SMELL=157
	ACT?BRIEF=156
	ACT?ECHO=155
	ACT?DIAGNOSE=154
	ACT?GIVE=153
	ACT?WAKE=152
	ACT?DRINK=151
	ACT?ANSWER=150
	ACT?MUMBLE=149
	ACT?YELL=148
	ACT?LOCK=147
	ACT?ACTIVATE=146
	ACT?BURN=145
	ACT?KICK=144
	ACT?PLUGH=143
	ACT?TURN=142
	ACT?#RECORD=141
	ACT?CROSS=140
	ACT?STAB=139
	ACT?MAKE=138
	ACT?RESTORE=137
	ACT?CLOSE=136
	ACT?STRIKE=135
	ACT?SLIDE=134
	ACT?WAVE=133
	ACT?EXIT=132
	ACT?EXAMINE=131
	ACT?DISENCHANT=130
	ACT?EAT=129
	ACT?FILL=128
	ACT?LEAN=127
	ACT?SQUEEZE=126
	ACT?BUG=125
	ACT?CLIMB=124
	ACT?LAUNCH=123
	ACT?TREASURE=122
	ACT?HELLO=121

; USER DEFINED CONSTANTS ARE INITIALIZED HERE

	SOG=16
	SIR=32
	DEXITSTR=1
	XEQUAL?=4
	S-FANTASIZE=12
	P-ITBLLEN=9
	P-SYNLEN=8
	P-SRCTOP=0
	C-INTLEN=6
	S-FERMENT=7
	O-START=1
	DEXITOBJ=1
	P-P1OFF=5
	O-PTR=0
	S-FEEBLE=1
	O-LENGTH=2
	C-TABLELEN=180
	P-NC2=8
	P-NC1=6
	S-FLOAT=9
	P-WORDLEN=4
	SERIAL=0
	P-VERBN=1
	P-P1BITS=3
	FEXIT=3
	S-FENCE=11
	CC-SEPTR=1
	S-FIERCE=8
	ZORKID=1
	P-SPREP1=1
	CC-SBPTR=0
	P-PREP1=2
	M-BEG=1
	XDIV=3
	M-FATAL=2
	XGRTR?=5
	NEXITSTR=0
	SPELLS=12
	P-SLOC2=6
	NEXIT=2
	SC=64
	P-PREP1N=3
	P-PSOFF=4
	S-FILCH=4
	XLESS?=6
	P-VERB=0
	M-HANDLED=1
	M-ENTER=2
	CC-DEPTR=3
	SHAVE=2
	DEXIT=5
	P-SRCBOT=2
	M-OBJDESC=5
	CC-DBPTR=2
	SMANY=4
	STAKE=8
	P-SPREP2=2
	XSUB=1
	XADD=0
	S-FALL=6
	CEXIT=4
	P-LEXSTART=1
	TREASURES-MAX=10
	M-LOOK=3
	UEXIT=1
	S-FIREPROOF=10
	O-END=3
	P-LEXELEN=2
	P-LEXWORDS=1
	S-FEAR=3
	P-ALL=1
	XMUL=2
	P-SFWIM1=3
	P-INHIBIT=4
	CEXITFLAG=1
	M-FLASH=4
	M-OBJECT=0
	FEXITFCN=0
	P-SBITS=0
	M-NOT-HANDLED=0
	P-SRCALL=1
	CEXITSTR=1
	S-FUMBLE=2
	P-SLOC1=5
	M-END=6
	LOW-DIRECTION=18
	P-PREP2=4
	P-SONUMS=3
	C-TICK=1
	P-NC2L=9
	P-NC1L=7
	S-FREEZE=5
	P-ONE=2
	P-SACTION=7
	P-PREP2N=5
	P-SFWIM2=4
	C-ENABLED?=0
	REXIT=0
	SH=128
	C-RTN=2

; PROPERTY DEFAULTS AND OBJECTS ARE DEFINED HERE

OBJECT::.TABLE 
	0			;()
	0			;(P?STRENGTH)
	0			;(P?ADVFCN)
	0			;(P?CONTFCN)
	0			;(P?VTYPE)
	0			;(P?DESCFCN)
	0			;(P?TEXT)
	0			;(P?VALUE)
	0			;(P?CAPACITY)
	0			;(P?FDESC)
	0			;(P?PSEUDO)
	0			;(P?GLOBAL)
	0			;(P?LDESC)
	5			;(P?SIZE)
	0			;(P?ACTION)
	0			;(P?ADJECTIVE)
	0			;(P?SYNONYM)
	0			;(P?CROSS)
	0			;(P?LAND)
	0			;(P?OUT)
	0			;(P?IN)
	0			;(P?DOWN)
	0			;(P?UP)
	0			;(P?SW)
	0			;(P?SE)
	0			;(P?NW)
	0			;(P?NE)
	0			;(P?SOUTH)
	0			;(P?WEST)
	0			;(P?EAST)
	0			;(P?NORTH)
	.OBJECT ROUND-BUTTON,FX?NDESCBIT,0,MACHINE-ROOM,0,0,T?ROUND-BUTTON
	.OBJECT VAULT,FX?RLANDBIT,0,ROOMS,SMALL-ROOM,BILLS,T?VAULT
	.OBJECT STATUETTE,FX?STAGGERED,FX?TAKEBIT,CHEST,0,0,T?STATUETTE
	.OBJECT TRIANGULAR-BUTTON,FX?NDESCBIT,0,MACHINE-ROOM,SQUARE-BUTTON,0,T?TRIANGULAR-BUTTON
	.OBJECT GLOBAL-WATER,0,FX?DRINKBIT,LOCAL-GLOBALS,BRIDGE,0,T?GLOBAL-WATER
	.OBJECT WELL,FX?NDESCBIT,0,LOCAL-GLOBALS,GLOBAL-WATER,0,T?WELL
	.OBJECT RIDDLE-DOOR,FX?NDESCBIT,FX?CONTBIT+FX?DOORBIT,RIDDLE-ROOM,0,0,T?RIDDLE-DOOR
	.OBJECT WELL-TOP,FX?NONLANDBIT+FX?RLANDBIT,0,ROOMS,IN-CAGE,TOP-ETCHINGS,T?WELL-TOP
	.OBJECT BOTTOM-ETCHINGS,FX?NDESCBIT,FX?READBIT,WELL-BOTTOM,0,0,T?BOTTOM-ETCHINGS
	.OBJECT TROPHY-SWORD,FX?TRYTAKEBIT+FX?NDESCBIT,0,TROPHY-ROOM,WANDS,0,T?TROPHY-SWORD
	.OBJECT CAGE,FX?INVISIBLE,0,CAGE-ROOM,PALANTIR-1,0,T?CAGE
	.OBJECT HANDS,FX?NDESCBIT,FX?TOOLBIT,GLOBAL-OBJECTS,ZORKMID,0,T?HANDS
	.OBJECT LEDGE-1,FX?NONLANDBIT+FX?RLANDBIT,0,ROOMS,VAIR-4,COIN,T?LEDGE-1
	.OBJECT KEY,FX?TURNBIT+FX?NDESCBIT,FX?TOOLBIT+FX?TAKEBIT,KEYHOLE-2,0,0,T?KEY
	.OBJECT LAVA-ROOM,FX?RLANDBIT,0,ROOMS,SAFE-ROOM,RUBY,T?LAVA-ROOM
	.OBJECT GAZEBO-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,GARDEN-NORTH,GAZEBO-TABLE,T?GAZEBO-ROOM
	.OBJECT DEAD-SERPENT,0,FX?TAKEBIT,0,0,0,T?DEAD-SERPENT
	.OBJECT WIZARD,FX?OPENBIT,FX?CONTBIT+FX?ACTORBIT,0,0,WAND,T?WIZARD
	.OBJECT DIAMOND-5,FX?RLANDBIT,0,ROOMS,DIAMOND-4,0,T?DIAMOND-5
	.OBJECT CURTAIN,FX?NDESCBIT,0,DEPOSITORY,CUBE,0,T?CURTAIN
	.OBJECT FOOT-BRIDGE,FX?RLANDBIT,FX?ONBIT,ROOMS,NARROW-TUNNEL,0,T?FOOT-BRIDGE
	.OBJECT IRON-BOX,FX?INVISIBLE,FX?TAKEBIT+FX?CONTBIT,CAROUSEL-ROOM,0,VIOLIN,T?IRON-BOX
	.OBJECT MATCH,0,FX?TAKEBIT+FX?READBIT,GAZEBO-TABLE,0,0,T?MATCH
	.OBJECT WAND,FX?TRYTAKEBIT+FX?NDESCBIT+FX?STAGGERED,FX?TAKEBIT,WIZARD,0,0,T?WAND
	.OBJECT ME,0,FX?ACTORBIT,GLOBAL-OBJECTS,LUNGS,0,T?ME
	.OBJECT UNICORN,FX?OPENBIT+FX?TRYTAKEBIT,FX?CONTBIT+FX?ACTORBIT,0,0,RIBBON,T?UNICORN
	.OBJECT SQUARE-BUTTON,FX?NDESCBIT,0,MACHINE-ROOM,ROUND-BUTTON,0,T?SQUARE-BUTTON
	.OBJECT GUARDIAN-ROOM,FX?RLANDBIT,0,ROOMS,ZORK3,DOOR-KEEPER,T?GUARDIAN-ROOM
	.OBJECT PALANTIR-1,FX?TRYTAKEBIT+FX?TRANSBIT+FX?STAGGERED,FX?TAKEBIT,CAGE-ROOM,0,0,T?PALANTIR-1
	.OBJECT MARBLE-HALL,FX?RLANDBIT,0,ROOMS,STREAM-PATH,BRICK,T?MARBLE-HALL
	.OBJECT PALANTIR-3,FX?TRANSBIT+FX?NDESCBIT+FX?STAGGERED,FX?TAKEBIT,IN-AQUARIUM,0,0,T?PALANTIR-3
	.OBJECT SERPENT,0,FX?ACTORBIT,AQUARIUM,0,0,T?SERPENT
	.OBJECT PALANTIR-2,FX?TRANSBIT+FX?STAGGERED,FX?TAKEBIT,DREARY-ROOM,KEYHOLE-2,0,T?PALANTIR-2
	.OBJECT VAIR-1,FX?NWALLBIT+FX?NONLANDBIT,0,ROOMS,VOLCANO-BOTTOM,0,T?VAIR-1
	.OBJECT ORANGE-ICING,0,FX?FOODBIT+FX?TAKEBIT+FX?READBIT,ALICE-TABLE,BLUE-ICING,0,T?ORANGE-ICING
	.OBJECT PALANTIR-4,FX?TRANSBIT+FX?STAGGERED,FX?TAKEBIT,STAND-4,0,0,T?PALANTIR-4
	.OBJECT ROOMS,0,0,0,0,DEAD-PALANTIR-4,T?ROOMS
	.OBJECT PEARL-ROOM,FX?RLANDBIT,0,ROOMS,RIDDLE-ROOM,PEARL,T?PEARL-ROOM
	.OBJECT POOL,0,0,POOL-ROOM,LEAK,0,T?POOL
	.OBJECT ADVENTURER,FX?SACREDBIT+FX?INVISIBLE+FX?NDESCBIT,FX?ACTORBIT,0,0,0,T?ADVENTURER
	.OBJECT GREEN-BOOK,0,FX?BURNBIT+FX?CONTBIT+FX?TAKEBIT+FX?READBIT,LIBRARY,0,0,T?GREEN-BOOK
	.OBJECT FLASK,FX?TRANSBIT,FX?READBIT+FX?TAKEBIT,POOL-ROOM,0,0,T?FLASK
	.OBJECT WIZ-DOOR,0,FX?CONTBIT+FX?DOORBIT,LOCAL-GLOBALS,GLOBAL-UNICORN,0,T?WIZ-DOOR
	.OBJECT LOCAL-GLOBALS,0,0,GLOBAL-OBJECTS,COMPASS,STAIRS,T?LOCAL-GLOBALS
	.OBJECT WIZARDS-WORKSHOP,FX?RLANDBIT,0,ROOMS,GUARDIAN-ROOM,0,T?WIZARDS-WORKSHOP
	.OBJECT TINY-ROOM,FX?RLANDBIT,0,ROOMS,DREARY-ROOM,KEYHOLE-1,T?TINY-ROOM
	.OBJECT LEAK,FX?NDESCBIT,0,POOL-ROOM,FLASK,0,T?LEAK
	.OBJECT ROSE-BUSH,FX?TRYTAKEBIT+FX?NDESCBIT,0,LOCAL-GLOBALS,MOSS,0,T?ROSE-BUSH
	.OBJECT OFFICE,FX?RLANDBIT,0,ROOMS,DEPOSITORY,PORTRAIT,T?OFFICE
	.OBJECT SNWL,FX?NDESCBIT,0,LOCAL-GLOBALS,SSWL,0,T?SNWL
	.OBJECT INSIDE-BARROW,FX?RLANDBIT,FX?ONBIT,ROOMS,0,SWORD,T?INSIDE-BARROW
	.OBJECT BUCKET,FX?OPENBIT,FX?CONTBIT+FX?VEHBIT,WELL-BOTTOM,BOTTOM-ETCHINGS,0,T?BUCKET
	.OBJECT SHALLOW-FORD,FX?RLANDBIT,FX?ONBIT,ROOMS,GREAT-CAVERN,0,T?SHALLOW-FORD
	.OBJECT CAGE-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,MACHINE-ROOM,CAGE,T?CAGE-ROOM
	.OBJECT CARD,0,FX?BURNBIT+FX?TAKEBIT+FX?READBIT,SAFE,0,0,T?CARD
	.OBJECT PORTRAIT,FX?STAGGERED,FX?BURNBIT+FX?TAKEBIT,OFFICE,0,0,T?PORTRAIT
	.OBJECT DEAD-DRAGON,0,0,0,0,0,T?DEAD-DRAGON
	.OBJECT CERBERUS,FX?OPENBIT,FX?CONTBIT+FX?ACTORBIT,CERBERUS-ROOM,0,0,T?CERBERUS
	.OBJECT DREARY-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,OFFICE,PALANTIR-2,T?DREARY-ROOM
	.OBJECT DEAD-BALLOON,0,0,0,0,0,T?DEAD-BALLOON
	.OBJECT BLUE-BOOK,0,FX?BURNBIT+FX?CONTBIT+FX?TAKEBIT+FX?READBIT,LIBRARY,GREEN-BOOK,0,T?BLUE-BOOK
	.OBJECT GLOBAL-OBJECTS,FX?WEARBIT+FX?STAGGERED+FX?FIGHTBIT+FX?RLANDBIT+FX?TRANSBIT+FX?SEARCHBIT+FX?OPENBIT+FX?TRYTAKEBIT+FX?SURFACEBIT+FX?TOUCHBIT+FX?INVISIBLE,FX?ONBIT+FX?RMUNGBIT,0,0,HANDS,T?GLOBAL-OBJECTS
	.OBJECT TROPHY-ROOM,FX?RLANDBIT,0,ROOMS,WORKBENCH-ROOM,WIZARD-CASE,T?TROPHY-ROOM
	.OBJECT SMALL-ROOM,FX?RLANDBIT,0,ROOMS,VIEWING-EAST,0,T?SMALL-ROOM
	.OBJECT HOOK-2,0,0,LEDGE-2,0,0,T?HOOK-2
	.OBJECT IT,FX?TOUCHBIT+FX?NDESCBIT,0,GLOBAL-OBJECTS,INTNUM,0,T?IT
	.OBJECT BROKEN-CASE,FX?OPENBIT,FX?CONTBIT,0,0,0,T?BROKEN-CASE
	.OBJECT BAT,FX?INVISIBLE,FX?BURNBIT+FX?READBIT+FX?WEAPONBIT+FX?TAKEBIT,0,0,0,T?BAT
	.OBJECT WIZARDS-QUARTERS,FX?RLANDBIT,0,ROOMS,IN-AQUARIUM,0,T?WIZARDS-QUARTERS
	.OBJECT GLOBAL-PRINCESS,0,FX?ACTORBIT,GLOBAL-OBJECTS,WISH,0,T?GLOBAL-PRINCESS
	.OBJECT PATHOBJ,FX?NDESCBIT,0,GLOBAL-OBJECTS,ME,0,T?PATHOBJ
	.OBJECT COLLAR,FX?STAGGERED,FX?TAKEBIT,KENNEL,0,0,T?COLLAR
	.OBJECT RIBBON,FX?NDESCBIT,0,UNICORN,GOLD-KEY,0,T?RIBBON
	.OBJECT BRIDGE,FX?NDESCBIT,0,LOCAL-GLOBALS,ROSE-BUSH,0,T?BRIDGE
	.OBJECT DIAMOND-8,FX?RLANDBIT,0,ROOMS,DIAMOND-7,0,T?DIAMOND-8
	.OBJECT WORKBENCH,FX?OPENBIT+FX?SURFACEBIT+FX?NDESCBIT,FX?CONTBIT,WORKBENCH-ROOM,ARCANA,STAND-3,T?WORKBENCH
	.OBJECT PCRACK,FX?NDESCBIT,0,DREARY-ROOM,PTABLE,0,T?PCRACK
	.OBJECT STAMP,FX?STAGGERED,FX?BURNBIT+FX?TAKEBIT+FX?READBIT,PURPLE-BOOK,0,0,T?STAMP
	.OBJECT DOOR-KEEPER,FX?NDESCBIT,0,GUARDIAN-ROOM,0,0,T?DOOR-KEEPER
	.OBJECT STONE-BRIDGE,FX?RLANDBIT,0,ROOMS,FRESCO-ROOM,0,T?STONE-BRIDGE
	.OBJECT CHEST,0,FX?TAKEBIT+FX?CONTBIT,DRAGON-LAIR,0,STATUETTE,T?CHEST
	.OBJECT POOL-ROOM,FX?RLANDBIT,0,ROOMS,POSTS-ROOM,CANDY,T?POOL-ROOM
	.OBJECT EAT-ME-CAKE,0,FX?FOODBIT+FX?TAKEBIT+FX?READBIT,ALICE-TABLE,0,0,T?EAT-ME-CAKE
	.OBJECT MENHIR,FX?TURNBIT+FX?NDESCBIT,FX?READBIT,LOCAL-GLOBALS,GLOBAL-MENHIR,0,T?MENHIR
	.OBJECT TROPHY-BOTTLES,FX?TRYTAKEBIT+FX?NDESCBIT,0,TROPHY-ROOM,TROPHY-SWORD,0,T?TROPHY-BOTTLES
	.OBJECT VAIR-3,FX?NWALLBIT+FX?NONLANDBIT,0,ROOMS,VAIR-2,0,T?VAIR-3
	.OBJECT MACHINE-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,MAGNET-ROOM,TRIANGULAR-BUTTON,T?MACHINE-ROOM
	.OBJECT HOOK-1,0,0,LEDGE-1,0,0,T?HOOK-1
	.OBJECT STAND-1,FX?OPENBIT+FX?SURFACEBIT+FX?NDESCBIT,FX?CONTBIT,WORKBENCH,0,0,T?STAND-1
	.OBJECT SOUTH-WALL,FX?NDESCBIT,0,GLOBAL-OBJECTS,EAST-WALL,0,T?SOUTH-WALL
	.OBJECT PENTAGRAM-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,TROPHY-ROOM,PENTAGRAM,T?PENTAGRAM-ROOM
	.OBJECT BANK-ENTRANCE,FX?RLANDBIT,0,ROOMS,POOL-ROOM,0,T?BANK-ENTRANCE
	.OBJECT CLOTH-BAG,FX?NDESCBIT,0,BALLOON,BRAIDED-WIRE,0,T?CLOTH-BAG
	.OBJECT WORKBENCH-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,WIZARDS-WORKSHOP,WORKBENCH,T?WORKBENCH-ROOM
	.OBJECT DIAMOND-9,FX?RLANDBIT,0,ROOMS,DIAMOND-8,0,T?DIAMOND-9
	.OBJECT WANDS,FX?TRYTAKEBIT+FX?NDESCBIT,0,TROPHY-ROOM,DEGREE,0,T?WANDS
	.OBJECT RUBY,FX?STAGGERED,FX?TAKEBIT,LAVA-ROOM,0,0,T?RUBY
	.OBJECT ROBOT,FX?OPENBIT,FX?CONTBIT+FX?ACTORBIT,MAGNET-ROOM,ROBOT-LABEL,0,T?ROBOT
	.OBJECT STAND-3,FX?OPENBIT+FX?SURFACEBIT+FX?NDESCBIT,FX?CONTBIT,WORKBENCH,STAND-2,0,T?STAND-3
	.OBJECT PLACE-MAT,FX?OPENBIT+FX?SURFACEBIT,FX?CONTBIT+FX?TAKEBIT,GAZEBO-TABLE,NEWSPAPER,0,T?PLACE-MAT
	.OBJECT EXPLOSION,0,0,0,0,0,T?EXPLOSION
	.OBJECT VIEWING-EAST,FX?RLANDBIT,0,ROOMS,VIEWING-WEST,0,T?VIEWING-EAST
	.OBJECT BLUE-ICING,0,FX?FOODBIT+FX?TAKEBIT+FX?READBIT,ALICE-TABLE,EAT-ME-CAKE,0,T?BLUE-ICING
	.OBJECT STREAM,FX?NDESCBIT,0,LOCAL-GLOBALS,0,0,T?STREAM
	.OBJECT CHASM,FX?NDESCBIT,0,LOCAL-GLOBALS,STREAM,0,T?CHASM
	.OBJECT IN-CAGE,FX?NWALLBIT+FX?RLANDBIT,FX?ONBIT,ROOMS,CAGE-ROOM,0,T?IN-CAGE
	.OBJECT TEAPOT,FX?OPENBIT+FX?TRANSBIT,FX?CONTBIT+FX?TAKEBIT,GAZEBO-TABLE,PLACE-MAT,0,T?TEAPOT
	.OBJECT KEYHOLE-2,FX?SEARCHBIT+FX?OPENBIT+FX?NDESCBIT,0,DREARY-ROOM,PCRACK,KEY,T?KEYHOLE-2
	.OBJECT LID-2,FX?OPENBIT+FX?NDESCBIT,FX?CONTBIT,DREARY-ROOM,0,0,T?LID-2
	.OBJECT ROSE,0,FX?TAKEBIT,0,0,0,T?ROSE
	.OBJECT ICE,0,0,GLACIER-ROOM,0,0,T?ICE
	.OBJECT LID-1,FX?NDESCBIT,FX?CONTBIT,TINY-ROOM,0,0,T?LID-1
	.OBJECT VAIR-2,FX?NWALLBIT+FX?NONLANDBIT,0,ROOMS,VAIR-1,0,T?VAIR-2
	.OBJECT ZORKMID,0,0,GLOBAL-OBJECTS,PATHOBJ,0,T?ZORKMID
	.OBJECT DEPOSIT-BOX,FX?TRYTAKEBIT+FX?NDESCBIT,FX?TAKEBIT,GNOME-OF-ZURICH,0,0,T?DEPOSIT-BOX
	.OBJECT CRYPT,FX?NDESCBIT,FX?READBIT,CRYPT-ROOM,HEADS,0,T?CRYPT
	.OBJECT VOLCANO-VIEW,FX?RLANDBIT,0,ROOMS,LIBRARY,0,T?VOLCANO-VIEW
	.OBJECT HEADS,FX?TRYTAKEBIT+FX?NDESCBIT,0,CRYPT-ROOM,0,0,T?HEADS
	.OBJECT WELL-BOTTOM,FX?NONLANDBIT+FX?RLANDBIT,0,ROOMS,WELL-TOP,BUCKET,T?WELL-BOTTOM
	.OBJECT HEDGES,FX?NDESCBIT,0,TOPIARY-ROOM,0,0,T?HEDGES
	.OBJECT DIAMOND-2,FX?RLANDBIT,0,ROOMS,DIAMOND-1,0,T?DIAMOND-2
	.OBJECT POSTS-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,TEA-ROOM,POSTS,T?POSTS-ROOM
	.OBJECT SAILOR,FX?NDESCBIT,0,GLOBAL-OBJECTS,BLESSINGS,0,T?SAILOR
	.OBJECT RAVINE-LEDGE,FX?RLANDBIT,0,ROOMS,DEEP-FORD,0,T?RAVINE-LEDGE
	.OBJECT CRYPT-ROOM,FX?RLANDBIT,0,ROOMS,CRYPT-ANTEROOM,CRYPT,T?CRYPT-ROOM
	.OBJECT RECEPTACLE,FX?NDESCBIT+FX?SEARCHBIT,FX?CONTBIT,BALLOON,CLOTH-BAG,0,T?RECEPTACLE
	.OBJECT GOLD-KEY,FX?TRYTAKEBIT+FX?NDESCBIT+FX?STAGGERED,FX?TAKEBIT,UNICORN,0,0,T?GOLD-KEY
	.OBJECT KENNEL,FX?RLANDBIT,0,ROOMS,MENHIR-ROOM,COLLAR,T?KENNEL
	.OBJECT WIZARD-CASE,FX?TRANSBIT,FX?CONTBIT,TROPHY-ROOM,WARNING-LABEL,0,T?WIZARD-CASE
	.OBJECT KEYHOLE-1,FX?SEARCHBIT+FX?OPENBIT+FX?NDESCBIT,0,TINY-ROOM,LID-1,0,T?KEYHOLE-1
	.OBJECT CANDY,FX?INVISIBLE+FX?STAGGERED,FX?READBIT+FX?TAKEBIT+FX?FOODBIT,POOL-ROOM,POOL,0,T?CANDY
	.OBJECT SAFE,FX?NDESCBIT,FX?CONTBIT,SAFE-ROOM,0,CROWN,T?SAFE
	.OBJECT GNOME-OF-ZURICH,FX?OPENBIT,FX?CONTBIT+FX?ACTORBIT,0,0,DEPOSIT-BOX,T?GNOME-OF-ZURICH
	.OBJECT PEARL,FX?STAGGERED,FX?TAKEBIT,PEARL-ROOM,0,0,T?PEARL
	.OBJECT COMPASS,0,0,GLOBAL-OBJECTS,FOOTPAD,0,T?COMPASS
	.OBJECT LIBRARY,FX?RLANDBIT,0,ROOMS,LEDGE-1,PURPLE-BOOK,T?LIBRARY
	.OBJECT PDOOR,0,FX?CONTBIT+FX?DOORBIT,LOCAL-GLOBALS,GLOBAL-WIZARD-CASE,0,T?PDOOR
	.OBJECT BALLOON-LABEL,0,FX?BURNBIT+FX?TAKEBIT+FX?READBIT,0,0,0,T?BALLOON-LABEL
	.OBJECT WISH,FX?NDESCBIT,0,GLOBAL-OBJECTS,NORTH-WALL,0,T?WISH
	.OBJECT VIOLIN,FX?STAGGERED,FX?TAKEBIT,IRON-BOX,0,0,T?VIOLIN
	.OBJECT FRESCO-ROOM,FX?RLANDBIT,0,ROOMS,DRAGON-LAIR,0,T?FRESCO-ROOM
	.OBJECT DIAMOND-3,FX?RLANDBIT,0,ROOMS,DIAMOND-2,0,T?DIAMOND-3
	.OBJECT LEDGE-2,FX?NONLANDBIT+FX?RLANDBIT,0,ROOMS,VOLCANO-VIEW,HOOK-2,T?LEDGE-2
	.OBJECT CAROUSEL-ROOM,FX?RLANDBIT,0,ROOMS,WIZARDS-QUARTERS,IRON-BOX,T?CAROUSEL-ROOM
	.OBJECT SEWL,FX?NDESCBIT,0,LOCAL-GLOBALS,WELL,0,T?SEWL
	.OBJECT CROWN,FX?WEARBIT+FX?STAGGERED,FX?TAKEBIT,SAFE,CARD,0,T?CROWN
	.OBJECT RED-ICING,0,FX?FOODBIT+FX?TAKEBIT+FX?READBIT,ALICE-TABLE,ORANGE-ICING,0,T?RED-ICING
	.OBJECT NORTH-WALL,FX?NDESCBIT,0,GLOBAL-OBJECTS,WEST-WALL,0,T?NORTH-WALL
	.OBJECT LAMP,0,FX?LIGHTBIT+FX?TAKEBIT,INSIDE-BARROW,0,0,T?LAMP
	.OBJECT PRINCESS,0,FX?ACTORBIT,DRAGON-LAIR,CHEST,0,T?PRINCESS
	.OBJECT DIM-DOOR,FX?INVISIBLE,FX?CONTBIT+FX?DOORBIT,LOCAL-GLOBALS,CRYPT-DOOR,0,T?DIM-DOOR
	.OBJECT TELLER-WEST,FX?RLANDBIT,0,ROOMS,BANK-ENTRANCE,0,T?TELLER-WEST
	.OBJECT BLESSINGS,FX?NDESCBIT,0,GLOBAL-OBJECTS,IT,0,T?BLESSINGS
	.OBJECT GLOBAL-UNICORN,0,FX?ACTORBIT,LOCAL-GLOBALS,SNWL,0,T?GLOBAL-UNICORN
	.OBJECT ALICE-TABLE,FX?OPENBIT+FX?SURFACEBIT,FX?CONTBIT,TEA-ROOM,0,RED-ICING,T?ALICE-TABLE
	.OBJECT EAST-WALL,FX?NDESCBIT,0,GLOBAL-OBJECTS,TUNNEL,0,T?EAST-WALL
	.OBJECT FORMAL-GARDEN,FX?RLANDBIT,FX?ONBIT,ROOMS,GAZEBO-ROOM,0,T?FORMAL-GARDEN
	.OBJECT DARK-TUNNEL,FX?RLANDBIT,0,ROOMS,SHALLOW-FORD,0,T?DARK-TUNNEL
	.OBJECT MENHIR-ROOM,FX?RLANDBIT,0,ROOMS,ROOM-8,0,T?MENHIR-ROOM
	.OBJECT CUBE,FX?NDESCBIT,FX?READBIT,DEPOSITORY,BANK-BROCHURE,0,T?CUBE
	.OBJECT GLACIER-ROOM,FX?RLANDBIT,0,ROOMS,COOL-ROOM,ICE,T?GLACIER-ROOM
	.OBJECT CERBERUS-ROOM,FX?RLANDBIT,0,ROOMS,DIAMOND-9,CERBERUS,T?CERBERUS-ROOM
	.OBJECT SLOT,FX?NDESCBIT+FX?OPENBIT,0,SAFE-ROOM,SAFE,0,T?SLOT
	.OBJECT LUNGS,FX?NDESCBIT,0,GLOBAL-OBJECTS,GRUE,0,T?LUNGS
	.OBJECT WEST-WALL,FX?NDESCBIT,0,GLOBAL-OBJECTS,SOUTH-WALL,0,T?WEST-WALL
	.OBJECT GLOBAL-MENHIR,FX?NDESCBIT,FX?READBIT,LOCAL-GLOBALS,WIZ-DOOR,0,T?GLOBAL-MENHIR
	.OBJECT BROKEN-LAMP,0,FX?TAKEBIT,0,0,0,T?BROKEN-LAMP
	.OBJECT NARROW-TUNNEL,FX?RLANDBIT,FX?ONBIT,ROOMS,INSIDE-BARROW,0,T?NARROW-TUNNEL
	.OBJECT BALLOON,FX?OPENBIT,FX?VEHBIT,VOLCANO-BOTTOM,0,RECEPTACLE,T?BALLOON
	.OBJECT BRAIDED-WIRE,FX?NDESCBIT,0,BALLOON,0,0,T?BRAIDED-WIRE
	.OBJECT LEDGE-TUNNEL,FX?RLANDBIT,0,ROOMS,RAVINE-LEDGE,0,T?LEDGE-TUNNEL
	.OBJECT COOL-ROOM,FX?RLANDBIT,0,ROOMS,STONE-BRIDGE,0,T?COOL-ROOM
	.OBJECT PWINDOW,0,FX?DOORBIT,LOCAL-GLOBALS,PDOOR,0,T?PWINDOW
	.OBJECT GRUE,0,0,GLOBAL-OBJECTS,GROUND,0,T?GRUE
	.OBJECT DEGREE,FX?TRYTAKEBIT+FX?NDESCBIT,FX?READBIT,TROPHY-ROOM,0,0,T?DEGREE
	.OBJECT VOLCANO-BOTTOM,FX?NONLANDBIT+FX?RLANDBIT,0,ROOMS,PEARL-ROOM,BALLOON,T?VOLCANO-BOTTOM
	.OBJECT VAIR-4,FX?NWALLBIT+FX?NONLANDBIT,0,ROOMS,VAIR-3,0,T?VAIR-4
	.OBJECT GAZEBO-TABLE,FX?OPENBIT+FX?SURFACEBIT+FX?NDESCBIT,FX?CONTBIT,GAZEBO-ROOM,0,TEAPOT,T?GAZEBO-TABLE
	.OBJECT BILLS,FX?STAGGERED,FX?BURNBIT+FX?TAKEBIT+FX?READBIT,VAULT,0,0,T?BILLS
	.OBJECT STAIRS,FX?NDESCBIT,FX?CLIMBBIT,LOCAL-GLOBALS,PSEUDO-OBJECT,0,T?STAIRS
	.OBJECT NEWSPAPER,0,FX?READBIT+FX?BURNBIT+FX?TAKEBIT,GAZEBO-TABLE,LETTER-OPENER,0,T?NEWSPAPER
	.OBJECT SAFE-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,LEDGE-2,SLOT,T?SAFE-ROOM
	.OBJECT GREAT-CAVERN,FX?RLANDBIT,FX?ONBIT,ROOMS,FOOT-BRIDGE,0,T?GREAT-CAVERN
	.OBJECT LAVA-TUBE,FX?RLANDBIT,0,ROOMS,GLACIER-ROOM,0,T?LAVA-TUBE
	.OBJECT DIAMOND-1,FX?RLANDBIT,0,ROOMS,STAIRWAY-TOP,0,T?DIAMOND-1
	.OBJECT WATER,0,FX?DRINKBIT+FX?TAKEBIT,0,0,0,T?WATER
	.OBJECT MAGNET-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,LAVA-ROOM,ROBOT,T?MAGNET-ROOM
	.OBJECT GLOBAL-PALANTIR,FX?NDESCBIT,0,LOCAL-GLOBALS,GAZEBO,0,T?GLOBAL-PALANTIR
	.OBJECT GROUND,0,0,GLOBAL-OBJECTS,SAILOR,0,T?GROUND
	.OBJECT TEA-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,WELL-BOTTOM,ALICE-TABLE,T?TEA-ROOM
	.OBJECT TOP-ETCHINGS,FX?NDESCBIT,FX?READBIT,WELL-TOP,0,0,T?TOP-ETCHINGS
	.OBJECT DRAGON,0,FX?ACTORBIT,DRAGON-ROOM,0,0,T?DRAGON
	.OBJECT NOT-HERE-OBJECT,0,0,0,0,0,T?NOT-HERE-OBJECT
	.OBJECT CRYPT-ANTEROOM,FX?RLANDBIT,0,ROOMS,CERBERUS-ROOM,0,T?CRYPT-ANTEROOM
	.OBJECT POSTS,FX?NDESCBIT,0,POSTS-ROOM,0,0,T?POSTS
	.OBJECT INTNUM,0,FX?TOOLBIT,GLOBAL-OBJECTS,LOCAL-GLOBALS,0,T?INTNUM
	.OBJECT STAND-4,FX?OPENBIT+FX?SURFACEBIT,FX?CONTBIT,0,0,PALANTIR-4,T?STAND-4
	.OBJECT PURPLE-BOOK,FX?SEARCHBIT,FX?BURNBIT+FX?CONTBIT+FX?TAKEBIT+FX?READBIT,LIBRARY,WHITE-BOOK,STAMP,T?PURPLE-BOOK
	.OBJECT SSWL,FX?NDESCBIT,0,LOCAL-GLOBALS,SWWL,0,T?SSWL
	.OBJECT DEPOSITORY,FX?RLANDBIT,FX?ONBIT,ROOMS,VAULT,CURTAIN,T?DEPOSITORY
	.OBJECT DRAGON-LAIR,FX?RLANDBIT,0,ROOMS,DRAGON-ROOM,PRINCESS,T?DRAGON-LAIR
	.OBJECT DIAMOND-6,FX?RLANDBIT,0,ROOMS,DIAMOND-5,0,T?DIAMOND-6
	.OBJECT ARCANA,FX?TRYTAKEBIT+FX?NDESCBIT,0,WORKBENCH-ROOM,0,0,T?ARCANA
	.OBJECT VIEWING-WEST,FX?RLANDBIT,0,ROOMS,TELLER-EAST,0,T?VIEWING-WEST
	.OBJECT FOOTPAD,0,0,GLOBAL-OBJECTS,GLOBAL-PRINCESS,0,T?FOOTPAD
	.OBJECT COBWEBBY-CORRIDOR,FX?RLANDBIT,0,ROOMS,LAVA-TUBE,FUSE,T?COBWEBBY-CORRIDOR
	.OBJECT ROOM-8,FX?RLANDBIT,0,ROOMS,COBWEBBY-CORRIDOR,REPELLENT,T?ROOM-8
	.OBJECT GLOBAL-CERBERUS,0,0,LOCAL-GLOBALS,DWINDOW,0,T?GLOBAL-CERBERUS
	.OBJECT PENTAGRAM,FX?OPENBIT+FX?SURFACEBIT+FX?NDESCBIT,FX?CONTBIT,PENTAGRAM-ROOM,0,0,T?PENTAGRAM
	.OBJECT DEAD-PALANTIR-4,FX?RLANDBIT,FX?ONBIT,ROOMS,DEAD-PALANTIR-3,0,T?DEAD-PALANTIR-4
	.OBJECT SWWL,FX?NDESCBIT,0,LOCAL-GLOBALS,SEWL,0,T?SWWL
	.OBJECT STREAM-PATH,FX?RLANDBIT,0,ROOMS,TOPIARY-ROOM,0,T?STREAM-PATH
	.OBJECT FUSE,0,FX?BURNBIT+FX?TAKEBIT,COBWEBBY-CORRIDOR,0,0,T?FUSE
	.OBJECT REPELLENT,0,FX?READBIT+FX?TAKEBIT,ROOM-8,0,0,T?REPELLENT
	.OBJECT SALTY-WATER,0,FX?DRINKBIT+FX?TAKEBIT,0,0,0,T?SALTY-WATER
	.OBJECT DWINDOW,FX?TRYTAKEBIT+FX?NDESCBIT,0,LOCAL-GLOBALS,MENHIR,0,T?DWINDOW
	.OBJECT MOSS,FX?TRYTAKEBIT+FX?NDESCBIT,0,LOCAL-GLOBALS,CHASM,0,T?MOSS
	.OBJECT TOPIARY-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,FORMAL-GARDEN,HEDGES,T?TOPIARY-ROOM
	.OBJECT STAND-2,FX?OPENBIT+FX?SURFACEBIT+FX?NDESCBIT,FX?CONTBIT,WORKBENCH,STAND-1,0,T?STAND-2
	.OBJECT BANK-BROCHURE,0,FX?BURNBIT+FX?TAKEBIT+FX?READBIT,DEPOSITORY,0,0,T?BANK-BROCHURE
	.OBJECT TUNNEL,FX?NDESCBIT,0,GLOBAL-OBJECTS,0,0,T?TUNNEL
	.OBJECT GLOBAL-WIZARD-CASE,0,0,LOCAL-GLOBALS,DIM-DOOR,0,T?GLOBAL-WIZARD-CASE
	.OBJECT SWORD,FX?TRYTAKEBIT,FX?WEAPONBIT+FX?TAKEBIT,INSIDE-BARROW,LAMP,0,T?SWORD
	.OBJECT DEAD-PALANTIR-1,FX?RLANDBIT,FX?ONBIT,ROOMS,TINY-ROOM,0,T?DEAD-PALANTIR-1
	.OBJECT BRICK,FX?SEARCHBIT+FX?OPENBIT,FX?BURNBIT+FX?TAKEBIT,MARBLE-HALL,0,0,T?BRICK
	.OBJECT DIAMOND-7,FX?RLANDBIT,0,ROOMS,DIAMOND-6,0,T?DIAMOND-7
	.OBJECT DEAD-PALANTIR-2,FX?RLANDBIT,FX?ONBIT,ROOMS,DEAD-PALANTIR-1,0,T?DEAD-PALANTIR-2
	.OBJECT DEAD-PALANTIR-3,FX?RLANDBIT,FX?ONBIT,ROOMS,DEAD-PALANTIR-2,0,T?DEAD-PALANTIR-3
	.OBJECT GENIE,FX?INVISIBLE,FX?ACTORBIT,0,0,0,T?GENIE
	.OBJECT ZORK3,FX?RLANDBIT,FX?ONBIT,ROOMS,CRYPT-ROOM,0,T?ZORK3
	.OBJECT DEEP-FORD,FX?RLANDBIT,0,ROOMS,MARBLE-HALL,0,T?DEEP-FORD
	.OBJECT WHITE-BOOK,0,FX?BURNBIT+FX?CONTBIT+FX?TAKEBIT+FX?READBIT,LIBRARY,BLUE-BOOK,0,T?WHITE-BOOK
	.OBJECT AQUARIUM-ROOM,FX?RLANDBIT,FX?ONBIT,ROOMS,PENTAGRAM-ROOM,AQUARIUM,T?AQUARIUM-ROOM
	.OBJECT GARDEN-NORTH,FX?RLANDBIT,FX?ONBIT,ROOMS,DARK-TUNNEL,0,T?GARDEN-NORTH
	.OBJECT GAZEBO,FX?NDESCBIT,0,LOCAL-GLOBALS,PWINDOW,0,T?GAZEBO
	.OBJECT WARNING-LABEL,0,FX?READBIT,TROPHY-ROOM,TROPHY-BOTTLES,0,T?WARNING-LABEL
	.OBJECT IN-AQUARIUM,FX?RLANDBIT,FX?ONBIT,ROOMS,AQUARIUM-ROOM,PALANTIR-3,T?IN-AQUARIUM
	.OBJECT RIDDLE-ROOM,FX?RLANDBIT,0,ROOMS,CAROUSEL-ROOM,RIDDLE-DOOR,T?RIDDLE-ROOM
	.OBJECT GNOME,0,FX?ACTORBIT,0,0,0,T?GNOME
	.OBJECT STAIRWAY-TOP,FX?RLANDBIT,0,ROOMS,KENNEL,0,T?STAIRWAY-TOP
	.OBJECT MANGLED-CAGE,0,FX?TAKEBIT,0,0,0,T?MANGLED-CAGE
	.OBJECT DIAMOND-4,FX?RLANDBIT,0,ROOMS,DIAMOND-3,0,T?DIAMOND-4
	.OBJECT TELLER-EAST,FX?RLANDBIT,0,ROOMS,TELLER-WEST,0,T?TELLER-EAST
	.OBJECT ROBOT-LABEL,0,FX?BURNBIT+FX?TAKEBIT+FX?READBIT,MAGNET-ROOM,0,0,T?ROBOT-LABEL
	.OBJECT CRYPT-DOOR,0,FX?CONTBIT+FX?DOORBIT,LOCAL-GLOBALS,GLOBAL-CERBERUS,0,T?CRYPT-DOOR
	.OBJECT COIN,FX?STAGGERED,FX?TAKEBIT+FX?READBIT,LEDGE-1,HOOK-1,0,T?COIN
	.OBJECT LETTER-OPENER,0,FX?TOOLBIT+FX?TAKEBIT,GAZEBO-TABLE,MATCH,0,T?LETTER-OPENER
	.OBJECT DRAGON-ROOM,FX?RLANDBIT,0,ROOMS,LEDGE-TUNNEL,DRAGON,T?DRAGON-ROOM
	.OBJECT PSEUDO-OBJECT,0,0,LOCAL-GLOBALS,GLOBAL-PALANTIR,0,T?PSEUDO-OBJECT
	.OBJECT AQUARIUM,FX?OPENBIT,FX?CONTBIT,AQUARIUM-ROOM,0,SERPENT,T?AQUARIUM
	.OBJECT PTABLE,FX?OPENBIT+FX?SURFACEBIT+FX?NDESCBIT,FX?CONTBIT,DREARY-ROOM,LID-2,0,T?PTABLE
	.ENDT

; OBJECT PROPERTY TABLES ARE DEFINED HERE

OBJPRP::

T?ROUND-BUTTON::	.TABLE			; TABLE FOR OBJECT ROUND-BUTTON
	.STRL "round button"
	.PROP 2,P?SYNONYM
	W?BUTTON
	.PROP 1,P?ADJECTIVE
	.BYTE A?ROUND
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	BUTTONS
	.BYTE	0
	.ENDT

T?VAULT::	.TABLE			; TABLE FOR OBJECT VAULT
	.STRL "Vault"
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?100
	.PROP 4,P?GLOBAL
	.BYTE SEWL
	.BYTE SWWL
	.BYTE SNWL
	.BYTE SSWL
	.BYTE	0
	.ENDT

T?STATUETTE::	.TABLE			; TABLE FOR OBJECT STATUETTE
	.STRL "golden dragon statuette"
	.PROP 6,P?SYNONYM
	W?TREASURE
	W?STATUETTE
	W?DRAGON
	.PROP 1,P?ADJECTIVE
	.BYTE A?GOLD
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?30
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	20
	.BYTE	0
	.ENDT

T?TRIANGULAR-BUTTON::	.TABLE			; TABLE FOR OBJECT TRIANGULAR-BUTTON
	.STRL "triangular button"
	.PROP 2,P?SYNONYM
	W?BUTTON
	.PROP 1,P?ADJECTIVE
	.BYTE A?TRIANGULAR
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	BUTTONS
	.BYTE	0
	.ENDT

T?GLOBAL-WATER::	.TABLE			; TABLE FOR OBJECT GLOBAL-WATER
	.STRL "water"
	.PROP 4,P?SYNONYM
	W?WATER
	W?QUANTITY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WATER-FCN
	.BYTE	0
	.ENDT

T?WELL::	.TABLE			; TABLE FOR OBJECT WELL
	.STRL "well"
	.PROP 2,P?SYNONYM
	W?WELL
	.PROP 1,P?ADJECTIVE
	.BYTE A?MAGIC
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WELL-FCN
	.BYTE	0
	.ENDT

T?RIDDLE-DOOR::	.TABLE			; TABLE FOR OBJECT RIDDLE-DOOR
	.STRL "stone door"
	.PROP 2,P?SYNONYM
	W?DOOR
	.PROP 2,P?ADJECTIVE
	.BYTE A?GREAT
	.BYTE A?STONE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	RIDDLE-DOOR-FCN
	.BYTE	0
	.ENDT

T?WELL-TOP::	.TABLE			; TABLE FOR OBJECT WELL-TOP
	.STRL "Top of Well"
	.PROP 1,P?EAST
	.BYTE TEA-ROOM
	.PROP 2,P?DOWN			; STRING PROPERTY
	STR?88
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?87
	.PROP 1,P?GLOBAL
	.BYTE WELL
	.PROP 4,P?PSEUDO
	W?CRACK
	CRACK-PSEUDO
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	10
	.BYTE	0
	.ENDT

T?BOTTOM-ETCHINGS::	.TABLE			; TABLE FOR OBJECT BOTTOM-ETCHINGS
	.STRL "wall with etchings"
	.PROP 4,P?SYNONYM
	W?ETCHINGS
	W?WALL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	BOTTOM-ETCHINGS-F
	.BYTE	0
	.ENDT

T?TROPHY-SWORD::	.TABLE			; TABLE FOR OBJECT TROPHY-SWORD
	.STRL "nicked swords"
	.PROP 4,P?SYNONYM
	W?SWORD
	W?SWORDS
	.PROP 2,P?ADJECTIVE
	.BYTE A?DULL
	.BYTE A?NICKED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TROPHY-PSEUDO
	.BYTE	0
	.ENDT

T?CAGE::	.TABLE			; TABLE FOR OBJECT CAGE
	.STRL "solid steel cage"
	.PROP 2,P?SYNONYM
	W?CAGE
	.PROP 2,P?ADJECTIVE
	.BYTE A?STEEL
	.BYTE A?SOLID
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?145
	.BYTE	0
	.ENDT

T?HANDS::	.TABLE			; TABLE FOR OBJECT HANDS
	.STRL "pair of hands"
	.PROP 6,P?SYNONYM
	W?PAIR
	W?HANDS
	W?HAND
	.PROP 1,P?ADJECTIVE
	.BYTE A?BARE
	.BYTE	0
	.ENDT

T?LEDGE-1::	.TABLE			; TABLE FOR OBJECT LEDGE-1
	.STRL "Narrow Ledge"
	.PROP 4,P?WEST			; CONDITIONAL EXIT
	.BYTE VOLCANO-BOTTOM				; ROOM NAME
	.BYTE GNOME-DOOR-FLAG				; FLAG NAME
	0			; NO STRING
	.PROP 1,P?SOUTH
	.BYTE LIBRARY
	.PROP 2,P?DOWN			; STRING PROPERTY
	STR?78
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?77
	.BYTE	0
	.ENDT

T?KEY::	.TABLE			; TABLE FOR OBJECT KEY
	.STRL "rusty iron key"
	.PROP 2,P?SYNONYM
	W?KEY
	.PROP 2,P?ADJECTIVE
	.BYTE A?IRON
	.BYTE A?RUSTY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PKEY-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	2
	.BYTE	0
	.ENDT

T?LAVA-ROOM::	.TABLE			; TABLE FOR OBJECT LAVA-ROOM
	.STRL "Lava Room"
	.PROP 1,P?EAST
	.BYTE GLACIER-ROOM
	.PROP 1,P?SOUTH
	.BYTE VOLCANO-BOTTOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?83
	.BYTE	0
	.ENDT

T?GAZEBO-ROOM::	.TABLE			; TABLE FOR OBJECT GAZEBO-ROOM
	.STRL "Gazebo"
	.PROP 1,P?OUT
	.BYTE GARDEN-NORTH
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?13
	.PROP 2,P?GLOBAL
	.BYTE GLOBAL-UNICORN
	.BYTE GAZEBO
	.BYTE	0
	.ENDT

T?DEAD-SERPENT::	.TABLE			; TABLE FOR OBJECT DEAD-SERPENT
	.STRL "dead sea serpent"
	.PROP 4,P?SYNONYM
	W?SERPENT
	W?SNAKE
	.PROP 3,P?ADJECTIVE
	.BYTE A?DEAD
	.BYTE A?BABY
	.BYTE A?SEA
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DEAD-SERPENT-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	400
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?69
	.BYTE	0
	.ENDT

T?WIZARD::	.TABLE			; TABLE FOR OBJECT WIZARD
	.STRL "Wizard of Frobozz"
	.PROP 8,P?SYNONYM
	W?WIZARD
	W?MAGICIAN
	W?SORCEROR
	W?MAN
	.PROP 4,P?ADJECTIVE
	.BYTE A?STRANGE
	.BYTE A?LITTLE
	.BYTE A?FROBOZZ
	.BYTE A?OLD
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WIZARD-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?161
	.BYTE	0
	.ENDT

T?DIAMOND-5::	.TABLE			; TABLE FOR OBJECT DIAMOND-5
	.STRL "Oddly-angled Room"
	.PROP 1,P?NORTH
	.BYTE DIAMOND-2
	.PROP 1,P?EAST
	.BYTE DIAMOND-6
	.PROP 1,P?WEST
	.BYTE DIAMOND-4
	.PROP 1,P?SOUTH
	.BYTE DIAMOND-8
	.PROP 1,P?NE
	.BYTE DIAMOND-3
	.PROP 1,P?NW
	.BYTE DIAMOND-1
	.PROP 1,P?SE
	.BYTE DIAMOND-9
	.PROP 1,P?SW
	.BYTE DIAMOND-7
	.PROP 1,P?UP
	.BYTE STAIRWAY-TOP
	.PROP 1,P?DOWN
	.BYTE CERBERUS-ROOM
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DIAMOND-MOTION
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?50
	.PROP 2,P?GLOBAL
	.BYTE STAIRS
	.BYTE DWINDOW
	.BYTE	0
	.ENDT

T?CURTAIN::	.TABLE			; TABLE FOR OBJECT CURTAIN
	.STRL "shimmering curtain of light"
	.PROP 4,P?SYNONYM
	W?CURTAIN
	W?LIGHT
	.PROP 1,P?ADJECTIVE
	.BYTE A?SHIMMERING
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SCOL-OBJECT
	.BYTE	0
	.ENDT

T?FOOT-BRIDGE::	.TABLE			; TABLE FOR OBJECT FOOT-BRIDGE
	.STRL "Foot Bridge"
	.PROP 1,P?NORTH
	.BYTE NARROW-TUNNEL
	.PROP 1,P?SOUTH
	.BYTE GREAT-CAVERN
	.PROP 2,P?DOWN			; STRING PROPERTY
	STR?6
	.PROP 2,P?CROSS			; STRING PROPERTY
	STR?7
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?5
	.PROP 2,P?GLOBAL
	.BYTE BRIDGE
	.BYTE CHASM
	.BYTE	0
	.ENDT

T?IRON-BOX::	.TABLE			; TABLE FOR OBJECT IRON-BOX
	.STRL "steel box"
	.PROP 2,P?SYNONYM
	W?BOX
	.PROP 2,P?ADJECTIVE
	.BYTE A?STEEL
	.BYTE A?DENTED
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	40
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?144
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	20
	.BYTE	0
	.ENDT

T?MATCH::	.TABLE			; TABLE FOR OBJECT MATCH
	.STRL "matchbook"
	.PROP 6,P?SYNONYM
	W?MATCH
	W?MATCHES
	W?MATCHBOOK
	.PROP 1,P?ADJECTIVE
	.BYTE A?ZORK
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MATCH-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	2
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?104
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?105
	.BYTE	0
	.ENDT

T?WAND::	.TABLE			; TABLE FOR OBJECT WAND
	.STRL "Wizard's magic wand"
	.PROP 2,P?SYNONYM
	W?WAND
	.PROP 1,P?ADJECTIVE
	.BYTE A?MAGIC
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WAND-FCN
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	30
	.BYTE	0
	.ENDT

T?ME::	.TABLE			; TABLE FOR OBJECT ME
	.STRL "you"
	.PROP 8,P?SYNONYM
	W?ME
	W?MYSELF
	W?SELF
	W?CRETIN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CRETIN-FCN
	.BYTE	0
	.ENDT

T?UNICORN::	.TABLE			; TABLE FOR OBJECT UNICORN
	.STRL "unicorn"
	.PROP 4,P?SYNONYM
	W?UNICORN
	W?ANIMAL
	.PROP 2,P?ADJECTIVE
	.BYTE A?BEAUTIFUL
	.BYTE A?WHITE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	UNICORN-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?11
	.BYTE	0
	.ENDT

T?SQUARE-BUTTON::	.TABLE			; TABLE FOR OBJECT SQUARE-BUTTON
	.STRL "square button"
	.PROP 2,P?SYNONYM
	W?BUTTON
	.PROP 1,P?ADJECTIVE
	.BYTE A?SQUARE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	BUTTONS
	.BYTE	0
	.ENDT

T?GUARDIAN-ROOM::	.TABLE			; TABLE FOR OBJECT GUARDIAN-ROOM
	.STRL "Guarded Room"
	.PROP 1,P?NORTH
	.BYTE COBWEBBY-CORRIDOR
	.PROP 5,P?SOUTH			; DOOR EXIT
	.BYTE WIZARDS-WORKSHOP				; ROOM NAME
	.BYTE WIZ-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 5,P?IN			; DOOR EXIT
	.BYTE WIZARDS-WORKSHOP				; ROOM NAME
	.BYTE WIZ-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GUARDIAN-ROOM-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.PROP 1,P?GLOBAL
	.BYTE WIZ-DOOR
	.BYTE	0
	.ENDT

T?PALANTIR-1::	.TABLE			; TABLE FOR OBJECT PALANTIR-1
	.STRL "red crystal sphere"
	.PROP 6,P?SYNONYM
	W?SPHERE
	W?BALL
	W?PALANTIR
	.PROP 2,P?ADJECTIVE
	.BYTE A?CRYSTAL
	.BYTE A?RED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SPHERE-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	10
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?116
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	20
	.BYTE	0
	.ENDT

T?MARBLE-HALL::	.TABLE			; TABLE FOR OBJECT MARBLE-HALL
	.STRL "Marble Hall"
	.PROP 1,P?NORTH
	.BYTE DEEP-FORD
	.PROP 4,P?EAST			; CONDITIONAL EXIT
	.BYTE STREAM-PATH				; ROOM NAME
	.BYTE SECRET-DOOR				; FLAG NAME
	STR?19			; STRING
	.PROP 1,P?SOUTH
	.BYTE CAROUSEL-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?18
	.PROP 1,P?GLOBAL
	.BYTE STREAM
	.BYTE	0
	.ENDT

T?PALANTIR-3::	.TABLE			; TABLE FOR OBJECT PALANTIR-3
	.STRL "clear crystal sphere"
	.PROP 4,P?SYNONYM
	W?PALANTIR
	W?SPHERE
	.PROP 3,P?ADJECTIVE
	.BYTE A?CRYSTAL
	.BYTE A?WHITE
	.BYTE A?CLEAR
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PALANTIR
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?67
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	20
	.BYTE	0
	.ENDT

T?SERPENT::	.TABLE			; TABLE FOR OBJECT SERPENT
	.STRL "baby sea serpent"
	.PROP 4,P?SYNONYM
	W?SERPENT
	W?SNAKE
	.PROP 2,P?ADJECTIVE
	.BYTE A?BABY
	.BYTE A?SEA
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SERPENT-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?68
	.BYTE	0
	.ENDT

T?PALANTIR-2::	.TABLE			; TABLE FOR OBJECT PALANTIR-2
	.STRL "blue crystal sphere"
	.PROP 4,P?SYNONYM
	W?PALANTIR
	W?SPHERE
	.PROP 2,P?ADJECTIVE
	.BYTE A?CRYSTAL
	.BYTE A?BLUE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PALANTIR
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?157
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	20
	.BYTE	0
	.ENDT

T?VAIR-1::	.TABLE			; TABLE FOR OBJECT VAIR-1
	.STRL "Volcano Core"
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?73
	.BYTE	0
	.ENDT

T?ORANGE-ICING::	.TABLE			; TABLE FOR OBJECT ORANGE-ICING
	.STRL "cake frosted with orange letters"
	.PROP 8,P?SYNONYM
	W?CAKE
	W?CAKES
	W?ICING
	W?LETTER
	.PROP 2,P?ADJECTIVE
	.BYTE A?ORANGE
	.BYTE A?FROSTED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CAKE-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	4
	.BYTE	0
	.ENDT

T?PALANTIR-4::	.TABLE			; TABLE FOR OBJECT PALANTIR-4
	.STRL "black crystal sphere"
	.PROP 6,P?SYNONYM
	W?SPHERE
	W?BALL
	W?PALANTIR
	.PROP 3,P?ADJECTIVE
	.BYTE A?CRYSTAL
	.BYTE A?STRANGE
	.BYTE A?BLACK
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PALANTIR
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	10
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?57
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	30
	.BYTE	0
	.ENDT

T?ROOMS::	.TABLE			; TABLE FOR OBJECT ROOMS
	.STRL ""
	.PROP 1,P?IN
	.BYTE ROOMS
	.BYTE	0
	.ENDT

T?PEARL-ROOM::	.TABLE			; TABLE FOR OBJECT PEARL-ROOM
	.STRL "Pearl Room"
	.PROP 1,P?EAST
	.BYTE WELL-BOTTOM
	.PROP 1,P?WEST
	.BYTE RIDDLE-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?71
	.BYTE	0
	.ENDT

T?POOL::	.TABLE			; TABLE FOR OBJECT POOL
	.STRL "pool of tears"
	.PROP 4,P?SYNONYM
	W?POOL
	W?TEARS
	.PROP 1,P?ADJECTIVE
	.BYTE A?LARGE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	POOL-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?128
	.BYTE	0
	.ENDT

T?ADVENTURER::	.TABLE			; TABLE FOR OBJECT ADVENTURER
	.STRL "cretin"
	.PROP 2,P?SYNONYM
	W?ADVENTURER
	.PROP 2,P?ACTION			; INTEGER/CONSTANT PROPERTY

	0
	.PROP 2,P?STRENGTH			; INTEGER/CONSTANT PROPERTY

	0
	.BYTE	0
	.ENDT

T?GREEN-BOOK::	.TABLE			; TABLE FOR OBJECT GREEN-BOOK
	.STRL "green book"
	.PROP 6,P?SYNONYM
	W?BOOK
	W?COVER
	W?BOOKS
	.PROP 3,P?ADJECTIVE
	.BYTE A?HANDSOME
	.BYTE A?GREEN
	.BYTE A?LEATHER
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	RANDOM-BOOK
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	10
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?134
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	2
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?135
	.BYTE	0
	.ENDT

T?FLASK::	.TABLE			; TABLE FOR OBJECT FLASK
	.STRL "stoppered glass flask filled with liquid"
	.PROP 2,P?SYNONYM
	W?FLASK
	.PROP 1,P?ADJECTIVE
	.BYTE A?GLASS
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	FLASK-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	10
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?119
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	5
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?120
	.BYTE	0
	.ENDT

T?WIZ-DOOR::	.TABLE			; TABLE FOR OBJECT WIZ-DOOR
	.STRL "door partly covered in cobwebs"
	.PROP 2,P?SYNONYM
	W?DOOR
	.PROP 3,P?ADJECTIVE
	.BYTE A?COBWEBBED
	.BYTE A?WOODEN
	.BYTE A?OAK
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WIZ-DOOR-FCN
	.BYTE	0
	.ENDT

T?LOCAL-GLOBALS::	.TABLE			; TABLE FOR OBJECT LOCAL-GLOBALS
	.STRL ""
	.PROP 2,P?SYNONYM
	W?ZZMGCK
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	0
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?166
	.PROP 1,P?GLOBAL
	.BYTE GLOBAL-OBJECTS
	.PROP 4,P?PSEUDO
	W?FOOBAR
	V-WALK
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?166
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	0
	.PROP 2,P?DESCFCN			; ATOM (CONSTANT) PROPERTY

	PATH-OBJECT
	.PROP 2,P?VTYPE			; INTEGER/CONSTANT PROPERTY

	1
	.PROP 2,P?CONTFCN			; INTEGER/CONSTANT PROPERTY

	0
	.PROP 2,P?ADVFCN			; INTEGER/CONSTANT PROPERTY

	0
	.BYTE	0
	.ENDT

T?WIZARDS-WORKSHOP::	.TABLE			; TABLE FOR OBJECT WIZARDS-WORKSHOP
	.STRL "Wizard's Workshop"
	.PROP 5,P?NORTH			; DOOR EXIT
	.BYTE GUARDIAN-ROOM				; ROOM NAME
	.BYTE WIZ-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 1,P?WEST
	.BYTE WORKBENCH-ROOM
	.PROP 1,P?SOUTH
	.BYTE TROPHY-ROOM
	.PROP 5,P?OUT			; DOOR EXIT
	.BYTE GUARDIAN-ROOM				; ROOM NAME
	.BYTE WIZ-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WORKSHOP-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?55
	.PROP 1,P?GLOBAL
	.BYTE WIZ-DOOR
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	10
	.BYTE	0
	.ENDT

T?TINY-ROOM::	.TABLE			; TABLE FOR OBJECT TINY-ROOM
	.STRL "Tiny Room"
	.PROP 5,P?NORTH			; DOOR EXIT
	.BYTE DREARY-ROOM				; ROOM NAME
	.BYTE PDOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 1,P?DOWN
	.BYTE RAVINE-LEDGE
	.PROP 5,P?IN			; DOOR EXIT
	.BYTE DREARY-ROOM				; ROOM NAME
	.BYTE PDOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TINY-ROOM-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.PROP 3,P?GLOBAL
	.BYTE PDOOR
	.BYTE PWINDOW
	.BYTE CHASM
	.BYTE	0
	.ENDT

T?LEAK::	.TABLE			; TABLE FOR OBJECT LEAK
	.STRL "leak"
	.PROP 2,P?SYNONYM
	W?LEAK
	.PROP 1,P?ADJECTIVE
	.BYTE A?LARGE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PLEAK
	.BYTE	0
	.ENDT

T?ROSE-BUSH::	.TABLE			; TABLE FOR OBJECT ROSE-BUSH
	.STRL "roses"
	.PROP 6,P?SYNONYM
	W?ROSES
	W?BUSH
	W?ARBOR
	.PROP 1,P?ADJECTIVE
	.BYTE A?ROSE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	ROSE-BUSH-FCN
	.BYTE	0
	.ENDT

T?OFFICE::	.TABLE			; TABLE FOR OBJECT OFFICE
	.STRL "Chairman's Office"
	.PROP 1,P?NORTH
	.BYTE DEPOSITORY
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?103
	.BYTE	0
	.ENDT

T?SNWL::	.TABLE			; TABLE FOR OBJECT SNWL
	.STRL "north wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 2,P?ADJECTIVE
	.BYTE A?NORTH
	.BYTE A?NORTHE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SCOLWALL
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	0
	.BYTE	0
	.ENDT

T?INSIDE-BARROW::	.TABLE			; TABLE FOR OBJECT INSIDE-BARROW
	.STRL "Inside the Barrow"
	.PROP 1,P?SOUTH
	.BYTE NARROW-TUNNEL
	.PROP 2,P?OUT			; STRING PROPERTY
	STR?2
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?1
	.BYTE	0
	.ENDT

T?BUCKET::	.TABLE			; TABLE FOR OBJECT BUCKET
	.STRL "wooden bucket"
	.PROP 2,P?SYNONYM
	W?BUCKET
	.PROP 1,P?ADJECTIVE
	.BYTE A?WOODEN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	BUCKET-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	100
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?148
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	100
	.PROP 2,P?VTYPE			; INTEGER/CONSTANT PROPERTY

	0
	.PROP 2,P?CONTFCN			; ATOM (CONSTANT) PROPERTY

	BUCKET-CONT
	.BYTE	0
	.ENDT

T?SHALLOW-FORD::	.TABLE			; TABLE FOR OBJECT SHALLOW-FORD
	.STRL "Shallow Ford"
	.PROP 1,P?NORTH
	.BYTE GREAT-CAVERN
	.PROP 1,P?SOUTH
	.BYTE DARK-TUNNEL
	.PROP 1,P?CROSS
	.BYTE DARK-TUNNEL
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?9
	.PROP 1,P?GLOBAL
	.BYTE GLOBAL-WATER
	.BYTE	0
	.ENDT

T?CAGE-ROOM::	.TABLE			; TABLE FOR OBJECT CAGE-ROOM
	.STRL "Dingy Closet"
	.PROP 1,P?NORTH
	.BYTE MACHINE-ROOM
	.PROP 1,P?OUT
	.BYTE MACHINE-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?85
	.BYTE	0
	.ENDT

T?CARD::	.TABLE			; TABLE FOR OBJECT CARD
	.STRL "card"
	.PROP 4,P?SYNONYM
	W?CARD
	W?NOTE
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	1
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?112
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?113
	.BYTE	0
	.ENDT

T?PORTRAIT::	.TABLE			; TABLE FOR OBJECT PORTRAIT
	.STRL "portrait of J. Pierpont Flathead"
	.PROP 8,P?SYNONYM
	W?PORTRAIT
	W?PAINTING
	W?ART
	W?TREASURE
	.PROP 1,P?ADJECTIVE
	.BYTE A?FLATHEAD
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	25
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?152
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?153
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	20
	.BYTE	0
	.ENDT

T?DEAD-DRAGON::	.TABLE			; TABLE FOR OBJECT DEAD-DRAGON
	.STRL "huge dead dragon"
	.PROP 6,P?SYNONYM
	W?DRAGON
	W?SMAUG
	W?WORM
	.PROP 3,P?ADJECTIVE
	.BYTE A?RED
	.BYTE A?HUGE
	.BYTE A?DEAD
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	400
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?33
	.BYTE	0
	.ENDT

T?CERBERUS::	.TABLE			; TABLE FOR OBJECT CERBERUS
	.STRL "three-headed dog"
	.PROP 8,P?SYNONYM
	W?CERBERUS
	W?DOG
	W?HOUND
	W?MONSTER
	.PROP 4,P?ADJECTIVE
	.BYTE A?HUGE
	.BYTE A?GIANT
	.BYTE A?THREE
	.BYTE A?HEADED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CERBERUS-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?53
	.BYTE	0
	.ENDT

T?DREARY-ROOM::	.TABLE			; TABLE FOR OBJECT DREARY-ROOM
	.STRL "Dreary Room"
	.PROP 5,P?SOUTH			; DOOR EXIT
	.BYTE TINY-ROOM				; ROOM NAME
	.BYTE PDOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 5,P?OUT			; DOOR EXIT
	.BYTE TINY-ROOM				; ROOM NAME
	.BYTE PDOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DREARY-ROOM-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.PROP 2,P?GLOBAL
	.BYTE PDOOR
	.BYTE PWINDOW
	.BYTE	0
	.ENDT

T?DEAD-BALLOON::	.TABLE			; TABLE FOR OBJECT DEAD-BALLOON
	.STRL "broken balloon"
	.PROP 4,P?SYNONYM
	W?BALLOON
	W?BASKET
	.PROP 1,P?ADJECTIVE
	.BYTE A?BROKEN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	40
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?111
	.BYTE	0
	.ENDT

T?BLUE-BOOK::	.TABLE			; TABLE FOR OBJECT BLUE-BOOK
	.STRL "blue book"
	.PROP 6,P?SYNONYM
	W?BOOK
	W?COVER
	W?BOOKS
	.PROP 1,P?ADJECTIVE
	.BYTE A?BLUE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	RANDOM-BOOK
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	10
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?136
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	2
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?135
	.BYTE	0
	.ENDT

T?GLOBAL-OBJECTS::	.TABLE			; TABLE FOR OBJECT GLOBAL-OBJECTS
	.STRL ""
	.BYTE	0
	.ENDT

T?TROPHY-ROOM::	.TABLE			; TABLE FOR OBJECT TROPHY-ROOM
	.STRL "Trophy Room"
	.PROP 1,P?NORTH
	.BYTE WIZARDS-WORKSHOP
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?58
	.PROP 8,P?PSEUDO
	W?OWL
	TROPHY-PSEUDO
	W?HOMUNCULI
	TROPHY-PSEUDO
	.BYTE	0
	.ENDT

T?SMALL-ROOM::	.TABLE			; TABLE FOR OBJECT SMALL-ROOM
	.STRL "Small Room"
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?99
	.PROP 4,P?GLOBAL
	.BYTE SEWL
	.BYTE SWWL
	.BYTE SNWL
	.BYTE SSWL
	.BYTE	0
	.ENDT

T?HOOK-2::	.TABLE			; TABLE FOR OBJECT HOOK-2
	.STRL "hook"
	.PROP 2,P?SYNONYM
	W?HOOK
	.PROP 1,P?ADJECTIVE
	.BYTE A?SMALL
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?123
	.BYTE	0
	.ENDT

T?IT::	.TABLE			; TABLE FOR OBJECT IT
	.STRL "random object"
	.PROP 8,P?SYNONYM
	W?IT
	W?THEM
	W?HER
	W?HIM
	.BYTE	0
	.ENDT

T?BROKEN-CASE::	.TABLE			; TABLE FOR OBJECT BROKEN-CASE
	.STRL "smashed trophy cabinet"
	.PROP 4,P?SYNONYM
	W?CASE
	W?CABINET
	.PROP 3,P?ADJECTIVE
	.BYTE A?BROKEN
	.BYTE A?TROPHY
	.BYTE A?WIZARD
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?63
	.BYTE	0
	.ENDT

T?BAT::	.TABLE			; TABLE FOR OBJECT BAT
	.STRL "wooden club"
	.PROP 4,P?SYNONYM
	W?CLUB
	W?BAT
	.PROP 2,P?ADJECTIVE
	.BYTE A?WOODEN
	.BYTE A?BASEBALL
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?47
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?48
	.BYTE	0
	.ENDT

T?WIZARDS-QUARTERS::	.TABLE			; TABLE FOR OBJECT WIZARDS-QUARTERS
	.STRL "Wizard's Quarters"
	.PROP 1,P?NORTH
	.BYTE AQUARIUM-ROOM
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WIZARD-QUARTERS-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.BYTE	0
	.ENDT

T?GLOBAL-PRINCESS::	.TABLE			; TABLE FOR OBJECT GLOBAL-PRINCESS
	.STRL "beautiful princess"
	.PROP 6,P?SYNONYM
	W?PRINCESS
	W?WOMAN
	W?LADY
	.PROP 2,P?ADJECTIVE
	.BYTE A?BEAUTIFUL
	.BYTE A?YOUNG
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PRINCESS-FCN
	.BYTE	0
	.ENDT

T?PATHOBJ::	.TABLE			; TABLE FOR OBJECT PATHOBJ
	.STRL "passage"
	.PROP 4,P?SYNONYM
	W?TRAIL
	W?PATH
	.PROP 4,P?ADJECTIVE
	.BYTE A?FOREST
	.BYTE A?NARROW
	.BYTE A?LONG
	.BYTE A?WINDING
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PATH-OBJECT
	.BYTE	0
	.ENDT

T?COLLAR::	.TABLE			; TABLE FOR OBJECT COLLAR
	.STRL "gigantic dog collar"
	.PROP 4,P?SYNONYM
	W?COLLAR
	W?TREASURE
	.PROP 3,P?ADJECTIVE
	.BYTE A?HUGE
	.BYTE A?GIANT
	.BYTE A?DOG
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	COLLAR-FCN
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?46
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	15
	.BYTE	0
	.ENDT

T?RIBBON::	.TABLE			; TABLE FOR OBJECT RIBBON
	.STRL "ribbon"
	.PROP 2,P?SYNONYM
	W?RIBBON
	.PROP 2,P?ADJECTIVE
	.BYTE A?VELVET
	.BYTE A?SATIN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	UNICORN-FCN
	.BYTE	0
	.ENDT

T?BRIDGE::	.TABLE			; TABLE FOR OBJECT BRIDGE
	.STRL "bridge"
	.PROP 2,P?SYNONYM
	W?BRIDGE
	.PROP 3,P?ADJECTIVE
	.BYTE A?STONE
	.BYTE A?WOODEN
	.BYTE A?RICKETY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	BRIDGE-FCN
	.BYTE	0
	.ENDT

T?DIAMOND-8::	.TABLE			; TABLE FOR OBJECT DIAMOND-8
	.STRL "Oddly-angled Room"
	.PROP 1,P?NORTH
	.BYTE DIAMOND-5
	.PROP 1,P?NE
	.BYTE DIAMOND-6
	.PROP 1,P?NW
	.BYTE DIAMOND-4
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DIAMOND-MOTION
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?50
	.PROP 1,P?GLOBAL
	.BYTE DWINDOW
	.BYTE	0
	.ENDT

T?WORKBENCH::	.TABLE			; TABLE FOR OBJECT WORKBENCH
	.STRL "Wizard's workbench"
	.PROP 6,P?SYNONYM
	W?WORKBENCH
	W?BENCH
	W?TABLE
	.PROP 4,P?ADJECTIVE
	.BYTE A?WORK
	.BYTE A?HEAVY
	.BYTE A?WOODEN
	.BYTE A?WIZARD
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	200
	.BYTE	0
	.ENDT

T?PCRACK::	.TABLE			; TABLE FOR OBJECT PCRACK
	.STRL "narrow crack"
	.PROP 2,P?SYNONYM
	W?CRACK
	.PROP 1,P?ADJECTIVE
	.BYTE A?NARROW
	.BYTE	0
	.ENDT

T?STAMP::	.TABLE			; TABLE FOR OBJECT STAMP
	.STRL "Flathead stamp"
	.PROP 4,P?SYNONYM
	W?STAMP
	W?TREASURE
	.PROP 1,P?ADJECTIVE
	.BYTE A?FLATHEAD
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	1
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?132
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	10
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?133
	.BYTE	0
	.ENDT

T?DOOR-KEEPER::	.TABLE			; TABLE FOR OBJECT DOOR-KEEPER
	.STRL "lizard"
	.PROP 8,P?SYNONYM
	W?KEEPER
	W?GUARDIAN
	W?LIZARD
	W?HEAD
	.PROP 1,P?ADJECTIVE
	.BYTE A?NASTY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DOOR-KEEPER-FCN
	.BYTE	0
	.ENDT

T?STONE-BRIDGE::	.TABLE			; TABLE FOR OBJECT STONE-BRIDGE
	.STRL "Stone Bridge"
	.PROP 1,P?NORTH
	.BYTE DRAGON-ROOM
	.PROP 1,P?SOUTH
	.BYTE COOL-ROOM
	.PROP 2,P?DOWN			; STRING PROPERTY
	STR?37
	.PROP 2,P?CROSS			; STRING PROPERTY
	STR?7
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?36
	.PROP 2,P?GLOBAL
	.BYTE BRIDGE
	.BYTE CHASM
	.BYTE	0
	.ENDT

T?CHEST::	.TABLE			; TABLE FOR OBJECT CHEST
	.STRL "rotten wooden chest"
	.PROP 4,P?SYNONYM
	W?CHEST
	W?TRUNK
	.PROP 3,P?ADJECTIVE
	.BYTE A?WOODEN
	.BYTE A?OLD
	.BYTE A?ROTTEN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CHEST-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	40
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?29
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	40
	.BYTE	0
	.ENDT

T?POOL-ROOM::	.TABLE			; TABLE FOR OBJECT POOL-ROOM
	.STRL "Pool Room"
	.PROP 1,P?WEST
	.BYTE POSTS-ROOM
	.PROP 1,P?OUT
	.BYTE POSTS-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?95
	.BYTE	0
	.ENDT

T?EAT-ME-CAKE::	.TABLE			; TABLE FOR OBJECT EAT-ME-CAKE
	.STRL "cake frosted with green letters"
	.PROP 8,P?SYNONYM
	W?CAKE
	W?ICING
	W?CAKES
	W?LETTER
	.PROP 2,P?ADJECTIVE
	.BYTE A?GREEN
	.BYTE A?FROSTED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	EATME-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	4
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?127
	.BYTE	0
	.ENDT

T?MENHIR::	.TABLE			; TABLE FOR OBJECT MENHIR
	.STRL "enormous menhir"
	.PROP 8,P?SYNONYM
	W?MENHIR
	W?ROCK
	W?STONE
	W?F
	.PROP 3,P?ADJECTIVE
	.BYTE A?HUGE
	.BYTE A?HEAVY
	.BYTE A?ENORMOUS
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MENHIR-FCN
	.BYTE	0
	.ENDT

T?TROPHY-BOTTLES::	.TABLE			; TABLE FOR OBJECT TROPHY-BOTTLES
	.STRL "small bottles"
	.PROP 2,P?SYNONYM
	W?BOTTLE
	.PROP 1,P?ADJECTIVE
	.BYTE A?SMALL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TROPHY-PSEUDO
	.BYTE	0
	.ENDT

T?VAIR-3::	.TABLE			; TABLE FOR OBJECT VAIR-3
	.STRL "Volcano by Viewing Ledge"
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?75
	.BYTE	0
	.ENDT

T?MACHINE-ROOM::	.TABLE			; TABLE FOR OBJECT MACHINE-ROOM
	.STRL "Machine Room"
	.PROP 1,P?WEST
	.BYTE MAGNET-ROOM
	.PROP 1,P?SOUTH
	.BYTE CAGE-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?84
	.BYTE	0
	.ENDT

T?HOOK-1::	.TABLE			; TABLE FOR OBJECT HOOK-1
	.STRL "hook"
	.PROP 2,P?SYNONYM
	W?HOOK
	.PROP 1,P?ADJECTIVE
	.BYTE A?SMALL
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?123
	.BYTE	0
	.ENDT

T?STAND-1::	.TABLE			; TABLE FOR OBJECT STAND-1
	.STRL "ruby stand"
	.PROP 4,P?SYNONYM
	W?STAND
	W?STANDS
	.PROP 2,P?ADJECTIVE
	.BYTE A?CRYSTAL
	.BYTE A?RUBY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	STAND-FCN
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	10
	.BYTE	0
	.ENDT

T?SOUTH-WALL::	.TABLE			; TABLE FOR OBJECT SOUTH-WALL
	.STRL "south wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 2,P?ADJECTIVE
	.BYTE A?SOUTH
	.BYTE A?SOUTHE
	.BYTE	0
	.ENDT

T?PENTAGRAM-ROOM::	.TABLE			; TABLE FOR OBJECT PENTAGRAM-ROOM
	.STRL "Pentagram Room"
	.PROP 1,P?NORTH
	.BYTE WORKBENCH-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?64
	.PROP 3,P?GLOBAL
	.BYTE GLOBAL-MENHIR
	.BYTE GLOBAL-CERBERUS
	.BYTE GLOBAL-WIZARD-CASE
	.BYTE	0
	.ENDT

T?BANK-ENTRANCE::	.TABLE			; TABLE FOR OBJECT BANK-ENTRANCE
	.STRL "Bank Entrance"
	.PROP 1,P?EAST
	.BYTE FRESCO-ROOM
	.PROP 1,P?NE
	.BYTE TELLER-EAST
	.PROP 1,P?NW
	.BYTE TELLER-WEST
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?96
	.BYTE	0
	.ENDT

T?CLOTH-BAG::	.TABLE			; TABLE FOR OBJECT CLOTH-BAG
	.STRL "cloth bag"
	.PROP 2,P?SYNONYM
	W?BAG
	.PROP 1,P?ADJECTIVE
	.BYTE A?CLOTH
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	BCONTENTS
	.BYTE	0
	.ENDT

T?WORKBENCH-ROOM::	.TABLE			; TABLE FOR OBJECT WORKBENCH-ROOM
	.STRL "Wizard's Workroom"
	.PROP 1,P?EAST
	.BYTE WIZARDS-WORKSHOP
	.PROP 1,P?WEST
	.BYTE AQUARIUM-ROOM
	.PROP 1,P?SOUTH
	.BYTE PENTAGRAM-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?56
	.PROP 8,P?PSEUDO
	W?MORTAR
	ARCANA-PSEUDO
	W?PESTLE
	ARCANA-PSEUDO
	.BYTE	0
	.ENDT

T?DIAMOND-9::	.TABLE			; TABLE FOR OBJECT DIAMOND-9
	.STRL "Oddly-angled Room"
	.PROP 1,P?NW
	.BYTE DIAMOND-5
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DIAMOND-MOTION
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?50
	.PROP 1,P?GLOBAL
	.BYTE DWINDOW
	.BYTE	0
	.ENDT

T?WANDS::	.TABLE			; TABLE FOR OBJECT WANDS
	.STRL "set of used wands"
	.PROP 8,P?SYNONYM
	W?WANDS
	W?WAND
	W?RACK
	W?SET
	.PROP 2,P?ADJECTIVE
	.BYTE A?WORN
	.BYTE A?USED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TROPHY-PSEUDO
	.BYTE	0
	.ENDT

T?RUBY::	.TABLE			; TABLE FOR OBJECT RUBY
	.STRL "ruby"
	.PROP 4,P?SYNONYM
	W?RUBY
	W?TREASURE
	.PROP 1,P?ADJECTIVE
	.BYTE A?MOBY
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?143
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?142
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	15
	.BYTE	0
	.ENDT

T?ROBOT::	.TABLE			; TABLE FOR OBJECT ROBOT
	.STRL "robot"
	.PROP 8,P?SYNONYM
	W?ROBOT
	W?R2D2
	W?C3PO
	W?ROBBY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	ROBOT-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?141
	.BYTE	0
	.ENDT

T?STAND-3::	.TABLE			; TABLE FOR OBJECT STAND-3
	.STRL "diamond stand"
	.PROP 4,P?SYNONYM
	W?STAND
	W?STANDS
	.PROP 2,P?ADJECTIVE
	.BYTE A?DIAMOND
	.BYTE A?CRYSTAL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	STAND-FCN
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	10
	.BYTE	0
	.ENDT

T?PLACE-MAT::	.TABLE			; TABLE FOR OBJECT PLACE-MAT
	.STRL "place mat"
	.PROP 4,P?SYNONYM
	W?MAT
	W?PLACEM
	.PROP 1,P?ADJECTIVE
	.BYTE A?PLACE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PLACE-MAT-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	12
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	20
	.BYTE	0
	.ENDT

T?EXPLOSION::	.TABLE			; TABLE FOR OBJECT EXPLOSION
	.STRL "debris from an explosion"
	.PROP 2,P?SYNONYM
	W?KREBF
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?110
	.BYTE	0
	.ENDT

T?VIEWING-EAST::	.TABLE			; TABLE FOR OBJECT VIEWING-EAST
	.STRL "East Viewing Room"
	.PROP 1,P?SOUTH
	.BYTE BANK-ENTRANCE
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?98
	.PROP 4,P?GLOBAL
	.BYTE SEWL
	.BYTE SWWL
	.BYTE SNWL
	.BYTE SSWL
	.BYTE	0
	.ENDT

T?BLUE-ICING::	.TABLE			; TABLE FOR OBJECT BLUE-ICING
	.STRL "cake frosted with blue letters"
	.PROP 8,P?SYNONYM
	W?CAKE
	W?ICING
	W?CAKES
	W?LETTER
	.PROP 2,P?ADJECTIVE
	.BYTE A?BLUE
	.BYTE A?FROSTED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CAKE-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	4
	.BYTE	0
	.ENDT

T?STREAM::	.TABLE			; TABLE FOR OBJECT STREAM
	.STRL "stream"
	.PROP 2,P?SYNONYM
	W?STREAM
	.PROP 2,P?ADJECTIVE
	.BYTE A?FLOWING
	.BYTE A?SMALL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	STREAM-FCN
	.BYTE	0
	.ENDT

T?CHASM::	.TABLE			; TABLE FOR OBJECT CHASM
	.STRL "chasm"
	.PROP 4,P?SYNONYM
	W?CHASM
	W?RAVINE
	.PROP 1,P?ADJECTIVE
	.BYTE A?DEEP
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CHASM-FCN
	.BYTE	0
	.ENDT

T?IN-CAGE::	.TABLE			; TABLE FOR OBJECT IN-CAGE
	.STRL "Cage"
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	IN-CAGE-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?86
	.BYTE	0
	.ENDT

T?TEAPOT::	.TABLE			; TABLE FOR OBJECT TEAPOT
	.STRL "china teapot"
	.PROP 4,P?SYNONYM
	W?TEAPOT
	W?POT
	.PROP 2,P?ADJECTIVE
	.BYTE A?CHINA
	.BYTE A?TEA
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TEAPOT-F
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	4
	.BYTE	0
	.ENDT

T?KEYHOLE-2::	.TABLE			; TABLE FOR OBJECT KEYHOLE-2
	.STRL "keyhole"
	.PROP 4,P?SYNONYM
	W?KEYHOLE
	W?HOLE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PKH-FCN
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	2
	.BYTE	0
	.ENDT

T?LID-2::	.TABLE			; TABLE FOR OBJECT LID-2
	.STRL "metal lid"
	.PROP 2,P?SYNONYM
	W?LID
	.PROP 1,P?ADJECTIVE
	.BYTE A?METAL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PLID-FCN
	.BYTE	0
	.ENDT

T?ROSE::	.TABLE			; TABLE FOR OBJECT ROSE
	.STRL "perfect rose"
	.PROP 2,P?SYNONYM
	W?ROSE
	.PROP 3,P?ADJECTIVE
	.BYTE A?BEAUTIFUL
	.BYTE A?RED
	.BYTE A?PERFECT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	ROSE-F
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	1
	.BYTE	0
	.ENDT

T?ICE::	.TABLE			; TABLE FOR OBJECT ICE
	.STRL "glacier"
	.PROP 6,P?SYNONYM
	W?ICE
	W?MASS
	W?GLACIER
	.PROP 2,P?ADJECTIVE
	.BYTE A?COLD
	.BYTE A?ICY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GLACIER-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?118
	.BYTE	0
	.ENDT

T?LID-1::	.TABLE			; TABLE FOR OBJECT LID-1
	.STRL "metal lid"
	.PROP 2,P?SYNONYM
	W?LID
	.PROP 1,P?ADJECTIVE
	.BYTE A?METAL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PLID-FCN
	.BYTE	0
	.ENDT

T?VAIR-2::	.TABLE			; TABLE FOR OBJECT VAIR-2
	.STRL "Volcano Near Small Ledge"
	.PROP 1,P?WEST
	.BYTE LEDGE-1
	.PROP 1,P?LAND
	.BYTE LEDGE-1
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?74
	.BYTE	0
	.ENDT

T?ZORKMID::	.TABLE			; TABLE FOR OBJECT ZORKMID
	.STRL "zorkmid"
	.PROP 2,P?SYNONYM
	W?ZORKMID
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	ZORKMID-FUNCTION
	.BYTE	0
	.ENDT

T?DEPOSIT-BOX::	.TABLE			; TABLE FOR OBJECT DEPOSIT-BOX
	.STRL "safety deposit box"
	.PROP 2,P?SYNONYM
	W?BOX
	.PROP 2,P?ADJECTIVE
	.BYTE A?DEPOSIT
	.BYTE A?SAFETY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	BOX-F
	.BYTE	0
	.ENDT

T?CRYPT::	.TABLE			; TABLE FOR OBJECT CRYPT
	.STRL "marble crypt"
	.PROP 6,P?SYNONYM
	W?TOMB
	W?CRYPT
	W?GRAVE
	.PROP 1,P?ADJECTIVE
	.BYTE A?MARBLE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CRYPT-OBJECT
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?54
	.BYTE	0
	.ENDT

T?VOLCANO-VIEW::	.TABLE			; TABLE FOR OBJECT VOLCANO-VIEW
	.STRL "Volcano View"
	.PROP 1,P?EAST
	.BYTE LAVA-TUBE
	.PROP 2,P?DOWN			; STRING PROPERTY
	STR?81
	.PROP 2,P?CROSS			; STRING PROPERTY
	STR?82
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?80
	.BYTE	0
	.ENDT

T?HEADS::	.TABLE			; TABLE FOR OBJECT HEADS
	.STRL "set of poled heads"
	.PROP 8,P?SYNONYM
	W?HEADS
	W?HEAD
	W?POLE
	W?POLES
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	HEAD-FCN
	.BYTE	0
	.ENDT

T?WELL-BOTTOM::	.TABLE			; TABLE FOR OBJECT WELL-BOTTOM
	.STRL "Circular Room"
	.PROP 1,P?WEST
	.BYTE PEARL-ROOM
	.PROP 2,P?UP			; STRING PROPERTY
	STR?90
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?89
	.PROP 1,P?GLOBAL
	.BYTE WELL
	.BYTE	0
	.ENDT

T?HEDGES::	.TABLE			; TABLE FOR OBJECT HEDGES
	.STRL "hedge"
	.PROP 4,P?SYNONYM
	W?HEDGE
	W?HEDGES
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	HEDGES-F
	.BYTE	0
	.ENDT

T?DIAMOND-2::	.TABLE			; TABLE FOR OBJECT DIAMOND-2
	.STRL "Oddly-angled Room"
	.PROP 1,P?SOUTH
	.BYTE DIAMOND-5
	.PROP 1,P?SE
	.BYTE DIAMOND-6
	.PROP 1,P?SW
	.BYTE DIAMOND-4
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DIAMOND-MOTION
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?50
	.PROP 1,P?GLOBAL
	.BYTE DWINDOW
	.BYTE	0
	.ENDT

T?POSTS-ROOM::	.TABLE			; TABLE FOR OBJECT POSTS-ROOM
	.STRL "Posts Room"
	.PROP 1,P?EAST
	.BYTE POOL-ROOM
	.PROP 2,P?WEST			; STRING PROPERTY
	STR?94
	.PROP 2,P?NW			; STRING PROPERTY
	STR?94
	.PROP 2,P?DOWN			; STRING PROPERTY
	STR?94
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	POSTS-ROOM-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?93
	.PROP 1,P?GLOBAL
	.BYTE CHASM
	.BYTE	0
	.ENDT

T?SAILOR::	.TABLE			; TABLE FOR OBJECT SAILOR
	.STRL "sailor"
	.PROP 6,P?SYNONYM
	W?SAILOR
	W?FOOTPAD
	W?AVIATOR
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SAILOR-FCN
	.BYTE	0
	.ENDT

T?RAVINE-LEDGE::	.TABLE			; TABLE FOR OBJECT RAVINE-LEDGE
	.STRL "Ledge in Ravine"
	.PROP 1,P?WEST
	.BYTE LEDGE-TUNNEL
	.PROP 1,P?SOUTH
	.BYTE DEEP-FORD
	.PROP 1,P?UP
	.BYTE TINY-ROOM
	.PROP 1,P?DOWN
	.BYTE DEEP-FORD
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?23
	.PROP 1,P?GLOBAL
	.BYTE CHASM
	.BYTE	0
	.ENDT

T?CRYPT-ROOM::	.TABLE			; TABLE FOR OBJECT CRYPT-ROOM
	.STRL "Crypt"
	.PROP 5,P?NORTH			; DOOR EXIT
	.BYTE CRYPT-ANTEROOM				; ROOM NAME
	.BYTE CRYPT-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 4,P?SOUTH			; CONDITIONAL EXIT
	.BYTE ZORK3				; ROOM NAME
	.BYTE DIM-DOOR-FLAG				; FLAG NAME
	0			; NO STRING
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CRYPT-ROOM-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.PROP 2,P?GLOBAL
	.BYTE CRYPT-DOOR
	.BYTE DIM-DOOR
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	2
	.BYTE	0
	.ENDT

T?RECEPTACLE::	.TABLE			; TABLE FOR OBJECT RECEPTACLE
	.STRL "receptacle"
	.PROP 2,P?SYNONYM
	W?RECEPTACLE
	.PROP 1,P?ADJECTIVE
	.BYTE A?METAL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	BCONTENTS
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	6
	.BYTE	0
	.ENDT

T?GOLD-KEY::	.TABLE			; TABLE FOR OBJECT GOLD-KEY
	.STRL "delicate gold key"
	.PROP 4,P?SYNONYM
	W?KEY
	W?TREASURE
	.PROP 2,P?ADJECTIVE
	.BYTE A?DELICATE
	.BYTE A?GOLD
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	UNICORN-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	3
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	15
	.BYTE	0
	.ENDT

T?KENNEL::	.TABLE			; TABLE FOR OBJECT KENNEL
	.STRL "Kennel"
	.PROP 4,P?NE			; CONDITIONAL EXIT
	.BYTE MENHIR-ROOM				; ROOM NAME
	.BYTE MENHIR-POSITION				; FLAG NAME
	STR?44			; STRING
	.PROP 4,P?OUT			; CONDITIONAL EXIT
	.BYTE MENHIR-ROOM				; ROOM NAME
	.BYTE MENHIR-POSITION				; FLAG NAME
	STR?44			; STRING
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?45
	.PROP 1,P?GLOBAL
	.BYTE MENHIR
	.BYTE	0
	.ENDT

T?WIZARD-CASE::	.TABLE			; TABLE FOR OBJECT WIZARD-CASE
	.STRL "Wizard's trophy cabinet"
	.PROP 4,P?SYNONYM
	W?CASE
	W?CABINET
	.PROP 2,P?ADJECTIVE
	.BYTE A?TROPHY
	.BYTE A?WIZARD
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WIZARD-CASE-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?62
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	1000
	.BYTE	0
	.ENDT

T?KEYHOLE-1::	.TABLE			; TABLE FOR OBJECT KEYHOLE-1
	.STRL "keyhole"
	.PROP 4,P?SYNONYM
	W?KEYHOLE
	W?HOLE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PKH-FCN
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	2
	.BYTE	0
	.ENDT

T?CANDY::	.TABLE			; TABLE FOR OBJECT CANDY
	.STRL "package of candy"
	.PROP 8,P?SYNONYM
	W?PACKAGE
	W?CANDY
	W?TREASURE
	W?GRASSHOPPERS
	.PROP 2,P?ADJECTIVE
	.BYTE A?CANDIED
	.BYTE A?RARE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CANDY-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	8
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?146
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	15
	.BYTE	0
	.ENDT

T?SAFE::	.TABLE			; TABLE FOR OBJECT SAFE
	.STRL "box"
	.PROP 4,P?SYNONYM
	W?SAFE
	W?BOX
	.PROP 2,P?ADJECTIVE
	.BYTE A?STEEL
	.BYTE A?RUSTY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SAFE-FCN
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	15
	.BYTE	0
	.ENDT

T?GNOME-OF-ZURICH::	.TABLE			; TABLE FOR OBJECT GNOME-OF-ZURICH
	.STRL "Gnome of Zurich"
	.PROP 4,P?SYNONYM
	W?GNOME
	W?ZURICH
	.PROP 1,P?ADJECTIVE
	.BYTE A?ZURICH
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	ZGNOME-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?156
	.BYTE	0
	.ENDT

T?PEARL::	.TABLE			; TABLE FOR OBJECT PEARL
	.STRL "pearl necklace"
	.PROP 6,P?SYNONYM
	W?NECKLACE
	W?PEARLS
	W?TREASURE
	.PROP 1,P?ADJECTIVE
	.BYTE A?PEARL
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	10
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?126
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	15
	.BYTE	0
	.ENDT

T?COMPASS::	.TABLE			; TABLE FOR OBJECT COMPASS
	.STRL "compass"
	.PROP 2,P?SYNONYM
	W?COMPASS
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	COMPASS-F
	.BYTE	0
	.ENDT

T?LIBRARY::	.TABLE			; TABLE FOR OBJECT LIBRARY
	.STRL "Library"
	.PROP 1,P?NORTH
	.BYTE LEDGE-1
	.PROP 1,P?OUT
	.BYTE LEDGE-1
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?79
	.BYTE	0
	.ENDT

T?PDOOR::	.TABLE			; TABLE FOR OBJECT PDOOR
	.STRL "door made of oak"
	.PROP 2,P?SYNONYM
	W?DOOR
	.PROP 2,P?ADJECTIVE
	.BYTE A?WOODEN
	.BYTE A?OAK
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PDOOR-FCN
	.BYTE	0
	.ENDT

T?BALLOON-LABEL::	.TABLE			; TABLE FOR OBJECT BALLOON-LABEL
	.STRL "blue label"
	.PROP 2,P?SYNONYM
	W?LABEL
	.PROP 1,P?ADJECTIVE
	.BYTE A?BLUE
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	1
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?107
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?108
	.BYTE	0
	.ENDT

T?WISH::	.TABLE			; TABLE FOR OBJECT WISH
	.STRL "wish"
	.PROP 4,P?SYNONYM
	W?WISH
	W?BLESS
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WISH-FCN
	.BYTE	0
	.ENDT

T?VIOLIN::	.TABLE			; TABLE FOR OBJECT VIOLIN
	.STRL "fancy violin"
	.PROP 6,P?SYNONYM
	W?STRADIVARIUS
	W?VIOLIN
	W?TREASURE
	.PROP 1,P?ADJECTIVE
	.BYTE A?FANCY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	VIOLIN-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	10
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?117
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	20
	.BYTE	0
	.ENDT

T?FRESCO-ROOM::	.TABLE			; TABLE FOR OBJECT FRESCO-ROOM
	.STRL "Fresco Room"
	.PROP 1,P?EAST
	.BYTE DRAGON-ROOM
	.PROP 1,P?WEST
	.BYTE BANK-ENTRANCE
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?35
	.BYTE	0
	.ENDT

T?DIAMOND-3::	.TABLE			; TABLE FOR OBJECT DIAMOND-3
	.STRL "Oddly-angled Room"
	.PROP 1,P?SW
	.BYTE DIAMOND-5
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DIAMOND-MOTION
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?50
	.PROP 1,P?GLOBAL
	.BYTE DWINDOW
	.BYTE	0
	.ENDT

T?LEDGE-2::	.TABLE			; TABLE FOR OBJECT LEDGE-2
	.STRL "Wide Ledge"
	.PROP 4,P?WEST			; CONDITIONAL EXIT
	.BYTE VOLCANO-BOTTOM				; ROOM NAME
	.BYTE GNOME-DOOR-FLAG				; FLAG NAME
	0			; NO STRING
	.PROP 1,P?SOUTH
	.BYTE SAFE-ROOM
	.PROP 2,P?DOWN			; STRING PROPERTY
	STR?37
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	LEDGE-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.BYTE	0
	.ENDT

T?CAROUSEL-ROOM::	.TABLE			; TABLE FOR OBJECT CAROUSEL-ROOM
	.STRL "Carousel Room"
	.PROP 1,P?NORTH
	.BYTE MARBLE-HALL
	.PROP 1,P?EAST
	.BYTE TOPIARY-ROOM
	.PROP 1,P?WEST
	.BYTE ROOM-8
	.PROP 1,P?SOUTH
	.BYTE MENHIR-ROOM
	.PROP 1,P?NE
	.BYTE STREAM-PATH
	.PROP 1,P?NW
	.BYTE COOL-ROOM
	.PROP 1,P?SE
	.BYTE RIDDLE-ROOM
	.PROP 1,P?SW
	.BYTE COBWEBBY-CORRIDOR
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CAROUSEL-ROOM-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.BYTE	0
	.ENDT

T?SEWL::	.TABLE			; TABLE FOR OBJECT SEWL
	.STRL "east wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 2,P?ADJECTIVE
	.BYTE A?EAST
	.BYTE A?EASTERN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SCOLWALL
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	0
	.BYTE	0
	.ENDT

T?CROWN::	.TABLE			; TABLE FOR OBJECT CROWN
	.STRL "gaudy crown"
	.PROP 4,P?SYNONYM
	W?CROWN
	W?TREASURE
	.PROP 1,P?ADJECTIVE
	.BYTE A?GAUDY
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	10
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?115
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?114
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	20
	.BYTE	0
	.ENDT

T?RED-ICING::	.TABLE			; TABLE FOR OBJECT RED-ICING
	.STRL "cake frosted with red letters"
	.PROP 8,P?SYNONYM
	W?CAKE
	W?CAKES
	W?ICING
	W?LETTER
	.PROP 2,P?ADJECTIVE
	.BYTE A?RED
	.BYTE A?FROSTED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CAKE-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	4
	.BYTE	0
	.ENDT

T?NORTH-WALL::	.TABLE			; TABLE FOR OBJECT NORTH-WALL
	.STRL "north wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 2,P?ADJECTIVE
	.BYTE A?NORTH
	.BYTE A?NORTHE
	.BYTE	0
	.ENDT

T?LAMP::	.TABLE			; TABLE FOR OBJECT LAMP
	.STRL "lamp"
	.PROP 6,P?SYNONYM
	W?LAMP
	W?LANTERN
	W?LIGHT
	.PROP 1,P?ADJECTIVE
	.BYTE A?BRASS
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	LANTERN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	15
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?124
	.BYTE	0
	.ENDT

T?PRINCESS::	.TABLE			; TABLE FOR OBJECT PRINCESS
	.STRL "beautiful princess"
	.PROP 6,P?SYNONYM
	W?PRINCESS
	W?WOMAN
	W?LADY
	.PROP 2,P?ADJECTIVE
	.BYTE A?BEAUTIFUL
	.BYTE A?YOUNG
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PRINCESS-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?34
	.BYTE	0
	.ENDT

T?DIM-DOOR::	.TABLE			; TABLE FOR OBJECT DIM-DOOR
	.STRL "secret door"
	.PROP 4,P?SYNONYM
	W?DOOR
	W?LETTER
	.PROP 4,P?ADJECTIVE
	.BYTE A?F
	.BYTE A?DIMLY
	.BYTE A?SOUTH
	.BYTE A?SECRET
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DIM-DOOR-FCN
	.BYTE	0
	.ENDT

T?TELLER-WEST::	.TABLE			; TABLE FOR OBJECT TELLER-WEST
	.STRL "West Teller's Room"
	.PROP 1,P?NORTH
	.BYTE VIEWING-WEST
	.PROP 1,P?WEST
	.BYTE DEPOSITORY
	.PROP 1,P?SOUTH
	.BYTE BANK-ENTRANCE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TELLER-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.BYTE	0
	.ENDT

T?BLESSINGS::	.TABLE			; TABLE FOR OBJECT BLESSINGS
	.STRL "blessings"
	.PROP 4,P?SYNONYM
	W?BLESSINGS
	W?GRACES
	.BYTE	0
	.ENDT

T?GLOBAL-UNICORN::	.TABLE			; TABLE FOR OBJECT GLOBAL-UNICORN
	.STRL "unicorn"
	.PROP 2,P?SYNONYM
	W?UNICORN
	.PROP 2,P?ADJECTIVE
	.BYTE A?BEAUTIFUL
	.BYTE A?WHITE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GLOBAL-UNICORN-FCN
	.BYTE	0
	.ENDT

T?ALICE-TABLE::	.TABLE			; TABLE FOR OBJECT ALICE-TABLE
	.STRL "large oblong table"
	.PROP 2,P?SYNONYM
	W?TABLE
	.PROP 2,P?ADJECTIVE
	.BYTE A?LARGE
	.BYTE A?OBLONG
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	50
	.BYTE	0
	.ENDT

T?EAST-WALL::	.TABLE			; TABLE FOR OBJECT EAST-WALL
	.STRL "east wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 2,P?ADJECTIVE
	.BYTE A?EAST
	.BYTE A?EASTERN
	.BYTE	0
	.ENDT

T?FORMAL-GARDEN::	.TABLE			; TABLE FOR OBJECT FORMAL-GARDEN
	.STRL "Formal Garden"
	.PROP 1,P?NORTH
	.BYTE GARDEN-NORTH
	.PROP 1,P?WEST
	.BYTE STREAM-PATH
	.PROP 1,P?SOUTH
	.BYTE TOPIARY-ROOM
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GARDEN-ROOM-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?14
	.PROP 2,P?GLOBAL
	.BYTE GLOBAL-UNICORN
	.BYTE MOSS
	.BYTE	0
	.ENDT

T?DARK-TUNNEL::	.TABLE			; TABLE FOR OBJECT DARK-TUNNEL
	.STRL "Dark Tunnel"
	.PROP 1,P?NE
	.BYTE SHALLOW-FORD
	.PROP 1,P?SE
	.BYTE GARDEN-NORTH
	.PROP 1,P?SW
	.BYTE STREAM-PATH
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?10
	.BYTE	0
	.ENDT

T?MENHIR-ROOM::	.TABLE			; TABLE FOR OBJECT MENHIR-ROOM
	.STRL "Menhir Room"
	.PROP 1,P?NORTH
	.BYTE CAROUSEL-ROOM
	.PROP 1,P?SOUTH
	.BYTE STAIRWAY-TOP
	.PROP 4,P?SW			; CONDITIONAL EXIT
	.BYTE KENNEL				; ROOM NAME
	.BYTE MENHIR-POSITION				; FLAG NAME
	STR?44			; STRING
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MENHIR-ROOM-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.PROP 1,P?GLOBAL
	.BYTE MENHIR
	.BYTE	0
	.ENDT

T?CUBE::	.TABLE			; TABLE FOR OBJECT CUBE
	.STRL "large stone cube"
	.PROP 6,P?SYNONYM
	W?VAULT
	W?CUBE
	W?LETTER
	.PROP 2,P?ADJECTIVE
	.BYTE A?STONE
	.BYTE A?LARGE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CUBE-F
	.BYTE	0
	.ENDT

T?GLACIER-ROOM::	.TABLE			; TABLE FOR OBJECT GLACIER-ROOM
	.STRL "Ice Room"
	.PROP 1,P?EAST
	.BYTE COOL-ROOM
	.PROP 4,P?WEST			; CONDITIONAL EXIT
	.BYTE LAVA-ROOM				; ROOM NAME
	.BYTE ICE-MELTED				; FLAG NAME
	STR?40			; STRING
	.PROP 1,P?UP
	.BYTE LAVA-TUBE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GLACIER-ROOM-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.BYTE	0
	.ENDT

T?CERBERUS-ROOM::	.TABLE			; TABLE FOR OBJECT CERBERUS-ROOM
	.STRL "Cerberus Room"
	.PROP 4,P?EAST			; CONDITIONAL EXIT
	.BYTE CRYPT-ANTEROOM				; ROOM NAME
	.BYTE CERBERUS-LEASHED				; FLAG NAME
	STR?52			; STRING
	.PROP 1,P?UP
	.BYTE DIAMOND-5
	.PROP 4,P?IN			; CONDITIONAL EXIT
	.BYTE CRYPT-ANTEROOM				; ROOM NAME
	.BYTE CERBERUS-LEASHED				; FLAG NAME
	STR?52			; STRING
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?51
	.PROP 1,P?GLOBAL
	.BYTE STAIRS
	.PROP 8,P?PSEUDO
	W?TOMB
	TOMB-PSEUDO
	W?CRYPT
	TOMB-PSEUDO
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	10
	.BYTE	0
	.ENDT

T?SLOT::	.TABLE			; TABLE FOR OBJECT SLOT
	.STRL "hole"
	.PROP 4,P?SYNONYM
	W?SLOT
	W?HOLE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SLOT-F
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	10
	.BYTE	0
	.ENDT

T?LUNGS::	.TABLE			; TABLE FOR OBJECT LUNGS
	.STRL "blast of air"
	.PROP 8,P?SYNONYM
	W?LUNGS
	W?AIR
	W?MOUTH
	W?BREATH
	.BYTE	0
	.ENDT

T?WEST-WALL::	.TABLE			; TABLE FOR OBJECT WEST-WALL
	.STRL "west wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 2,P?ADJECTIVE
	.BYTE A?WEST
	.BYTE A?WESTERN
	.BYTE	0
	.ENDT

T?GLOBAL-MENHIR::	.TABLE			; TABLE FOR OBJECT GLOBAL-MENHIR
	.STRL "enormous menhir"
	.PROP 6,P?SYNONYM
	W?MENHIR
	W?ROCK
	W?STONE
	.PROP 3,P?ADJECTIVE
	.BYTE A?HUGE
	.BYTE A?HEAVY
	.BYTE A?ENORMOUS
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GLOBAL-MENHIR-F
	.BYTE	0
	.ENDT

T?BROKEN-LAMP::	.TABLE			; TABLE FOR OBJECT BROKEN-LAMP
	.STRL "broken brass lantern"
	.PROP 6,P?SYNONYM
	W?LAMP
	W?LANTERN
	W?LIGHT
	.PROP 2,P?ADJECTIVE
	.BYTE A?BROKEN
	.BYTE A?BRASS
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	15
	.BYTE	0
	.ENDT

T?NARROW-TUNNEL::	.TABLE			; TABLE FOR OBJECT NARROW-TUNNEL
	.STRL "Narrow Tunnel"
	.PROP 1,P?NORTH
	.BYTE INSIDE-BARROW
	.PROP 1,P?SOUTH
	.BYTE FOOT-BRIDGE
	.PROP 2,P?DOWN			; STRING PROPERTY
	STR?4
	.PROP 1,P?CROSS
	.BYTE FOOT-BRIDGE
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?3
	.PROP 4,P?GLOBAL
	.BYTE BRIDGE
	.BYTE CHASM
	.BYTE STREAM
	.BYTE MOSS
	.BYTE	0
	.ENDT

T?BALLOON::	.TABLE			; TABLE FOR OBJECT BALLOON
	.STRL "basket"
	.PROP 4,P?SYNONYM
	W?BALLOON
	W?BASKET
	.PROP 1,P?ADJECTIVE
	.BYTE A?WICKER
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	BALLOON-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	70
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	100
	.PROP 2,P?DESCFCN			; ATOM (CONSTANT) PROPERTY

	BALLOON-FCN
	.PROP 2,P?VTYPE			; INTEGER/CONSTANT PROPERTY

	0
	.BYTE	0
	.ENDT

T?BRAIDED-WIRE::	.TABLE			; TABLE FOR OBJECT BRAIDED-WIRE
	.STRL "braided wire"
	.PROP 4,P?SYNONYM
	W?ROPE
	W?WIRE
	.PROP 1,P?ADJECTIVE
	.BYTE A?BRAIDED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WIRE-FCN
	.BYTE	0
	.ENDT

T?LEDGE-TUNNEL::	.TABLE			; TABLE FOR OBJECT LEDGE-TUNNEL
	.STRL "End of Ledge"
	.PROP 1,P?NORTH
	.BYTE DRAGON-ROOM
	.PROP 1,P?EAST
	.BYTE RAVINE-LEDGE
	.PROP 2,P?DOWN			; STRING PROPERTY
	STR?25
	.PROP 1,P?IN
	.BYTE DRAGON-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?24
	.BYTE	0
	.ENDT

T?COOL-ROOM::	.TABLE			; TABLE FOR OBJECT COOL-ROOM
	.STRL "Cool Room"
	.PROP 1,P?NORTH
	.BYTE STONE-BRIDGE
	.PROP 1,P?WEST
	.BYTE GLACIER-ROOM
	.PROP 1,P?SE
	.BYTE CAROUSEL-ROOM
	.PROP 1,P?CROSS
	.BYTE STONE-BRIDGE
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?38
	.PROP 1,P?GLOBAL
	.BYTE BRIDGE
	.BYTE	0
	.ENDT

T?PWINDOW::	.TABLE			; TABLE FOR OBJECT PWINDOW
	.STRL "barred window"
	.PROP 2,P?SYNONYM
	W?WINDOW
	.PROP 1,P?ADJECTIVE
	.BYTE A?BARRED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PWINDOW-FCN
	.BYTE	0
	.ENDT

T?GRUE::	.TABLE			; TABLE FOR OBJECT GRUE
	.STRL "lurking grue"
	.PROP 2,P?SYNONYM
	W?GRUE
	.PROP 4,P?ADJECTIVE
	.BYTE A?LURKING
	.BYTE A?SINISTER
	.BYTE A?HUNGRY
	.BYTE A?SILENT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GRUE-FUNCTION
	.BYTE	0
	.ENDT

T?DEGREE::	.TABLE			; TABLE FOR OBJECT DEGREE
	.STRL "degree"
	.PROP 4,P?SYNONYM
	W?DEGREE
	W?DIPLOMA
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TROPHY-PSEUDO
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?59
	.BYTE	0
	.ENDT

T?VOLCANO-BOTTOM::	.TABLE			; TABLE FOR OBJECT VOLCANO-BOTTOM
	.STRL "Volcano Bottom"
	.PROP 1,P?NORTH
	.BYTE LAVA-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?72
	.BYTE	0
	.ENDT

T?VAIR-4::	.TABLE			; TABLE FOR OBJECT VAIR-4
	.STRL "Volcano Near Wide Ledge"
	.PROP 1,P?WEST
	.BYTE LEDGE-2
	.PROP 1,P?LAND
	.BYTE LEDGE-2
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?76
	.BYTE	0
	.ENDT

T?GAZEBO-TABLE::	.TABLE			; TABLE FOR OBJECT GAZEBO-TABLE
	.STRL "table"
	.PROP 2,P?SYNONYM
	W?TABLE
	.PROP 1,P?ADJECTIVE
	.BYTE A?TEA
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	100
	.BYTE	0
	.ENDT

T?BILLS::	.TABLE			; TABLE FOR OBJECT BILLS
	.STRL "stack of zorkmid bills"
	.PROP 8,P?SYNONYM
	W?BILLS
	W?STACK
	W?MONEY
	W?TREASURE
	.PROP 3,P?ADJECTIVE
	.BYTE A?NEAT
	.BYTE A?MANY
	.BYTE A?ZORKMID
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	BILLS-OBJECT
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	10
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?149
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?150
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	25
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?151
	.BYTE	0
	.ENDT

T?STAIRS::	.TABLE			; TABLE FOR OBJECT STAIRS
	.STRL "stairs"
	.PROP 8,P?SYNONYM
	W?STAIRS
	W?STEPS
	W?STAIRCASE
	W?STAIRWAY
	.PROP 5,P?ADJECTIVE
	.BYTE A?STONE
	.BYTE A?DARK
	.BYTE A?MARBLE
	.BYTE A?FORBIDDING
	.BYTE A?STEEP
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	STAIRS-F
	.BYTE	0
	.ENDT

T?NEWSPAPER::	.TABLE			; TABLE FOR OBJECT NEWSPAPER
	.STRL "newspaper"
	.PROP 4,P?SYNONYM
	W?PAPER
	W?NEWSPAPER
	.PROP 2,P?ADJECTIVE
	.BYTE A?NEWS
	.BYTE A?NEWSPAPER
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?158
	.BYTE	0
	.ENDT

T?SAFE-ROOM::	.TABLE			; TABLE FOR OBJECT SAFE-ROOM
	.STRL "Dusty Room"
	.PROP 1,P?NORTH
	.BYTE LEDGE-2
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SAFE-ROOM-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.BYTE	0
	.ENDT

T?GREAT-CAVERN::	.TABLE			; TABLE FOR OBJECT GREAT-CAVERN
	.STRL "Great Cavern"
	.PROP 1,P?NE
	.BYTE FOOT-BRIDGE
	.PROP 1,P?SW
	.BYTE SHALLOW-FORD
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?8
	.PROP 1,P?GLOBAL
	.BYTE MOSS
	.PROP 8,P?PSEUDO
	W?STALAGMITE
	STALA-PSEUDO
	W?STALACTITE
	STALA-PSEUDO
	.BYTE	0
	.ENDT

T?LAVA-TUBE::	.TABLE			; TABLE FOR OBJECT LAVA-TUBE
	.STRL "Lava Tube"
	.PROP 1,P?SOUTH
	.BYTE COBWEBBY-CORRIDOR
	.PROP 1,P?UP
	.BYTE VOLCANO-VIEW
	.PROP 1,P?DOWN
	.BYTE GLACIER-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?41
	.PROP 4,P?PSEUDO
	W?CRACK
	LT-CRACK-PSEUDO
	.BYTE	0
	.ENDT

T?DIAMOND-1::	.TABLE			; TABLE FOR OBJECT DIAMOND-1
	.STRL "Oddly-angled Room"
	.PROP 1,P?SE
	.BYTE DIAMOND-5
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DIAMOND-MOTION
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?50
	.PROP 1,P?GLOBAL
	.BYTE DWINDOW
	.BYTE	0
	.ENDT

T?WATER::	.TABLE			; TABLE FOR OBJECT WATER
	.STRL "quantity of water"
	.PROP 8,P?SYNONYM
	W?WATER
	W?QUANTITY
	W?LIQUID
	W?H2O
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WATER-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	4
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?159
	.BYTE	0
	.ENDT

T?MAGNET-ROOM::	.TABLE			; TABLE FOR OBJECT MAGNET-ROOM
	.STRL "Low Room"
	.PROP 3,P?NORTH
	.WORD MAGNET-ROOM-EXIT
	.BYTE 0
	.PROP 3,P?EAST
	.WORD MAGNET-ROOM-EXIT
	.BYTE 0
	.PROP 3,P?WEST
	.WORD MAGNET-ROOM-EXIT
	.BYTE 0
	.PROP 3,P?SOUTH
	.WORD MAGNET-ROOM-EXIT
	.BYTE 0
	.PROP 3,P?NE
	.WORD MAGNET-ROOM-EXIT
	.BYTE 0
	.PROP 3,P?NW
	.WORD MAGNET-ROOM-EXIT
	.BYTE 0
	.PROP 3,P?SE
	.WORD MAGNET-ROOM-EXIT
	.BYTE 0
	.PROP 3,P?SW
	.WORD MAGNET-ROOM-EXIT
	.BYTE 0
	.PROP 3,P?OUT
	.WORD MAGNET-ROOM-EXIT
	.BYTE 0
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MAGNET-ROOM-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.BYTE	0
	.ENDT

T?GLOBAL-PALANTIR::	.TABLE			; TABLE FOR OBJECT GLOBAL-PALANTIR
	.STRL "sphere"
	.PROP 2,P?SYNONYM
	W?SPHERE
	.PROP 4,P?ADJECTIVE
	.BYTE A?RED
	.BYTE A?BLUE
	.BYTE A?WHITE
	.BYTE A?CRYSTAL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GLOBAL-PALANTIRS
	.BYTE	0
	.ENDT

T?GROUND::	.TABLE			; TABLE FOR OBJECT GROUND
	.STRL "ground"
	.PROP 8,P?SYNONYM
	W?GROUND
	W?SAND
	W?DIRT
	W?FLOOR
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GROUND-FUNCTION
	.BYTE	0
	.ENDT

T?TEA-ROOM::	.TABLE			; TABLE FOR OBJECT TEA-ROOM
	.STRL "Tea Room"
	.PROP 2,P?EAST			; STRING PROPERTY
	STR?92
	.PROP 1,P?WEST
	.BYTE WELL-TOP
	.PROP 1,P?NW
	.BYTE MAGNET-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?91
	.PROP 4,P?PSEUDO
	W?HOLE
	ALICE-HOLE
	.BYTE	0
	.ENDT

T?TOP-ETCHINGS::	.TABLE			; TABLE FOR OBJECT TOP-ETCHINGS
	.STRL "wall with etchings"
	.PROP 4,P?SYNONYM
	W?ETCHINGS
	W?WALL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TOP-ETCHINGS-F
	.BYTE	0
	.ENDT

T?DRAGON::	.TABLE			; TABLE FOR OBJECT DRAGON
	.STRL "huge red dragon"
	.PROP 6,P?SYNONYM
	W?DRAGON
	W?SMAUG
	W?WORM
	.PROP 2,P?ADJECTIVE
	.BYTE A?RED
	.BYTE A?HUGE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DRAGON-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?31
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?32
	.BYTE	0
	.ENDT

T?NOT-HERE-OBJECT::	.TABLE			; TABLE FOR OBJECT NOT-HERE-OBJECT
	.STRL "such thing"
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	NOT-HERE-OBJECT-F
	.BYTE	0
	.ENDT

T?CRYPT-ANTEROOM::	.TABLE			; TABLE FOR OBJECT CRYPT-ANTEROOM
	.STRL "Crypt Anteroom"
	.PROP 1,P?WEST
	.BYTE CERBERUS-ROOM
	.PROP 5,P?SOUTH			; DOOR EXIT
	.BYTE CRYPT-ROOM				; ROOM NAME
	.BYTE CRYPT-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 5,P?IN			; DOOR EXIT
	.BYTE CRYPT-ROOM				; ROOM NAME
	.BYTE CRYPT-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CRYPT-ANTEROOM-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.PROP 1,P?GLOBAL
	.BYTE CRYPT-DOOR
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	3
	.BYTE	0
	.ENDT

T?POSTS::	.TABLE			; TABLE FOR OBJECT POSTS
	.STRL "group of wooden posts"
	.PROP 4,P?SYNONYM
	W?POSTS
	W?POST
	.PROP 1,P?ADJECTIVE
	.BYTE A?WOODEN
	.BYTE	0
	.ENDT

T?INTNUM::	.TABLE			; TABLE FOR OBJECT INTNUM
	.STRL "number"
	.PROP 2,P?SYNONYM
	W?INTNUM
	.BYTE	0
	.ENDT

T?STAND-4::	.TABLE			; TABLE FOR OBJECT STAND-4
	.STRL "black obsidian stand"
	.PROP 4,P?SYNONYM
	W?STAND
	W?STANDS
	.PROP 4,P?ADJECTIVE
	.BYTE A?OBSIDIAN
	.BYTE A?BLACK
	.BYTE A?CRYSTAL
	.BYTE A?STRANGE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	STAND-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	5
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	10
	.BYTE	0
	.ENDT

T?PURPLE-BOOK::	.TABLE			; TABLE FOR OBJECT PURPLE-BOOK
	.STRL "purple book"
	.PROP 4,P?SYNONYM
	W?BOOK
	W?BOOKS
	.PROP 1,P?ADJECTIVE
	.BYTE A?PURPLE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PURPLE-BOOK-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	10
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?139
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	2
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?140
	.BYTE	0
	.ENDT

T?SSWL::	.TABLE			; TABLE FOR OBJECT SSWL
	.STRL "south wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 2,P?ADJECTIVE
	.BYTE A?SOUTH
	.BYTE A?SOUTHE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SCOLWALL
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	0
	.BYTE	0
	.ENDT

T?DEPOSITORY::	.TABLE			; TABLE FOR OBJECT DEPOSITORY
	.STRL "Safety Depository"
	.PROP 2,P?NORTH			; STRING PROPERTY
	STR?102
	.PROP 3,P?EAST
	.WORD BKLEAVEE
	.BYTE 0
	.PROP 3,P?WEST
	.WORD BKLEAVEW
	.BYTE 0
	.PROP 1,P?SOUTH
	.BYTE OFFICE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DEPOSITORY-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?101
	.PROP 1,P?GLOBAL
	.BYTE SNWL
	.BYTE	0
	.ENDT

T?DRAGON-LAIR::	.TABLE			; TABLE FOR OBJECT DRAGON-LAIR
	.STRL "Dragon's Lair"
	.PROP 1,P?SOUTH
	.BYTE DRAGON-ROOM
	.PROP 1,P?OUT
	.BYTE DRAGON-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?28
	.BYTE	0
	.ENDT

T?DIAMOND-6::	.TABLE			; TABLE FOR OBJECT DIAMOND-6
	.STRL "Oddly-angled Room"
	.PROP 1,P?WEST
	.BYTE DIAMOND-5
	.PROP 1,P?NW
	.BYTE DIAMOND-2
	.PROP 1,P?SW
	.BYTE DIAMOND-8
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DIAMOND-MOTION
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?50
	.PROP 1,P?GLOBAL
	.BYTE DWINDOW
	.BYTE	0
	.ENDT

T?ARCANA::	.TABLE			; TABLE FOR OBJECT ARCANA
	.STRL "arcane item"
	.PROP 8,P?SYNONYM
	W?ALEMBIC
	W?VELLUM
	W?CANDLES
	W?KNIVES
	.PROP 2,P?ADJECTIVE
	.BYTE A?WAX
	.BYTE A?SMALL
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	ARCANA-PSEUDO
	.BYTE	0
	.ENDT

T?VIEWING-WEST::	.TABLE			; TABLE FOR OBJECT VIEWING-WEST
	.STRL "West Viewing Room"
	.PROP 1,P?SOUTH
	.BYTE BANK-ENTRANCE
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?97
	.PROP 4,P?GLOBAL
	.BYTE SEWL
	.BYTE SWWL
	.BYTE SNWL
	.BYTE SSWL
	.BYTE	0
	.ENDT

T?FOOTPAD::	.TABLE			; TABLE FOR OBJECT FOOTPAD
	.STRL "footpad"
	.PROP 2,P?SYNONYM
	W?FOOTPAD
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	FOOTPAD-F
	.BYTE	0
	.ENDT

T?COBWEBBY-CORRIDOR::	.TABLE			; TABLE FOR OBJECT COBWEBBY-CORRIDOR
	.STRL "Cobwebby Corridor"
	.PROP 1,P?NORTH
	.BYTE LAVA-TUBE
	.PROP 1,P?NE
	.BYTE CAROUSEL-ROOM
	.PROP 1,P?SW
	.BYTE GUARDIAN-ROOM
	.PROP 1,P?UP
	.BYTE LAVA-TUBE
	.PROP 1,P?DOWN
	.BYTE GUARDIAN-ROOM
	.PROP 1,P?IN
	.BYTE LAVA-TUBE
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?42
	.PROP 4,P?PSEUDO
	W?CRACK
	CC-CRACK-PSEUDO
	.BYTE	0
	.ENDT

T?ROOM-8::	.TABLE			; TABLE FOR OBJECT ROOM-8
	.STRL "Room 8"
	.PROP 1,P?EAST
	.BYTE CAROUSEL-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?43
	.BYTE	0
	.ENDT

T?GLOBAL-CERBERUS::	.TABLE			; TABLE FOR OBJECT GLOBAL-CERBERUS
	.STRL "three-headed dog"
	.PROP 8,P?SYNONYM
	W?CERBERUS
	W?DOG
	W?HOUND
	W?MONSTER
	.PROP 4,P?ADJECTIVE
	.BYTE A?HUGE
	.BYTE A?GIANT
	.BYTE A?THREE
	.BYTE A?HEADED
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GLOBAL-CERBERUS-F
	.BYTE	0
	.ENDT

T?PENTAGRAM::	.TABLE			; TABLE FOR OBJECT PENTAGRAM
	.STRL "pentagram"
	.PROP 6,P?SYNONYM
	W?PENTAGRAM
	W?STAR
	W?CIRCLE
	.PROP 3,P?ADJECTIVE
	.BYTE A?GREAT
	.BYTE A?CHALK
	.BYTE A?BLACK
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	PENTAGRAM-FCN
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	200
	.BYTE	0
	.ENDT

T?DEAD-PALANTIR-4::	.TABLE			; TABLE FOR OBJECT DEAD-PALANTIR-4
	.STRL "Room of Black Mist"
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DEAD-PALANTIR
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.BYTE	0
	.ENDT

T?SWWL::	.TABLE			; TABLE FOR OBJECT SWWL
	.STRL "west wall"
	.PROP 2,P?SYNONYM
	W?WALL
	.PROP 2,P?ADJECTIVE
	.BYTE A?WEST
	.BYTE A?WESTERN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SCOLWALL
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	0
	.BYTE	0
	.ENDT

T?STREAM-PATH::	.TABLE			; TABLE FOR OBJECT STREAM-PATH
	.STRL "Path Near Stream"
	.PROP 1,P?EAST
	.BYTE FORMAL-GARDEN
	.PROP 4,P?WEST			; CONDITIONAL EXIT
	.BYTE MARBLE-HALL				; ROOM NAME
	.BYTE SECRET-DOOR				; FLAG NAME
	0			; NO STRING
	.PROP 1,P?NE
	.BYTE DARK-TUNNEL
	.PROP 1,P?SW
	.BYTE CAROUSEL-ROOM
	.PROP 2,P?DOWN			; STRING PROPERTY
	STR?17
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?16
	.PROP 3,P?GLOBAL
	.BYTE BRIDGE
	.BYTE CHASM
	.BYTE STREAM
	.BYTE	0
	.ENDT

T?FUSE::	.TABLE			; TABLE FOR OBJECT FUSE
	.STRL "black string"
	.PROP 6,P?SYNONYM
	W?FUSE
	W?STRING
	W?COIL
	.PROP 2,P?ADJECTIVE
	.BYTE A?BLACK
	.BYTE A?THIN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	FUSE-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	1
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?147
	.BYTE	0
	.ENDT

T?REPELLENT::	.TABLE			; TABLE FOR OBJECT REPELLENT
	.STRL "Frobozz Magic Grue Repellent"
	.PROP 4,P?SYNONYM
	W?REPELLENT
	W?CAN
	.PROP 2,P?ADJECTIVE
	.BYTE A?GRUE
	.BYTE A?MAGIC
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	REPELLENT-FCN
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?164
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?165
	.BYTE	0
	.ENDT

T?SALTY-WATER::	.TABLE			; TABLE FOR OBJECT SALTY-WATER
	.STRL "quantity of salty water"
	.PROP 8,P?SYNONYM
	W?WATER
	W?QUANTITY
	W?LIQUID
	W?H2O
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WATER-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	4
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?159
	.BYTE	0
	.ENDT

T?DWINDOW::	.TABLE			; TABLE FOR OBJECT DWINDOW
	.STRL "diamond shaped window"
	.PROP 2,P?SYNONYM
	W?WINDOW
	.PROP 2,P?ADJECTIVE
	.BYTE A?GLOWING
	.BYTE A?DIAMOND
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DWINDOW-FCN
	.BYTE	0
	.ENDT

T?MOSS::	.TABLE			; TABLE FOR OBJECT MOSS
	.STRL "mosses"
	.PROP 4,P?SYNONYM
	W?MOSS
	W?MOSSES
	.PROP 2,P?ADJECTIVE
	.BYTE A?GLOWING
	.BYTE A?PHOSPHORESCENT
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	MOSS-FCN
	.BYTE	0
	.ENDT

T?TOPIARY-ROOM::	.TABLE			; TABLE FOR OBJECT TOPIARY-ROOM
	.STRL "Topiary"
	.PROP 1,P?NORTH
	.BYTE FORMAL-GARDEN
	.PROP 1,P?WEST
	.BYTE CAROUSEL-ROOM
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GARDEN-ROOM-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?15
	.PROP 3,P?GLOBAL
	.BYTE GLOBAL-UNICORN
	.BYTE MOSS
	.BYTE ROSE-BUSH
	.BYTE	0
	.ENDT

T?STAND-2::	.TABLE			; TABLE FOR OBJECT STAND-2
	.STRL "sapphire stand"
	.PROP 4,P?SYNONYM
	W?STAND
	W?STANDS
	.PROP 2,P?ADJECTIVE
	.BYTE A?CRYSTAL
	.BYTE A?SAPPHIRE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	STAND-FCN
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	10
	.BYTE	0
	.ENDT

T?BANK-BROCHURE::	.TABLE			; TABLE FOR OBJECT BANK-BROCHURE
	.STRL "bank brochure"
	.PROP 6,P?SYNONYM
	W?BROCHURE
	W?PAPER
	W?PIECE
	.PROP 3,P?ADJECTIVE
	.BYTE A?BANK
	.BYTE A?SMALL
	.BYTE A?WORN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	2
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?154
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?155
	.BYTE	0
	.ENDT

T?TUNNEL::	.TABLE			; TABLE FOR OBJECT TUNNEL
	.STRL "tunnel"
	.PROP 6,P?SYNONYM
	W?PASSAGE
	W?TUNNEL
	W?CRAWLWAY
	.PROP 2,P?ADJECTIVE
	.BYTE A?DARK
	.BYTE A?SMOKY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TUNNEL-OBJECT
	.BYTE	0
	.ENDT

T?GLOBAL-WIZARD-CASE::	.TABLE			; TABLE FOR OBJECT GLOBAL-WIZARD-CASE
	.STRL "Wizard's trophy cabinet"
	.PROP 4,P?SYNONYM
	W?CASE
	W?CABINET
	.PROP 2,P?ADJECTIVE
	.BYTE A?TROPHY
	.BYTE A?WIZARD
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	WIZARD-CASE-FCN
	.BYTE	0
	.ENDT

T?SWORD::	.TABLE			; TABLE FOR OBJECT SWORD
	.STRL "elvish sword"
	.PROP 8,P?SYNONYM
	W?SWORD
	W?ORCRIST
	W?GLAMDRING
	W?BLADE
	.PROP 3,P?ADJECTIVE
	.BYTE A?ELVISH
	.BYTE A?OLD
	.BYTE A?ANTIQUE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	SWORD-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	30
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?162
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?163
	.BYTE	0
	.ENDT

T?DEAD-PALANTIR-1::	.TABLE			; TABLE FOR OBJECT DEAD-PALANTIR-1
	.STRL "Room of Red Mist"
	.PROP 1,P?WEST
	.BYTE DEAD-PALANTIR-2
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DEAD-PALANTIR
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.PROP 1,P?GLOBAL
	.BYTE GLOBAL-PALANTIR
	.BYTE	0
	.ENDT

T?BRICK::	.TABLE			; TABLE FOR OBJECT BRICK
	.STRL "brick"
	.PROP 2,P?SYNONYM
	W?BRICK
	.PROP 2,P?ADJECTIVE
	.BYTE A?SQUARE
	.BYTE A?CLAY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	BRICK-FCN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	9
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?109
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	2
	.BYTE	0
	.ENDT

T?DIAMOND-7::	.TABLE			; TABLE FOR OBJECT DIAMOND-7
	.STRL "Oddly-angled Room"
	.PROP 1,P?NE
	.BYTE DIAMOND-5
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DIAMOND-MOTION
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?50
	.PROP 1,P?GLOBAL
	.BYTE DWINDOW
	.BYTE	0
	.ENDT

T?DEAD-PALANTIR-2::	.TABLE			; TABLE FOR OBJECT DEAD-PALANTIR-2
	.STRL "Room of Blue Mist"
	.PROP 1,P?WEST
	.BYTE DEAD-PALANTIR-3
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DEAD-PALANTIR
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.PROP 1,P?GLOBAL
	.BYTE GLOBAL-PALANTIR
	.BYTE	0
	.ENDT

T?DEAD-PALANTIR-3::	.TABLE			; TABLE FOR OBJECT DEAD-PALANTIR-3
	.STRL "Room of White Mist"
	.PROP 1,P?WEST
	.BYTE DEAD-PALANTIR-4
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DEAD-PALANTIR
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.PROP 1,P?GLOBAL
	.BYTE GLOBAL-PALANTIR
	.BYTE	0
	.ENDT

T?GENIE::	.TABLE			; TABLE FOR OBJECT GENIE
	.STRL "demon"
	.PROP 8,P?SYNONYM
	W?DEVIL
	W?DEMON
	W?GENIE
	W?DJINN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GENIE-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?160
	.BYTE	0
	.ENDT

T?ZORK3::	.TABLE			; TABLE FOR OBJECT ZORK3
	.STRL "Landing"
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	ZORK3-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.BYTE	0
	.ENDT

T?DEEP-FORD::	.TABLE			; TABLE FOR OBJECT DEEP-FORD
	.STRL "Deep Ford"
	.PROP 1,P?NORTH
	.BYTE RAVINE-LEDGE
	.PROP 2,P?EAST			; STRING PROPERTY
	STR?21
	.PROP 2,P?WEST			; STRING PROPERTY
	STR?22
	.PROP 1,P?SOUTH
	.BYTE MARBLE-HALL
	.PROP 1,P?UP
	.BYTE RAVINE-LEDGE
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?20
	.PROP 3,P?GLOBAL
	.BYTE GLOBAL-WATER
	.BYTE CHASM
	.BYTE STREAM
	.BYTE	0
	.ENDT

T?WHITE-BOOK::	.TABLE			; TABLE FOR OBJECT WHITE-BOOK
	.STRL "white book"
	.PROP 6,P?SYNONYM
	W?BOOK
	W?COVER
	W?BOOKS
	.PROP 2,P?ADJECTIVE
	.BYTE A?WHITE
	.BYTE A?GLOSSY
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	RANDOM-BOOK
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	5
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?137
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	2
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?138
	.BYTE	0
	.ENDT

T?AQUARIUM-ROOM::	.TABLE			; TABLE FOR OBJECT AQUARIUM-ROOM
	.STRL "Aquarium Room"
	.PROP 1,P?EAST
	.BYTE WORKBENCH-ROOM
	.PROP 1,P?SOUTH
	.BYTE WIZARDS-QUARTERS
	.PROP 1,P?IN
	.BYTE IN-AQUARIUM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?65
	.BYTE	0
	.ENDT

T?GARDEN-NORTH::	.TABLE			; TABLE FOR OBJECT GARDEN-NORTH
	.STRL "North End of Garden"
	.PROP 1,P?NORTH
	.BYTE DARK-TUNNEL
	.PROP 1,P?SOUTH
	.BYTE FORMAL-GARDEN
	.PROP 1,P?IN
	.BYTE GAZEBO-ROOM
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GARDEN-ROOM-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?12
	.PROP 4,P?GLOBAL
	.BYTE GLOBAL-UNICORN
	.BYTE GAZEBO
	.BYTE MOSS
	.BYTE ROSE-BUSH
	.BYTE	0
	.ENDT

T?GAZEBO::	.TABLE			; TABLE FOR OBJECT GAZEBO
	.STRL "gazebo"
	.PROP 4,P?SYNONYM
	W?GAZEBO
	W?STRUCTURE
	.PROP 1,P?ADJECTIVE
	.BYTE A?WOODEN
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GAZEBO-FCN
	.BYTE	0
	.ENDT

T?WARNING-LABEL::	.TABLE			; TABLE FOR OBJECT WARNING-LABEL
	.STRL "warning label"
	.PROP 2,P?SYNONYM
	W?LABEL
	.PROP 1,P?ADJECTIVE
	.BYTE A?WARNING
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?60
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?61
	.BYTE	0
	.ENDT

T?IN-AQUARIUM::	.TABLE			; TABLE FOR OBJECT IN-AQUARIUM
	.STRL "Murky Room"
	.PROP 1,P?OUT
	.BYTE AQUARIUM-ROOM
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	IN-AQUARIUM-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?70
	.BYTE	0
	.ENDT

T?RIDDLE-ROOM::	.TABLE			; TABLE FOR OBJECT RIDDLE-ROOM
	.STRL "Riddle Room"
	.PROP 5,P?EAST			; DOOR EXIT
	.BYTE PEARL-ROOM				; ROOM NAME
	.BYTE RIDDLE-DOOR			; DOOR NAME
	.WORD 0
	.BYTE 0				; STRING TO PRINT
	.PROP 1,P?NW
	.BYTE CAROUSEL-ROOM
	.PROP 1,P?DOWN
	.BYTE CAROUSEL-ROOM
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	RIDDLE-ROOM-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.PROP 4,P?PSEUDO
	W?RIDDLE
	RIDDLE-PSEUDO
	.BYTE	0
	.ENDT

T?GNOME::	.TABLE			; TABLE FOR OBJECT GNOME
	.STRL "Volcano Gnome"
	.PROP 2,P?SYNONYM
	W?GNOME
	.PROP 1,P?ADJECTIVE
	.BYTE A?VOLCANO
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	GNOME-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?106
	.BYTE	0
	.ENDT

T?STAIRWAY-TOP::	.TABLE			; TABLE FOR OBJECT STAIRWAY-TOP
	.STRL "Stairway"
	.PROP 1,P?NORTH
	.BYTE MENHIR-ROOM
	.PROP 1,P?DOWN
	.BYTE DIAMOND-5
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?49
	.PROP 1,P?GLOBAL
	.BYTE STAIRS
	.BYTE	0
	.ENDT

T?MANGLED-CAGE::	.TABLE			; TABLE FOR OBJECT MANGLED-CAGE
	.STRL "mangled cage"
	.PROP 2,P?SYNONYM
	W?CAGE
	.PROP 2,P?ADJECTIVE
	.BYTE A?MANGLED
	.BYTE A?STEEL
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	60
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?125
	.BYTE	0
	.ENDT

T?DIAMOND-4::	.TABLE			; TABLE FOR OBJECT DIAMOND-4
	.STRL "Oddly-angled Room"
	.PROP 1,P?EAST
	.BYTE DIAMOND-5
	.PROP 1,P?NE
	.BYTE DIAMOND-2
	.PROP 1,P?SE
	.BYTE DIAMOND-8
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	DIAMOND-MOTION
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?50
	.PROP 1,P?GLOBAL
	.BYTE DWINDOW
	.BYTE	0
	.ENDT

T?TELLER-EAST::	.TABLE			; TABLE FOR OBJECT TELLER-EAST
	.STRL "East Teller's Room"
	.PROP 1,P?NORTH
	.BYTE VIEWING-EAST
	.PROP 1,P?EAST
	.BYTE DEPOSITORY
	.PROP 1,P?SOUTH
	.BYTE BANK-ENTRANCE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	TELLER-ROOM
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?39
	.BYTE	0
	.ENDT

T?ROBOT-LABEL::	.TABLE			; TABLE FOR OBJECT ROBOT-LABEL
	.STRL "green piece of paper"
	.PROP 6,P?SYNONYM
	W?PAPER
	W?PIECE
	W?INSTRUCTIONS
	.PROP 1,P?ADJECTIVE
	.BYTE A?GREEN
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	3
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?121
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?122
	.BYTE	0
	.ENDT

T?CRYPT-DOOR::	.TABLE			; TABLE FOR OBJECT CRYPT-DOOR
	.STRL "crypt door"
	.PROP 2,P?SYNONYM
	W?DOOR
	.PROP 2,P?ADJECTIVE
	.BYTE A?CRYPT
	.BYTE A?NORTH
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CRYPT-DOOR-FCN
	.BYTE	0
	.ENDT

T?COIN::	.TABLE			; TABLE FOR OBJECT COIN
	.STRL "priceless zorkmid"
	.PROP 8,P?SYNONYM
	W?COIN
	W?ZORKMID
	W?GOLD
	W?TREASURE
	.PROP 2,P?ADJECTIVE
	.BYTE A?GOLD
	.BYTE A?PRICELESS
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	10
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?130
	.PROP 2,P?FDESC			; STRING PROPERTY
	STR?129
	.PROP 2,P?VALUE			; INTEGER/CONSTANT PROPERTY

	20
	.PROP 2,P?TEXT			; STRING PROPERTY
	STR?131
	.BYTE	0
	.ENDT

T?LETTER-OPENER::	.TABLE			; TABLE FOR OBJECT LETTER-OPENER
	.STRL "letter opener"
	.PROP 2,P?SYNONYM
	W?OPENER
	.PROP 1,P?ADJECTIVE
	.BYTE A?LETTER
	.PROP 2,P?SIZE			; INTEGER/CONSTANT PROPERTY

	2
	.BYTE	0
	.ENDT

T?DRAGON-ROOM::	.TABLE			; TABLE FOR OBJECT DRAGON-ROOM
	.STRL "Dragon Room"
	.PROP 4,P?NORTH			; CONDITIONAL EXIT
	.BYTE DRAGON-LAIR				; ROOM NAME
	.BYTE ICE-MELTED				; FLAG NAME
	STR?27			; STRING
	.PROP 1,P?EAST
	.BYTE LEDGE-TUNNEL
	.PROP 1,P?WEST
	.BYTE FRESCO-ROOM
	.PROP 1,P?SOUTH
	.BYTE STONE-BRIDGE
	.PROP 4,P?IN			; CONDITIONAL EXIT
	.BYTE DRAGON-LAIR				; ROOM NAME
	.BYTE ICE-MELTED				; FLAG NAME
	STR?27			; STRING
	.PROP 1,P?CROSS
	.BYTE STONE-BRIDGE
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?26
	.PROP 1,P?GLOBAL
	.BYTE BRIDGE
	.BYTE	0
	.ENDT

T?PSEUDO-OBJECT::	.TABLE			; TABLE FOR OBJECT PSEUDO-OBJECT
	.STRL "pseudo"
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	CRETIN-FCN
	.BYTE	0
	.ENDT

T?AQUARIUM::	.TABLE			; TABLE FOR OBJECT AQUARIUM
	.STRL "aquarium"
	.PROP 4,P?SYNONYM
	W?AQUARIUM
	W?GLASS
	.PROP 1,P?ADJECTIVE
	.BYTE A?HUGE
	.PROP 2,P?ACTION			; ATOM (CONSTANT) PROPERTY

	AQUARIUM-FCN
	.PROP 2,P?LDESC			; STRING PROPERTY
	STR?66
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	200
	.BYTE	0
	.ENDT

T?PTABLE::	.TABLE			; TABLE FOR OBJECT PTABLE
	.STRL "table"
	.PROP 2,P?SYNONYM
	W?TABLE
	.PROP 2,P?ADJECTIVE
	.BYTE A?DUSTY
	.BYTE A?WOODEN
	.PROP 2,P?CAPACITY			; INTEGER/CONSTANT PROPERTY

	40
	.BYTE	0
	.ENDT


; THE GLOBAL VARIABLES ARE ALL LOCATED HERE

GLOBAL::.TABLE
	.GVAR HERE=0
	.GVAR SCORE=0
	.GVAR MOVES=0
	.GVAR P-END-ON-PREP=0
	.GVAR SUPER-BRIEF=0
	.GVAR SAFE-FLAG=0
	.GVAR CAROUSEL-FLIP-FLAG=0
	.GVAR SWIMYUKS=T?22,TABLE
	.GVAR SPELL-VICTIM=0
	.GVAR VERBOSE=0
	.GVAR P-BUTS=T?15,TABLE
	.GVAR EVAPORATED=0
	.GVAR GENIE-THANKS=T?41,TABLE
	.GVAR DIAMOND-SOLVE=0
	.GVAR P-DIR=0
	.GVAR P-ACLAUSE=0
	.GVAR P-SLOCBITS=0
	.GVAR P-MATCHLEN=0
	.GVAR P-ADVERB=0
	.GVAR PUNLOCK-FLAG=0
	.GVAR BASE-SCORE=0
	.GVAR CLOCK-WAIT=0
	.GVAR P-MULT=0
	.GVAR P-OTBL=T?10,TABLE
	.GVAR WIZQDESCS=T?45,TABLE
	.GVAR P-NAM=0
	.GVAR ALWAYS-LIT=0
	.GVAR C-TABLE=T?1,TABLE
	.GVAR LUCKY=1
	.GVAR P-XNAM=0
	.GVAR SWORD-GLOW=0
	.GVAR OOPS-TABLE=T?8,TABLE
	.GVAR P-WALK-DIR=0
	.GVAR WIZQLAST=0
	.GVAR P-ANAM=0
	.GVAR PLAYER=0
	.GVAR OTHER-PROPERTIES=STR?212,STRING
	.GVAR MUD-FLAG=0
	.GVAR P-CONT=0
	.GVAR UNICORN-MSGS=T?39,TABLE
	.GVAR P-PRSI=T?14,TABLE
	.GVAR PRCOUNT=0
	.GVAR AGAIN-LEXV=T?4,TABLE
	.GVAR SPELL-USED=0
	.GVAR P-DIRECTION=0
	.GVAR MENHIR-POSITION=0
	.GVAR FUMBLE-NUMBER=7
	.GVAR DUMMY=T?33,TABLE
	.GVAR DESC-OBJECT=0
	.GVAR DWDESCS=T?34,TABLE
	.GVAR MUNGED-ROOM=0
	.GVAR BTIE-FLAG=0
	.GVAR LIT=0
	.GVAR BASES=T?35,TABLE
	.GVAR P-VTBL=T?11,TABLE
	.GVAR P-XADJN=0
	.GVAR BANK-SOLVE-FLAG=0
	.GVAR SPELL-NAMES=T?42,TABLE
	.GVAR DIAMOND-COUNT=0
	.GVAR RESERVE-LEXV=T?5,TABLE
	.GVAR LAMP-TABLE=T?32,TABLE
	.GVAR P-ACT=0
	.GVAR P-ADJ=0
	.GVAR P-LEN=0
	.GVAR C-INTS=180
	.GVAR P-CCTBL=T?2,TABLE
	.GVAR P-LEXV=T?3,TABLE
	.GVAR LOAD-ALLOWED=100
	.GVAR WAND-ON-LOC=0
	.GVAR SPRAYED?=0
	.GVAR PRSO=0
	.GVAR BUCKET-TOP-FLAG=0
	.GVAR GNOME-DOOR-FLAG=0
	.GVAR DIAMOND-ROOMS=T?36,TABLE
	.GVAR P-MERGED=0
	.GVAR PRFOLLOW=0
	.GVAR P-GWIMBIT=0
	.GVAR C-DEMONS=180
	.GVAR PLOOK-FLAG=0
	.GVAR MATCH-COUNT=6
	.GVAR P-OCLAUSE=T?17,TABLE
	.GVAR GENIE-READY?=0
	.GVAR PRINCESS-AWAKE=0
	.GVAR EIGHT-DIRECTIONS=T?26,TABLE
	.GVAR P-SYNTAX=0
	.GVAR ZGNOME-FLAG=0
	.GVAR P-XADJ=0
	.GVAR DIAMOND-MOVES=0
	.GVAR P-AADJ=0
	.GVAR PRSA=0
	.GVAR ICE-MELTED=0
	.GVAR PRDIRS=T?40,TABLE
	.GVAR GENIE-HOARD=0
	.GVAR WHEEEEE=T?19,TABLE
	.GVAR P-PRSO=T?13,TABLE
	.GVAR SPELL?=0
	.GVAR P-AND=0
	.GVAR UNICORN-FRIGHTENED=0
	.GVAR P-ONEOBJ=0
	.GVAR SCOL-ROOM=VIEWING-WEST
	.GVAR TOPIARY-MOVED=0
	.GVAR P-INBUF=T?6,TABLE
	.GVAR DEAD=0
	.GVAR JUMPLOSS=T?18,TABLE
	.GVAR SPRAY-USED?=0
	.GVAR P-MERGE=T?16,TABLE
	.GVAR DEATHS=0
	.GVAR P-WON=0
	.GVAR WIZ-DOOR-FLAG=0
	.GVAR SPELL-STOPS=T?44,TABLE
	.GVAR P-OVTBL=T?12,TABLE
	.GVAR SPELL-HANDLED?=0
	.GVAR WON-FLAG=0
	.GVAR DRAGON-ATTACKS=T?38,TABLE
	.GVAR P-ITBL=T?9,TABLE
	.GVAR QUOTE-FLAG=0
	.GVAR P-TABLE=0
	.GVAR DIDIRS=T?37,TABLE
	.GVAR CERBERUS-LEASHED=0
	.GVAR LOAD-MAX=100
	.GVAR P-GETFLAGS=0
	.GVAR DRAGON-ANGER=0
	.GVAR YUKS=T?24,TABLE
	.GVAR DIM-DOOR-FLAG=0
	.GVAR SCOL-WALLS=T?31,TABLE
	.GVAR GNOME-FLAG=0
	.GVAR DIAMOND-BASE=0
	.GVAR BINF-FLAG=0
	.GVAR OOPS-INBUF=T?7,TABLE
	.GVAR FUMBLE-PROB=8
	.GVAR INDENTS=T?20,TABLE
	.GVAR P-NUMBER=0
	.GVAR P-OFLAG=0
	.GVAR BLAB-FLAG=0
	.GVAR WINNER=0
	.GVAR BALLOON-UPS=T?27,TABLE
	.GVAR P-ADJN=0
	.GVAR AGAIN-DIR=0
	.GVAR CAGE-SOLVE-FLAG=0
	.GVAR MATOBJ=0
	.GVAR FANTASIES=T?46,TABLE
	.GVAR HS=0
	.GVAR GUARDIAN-FED=0
	.GVAR WAND-ON=0
	.GVAR P-IT-OBJECT=0
	.GVAR HO-HUM=T?21,TABLE
	.GVAR BLOC=VOLCANO-BOTTOM
	.GVAR FATAL-VAPORS=STR?229,STRING
	.GVAR OLD-HERE=DRAGON-ROOM
	.GVAR CAROUSEL-ZOOM-FLAG=0
	.GVAR BALLOON-DOWNS=T?29,TABLE
	.GVAR PRSI=0
	.GVAR RESERVE-PTR=0
	.GVAR COMPASS-KLUDGE=0
	.GVAR BALLOON-FLOATS=T?28,TABLE
	.GVAR HELLOS=T?23,TABLE
	.GVAR SPELL-HINTS=T?43,TABLE
	.GVAR SCOL-ROOMS=T?30,TABLE
	.GVAR TOPIARY-NEAR=0
	.GVAR P-NOT-HERE=0
	.GVAR P-NCN=0
	.GVAR SCOL-ACTIVE=0
	.GVAR CRYPT-LIT?=1
	.GVAR SECRET-DOOR=0
	.GVAR PREPOSITIONS=PRTBL,TABLE
	.GVAR ACTIONS=ATBL,TABLE
	.GVAR PREACTIONS=PATBL,TABLE
	.GVAR VERBS=VTBL,TABLE
	.ENDT

GLOEND::


; IMPURE TABLES ARE DEFINED HERE

IMPTBL::

T?1::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?2::	.TABLE
	0
	0
	0
	0
	.ENDT

T?3::	.TABLE
	.BYTE 59
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	.ENDT

T?4::	.TABLE
	.BYTE 59
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	.ENDT

T?5::	.TABLE
	.BYTE 59
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	0
	.BYTE 0
	.BYTE 0
	.ENDT

T?6::	.TABLE
	.BYTE 120
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.ENDT

T?7::	.TABLE
	.BYTE 120
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.ENDT

T?8::	.TABLE
	0
	0
	0
	0
	.ENDT

T?9::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?10::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?11::	.TABLE
	0
	0
	0
	0
	.ENDT

T?12::	.TABLE
	0
	.BYTE 0
	.BYTE 0
	.ENDT

T?13::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?14::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?15::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?16::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?17::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT

T?18::	.TABLE
	4
	0
	STR?170
	STR?171
	STR?172
	.ENDT

T?19::	.TABLE
	5
	0
	STR?176
	STR?177
	STR?178
	STR?179
	.ENDT

T?20::	.TABLE
	STR?183
	STR?183
	STR?184
	STR?185
	STR?186
	STR?187
	.ENDT

T?21::	.TABLE
	4
	0
	STR?188
	STR?189
	STR?190
	.ENDT

T?22::	.TABLE
	2
	0
	STR?192
	.ENDT

T?23::	.TABLE
	5
	0
	STR?193
	STR?194
	STR?195
	STR?196
	.ENDT

T?24::	.TABLE
	5
	0
	STR?197
	STR?198
	STR?199
	STR?200
	.ENDT

T?25::	.TABLE
	4
	0
	STR?201
	STR?202
	STR?203
	.ENDT

T?26::	.TABLE
	P?NORTH
	P?EAST
	P?SOUTH
	P?NE
	P?SE
	P?SW
	P?NW
	.ENDT

T?27::	.TABLE
	4
	VAIR-1
	VAIR-2
	VAIR-3
	VAIR-4
	.ENDT

T?28::	.TABLE
	4
	LEDGE-1
	VAIR-2
	LEDGE-2
	VAIR-4
	.ENDT

T?29::	.TABLE
	4
	VAIR-4
	VAIR-3
	VAIR-2
	VAIR-1
	.ENDT

T?30::	.TABLE
	8
	P?EAST
	VIEWING-EAST
	P?WEST
	VIEWING-WEST
	P?NORTH
	SMALL-ROOM
	P?SOUTH
	VAULT
	.ENDT

T?31::	.TABLE
	VIEWING-WEST
	SEWL
	VIEWING-WEST
	VIEWING-EAST
	SWWL
	VIEWING-EAST
	SMALL-ROOM
	SSWL
	VAULT
	VAULT
	SNWL
	SMALL-ROOM
	.ENDT

T?32::	.TABLE
	300
	STR?247
	100
	STR?248
	50
	STR?249
	0
	.ENDT

T?33::	.TABLE
	3
	STR?201
	STR?250
	STR?251
	.ENDT

T?34::	.TABLE
	STR?254
	STR?255
	STR?256
	STR?257
	STR?258
	.ENDT

T?35::	.TABLE
	STR?259
	STR?259
	STR?259
	STR?260
	STR?261
	STR?262
	.ENDT

T?36::	.TABLE
	DIAMOND-2
	DIAMOND-4
	DIAMOND-6
	DIAMOND-8
	DIAMOND-1
	DIAMOND-3
	DIAMOND-5
	DIAMOND-7
	DIAMOND-9
	.ENDT

T?37::	.TABLE
	P?SE
	P?NE
	P?NW
	P?SW
	.ENDT

T?38::	.TABLE
	5
	STR?267
	STR?268
	STR?269
	STR?270
	STR?271
	.ENDT

T?39::	.TABLE
	4
	STR?276
	STR?277
	STR?278
	STR?279
	.ENDT

T?40::	.TABLE
	STR?240
	DRAGON-ROOM
	STR?239
	P?SOUTH
	STR?281
	LEDGE-TUNNEL
	STR?282
	P?EAST
	STR?281
	RAVINE-LEDGE
	STR?282
	P?EAST
	STR?283
	DEEP-FORD
	STR?284
	P?DOWN
	STR?240
	MARBLE-HALL
	STR?239
	P?SOUTH
	STR?281
	STREAM-PATH
	STR?282
	P?EAST
	STR?281
	FORMAL-GARDEN
	STR?282
	P?EAST
	STR?239
	GARDEN-NORTH
	STR?240
	P?NORTH
	STR?285
	GAZEBO-ROOM
	STR?286
	P?IN
	.ENDT

T?41::	.TABLE
	9
	STR?297
	STR?298
	STR?299
	STR?300
	STR?301
	STR?302
	STR?303
	STR?304
	STR?305
	.ENDT

T?42::	.TABLE
	12
	STR?310
	STR?311
	STR?312
	STR?313
	STR?314
	STR?315
	STR?316
	STR?317
	STR?318
	STR?319
	STR?320
	STR?321
	.ENDT

T?43::	.TABLE
	12
	STR?322
	0
	STR?323
	0
	STR?324
	0
	STR?325
	STR?326
	0
	0
	0
	0
	.ENDT

T?44::	.TABLE
	12
	STR?327
	0
	STR?328
	0
	STR?329
	0
	STR?330
	STR?331
	STR?332
	0
	0
	0
	.ENDT

T?45::	.TABLE
	8
	STR?335
	STR?336
	STR?337
	STR?338
	STR?339
	STR?340
	STR?341
	STR?342
	.ENDT

T?46::	.TABLE
	8
	STR?344
	STR?345
	STR?346
	STR?347
	STR?348
	STR?349
	STR?350
	STR?351
	.ENDT


; END OF PURENESS

IMPURE::



; VERB TABLE IS DEFINED HERE

VTBL::	.TABLE
	ST?KISS
	ST?SKIP
	ST?INFLAT
	ST?STAY
	ST?PULL
	ST?PUT
	ST?RAPE
	ST?VERBOSE
	ST?WALK
	ST?QUIT
	ST?FIND
	ST?DESTROY
	ST?UNLOCK
	ST?READ
	ST?SAY
	ST?PUNCTURE
	ST?JUMP
	ST?POUR
	ST?WAIT
	ST?TAKE
	ST?COUNT
	ST?RAISE
	ST?FOLLOW
	ST?VERSION
	ST?WIND
	ST?#UNRECORD
	ST?LIGHT
	ST?MOVE
	ST?CHOMP
	ST?PLAY
	ST?OPEN
	ST?#COMMAND
	ST?BLOW
	ST?KNOCK
	ST?PICK
	ST?DEFLATE
	ST?BOARD
	ST?#RANDOM
	ST?APPLY
	ST?PRAY
	ST?STAND
	ST?ENCHANT
	ST?LISTEN
	ST?TIE
	ST?SAVE
	ST?TELL
	ST?THROW
	ST?ZORK
	ST?LOWER
	ST?COMMAND
	ST?TALK
	ST?SHAKE
	ST?INVENTORY
	ST?ATTACK
	ST?KILL
	ST?ENTER
	ST?SEARCH
	ST?WEAR
	ST?FROBOZZ
	ST?DISEMBARK
	ST?SWIM
	ST?LUBRICATE
	ST?PLUG
	ST?UNTIE
	ST?PUMP
	ST?CUT
	ST?UNSCRIPT
	ST?MELT
	ST?BRUSH
	ST?RING
	ST?PUSH
	ST?RUB
	ST?SUPER
	ST?BLAST
	ST?DIG
	ST?WISH
	ST?INCANT
	ST?SEND
	ST?SCORE
	ST?EXORCISE
	ST?HATCH
	ST?WIN
	ST?LOOK
	ST?ODYSSEUS
	ST?SPRAY
	ST?DROP
	ST?BACK
	ST?ROLL
	ST?LEAVE
	ST?CURSE
	ST?SCRIPT
	ST?REPENT
	ST?SPIN
	ST?$VERIFY
	ST?EXTINGUISH
	ST?SWING
	ST?RESTART
	ST?POKE
	ST?SMELL
	ST?BRIEF
	ST?ECHO
	ST?DIAGNOSE
	ST?GIVE
	ST?WAKE
	ST?DRINK
	ST?ANSWER
	ST?MUMBLE
	ST?YELL
	ST?LOCK
	ST?ACTIVATE
	ST?BURN
	ST?KICK
	ST?PLUGH
	ST?TURN
	ST?#RECORD
	ST?CROSS
	ST?STAB
	ST?MAKE
	ST?RESTORE
	ST?CLOSE
	ST?STRIKE
	ST?SLIDE
	ST?WAVE
	ST?EXIT
	ST?EXAMINE
	ST?DISENCHANT
	ST?EAT
	ST?FILL
	ST?LEAN
	ST?SQUEEZE
	ST?BUG
	ST?CLIMB
	ST?LAUNCH
	ST?TREASURE
	ST?HELLO
	.ENDT

; SYNTAX DEFINITION TABLES ARE DEFINED HERE

ST?KISS::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?KISS
	.ENDT

ST?SKIP::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SKIP
	.ENDT

ST?INFLAT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE TOOLBIT
	.BYTE 0
	.BYTE SOG+SIR+SH+SC
	.BYTE V?INFLATE
	.ENDT

ST?STAY::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?STAY
	.ENDT

ST?PULL::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?MOVE
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?MOVE
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?MOVE
	.ENDT

ST?PUT::	.TABLE
	.BYTE 7	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?BEHIND
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY+SHAVE
	.BYTE 0
	.BYTE V?PUT-BEHIND
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SIR+SOG+SC+SMANY
	.BYTE 0
	.BYTE V?WEAR
	.BYTE 1	;OBJECTS
	.BYTE PR?OUT
	.BYTE 0
	.BYTE ONBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE+SHAVE
	.BYTE 0
	.BYTE V?LAMP-OFF
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?UNDER
	.BYTE 0
	.BYTE 0
	.BYTE SH+SHAVE
	.BYTE 0
	.BYTE V?PUT-UNDER
	.BYTE 1	;OBJECTS
	.BYTE PR?DOWN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY
	.BYTE 0
	.BYTE V?DROP
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY+SHAVE
	.BYTE 0
	.BYTE V?PUT-ON
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY+SHAVE
	.BYTE 0
	.BYTE V?PUT
	.ENDT

ST?RAPE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RAPE
	.ENDT

ST?VERBOSE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?VERBOSE
	.ENDT

ST?WALK::	.TABLE
	.BYTE 11	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?DOWN
	.BYTE 0
	.BYTE CLIMBBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?CLIMB-DOWN
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE CLIMBBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?CLIMB-UP
	.BYTE 1	;OBJECTS
	.BYTE PR?AROUND
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WALK-AROUND
	.BYTE 1	;OBJECTS
	.BYTE PR?TO
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WALK-TO
	.BYTE 1	;OBJECTS
	.BYTE PR?OVER
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LEAP
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?THROUGH
	.BYTE 1	;OBJECTS
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?THROUGH
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?THROUGH
	.BYTE 1	;OBJECTS
	.BYTE PR?AWAY
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WALK
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WALK
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WALK-AROUND
	.ENDT

ST?QUIT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?QUIT
	.ENDT

ST?FIND::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?FIND
	.ENDT

ST?DESTROY::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR+SH+SC
	.BYTE 0
	.BYTE V?OPEN
	.BYTE 2	;OBJECTS
	.BYTE PR?DOWN
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR+SH+SC
	.BYTE SH+SC+STAKE
	.BYTE V?MUNG
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR+SH+SC
	.BYTE SH+SC+STAKE
	.BYTE V?MUNG
	.ENDT

ST?UNLOCK::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE TOOLBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SOG+SIR+STAKE
	.BYTE V?UNLOCK
	.ENDT

ST?READ::	.TABLE
	.BYTE 4	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE READBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE
	.BYTE 0
	.BYTE V?READ-PAGE
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE READBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE
	.BYTE 0
	.BYTE V?READ
	.BYTE 1	;OBJECTS
	.BYTE PR?FROM
	.BYTE 0
	.BYTE READBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE
	.BYTE 0
	.BYTE V?READ
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE READBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE
	.BYTE 0
	.BYTE V?READ
	.ENDT

ST?SAY::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SAY
	.ENDT

ST?PUNCTURE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE ACTORBIT
	.BYTE WEAPONBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SHAVE
	.BYTE V?MUNG
	.ENDT

ST?JUMP::	.TABLE
	.BYTE 6	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?OFF
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LEAP
	.BYTE 1	;OBJECTS
	.BYTE PR?FROM
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LEAP
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LEAP
	.BYTE 1	;OBJECTS
	.BYTE PR?ACROSS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LEAP
	.BYTE 1	;OBJECTS
	.BYTE PR?OVER
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LEAP
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LEAP
	.ENDT

ST?POUR::	.TABLE
	.BYTE 4	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?FROM
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC
	.BYTE 0
	.BYTE V?DROP
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC
	.BYTE 0
	.BYTE V?POUR-ON
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC
	.BYTE 0
	.BYTE V?DROP
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC
	.BYTE 0
	.BYTE V?DROP
	.ENDT

ST?WAIT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WAIT
	.ENDT

ST?TAKE::	.TABLE
	.BYTE 8	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?FROM
	.BYTE TAKEBIT
	.BYTE 0
	.BYTE SIR+SC+SMANY
	.BYTE 0
	.BYTE V?TAKE
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?OFF
	.BYTE TAKEBIT
	.BYTE 0
	.BYTE SC+SIR+SMANY
	.BYTE 0
	.BYTE V?TAKE
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?OUT
	.BYTE TAKEBIT
	.BYTE 0
	.BYTE SC+SIR+SMANY
	.BYTE 0
	.BYTE V?TAKE
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE RMUNGBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?STAND
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE VEHBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?CLIMB-ON
	.BYTE 1	;OBJECTS
	.BYTE PR?OUT
	.BYTE 0
	.BYTE RMUNGBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?DISEMBARK
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE VEHBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?BOARD
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE TAKEBIT
	.BYTE 0
	.BYTE SOG+SIR+SMANY
	.BYTE 0
	.BYTE V?TAKE
	.ENDT

ST?COUNT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?COUNT
	.ENDT

ST?RAISE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RAISE
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RAISE
	.ENDT

ST?FOLLOW::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?FOLLOW
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?FOLLOW
	.ENDT

ST?VERSION::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?VERSION
	.ENDT

ST?WIND::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WIND
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WIND
	.ENDT

ST?#UNRECORD::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?UNRECORD
	.ENDT

ST?LIGHT::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE LIGHTBIT
	.BYTE FLAMEBIT
	.BYTE SH+SC+SOG+SIR
	.BYTE SH+SC+STAKE+SHAVE
	.BYTE V?BURN
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE LIGHTBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE+SHAVE
	.BYTE 0
	.BYTE V?LAMP-ON
	.ENDT

ST?MOVE::	.TABLE
	.BYTE 5	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE TOOLBIT
	.BYTE 0
	.BYTE 0
	.BYTE V?TURN
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY+SHAVE
	.BYTE 0
	.BYTE V?PUT
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?TO
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?PUSH-TO
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?PUSH-TO
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?MOVE
	.ENDT

ST?CHOMP::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?CHOMP
	.ENDT

ST?PLAY::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PLAY
	.ENDT

ST?OPEN::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE DOORBIT
	.BYTE TOOLBIT
	.BYTE SH+SC+SOG+SIR
	.BYTE SOG+SIR+SH+SC+SHAVE
	.BYTE V?OPEN
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE DOORBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?OPEN
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE DOORBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?OPEN
	.ENDT

ST?#COMMAND::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?COMMAND-FILE
	.ENDT

ST?BLOW::	.TABLE
	.BYTE 4	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?BREATHE
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?BLAST
	.BYTE 2	;OBJECTS
	.BYTE PR?UP
	.BYTE PR?WITH
	.BYTE 0
	.BYTE TOOLBIT
	.BYTE 0
	.BYTE SOG+SIR+SH+SC
	.BYTE V?INFLATE
	.BYTE 1	;OBJECTS
	.BYTE PR?OUT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LAMP-OFF
	.ENDT

ST?KNOCK::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?DOWN
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?ATTACK
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?KNOCK
	.BYTE 1	;OBJECTS
	.BYTE PR?AT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?KNOCK
	.ENDT

ST?PICK::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE TAKEBIT
	.BYTE 0
	.BYTE SOG+SMANY
	.BYTE 0
	.BYTE V?TAKE
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PICK
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PICK
	.ENDT

ST?DEFLATE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?DEFLATE
	.ENDT

ST?BOARD::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE VEHBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?BOARD
	.ENDT

ST?#RANDOM::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RANDOM
	.ENDT

ST?APPLY::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?TO
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PUT
	.ENDT

ST?PRAY::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PRAY
	.ENDT

ST?STAND::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE RMUNGBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?STAND
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?STAND
	.ENDT

ST?ENCHANT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?ENCHANT
	.ENDT

ST?LISTEN::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?FOR
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LISTEN
	.BYTE 1	;OBJECTS
	.BYTE PR?TO
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LISTEN
	.ENDT

ST?TIE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE PR?UP
	.BYTE PR?WITH
	.BYTE ACTORBIT
	.BYTE TOOLBIT
	.BYTE SOG+SIR
	.BYTE SOG+SIR+SH+SC+SHAVE
	.BYTE V?TIE-UP
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?TO
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?TIE
	.ENDT

ST?SAVE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SAVE
	.ENDT

ST?TELL::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?ABOUT
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SIR
	.BYTE 0
	.BYTE V?TELL
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SIR
	.BYTE 0
	.BYTE V?TELL
	.ENDT

ST?THROW::	.TABLE
	.BYTE 7	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?OVER
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SHAVE
	.BYTE 0
	.BYTE V?THROW-OFF
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?OFF
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SHAVE
	.BYTE 0
	.BYTE V?THROW-OFF
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SHAVE
	.BYTE 0
	.BYTE V?PUT-ON
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SHAVE
	.BYTE 0
	.BYTE V?PUT
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?OVERBOARD
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE SH+SC+SHAVE
	.BYTE SOG+SIR
	.BYTE V?THROW
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?AT
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE SH+SC+SHAVE
	.BYTE SOG+SIR
	.BYTE V?THROW
	.ENDT

ST?ZORK::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?ZORK
	.ENDT

ST?LOWER::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LOWER
	.ENDT

ST?COMMAND::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?COMMAND
	.ENDT

ST?TALK::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?TO
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SIR
	.BYTE 0
	.BYTE V?TELL
	.ENDT

ST?SHAKE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SHAVE
	.BYTE 0
	.BYTE V?SHAKE
	.ENDT

ST?INVENTORY::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?INVENTORY
	.ENDT

ST?ATTACK::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE ACTORBIT
	.BYTE WEAPONBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SHAVE
	.BYTE V?ATTACK
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?ATTACK
	.ENDT

ST?KILL::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE ACTORBIT
	.BYTE WEAPONBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SHAVE
	.BYTE V?ATTACK
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?ATTACK
	.ENDT

ST?ENTER::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?THROUGH
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?ENTER
	.ENDT

ST?SEARCH::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?FOR
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?FIND
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SEARCH
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SEARCH
	.ENDT

ST?WEAR::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WEAR
	.ENDT

ST?FROBOZZ::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?FROBOZZ
	.ENDT

ST?DISEMBARK::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE VEHBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?DISEMBARK
	.ENDT

ST?SWIM::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?ACROSS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SWIM
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SWIM
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SWIM
	.ENDT

ST?LUBRICATE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC
	.BYTE V?OIL
	.ENDT

ST?PLUG::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PLUG
	.ENDT

ST?UNTIE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?FROM
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR+SH+SC
	.BYTE 0
	.BYTE V?UNTIE
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR+SH+SC
	.BYTE 0
	.BYTE V?UNTIE
	.ENDT

ST?PUMP::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE PR?UP
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PUMP
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PUMP
	.ENDT

ST?CUT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE WEAPONBIT
	.BYTE 0
	.BYTE SC+SH
	.BYTE V?CUT
	.ENDT

ST?UNSCRIPT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?UNSCRIPT
	.ENDT

ST?MELT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE FLAMEBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE V?MELT
	.ENDT

ST?BRUSH::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?BRUSH
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?BRUSH
	.ENDT

ST?RING::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE STAKE
	.BYTE 0
	.BYTE V?RING
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE STAKE
	.BYTE 0
	.BYTE V?RING
	.ENDT

ST?PUSH::	.TABLE
	.BYTE 6	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?UNDER
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PUT-UNDER
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE TOOLBIT
	.BYTE 0
	.BYTE 0
	.BYTE V?TURN
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SIR+SOG+SMANY
	.BYTE 0
	.BYTE V?PUSH
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SIR+SOG+SMANY
	.BYTE 0
	.BYTE V?PUSH
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?TO
	.BYTE 0
	.BYTE 0
	.BYTE SIR+SOG
	.BYTE 0
	.BYTE V?PUSH-TO
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SIR+SOG
	.BYTE 0
	.BYTE V?PUSH-TO
	.ENDT

ST?RUB::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RUB
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RUB
	.ENDT

ST?SUPER::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SUPER-BRIEF
	.ENDT

ST?BLAST::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?BLAST
	.ENDT

ST?DIG::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE TOOLBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SHAVE
	.BYTE V?DIG
	.BYTE 2	;OBJECTS
	.BYTE PR?IN
	.BYTE PR?WITH
	.BYTE 0
	.BYTE TOOLBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SHAVE
	.BYTE V?DIG
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?DIG
	.ENDT

ST?WISH::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WISH
	.ENDT

ST?INCANT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?INCANT
	.ENDT

ST?SEND::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?FOR
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SEND
	.ENDT

ST?SCORE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SCORE
	.ENDT

ST?EXORCISE::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?AWAY
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?EXORCISE
	.BYTE 1	;OBJECTS
	.BYTE PR?OUT
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?EXORCISE
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?EXORCISE
	.ENDT

ST?HATCH::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?HATCH
	.ENDT

ST?WIN::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WIN
	.ENDT

ST?LOOK::	.TABLE
	.BYTE 12	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?FOR
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?FIND
	.BYTE 2	;OBJECTS
	.BYTE PR?AT
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?READ
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+SMANY
	.BYTE 0
	.BYTE V?LOOK-INSIDE
	.BYTE 1	;OBJECTS
	.BYTE PR?BEHIND
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LOOK-BEHIND
	.BYTE 1	;OBJECTS
	.BYTE PR?UNDER
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LOOK-UNDER
	.BYTE 1	;OBJECTS
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+SMANY
	.BYTE 0
	.BYTE V?LOOK-INSIDE
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LOOK-ON
	.BYTE 1	;OBJECTS
	.BYTE PR?AT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+SMANY
	.BYTE 0
	.BYTE V?EXAMINE
	.BYTE 1	;OBJECTS
	.BYTE PR?DOWN
	.BYTE 0
	.BYTE RMUNGBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LOOK
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE RMUNGBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LOOK
	.BYTE 1	;OBJECTS
	.BYTE PR?AROUND
	.BYTE 0
	.BYTE RMUNGBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LOOK
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LOOK
	.ENDT

ST?ODYSSEUS::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?ODYSSEUS
	.ENDT

ST?SPRAY::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SSPRAY
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SPRAY
	.ENDT

ST?DROP::	.TABLE
	.BYTE 4	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY+SHAVE
	.BYTE 0
	.BYTE V?PUT-ON
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY+SHAVE
	.BYTE 0
	.BYTE V?PUT
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?DOWN
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY+SHAVE
	.BYTE 0
	.BYTE V?PUT
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SMANY+SHAVE
	.BYTE 0
	.BYTE V?DROP
	.ENDT

ST?BACK::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?BACK
	.ENDT

ST?ROLL::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?MOVE
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?MOVE
	.ENDT

ST?LEAVE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?DROP
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LEAVE
	.ENDT

ST?CURSE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?CURSES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?CURSES
	.ENDT

ST?SCRIPT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SCRIPT
	.ENDT

ST?REPENT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?REPENT
	.ENDT

ST?SPIN::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SPIN
	.ENDT

ST?$VERIFY::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?VERIFY
	.ENDT

ST?EXTINGUISH::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ONBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE+SHAVE
	.BYTE 0
	.BYTE V?LAMP-OFF
	.ENDT

ST?SWING::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?AT
	.BYTE WEAPONBIT
	.BYTE ACTORBIT
	.BYTE SH+SC+SHAVE
	.BYTE SOG+SIR
	.BYTE V?SWING
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE WEAPONBIT
	.BYTE 0
	.BYTE SH+SC+SHAVE
	.BYTE 0
	.BYTE V?SWING
	.ENDT

ST?RESTART::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RESTART
	.ENDT

ST?POKE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE ACTORBIT
	.BYTE WEAPONBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SHAVE
	.BYTE V?MUNG
	.ENDT

ST?SMELL::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SMELL
	.ENDT

ST?BRIEF::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?BRIEF
	.ENDT

ST?ECHO::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?ECHO
	.ENDT

ST?DIAGNOSE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?DIAGNOSE
	.ENDT

ST?GIVE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SOG
	.BYTE SMANY+SH+SHAVE
	.BYTE V?SGIVE
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?TO
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE SMANY+SH+SHAVE
	.BYTE SOG
	.BYTE V?GIVE
	.ENDT

ST?WAKE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?ALARM
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?ALARM
	.ENDT

ST?DRINK::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?FROM
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC
	.BYTE 0
	.BYTE V?DRINK-FROM
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE DRINKBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?DRINK
	.ENDT

ST?ANSWER::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?REPLY
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?ANSWER
	.ENDT

ST?MUMBLE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?MUMBLE
	.ENDT

ST?YELL::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?YELL
	.ENDT

ST?LOCK::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE 0
	.BYTE TOOLBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SOG+SIR+STAKE
	.BYTE V?LOCK
	.ENDT

ST?ACTIVATE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE LIGHTBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?LAMP-ON
	.ENDT

ST?BURN::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE PR?DOWN
	.BYTE PR?WITH
	.BYTE BURNBIT
	.BYTE FLAMEBIT
	.BYTE SH+SC+SOG+SIR
	.BYTE SH+SC+SOG+SIR+SHAVE
	.BYTE V?BURN
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE BURNBIT
	.BYTE FLAMEBIT
	.BYTE SH+SC+SOG+SIR
	.BYTE SH+SC+SOG+SIR+SHAVE
	.BYTE V?BURN
	.ENDT

ST?KICK::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?KICK
	.ENDT

ST?PLUGH::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?ADVENT
	.ENDT

ST?TURN::	.TABLE
	.BYTE 6	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?FOR
	.BYTE TURNBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?TURN
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?TO
	.BYTE TURNBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?TURN
	.BYTE 1	;OBJECTS
	.BYTE PR?OFF
	.BYTE 0
	.BYTE ONBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE+SHAVE
	.BYTE 0
	.BYTE V?LAMP-OFF
	.BYTE 2	;OBJECTS
	.BYTE PR?ON
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SHAVE
	.BYTE V?LAMP-ON
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE LIGHTBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?LAMP-ON
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE TURNBIT
	.BYTE RMUNGBIT
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?TURN
	.ENDT

ST?#RECORD::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RECORD
	.ENDT

ST?CROSS::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?CROSS
	.ENDT

ST?STAB::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE ACTORBIT
	.BYTE WEAPONBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SHAVE
	.BYTE V?ATTACK
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE ACTORBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?STAB
	.ENDT

ST?MAKE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?MAKE
	.ENDT

ST?RESTORE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?RESTORE
	.ENDT

ST?CLOSE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE DOORBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?CLOSE
	.ENDT

ST?STRIKE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SOG+SIR+SH+SC
	.BYTE 0
	.BYTE V?STRIKE
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE ACTORBIT
	.BYTE WEAPONBIT
	.BYTE SOG+SIR
	.BYTE SH+SC+SOG+SIR+SHAVE
	.BYTE V?ATTACK
	.ENDT

ST?SLIDE::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?TO
	.BYTE 0
	.BYTE 0
	.BYTE SIR+SOG
	.BYTE 0
	.BYTE V?PUSH-TO
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SIR+SOG
	.BYTE 0
	.BYTE V?PUSH-TO
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?UNDER
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PUT-UNDER
	.ENDT

ST?WAVE::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?AT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?WAVE
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?AT
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+STAKE+SHAVE
	.BYTE 0
	.BYTE V?WAVE
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+STAKE+SHAVE
	.BYTE 0
	.BYTE V?WAVE
	.ENDT

ST?EXIT::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?EXIT
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?EXIT
	.ENDT

ST?EXAMINE::	.TABLE
	.BYTE 3	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SIR+SOG+SMANY
	.BYTE 0
	.BYTE V?LOOK-INSIDE
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SC+SIR+SOG+SMANY
	.BYTE 0
	.BYTE V?LOOK-INSIDE
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SMANY
	.BYTE 0
	.BYTE V?EXAMINE
	.ENDT

ST?DISENCHANT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?DISENCHANT
	.ENDT

ST?EAT::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE FOODBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR+STAKE
	.BYTE 0
	.BYTE V?EAT
	.ENDT

ST?FILL::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE CONTBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?FILL
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?WITH
	.BYTE CONTBIT
	.BYTE 0
	.BYTE SH+SC+SOG+SIR
	.BYTE 0
	.BYTE V?FILL
	.ENDT

ST?LEAN::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE SH+SHAVE
	.BYTE 0
	.BYTE V?LEAN-ON
	.ENDT

ST?SQUEEZE::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 2	;OBJECTS
	.BYTE 0
	.BYTE PR?ON
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?PUT
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?SQUEEZE
	.ENDT

ST?BUG::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?BUG
	.ENDT

ST?CLIMB::	.TABLE
	.BYTE 8	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE PR?WITH
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?THROUGH
	.BYTE 1	;OBJECTS
	.BYTE PR?ON
	.BYTE 0
	.BYTE VEHBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?CLIMB-ON
	.BYTE 1	;OBJECTS
	.BYTE PR?IN
	.BYTE 0
	.BYTE VEHBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?BOARD
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE CLIMBBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?CLIMB-FOO
	.BYTE 1	;OBJECTS
	.BYTE PR?DOWN
	.BYTE 0
	.BYTE CLIMBBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?CLIMB-DOWN
	.BYTE 1	;OBJECTS
	.BYTE PR?DOWN
	.BYTE 0
	.BYTE RMUNGBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?CLIMB-DOWN
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE CLIMBBIT
	.BYTE 0
	.BYTE SOG+SIR
	.BYTE 0
	.BYTE V?CLIMB-UP
	.BYTE 1	;OBJECTS
	.BYTE PR?UP
	.BYTE 0
	.BYTE RMUNGBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?CLIMB-UP
	.ENDT

ST?LAUNCH::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE VEHBIT
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?LAUNCH
	.ENDT

ST?TREASURE::	.TABLE
	.BYTE 1	;NUMBER OF SYNTAXES
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?TREASURE
	.ENDT

ST?HELLO::	.TABLE
	.BYTE 2	;NUMBER OF SYNTAXES
	.BYTE 1	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?HELLO
	.BYTE 0	;OBJECTS
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE 0
	.BYTE V?HELLO
	.ENDT


; THE ACTION CALLING TABLE IS DEFINED HERE

ATBL::	.TABLE
	V-VERBOSE
	V-BRIEF
	V-SUPER-BRIEF
	V-DIAGNOSE
	V-INVENTORY
	V-QUIT
	V-RESTART
	V-RESTORE
	V-SAVE
	V-SCORE
	V-SCRIPT
	V-UNSCRIPT
	V-VERSION
	V-VERIFY
	V-RANDOM
	V-COMMAND-FILE
	V-RECORD
	V-UNRECORD
	V-LAMP-ON
	V-ANSWER
	V-REPLY
	V-PUT
	V-ATTACK
	V-BACK
	V-BLAST
	V-LAMP-OFF
	V-INFLATE
	V-BREATHE
	V-BOARD
	V-BRUSH
	V-BUG
	V-BURN
	V-CHOMP
	V-CLIMB-UP
	V-CLIMB-DOWN
	V-CLIMB-FOO
	V-CLIMB-ON
	V-THROUGH
	V-CLOSE
	V-COMMAND
	V-COUNT
	V-CROSS
	V-CUT
	V-CURSES
	V-DEFLATE
	V-MUNG
	V-OPEN
	V-DIG
	V-DISEMBARK
	V-DISENCHANT
	V-DRINK
	V-DRINK-FROM
	V-DROP
	V-PUT-ON
	V-EAT
	V-ECHO
	V-ENCHANT
	V-ENTER
	V-EXIT
	V-EXAMINE
	V-LOOK-INSIDE
	V-EXORCISE
	V-FILL
	V-FIND
	V-FOLLOW
	V-FROBOZZ
	V-GIVE
	V-SGIVE
	V-HATCH
	V-HELLO
	V-INCANT
	V-LEAP
	V-KICK
	V-STAB
	V-KISS
	V-KNOCK
	V-LAUNCH
	V-LEAN-ON
	V-LEAVE
	V-LISTEN
	V-LOCK
	V-LOOK
	V-LOOK-ON
	V-LOOK-UNDER
	V-LOOK-BEHIND
	V-READ
	V-LOWER
	V-OIL
	V-MAKE
	V-MELT
	V-MOVE
	V-PUSH-TO
	V-TURN
	V-MUMBLE
	V-ODYSSEUS
	V-PICK
	V-TAKE
	V-PLAY
	V-PLUG
	V-ADVENT
	V-POUR-ON
	V-PRAY
	V-PUMP
	V-PUSH
	V-PUT-UNDER
	V-WEAR
	V-PUT-BEHIND
	V-RAISE
	V-RAPE
	V-READ-PAGE
	V-REPENT
	V-RING
	V-RUB
	V-TELL
	V-SAY
	V-SEARCH
	V-SEND
	V-SHAKE
	V-SKIP
	V-SMELL
	V-SPIN
	V-SPRAY
	V-SSPRAY
	V-SQUEEZE
	V-STAND
	V-STAY
	V-STRIKE
	V-SWIM
	V-SWING
	V-THROW
	V-OVERBOARD
	V-THROW-OFF
	V-TIE
	V-TIE-UP
	V-TREASURE
	V-UNLOCK
	V-UNTIE
	V-WAIT
	V-ALARM
	V-WALK-AROUND
	V-WALK
	V-WALK-TO
	V-WAVE
	V-WIN
	V-WIND
	V-WISH
	V-YELL
	V-ZORK
	.ENDT

; THE PREACTION CALLING TABLE IS DEFINED HERE

PATBL::	.TABLE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	PRE-PUT
	0
	0
	0
	0
	0
	0
	PRE-BOARD
	0
	0
	PRE-BURN
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	PRE-MUNG
	0
	0
	0
	0
	0
	0
	PRE-DROP
	PRE-PUT
	0
	0
	0
	0
	0
	0
	0
	0
	PRE-FILL
	0
	0
	0
	PRE-GIVE
	PRE-SGIVE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	PRE-READ
	0
	0
	0
	0
	PRE-MOVE
	0
	PRE-TURN
	0
	0
	0
	PRE-TAKE
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	0
	.ENDT


; PREPOSITION TABLE IS DEFINED HERE

PRTBL::	.TABLE
	.WORD 18
	W?ABOUT
	PR?ABOUT
	W?BEHIND
	PR?BEHIND
	W?UNDER
	PR?UNDER
	W?AROUND
	PR?AROUND
	W?FOR
	PR?FOR
	W?AT
	PR?AT
	W?OFF
	PR?OFF
	W?ACROSS
	PR?ACROSS
	W?OVER
	PR?OVER
	W?AWAY
	PR?AWAY
	W?FROM
	PR?FROM
	W?ON
	PR?ON
	W?DOWN
	PR?DOWN
	W?IN
	PR?IN
	W?UP
	PR?UP
	W?OUT
	PR?OUT
	W?WITH
	PR?WITH
	W?TO
	PR?TO
	.ENDT


; VOCABULARY TABLE IS HERE

VOCAB::	.TABLE
	.BYTE 3
	.BYTE 46
	.BYTE 44
	.BYTE 34
	.BYTE 7
	689
W?$VERIFY::	.ZWORD "$verif"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?$VERIFY
	.BYTE 0
W?PERIOD::	.ZWORD "."
	.BYTE PS?BUZZ-WORD
	.BYTE B?PERIOD
	.BYTE 0
W?COMMA::	.ZWORD ","
	.BYTE PS?BUZZ-WORD
	.BYTE B?COMMA
	.BYTE 0
W?#COMMAND::	.ZWORD "#comma"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?#COMMAND
	.BYTE 0
W?#RANDOM::	.ZWORD "#rando"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?#RANDOM
	.BYTE 0
W?#RECORD::	.ZWORD "#recor"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?#RECORD
	.BYTE 0
W?#UNRECORD::	.ZWORD "#unrec"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?#UNRECORD
	.BYTE 0
W?QUOTE::	.ZWORD """"
	.BYTE PS?BUZZ-WORD
	.BYTE B?QUOTE
	.BYTE 0
W?A::	.ZWORD "a"
	.BYTE PS?BUZZ-WORD
	.BYTE B?A
	.BYTE 0
W?ABOUT::	.ZWORD "about"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?ABOUT
	.BYTE 0
W?ACROSS::	.ZWORD "across"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?ACROSS
	.BYTE 0
W?ACTIVATE::	.ZWORD "activa"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ACTIVATE
	.BYTE 0
W?ADVENTURER::	.ZWORD "advent"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?AGAIN::	.ZWORD "again"
	.BYTE PS?BUZZ-WORD
	.BYTE B?AGAIN
	.BYTE 0
W?AIR::	.ZWORD "air"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ALEMBIC::	.ZWORD "alembi"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ALL::	.ZWORD "all"
	.BYTE PS?BUZZ-WORD
	.BYTE B?ALL
	.BYTE 0
W?AN::	.ZWORD "an"
	.BYTE PS?BUZZ-WORD
	.BYTE B?AN
	.BYTE 0
W?AND::	.ZWORD "and"
	.BYTE PS?BUZZ-WORD
	.BYTE B?AND
	.BYTE 0
W?ANIMAL::	.ZWORD "animal"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ANSWER::	.ZWORD "answer"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ANSWER
	.BYTE 0
W?ANTIQUE::	.ZWORD "antiqu"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?ANTIQUE
	.BYTE 0
W?APPLY::	.ZWORD "apply"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?APPLY
	.BYTE 0
W?AQUARIUM::	.ZWORD "aquari"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ARBOR::	.ZWORD "arbor"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?AROUND::	.ZWORD "around"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?AROUND
	.BYTE 0
W?ART::	.ZWORD "art"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ASK::	.ZWORD "ask"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TELL
	.BYTE 0
W?AT::	.ZWORD "at"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?AT
	.BYTE 0
W?ATTACH::	.ZWORD "attach"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TIE
	.BYTE 0
W?ATTACK::	.ZWORD "attack"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ATTACK
	.BYTE 0
W?AVIATOR::	.ZWORD "aviato"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?AWAKE::	.ZWORD "awake"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WAKE
	.BYTE 0
W?AWAY::	.ZWORD "away"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?AWAY
	.BYTE 0
W?BABY::	.ZWORD "baby"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?BABY
	.BYTE 0
W?BACK::	.ZWORD "back"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BACK
	.BYTE 0
W?BAG::	.ZWORD "bag"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BALL::	.ZWORD "ball"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BALLOON::	.ZWORD "balloo"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BANISH::	.ZWORD "banish"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXORCISE
	.BYTE 0
W?BANK::	.ZWORD "bank"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?BANK
	.BYTE 0
W?BARE::	.ZWORD "bare"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?BARE
	.BYTE 0
W?BARF::	.ZWORD "barf"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CHOMP
	.BYTE 0
W?BARRED::	.ZWORD "barred"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?BARRED
	.BYTE 0
W?BASEBALL::	.ZWORD "baseba"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?BASEBALL
	.BYTE 0
W?BASKET::	.ZWORD "basket"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BAT::	.ZWORD "bat"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BATHE::	.ZWORD "bathe"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SWIM
	.BYTE 0
W?BEAUTIFUL::	.ZWORD "beauti"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?BEAUTIFUL
	.BYTE 0
W?BEGONE::	.ZWORD "begone"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXORCISE
	.BYTE 0
W?BEHIND::	.ZWORD "behind"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?BEHIND
	.BYTE 0
W?BELOW::	.ZWORD "below"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?UNDER
	.BYTE 0
W?BENCH::	.ZWORD "bench"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BENEATH::	.ZWORD "beneat"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?UNDER
	.BYTE 0
W?BILLS::	.ZWORD "bills"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BITE::	.ZWORD "bite"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EAT
	.BYTE 0
W?BLACK::	.ZWORD "black"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?BLACK
	.BYTE 0
W?BLADE::	.ZWORD "blade"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BLAST::	.ZWORD "blast"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BLAST
	.BYTE 0
W?BLESS::	.ZWORD "bless"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BLESSINGS::	.ZWORD "blessi"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BLOCK::	.ZWORD "block"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DESTROY
	.BYTE 0
W?BLOW::	.ZWORD "blow"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BLOW
	.BYTE 0
W?BLUE::	.ZWORD "blue"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?BLUE
	.BYTE 0
W?BOARD::	.ZWORD "board"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BOARD
	.BYTE 0
W?BOOK::	.ZWORD "book"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BOOKS::	.ZWORD "books"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BOTTLE::	.ZWORD "bottle"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BOX::	.ZWORD "box"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BRAIDED::	.ZWORD "braide"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?BRAIDED
	.BYTE 0
W?BRANDISH::	.ZWORD "brandi"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WAVE
	.BYTE 0
W?BRASS::	.ZWORD "brass"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?BRASS
	.BYTE 0
W?BREAK::	.ZWORD "break"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DESTROY
	.BYTE 0
W?BREATH::	.ZWORD "breath"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BRICK::	.ZWORD "brick"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BRIDGE::	.ZWORD "bridge"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BRIEF::	.ZWORD "brief"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BRIEF
	.BYTE 0
W?BROCHURE::	.ZWORD "brochu"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BROKEN::	.ZWORD "broken"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?BROKEN
	.BYTE 0
W?BRUSH::	.ZWORD "brush"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BRUSH
	.BYTE 0
W?BUCKET::	.ZWORD "bucket"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BUG::	.ZWORD "bug"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BUG
	.BYTE 0
W?BURN::	.ZWORD "burn"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BURN
	.BYTE 0
W?BUSH::	.ZWORD "bush"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?BUT::	.ZWORD "but"
	.BYTE PS?BUZZ-WORD
	.BYTE B?BUT
	.BYTE 0
W?BUTTON::	.ZWORD "button"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?C3PO::	.ZWORD "c3po"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CABINET::	.ZWORD "cabine"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CAGE::	.ZWORD "cage"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CAKE::	.ZWORD "cake"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CAKES::	.ZWORD "cakes"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CAN::	.ZWORD "can"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CANDIED::	.ZWORD "candie"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?CANDIED
	.BYTE 0
W?CANDLES::	.ZWORD "candle"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CANDY::	.ZWORD "candy"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CARD::	.ZWORD "card"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CARRY::	.ZWORD "carry"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TAKE
	.BYTE 0
W?CASE::	.ZWORD "case"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CAST::	.ZWORD "cast"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXORCISE
	.BYTE 0
W?CATCH::	.ZWORD "catch"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TAKE
	.BYTE 0
W?CERBERUS::	.ZWORD "cerber"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CHALK::	.ZWORD "chalk"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?CHALK
	.BYTE 0
W?CHANT::	.ZWORD "chant"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?INCANT
	.BYTE 0
W?CHASE::	.ZWORD "chase"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FOLLOW
	.BYTE 0
W?CHASM::	.ZWORD "chasm"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CHEST::	.ZWORD "chest"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CHINA::	.ZWORD "china"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?CHINA
	.BYTE 0
W?CHOMP::	.ZWORD "chomp"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CHOMP
	.BYTE 0
W?CHUCK::	.ZWORD "chuck"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?THROW
	.BYTE 0
W?CIRCLE::	.ZWORD "circle"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CLAY::	.ZWORD "clay"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?CLAY
	.BYTE 0
W?CLEAN::	.ZWORD "clean"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BRUSH
	.BYTE 0
W?CLEAR::	.ZWORD "clear"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?CLEAR
	.BYTE 0
W?CLIMB::	.ZWORD "climb"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CLIMB
	.BYTE 0
W?CLOSE::	.ZWORD "close"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CLOSE
	.BYTE 0
W?CLOTH::	.ZWORD "cloth"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?CLOTH
	.BYTE 0
W?CLUB::	.ZWORD "club"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?COBWEBBED::	.ZWORD "cobweb"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?COBWEBBED
	.BYTE 0
W?COIL::	.ZWORD "coil"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?COIN::	.ZWORD "coin"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?COLD::	.ZWORD "cold"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?COLD
	.BYTE 0
W?COLLAR::	.ZWORD "collar"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?COME::	.ZWORD "come"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FOLLOW
	.BYTE 0
W?COMMAND::	.ZWORD "comman"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?COMMAND
	.BYTE 0
W?COMPASS::	.ZWORD "compas"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CONSUME::	.ZWORD "consum"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EAT
	.BYTE 0
W?COUNT::	.ZWORD "count"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?COUNT
	.BYTE 0
W?COVER::	.ZWORD "cover"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CRACK::	.ZWORD "crack"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CRAWLWAY::	.ZWORD "crawlw"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CRETIN::	.ZWORD "cretin"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CROSS::	.ZWORD "cross"
	.BYTE PS?VERB+PS?DIRECTION+P1?DIRECTION
	.BYTE 18
	.BYTE ACT?CROSS
W?CROWN::	.ZWORD "crown"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CRYPT::	.ZWORD "crypt"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?OBJECT
	.BYTE O?ANY
	.BYTE A?CRYPT
W?CRYSTAL::	.ZWORD "crysta"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?CRYSTAL
	.BYTE 0
W?CUBE::	.ZWORD "cube"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CURSE::	.ZWORD "curse"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CURSE
	.BYTE 0
W?CURTAIN::	.ZWORD "curtai"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?CUT::	.ZWORD "cut"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CUT
	.BYTE 0
W?D::	.ZWORD "d"
	.BYTE PS?DIRECTION+PS?PREPOSITION+P1?OBJECT
	.BYTE PR?DOWN
	.BYTE 22
W?DAMAGE::	.ZWORD "damage"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DESTROY
	.BYTE 0
W?DAMN::	.ZWORD "damn"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CURSE
	.BYTE 0
W?DARK::	.ZWORD "dark"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?DARK
	.BYTE 0
W?DEAD::	.ZWORD "dead"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?DEAD
	.BYTE 0
W?DEEP::	.ZWORD "deep"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?DEEP
	.BYTE 0
W?DEFLATE::	.ZWORD "deflat"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DEFLATE
	.BYTE 0
W?DEGREE::	.ZWORD "degree"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?DELICATE::	.ZWORD "delica"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?DELICATE
	.BYTE 0
W?DEMON::	.ZWORD "demon"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?DENTED::	.ZWORD "dented"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?DENTED
	.BYTE 0
W?DEPOSIT::	.ZWORD "deposi"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?DEPOSIT
	.BYTE 0
W?DESCRIBE::	.ZWORD "descri"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXAMINE
	.BYTE 0
W?DESTROY::	.ZWORD "destro"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DESTROY
	.BYTE 0
W?DEVIL::	.ZWORD "devil"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?DIAGNOSE::	.ZWORD "diagno"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DIAGNOSE
	.BYTE 0
W?DIAMOND::	.ZWORD "diamon"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?DIAMOND
	.BYTE 0
W?DIG::	.ZWORD "dig"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DIG
	.BYTE 0
W?DIMLY::	.ZWORD "dimly"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?DIMLY
	.BYTE 0
W?DIPLOMA::	.ZWORD "diplom"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?DIRT::	.ZWORD "dirt"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?DISEMBARK::	.ZWORD "disemb"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DISEMBARK
	.BYTE 0
W?DISENCHANT::	.ZWORD "disenc"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DISENCHANT
	.BYTE 0
W?DISPATCH::	.ZWORD "dispat"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KILL
	.BYTE 0
W?DIVE::	.ZWORD "dive"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?JUMP
	.BYTE 0
W?DJINN::	.ZWORD "djinn"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?DOG::	.ZWORD "dog"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?DOG
	.BYTE O?ANY
W?DONATE::	.ZWORD "donate"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?GIVE
	.BYTE 0
W?DOOR::	.ZWORD "door"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?DOUSE::	.ZWORD "douse"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXTINGUISH
	.BYTE 0
W?DOWN::	.ZWORD "down"
	.BYTE PS?DIRECTION+PS?PREPOSITION+P1?OBJECT
	.BYTE PR?DOWN
	.BYTE 22
W?DRAGON::	.ZWORD "dragon"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?DRINK::	.ZWORD "drink"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DRINK
	.BYTE 0
W?DRIVE::	.ZWORD "drive"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXORCISE
	.BYTE 0
W?DROP::	.ZWORD "drop"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DROP
	.BYTE 0
W?DULL::	.ZWORD "dull"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?DULL
	.BYTE 0
W?DUSTY::	.ZWORD "dusty"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?DUSTY
	.BYTE 0
W?E::	.ZWORD "e"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?EAST
	.BYTE 30
W?EAST::	.ZWORD "east"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?EAST
	.BYTE 30
W?EASTERN::	.ZWORD "easter"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?EASTERN
	.BYTE 0
W?EAT::	.ZWORD "eat"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EAT
	.BYTE 0
W?ECHO::	.ZWORD "echo"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ECHO
	.BYTE 0
W?ELVISH::	.ZWORD "elvish"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?ELVISH
	.BYTE 0
W?ENCHANT::	.ZWORD "enchan"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ENCHANT
	.BYTE 0
W?ENORMOUS::	.ZWORD "enormo"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?ENORMOUS
	.BYTE 0
W?ENTER::	.ZWORD "enter"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ENTER
	.BYTE 0
W?ETCHINGS::	.ZWORD "etchin"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?EXAMINE::	.ZWORD "examin"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXAMINE
	.BYTE 0
W?EXCEPT::	.ZWORD "except"
	.BYTE PS?BUZZ-WORD
	.BYTE B?EXCEPT
	.BYTE 0
W?EXIT::	.ZWORD "exit"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXIT
	.BYTE 0
W?EXORCISE::	.ZWORD "exorci"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXORCISE
	.BYTE 0
W?EXTINGUISH::	.ZWORD "exting"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXTINGUISH
	.BYTE 0
W?F::	.ZWORD "f"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?OBJECT
	.BYTE O?ANY
	.BYTE A?F
W?FALL::	.ZWORD "fall"
	.BYTE PS?BUZZ-WORD
	.BYTE B?FALL
	.BYTE 0
W?FANCY::	.ZWORD "fancy"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?FANCY
	.BYTE 0
W?FANTASIZE::	.ZWORD "fantas"
	.BYTE PS?BUZZ-WORD
	.BYTE B?FANTASIZE
	.BYTE 0
W?FASTEN::	.ZWORD "fasten"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TIE
	.BYTE 0
W?FEAR::	.ZWORD "fear"
	.BYTE PS?BUZZ-WORD
	.BYTE B?FEAR
	.BYTE 0
W?FEEBLE::	.ZWORD "feeble"
	.BYTE PS?BUZZ-WORD
	.BYTE B?FEEBLE
	.BYTE 0
W?FEED::	.ZWORD "feed"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?GIVE
	.BYTE 0
W?FEEL::	.ZWORD "feel"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RUB
	.BYTE 0
W?FENCE::	.ZWORD "fence"
	.BYTE PS?BUZZ-WORD
	.BYTE B?FENCE
	.BYTE 0
W?FERMENT::	.ZWORD "fermen"
	.BYTE PS?BUZZ-WORD
	.BYTE B?FERMENT
	.BYTE 0
W?FIERCE::	.ZWORD "fierce"
	.BYTE PS?BUZZ-WORD
	.BYTE B?FIERCE
	.BYTE 0
W?FIGHT::	.ZWORD "fight"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ATTACK
	.BYTE 0
W?FILCH::	.ZWORD "filch"
	.BYTE PS?BUZZ-WORD
	.BYTE B?FILCH
	.BYTE 0
W?FILL::	.ZWORD "fill"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FILL
	.BYTE 0
W?FIND::	.ZWORD "find"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FIND
	.BYTE 0
W?FIREPROOF::	.ZWORD "firepr"
	.BYTE PS?BUZZ-WORD
	.BYTE B?FIREPROOF
	.BYTE 0
W?FIX::	.ZWORD "fix"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PLUG
	.BYTE 0
W?FLASK::	.ZWORD "flask"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?FLATHEAD::	.ZWORD "flathe"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?FLATHEAD
	.BYTE 0
W?FLIP::	.ZWORD "flip"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TURN
	.BYTE 0
W?FLOAT::	.ZWORD "float"
	.BYTE PS?BUZZ-WORD
	.BYTE B?FLOAT
	.BYTE 0
W?FLOOR::	.ZWORD "floor"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?FLOWING::	.ZWORD "flowin"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?FLOWING
	.BYTE 0
W?FLUORESCE::	.ZWORD "fluore"
	.BYTE PS?BUZZ-WORD
	.BYTE B?FLUORESCE
	.BYTE 0
W?FOLLOW::	.ZWORD "follow"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FOLLOW
	.BYTE 0
W?FOOBAR::	.ZWORD "foobar"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?FOOTPAD::	.ZWORD "footpa"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?FOR::	.ZWORD "for"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?FOR
	.BYTE 0
W?FORBIDDING::	.ZWORD "forbid"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?FORBIDDING
	.BYTE 0
W?FORD::	.ZWORD "ford"
	.BYTE PS?VERB+PS?DIRECTION+P1?DIRECTION
	.BYTE 18
	.BYTE ACT?CROSS
W?FOREST::	.ZWORD "forest"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?FOREST
	.BYTE 0
W?FREE::	.ZWORD "free"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?UNTIE
	.BYTE 0
W?FREEZE::	.ZWORD "freeze"
	.BYTE PS?BUZZ-WORD
	.BYTE B?FREEZE
	.BYTE 0
W?FROBOZZ::	.ZWORD "froboz"
	.BYTE PS?VERB+PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?FROBOZZ
	.BYTE ACT?FROBOZZ
W?FROM::	.ZWORD "from"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?FROM
	.BYTE 0
W?FROSTED::	.ZWORD "froste"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?FROSTED
	.BYTE 0
W?FROTZ::	.ZWORD "frotz"
	.BYTE PS?BUZZ-WORD
	.BYTE B?FROTZ
	.BYTE 0
W?FRY::	.ZWORD "fry"
	.BYTE PS?BUZZ-WORD
	.BYTE B?FRY
	.BYTE 0
W?FUCK::	.ZWORD "fuck"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CURSE
	.BYTE 0
W?FUDGE::	.ZWORD "fudge"
	.BYTE PS?BUZZ-WORD
	.BYTE B?FUDGE
	.BYTE 0
W?FUMBLE::	.ZWORD "fumble"
	.BYTE PS?BUZZ-WORD
	.BYTE B?FUMBLE
	.BYTE 0
W?FUSE::	.ZWORD "fuse"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?G::	.ZWORD "g"
	.BYTE PS?BUZZ-WORD
	.BYTE B?G
	.BYTE 0
W?GAUDY::	.ZWORD "gaudy"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?GAUDY
	.BYTE 0
W?GAZE::	.ZWORD "gaze"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LOOK
	.BYTE 0
W?GAZEBO::	.ZWORD "gazebo"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?GENIE::	.ZWORD "genie"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?GET::	.ZWORD "get"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TAKE
	.BYTE 0
W?GIANT::	.ZWORD "giant"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?GIANT
	.BYTE 0
W?GIVE::	.ZWORD "give"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?GIVE
	.BYTE 0
W?GLACIER::	.ZWORD "glacie"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?GLAMDRING::	.ZWORD "glamdr"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?GLASS::	.ZWORD "glass"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?OBJECT
	.BYTE O?ANY
	.BYTE A?GLASS
W?GLOSSY::	.ZWORD "glossy"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?GLOSSY
	.BYTE 0
W?GLOWING::	.ZWORD "glowin"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?GLOWING
	.BYTE 0
W?GLUE::	.ZWORD "glue"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PLUG
	.BYTE 0
W?GNOME::	.ZWORD "gnome"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?GO::	.ZWORD "go"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WALK
	.BYTE 0
W?GOLD::	.ZWORD "gold"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?GOLD
	.BYTE O?ANY
W?GRAB::	.ZWORD "grab"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TAKE
	.BYTE 0
W?GRACES::	.ZWORD "graces"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?GRASSHOPPERS::	.ZWORD "grassh"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?GRAVE::	.ZWORD "grave"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?GREASE::	.ZWORD "grease"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LUBRICATE
	.BYTE 0
W?GREAT::	.ZWORD "great"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?GREAT
	.BYTE 0
W?GREEN::	.ZWORD "green"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?GREEN
	.BYTE 0
W?GROUND::	.ZWORD "ground"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?GRUE::	.ZWORD "grue"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?GRUE
	.BYTE O?ANY
W?GUARDIAN::	.ZWORD "guardi"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?H2O::	.ZWORD "h2o"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HAND::	.ZWORD "hand"
	.BYTE PS?OBJECT+PS?VERB+P1?OBJECT
	.BYTE O?ANY
	.BYTE ACT?GIVE
W?HANDS::	.ZWORD "hands"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HANDSOME::	.ZWORD "handso"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?HANDSOME
	.BYTE 0
W?HATCH::	.ZWORD "hatch"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?HATCH
	.BYTE 0
W?HEAD::	.ZWORD "head"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HEADED::	.ZWORD "headed"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?HEADED
	.BYTE 0
W?HEADS::	.ZWORD "heads"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HEAVY::	.ZWORD "heavy"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?HEAVY
	.BYTE 0
W?HEDGE::	.ZWORD "hedge"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HEDGES::	.ZWORD "hedges"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HELLO::	.ZWORD "hello"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?HELLO
	.BYTE 0
W?HER::	.ZWORD "her"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HERE::	.ZWORD "here"
	.BYTE PS?BUZZ-WORD
	.BYTE B?HERE
	.BYTE 0
W?HI::	.ZWORD "hi"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?HELLO
	.BYTE 0
W?HIDE::	.ZWORD "hide"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PUT
	.BYTE 0
W?HIM::	.ZWORD "him"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HIT::	.ZWORD "hit"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ATTACK
	.BYTE 0
W?HOLD::	.ZWORD "hold"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TAKE
	.BYTE 0
W?HOLE::	.ZWORD "hole"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HOMUNCULI::	.ZWORD "homunc"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HOOK::	.ZWORD "hook"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HOP::	.ZWORD "hop"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SKIP
	.BYTE 0
W?HOUND::	.ZWORD "hound"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?HUGE::	.ZWORD "huge"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?HUGE
	.BYTE 0
W?HUNGRY::	.ZWORD "hungry"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?HUNGRY
	.BYTE 0
W?HURL::	.ZWORD "hurl"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?THROW
	.BYTE 0
W?HURT::	.ZWORD "hurt"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ATTACK
	.BYTE 0
W?I::	.ZWORD "i"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?INVENTORY
	.BYTE 0
W?ICE::	.ZWORD "ice"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ICING::	.ZWORD "icing"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ICY::	.ZWORD "icy"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?ICY
	.BYTE 0
W?IGNITE::	.ZWORD "ignite"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BURN
	.BYTE 0
W?IMBIBE::	.ZWORD "imbibe"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DRINK
	.BYTE 0
W?IN::	.ZWORD "in"
	.BYTE PS?DIRECTION+PS?PREPOSITION+P1?OBJECT
	.BYTE PR?IN
	.BYTE 21
W?INCANT::	.ZWORD "incant"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?INCANT
	.BYTE 0
W?INCINERATE::	.ZWORD "incine"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?BURN
	.BYTE 0
W?INFLAT::	.ZWORD "inflat"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?INFLAT
	.BYTE 0
W?INJURE::	.ZWORD "injure"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ATTACK
	.BYTE 0
W?INSERT::	.ZWORD "insert"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PUT
	.BYTE 0
W?INSIDE::	.ZWORD "inside"
	.BYTE PS?DIRECTION+PS?PREPOSITION+P1?OBJECT
	.BYTE PR?IN
	.BYTE 21
W?INSTRUCTIONS::	.ZWORD "instru"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?INTNUM::	.ZWORD "intnum"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?INTO::	.ZWORD "into"
	.BYTE PS?DIRECTION+PS?PREPOSITION+P1?OBJECT
	.BYTE PR?IN
	.BYTE 21
W?INVENTORY::	.ZWORD "invent"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?INVENTORY
	.BYTE 0
W?IRON::	.ZWORD "iron"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?IRON
	.BYTE 0
W?IS::	.ZWORD "is"
	.BYTE PS?BUZZ-WORD
	.BYTE B?IS
	.BYTE 0
W?IT::	.ZWORD "it"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?JUMP::	.ZWORD "jump"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?JUMP
	.BYTE 0
W?KEEPER::	.ZWORD "keeper"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?KEY::	.ZWORD "key"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?KEYHOLE::	.ZWORD "keyhol"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?KICK::	.ZWORD "kick"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KICK
	.BYTE 0
W?KILL::	.ZWORD "kill"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KILL
	.BYTE 0
W?KISS::	.ZWORD "kiss"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KISS
	.BYTE 0
W?KNIVES::	.ZWORD "knives"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?KNOCK::	.ZWORD "knock"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KNOCK
	.BYTE 0
W?KREBF::	.ZWORD "krebf"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?L::	.ZWORD "l"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LOOK
	.BYTE 0
W?LABEL::	.ZWORD "label"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?LADY::	.ZWORD "lady"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?LAMP::	.ZWORD "lamp"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?LAND::	.ZWORD "land"
	.BYTE PS?DIRECTION+P1?DIRECTION
	.BYTE 19
	.BYTE 0
W?LANTERN::	.ZWORD "lanter"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?LARGE::	.ZWORD "large"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?LARGE
	.BYTE 0
W?LAUNCH::	.ZWORD "launch"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LAUNCH
	.BYTE 0
W?LEAK::	.ZWORD "leak"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?LEAN::	.ZWORD "lean"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LEAN
	.BYTE 0
W?LEAP::	.ZWORD "leap"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?JUMP
	.BYTE 0
W?LEATHER::	.ZWORD "leathe"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?LEATHER
	.BYTE 0
W?LEAVE::	.ZWORD "leave"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LEAVE
	.BYTE 0
W?LETTER::	.ZWORD "letter"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?OBJECT
	.BYTE O?ANY
	.BYTE A?LETTER
W?LID::	.ZWORD "lid"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?LIFT::	.ZWORD "lift"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RAISE
	.BYTE 0
W?LIGHT::	.ZWORD "light"
	.BYTE PS?OBJECT+PS?VERB+P1?OBJECT
	.BYTE O?ANY
	.BYTE ACT?LIGHT
W?LIQUID::	.ZWORD "liquid"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?LIQUIFY::	.ZWORD "liquif"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?MELT
	.BYTE 0
W?LISTEN::	.ZWORD "listen"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LISTEN
	.BYTE 0
W?LITTLE::	.ZWORD "little"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?LITTLE
	.BYTE 0
W?LIZARD::	.ZWORD "lizard"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?LOCK::	.ZWORD "lock"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LOCK
	.BYTE 0
W?LONG::	.ZWORD "long"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?LONG
	.BYTE 0
W?LOOK::	.ZWORD "look"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LOOK
	.BYTE 0
W?LOSE::	.ZWORD "lose"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CHOMP
	.BYTE 0
W?LOWER::	.ZWORD "lower"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LOWER
	.BYTE 0
W?LUBRICATE::	.ZWORD "lubric"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LUBRICATE
	.BYTE 0
W?LUNGS::	.ZWORD "lungs"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?LURKING::	.ZWORD "lurkin"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?LURKING
	.BYTE 0
W?MAGIC::	.ZWORD "magic"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?MAGIC
	.BYTE 0
W?MAGICIAN::	.ZWORD "magici"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MAKE::	.ZWORD "make"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?MAKE
	.BYTE 0
W?MAN::	.ZWORD "man"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MANGLED::	.ZWORD "mangle"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?MANGLED
	.BYTE 0
W?MANY::	.ZWORD "many"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?MANY
	.BYTE 0
W?MARBLE::	.ZWORD "marble"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?MARBLE
	.BYTE 0
W?MASS::	.ZWORD "mass"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MAT::	.ZWORD "mat"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MATCH::	.ZWORD "match"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MATCHBOOK::	.ZWORD "matchb"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MATCHES::	.ZWORD "matche"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ME::	.ZWORD "me"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MELT::	.ZWORD "melt"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?MELT
	.BYTE 0
W?MENHIR::	.ZWORD "menhir"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?METAL::	.ZWORD "metal"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?METAL
	.BYTE 0
W?MOBY::	.ZWORD "moby"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?MOBY
	.BYTE 0
W?MOLEST::	.ZWORD "molest"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RAPE
	.BYTE 0
W?MONEY::	.ZWORD "money"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MONSTER::	.ZWORD "monste"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MORTAR::	.ZWORD "mortar"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MOSS::	.ZWORD "moss"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MOSSES::	.ZWORD "mosses"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MOUTH::	.ZWORD "mouth"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?MOVE::	.ZWORD "move"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?MOVE
	.BYTE 0
W?MUMBLE::	.ZWORD "mumble"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?MUMBLE
	.BYTE 0
W?MURDER::	.ZWORD "murder"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KILL
	.BYTE 0
W?MYSELF::	.ZWORD "myself"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?N::	.ZWORD "n"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?NORTH
	.BYTE 31
W?NARROW::	.ZWORD "narrow"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?NARROW
	.BYTE 0
W?NASTY::	.ZWORD "nasty"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?NASTY
	.BYTE 0
W?NE::	.ZWORD "ne"
	.BYTE PS?DIRECTION+P1?DIRECTION
	.BYTE 27
	.BYTE 0
W?NEAT::	.ZWORD "neat"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?NEAT
	.BYTE 0
W?NECKLACE::	.ZWORD "neckla"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?NEWS::	.ZWORD "news"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?NEWS
	.BYTE 0
W?NEWSPAPER::	.ZWORD "newspa"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?OBJECT
	.BYTE O?ANY
	.BYTE A?NEWSPAPER
W?NICKED::	.ZWORD "nicked"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?NICKED
	.BYTE 0
W?NO::	.ZWORD "no"
	.BYTE PS?BUZZ-WORD
	.BYTE B?NO
	.BYTE 0
W?NORTH::	.ZWORD "north"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?NORTH
	.BYTE 31
W?NORTHE::	.ZWORD "northe"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?NORTHE
	.BYTE 27
W?NORTHWEST::	.ZWORD "northw"
	.BYTE PS?DIRECTION+P1?DIRECTION
	.BYTE 26
	.BYTE 0
W?NOTE::	.ZWORD "note"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?NW::	.ZWORD "nw"
	.BYTE PS?DIRECTION+P1?DIRECTION
	.BYTE 26
	.BYTE 0
W?OAK::	.ZWORD "oak"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?OAK
	.BYTE 0
W?OBLONG::	.ZWORD "oblong"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?OBLONG
	.BYTE 0
W?OBSIDIAN::	.ZWORD "obsidi"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?OBSIDIAN
	.BYTE 0
W?ODYSSEUS::	.ZWORD "odysse"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ODYSSEUS
	.BYTE 0
W?OF::	.ZWORD "of"
	.BYTE PS?BUZZ-WORD
	.BYTE B?OF
	.BYTE 0
W?OFF::	.ZWORD "off"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?OFF
	.BYTE 0
W?OFFER::	.ZWORD "offer"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?GIVE
	.BYTE 0
W?OIL::	.ZWORD "oil"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LUBRICATE
	.BYTE 0
W?OLD::	.ZWORD "old"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?OLD
	.BYTE 0
W?ON::	.ZWORD "on"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?ON
	.BYTE 0
W?ONE::	.ZWORD "one"
	.BYTE PS?BUZZ-WORD
	.BYTE B?ONE
	.BYTE 0
W?ONTO::	.ZWORD "onto"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?ON
	.BYTE 0
W?OOPS::	.ZWORD "oops"
	.BYTE PS?BUZZ-WORD
	.BYTE B?OOPS
	.BYTE 0
W?OPEN::	.ZWORD "open"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?OPEN
	.BYTE 0
W?OPENER::	.ZWORD "opener"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ORANGE::	.ZWORD "orange"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?ORANGE
	.BYTE 0
W?ORCRIST::	.ZWORD "orcris"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?OUT::	.ZWORD "out"
	.BYTE PS?DIRECTION+PS?PREPOSITION+P1?OBJECT
	.BYTE PR?OUT
	.BYTE 20
W?OVER::	.ZWORD "over"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?OVER
	.BYTE 0
W?OWL::	.ZWORD "owl"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?OZMOO::	.ZWORD "ozmoo"
	.BYTE PS?BUZZ-WORD
	.BYTE B?OZMOO
	.BYTE 0
W?PACKAGE::	.ZWORD "packag"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PAINTING::	.ZWORD "painti"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PAIR::	.ZWORD "pair"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PALANTIR::	.ZWORD "palant"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PAPER::	.ZWORD "paper"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PASSAGE::	.ZWORD "passag"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PAT::	.ZWORD "pat"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RUB
	.BYTE 0
W?PATCH::	.ZWORD "patch"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PLUG
	.BYTE 0
W?PATH::	.ZWORD "path"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PEAL::	.ZWORD "peal"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RING
	.BYTE 0
W?PEARL::	.ZWORD "pearl"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?PEARL
	.BYTE 0
W?PEARLS::	.ZWORD "pearls"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PENTAGRAM::	.ZWORD "pentag"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PERFECT::	.ZWORD "perfec"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?PERFECT
	.BYTE 0
W?PESTLE::	.ZWORD "pestle"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PET::	.ZWORD "pet"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RUB
	.BYTE 0
W?PHOSPHORESCENT::	.ZWORD "phosph"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?PHOSPHORESCENT
	.BYTE 0
W?PICK::	.ZWORD "pick"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PICK
	.BYTE 0
W?PIECE::	.ZWORD "piece"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PIERCE::	.ZWORD "pierce"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CUT
	.BYTE 0
W?PLACE::	.ZWORD "place"
	.BYTE PS?VERB+PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?PLACE
	.BYTE ACT?PUT
W?PLACEM::	.ZWORD "placem"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PLAY::	.ZWORD "play"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PLAY
	.BYTE 0
W?PLUG::	.ZWORD "plug"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PLUG
	.BYTE 0
W?PLUGH::	.ZWORD "plugh"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PLUGH
	.BYTE 0
W?POKE::	.ZWORD "poke"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?POKE
	.BYTE 0
W?POLE::	.ZWORD "pole"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?POLES::	.ZWORD "poles"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?POOL::	.ZWORD "pool"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PORTRAIT::	.ZWORD "portra"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?POST::	.ZWORD "post"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?POSTS::	.ZWORD "posts"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?POT::	.ZWORD "pot"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?POUR::	.ZWORD "pour"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?POUR
	.BYTE 0
W?PRAY::	.ZWORD "pray"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PRAY
	.BYTE 0
W?PRESS::	.ZWORD "press"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PUSH
	.BYTE 0
W?PRICELESS::	.ZWORD "pricel"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?PRICELESS
	.BYTE 0
W?PRINCESS::	.ZWORD "prince"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?PROCEED::	.ZWORD "procee"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WALK
	.BYTE 0
W?PULL::	.ZWORD "pull"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PULL
	.BYTE 0
W?PUMP::	.ZWORD "pump"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PUMP
	.BYTE 0
W?PUNCTURE::	.ZWORD "punctu"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PUNCTURE
	.BYTE 0
W?PURPLE::	.ZWORD "purple"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?PURPLE
	.BYTE 0
W?PURSUE::	.ZWORD "pursue"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FOLLOW
	.BYTE 0
W?PUSH::	.ZWORD "push"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PUSH
	.BYTE 0
W?PUT::	.ZWORD "put"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PUT
	.BYTE 0
W?Q::	.ZWORD "q"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?QUIT
	.BYTE 0
W?QUANTITY::	.ZWORD "quanti"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?QUIT::	.ZWORD "quit"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?QUIT
	.BYTE 0
W?R2D2::	.ZWORD "r2d2"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?RACK::	.ZWORD "rack"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?RAISE::	.ZWORD "raise"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RAISE
	.BYTE 0
W?RAP::	.ZWORD "rap"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KNOCK
	.BYTE 0
W?RAPE::	.ZWORD "rape"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RAPE
	.BYTE 0
W?RARE::	.ZWORD "rare"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?RARE
	.BYTE 0
W?RAVINE::	.ZWORD "ravine"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?READ::	.ZWORD "read"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?READ
	.BYTE 0
W?RECEPTACLE::	.ZWORD "recept"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?RED::	.ZWORD "red"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?RED
	.BYTE 0
W?RELEASE::	.ZWORD "releas"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?UNTIE
	.BYTE 0
W?REMOVE::	.ZWORD "remove"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TAKE
	.BYTE 0
W?REPAIR::	.ZWORD "repair"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PLUG
	.BYTE 0
W?REPELLENT::	.ZWORD "repell"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?REPENT::	.ZWORD "repent"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?REPENT
	.BYTE 0
W?REPLY::	.ZWORD "reply"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ANSWER
	.BYTE 0
W?RESTART::	.ZWORD "restar"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RESTART
	.BYTE 0
W?RESTORE::	.ZWORD "restor"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RESTORE
	.BYTE 0
W?RIBBON::	.ZWORD "ribbon"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?RICKETY::	.ZWORD "ricket"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?RICKETY
	.BYTE 0
W?RIDDLE::	.ZWORD "riddle"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?RING::	.ZWORD "ring"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RING
	.BYTE 0
W?ROBBY::	.ZWORD "robby"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ROBOT::	.ZWORD "robot"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ROCK::	.ZWORD "rock"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ROLL::	.ZWORD "roll"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ROLL
	.BYTE 0
W?ROPE::	.ZWORD "rope"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ROSE::	.ZWORD "rose"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?ROSE
	.BYTE O?ANY
W?ROSES::	.ZWORD "roses"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?ROTTEN::	.ZWORD "rotten"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?ROTTEN
	.BYTE 0
W?ROUND::	.ZWORD "round"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?ROUND
	.BYTE 0
W?RUB::	.ZWORD "rub"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RUB
	.BYTE 0
W?RUBY::	.ZWORD "ruby"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?RUBY
	.BYTE O?ANY
W?RUN::	.ZWORD "run"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WALK
	.BYTE 0
W?RUSTY::	.ZWORD "rusty"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?RUSTY
	.BYTE 0
W?S::	.ZWORD "s"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?SOUTH
	.BYTE 28
W?SAFE::	.ZWORD "safe"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SAFETY::	.ZWORD "safety"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SAFETY
	.BYTE 0
W?SAILOR::	.ZWORD "sailor"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SAND::	.ZWORD "sand"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SAPPHIRE::	.ZWORD "sapphi"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SAPPHIRE
	.BYTE 0
W?SATIN::	.ZWORD "satin"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SATIN
	.BYTE 0
W?SAVE::	.ZWORD "save"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SAVE
	.BYTE 0
W?SAY::	.ZWORD "say"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SAY
	.BYTE 0
W?SCORE::	.ZWORD "score"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SCORE
	.BYTE 0
W?SCREAM::	.ZWORD "scream"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?YELL
	.BYTE 0
W?SCRIPT::	.ZWORD "script"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SCRIPT
	.BYTE 0
W?SE::	.ZWORD "se"
	.BYTE PS?DIRECTION+P1?DIRECTION
	.BYTE 25
	.BYTE 0
W?SEA::	.ZWORD "sea"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SEA
	.BYTE 0
W?SEARCH::	.ZWORD "search"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SEARCH
	.BYTE 0
W?SECRET::	.ZWORD "secret"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SECRET
	.BYTE 0
W?SECURE::	.ZWORD "secure"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TIE
	.BYTE 0
W?SEE::	.ZWORD "see"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FIND
	.BYTE 0
W?SEEK::	.ZWORD "seek"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FIND
	.BYTE 0
W?SELF::	.ZWORD "self"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SEND::	.ZWORD "send"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SEND
	.BYTE 0
W?SERPENT::	.ZWORD "serpen"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SET::	.ZWORD "set"
	.BYTE PS?OBJECT+PS?VERB+P1?OBJECT
	.BYTE O?ANY
	.BYTE ACT?TURN
W?SHAKE::	.ZWORD "shake"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SHAKE
	.BYTE 0
W?SHIMMERING::	.ZWORD "shimme"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SHIMMERING
	.BYTE 0
W?SHIT::	.ZWORD "shit"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CURSE
	.BYTE 0
W?SHOUT::	.ZWORD "shout"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?YELL
	.BYTE 0
W?SHUT::	.ZWORD "shut"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TURN
	.BYTE 0
W?SIGH::	.ZWORD "sigh"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?MUMBLE
	.BYTE 0
W?SILENT::	.ZWORD "silent"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SILENT
	.BYTE 0
W?SINISTER::	.ZWORD "sinist"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SINISTER
	.BYTE 0
W?SIT::	.ZWORD "sit"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CLIMB
	.BYTE 0
W?SKIM::	.ZWORD "skim"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?READ
	.BYTE 0
W?SKIP::	.ZWORD "skip"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SKIP
	.BYTE 0
W?SLAY::	.ZWORD "slay"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KILL
	.BYTE 0
W?SLICE::	.ZWORD "slice"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?CUT
	.BYTE 0
W?SLIDE::	.ZWORD "slide"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SLIDE
	.BYTE 0
W?SLOT::	.ZWORD "slot"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SMALL::	.ZWORD "small"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SMALL
	.BYTE 0
W?SMASH::	.ZWORD "smash"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DESTROY
	.BYTE 0
W?SMAUG::	.ZWORD "smaug"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SMELL::	.ZWORD "smell"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SMELL
	.BYTE 0
W?SMOKY::	.ZWORD "smoky"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SMOKY
	.BYTE 0
W?SNAKE::	.ZWORD "snake"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SNIFF::	.ZWORD "sniff"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SMELL
	.BYTE 0
W?SOLID::	.ZWORD "solid"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SOLID
	.BYTE 0
W?SORCEROR::	.ZWORD "sorcer"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SOUTH::	.ZWORD "south"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?SOUTH
	.BYTE 28
W?SOUTHE::	.ZWORD "southe"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?SOUTHE
	.BYTE 25
W?SOUTHWEST::	.ZWORD "southw"
	.BYTE PS?DIRECTION+P1?DIRECTION
	.BYTE 24
	.BYTE 0
W?SPHERE::	.ZWORD "sphere"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SPILL::	.ZWORD "spill"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?POUR
	.BYTE 0
W?SPIN::	.ZWORD "spin"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SPIN
	.BYTE 0
W?SPRAY::	.ZWORD "spray"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SPRAY
	.BYTE 0
W?SQUARE::	.ZWORD "square"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?SQUARE
	.BYTE 0
W?SQUEEZE::	.ZWORD "squeez"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SQUEEZE
	.BYTE 0
W?STAB::	.ZWORD "stab"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?STAB
	.BYTE 0
W?STACK::	.ZWORD "stack"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STAIRCASE::	.ZWORD "stairc"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STAIRS::	.ZWORD "stairs"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STAIRWAY::	.ZWORD "stairw"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STALACTITE::	.ZWORD "stalac"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STALAGMITE::	.ZWORD "stalag"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STAMP::	.ZWORD "stamp"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STAND::	.ZWORD "stand"
	.BYTE PS?OBJECT+PS?VERB+P1?OBJECT
	.BYTE O?ANY
	.BYTE ACT?STAND
W?STANDS::	.ZWORD "stands"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STAR::	.ZWORD "star"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STARE::	.ZWORD "stare"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?LOOK
	.BYTE 0
W?STARTLE::	.ZWORD "startl"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WAKE
	.BYTE 0
W?STATUETTE::	.ZWORD "statue"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STAY::	.ZWORD "stay"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?STAY
	.BYTE 0
W?STEEL::	.ZWORD "steel"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?STEEL
	.BYTE 0
W?STEEP::	.ZWORD "steep"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?STEEP
	.BYTE 0
W?STEP::	.ZWORD "step"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WALK
	.BYTE 0
W?STEPS::	.ZWORD "steps"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STONE::	.ZWORD "stone"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?STONE
	.BYTE O?ANY
W?STRADIVARIUS::	.ZWORD "stradi"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STRANGE::	.ZWORD "strang"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?STRANGE
	.BYTE 0
W?STREAM::	.ZWORD "stream"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STRIKE::	.ZWORD "strike"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?STRIKE
	.BYTE 0
W?STRING::	.ZWORD "string"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STRUCTURE::	.ZWORD "struct"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?STUFF::	.ZWORD "stuff"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PUT
	.BYTE 0
W?SUPER::	.ZWORD "super"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SUPER
	.BYTE 0
W?SUPERBRIEF::	.ZWORD "superb"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SUPER
	.BYTE 0
W?SURPRISE::	.ZWORD "surpri"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WAKE
	.BYTE 0
W?SW::	.ZWORD "sw"
	.BYTE PS?DIRECTION+P1?DIRECTION
	.BYTE 24
	.BYTE 0
W?SWALLOW::	.ZWORD "swallo"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?DRINK
	.BYTE 0
W?SWIM::	.ZWORD "swim"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SWIM
	.BYTE 0
W?SWING::	.ZWORD "swing"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SWING
	.BYTE 0
W?SWORD::	.ZWORD "sword"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?SWORDS::	.ZWORD "swords"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?TABLE::	.ZWORD "table"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?TAKE::	.ZWORD "take"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TAKE
	.BYTE 0
W?TALK::	.ZWORD "talk"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TALK
	.BYTE 0
W?TASTE::	.ZWORD "taste"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EAT
	.BYTE 0
W?TAUNT::	.ZWORD "taunt"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?KICK
	.BYTE 0
W?TEA::	.ZWORD "tea"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?TEA
	.BYTE 0
W?TEAPOT::	.ZWORD "teapot"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?TEARS::	.ZWORD "tears"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?TELL::	.ZWORD "tell"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TELL
	.BYTE 0
W?TEMPLE::	.ZWORD "temple"
	.BYTE PS?OBJECT+PS?VERB+P1?OBJECT
	.BYTE O?ANY
	.BYTE ACT?TREASURE
W?THE::	.ZWORD "the"
	.BYTE PS?BUZZ-WORD
	.BYTE B?THE
	.BYTE 0
W?THEM::	.ZWORD "them"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?THEN::	.ZWORD "then"
	.BYTE PS?BUZZ-WORD
	.BYTE B?THEN
	.BYTE 0
W?THIN::	.ZWORD "thin"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?THIN
	.BYTE 0
W?THREE::	.ZWORD "three"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?THREE
	.BYTE 0
W?THROUGH::	.ZWORD "throug"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?WITH
	.BYTE 0
W?THROW::	.ZWORD "throw"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?THROW
	.BYTE 0
W?THRU::	.ZWORD "thru"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?WITH
	.BYTE 0
W?THRUST::	.ZWORD "thrust"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SWING
	.BYTE 0
W?TIE::	.ZWORD "tie"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TIE
	.BYTE 0
W?TO::	.ZWORD "to"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?TO
	.BYTE 0
W?TOMB::	.ZWORD "tomb"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?TOSS::	.ZWORD "toss"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?THROW
	.BYTE 0
W?TOUCH::	.ZWORD "touch"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?RUB
	.BYTE 0
W?TRAIL::	.ZWORD "trail"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?TREASURE::	.ZWORD "treasu"
	.BYTE PS?OBJECT+PS?VERB+P1?OBJECT
	.BYTE O?ANY
	.BYTE ACT?TREASURE
W?TRIANGULAR::	.ZWORD "triang"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?TRIANGULAR
	.BYTE 0
W?TROPHY::	.ZWORD "trophy"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?TROPHY
	.BYTE 0
W?TRUNK::	.ZWORD "trunk"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?TUG::	.ZWORD "tug"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PULL
	.BYTE 0
W?TUNNEL::	.ZWORD "tunnel"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?TURN::	.ZWORD "turn"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?TURN
	.BYTE 0
W?U::	.ZWORD "u"
	.BYTE PS?DIRECTION+PS?PREPOSITION+P1?OBJECT
	.BYTE PR?UP
	.BYTE 23
W?ULYSSES::	.ZWORD "ulysse"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?ODYSSEUS
	.BYTE 0
W?UNATTACH::	.ZWORD "unatta"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?UNTIE
	.BYTE 0
W?UNDER::	.ZWORD "under"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?UNDER
	.BYTE 0
W?UNDERNEATH::	.ZWORD "undern"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?UNDER
	.BYTE 0
W?UNFASTEN::	.ZWORD "unfast"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?UNTIE
	.BYTE 0
W?UNHOOK::	.ZWORD "unhook"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?UNTIE
	.BYTE 0
W?UNICORN::	.ZWORD "unicor"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?UNLOCK::	.ZWORD "unlock"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?UNLOCK
	.BYTE 0
W?UNSCRIPT::	.ZWORD "unscri"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?UNSCRIPT
	.BYTE 0
W?UNTIE::	.ZWORD "untie"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?UNTIE
	.BYTE 0
W?UP::	.ZWORD "up"
	.BYTE PS?DIRECTION+PS?PREPOSITION+P1?OBJECT
	.BYTE PR?UP
	.BYTE 23
W?USED::	.ZWORD "used"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?USED
	.BYTE 0
W?USING::	.ZWORD "using"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?WITH
	.BYTE 0
W?VAULT::	.ZWORD "vault"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?VELLUM::	.ZWORD "vellum"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?VELVET::	.ZWORD "velvet"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?VELVET
	.BYTE 0
W?VERBOSE::	.ZWORD "verbos"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?VERBOSE
	.BYTE 0
W?VERSION::	.ZWORD "versio"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?VERSION
	.BYTE 0
W?VIOLIN::	.ZWORD "violin"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?VOLCANO::	.ZWORD "volcan"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?VOLCANO
	.BYTE 0
W?W::	.ZWORD "w"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?WEST
	.BYTE 29
W?WADE::	.ZWORD "wade"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?SWIM
	.BYTE 0
W?WAIT::	.ZWORD "wait"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WAIT
	.BYTE 0
W?WAKE::	.ZWORD "wake"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WAKE
	.BYTE 0
W?WALK::	.ZWORD "walk"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WALK
	.BYTE 0
W?WALL::	.ZWORD "wall"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?WAND::	.ZWORD "wand"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?WANDS::	.ZWORD "wands"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?WARNING::	.ZWORD "warnin"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WARNING
	.BYTE 0
W?WATER::	.ZWORD "water"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?WAVE::	.ZWORD "wave"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WAVE
	.BYTE 0
W?WAX::	.ZWORD "wax"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WAX
	.BYTE 0
W?WEAR::	.ZWORD "wear"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WEAR
	.BYTE 0
W?WELL::	.ZWORD "well"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?WEST::	.ZWORD "west"
	.BYTE PS?ADJECTIVE+PS?DIRECTION+P1?ADJECTIVE
	.BYTE A?WEST
	.BYTE 29
W?WESTERN::	.ZWORD "wester"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WESTERN
	.BYTE 0
W?WHAT::	.ZWORD "what"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXAMINE
	.BYTE 0
W?WHATS::	.ZWORD "whats"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?EXAMINE
	.BYTE 0
W?WHERE::	.ZWORD "where"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?FIND
	.BYTE 0
W?WHITE::	.ZWORD "white"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WHITE
	.BYTE 0
W?WICKER::	.ZWORD "wicker"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WICKER
	.BYTE 0
W?WIN::	.ZWORD "win"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WIN
	.BYTE 0
W?WIND::	.ZWORD "wind"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WIND
	.BYTE 0
W?WINDING::	.ZWORD "windin"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WINDING
	.BYTE 0
W?WINDOW::	.ZWORD "window"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?WINNAGE::	.ZWORD "winnag"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WIN
	.BYTE 0
W?WIRE::	.ZWORD "wire"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?WISH::	.ZWORD "wish"
	.BYTE PS?OBJECT+PS?VERB+P1?OBJECT
	.BYTE O?ANY
	.BYTE ACT?WISH
W?WITH::	.ZWORD "with"
	.BYTE PS?PREPOSITION+P1?OBJECT
	.BYTE PR?WITH
	.BYTE 0
W?WIZARD::	.ZWORD "wizard"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WIZARD
	.BYTE O?ANY
W?WOMAN::	.ZWORD "woman"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?WOODEN::	.ZWORD "wooden"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WOODEN
	.BYTE 0
W?WORK::	.ZWORD "work"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WORK
	.BYTE 0
W?WORKBENCH::	.ZWORD "workbe"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?WORM::	.ZWORD "worm"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
W?WORN::	.ZWORD "worn"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?WORN
	.BYTE 0
W?XYZZY::	.ZWORD "xyzzy"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PLUGH
	.BYTE 0
W?Y::	.ZWORD "y"
	.BYTE PS?BUZZ-WORD
	.BYTE B?Y
	.BYTE 0
W?YANK::	.ZWORD "yank"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?PULL
	.BYTE 0
W?YELL::	.ZWORD "yell"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?YELL
	.BYTE 0
W?YES::	.ZWORD "yes"
	.BYTE PS?BUZZ-WORD
	.BYTE B?YES
	.BYTE 0
W?YOUNG::	.ZWORD "young"
	.BYTE PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?YOUNG
	.BYTE 0
W?Z::	.ZWORD "z"
	.BYTE PS?VERB+P1?VERB
	.BYTE ACT?WAIT
	.BYTE 0
W?ZORK::	.ZWORD "zork"
	.BYTE PS?VERB+PS?ADJECTIVE+P1?ADJECTIVE
	.BYTE A?ZORK
	.BYTE ACT?ZORK
W?ZORKMID::	.ZWORD "zorkmi"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?OBJECT
	.BYTE O?ANY
	.BYTE A?ZORKMID
W?ZURICH::	.ZWORD "zurich"
	.BYTE PS?OBJECT+PS?ADJECTIVE+P1?OBJECT
	.BYTE O?ANY
	.BYTE A?ZURICH
W?ZZMGCK::	.ZWORD "zzmgck"
	.BYTE PS?OBJECT+P1?OBJECT
	.BYTE O?ANY
	.BYTE 0
	.ENDT


; END LOAD

ENDLOD::



; PURE TABLES ARE DEFINED HERE

PURTBL::

	.ENDI
