

	.FUNCT	V-VERBOSE
	SET	'VERBOSE,TRUE-VALUE
	SET	'SUPER-BRIEF,FALSE-VALUE
	PRINTR	"Maximum verbosity."


	.FUNCT	V-BRIEF
	SET	'VERBOSE,FALSE-VALUE
	SET	'SUPER-BRIEF,FALSE-VALUE
	PRINTR	"Brief descriptions."


	.FUNCT	V-SUPER-BRIEF
	SET	'SUPER-BRIEF,TRUE-VALUE
	PRINTR	"Superbrief descriptions."


	.FUNCT	V-INVENTORY
	FIRST?	WINNER \?ELS5
	CALL	PRINT-CONT,WINNER
	RSTACK	
?ELS5:	PRINTR	"You are empty-handed."


	.FUNCT	FINISH,WRD
	CALL	V-SCORE
?PRG1:	CRLF	
	PRINTI	"Would you like to restart the game from the beginning, restore a saved game position, or end this session of the game?
(Type RESTART, RESTORE, or QUIT):
>"
	READ	P-INBUF,P-LEXV
	GET	P-LEXV,1 >WRD
	EQUAL?	WRD,W?RESTART \?ELS7
	RESTART	
	PRINTI	"Failed."
	CRLF	
	JUMP	?PRG1
?ELS7:	EQUAL?	WRD,W?RESTORE \?ELS11
	RESTORE	 \?ELS14
	PRINTI	"Ok."
	CRLF	
	JUMP	?PRG1
?ELS14:	PRINTI	"Failed."
	CRLF	
	JUMP	?PRG1
?ELS11:	EQUAL?	WRD,W?QUIT,W?Q \?PRG1
	QUIT	
	JUMP	?PRG1


	.FUNCT	V-QUIT,SCOR
	CALL	V-SCORE
	PRINTI	"Do you wish to leave the game? (Y is affirmative): "
	CALL	YES?
	ZERO?	STACK /?ELS7
	QUIT	
	RTRUE	
?ELS7:	PRINTR	"Ok."


	.FUNCT	V-RESTART
	CALL	V-SCORE,TRUE-VALUE
	PRINTI	"Do you wish to restart? (Y is affirmative): "
	CALL	YES?
	ZERO?	STACK /FALSE
	PRINTI	"Restarting."
	CRLF	
	RESTART	
	PRINTR	"Failed."


	.FUNCT	V-RESTORE
	RESTORE	 \?ELS5
	PRINTI	"Ok."
	CRLF	
	CALL	V-FIRST-LOOK
	RSTACK	
?ELS5:	PRINTR	"Failed."


	.FUNCT	V-SAVE
	SAVE	 \?ELS5
	PRINTR	"Ok."
?ELS5:	PRINTR	"Failed."


	.FUNCT	V-SCRIPT
	GET	0,8
	BOR	STACK,1
	PUT	0,8,STACK
	PRINTI	"Here begins a transcript of interaction with"
	CRLF	
	CALL	V-VERSION
	RTRUE	


	.FUNCT	V-UNSCRIPT
	PRINTI	"Here ends a transcript of interaction with"
	CRLF	
	CALL	V-VERSION
	GET	0,8
	BAND	STACK,-2
	PUT	0,8,STACK
	RTRUE	


	.FUNCT	V-VERSION,CNT=17
	PRINTI	"ZORK II: The Wizard of Frobozz
Infocom interactive fiction - a fantasy story
Copyright (c) 1981, 1982, 1983, 1986"
	PRINTI	" Infocom, Inc. All rights reserved."
	CRLF	
	PRINTI	"ZORK is a registered trademark of Infocom, Inc.
Release "
	GET	0,1
	BAND	STACK,2047
	PRINTN	STACK
	PRINTI	" / Serial number "
?PRG9:	IGRTR?	'CNT,23 \?ELS13
	JUMP	?REP10
?ELS13:	GETB	0,CNT
	PRINTC	STACK
	JUMP	?PRG9
?REP10:	CRLF	
	RTRUE	


	.FUNCT	V-VERIFY
	PRINTI	"Verifying disk..."
	CRLF	
	VERIFY	 \?ELS7
	PRINTR	"The disk is correct."
?ELS7:	CRLF	
	PRINTR	"** Disk Failure **"


	.FUNCT	V-COMMAND-FILE
	DIRIN	1
	RTRUE	


	.FUNCT	V-RANDOM
	EQUAL?	PRSO,INTNUM /?ELS5
	PRINTR	"Illegal call to #RND."
?ELS5:	SUB	0,P-NUMBER
	RANDOM	STACK
	RTRUE	


	.FUNCT	V-RECORD
	DIROUT	4
	RTRUE	


	.FUNCT	V-UNRECORD
	DIROUT	-4
	RTRUE	


	.FUNCT	V-ADVENT
	PRINTR	"A hollow voice says ""Fool."""


	.FUNCT	V-ALARM
	FSET?	PRSO,ACTORBIT \?ELS5
	CALL	NULL-F
	ZERO?	STACK \TRUE
	PRINTR	"He's wide awake, or haven't you noticed..."
?ELS5:	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" isn't sleeping."


	.FUNCT	V-ANSWER
	PRINTI	"Nobody seems to be awaiting your answer."
	CRLF	
	SET	'P-CONT,FALSE-VALUE
	SET	'QUOTE-FLAG,FALSE-VALUE
	RTRUE	


	.FUNCT	V-ATTACK
	FSET?	PRSO,ACTORBIT /?ELS5
	PRINTI	"I've known strange people, but fighting a "
	PRINTD	PRSO
	PRINTR	"?"
?ELS5:	ZERO?	PRSI /?THN10
	EQUAL?	PRSI,HANDS \?ELS9
?THN10:	PRINTI	"Trying to attack a "
	PRINTD	PRSO
	PRINTR	" with your bare hands is suicidal."
?ELS9:	IN?	PRSI,WINNER /?ELS15
	PRINTI	"You aren't even holding the "
	PRINTD	PRSI
	PRINTR	"."
?ELS15:	FSET?	PRSI,WEAPONBIT /?ELS19
	PRINTI	"Trying to attack the "
	PRINTD	PRSO
	PRINTI	" with a "
	PRINTD	PRSI
	PRINTR	" is suicidal."
?ELS19:	PRINTR	"You can't."


	.FUNCT	V-BACK
	PRINTR	"Sorry, my memory is poor. Please give a direction."


	.FUNCT	V-BLAST
	PRINTR	"You can't blast anything by using words."


	.FUNCT	PRE-BOARD,AV
	LOC	WINNER >AV
	CALL	NULL-F
	ZERO?	STACK \TRUE
	FSET?	PRSO,VEHBIT \?ELS5
	IN?	PRSO,HERE /?ELS8
	PRINTI	"The "
	PRINTD	PRSO
	PRINTI	" must be on the ground to be boarded."
	CRLF	
	RETURN	2
?ELS8:	FSET?	AV,VEHBIT \FALSE
	PRINTI	"You are already in the "
	PRINTD	AV
	PRINTI	"!"
	CRLF	
	RETURN	2
?ELS5:	EQUAL?	PRSO,WATER,GLOBAL-WATER \?ELS18
	CALL	PERFORM,V?SWIM,PRSO
	RTRUE	
?ELS18:	PRINTI	"You have a theory on how to board a "
	PRINTD	PRSO
	PRINTI	", perhaps?"
	CRLF	
	RETURN	2


	.FUNCT	V-BOARD,AV
	PRINTI	"You are now in the "
	PRINTD	PRSO
	PRINTI	"."
	CRLF	
	MOVE	WINNER,PRSO
	GETP	PRSO,P?ACTION
	CALL	STACK,M-ENTER
	RTRUE	


	.FUNCT	V-BREATHE
	CALL	PERFORM,V?INFLATE,PRSO,LUNGS
	RSTACK	


	.FUNCT	V-BRUSH
	PRINTR	"If you wish, but heaven only knows why."


	.FUNCT	V-BUG
	PRINTR	"Bug? Not in a flawless program like this! (Cough, cough)."


	.FUNCT	TELL-NO-PRSI
	PRINTR	"You didn't say with what!"


	.FUNCT	PRE-BURN
	ZERO?	PRSI \?ELS5
	CALL	TELL-NO-PRSI
	RSTACK	
?ELS5:	FSET?	PRSI,FLAMEBIT \?ELS7
	FSET?	PRSI,ONBIT /FALSE
?ELS7:	PRINTI	"With a "
	PRINTD	PRSI
	PRINTR	"??!?"


	.FUNCT	V-BURN
	LOC	PRSO
	EQUAL?	STACK,RECEPTACLE \?ELS5
	CALL	BALLOON-BURN
	RTRUE	
?ELS5:	FSET?	PRSO,BURNBIT \?ELS7
	IN?	PRSO,WINNER /?THN13
	IN?	WINNER,PRSO \?ELS12
?THN13:	CALL	REMOVE-CAREFULLY,PRSO
	PRINTI	"The "
	PRINTD	PRSO
	PRINTI	" catches fire. Unfortunately, you were "
	IN?	WINNER,PRSO \?ELS21
	PRINTI	"in"
	JUMP	?CND19
?ELS21:	PRINTI	"holding"
?CND19:	CALL	JIGS-UP,STR?168
	RSTACK	
?ELS12:	CALL	REMOVE-CAREFULLY,PRSO
	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" catches fire and is consumed."
?ELS7:	PRINTI	"You can't burn a "
	PRINTD	PRSO
	PRINTR	"."


	.FUNCT	V-CHOMP
	PRINTR	"Preposterous!"


	.FUNCT	V-CLIMB-DOWN
	CALL	V-CLIMB-UP,P?DOWN,PRSO
	RSTACK	


	.FUNCT	V-CLIMB-FOO
	CALL	V-CLIMB-UP,P?UP,PRSO
	RSTACK	


	.FUNCT	V-CLIMB-ON
	FSET?	PRSO,VEHBIT \?ELS5
	CALL	PERFORM,V?BOARD,PRSO
	RTRUE	
?ELS5:	PRINTI	"You can't climb onto the "
	PRINTD	PRSO
	PRINTR	"."


	.FUNCT	V-CLIMB-UP,DIR=P?UP,OBJ=0,X,TX,?TMP1
	ZERO?	OBJ /?CND1
	EQUAL?	PRSO,ROOMS /?CND1
	SET	'OBJ,PRSO
?CND1:	GETPT	HERE,DIR >TX
	ZERO?	TX /?ELS10
	ZERO?	OBJ /?CND11
	PTSIZE	TX >X
	EQUAL?	X,NEXIT /?THN18
	EQUAL?	X,CEXIT,DEXIT,UEXIT \?CND11
	GETB	TX,0
	CALL	GLOBAL-IN?,PRSO,STACK
	ZERO?	STACK \?CND11
?THN18:	PRINTI	"The "
	PRINTD	OBJ
	PRINTI	" do"
	EQUAL?	OBJ,STAIRS /?CND24
	PRINTI	"es"
?CND24:	PRINTI	"n't lead "
	EQUAL?	DIR,P?UP \?ELS33
	PRINTI	"up"
	JUMP	?CND31
?ELS33:	PRINTI	"down"
?CND31:	PRINTR	"ward."
?CND11:	CALL	DO-WALK,DIR
	RTRUE	
?ELS10:	ZERO?	OBJ /?ELS43
	GETPT	PRSO,P?SYNONYM >X
	PTSIZE	X
	CALL	ZMEMQ,W?WALL,X,STACK
	ZERO?	STACK /?ELS43
	PRINTR	"Climbing the walls is to no avail."
?ELS43:	CALL	NULL-F
	ZERO?	STACK /?ELS49
	PRINTR	"There are no climbable trees here."
?ELS49:	EQUAL?	OBJ,FALSE-VALUE,ROOMS \?ELS53
	PRINTR	"You can't go that way."
?ELS53:	PRINTR	"You can't do that!"


	.FUNCT	V-CLOSE
	FSET?	PRSO,CONTBIT /?ELS5
	FSET?	PRSO,DOORBIT /?ELS5
	PRINTI	"You must tell me how to do that to a "
	PRINTD	PRSO
	PRINTR	"."
?ELS5:	FSET?	PRSO,SURFACEBIT /?ELS11
	GETP	PRSO,P?CAPACITY
	ZERO?	STACK /?ELS11
	FSET?	PRSO,OPENBIT \?ELS18
	FCLEAR	PRSO,OPENBIT
	PRINTI	"Closed."
	CRLF	
	ZERO?	LIT /TRUE
	CALL	LIT?,HERE >LIT
	ZERO?	LIT \TRUE
	PRINTR	"It is now pitch black."
?ELS18:	PRINTR	"It is already closed."
?ELS11:	FSET?	PRSO,DOORBIT \?ELS33
	FSET?	PRSO,OPENBIT \?ELS38
	FCLEAR	PRSO,OPENBIT
	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" is now closed."
?ELS38:	PRINTR	"It is already closed."
?ELS33:	PRINTR	"You cannot close that."


	.FUNCT	V-COMMAND
	FSET?	PRSO,ACTORBIT \?ELS5
	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" pays no attention."
?ELS5:	PRINTR	"You cannot talk to that!"


	.FUNCT	V-COUNT
	EQUAL?	PRSO,BLESSINGS \?ELS5
	PRINTR	"Well, for one, you are playing Zork..."
?ELS5:	PRINTR	"You have lost your mind."


	.FUNCT	V-CROSS
	PRINTR	"You can't cross that!"


	.FUNCT	V-CURSES
	ZERO?	PRSO /?ELS5
	FSET?	PRSO,ACTORBIT \?ELS11
	PRINTR	"Insults of this nature won't help you."
?ELS11:	PRINTR	"What a loony!"
?ELS5:	PRINTR	"Such language in a high-class establishment like this!"


	.FUNCT	V-CUT
	FSET?	PRSO,ACTORBIT \?ELS5
	CALL	PERFORM,V?ATTACK,PRSO,PRSI
	RSTACK	
?ELS5:	FSET?	PRSO,BURNBIT \?ELS7
	FSET?	PRSI,WEAPONBIT \?ELS7
	IN?	WINNER,PRSO \?CND10
	PRINTR	"Not a bright idea, especially since you're in it."
?CND10:	CALL	REMOVE-CAREFULLY,PRSO
	PRINTI	"Your skillful "
	PRINTD	PRSI
	PRINTI	"smanship slices the "
	PRINTD	PRSO
	PRINTR	" into innumerable slivers which blow away."
?ELS7:	FSET?	PRSI,WEAPONBIT /?ELS18
	PRINTI	"The ""cutting edge"" of a "
	PRINTD	PRSI
	PRINTR	" is hardly adequate."
?ELS18:	PRINTI	"Strange concept, cutting the "
	PRINTD	PRSO
	PRINTR	"...."


	.FUNCT	V-DEFLATE
	PRINTR	"Come on, now!"


	.FUNCT	V-DIG
	ZERO?	PRSI \?CND1
	SET	'PRSI,HANDS
?CND1:	FSET?	PRSI,TOOLBIT \?ELS8
	PRINTI	"Digging with the "
	PRINTD	PRSI
	PRINTR	" is slow and tedious."
?ELS8:	PRINTI	"Digging with a "
	PRINTD	PRSI
	PRINTR	" is silly."


	.FUNCT	V-DISEMBARK
	EQUAL?	PRSO,ROOMS \?ELS5
	LOC	WINNER
	FSET?	STACK,VEHBIT \?ELS5
	LOC	WINNER
	CALL	PERFORM,V?DISEMBARK,STACK
	RTRUE	
?ELS5:	LOC	WINNER
	EQUAL?	STACK,PRSO /?ELS9
	PRINTI	"You're not in that!"
	CRLF	
	RETURN	2
?ELS9:	FSET?	HERE,RLANDBIT \?ELS15
	PRINTI	"You are on your own feet again."
	CRLF	
	MOVE	WINNER,HERE
	RTRUE	
?ELS15:	PRINTI	"You realize that getting out here would be fatal."
	CRLF	
	RETURN	2


	.FUNCT	V-DISENCHANT
	IN?	PRSO,HERE \TRUE
	EQUAL?	SPELL-USED,W?FEEBLE,W?FUMBLE,W?FEAR /?THN8
	EQUAL?	SPELL-USED,W?FREEZE,W?FALL,W?FERMENT /?THN8
	EQUAL?	SPELL-USED,W?FIERCE,W?FENCE,W?FANTASIZE \?ELS7
?THN8:	FSET?	PRSO,ACTORBIT \FALSE
	EQUAL?	SPELL-USED,W?FEEBLE \?ELS19
	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" seems stronger now."
?ELS19:	EQUAL?	SPELL-USED,W?FUMBLE \?ELS23
	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" no longer appears clumsy."
?ELS23:	EQUAL?	SPELL-USED,W?FEAR \?ELS27
	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" no longer appears afraid."
?ELS27:	EQUAL?	SPELL-USED,W?FREEZE \?ELS31
	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" moves again."
?ELS31:	EQUAL?	SPELL-USED,W?FERMENT \?ELS35
	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" stops swaying."
?ELS35:	EQUAL?	SPELL-USED,W?FIERCE \FALSE
	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" appears more peaceful."
?ELS7:	EQUAL?	SPELL-USED,W?FLOAT \?ELS43
	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" sinks to the ground."
?ELS43:	EQUAL?	SPELL-USED,W?FUDGE \FALSE
	PRINTR	"The sweet smell has dispersed."


	.FUNCT	V-DRINK
	CALL	V-EAT
	RSTACK	


	.FUNCT	V-DRINK-FROM
	PRINTR	"How peculiar!"


	.FUNCT	PRE-DROP
	LOC	WINNER
	EQUAL?	PRSO,STACK \FALSE
	CALL	PERFORM,V?DISEMBARK,PRSO
	RTRUE	


	.FUNCT	V-DROP
	CALL	IDROP
	ZERO?	STACK /FALSE
	PRINTR	"Dropped."


	.FUNCT	V-EAT,EAT?=0,DRINK?=0,NOBJ=0
	FSET?	PRSO,FOODBIT /?PRD6
	PUSH	0
	JUMP	?PRD7
?PRD6:	PUSH	1
?PRD7:	SET	'EAT?,STACK
	ZERO?	EAT? /?ELS5
	IN?	PRSO,WINNER /?ELS10
	LOC	PRSO
	IN?	STACK,WINNER /?ELS10
	PRINTI	"You're not holding that."
	CRLF	
	JUMP	?CND8
?ELS10:	EQUAL?	PRSA,V?DRINK \?ELS16
	PRINTI	"How can you drink that?"
	JUMP	?CND8
?ELS16:	PRINTI	"Thank you very much. It really hit the spot."
	CALL	REMOVE-CAREFULLY,PRSO
?CND8:	CRLF	
	RTRUE	
?ELS5:	FSET?	PRSO,DRINKBIT \?ELS24
	SET	'DRINK?,TRUE-VALUE
	LOC	PRSO >NOBJ
	IN?	PRSO,GLOBAL-OBJECTS /?THN30
	CALL	GLOBAL-IN?,GLOBAL-WATER,HERE
	ZERO?	STACK \?THN30
	EQUAL?	PRSO,PSEUDO-OBJECT \?ELS29
?THN30:	CALL	HIT-SPOT
	RSTACK	
?ELS29:	ZERO?	NOBJ /?THN34
	CALL	ACCESSIBLE?,NOBJ
	ZERO?	STACK \?ELS33
?THN34:	PRINTR	"There isn't any water here."
?ELS33:	CALL	ACCESSIBLE?,NOBJ
	ZERO?	STACK /?ELS39
	PRINTI	"You have to be holding the "
	PRINTD	NOBJ
	PRINTR	" first."
?ELS39:	FSET?	NOBJ,OPENBIT /?ELS43
	PRINTI	"You'll have to open the "
	PRINTD	NOBJ
	PRINTR	" first."
?ELS43:	CALL	HIT-SPOT
	RSTACK	
?ELS24:	ZERO?	EAT? \FALSE
	ZERO?	DRINK? \FALSE
	PRINTI	"I don't think that the "
	PRINTD	PRSO
	PRINTR	" would agree with you."


	.FUNCT	HIT-SPOT
	EQUAL?	PRSO,WATER \?CND1
	CALL	GLOBAL-IN?,GLOBAL-WATER,HERE
	ZERO?	STACK \?CND1
	CALL	REMOVE-CAREFULLY,PRSO
?CND1:	PRINTR	"Thank you very much. I was rather thirsty (from all this talking, probably)."


	.FUNCT	V-ECHO,LST,MAX,ECH=0,CNT
	PRINTR	"echo echo ..."


	.FUNCT	V-ENCHANT
	ZERO?	WAND-ON /?CND1
	SET	'SPELL-VICTIM,WAND-ON
?CND1:	ZERO?	SPELL-VICTIM /?ELS9
	ZERO?	SPELL-USED \?CND11
	PRINTR	"You must be more specific."
?CND11:	EQUAL?	SPELL-USED,W?FEEBLE,W?FUMBLE,W?FEAR /?THN21
	EQUAL?	SPELL-USED,W?FREEZE,W?FALL,W?FERMENT /?THN21
	EQUAL?	SPELL-USED,W?FIERCE,W?FENCE,W?FANTASIZE \?ELS20
?THN21:	FSET?	PRSO,ACTORBIT \?ELS27
	PRINTR	"The wand stops glowing, but there is no other obvious effect."
?ELS27:	PRINTI	"That might have done something, but it's hard to tell with a "
	PRINTD	PRSO
	PRINTR	"."
?ELS20:	EQUAL?	SPELL-USED,W?FUDGE \?ELS35
	PRINTR	"A strong odor of chocolate permeates the room."
?ELS35:	EQUAL?	SPELL-USED,W?FLUORESCE \?ELS39
	FSET	PRSO,LIGHTBIT
	FSET	PRSO,ONBIT
	SET	'LIT,TRUE-VALUE
	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" begins to glow."
?ELS39:	EQUAL?	SPELL-USED,W?FILCH \?ELS43
	SET	'SPELL-HANDLED?,TRUE-VALUE
	FSET?	PRSO,TAKEBIT \?ELS48
	MOVE	PRSO,WINNER
	CALL	SCORE-OBJ,PRSO
	PRINTR	"Filched!"
?ELS48:	PRINTI	"You can't filch the "
	PRINTD	PRSO
	PRINTR	"!"
?ELS43:	EQUAL?	SPELL-USED,W?FLOAT \?ELS56
	FSET?	PRSO,TAKEBIT \?ELS56
	EQUAL?	SPELL-VICTIM,COLLAR \?CND59
	IN?	COLLAR,CERBERUS \?CND59
	SET	'SPELL-VICTIM,CERBERUS
?CND59:	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" floats serenely in midair."
?ELS56:	EQUAL?	SPELL-USED,W?FRY \?ELS67
	FSET?	PRSO,TAKEBIT \?ELS67
	SET	'SPELL-HANDLED?,TRUE-VALUE
	CALL	REMOVE-CAREFULLY,PRSO
	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" goes up in a puff of smoke."
?ELS67:	SET	'SPELL-VICTIM,FALSE-VALUE
	PRINTR	"The wand stops glowing, but there is no other apparent effect."
?ELS9:	SET	'SPELL-VICTIM,FALSE-VALUE
	PRINTR	"Nothing happens."


	.FUNCT	REMOVE-CAREFULLY,OBJ,OLIT
	EQUAL?	OBJ,P-IT-OBJECT \?CND1
	SET	'P-IT-OBJECT,FALSE-VALUE
?CND1:	SET	'OLIT,LIT
	REMOVE	OBJ
	CALL	LIT?,HERE >LIT
	ZERO?	OLIT /TRUE
	EQUAL?	OLIT,LIT /TRUE
	PRINTR	"You are left in the dark..."


	.FUNCT	V-ENTER
	CALL	DO-WALK,P?IN
	RSTACK	


	.FUNCT	V-EXAMINE
	GETP	PRSO,P?TEXT
	ZERO?	STACK /?ELS5
	GETP	PRSO,P?TEXT
	PRINT	STACK
	CRLF	
	RTRUE	
?ELS5:	FSET?	PRSO,CONTBIT /?THN10
	FSET?	PRSO,DOORBIT \?ELS9
?THN10:	CALL	V-LOOK-INSIDE
	RSTACK	
?ELS9:	PRINTI	"There's nothing special about the "
	PRINTD	PRSO
	PRINTR	"."


	.FUNCT	V-EXIT
	EQUAL?	PRSO,FALSE-VALUE,ROOMS \?ELS5
	LOC	WINNER
	FSET?	STACK,VEHBIT \?ELS5
	LOC	WINNER
	CALL	PERFORM,V?DISEMBARK,STACK
	RTRUE	
?ELS5:	ZERO?	PRSO /?ELS9
	IN?	WINNER,PRSO \?ELS9
	CALL	PERFORM,V?DISEMBARK,PRSO
	RTRUE	
?ELS9:	CALL	DO-WALK,P?OUT
	RSTACK	


	.FUNCT	V-EXORCISE
	PRINTR	"What a bizarre concept!"


	.FUNCT	PRE-FILL,TX
	ZERO?	PRSI \?CND1
	GETPT	HERE,P?GLOBAL >TX
	ZERO?	TX /?ELS6
	PTSIZE	TX
	SUB	STACK,1
	CALL	ZMEMQB,GLOBAL-WATER,TX,STACK
	ZERO?	STACK /?ELS6
	CALL	PERFORM,V?FILL,PRSO,GLOBAL-WATER
	RTRUE	
?ELS6:	LOC	WINNER
	IN?	WATER,STACK \?ELS10
	CALL	PERFORM,V?FILL,PRSO,WATER
	RTRUE	
?ELS10:	PRINTR	"There is nothing to fill it with."
?CND1:	EQUAL?	PRSI,WATER /FALSE
	EQUAL?	PRSI,GLOBAL-WATER /FALSE
	CALL	PERFORM,V?PUT,PRSI,PRSO
	RTRUE	


	.FUNCT	V-FILL
	ZERO?	PRSI \?ELS5
	CALL	GLOBAL-IN?,GLOBAL-WATER,HERE
	ZERO?	STACK /?ELS10
	CALL	PERFORM,V?FILL,PRSO,GLOBAL-WATER
	RTRUE	
?ELS10:	LOC	WINNER
	IN?	WATER,STACK \?ELS12
	CALL	PERFORM,V?FILL,PRSO,WATER
	RTRUE	
?ELS12:	PRINTR	"There's nothing to fill it with."
?ELS5:	PRINTR	"You may know how to do that, but I don't."


	.FUNCT	V-FIND,L
	LOC	PRSO >L
	EQUAL?	PRSO,HANDS,LUNGS \?ELS5
	PRINTR	"Within six feet of your head, assuming you haven't left that somewhere."
?ELS5:	EQUAL?	PRSO,ME \?ELS9
	PRINTR	"You're around here somewhere..."
?ELS9:	EQUAL?	L,GLOBAL-OBJECTS \?ELS13
	PRINTR	"You find it."
?ELS13:	IN?	PRSO,WINNER \?ELS17
	PRINTR	"You have it."
?ELS17:	IN?	PRSO,HERE /?THN22
	CALL	GLOBAL-IN?,PRSO,HERE
	ZERO?	STACK \?THN22
	EQUAL?	PRSO,PSEUDO-OBJECT \?ELS21
?THN22:	PRINTR	"It's right here."
?ELS21:	FSET?	L,ACTORBIT \?ELS27
	PRINTI	"The "
	PRINTD	L
	PRINTR	" has it."
?ELS27:	FSET?	L,SURFACEBIT \?ELS31
	PRINTI	"It's on the "
	PRINTD	L
	PRINTR	"."
?ELS31:	FSET?	L,CONTBIT \?ELS35
	PRINTI	"It's in the "
	PRINTD	L
	PRINTR	"."
?ELS35:	PRINTR	"Beats me."


	.FUNCT	V-FOLLOW
	PRINTR	"You're nuts!"


	.FUNCT	V-FROBOZZ
	PRINTR	"The FROBOZZ Corporation created, owns, and operates this dungeon."


	.FUNCT	PRE-GIVE
	CALL	HELD?,PRSO
	ZERO?	STACK \FALSE
	PRINTI	"That's easy for you to say since you don't even have the "
	PRINTD	PRSO
	PRINTR	"."


	.FUNCT	V-GIVE
	FSET?	PRSI,ACTORBIT /?ELS5
	PRINTI	"You can't give a "
	PRINTD	PRSO
	PRINTI	" to a "
	PRINTD	PRSI
	PRINTR	"!"
?ELS5:	PRINTI	"The "
	PRINTD	PRSI
	PRINTR	" refuses it politely."


	.FUNCT	V-HATCH
	PRINTR	"Bizarre!"


	.FUNCT	V-HELLO
	ZERO?	PRSO /?ELS5
	FSET?	PRSO,ACTORBIT \?ELS11
	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" bows his head to you in greeting."
?ELS11:	PRINTI	"It's a well known fact that only schizophrenics say ""Hello"" to a "
	PRINTD	PRSO
	PRINTR	"."
?ELS5:	CALL	PICK-ONE,HELLOS
	PRINT	STACK
	CRLF	
	RTRUE	


	.FUNCT	V-INCANT
	ZERO?	SPELL-USED /?ELS3
	PRINTI	"Nothing happens."
	CRLF	
	JUMP	?CND1
?ELS3:	ZERO?	WAND-ON /?ELS8
	SET	'SPELL-VICTIM,WAND-ON
	GET	P-LEXV,P-CONT >SPELL-USED
	PRINTI	"The wand glows very brightly for a moment."
	CRLF	
	RANDOM	10
	ADD	10,STACK
	CALL	QUEUE,I-SPELL,STACK
	PUT	STACK,0,1
	SET	'WAND-ON,FALSE-VALUE
	CALL	PERFORM,V?ENCHANT,SPELL-VICTIM
	JUMP	?CND1
?ELS8:	PRINTI	"The incantation echoes back faintly, but nothing else happens."
	CRLF	
?CND1:	SET	'QUOTE-FLAG,FALSE-VALUE
	SET	'P-CONT,FALSE-VALUE
	RTRUE	


	.FUNCT	V-INFLATE
	PRINTR	"How can you inflate that?"


	.FUNCT	V-KICK
	CALL	HACK-HACK,STR?169
	RSTACK	


	.FUNCT	V-KISS
	PRINTR	"I'd sooner kiss a pig."


	.FUNCT	V-KNOCK
	FSET?	PRSO,DOORBIT \?ELS5
	PRINTR	"Nobody's home."
?ELS5:	PRINTI	"Why knock on a "
	PRINTD	PRSO
	PRINTR	"?"


	.FUNCT	V-LAMP-OFF
	FSET?	PRSO,LIGHTBIT \?ELS3
	FSET?	PRSO,ONBIT /?ELS6
	PRINTR	"It is already off."
?ELS6:	FCLEAR	PRSO,ONBIT
	ZERO?	LIT /?CND11
	CALL	LIT?,HERE >LIT
?CND11:	PRINTI	"The "
	PRINTD	PRSO
	PRINTI	" is now off."
	CRLF	
	ZERO?	LIT \TRUE
	PRINTI	"It is now pitch black."
	CRLF	
	RTRUE	
?ELS3:	PRINTR	"You can't turn that off."


	.FUNCT	V-LAMP-ON
	FSET?	PRSO,LIGHTBIT \?ELS3
	FSET?	PRSO,ONBIT \?ELS6
	PRINTR	"It is already on."
?ELS6:	FSET	PRSO,ONBIT
	PRINTI	"The "
	PRINTD	PRSO
	PRINTI	" is now on."
	CRLF	
	ZERO?	LIT \TRUE
	CALL	LIT?,HERE >LIT
	CRLF	
	CALL	V-LOOK
	RTRUE	
?ELS3:	FSET?	PRSO,BURNBIT \?ELS17
	PRINTI	"If you wish to burn the "
	PRINTD	PRSO
	PRINTR	", you should say so."
?ELS17:	PRINTR	"You can't turn that on."


	.FUNCT	V-LAUNCH
	FSET?	PRSO,VEHBIT \?ELS5
	PRINTR	"You can't launch that by saying ""launch""!"
?ELS5:	PRINTR	"That's pretty weird."


	.FUNCT	V-LEAN-ON
	PRINTR	"Getting tired?"


	.FUNCT	V-LEAP,TX,S
	ZERO?	PRSO /?ELS5
	IN?	PRSO,HERE \?ELS11
	FSET?	PRSO,ACTORBIT \?ELS16
	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" is too big to jump over."
?ELS16:	CALL	V-SKIP
	RSTACK	
?ELS11:	PRINTR	"That would be a good trick."
?ELS5:	GETPT	HERE,P?DOWN >TX
	ZERO?	TX /?ELS26
	PTSIZE	TX >S
	EQUAL?	S,2 /?THN32
	EQUAL?	S,4 \?ELS31
	GETB	TX,1
	VALUE	STACK
	ZERO?	STACK \?ELS31
?THN32:	PRINTI	"This was not a very safe place to try jumping."
	CRLF	
	CALL	PICK-ONE,JUMPLOSS
	CALL	JIGS-UP,STACK
	RSTACK	
?ELS31:	CALL	NULL-F
	ZERO?	STACK \TRUE
	CALL	V-SKIP
	RSTACK	
?ELS26:	CALL	V-SKIP
	RSTACK	


	.FUNCT	V-LEAVE
	CALL	DO-WALK,P?OUT
	RSTACK	


	.FUNCT	V-LISTEN
	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" makes no sound."


	.FUNCT	V-LOCK
	PRINTR	"It doesn't seem to work."


	.FUNCT	V-LOOK
	CALL	DESCRIBE-ROOM,TRUE-VALUE
	ZERO?	STACK /FALSE
	CALL	DESCRIBE-OBJECTS,TRUE-VALUE
	RSTACK	


	.FUNCT	V-LOOK-BEHIND
	PRINTI	"There is nothing behind the "
	PRINTD	PRSO
	PRINTR	"."


	.FUNCT	V-LOOK-INSIDE
	FSET?	PRSO,DOORBIT \?ELS5
	FSET?	PRSO,OPENBIT \?ELS8
	PRINTI	"The "
	PRINTD	PRSO
	PRINTI	" is open, but I can't tell what's beyond it."
	JUMP	?CND6
?ELS8:	PRINTI	"The "
	PRINTD	PRSO
	PRINTI	" is closed."
?CND6:	CRLF	
	RTRUE	
?ELS5:	FSET?	PRSO,CONTBIT \?ELS16
	FSET?	PRSO,ACTORBIT \?ELS21
	PRINTR	"There is nothing special to be seen."
?ELS21:	CALL	SEE-INSIDE?,PRSO
	ZERO?	STACK /?ELS25
	FIRST?	PRSO \?ELS30
	CALL	PRINT-CONT,PRSO
	ZERO?	STACK \TRUE
?ELS30:	CALL	NULL-F
	ZERO?	STACK \TRUE
	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" is empty."
?ELS25:	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" is closed."
?ELS16:	PRINTI	"You can't look inside a "
	PRINTD	PRSO
	PRINTR	"."


	.FUNCT	V-LOOK-ON
	FSET?	PRSO,SURFACEBIT \?ELS5
	CALL	PERFORM,V?LOOK-INSIDE,PRSO
	RTRUE	
?ELS5:	PRINTI	"Look on a "
	PRINTD	PRSO
	PRINTR	"???"


	.FUNCT	V-LOOK-UNDER
	PRINTR	"There is nothing but dust there."


	.FUNCT	V-LOWER
	CALL	HACK-HACK,STR?173
	RSTACK	


	.FUNCT	V-MAKE
	PRINTR	"You can't do that."


	.FUNCT	V-MELT
	PRINTI	"It's not clear that a "
	PRINTD	PRSO
	PRINTR	" can be melted."


	.FUNCT	PRE-MOVE
	CALL	HELD?,PRSO
	ZERO?	STACK /FALSE
	PRINTR	"You aren't an accomplished enough juggler."


	.FUNCT	V-MOVE
	FSET?	PRSO,TAKEBIT \?ELS5
	PRINTI	"Moving the "
	PRINTD	PRSO
	PRINTR	" reveals nothing."
?ELS5:	PRINTI	"You can't move the "
	PRINTD	PRSO
	PRINTR	"."


	.FUNCT	V-MUMBLE
	PRINTR	"You'll have to speak up if you expect me to hear you!"


	.FUNCT	PRE-MUNG
	CALL	NULL-F
	ZERO?	STACK \TRUE
	ZERO?	PRSI /?THN8
	FSET?	PRSI,WEAPONBIT /FALSE
?THN8:	PRINTI	"Trying to destroy the "
	PRINTD	PRSO
	PRINTI	" with "
	ZERO?	PRSI \?ELS14
	PRINTI	"your bare hands"
	JUMP	?CND12
?ELS14:	PRINTI	"a "
	PRINTD	PRSI
?CND12:	PRINTR	" is futile."


	.FUNCT	V-MUNG
	FSET?	PRSO,ACTORBIT \?ELS5
	CALL	PERFORM,V?ATTACK,PRSO
	RTRUE	
?ELS5:	PRINTR	"Nice try."


	.FUNCT	V-ODYSSEUS
	CALL	NULL-F
	ZERO?	STACK \TRUE
	PRINTR	"Wasn't he a sailor?"


	.FUNCT	V-OIL
	PRINTR	"You probably put spinach in your gas tank, too."


	.FUNCT	V-OPEN,F,STR
	FSET?	PRSO,CONTBIT \?ELS5
	GETP	PRSO,P?CAPACITY
	ZERO?	STACK /?ELS5
	FSET?	PRSO,OPENBIT \?ELS12
	PRINTR	"It is already open."
?ELS12:	FSET	PRSO,OPENBIT
	FSET	PRSO,TOUCHBIT
	FIRST?	PRSO \?THN22
	FSET?	PRSO,TRANSBIT \?ELS21
?THN22:	PRINTR	"Opened."
?ELS21:	FIRST?	PRSO >F \?ELS27
	NEXT?	F /?ELS27
	FSET?	F,TOUCHBIT /?ELS27
	GETP	F,P?FDESC >STR
	ZERO?	STR /?ELS27
	PRINTI	"The "
	PRINTD	PRSO
	PRINTI	" opens."
	CRLF	
	PRINT	STR
	CRLF	
	RTRUE	
?ELS27:	PRINTI	"Opening the "
	PRINTD	PRSO
	PRINTI	" reveals "
	CALL	PRINT-CONTENTS,PRSO
	PRINTR	"."
?ELS5:	FSET?	PRSO,DOORBIT \?ELS41
	FSET?	PRSO,OPENBIT \?ELS46
	PRINTR	"It is already open."
?ELS46:	PRINTI	"The "
	PRINTD	PRSO
	PRINTI	" opens."
	CRLF	
	FSET	PRSO,OPENBIT
	RTRUE	
?ELS41:	PRINTI	"You must tell me how to do that to a "
	PRINTD	PRSO
	PRINTR	"."


	.FUNCT	V-OVERBOARD,LOCN
	CALL	NULL-F
	ZERO?	STACK \TRUE
	LOC	WINNER
	FSET?	STACK,VEHBIT \?ELS7
	CALL	PERFORM,V?THROW,PRSO
	RTRUE	
?ELS7:	PRINTR	"Huh?"


	.FUNCT	V-PICK
	PRINTR	"You can't pick that."


	.FUNCT	V-PLAY
	FSET?	PRSO,ACTORBIT \?ELS5
	PRINTI	"You become so engrossed in the role of the "
	PRINTD	PRSO
	PRINTI	" that you kill yourself, just as he might have done!"
	CRLF	
	CALL	JIGS-UP,STR?174
	RSTACK	
?ELS5:	PRINTR	"That's silly!"


	.FUNCT	V-PLUG
	PRINTR	"This has no effect."


	.FUNCT	V-POUR-ON
	EQUAL?	PRSO,WATER \?ELS5
	CALL	REMOVE-CAREFULLY,PRSO
	FSET?	PRSI,FLAMEBIT \?ELS10
	FSET?	PRSI,ONBIT \?ELS10
	PRINTI	"The "
	PRINTD	PRSI
	PRINTI	" is extinguished."
	CRLF	
	EQUAL?	PRSI,BINF-FLAG \?CND15
	SET	'BINF-FLAG,FALSE-VALUE
?CND15:	FCLEAR	PRSI,ONBIT
	FCLEAR	PRSI,FLAMEBIT
	RTRUE	
?ELS10:	PRINTI	"The water spills over the "
	PRINTD	PRSI
	PRINTR	", to the floor, and evaporates."
?ELS5:	CALL	NULL-F
	ZERO?	STACK \TRUE
	PRINTR	"You can't pour that."


	.FUNCT	V-PRAY
	CALL	NULL-F
	ZERO?	STACK \TRUE
	PRINTR	"If you pray enough, your prayers may be answered."


	.FUNCT	V-PUMP
	CALL	NULL-F
	ZERO?	STACK \TRUE
	CALL	NULL-F
	ZERO?	STACK \TRUE
	PRINTR	"It's really not clear how."


	.FUNCT	V-PUSH
	CALL	HACK-HACK,STR?174
	RSTACK	


	.FUNCT	V-PUSH-TO
	PRINTR	"You can't push things to that."


	.FUNCT	PRE-PUT
	CALL	NULL-F
	ZERO?	STACK \FALSE
	CALL	PRE-GIVE
	RSTACK	


	.FUNCT	V-PUT,?TMP1
	FSET?	PRSI,OPENBIT /?CND1
	FSET?	PRSI,DOORBIT /?CND1
	FSET?	PRSI,CONTBIT /?CND1
	FSET?	PRSI,VEHBIT \?ELS3
	JUMP	?CND1
?ELS3:	PRINTR	"You can't do that."
?CND1:	FSET?	PRSI,OPENBIT /?ELS14
	PRINTI	"The "
	PRINTD	PRSI
	PRINTI	" isn't open."
	CRLF	
	CALL	THIS-IS-IT,PRSI
	RSTACK	
?ELS14:	EQUAL?	PRSI,PRSO \?ELS18
	PRINTR	"How can you do that?"
?ELS18:	IN?	PRSO,PRSI \?ELS22
	PRINTI	"The "
	PRINTD	PRSO
	PRINTI	" is already in the "
	PRINTD	PRSI
	PRINTR	"."
?ELS22:	CALL	WEIGHT,PRSI >?TMP1
	CALL	WEIGHT,PRSO
	ADD	?TMP1,STACK >?TMP1
	GETP	PRSI,P?SIZE
	SUB	?TMP1,STACK >?TMP1
	GETP	PRSI,P?CAPACITY
	GRTR?	?TMP1,STACK \?ELS26
	PRINTR	"There's no room."
?ELS26:	CALL	HELD?,PRSO
	ZERO?	STACK \?ELS30
	FSET?	PRSO,TRYTAKEBIT \?ELS30
	PRINTI	"You don't have the "
	PRINTD	PRSO
	PRINTR	"."
?ELS30:	CALL	HELD?,PRSO
	ZERO?	STACK \?ELS36
	CALL	ITAKE
	ZERO?	STACK /TRUE
?ELS36:	MOVE	PRSO,PRSI
	FSET	PRSO,TOUCHBIT
	CALL	SCORE-OBJ,PRSO
	PRINTR	"Done."


	.FUNCT	V-PUT-BEHIND
	PRINTR	"That hiding place is too obvious."


	.FUNCT	V-PUT-ON
	EQUAL?	PRSI,GROUND \?ELS5
	CALL	PERFORM,V?DROP,PRSO
	RTRUE	
?ELS5:	FSET?	PRSI,SURFACEBIT \?ELS7
	CALL	V-PUT
	RSTACK	
?ELS7:	PRINTI	"There's no good surface on the "
	PRINTD	PRSI
	PRINTR	"."


	.FUNCT	V-PUT-UNDER
	PRINTR	"You can't do that."


	.FUNCT	V-RAISE
	CALL	V-LOWER
	RSTACK	


	.FUNCT	V-RAPE
	PRINTR	"What a (ahem!) strange idea."


	.FUNCT	PRE-READ
	ZERO?	LIT \?ELS5
	PRINTR	"It is impossible to read in the dark."
?ELS5:	ZERO?	PRSI /FALSE
	FSET?	PRSI,TRANSBIT /FALSE
	PRINTI	"How does one look through a "
	PRINTD	PRSI
	PRINTR	"?"


	.FUNCT	V-READ
	FSET?	PRSO,READBIT /?ELS5
	PRINTI	"How does one read a "
	PRINTD	PRSO
	PRINTR	"?"
?ELS5:	GETP	PRSO,P?TEXT
	PRINT	STACK
	CRLF	
	RTRUE	


	.FUNCT	V-READ-PAGE
	CALL	PERFORM,V?READ,PRSO
	RTRUE	


	.FUNCT	V-REPENT
	PRINTR	"It could very well be too late!"


	.FUNCT	V-REPLY
	PRINTI	"It is hardly likely that the "
	PRINTD	PRSO
	PRINTI	" is interested."
	CRLF	
	SET	'P-CONT,FALSE-VALUE
	SET	'QUOTE-FLAG,FALSE-VALUE
	RTRUE	


	.FUNCT	V-RING
	PRINTR	"How, exactly, can you ring that?"


	.FUNCT	V-RUB
	CALL	HACK-HACK,STR?175
	RSTACK	


	.FUNCT	V-SAY,V
	ZERO?	SPELL-USED \?THN4
	ZERO?	WAND-ON /?CND1
?THN4:	CALL	PERFORM,V?INCANT
	RTRUE	
?CND1:	CALL	FIND-IN,HERE,ACTORBIT >V
	ZERO?	V /?ELS10
	PRINTI	"You must address the "
	PRINTD	V
	PRINTI	" directly."
	CRLF	
	SET	'QUOTE-FLAG,FALSE-VALUE
	SET	'P-CONT,FALSE-VALUE
	RETURN	P-CONT
?ELS10:	GET	P-LEXV,P-CONT
	EQUAL?	STACK,W?HELLO \?ELS14
	SET	'QUOTE-FLAG,FALSE-VALUE
	RTRUE	
?ELS14:	SET	'QUOTE-FLAG,FALSE-VALUE
	SET	'P-CONT,FALSE-VALUE
	PRINTR	"Talking to yourself is a sign of impending mental collapse."


	.FUNCT	V-SEARCH
	PRINTR	"You find nothing unusual."


	.FUNCT	V-SEND
	FSET?	PRSO,ACTORBIT \?ELS5
	PRINTI	"Why would you send for the "
	PRINTD	PRSO
	PRINTR	"?"
?ELS5:	PRINTR	"That doesn't make sends."


	.FUNCT	PRE-SGIVE
	CALL	PERFORM,V?GIVE,PRSI,PRSO
	RTRUE	


	.FUNCT	V-SGIVE
	PRINTR	"Foo!"


	.FUNCT	V-SHAKE
	FSET?	PRSO,ACTORBIT \?ELS5
	PRINTR	"This seems to have no effect."
?ELS5:	FSET?	PRSO,TAKEBIT /?ELS9
	PRINTR	"You can't take it; thus, you can't shake it!"
?ELS9:	FSET?	PRSO,CONTBIT \?ELS13
	FSET?	PRSO,OPENBIT \?ELS18
	FIRST?	PRSO \?ELS23
	CALL	SHAKE-LOOP
	PRINTI	"The contents of the "
	PRINTD	PRSO
	PRINTI	" spill "
	FSET?	HERE,RLANDBIT /?ELS28
	PRINTI	"out and disappears"
	JUMP	?CND26
?ELS28:	PRINTI	"to the ground"
?CND26:	PRINTR	"."
?ELS23:	PRINTR	"Shaken."
?ELS18:	FIRST?	PRSO \?ELS47
	PRINTI	"It sounds like there is something inside the "
	PRINTD	PRSO
	PRINTR	"."
?ELS47:	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" sounds empty."
?ELS13:	PRINTR	"Shaken."


	.FUNCT	SHAKE-LOOP,X
?PRG1:	FIRST?	PRSO >X \TRUE
	FSET	X,TOUCHBIT
	EQUAL?	X,WATER \?ELS10
	PUSH	PSEUDO-OBJECT
	JUMP	?CND6
?ELS10:	FSET?	HERE,RLANDBIT /?ELS12
	PUSH	PSEUDO-OBJECT
	JUMP	?CND6
?ELS12:	PUSH	HERE
?CND6:	MOVE	X,STACK
	JUMP	?PRG1


	.FUNCT	V-SKIP
	CALL	PICK-ONE,WHEEEEE
	PRINT	STACK
	CRLF	
	RTRUE	


	.FUNCT	V-SMELL
	PRINTI	"It smells like a "
	PRINTD	PRSO
	PRINTR	"."


	.FUNCT	V-SPIN
	PRINTR	"You can't spin that!"


	.FUNCT	V-SPRAY
	CALL	V-SQUEEZE
	RSTACK	


	.FUNCT	V-SQUEEZE
	FSET?	PRSO,ACTORBIT \?ELS3
	PRINTI	"The "
	PRINTD	PRSO
	PRINTI	" does not understand this."
	JUMP	?CND1
?ELS3:	PRINTI	"How singularly useless."
?CND1:	CRLF	
	RTRUE	


	.FUNCT	V-SSPRAY
	CALL	PERFORM,V?SPRAY,PRSI,PRSO
	RSTACK	


	.FUNCT	V-STAB,W
	CALL	FIND-WEAPON,WINNER >W
	ZERO?	W /?ELS5
	CALL	PERFORM,V?ATTACK,PRSO,W
	RTRUE	
?ELS5:	PRINTI	"No doubt you propose to stab the "
	PRINTD	PRSO
	PRINTR	" with your pinky?"


	.FUNCT	V-STAND
	LOC	WINNER
	FSET?	STACK,VEHBIT \?ELS5
	LOC	WINNER
	CALL	PERFORM,V?DISEMBARK,STACK
	RTRUE	
?ELS5:	PRINTR	"You are already standing, I think."


	.FUNCT	V-STAY
	PRINTR	"You will be lost without me!"


	.FUNCT	V-STRIKE
	FSET?	PRSO,ACTORBIT \?ELS5
	PRINTI	"Since you aren't versed in hand-to-hand combat, you'd better attack the "
	PRINTD	PRSO
	PRINTR	" with a weapon."
?ELS5:	CALL	PERFORM,V?LAMP-ON,PRSO
	RTRUE	


	.FUNCT	V-SWIM
	CALL	GLOBAL-IN?,GLOBAL-WATER,HERE
	ZERO?	STACK /?ELS5
	PRINTI	"Swimming isn't usually allowed in the "
	EQUAL?	PRSO,WATER,GLOBAL-WATER /?ELS10
	PRINTD	PRSO
	PRINTI	"."
	JUMP	?CND8
?ELS10:	PRINTI	"dungeon."
?CND8:	CRLF	
	RTRUE	
?ELS5:	CALL	NULL-F
	ZERO?	STACK \FALSE
	PRINTR	"Go jump in a lake!"


	.FUNCT	V-SWING
	ZERO?	PRSI \?ELS5
	PRINTR	"Whoosh!"
?ELS5:	CALL	PERFORM,V?ATTACK,PRSI,PRSO
	RSTACK	


	.FUNCT	PRE-TAKE
	IN?	PRSO,WINNER \?ELS5
	FSET?	PRSO,WEARBIT \?ELS10
	PRINTR	"You are already wearing it."
?ELS10:	PRINTR	"You already have that!"
?ELS5:	LOC	PRSO
	FSET?	STACK,CONTBIT \?ELS18
	LOC	PRSO
	FSET?	STACK,OPENBIT /?ELS18
	PRINTR	"You can't reach something that's inside a closed container."
?ELS18:	ZERO?	PRSI /?ELS24
	EQUAL?	PRSI,GROUND \?CND26
	SET	'PRSI,FALSE-VALUE
	RFALSE	
?CND26:	EQUAL?	PRSO,DOOR-KEEPER \?CND29
	SET	'PRSI,FALSE-VALUE
	RFALSE	
?CND29:	LOC	PRSO
	EQUAL?	PRSI,STACK /?ELS36
	PRINTI	"The "
	PRINTD	PRSO
	PRINTI	" isn't in the "
	PRINTD	PRSI
	PRINTR	"."
?ELS36:	SET	'PRSI,FALSE-VALUE
	RFALSE	
?ELS24:	LOC	WINNER
	EQUAL?	PRSO,STACK \FALSE
	PRINTR	"You're inside of it!"


	.FUNCT	V-TAKE
	CALL	ITAKE
	EQUAL?	STACK,TRUE-VALUE \FALSE
	FSET?	PRSO,WEARBIT \?ELS10
	PRINTI	"You are now wearing the "
	PRINTD	PRSO
	PRINTR	"."
?ELS10:	PRINTR	"Taken."


	.FUNCT	V-TELL
	FSET?	PRSO,ACTORBIT \?ELS5
	ZERO?	P-CONT /?ELS10
	SET	'WINNER,PRSO
	LOC	WINNER >HERE
	RETURN	HERE
?ELS10:	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" pauses for a moment, perhaps thinking that you should reread the manual."
?ELS5:	PRINTI	"You can't talk to the "
	PRINTD	PRSO
	PRINTI	"!"
	CRLF	
	SET	'QUOTE-FLAG,FALSE-VALUE
	SET	'P-CONT,FALSE-VALUE
	RETURN	2


	.FUNCT	V-THROUGH,OBJ=0,M
	FSET?	PRSO,DOORBIT \?ELS5
	CALL	OTHER-SIDE,PRSO >M
	ZERO?	M /?ELS5
	CALL	DO-WALK,M
	RTRUE	
?ELS5:	ZERO?	OBJ \?ELS9
	FSET?	PRSO,VEHBIT \?ELS9
	CALL	PERFORM,V?BOARD,PRSO
	RTRUE	
?ELS9:	ZERO?	OBJ \?THN14
	FSET?	PRSO,TAKEBIT /?ELS13
?THN14:	ZERO?	SCOL-ROOM /?ELS18
	ZERO?	OBJ \?THN21
	EQUAL?	PRSO,CURTAIN \?ELS18
?THN21:	CALL	SCOL-GO,OBJ
	RTRUE	
?ELS18:	EQUAL?	HERE,DEPOSITORY \?ELS24
	EQUAL?	PRSO,SNWL \?ELS24
	ZERO?	SCOL-ROOM /?ELS24
	CALL	SCOL-GO,OBJ
	RTRUE	
?ELS24:	EQUAL?	HERE,SCOL-ACTIVE \?ELS28
	CALL	GET-WALL,HERE >M
	GET	M,1
	EQUAL?	PRSO,STACK \?ELS28
	GET	M,2 >SCOL-ROOM
	GETP	PRSO,P?SIZE >PRSO
	ZERO?	OBJ /?ELS33
	CALL	SCOL-OBJ,OBJ,0,DEPOSITORY
	RTRUE	
?ELS33:	CALL	SCOL-THROUGH,0,DEPOSITORY
	RTRUE	
?ELS28:	EQUAL?	PRSO,CURTAIN \?CND16
	PRINTR	"You can't go more than part way through the curtain."
?CND16:	PRINTI	"You hit your head against the "
	PRINTD	PRSO
	PRINTR	" as you attempt this feat."
?ELS13:	IN?	PRSO,WINNER \?ELS44
	PRINTR	"That would involve quite a contortion!"
?ELS44:	CALL	PICK-ONE,YUKS
	PRINT	STACK
	CRLF	
	RTRUE	


	.FUNCT	V-THROW
	CALL	IDROP
	ZERO?	STACK /?ELS5
	EQUAL?	PRSI,ME \?ELS10
	PRINTI	"A terrific throw! The "
	PRINTD	PRSO
	SET	'WINNER,PLAYER
	CALL	JIGS-UP,STR?180
	RSTACK	
?ELS10:	ZERO?	PRSI /?ELS14
	FSET?	PRSI,ACTORBIT \?ELS14
	PRINTI	"The "
	PRINTD	PRSI
	PRINTI	" ducks as the "
	PRINTD	PRSO
	PRINTR	" flies by and crashes to the ground."
?ELS14:	PRINTR	"Thrown."
?ELS5:	PRINTR	"Huh?"


	.FUNCT	V-THROW-OFF
	PRINTR	"You can't throw anything off of that!"


	.FUNCT	V-TIE
	EQUAL?	PRSI,WINNER \?ELS5
	PRINTR	"You can't tie anything to yourself."
?ELS5:	PRINTI	"You can't tie the "
	PRINTD	PRSO
	PRINTR	" to that."


	.FUNCT	V-TIE-UP
	PRINTR	"You could certainly never tie it with that!"


	.FUNCT	V-TREASURE
	CALL	NULL-F
	ZERO?	STACK \TRUE
	CALL	NULL-F
	ZERO?	STACK \TRUE
	PRINTR	"Nothing happens."


	.FUNCT	PRE-TURN
	EQUAL?	PRSI,FALSE-VALUE,ROOMS \?ELS5
	PRINTR	"Your bare hands don't appear to be enough."
?ELS5:	FSET?	PRSO,TURNBIT /FALSE
	PRINTR	"You can't turn that!"


	.FUNCT	V-TURN
	PRINTR	"This has no effect."


	.FUNCT	V-UNLOCK
	CALL	V-LOCK
	RSTACK	


	.FUNCT	V-UNTIE
	PRINTR	"This cannot be tied, so it cannot be untied!"


	.FUNCT	V-WAIT,NUM=3
	PRINTI	"Time passes..."
	CRLF	
?PRG3:	DLESS?	'NUM,0 \?ELS7
	JUMP	?REP4
?ELS7:	CALL	CLOCKER
	ZERO?	STACK /?PRG3
?REP4:	SET	'CLOCK-WAIT,TRUE-VALUE
	RETURN	CLOCK-WAIT


	.FUNCT	V-WALK,PT,PTS,STR,OBJ,RM
	ZERO?	P-WALK-DIR \?ELS5
	CALL	PERFORM,V?WALK-TO,PRSO
	RTRUE	
?ELS5:	GETPT	HERE,PRSO >PT
	ZERO?	PT /?ELS7
	PTSIZE	PT >PTS
	EQUAL?	PTS,UEXIT \?ELS12
	GETB	PT,REXIT
	CALL	GOTO,STACK
	RSTACK	
?ELS12:	EQUAL?	PTS,NEXIT \?ELS14
	GET	PT,NEXITSTR
	PRINT	STACK
	CRLF	
	RETURN	2
?ELS14:	EQUAL?	PTS,FEXIT \?ELS20
	GET	PT,FEXITFCN
	CALL	STACK >RM
	ZERO?	RM /?ELS25
	CALL	GOTO,RM
	RSTACK	
?ELS25:	CALL	NULL-F
	ZERO?	STACK \FALSE
	RETURN	2
?ELS20:	EQUAL?	PTS,CEXIT \?ELS33
	GETB	PT,CEXITFLAG
	VALUE	STACK
	ZERO?	STACK /?ELS38
	GETB	PT,REXIT
	CALL	GOTO,STACK
	RSTACK	
?ELS38:	GET	PT,CEXITSTR >STR
	ZERO?	STR /?ELS40
	PRINT	STR
	CRLF	
	RETURN	2
?ELS40:	PRINTI	"You can't go that way."
	CRLF	
	RETURN	2
?ELS33:	EQUAL?	PTS,DEXIT \FALSE
	GETB	PT,DEXITOBJ >OBJ
	FSET?	OBJ,OPENBIT \?ELS57
	GETB	PT,REXIT
	CALL	GOTO,STACK
	RSTACK	
?ELS57:	GET	PT,DEXITSTR >STR
	ZERO?	STR /?ELS59
	PRINT	STR
	CRLF	
	RETURN	2
?ELS59:	PRINTI	"The "
	PRINTD	OBJ
	PRINTI	" is closed."
	CRLF	
	CALL	THIS-IS-IT,OBJ
	RETURN	2
?ELS7:	ZERO?	LIT \?ELS71
	RANDOM	100
	GRTR?	80,STACK \?ELS71
	EQUAL?	WINNER,ADVENTURER \?ELS71
	FSET?	HERE,NONLANDBIT /?ELS71
	ZERO?	SPRAYED? /?ELS78
	PRINTI	"There are odd noises in the darkness, and there is no exit in that direction."
	CRLF	
	RETURN	2
?ELS78:	CALL	NULL-F
	ZERO?	STACK \FALSE
	CALL	JIGS-UP,STR?181
	RSTACK	
?ELS71:	PRINTI	"You can't go that way."
	CRLF	
	RETURN	2


	.FUNCT	V-WALK-AROUND
	PRINTR	"Use compass directions for movement."


	.FUNCT	V-WALK-TO
	ZERO?	PRSO /?ELS5
	IN?	PRSO,HERE /?THN8
	CALL	GLOBAL-IN?,PRSO,HERE
	ZERO?	STACK /?ELS5
?THN8:	PRINTR	"It's here!"
?ELS5:	PRINTR	"You should supply a direction!"


	.FUNCT	V-WAVE
	CALL	HACK-HACK,STR?182
	RSTACK	


	.FUNCT	V-WEAR
	FSET?	PRSO,WEARBIT /?ELS5
	PRINTI	"You can't wear the "
	PRINTD	PRSO
	PRINTR	"."
?ELS5:	CALL	PERFORM,V?TAKE,PRSO
	RTRUE	


	.FUNCT	V-WIN
	PRINTR	"Naturally!"


	.FUNCT	V-WIND
	PRINTI	"You cannot wind up a "
	PRINTD	PRSO
	PRINTR	"."


	.FUNCT	V-WISH
	CALL	PERFORM,V?MAKE,WISH
	RSTACK	


	.FUNCT	V-YELL
	PRINTR	"Aaaarrrrgggghhhh!"


	.FUNCT	V-ZORK
	PRINTR	"At your service!"


	.FUNCT	V-FIRST-LOOK
	CALL	DESCRIBE-ROOM
	ZERO?	STACK /FALSE
	ZERO?	SUPER-BRIEF \FALSE
	CALL	DESCRIBE-OBJECTS
	RSTACK	


	.FUNCT	DESCRIBE-ROOM,LOOK?=0,V?,STR,AV
	ZERO?	LOOK? /?ORP4
	PUSH	LOOK?
	JUMP	?THN1
?ORP4:	PUSH	VERBOSE
?THN1:	POP	'V?
	ZERO?	LIT \?CND5
	PRINTI	"It is pitch black."
	ZERO?	SPRAYED? \?CND10
	PRINTI	" You are likely to be eaten by a grue."
?CND10:	CRLF	
	CALL	NULL-F
	RFALSE	
?CND5:	FSET?	HERE,TOUCHBIT /?CND15
	FSET	HERE,TOUCHBIT
	SET	'V?,TRUE-VALUE
?CND15:	CALL	NULL-F
	IN?	HERE,ROOMS \?CND18
	PRINTD	HERE
	LOC	WINNER >AV
	FSET?	AV,VEHBIT \?CND23
	PRINTI	", in the "
	PRINTD	AV
?CND23:	CRLF	
?CND18:	ZERO?	LOOK? \?THN31
	ZERO?	SUPER-BRIEF /?THN31
	EQUAL?	HERE,ZORK3 \TRUE
?THN31:	LOC	WINNER >AV
	ZERO?	V? /?ELS35
	GETP	HERE,P?ACTION
	CALL	STACK,M-LOOK
	ZERO?	STACK \TRUE
?ELS35:	ZERO?	V? /?ELS39
	GETP	HERE,P?LDESC >STR
	ZERO?	STR /?ELS39
	PRINT	STR
	CRLF	
	JUMP	?CND33
?ELS39:	GETP	HERE,P?ACTION
	CALL	STACK,M-FLASH
?CND33:	EQUAL?	HERE,AV /TRUE
	FSET?	AV,VEHBIT \TRUE
	GETP	AV,P?ACTION
	CALL	STACK,M-LOOK
	RTRUE	


	.FUNCT	DESCRIBE-OBJECTS,V?=0
	ZERO?	LIT /?ELS5
	FIRST?	HERE \FALSE
	ZERO?	V? /?ORP15
	PUSH	V?
	JUMP	?THN12
?ORP15:	PUSH	VERBOSE
?THN12:	POP	'V?
	CALL	PRINT-CONT,HERE,V?,-1
	RSTACK	
?ELS5:	PRINTR	"Only bats can see in the dark. And you're not one."


	.FUNCT	DESCRIBE-OBJECT,OBJ,V?,LEVEL,STR=0,AV
	SET	'DESC-OBJECT,OBJ
	ZERO?	LEVEL \?ELS3
	GETP	OBJ,P?DESCFCN
	CALL	STACK,M-OBJDESC
	ZERO?	STACK \TRUE
?ELS3:	ZERO?	LEVEL \?ELS7
	FSET?	OBJ,TOUCHBIT /?ELS13
	GETP	OBJ,P?FDESC >STR
	ZERO?	STR \?THN10
?ELS13:	GETP	OBJ,P?LDESC >STR
	ZERO?	STR /?ELS7
?THN10:	PRINT	STR
	JUMP	?CND1
?ELS7:	ZERO?	LEVEL \?ELS17
	PRINTI	"There is a "
	PRINTD	OBJ
	PRINTI	" here"
	FSET?	OBJ,ONBIT \?CND20
	PRINTI	" (providing light)"
?CND20:	PRINTI	"."
	JUMP	?CND1
?ELS17:	GET	INDENTS,LEVEL
	PRINT	STACK
	PRINTI	"A "
	PRINTD	OBJ
	FSET?	OBJ,ONBIT \?ELS35
	PRINTI	" (providing light)"
	JUMP	?CND1
?ELS35:	FSET?	OBJ,WEARBIT \?CND1
	IN?	OBJ,WINNER \?CND1
	PRINTI	" (being worn)"
?CND1:	EQUAL?	OBJ,SPELL-VICTIM \?CND44
	EQUAL?	SPELL-USED,W?FLOAT \?CND44
	PRINTI	" (floating in midair)"
?CND44:	ZERO?	LEVEL \?CND51
	LOC	WINNER >AV
	ZERO?	AV /?CND51
	FSET?	AV,VEHBIT \?CND51
	PRINTI	" (outside the "
	PRINTD	AV
	PRINTI	")"
?CND51:	CRLF	
	CALL	SEE-INSIDE?,OBJ
	ZERO?	STACK /FALSE
	FIRST?	OBJ \FALSE
	CALL	PRINT-CONT,OBJ,V?,LEVEL
	RSTACK	


	.FUNCT	PRINT-CONTENTS,OBJ,F,N,1ST?=1,IT?=0,TWO?=0
	FIRST?	OBJ >F \FALSE
?PRG6:	NEXT?	F >N /?KLU38
?KLU38:	ZERO?	1ST? /?ELS10
	SET	'1ST?,FALSE-VALUE
	JUMP	?CND8
?ELS10:	PRINTI	", "
	ZERO?	N \?CND8
	PRINTI	"and "
?CND8:	PRINTI	"a "
	PRINTD	F
	ZERO?	IT? \?ELS25
	ZERO?	TWO? \?ELS25
	SET	'IT?,F
	JUMP	?CND23
?ELS25:	SET	'TWO?,TRUE-VALUE
	SET	'IT?,FALSE-VALUE
?CND23:	SET	'F,N
	ZERO?	F \?PRG6
	ZERO?	IT? /TRUE
	ZERO?	TWO? \TRUE
	CALL	THIS-IS-IT,IT?
	RTRUE	


	.FUNCT	PRINT-CONT,OBJ,V?=0,LEVEL=0,Y,1ST?,SHIT,AV,STR,PV?=0,INV?=0
	FIRST?	OBJ >Y \TRUE
	LOC	WINNER >AV
	ZERO?	AV /?ELS6
	FSET?	AV,VEHBIT \?ELS6
	JUMP	?CND4
?ELS6:	SET	'AV,FALSE-VALUE
?CND4:	SET	'1ST?,TRUE-VALUE
	SET	'SHIT,TRUE-VALUE
	LOC	OBJ
	EQUAL?	WINNER,OBJ,STACK \?ELS13
	SET	'INV?,TRUE-VALUE
	JUMP	?CND11
?ELS13:	
?PRG16:	ZERO?	Y \?ELS20
	ZERO?	LEVEL \?REP17
	EQUAL?	SPELL?,S-FANTASIZE \?REP17
	RANDOM	100
	GRTR?	20,STACK \?REP17
	PRINTI	"There is a "
	CALL	PICK-ONE,FANTASIES
	PRINT	STACK
	PRINTI	" here."
	CRLF	
	SET	'1ST?,FALSE-VALUE
	JUMP	?REP17
?ELS20:	EQUAL?	Y,AV \?ELS29
	SET	'PV?,TRUE-VALUE
	JUMP	?CND18
?ELS29:	EQUAL?	Y,WINNER \?ELS31
	JUMP	?CND18
?ELS31:	FSET?	Y,INVISIBLE /?CND18
	FSET?	Y,TOUCHBIT /?CND18
	GETP	Y,P?FDESC >STR
	ZERO?	STR /?CND18
	FSET?	Y,NDESCBIT /?CND36
	PRINT	STR
	CRLF	
	SET	'SHIT,FALSE-VALUE
?CND36:	CALL	SEE-INSIDE?,Y
	ZERO?	STACK /?CND18
	LOC	Y
	GETP	STACK,P?DESCFCN
	ZERO?	STACK \?CND18
	FIRST?	Y \?CND18
	CALL	PRINT-CONT,Y,V?,0
	ZERO?	STACK /?CND41
	SET	'1ST?,FALSE-VALUE
?CND41:	
?CND18:	NEXT?	Y >Y /?KLU96
?KLU96:	JUMP	?PRG16
?REP17:	
?CND11:	FIRST?	OBJ >Y /?KLU97
?KLU97:	
?PRG49:	ZERO?	Y \?ELS53
	ZERO?	PV? /?REP50
	ZERO?	AV /?REP50
	FIRST?	AV \?REP50
	INC	'LEVEL
	CALL	PRINT-CONT,AV,V?,LEVEL
	JUMP	?REP50
?ELS53:	EQUAL?	Y,AV,ADVENTURER \?ELS60
	JUMP	?CND51
?ELS60:	FSET?	Y,INVISIBLE /?CND51
	ZERO?	INV? \?THN65
	FSET?	Y,TOUCHBIT /?THN65
	GETP	Y,P?FDESC
	ZERO?	STACK \?CND51
?THN65:	FSET?	Y,NDESCBIT /?ELS69
	ZERO?	1ST? /?CND70
	CALL	FIRSTER,OBJ,LEVEL
	ZERO?	STACK /?CND74
	LESS?	LEVEL,0 \?CND74
	SET	'LEVEL,0
?CND74:	INC	'LEVEL
	SET	'1ST?,FALSE-VALUE
?CND70:	LESS?	LEVEL,0 \?CND80
	SET	'LEVEL,0
?CND80:	CALL	DESCRIBE-OBJECT,Y,V?,LEVEL
	JUMP	?CND51
?ELS69:	FIRST?	Y \?CND51
	CALL	SEE-INSIDE?,Y
	ZERO?	STACK /?CND51
	INC	'LEVEL
	CALL	PRINT-CONT,Y,V?,LEVEL
	DEC	'LEVEL
?CND51:	NEXT?	Y >Y /?KLU98
?KLU98:	JUMP	?PRG49
?REP50:	ZERO?	1ST? /TRUE
	ZERO?	SHIT /TRUE
	RFALSE	


	.FUNCT	FIRSTER,OBJ,LEVEL
	CALL	NULL-F
	ZERO?	STACK \TRUE
	EQUAL?	OBJ,WINNER \?ELS7
	PRINTR	"You are carrying:"
?ELS7:	IN?	OBJ,ROOMS /FALSE
	GRTR?	LEVEL,0 \?CND12
	GET	INDENTS,LEVEL
	PRINT	STACK
?CND12:	FSET?	OBJ,SURFACEBIT \?ELS21
	PRINTI	"Sitting on the "
	PRINTD	OBJ
	PRINTR	" is: "
?ELS21:	FSET?	OBJ,ACTORBIT \?ELS25
	PRINTI	"The "
	PRINTD	OBJ
	PRINTR	" is holding: "
?ELS25:	PRINTI	"The "
	PRINTD	OBJ
	PRINTR	" contains:"


	.FUNCT	SEE-INSIDE?,OBJ
	FSET?	OBJ,INVISIBLE /FALSE
	FSET?	OBJ,TRANSBIT /TRUE
	FSET?	OBJ,OPENBIT /TRUE
	RFALSE	


	.FUNCT	SCORE-UPD,NUM
	ADD	BASE-SCORE,NUM >BASE-SCORE
	ADD	SCORE,NUM >SCORE
	CALL	NULL-F
	RTRUE	


	.FUNCT	SCORE-OBJ,OBJ,TEMP
	GETP	OBJ,P?VALUE >TEMP
	GRTR?	TEMP,0 \FALSE
	CALL	SCORE-UPD,TEMP
	PUTP	OBJ,P?VALUE,0
	RTRUE	


	.FUNCT	YES?
	PRINTI	">"
	READ	P-INBUF,P-LEXV
	GET	P-LEXV,1
	EQUAL?	STACK,W?YES,W?Y \FALSE
	RTRUE	


	.FUNCT	ITAKE,VB=1,CNT,OBJ,?TMP1
	CALL	NULL-F
	ZERO?	STACK \FALSE
	FSET?	PRSO,TAKEBIT /?ELS7
	ZERO?	VB /FALSE
	CALL	PICK-ONE,YUKS
	PRINT	STACK
	CRLF	
	RFALSE	
?ELS7:	EQUAL?	PRSO,SPELL-VICTIM \?ELS15
	EQUAL?	SPELL-USED,W?FLOAT,W?FREEZE \?ELS15
	EQUAL?	SPELL-USED,W?FLOAT \?ELS20
	PRINTI	"You can't reach that. It's floating above your head."
	CRLF	
	RFALSE	
?ELS20:	PRINTI	"It seems rooted to the spot."
	CRLF	
	RFALSE	
?ELS15:	LOC	PRSO
	FSET?	STACK,CONTBIT \?ELS28
	LOC	PRSO
	FSET?	STACK,OPENBIT \FALSE
?ELS28:	LOC	PRSO
	IN?	STACK,WINNER /?ELS32
	CALL	WEIGHT,PRSO >?TMP1
	CALL	WEIGHT,WINNER
	ADD	?TMP1,STACK
	GRTR?	STACK,LOAD-ALLOWED \?ELS32
	ZERO?	VB /?CND35
	PRINTI	"Your load is too heavy"
	LESS?	LOAD-ALLOWED,LOAD-MAX \?ELS43
	PRINTI	", especially in light of your condition."
	JUMP	?CND41
?ELS43:	PRINTI	"."
?CND41:	CRLF	
?CND35:	RETURN	2
?ELS32:	EQUAL?	PRSA,V?TAKE \?ELS53
	CALL	CCOUNT,WINNER >CNT
	GRTR?	CNT,FUMBLE-NUMBER \?ELS53
	MUL	CNT,FUMBLE-PROB >?TMP1
	RANDOM	100
	GRTR?	?TMP1,STACK \?ELS53
	PRINTI	"You're holding too many things already!"
	CRLF	
	RFALSE	
?ELS53:	MOVE	PRSO,WINNER
	FCLEAR	PRSO,NDESCBIT
	FSET	PRSO,TOUCHBIT
	EQUAL?	SPELL?,S-FILCH \?CND60
	CALL	RIPOFF,PRSO,WIZARD-CASE
	ZERO?	STACK /?CND60
	PRINTI	"When you touch the "
	PRINTD	PRSO
	PRINTI	" it immediately disappears!"
	CRLF	
	RFALSE	
?CND60:	CALL	SCORE-OBJ,PRSO
	RTRUE	


	.FUNCT	IDROP
	IN?	PRSO,WINNER /?ELS5
	LOC	PRSO
	IN?	STACK,WINNER /?ELS5
	PRINTI	"You're not carrying the "
	PRINTD	PRSO
	PRINTI	"."
	CRLF	
	RFALSE	
?ELS5:	IN?	PRSO,WINNER /?ELS11
	LOC	PRSO
	FSET?	STACK,OPENBIT /?ELS11
	PRINTI	"The "
	PRINTD	PRSO
	PRINTI	" is closed."
	CRLF	
	RFALSE	
?ELS11:	LOC	WINNER
	MOVE	PRSO,STACK
	RTRUE	


	.FUNCT	CCOUNT,OBJ,CNT=0,X
	FIRST?	OBJ >X \?CND1
?PRG4:	FSET?	X,WEARBIT /?CND6
	INC	'CNT
?CND6:	NEXT?	X >X /?PRG4
?CND1:	RETURN	CNT


	.FUNCT	WEIGHT,OBJ,CONT,WT=0
	FIRST?	OBJ >CONT \?CND1
?PRG4:	EQUAL?	OBJ,PLAYER \?ELS8
	FSET?	CONT,WEARBIT \?ELS8
	INC	'WT
	JUMP	?CND6
?ELS8:	CALL	WEIGHT,CONT
	ADD	WT,STACK >WT
?CND6:	NEXT?	CONT >CONT /?PRG4
?CND1:	GETP	OBJ,P?SIZE
	ADD	WT,STACK
	RSTACK	


	.FUNCT	HACK-HACK,STR
	IN?	PRSO,GLOBAL-OBJECTS \?ELS5
	EQUAL?	PRSA,V?LOWER,V?RAISE,V?WAVE \?ELS5
	PRINTI	"The "
	PRINTD	PRSO
	PRINTR	" isn't here!"
?ELS5:	PRINT	STR
	PRINTD	PRSO
	CALL	PICK-ONE,HO-HUM
	PRINT	STACK
	CRLF	
	RTRUE	


	.FUNCT	NO-GO-TELL,AV,WLOC
	ZERO?	AV /?ELS3
	PRINTI	"You can't go there in a "
	PRINTD	WLOC
	PRINTI	"."
	JUMP	?CND1
?ELS3:	PRINTI	"You can't go there without a vehicle."
?CND1:	CRLF	
	RTRUE	


	.FUNCT	GOTO,RM,V?=1,LB,WLOC,AV=0,OLIT,OHERE
	FSET?	RM,RLANDBIT /?PRD1
	PUSH	0
	JUMP	?PRD2
?PRD1:	PUSH	1
?PRD2:	SET	'LB,STACK
	LOC	WINNER >WLOC
	SET	'OLIT,LIT
	SET	'OHERE,HERE
	FSET?	WLOC,VEHBIT \?CND3
	GETP	WLOC,P?VTYPE >AV
?CND3:	ZERO?	LB \?ELS10
	ZERO?	AV \?ELS10
	CALL	NO-GO-TELL,AV,WLOC
	RFALSE	
?ELS10:	ZERO?	LB \?ELS14
	FSET?	RM,AV /?ELS14
	CALL	NO-GO-TELL,AV,WLOC
	RFALSE	
?ELS14:	FSET?	HERE,RLANDBIT \?ELS18
	ZERO?	LB /?ELS18
	ZERO?	AV /?ELS18
	EQUAL?	AV,RLANDBIT /?ELS18
	FSET?	RM,AV /?ELS18
	CALL	NO-GO-TELL,AV,WLOC
	RFALSE	
?ELS18:	FSET?	RM,RMUNGBIT \?ELS22
	GETP	RM,P?LDESC
	PRINT	STACK
	CRLF	
	RFALSE	
?ELS22:	ZERO?	LB /?CND27
	FSET?	HERE,RLANDBIT /?CND27
	ZERO?	DEAD \?CND27
	FSET?	WLOC,VEHBIT \?CND27
	EQUAL?	WLOC,BALLOON \?ELS34
	PRINTI	"The balloon lands."
	CRLF	
	JUMP	?CND27
?ELS34:	FSET?	WLOC,VEHBIT \?CND27
	PRINTI	"The "
	PRINTD	WLOC
	PRINTI	" comes to a stop."
	CRLF	
	CRLF	
?CND27:	ZERO?	AV /?ELS43
	MOVE	WLOC,RM
	JUMP	?CND41
?ELS43:	MOVE	WINNER,RM
?CND41:	SET	'HERE,RM
	CALL	LIT?,HERE >LIT
	ZERO?	OLIT \?CND47
	ZERO?	LIT \?CND47
	RANDOM	100
	GRTR?	80,STACK \?CND47
	ZERO?	SPRAYED? /?ELS54
	PRINTI	"There are sinister gurgling noises in the darkness all around you!"
	CRLF	
	JUMP	?CND47
?ELS54:	CALL	NULL-F
	ZERO?	STACK \FALSE
	PRINTI	"Oh, no! A lurking grue slithered into the "
	LOC	WINNER
	FSET?	STACK,VEHBIT \?ELS66
	LOC	WINNER
	PRINTD	STACK
	JUMP	?CND64
?ELS66:	PRINTI	"room"
?CND64:	CALL	JIGS-UP,STR?191
	RTRUE	
?CND47:	ZERO?	LIT \?CND73
	EQUAL?	WINNER,ADVENTURER \?CND73
	PRINTI	"You have moved into a dark place."
	CRLF	
	SET	'P-CONT,FALSE-VALUE
?CND73:	GETP	HERE,P?ACTION
	CALL	STACK,M-ENTER
	CALL	SCORE-OBJ,RM
	EQUAL?	HERE,RM \TRUE
	EQUAL?	ADVENTURER,WINNER /?ELS84
	IN?	ADVENTURER,OHERE \?ELS84
	PRINTI	"The "
	PRINTD	WINNER
	PRINTR	" leaves the room."
?ELS84:	CALL	NULL-F
	ZERO?	STACK \TRUE
	ZERO?	V? /TRUE
	EQUAL?	WINNER,ADVENTURER \TRUE
	CALL	V-FIRST-LOOK
	RTRUE	


	.FUNCT	LKP,ITM,TBL,CNT=0,LEN
	GET	TBL,0 >LEN
?PRG1:	IGRTR?	'CNT,LEN /FALSE
	GET	TBL,CNT
	EQUAL?	STACK,ITM \?PRG1
	EQUAL?	CNT,LEN /FALSE
	ADD	CNT,1
	GET	TBL,STACK
	RSTACK	


	.FUNCT	DO-WALK,DIR
	SET	'P-WALK-DIR,DIR
	CALL	PERFORM,V?WALK,DIR
	RSTACK	


	.FUNCT	GLOBAL-IN?,OBJ1,OBJ2,TX
	GETPT	OBJ2,P?GLOBAL >TX
	ZERO?	TX /FALSE
	PTSIZE	TX
	SUB	STACK,1
	CALL	ZMEMQB,OBJ1,TX,STACK
	RSTACK	


	.FUNCT	FIND-IN,WHERE,WHAT,W
	FIRST?	WHERE >W /?KLU13
?KLU13:	ZERO?	W /FALSE
?PRG4:	FSET?	W,WHAT \?ELS8
	EQUAL?	W,ADVENTURER /?ELS8
	RETURN	W
?ELS8:	NEXT?	W >W /?PRG4
	RFALSE	


	.FUNCT	HELD?,CAN
?PRG1:	LOC	CAN >CAN
	ZERO?	CAN /FALSE
	EQUAL?	CAN,WINNER \?PRG1
	RTRUE	


	.FUNCT	OTHER-SIDE,DOBJ,P=0,TX
?PRG1:	NEXTP	HERE,P >P
	LESS?	P,LOW-DIRECTION /FALSE
	GETPT	HERE,P >TX
	PTSIZE	TX
	EQUAL?	STACK,DEXIT \?PRG1
	GETB	TX,DEXITOBJ
	EQUAL?	STACK,DOBJ \?PRG1
	RETURN	P


	.FUNCT	MUNG-ROOM,RM,STR
	EQUAL?	RM,INSIDE-BARROW /FALSE
	FSET	RM,RMUNGBIT
	PUTP	RM,P?LDESC,STR
	RTRUE	


	.FUNCT	THIS-IS-IT,OBJ
	SET	'P-IT-OBJECT,OBJ
	RETURN	P-IT-OBJECT

	.ENDI
