{-# LANGUAGE CPP #-}

-----------------------------------------------------------------------------

-----------------------------------------------------------------------------

{- |
Module      :  Plugins.Monitors.ArchUpdates
Copyright   :  (c) 2024 Enrico Maria De Angelis
License     :  BSD-style (see LICENSE)

Maintainer  :  Enrico Maria De Angelis <enricomaria.dean6elis@gmail.com>
Stability   :  unstable
Portability :  unportable

An ArchLinux updates availablility plugin for Xmobar
-}
module Xmobar.Plugins.ArchUpdates (ArchUpdates (..)) where

import Xmobar.Plugins.Command (Rate)
import Xmobar.Plugins.PacmanUpdates (PacmanUpdates (PacmanUpdates))
import Xmobar.Run.Exec

data ArchUpdates = ArchUpdates (String, String, String) Rate
  deriving (Read, Show)

intoPacmanUpdates :: ArchUpdates -> PacmanUpdates
intoPacmanUpdates (ArchUpdates (z, o, m) r) =
  PacmanUpdates (z <> deprecation, o, m, "pacman: Unknown cause of failure.") r
 where
  deprecation = " <fc=#ff0000>(<action=`xdg-open https://codeberg.org/xmobar/xmobar/pulls/723`>deprecated plugin, click here</action>)</fc>"

instance Exec ArchUpdates where
  alias = const "arch"
  rate = rate . intoPacmanUpdates
  run = run . intoPacmanUpdates
