-- autogenerated from https://www.unicode.org/Public/17.0.0/ucd/UnicodeData.txt
-- |
-- Module      : Unicode.Internal.Char.UnicodeData.Decomposable
-- Copyright   : (c) 2020 Composewell Technologies and Contributors
-- License     : Apache-2.0
-- Maintainer  : streamly@composewell.com
-- Stability   : experimental

{-# OPTIONS_HADDOCK hide #-}

module Unicode.Internal.Char.UnicodeData.Decomposable
(isDecomposable)
where

import Data.Bits (Bits(..))
import Data.Char (ord)
import Data.Int (Int8)
import Data.Word (Word16, Word8)
import GHC.Exts (Ptr(..))
import Unicode.Internal.Bits (lookupBit, lookupWord16AsInt, lookupWord8AsInt)

{-# INLINE isDecomposable #-}
isDecomposable :: Char -> Bool
isDecomposable c = c >= '\x00C0' && c <= '\x2FA1D' && lookupIsDecomposableBitMap (ord c)

{-# INLINE lookupIsDecomposableBitMap #-}
lookupIsDecomposableBitMap :: Int -> Bool
lookupIsDecomposableBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets1# (
            lookupWord8AsInt offsets2# (
                n `shiftR` 12
            ) + ((n `shiftR` 9) .&. maskOffsets)
        ) + ((n `shiftR` 3) .&. maskData)
    ) (n .&. 7)
    where
    maskData = (1 `shiftL` 6) - 1
    maskOffsets = (1 `shiftL` 3) - 1
    !(Ptr data#) = isDecomposableDataBitMap
    !(Ptr offsets1#) = isDecomposableOffsets1BitMap
    !(Ptr offsets2#) = isDecomposableOffsets2BitMap

isDecomposableDataBitMap :: Ptr Int8
isDecomposableDataBitMap = Ptr
    "\255\255\255\207\192\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\27\0\0\0\0\0\16\64\224\215\
    \\1\0\0\252\1\0\0\124\24\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\88\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\12\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\24\0\0\0\0\0\0\40\64\2\0\0\0\0\0\160\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\8\32\132\16\0\2\104\1\2\0\8\32\132\16\0\2\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\129\13\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\28\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\116\0\0\0\0\139\112\0\2\0\0\0\
    \\2\0\0\139\112\0\0\192\0\0\0\0\0\0\0\0\0\6\0\207\252\252\252\63\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\16\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\64\85\4\0\0\0\0\40\11\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\192\31\0\0\0\0\0\0\0\0\0\0\248\1\0\0\0\0\0\0\0\0\0\80\85\85\
    \\165\2\219\54\0\0\16\64\0\80\85\85\165\2\219\54\0\0\144\71\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\11\255\255\255\255\255\255\255\255\255\255\255\3\255\255\63\63\255\255\255\255\63\63\255\170\255\255\255\63\255\255\255\255\255\
    \\255\223\95\222\255\207\239\255\255\220\63\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\64\12\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\12\0\64\0\0\0\224\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\254\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\88\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\12\
    \\0\0\0\0\0\0\0\0\0\0\0\0\64\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\16\0\0\0\0\0\0\0\64\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\8\32\
    \\132\16\0\2\104\1\2\0\8\32\132\16\0\2\0\0\0\0\0\0\0\0\0\0\0\0\124\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\5\0\8\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\18\0\0\0\0\255\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\24\0\176\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\20\0\8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\192\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\24\0\0\0\0\0\0\40\
    \\64\2\0\0\0\0\0\160\1\0\0\0\0\0\0\16\18\0\0\80\0\0\0\146\2\0\0\5\224\51\3\51\3\0\0\0\240\0\0\0\0\0\0\15\60\0\0\0\0\0\
    \\0\0\6\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\254\1\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\191\255\126\62\191\255\126\190\255\255\252\255\63\255\241\126\248\241\243\255\63\255\255\127\0\0\0\0\3\128\1\0\0\224\255\223\207\255\49\255\255\63\229\127\101\
    \\252\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\0\0\0\160\0\252\127\95\219\127\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\0\0\0\0\0\0\72\0\0\0\0\78\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\25\0\48\0\0\0\0\0\
    \\0\16\0\0\0\0\0\0\28\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\18\0\0\
    \\0\0\255\0\0\0\0\0\0\0\0\0\0\0\0\0\24\0\176\0\0\0\0\0\0\0\0\0\0\72\0\0\0\0\78\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\25\0\48\0\0\0\0\0\0\16\0\0\0\0\0\0\28\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\129\13\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\28\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\116\0\0\0\0"#

isDecomposableOffsets1BitMap :: Ptr Word16
isDecomposableOffsets1BitMap = Ptr
    "\232\1\102\1\102\1\102\1\102\1\102\1\102\1\102\1\102\1\8\2\165\5\102\1\102\1\149\2\241\4\102\1\102\1\102\1\74\1\102\1\102\1\152\3\102\1\102\1\102\1\102\1\102\1\8\2\165\5\102\1\102\1\175\1\102\1\102\1\102\1\102\1\102\1\102\1\102\1\40\2\122\2\139\4\115\0\59\0\102\1\35\3\102\1\102\1\102\1\152\3\
    \\102\1\102\1\102\1\102\1\102\1\101\5\0\0\37\1\48\4\75\4\15\6\229\0\173\0\140\3\102\1\102\1\102\1\102\1\134\1\102\1\85\2\207\2\102\1\102\1\102\1\102\1\102\1\245\2\102\1"#

isDecomposableOffsets2BitMap :: Ptr Word8
isDecomposableOffsets2BitMap = Ptr
    "\55\63\13\0\1\1\1\1\1\1\1\1\1\1\1\5\19\41\1\1\1\1\71\1\1\1\1\1\1\31\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\35"#

