-- autogenerated from https://www.unicode.org/Public/17.0.0/ucd/DerivedCoreProperties.txt
-- |
-- Module      : Unicode.Internal.Char.DerivedCoreProperties
-- Copyright   : (c) 2020 Composewell Technologies and Contributors
-- License     : Apache-2.0
-- Maintainer  : streamly@composewell.com
-- Stability   : experimental

{-# OPTIONS_HADDOCK hide #-}
{-# OPTIONS_GHC -Wno-unrecognised-pragmas #-}
{-# HLINT ignore "Use camelCase" #-}

module Unicode.Internal.Char.DerivedCoreProperties
    ( isXID_Continue
    , isXID_Start
    , isID_Continue
    , isID_Start
    , isUppercase
    , isLowercase
    , isAlphabetic
    ) where

import Data.Bits (Bits(..))
import Data.Char (ord)
import Data.Int (Int8)
import Data.Word (Word16)
import GHC.Exts (Ptr(..))
import Unicode.Internal.Bits (lookupBit, lookupWord16AsInt)

{-# INLINE isXID_Continue #-}
isXID_Continue :: Char -> Bool
isXID_Continue c
    | c < '\x002F' = False
    | c < '\x3347A' = lookupIsXID_ContinueBitMap (ord c)
    | c < '\xE0000' = False
    | c < '\xE01F0' = lookupIsXID_ContinueBitMap (ord c - 0xACB86)
    | otherwise = False

{-# INLINE lookupIsXID_ContinueBitMap #-}
lookupIsXID_ContinueBitMap :: Int -> Bool
lookupIsXID_ContinueBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isXID_ContinueDataBitMap
    !(Ptr offsets#) = isXID_ContinueOffsetsBitMap

isXID_ContinueDataBitMap :: Ptr Int8
isXID_ContinueDataBitMap = Ptr
    "\238\159\249\255\255\253\237\243\159\57\224\176\207\255\2\0\236\199\61\214\24\199\255\195\199\61\129\0\192\255\0\0\184\255\3\255\255\255\255\255\255\255\255\255\255\255\1\255\255\255\
    \\255\255\7\255\255\255\255\255\255\255\255\63\0\0\255\255\255\15\255\7\255\255\255\254\128\255\255\255\255\255\255\255\255\255\251\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\32\224\
    \\0\0\0\254\255\62\31\254\255\255\255\255\255\255\255\255\255\127\230\254\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\195\255\3\0\31\80\0\0\255\7\255\255\255\255\255\255\255\255\255\195\255\255\255\255\255\255\255\255\255\255\255\255\239\159\255\253\255\159\224\255\255\255\255\255\254\255\255\255\
    \\255\255\255\255\255\255\255\127\0\0\255\255\255\255\0\0\0\0\0\0\255\255\255\231\255\15\255\3\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\252\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\239\111\240\239\254\255\255\63\135\0\0\0\0\255\255\255\31\255\255\255\31\0\0\0\0\255\254\255\255\127\0\0\0\48\0\0\0\0\0\128\1\0\16\0\0\0\2\128\
    \\0\0\255\31\0\0\0\0\0\0\255\31\226\255\1\0\0\3\255\3\160\194\255\254\255\255\255\31\254\255\223\255\255\254\255\255\255\31\64\0\0\0\0\0\0\0\255\255\255\31\
    \\128\0\255\255\255\255\1\0\0\0\255\255\63\0\0\0\0\0\255\255\31\0\0\0\255\255\127\0\248\224\255\253\127\95\219\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\
    \\0\0\248\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\255\255\255\255\255\63\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\3\254\255\255\135\254\255\255\7\0\0\0\0\0\4\160\4\255\255\127\255\255\255\127\255\15\255\15\192\255\255\
    \\255\255\63\31\0\255\255\255\255\255\15\255\255\255\3\255\7\0\0\0\0\255\255\255\255\255\255\255\231\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\63\
    \\36\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\
    \\0\0\128\255\252\255\255\255\255\255\255\255\255\255\255\255\255\249\255\255\255\255\255\255\255\255\255\31\0\0\254\255\255\255\255\255\255\7\255\127\255\3\0\0\0\0\214\247\255\255\
    \\175\255\255\63\95\127\255\243\0\0\0\0\255\3\254\255\255\135\254\255\255\7\224\255\255\255\255\255\255\255\255\255\255\127\252\252\252\28\0\0\0\0\255\255\255\255\255\255\0\0\
    \\255\255\63\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\31\255\1\255\99\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\255\1\0\1\0\0\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\63\255\255\255\253\255\255\247\255\255\255\247\255\255\0\0\255\255\24\0\0\224\0\0\0\0\138\170\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\
    \\255\3\0\248\15\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\
    \\255\255\255\255\255\255\1\0\0\0\0\0\0\255\255\255\255\255\255\7\0\255\255\255\255\255\255\7\0\255\255\255\255\255\63\255\255\255\255\15\0\255\255\255\31\255\255\255\255\255\
    \\255\255\255\1\128\255\3\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\0\4\0\0\0\39\0\240\0\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\255\255\127\248\255\255\255\255\255\15\255\255\255\255\255\255\255\127\255\255\
    \\255\159\255\3\255\3\128\0\255\191\255\255\255\63\255\15\0\0\255\255\255\255\255\31\255\63\255\67\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\255\255\255\127\0\0\255\255\255\255\255\255\255\3\255\239\255\255\127\255\255\183\255\63\255\63\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\127\0\255\255\255\255\255\0\255\3\255\255\255\255\63\190\255\255\63\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\255\255\255\255\255\27\3\0\252\0\0\0\0\0\0\252\255\255\255\255\255\255\255\255\255\255\255\63\240\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\251\252\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\184\192\215\255\255\251\255\255\255\255\255\255\255\255\255\191\255\223\253\255\255\253\255\243\223\61\96\55\207\
    \\255\0\0\239\223\253\255\255\253\239\243\223\61\96\112\207\255\14\0\255\255\255\255\255\63\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\224\227\7\248\231\15\0\0\0\60\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\63\255\1\0\0\63\0\0\0\0\132\252\47\63\80\253\255\
    \\243\224\67\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\28\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\224\
    \\227\7\248\231\15\0\0\0\60\0\0\0\0\0\0\0\0\0\0\0\0\255\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\1\0\255\3\191\231\223\223\255\255\255\123\95\
    \\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\255\255\255\255\255\255\255\255\223\100\222\255\235\239\255\255\255\255\255\255\255\255\255\255\255\255\
    \\207\255\254\255\239\159\249\255\255\253\197\243\159\121\128\176\207\255\3\80\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\1\0\255\255\255\255\255\255\255\255\255\255\255\255\255\159\255\255\254\255\255\7\255\255\255\255\255\255\255\255\
    \\255\199\255\1\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\3\255\255\255\255\255\255\127\0\15\0\255\3\248\255\255\224\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\255\255\255\255\255\31\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\7\255\255\255\255\255\255\127\0\255\
    \\255\63\0\255\0\0\0\191\255\255\255\255\255\253\7\0\0\0\0\0\0\0\0\255\255\255\255\255\31\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\
    \\255\255\255\255\255\0\0\0\0\255\255\255\249\255\255\15\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\252\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\254\255\255\255\127\2\255\255\255\255\255\1\254\255\255\255\255\191\182\0\255\255\255\135\7\0\255\255\223\255\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\255\
    \\253\255\255\247\207\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\253\255\255\247\255\255\255\247\255\255\223\255\255\255\223\255\255\127\255\255\255\
    \\127\255\255\255\253\255\255\255\253\255\255\247\207\255\255\255\255\255\255\127\248\255\255\255\255\255\31\32\0\16\0\0\248\254\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\255\255\255\127\255\255\63\192\255\255\255\255\255\255\255\255\255\61\127\61\255\255\255\255\255\61\255\255\255\255\61\127\61\255\127\255\255\255\255\255\255\
    \\255\255\255\3\255\255\255\255\255\255\255\255\255\63\255\255\255\255\191\32\255\255\255\255\255\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\31\0\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\111\255\127\242\111\255\255\255\191\249\15\0\255\3\0\0\0\0\
    \\0\0\0\0\255\252\255\255\255\255\255\252\27\0\0\0\255\255\255\255\191\32\255\255\255\255\255\255\255\128\0\128\255\255\127\0\127\127\127\127\127\127\127\127\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\248\15\0\255\255\255\255\255\255\255\255\255\61\127\61\255\255\255\255\255\61\255\255\255\255\61\127\
    \\61\255\127\255\255\255\255\255\61\255\255\255\255\255\255\255\255\231\0\254\3\0\255\255\0\0\255\255\255\255\255\255\255\255\255\255\63\63\255\255\255\255\63\63\255\170\255\255\255\63\
    \\255\255\255\255\255\255\223\95\220\31\207\15\255\31\220\31\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\1\0\255\255\255\255\
    \\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\184\192\215\255\255\251\255\
    \\255\255\255\255\255\255\255\255\191\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\80\0\0\255\255\255\255\255\255\255\255\255\
    \\135\255\255\255\255\255\255\255\128\255\255\0\0\0\0\0\0\0\0\27\0\127\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\255\255\255\249\255\255\15\0\
    \\0\0\0\0\238\135\249\255\255\253\109\211\135\57\2\94\192\255\63\0\238\191\251\255\255\253\237\243\191\59\1\0\207\255\0\254\255\223\253\255\255\255\255\255\223\125\240\128\207\255\
    \\0\252\238\255\127\252\255\255\251\47\127\132\95\255\192\255\12\0\255\255\63\128\255\255\31\0\255\255\15\0\255\223\13\0\255\255\255\255\255\255\255\255\255\255\143\48\255\3\0\0\
    \\255\255\255\255\255\255\255\0\255\227\255\255\255\255\255\63\255\7\255\255\255\255\255\231\0\0\247\255\255\255\255\7\255\31\255\255\255\15\0\0\255\255\255\255\255\255\240\191\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\16\0\0\255\255\255\255\255\255\15\0\255\255\255\255\255\255\255\255\63\0\255\3\255\255\255\232\255\255\255\255\
    \\255\255\127\0\255\63\255\3\255\255\127\252\255\255\255\255\255\255\255\255\7\0\0\56\255\255\124\0\126\126\126\0\127\127\255\255\255\255\255\247\255\3\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\55\255\3\255\255\255\255\255\255\255\63\0\0\255\255\255\255\255\255\255\255\252\255\255\255\255\255\255\0\0\0\0\0\255\3\255\255\255\255\0\224\255\255\
    \\255\7\255\255\255\255\255\7\255\255\255\63\255\255\255\255\15\255\62\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\3\255\255\255\255\
    \\15\255\255\255\255\15\255\255\255\255\255\0\255\255\255\255\255\255\15\0\255\247\255\247\183\255\251\255\251\27\255\255\255\255\255\255\15\0\63\253\255\255\255\255\191\145\255\255\63\0\
    \\255\255\127\0\255\255\255\127\0\0\0\0\0\0\0\0\255\255\55\0\255\255\63\0\255\255\255\3\255\255\255\3\0\0\0\0\255\255\255\255\255\255\255\192\0\0\0\0\0\0\
    \\0\0\255\255\255\255\255\255\63\0\255\255\63\0\255\255\7\0\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\127\0\0\0\192\255\63\128\
    \\255\255\255\255\255\255\255\7\4\0\255\255\255\1\255\3\255\255\255\255\255\255\223\255\240\0\255\255\255\255\79\0\255\255\255\255\255\255\255\255\31\222\255\23\0\0\0\0\255\255\
    \\251\255\255\255\255\192\3\0\0\0\0\0\0\0\127\189\255\191\255\1\255\255\255\255\255\255\255\7\255\3\239\159\249\255\255\253\237\251\159\57\129\224\207\31\31\0\255\75\255\255\
    \\255\255\191\255\165\247\15\0\6\0\0\0\255\255\255\255\255\255\255\255\255\7\255\195\3\0\0\0\255\255\255\255\255\255\255\255\191\0\255\3\0\0\0\0\255\255\255\255\255\255\
    \\255\255\17\0\255\3\0\0\0\0\255\255\255\255\255\255\255\1\255\3\255\255\15\0\0\0\255\255\255\255\255\255\255\7\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\
    \\255\255\255\255\255\3\0\128\255\255\255\255\255\255\255\127\128\0\255\255\255\255\255\255\255\255\255\35\0\0\255\255\255\255\255\255\255\255\255\1\255\253\255\255\255\255\127\255\1\0\
    \\255\3\0\0\252\255\255\255\252\255\255\254\127\0\0\0\0\0\0\0\0\0\127\251\255\255\255\255\127\180\255\0\255\3\191\253\255\255\255\127\251\1\255\3\255\255\255\255\255\15\
    \\255\3\0\0\255\255\253\255\255\255\255\199\7\0\255\7\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\127\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\1\255\255\255\127\255\3\255\255\255\255\255\255\255\255\255\127\255\3\255\255\255\63\31\0\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\128\255\255\255\127\224\7\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\255\255\249\219\7\255\255\255\255\255\255\255\63\0\0\0\128\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\
    \\255\255\255\255\255\15\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\255\255\255\150\254\247\10\132\234\150\170\150\247\247\94\255\251\255\15\238\251\
    \\255\15\0\0\0\0\0\0\0\0"#

isXID_ContinueOffsetsBitMap :: Ptr Word16
isXID_ContinueOffsetsBitMap = Ptr
    "\50\2\170\0\178\0\126\5\108\5\255\7\208\0\107\2\56\0\152\6\144\10\0\0\157\5\176\10\218\2\158\1\196\8\170\0\169\8\152\9\169\0\170\0\236\6\208\10\31\0\77\2\112\4\172\3\240\10\170\0\170\0\180\9\128\1\7\6\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\90\9\62\9\64\1\64\1\149\0\240\0\
    \\64\1\64\1\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\93\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\
    \\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\
    \\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\247\1\170\0\16\11\188\2\48\11\5\4\80\11\112\11\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\
    \\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\84\4\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\170\0\
    \\158\2\220\1\92\5\144\11\150\3\248\2\190\4\117\0\74\3\176\11\208\11\240\11\170\0\149\7\16\12\48\12\97\1\80\12\229\3\43\5\60\5\190\1\112\12\144\12\176\12\208\12\240\12\231\5\16\13\14\1\48\13\30\9\80\13\73\6\112\13\144\13\11\5\176\13\170\0\170\0\170\0\247\4\231\4\194\3\64\1\64\1\64\1\64\1\64\1\64\1\
    \\64\1\64\1\64\1\208\3\170\0\170\0\170\0\170\0\24\3\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\36\3\170\0\170\0\208\13\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\
    \\64\1\64\1\64\1\3\5\64\1\64\1\64\1\64\1\64\1\64\1\170\0\170\0\240\13\77\7\64\1\101\7\197\7\81\10\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\16\14\33\4\64\1\64\1\
    \\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\66\1\170\0\59\4\73\4\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\54\3\64\1\64\1\64\1\64\1\64\1\
    \\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\26\2\64\1\64\1\17\2\64\1\209\5\31\6\64\1\127\6\106\3\118\3\31\8\64\1\64\1\115\8\64\1\64\1\64\1\64\1\48\14\80\14\144\4\158\4\64\1\45\7\117\7\137\8\255\8\228\8\112\14\64\1\64\1\64\1\64\1\144\14\64\1\64\1\64\1\64\1\64\1\
    \\64\1\64\1\64\1\64\1\64\1\64\1\64\1\26\2\64\1\64\1\64\1\64\1\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\
    \\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\
    \\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\
    \\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\89\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\85\0\170\0\170\0\170\0\
    \\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\150\2\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\206\6\170\0\170\0\
    \\52\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\64\1\170\0\170\0\60\1\64\1\64\1\64\1\64\1\64\1\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\212\4\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\
    \\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\251\4\31\1\172\2"#

{-# INLINE isXID_Start #-}
isXID_Start :: Char -> Bool
isXID_Start c = c >= '\x0041' && c <= '\x33479' && lookupIsXID_StartBitMap (ord c)

{-# INLINE lookupIsXID_StartBitMap #-}
lookupIsXID_StartBitMap :: Int -> Bool
lookupIsXID_StartBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isXID_StartDataBitMap
    !(Ptr offsets#) = isXID_StartOffsetsBitMap

isXID_StartDataBitMap :: Ptr Int8
isXID_StartDataBitMap = Ptr
    "\224\255\255\255\255\255\254\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\0\
    \\0\0\0\0\0\0\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\254\255\
    \\255\7\254\255\255\7\0\0\0\0\0\4\32\4\255\255\127\255\255\255\127\255\255\255\255\255\255\255\255\255\255\255\255\255\159\255\255\254\255\255\7\255\255\255\255\255\255\255\255\255\
    \\199\255\1\254\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\80\0\0\255\255\255\63\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\255\255\255\255\255\
    \\7\0\0\0\192\254\255\255\255\255\255\255\255\255\255\255\255\47\0\96\192\0\156\255\31\255\255\0\12\0\0\255\255\255\255\255\127\0\128\255\255\255\63\255\255\255\255\255\255\255\
    \\255\255\255\0\0\126\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\31\255\1\255\3\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\223\184\64\215\255\255\251\255\255\255\255\255\255\255\255\255\191\255\255\255\255\191\32\255\255\255\255\255\255\255\128\0\0\255\255\127\0\127\127\
    \\127\127\127\127\127\127\0\0\0\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\253\255\255\247\
    \\255\255\255\247\127\0\248\160\255\253\127\95\219\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\248\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\0\0\0\0\255\255\255\255\255\255\7\0\255\255\255\255\255\255\7\0\128\0\
    \\0\63\60\98\192\225\255\3\64\0\0\255\255\255\255\191\32\255\255\255\255\255\247\255\255\251\255\255\15\0\128\1\0\0\0\0\0\0\0\127\189\255\191\255\1\255\255\255\255\255\
    \\127\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\0\4\0\0\0\39\0\240\0\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\255\255\127\248\255\255\255\255\255\15\0\0\0\0\224\0\252\255\255\255\63\255\7\255\255\255\255\255\231\0\
    \\0\0\0\0\222\111\4\255\255\255\255\255\31\128\63\0\64\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\63\0\0\255\255\255\255\255\
    \\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\128\255\252\255\255\255\255\255\255\255\255\255\255\255\255\249\255\255\255\255\255\255\255\255\
    \\255\31\0\0\254\255\255\255\255\255\5\0\127\0\0\0\0\0\0\0\214\247\255\255\175\255\5\32\95\0\0\240\0\0\0\0\224\159\249\255\255\253\237\35\0\0\0\176\3\0\
    \\2\0\232\199\61\214\24\199\255\3\0\0\1\0\0\0\0\0\0\0\255\254\255\255\255\31\0\0\0\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\
    \\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\255\1\0\0\0\0\0\254\255\255\7\254\255\255\7\192\255\255\255\255\255\255\63\
    \\255\255\255\127\252\252\252\28\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\63\240\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\252\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\138\170\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\128\7\0\128\3\0\0\0\255\255\255\255\255\255\0\0\176\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\255\255\255\127\183\63\31\192\127\251\255\255\255\255\1\0\64\0\0\0\191\253\255\255\255\3\0\1\0\0\255\255\255\255\255\15\0\0\0\0\252\255\255\
    \\63\128\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\3\3\0\252\0\0\0\0\0\0\0\132\252\47\63\80\253\255\243\224\67\0\0\255\
    \\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\128\0\0\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\127\0\0\0\
    \\0\0\15\0\0\0\0\132\252\47\63\80\253\255\243\224\67\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\239\111\255\253\255\255\255\127\0\0\1\0\0\0\0\0\252\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\255\255\255\255\1\0\0\0\255\239\255\255\127\255\255\183\255\63\255\63\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\7\0\191\231\223\223\
    \\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\255\255\255\255\255\255\255\255\223\100\222\255\235\239\255\255\255\255\255\255\255\
    \\255\255\61\127\61\255\255\255\255\255\61\255\255\255\255\61\127\61\255\127\255\255\255\255\255\255\254\255\255\255\127\2\255\255\255\255\255\1\0\0\0\0\0\0\0\0\255\255\255\135\
    \\7\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\1\0\255\255\61\255\255\255\255\255\255\255\255\7\0\0\0\0\255\255\0\0\255\255\255\255\255\255\255\255\255\255\63\63\255\255\255\255\63\63\255\170\255\255\255\63\255\255\
    \\255\255\255\255\223\95\220\31\207\15\255\31\220\31\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\15\0\0\255\255\255\255\255\255\0\0\15\0\0\0\248\255\255\224\255\255\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\63\1\0\239\
    \\254\255\255\63\0\0\0\0\0\255\255\255\31\255\255\255\31\0\0\0\0\255\254\255\255\31\0\0\0\255\255\255\31\128\0\255\255\63\0\0\0\0\0\255\255\3\0\0\0\0\
    \\0\255\255\31\0\0\0\255\255\127\0\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\128\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\31\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\255\255\255\249\255\255\15\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\111\255\127\242\111\255\255\255\0\
    \\128\2\0\0\0\0\0\0\0\0\0\0\0\255\252\255\255\255\255\1\0\10\0\0\0\255\255\255\127\224\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\31\128\63\0\64\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\0\224\255\255\255\
    \\7\255\255\255\255\63\0\255\255\255\63\255\255\255\255\15\255\62\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\255\1\0\0\0\0\0\
    \\255\255\3\128\255\255\3\0\255\255\3\0\255\223\1\0\255\255\255\255\255\255\15\0\0\0\128\16\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\1\255\255\255\255\255\5\
    \\255\255\255\255\255\255\255\255\63\0\0\255\255\255\255\255\255\255\255\252\255\255\255\255\255\255\0\0\0\0\0\255\3\255\255\255\127\0\0\0\0\0\0\255\255\255\63\31\0\255\
    \\255\255\255\255\15\255\255\255\3\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\1\255\255\255\255\255\5\255\255\255\255\255\255\255\255\63\0\255\255\63\0\255\255\7\
    \\0\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\63\4\16\1\0\0\255\255\255\1\255\7\255\255\255\254\0\0\255\255\255\255\255\3\0\0\0\0\0\0\253\
    \\255\255\255\0\0\0\224\255\255\255\255\255\255\255\255\255\255\63\0\2\0\0\252\255\255\255\7\48\4\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\1\0\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\120\12\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\1\248\255\255\255\255\7\4\0\0\1\240\255\255\255\255\255\3\0\32\0\0\255\255\255\255\255\255\255\255\255\1\0\0\247\15\0\0\255\255\127\196\255\255\255\255\
    \\255\255\98\62\5\0\0\56\255\7\28\0\252\255\255\63\0\255\255\127\0\0\0\255\255\255\31\240\255\255\255\255\255\7\0\0\128\0\0\223\255\0\124\255\255\255\255\255\255\255\
    \\255\255\7\1\0\0\0\0\0\0\0\248\255\0\0\0\0\0\0\0\0\11\0\124\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\255\255\255\249\255\255\
    \\15\0\0\0\0\0\240\255\255\255\255\255\255\35\0\0\1\255\3\0\254\255\225\159\249\255\255\253\197\35\0\64\0\176\3\0\3\16\224\135\249\255\255\253\109\3\0\0\0\94\
    \\0\0\28\0\224\191\251\255\255\253\237\35\0\0\1\0\3\0\0\2\224\223\253\255\255\253\255\35\0\0\0\55\3\0\0\0\225\223\253\255\255\253\239\35\0\0\0\112\3\0\
    \\6\0\240\223\253\255\255\255\255\39\0\64\112\128\3\0\0\252\224\255\127\252\255\255\251\47\127\0\0\0\0\0\0\0\224\255\255\255\255\255\15\0\224\31\0\0\0\0\0\0\
    \\248\255\255\255\1\192\0\252\255\255\255\255\63\0\0\0\224\0\0\0\254\3\62\31\254\255\255\255\255\255\255\255\255\255\127\224\254\255\255\255\255\255\255\255\255\255\255\247\187\247\
    \\255\255\7\0\0\0\255\255\255\255\255\255\15\0\252\255\255\255\255\255\15\0\0\0\0\0\0\0\252\104\126\126\126\0\127\127\255\255\255\255\255\247\255\3\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\7\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\255\255\255\255\15\255\255\255\255\15\255\255\255\255\255\0\
    \\255\255\255\255\255\255\15\0\255\247\255\247\183\255\251\255\251\27\255\255\255\255\255\255\15\0\255\255\255\255\255\255\127\0\255\255\63\0\255\0\0\0\191\255\255\255\255\255\253\7\
    \\0\0\0\0\0\0\0\0\63\253\255\255\255\255\191\145\255\255\63\0\255\255\127\0\255\255\255\127\0\0\0\0\0\0\0\0\255\255\55\0\255\255\63\0\255\255\255\3\255\255\
    \\255\3\0\0\0\0\255\255\255\255\255\255\255\192\0\0\0\0\0\0\0\0\248\255\255\255\255\255\255\0\0\0\0\0\0\0\38\0\248\255\255\255\255\255\0\0\0\0\255\255\
    \\255\1\0\0\248\255\255\255\127\0\0\0\144\0\255\255\255\255\71\0\248\255\255\255\255\255\7\0\30\0\0\20\0\0\0\0\224\159\249\255\255\253\237\35\0\0\1\224\3\0\
    \\0\0\255\75\255\255\255\255\191\0\0\0\10\0\0\0\0\0\255\255\255\255\255\255\0\0\16\0\0\0\0\0\0\0\255\255\255\255\255\7\0\1\0\0\0\0\0\0\0\0\
    \\255\255\255\7\0\0\0\0\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\244\255\253\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\1\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\
    \\255\255\255\1\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\63\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\63\0\0\0\0\128\255\255\223\255\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\255\253\255\255\247\15\0\0\0\0\0\0\255\255\255\255\255\255\255\255\
    \\15\8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\255\255\255\150\254\247\10\132\234\150\170\150\247\247\94\255\251\255\15\238\251\255\15\0\0\
    \\0\0\0\0\0\0"#

isXID_StartOffsetsBitMap :: Ptr Word16
isXID_StartOffsetsBitMap = Ptr
    "\90\0\154\0\162\0\91\1\210\3\240\5\241\0\93\9\63\9\146\10\178\10\68\3\210\10\242\10\36\3\94\3\29\2\154\0\213\5\68\6\153\0\154\0\121\0\152\8\180\8\235\8\65\7\18\11\163\2\66\0\154\0\96\6\181\4\163\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\187\9\122\1\251\4\251\4\50\11\0\0\
    \\251\4\251\4\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\66\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\
    \\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\
    \\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\30\0\154\0\17\1\6\3\82\11\51\10\20\10\114\11\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\
    \\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\136\2\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\154\0\
    \\213\0\198\1\194\3\203\8\9\4\162\3\79\5\118\3\134\3\93\8\146\11\178\11\154\0\210\11\242\11\18\12\5\7\31\9\4\2\114\4\131\4\37\7\50\12\82\12\61\2\114\12\34\4\201\4\146\12\178\12\233\2\201\7\250\9\47\5\29\5\91\4\134\5\210\12\154\0\154\0\154\0\245\3\229\3\225\1\251\4\251\4\251\4\251\4\251\4\251\4\
    \\251\4\251\4\251\4\239\1\154\0\154\0\154\0\154\0\41\1\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\53\1\154\0\154\0\242\12\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\
    \\251\4\251\4\251\4\130\5\251\4\251\4\251\4\251\4\251\4\251\4\154\0\154\0\18\13\193\6\251\4\217\6\113\7\83\10\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\50\13\85\2\251\4\251\4\
    \\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\253\4\154\0\111\2\125\2\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\71\1\251\4\251\4\251\4\251\4\251\4\
    \\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\188\5\154\1\166\1\82\13\251\4\251\4\251\4\251\4\251\4\251\4\251\4\233\7\3\8\195\2\209\2\251\4\161\6\231\6\59\4\170\7\145\7\114\13\251\4\251\4\251\4\251\4\146\13\251\4\251\4\251\4\251\4\251\4\
    \\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\
    \\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\
    \\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\
    \\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\62\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\58\0\154\0\154\0\154\0\
    \\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\205\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\38\6\154\0\154\0\
    \\122\5\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\251\4\154\0\154\0\130\5\251\4\251\4\251\4\251\4\251\4\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\101\5\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\
    \\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\249\3"#

{-# INLINE isID_Continue #-}
isID_Continue :: Char -> Bool
isID_Continue c
    | c < '\x002F' = False
    | c < '\x3347A' = lookupIsID_ContinueBitMap (ord c)
    | c < '\xE0000' = False
    | c < '\xE01F0' = lookupIsID_ContinueBitMap (ord c - 0xACB86)
    | otherwise = False

{-# INLINE lookupIsID_ContinueBitMap #-}
lookupIsID_ContinueBitMap :: Int -> Bool
lookupIsID_ContinueBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isID_ContinueDataBitMap
    !(Ptr offsets#) = isID_ContinueOffsetsBitMap

isID_ContinueDataBitMap :: Ptr Int8
isID_ContinueDataBitMap = Ptr
    "\238\159\249\255\255\253\237\243\159\57\224\176\207\255\2\0\236\199\61\214\24\199\255\195\199\61\129\0\192\255\0\0\184\255\3\255\255\255\255\255\255\255\255\255\255\255\1\255\255\255\
    \\255\255\7\255\255\255\255\255\255\255\255\63\0\0\255\255\255\15\255\7\255\255\255\254\128\255\255\255\255\255\255\255\255\255\251\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\32\224\
    \\0\0\0\254\255\62\31\254\255\255\255\255\255\255\255\255\255\127\254\254\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\195\255\3\0\31\80\0\0\255\7\255\255\255\255\255\255\255\255\255\195\255\255\255\255\255\255\255\255\255\255\255\255\239\159\255\253\255\159\224\255\255\255\255\255\254\255\255\255\
    \\255\255\255\255\255\255\255\127\0\0\255\255\255\255\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\111\240\239\254\255\255\63\135\0\0\0\0\255\255\255\31\255\255\255\31\0\0\0\0\255\254\255\255\127\0\0\0\48\0\0\
    \\0\0\0\128\1\0\16\0\0\0\2\128\0\0\255\31\0\0\0\0\0\0\255\31\226\255\1\0\0\3\255\3\160\194\255\254\255\255\255\31\254\255\223\255\255\254\255\255\255\31\
    \\64\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\255\255\255\255\255\63\255\255\127\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\3\254\255\255\135\254\255\255\7\0\0\0\0\0\4\160\4\255\255\127\255\255\255\127\255\15\
    \\255\15\192\255\255\255\255\63\31\0\255\255\255\255\255\15\255\255\255\3\255\7\0\0\0\0\255\255\255\255\255\255\255\231\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\
    \\255\255\255\255\63\36\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\3\0\0\0\0\128\255\252\255\255\255\255\255\255\255\255\255\255\255\255\249\255\255\255\255\255\255\255\255\255\31\0\0\254\255\255\255\255\255\255\7\255\127\255\3\0\0\0\
    \\0\214\247\255\255\175\255\255\63\95\127\255\243\0\0\0\0\255\3\254\255\255\135\254\255\255\7\224\255\255\255\255\255\255\255\255\255\255\127\252\252\252\28\0\0\0\0\255\255\255\
    \\255\255\255\0\0\255\255\63\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\31\255\1\255\99\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\255\1\0\1\0\0\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\253\255\255\247\255\255\255\247\255\255\0\0\255\255\24\0\0\224\0\0\0\0\223\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\31\255\3\0\248\15\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\
    \\255\255\255\255\255\255\255\255\255\255\255\1\0\0\0\0\0\0\255\255\255\255\255\255\7\0\255\255\255\255\255\255\7\0\255\255\255\255\255\63\255\255\255\255\15\0\255\255\255\31\
    \\255\255\255\255\255\255\255\255\1\128\255\3\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\0\4\0\0\0\39\0\
    \\240\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\255\255\127\248\255\255\255\255\255\15\255\255\255\255\255\
    \\255\255\127\255\255\255\159\255\3\255\3\128\0\255\191\255\255\255\63\255\15\0\0\255\255\255\255\255\31\255\63\255\67\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\255\255\255\127\0\0\255\255\255\255\255\255\255\3\255\255\255\231\255\15\255\3\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\252\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\127\0\255\255\255\255\255\0\255\3\255\255\255\255\63\190\255\255\63\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\255\255\255\255\255\27\3\0\252\0\0\0\0\0\0\252\255\239\255\255\127\255\255\183\255\63\255\63\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\7\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\252\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\188\192\215\255\255\251\255\
    \\255\255\255\255\255\255\255\255\191\255\223\253\255\255\253\255\243\223\61\96\55\207\255\0\0\239\223\253\255\255\253\239\243\223\61\96\112\207\255\14\0\255\255\255\255\255\63\255\255\127\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\224\227\7\248\231\15\0\0\0\60\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\
    \\255\255\255\255\255\63\255\1\0\0\63\0\0\0\0\132\252\47\63\80\253\255\243\224\67\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\28\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\224\227\7\248\231\15\0\0\0\60\0\0\0\0\0\0\0\0\0\0\0\0\255\0\0\0\0\0\0\
    \\0\0\0\0\0\255\255\255\255\1\0\255\3\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\255\255\255\255\
    \\255\255\255\255\223\100\222\255\235\239\255\255\255\255\255\255\255\255\255\255\255\255\207\255\254\255\239\159\249\255\255\253\197\243\159\121\128\176\207\255\3\80\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\1\0\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\159\255\255\254\255\255\7\255\255\255\255\255\255\255\255\255\199\255\1\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\3\255\255\255\255\255\255\127\0\15\
    \\0\255\3\248\255\255\224\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\31\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\255\255\255\255\255\7\255\255\255\255\255\255\127\0\255\255\63\0\255\0\0\0\191\255\255\255\255\255\253\7\0\0\0\0\0\0\0\0\255\255\255\255\255\
    \\31\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\255\255\255\249\255\255\15\0\0\0\0\0\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\251\252\255\255\255\255\255\255\255\255\255\255\255\255\255\255\254\255\255\255\127\2\255\255\255\255\255\1\254\255\255\255\255\191\182\0\255\255\255\135\7\
    \\0\255\255\223\255\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\255\253\255\255\247\207\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\
    \\255\253\255\255\247\255\255\255\247\255\255\223\255\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\255\253\255\255\247\207\255\255\255\255\255\255\127\248\255\255\255\255\255\31\32\
    \\0\16\0\0\248\254\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\127\255\255\63\192\255\255\255\255\255\255\255\255\255\61\127\
    \\61\255\255\255\255\255\61\255\255\255\255\61\127\61\255\127\255\255\255\255\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\63\255\255\255\255\191\32\255\255\255\255\255\247\255\255\
    \\255\31\128\0\255\255\255\255\1\0\0\0\255\255\63\0\0\0\0\0\255\255\31\0\0\0\255\255\127\0\248\224\255\253\127\95\219\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\3\0\0\0\248\255\255\255\255\255\255\255\63\0\0\255\255\255\255\255\255\255\255\252\255\255\255\255\255\255\0\0\0\0\0\255\15\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\31\0\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\111\255\127\242\111\255\255\
    \\255\191\249\15\0\255\3\0\0\0\0\0\0\0\0\255\252\255\255\255\255\255\252\27\0\0\0\255\255\255\255\191\32\255\255\255\255\255\255\255\128\0\128\255\255\127\0\127\127\127\
    \\127\127\127\127\127\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\248\15\0\255\255\255\255\255\255\255\255\255\61\127\61\255\
    \\255\255\255\255\61\255\255\255\255\61\127\61\255\127\255\255\255\255\255\61\255\255\255\255\255\255\255\255\231\0\254\3\0\255\255\0\0\255\255\255\255\255\255\255\255\255\255\63\63\255\
    \\255\255\255\63\63\255\170\255\255\255\63\255\255\255\255\255\255\223\95\220\31\207\15\255\31\220\31\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\1\0\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\223\188\192\215\255\255\251\255\255\255\255\255\255\255\255\255\191\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\80\
    \\0\0\255\255\255\255\255\255\255\255\255\135\255\255\255\255\255\255\255\128\255\255\0\0\0\0\0\0\0\0\27\0\127\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\
    \\0\0\0\255\255\255\249\255\255\15\0\0\0\0\0\238\135\249\255\255\253\109\211\135\57\2\94\192\255\63\0\238\191\251\255\255\253\237\243\191\59\1\0\207\255\0\254\255\223\253\
    \\255\255\255\255\255\223\125\240\128\207\255\0\252\238\255\127\252\255\255\251\47\127\132\95\255\192\255\12\0\255\255\63\128\255\255\31\0\255\255\15\0\255\223\13\0\255\255\255\255\255\
    \\255\255\255\255\255\143\48\255\3\0\0\255\255\255\255\255\255\255\0\255\227\255\255\255\255\255\63\255\7\255\255\255\255\255\231\0\0\247\255\255\255\255\7\255\31\255\255\255\15\0\
    \\0\255\255\255\255\255\255\240\191\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\16\0\0\255\255\255\255\255\255\15\0\255\255\255\255\255\255\255\255\63\
    \\0\255\3\255\255\255\232\255\255\255\255\255\255\127\0\255\63\255\3\255\255\127\252\255\255\255\255\255\255\255\255\7\0\0\56\255\255\124\0\126\126\126\0\127\127\255\255\255\255\255\
    \\247\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\55\255\3\255\255\255\255\0\224\255\255\255\7\255\255\255\255\255\7\255\255\255\63\255\255\255\255\15\255\62\0\0\
    \\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\3\255\255\255\255\15\255\255\255\255\15\255\255\255\255\255\0\255\255\255\255\255\255\15\0\255\
    \\247\255\247\183\255\251\255\251\27\255\255\255\255\255\255\15\0\63\253\255\255\255\255\191\145\255\255\63\0\255\255\127\0\255\255\255\127\0\0\0\0\0\0\0\0\255\255\55\0\255\
    \\255\63\0\255\255\255\3\255\255\255\3\0\0\0\0\255\255\255\255\255\255\255\192\0\0\0\0\0\0\0\0\255\255\255\255\255\255\63\0\255\255\63\0\255\255\7\0\255\255\3\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\127\0\0\0\192\255\63\128\255\255\255\255\255\255\255\7\4\0\255\255\255\1\255\3\255\255\255\255\255\
    \\255\223\255\240\0\255\255\255\255\79\0\255\255\255\255\255\255\255\255\31\222\255\23\0\0\0\0\255\255\251\255\255\255\255\192\3\0\0\0\0\0\0\0\127\189\255\191\255\1\255\
    \\255\255\255\255\255\255\7\255\3\239\159\249\255\255\253\237\251\159\57\129\224\207\31\31\0\255\75\255\255\255\255\191\255\165\247\15\0\6\0\0\0\255\255\255\255\255\255\255\255\255\
    \\7\255\195\3\0\0\0\255\255\255\255\255\255\255\255\191\0\255\3\0\0\0\0\255\255\255\255\255\255\255\255\17\0\255\3\0\0\0\0\255\255\255\255\255\255\255\1\255\3\255\
    \\255\15\0\0\0\255\255\255\255\255\255\255\7\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\3\0\128\255\255\255\255\255\255\255\127\128\0\255\255\255\
    \\255\255\255\255\255\255\35\0\0\255\255\255\255\255\255\255\255\255\1\255\253\255\255\255\255\127\255\1\0\255\3\0\0\252\255\255\255\252\255\255\254\127\0\0\0\0\0\0\0\0\
    \\0\127\251\255\255\255\255\127\180\255\0\255\3\191\253\255\255\255\127\251\1\255\3\255\255\255\255\255\15\255\3\0\0\255\255\253\255\255\255\255\199\7\0\255\7\0\0\0\0\0\
    \\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\
    \\255\255\255\255\1\255\255\255\127\255\3\255\255\255\255\255\255\255\255\255\127\255\3\255\255\255\63\31\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\63\0\0\0\0\128\255\255\255\127\224\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\255\255\249\219\7\255\
    \\255\255\255\255\255\255\63\0\0\0\128\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\15\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\239\255\255\255\150\254\247\10\132\234\150\170\150\247\247\94\255\251\255\15\238\251\255\15\0\0\0\0\0\0\0\0"#

isID_ContinueOffsetsBitMap :: Ptr Word16
isID_ContinueOffsetsBitMap = Ptr
    "\211\1\170\0\178\0\48\5\30\5\177\7\208\0\12\2\56\0\74\6\155\10\0\0\79\5\187\10\123\2\120\1\118\8\170\0\91\8\163\9\169\0\170\0\158\6\219\10\31\0\238\1\17\4\77\3\251\10\170\0\170\0\191\9\90\1\185\5\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\101\9\73\9\26\1\26\1\149\0\240\0\
    \\26\1\26\1\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\93\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\
    \\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\
    \\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\152\1\170\0\27\11\93\2\59\11\166\3\91\11\123\11\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\
    \\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\245\3\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\170\0\
    \\63\2\180\8\170\0\207\8\55\3\153\2\248\4\117\0\235\2\155\11\187\11\219\11\170\0\71\7\251\11\27\12\59\1\59\12\134\3\199\4\216\4\150\8\91\12\123\12\155\12\187\12\219\12\153\5\251\12\95\4\27\13\41\9\59\13\251\5\91\13\123\13\167\4\155\13\170\0\170\0\170\0\147\4\131\4\99\3\26\1\26\1\26\1\26\1\26\1\26\1\
    \\26\1\26\1\26\1\113\3\170\0\170\0\170\0\170\0\185\2\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\197\2\170\0\170\0\187\13\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\
    \\26\1\26\1\26\1\159\4\26\1\26\1\26\1\26\1\26\1\26\1\170\0\170\0\219\13\255\6\26\1\23\7\119\7\92\10\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\251\13\194\3\26\1\26\1\
    \\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\28\1\170\0\220\3\234\3\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\215\2\26\1\26\1\26\1\26\1\26\1\
    \\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\187\1\26\1\26\1\178\1\26\1\131\5\209\5\26\1\49\6\11\3\23\3\209\7\26\1\26\1\37\8\26\1\26\1\26\1\26\1\27\14\59\14\49\4\63\4\26\1\223\6\39\7\59\8\10\9\239\8\91\14\26\1\26\1\26\1\26\1\123\14\26\1\26\1\26\1\26\1\26\1\
    \\26\1\26\1\26\1\26\1\26\1\26\1\26\1\187\1\26\1\26\1\26\1\26\1\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\
    \\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\
    \\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\
    \\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\89\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\85\0\170\0\170\0\170\0\
    \\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\55\2\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\128\6\170\0\170\0\
    \\14\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\26\1\170\0\170\0\22\1\26\1\26\1\26\1\26\1\26\1\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\14\5\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\
    \\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\151\4\112\4\77\2"#

{-# INLINE isID_Start #-}
isID_Start :: Char -> Bool
isID_Start c = c >= '\x0041' && c <= '\x33479' && lookupIsID_StartBitMap (ord c)

{-# INLINE lookupIsID_StartBitMap #-}
lookupIsID_StartBitMap :: Int -> Bool
lookupIsID_StartBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isID_StartDataBitMap
    !(Ptr offsets#) = isID_StartOffsetsBitMap

isID_StartDataBitMap :: Ptr Int8
isID_StartDataBitMap = Ptr
    "\224\255\255\255\255\255\254\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\0\
    \\0\0\0\0\0\0\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\254\255\
    \\255\7\254\255\255\7\0\0\0\0\0\4\32\4\255\255\127\255\255\255\127\255\255\255\255\255\255\255\255\255\255\255\255\255\159\255\255\254\255\255\7\255\255\255\255\255\255\255\255\255\
    \\199\255\1\254\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\80\0\0\255\255\255\63\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\255\255\255\255\255\
    \\7\0\0\0\192\254\255\255\255\255\255\255\255\255\255\255\255\47\0\96\192\0\156\255\31\255\255\0\12\0\0\255\255\255\255\255\127\0\128\255\255\255\63\255\255\255\255\255\255\255\
    \\255\255\255\0\0\126\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\31\255\1\255\3\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\223\188\64\215\255\255\251\255\255\255\255\255\255\255\255\255\191\255\255\255\255\191\32\255\255\255\255\255\255\255\128\0\0\255\255\127\0\127\127\
    \\127\127\127\127\127\127\0\0\0\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\253\255\255\247\
    \\255\255\255\247\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\0\
    \\0\0\0\0\0\255\255\255\255\255\255\7\0\255\255\255\255\255\255\7\0\128\0\0\63\60\98\192\225\255\3\64\0\0\255\255\255\255\191\32\255\255\255\255\255\247\255\255\251\255\
    \\255\15\0\128\1\0\0\0\0\0\0\0\127\189\255\191\255\1\255\255\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\7\0\4\0\0\0\39\0\240\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\255\255\127\248\255\255\255\
    \\255\255\15\0\0\0\0\224\0\252\255\255\255\63\255\7\255\255\255\255\255\231\0\0\0\0\0\222\111\4\255\255\255\255\255\31\128\63\0\64\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\63\0\0\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\128\
    \\255\252\255\255\255\255\255\255\255\255\255\255\255\255\249\255\255\255\255\255\255\255\255\255\31\0\0\254\255\255\255\255\255\13\0\127\0\0\0\0\0\0\0\214\247\255\255\175\255\13\
    \\32\95\0\0\240\0\0\0\0\224\159\249\255\255\253\237\35\0\0\0\176\3\0\2\0\232\199\61\214\24\199\255\3\0\0\1\0\0\0\0\0\0\0\255\254\255\255\255\31\0\
    \\0\0\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\
    \\255\1\0\0\0\0\0\254\255\255\7\254\255\255\7\192\255\255\255\255\255\255\255\255\255\255\127\252\252\252\28\0\0\0\0\255\239\255\255\127\255\255\183\255\63\255\63\0\0\0\
    \\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\252\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\223\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\31\0\128\7\0\128\3\0\0\0\255\255\255\255\255\255\0\0\176\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\255\255\255\127\183\63\31\192\127\251\255\255\255\255\1\0\64\0\0\0\191\253\255\255\255\3\0\1\0\0\255\255\255\255\255\15\0\0\0\0\252\255\255\63\128\255\255\63\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\3\3\0\252\0\0\0\0\0\0\0\132\252\47\63\80\253\255\243\224\67\0\0\255\255\255\255\255\1\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\128\0\0\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\127\0\0\0\0\0\15\0\0\
    \\0\0\132\252\47\63\80\253\255\243\224\67\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\239\111\255\253\255\255\255\127\0\0\1\0\0\0\0\0\252\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\
    \\1\0\0\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\255\255\255\255\255\255\255\255\223\100\222\255\235\
    \\239\255\255\255\255\255\255\255\255\255\61\127\61\255\255\255\255\255\61\255\255\255\255\61\127\61\255\127\255\255\255\255\255\255\254\255\255\255\127\2\255\255\255\255\255\1\0\0\0\0\
    \\0\0\0\0\255\255\255\135\7\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\1\0\255\255\61\255\255\255\255\255\255\255\255\7\0\0\0\0\255\255\0\0\255\255\255\255\255\255\255\255\255\255\63\63\255\255\255\255\63\63\
    \\255\170\255\255\255\63\255\255\255\255\255\255\223\95\220\31\207\15\255\31\220\31\244\255\253\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\7\0\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\15\0\0\255\255\255\255\255\255\0\0\
    \\15\0\0\0\248\255\255\224\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\255\255\255\63\1\0\239\254\255\255\63\0\0\0\0\0\255\255\255\31\255\255\255\31\0\0\0\0\255\254\255\255\31\0\0\0\255\255\255\31\128\0\255\255\
    \\63\0\0\0\0\0\255\255\3\0\0\0\0\0\255\255\31\0\0\0\255\255\127\0\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\128\0\0\0\0\0\0\0\0\0\
    \\0\0\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\255\255\255\249\255\255\15\0\0\0\0\0\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\127\111\255\127\242\111\255\255\255\0\128\2\0\0\0\0\0\0\0\0\0\0\0\255\252\255\255\255\255\1\0\10\0\0\0\1\248\255\255\255\255\7\4\0\0\1\240\
    \\255\255\255\255\255\3\0\32\0\0\255\255\255\255\255\255\255\255\255\1\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\63\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\127\224\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\31\128\63\0\64\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\0\248\160\255\253\127\95\219\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\3\0\0\0\248\255\255\255\255\255\255\255\63\0\0\255\255\255\255\255\255\255\255\252\255\255\255\255\255\255\0\0\0\0\0\255\15\255\255\255\255\0\
    \\224\255\255\255\7\255\255\255\255\63\0\255\255\255\63\255\255\255\255\15\255\62\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\255\1\0\
    \\0\0\0\0\255\255\3\128\255\255\3\0\255\255\3\0\255\223\1\0\255\255\255\255\255\255\15\0\0\0\128\16\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\1\255\255\
    \\255\255\255\5\255\255\255\255\255\255\255\255\63\0\255\255\63\0\255\255\7\0\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\127\0\0\0\0\0\0\255\255\
    \\255\63\31\0\255\255\255\255\255\15\255\255\255\3\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\1\255\255\255\255\255\5\255\255\255\255\255\255\255\255\63\0\255\255\
    \\255\3\255\255\255\3\0\0\0\0\255\255\255\255\255\255\255\192\0\0\0\0\0\0\0\0\255\255\63\4\16\1\0\0\255\255\255\1\255\7\255\255\255\254\0\0\255\255\255\255\
    \\255\3\0\0\0\0\0\0\253\255\255\255\0\0\0\224\255\255\255\255\255\255\255\255\255\255\63\0\2\0\0\252\255\255\255\7\48\4\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\1\0\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\120\12\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\1\0\0\247\15\0\0\255\255\127\196\255\255\255\255\255\255\98\62\5\0\0\56\255\7\28\0\252\255\255\63\0\
    \\255\255\127\0\0\0\255\255\255\31\240\255\255\255\255\255\7\0\0\128\0\0\223\255\0\124\255\255\255\255\255\255\255\255\255\7\1\0\0\0\0\0\0\0\248\255\0\0\0\0\
    \\0\0\0\0\11\0\124\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\255\255\255\249\255\255\15\0\0\0\0\0\240\255\255\255\255\255\255\35\0\0\1\
    \\255\3\0\254\255\225\159\249\255\255\253\197\35\0\64\0\176\3\0\3\16\224\135\249\255\255\253\109\3\0\0\0\94\0\0\28\0\224\191\251\255\255\253\237\35\0\0\1\0\3\
    \\0\0\2\224\223\253\255\255\253\255\35\0\0\0\55\3\0\0\0\225\223\253\255\255\253\239\35\0\0\0\112\3\0\6\0\240\223\253\255\255\255\255\39\0\64\112\128\3\0\0\
    \\252\224\255\127\252\255\255\251\47\127\0\0\0\0\0\0\0\224\255\255\255\255\255\15\0\224\31\0\0\0\0\0\0\248\255\255\255\1\192\0\252\255\255\255\255\63\0\0\0\224\
    \\0\0\0\254\3\62\31\254\255\255\255\255\255\255\255\255\255\127\248\254\255\255\255\255\255\255\255\255\255\255\247\187\247\255\255\7\0\0\0\255\255\255\255\255\255\15\0\252\255\255\
    \\255\255\255\15\0\0\0\0\0\0\0\252\104\126\126\126\0\127\127\255\255\255\255\255\247\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\0\0\0\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\255\255\255\255\15\255\255\255\255\15\255\255\255\255\255\0\255\255\255\255\255\255\15\0\255\247\255\247\183\255\251\255\251\
    \\27\255\255\255\255\255\255\15\0\255\255\255\255\255\255\127\0\255\255\63\0\255\0\0\0\191\255\255\255\255\255\253\7\0\0\0\0\0\0\0\0\63\253\255\255\255\255\191\145\255\
    \\255\63\0\255\255\127\0\255\255\255\127\0\0\0\0\0\0\0\0\255\255\55\0\248\255\255\255\255\255\255\0\0\0\0\0\0\0\38\0\248\255\255\255\255\255\0\0\0\0\255\
    \\255\255\1\0\0\248\255\255\255\127\0\0\0\144\0\255\255\255\255\71\0\248\255\255\255\255\255\7\0\30\0\0\20\0\0\0\0\224\159\249\255\255\253\237\35\0\0\1\224\3\
    \\0\0\0\255\75\255\255\255\255\191\0\0\0\10\0\0\0\0\0\255\255\255\255\255\255\0\0\16\0\0\0\0\0\0\0\255\255\255\255\255\7\0\1\0\0\0\0\0\0\0\
    \\0\255\255\255\7\0\0\0\0\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\127\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\128\255\255\223\
    \\255\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\255\253\255\255\247\15\0\0\0\0\0\0\255\255\255\255\255\255\255\255\15\8\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\239\255\255\255\150\254\247\10\132\234\150\170\150\247\247\94\255\251\255\15\238\251\255\15\0\0\0\0\0\0\0\0"#

isID_StartOffsetsBitMap :: Ptr Word16
isID_StartOffsetsBitMap = Ptr
    "\90\0\154\0\162\0\91\1\205\3\148\5\241\0\202\9\172\9\229\10\5\11\41\3\37\11\69\11\9\3\67\3\2\2\154\0\121\5\232\5\153\0\154\0\121\0\0\9\28\9\84\9\28\7\101\11\136\2\66\0\154\0\4\6\176\4\158\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\40\10\122\1\246\4\246\4\133\11\0\0\
    \\246\4\246\4\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\66\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\
    \\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\
    \\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\30\0\154\0\17\1\235\2\165\11\134\10\103\10\197\11\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\
    \\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\109\2\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\154\0\
    \\213\0\138\8\154\0\165\8\4\4\135\3\167\3\91\3\107\3\197\8\229\11\5\12\154\0\37\12\69\12\140\9\224\6\52\9\233\1\109\4\126\4\0\7\101\12\133\12\34\2\165\12\29\4\196\4\197\12\229\12\206\2\164\7\196\7\42\5\24\5\86\4\59\6\36\6\154\0\154\0\154\0\240\3\224\3\198\1\246\4\246\4\246\4\246\4\246\4\246\4\
    \\246\4\246\4\246\4\212\1\154\0\154\0\154\0\154\0\41\1\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\53\1\154\0\154\0\5\13\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\
    \\246\4\246\4\246\4\246\7\246\4\246\4\246\4\246\4\246\4\246\4\154\0\154\0\220\7\156\6\246\4\180\6\76\7\166\10\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\37\13\58\2\246\4\246\4\
    \\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\248\4\154\0\84\2\98\2\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\71\1\246\4\246\4\246\4\246\4\246\4\
    \\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\96\5\154\1\166\1\69\13\246\4\246\4\246\4\246\4\246\4\246\4\246\4\22\8\48\8\168\2\182\2\246\4\124\6\194\6\54\4\133\7\108\7\101\13\246\4\246\4\246\4\246\4\133\13\246\4\246\4\246\4\246\4\246\4\
    \\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\
    \\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\
    \\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\
    \\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\62\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\58\0\154\0\154\0\154\0\
    \\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\205\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\202\5\154\0\154\0\
    \\8\10\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\246\4\154\0\154\0\246\7\246\4\246\4\246\4\246\4\246\4\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\189\3\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\
    \\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\244\3"#

{-# INLINE isUppercase #-}
isUppercase :: Char -> Bool
isUppercase c = c >= '\x0041' && c <= '\x1F189' && lookupIsUppercaseBitMap (ord c)

{-# INLINE lookupIsUppercaseBitMap #-}
lookupIsUppercaseBitMap :: Int -> Bool
lookupIsUppercaseBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 9
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 6) - 1
    !(Ptr data#) = isUppercaseDataBitMap
    !(Ptr offsets#) = isUppercaseOffsetsBitMap

isUppercaseDataBitMap :: Ptr Int8
isUppercaseDataBitMap = Ptr
    "\255\255\255\255\255\255\0\0\0\0\0\0\85\85\85\85\1\84\85\85\85\85\85\85\171\42\85\85\85\85\85\85\85\85\85\85\85\85\254\255\255\255\127\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\254\255\255\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\3\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\191\32\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\63\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\2\255\255\255\255\255\231\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\255\255\255\255\0\0\0\0\0\0\0\0\255\255\255\1\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\191\32\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\255\255\255\3\255\255\255\3\255\255\255\3\255\255\255\255\255\255\0\0\0\0\0\0\157\234\37\192\85\85\85\85\85\85\85\85\85\85\85\85\5\40\4\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\192\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\132\56\39\62\80\61\15\192\32\0\0\0\255\255\0\0\8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\254\255\255\7\0\0\0\0\0\0\0\0\0\0\0\0\255\255\127\127\0\0\0\0\85\85\85\85\85\85\85\170\170\84\85\85\85\85\85\43\214\206\219\177\213\210\174\17\144\
    \\164\170\74\85\85\210\85\85\85\85\85\85\5\108\122\85\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\69\128\64\215\254\255\251\15\0\0\0\128\28\85\85\85\144\230\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\15\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\247\255\247\55\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\7\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\3\0\0\240\255\255\63\0\0\0\255\255\
    \\255\3\0\0\208\100\222\63\0\0\0\255\255\255\3\0\0\176\231\223\31\0\0\0\123\95\252\1\0\0\240\255\255\63\0\0\0\255\255\255\3\0\0\240\255\255\63\0\0\0\
    \\255\255\255\3\0\0\0\255\255\255\1\0\0\0\252\255\255\7\0\0\0\240\255\255\31\0\0\0\192\255\255\127\0\0\0\0\255\255\255\1\0\0\0\4\0\0\0\0\0\0\
    \\255\255\255\255\255\255\0\0\0\0\0\0\157\234\37\192\85\85\85\85\85\85\85\85\85\85\85\85\5\40\4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\85\85\85\85\85\21\0\0\85\85\85\5\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\84\85\84\85\85\85\85\85\
    \\85\85\0\106\85\40\69\85\85\125\95\85\245\90\85\21\0\0\32\0\255\255\255\3\0\0\240\255\255\63\0\0\0\255\255\255\3\0\0\208\100\222\63\0\0\0\255\255\255\3\
    \\0\0\176\231\223\31\0\0\0\123\95\252\1\0\0\240\255\255\63\0\0\0\255\255\255\3\0\0\240\255\255\63\0\0\0\0\0\0\0\0\255\255\255\255\0\0\0\0\0\0\
    \\0\0\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\85\85\85\85\
    \\85\85\85\85\85\85\85\85\85\85\85\85\85\85\21\64\85\85\85\85\85\85\85\85\85\85\85\85\0\255\0\63\0\255\0\255\0\63\0\170\0\255\0\0\0\0\0\0\0\0\
    \\0\15\0\15\0\15\0\31\0\15"#

isUppercaseOffsetsBitMap :: Ptr Word16
isUppercaseOffsetsBitMap = Ptr
    "\231\2\38\3\0\0\43\0\43\0\43\0\43\0\43\0\155\0\181\0\43\0\43\0\43\0\43\0\80\1\66\5\175\2\43\0\143\2\43\0\43\0\43\0\101\2\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\
    \\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\132\4\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\
    \\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\71\0\43\0\43\0\102\3\43\0\43\0\43\0\244\0\43\0\43\0\43\0\43\0\43\0\33\1\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\
    \\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\167\1\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\
    \\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\217\3\12\4\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\111\0\43\0\43\0\43\0\51\2"#

{-# INLINE isLowercase #-}
isLowercase :: Char -> Bool
isLowercase c = c >= '\x0061' && c <= '\x1E943' && lookupIsLowercaseBitMap (ord c)

{-# INLINE lookupIsLowercaseBitMap #-}
lookupIsLowercaseBitMap :: Int -> Bool
lookupIsLowercaseBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 9
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 6) - 1
    !(Ptr data#) = isLowercaseDataBitMap
    !(Ptr offsets#) = isLowercaseOffsetsBitMap

isLowercaseDataBitMap :: Ptr Int8
isLowercaseDataBitMap = Ptr
    "\170\170\170\170\170\170\170\170\170\170\170\170\170\170\170\170\170\170\234\191\170\170\170\170\170\170\170\170\170\170\170\170\255\0\63\0\255\0\255\0\63\0\255\0\255\0\255\63\255\0\
    \\255\0\255\0\223\64\220\0\207\0\255\0\220\0\0\0\252\255\255\15\0\0\192\223\255\255\0\0\0\252\255\255\15\0\0\192\235\239\255\0\0\0\252\255\255\15\0\0\192\255\
    \\255\255\0\0\0\252\255\255\15\0\0\192\255\255\255\0\0\0\252\255\255\15\0\0\192\255\255\255\0\0\0\252\255\255\63\0\0\0\252\255\255\247\3\0\0\240\255\255\223\15\
    \\0\0\192\255\255\127\63\0\0\0\255\255\255\253\0\0\0\252\255\255\247\11\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\255\251\255\127\224\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\63\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\251\255\127\224\7\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\185\255\
    \\255\255\255\255\253\7\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\0\0\0\0\0\0\0\248\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\127\0\248\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\
    \\255\255\255\255\247\255\3\255\255\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\
    \\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\128\255\251\255\251\27\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\254\255\255\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\255\255\255\255\255\247\255\3\255\255\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\170\170\170\170\170\42\0\0\170\170\170\58\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\168\170\171\170\170\170\170\170\170\170\255\149\170\80\186\170\170\130\160\170\10\165\170\10\0\0\94\7\0\0\0\0\0\0\255\255\255\255\
    \\255\255\170\170\170\170\2\168\170\170\170\170\170\170\84\213\170\170\170\170\170\170\170\170\170\170\170\170\0\0\0\0\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\2\128\0\0\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\196\8\0\0\128\16\50\192\67\0\0\0\0\255\255\16\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\127\0\248\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\254\255\255\7\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\63\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\5\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\254\255\255\7\0\0\0\0\0\4\32\4\0\0\0\128\255\255\127\255\170\170\170\170\170\170\170\85\85\171\170\170\170\
    \\170\170\212\41\49\36\78\42\45\81\230\64\82\85\181\170\170\41\170\170\170\170\170\170\250\147\133\170\255\255\255\255\255\255\255\255\207\255\255\255\255\1\3\0\0\0\31\0\0\0\
    \\0\0\0\0\0\0\0\0\32\0\0\0\0\0\138\60\0\0\1\0\0\240\255\255\255\127\227\170\170\170\47\25\0\0\0\0\0\0\255\255\255\255\255\255\255\63\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\252\255\255\255\
    \\15\0\0\0\0\0\0\255\255\255\255\255\255\98\21\218\63\170\170\170\170\170\170\170\170\170\170\170\170\26\80\8\0\255\255\255\255\191\32\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\247\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\63"#

isLowercaseOffsetsBitMap :: Ptr Word16
isLowercaseOffsetsBitMap = Ptr
    "\81\4\144\4\228\2\22\3\22\3\22\3\22\3\22\3\59\5\92\5\22\3\22\3\22\3\22\3\25\4\0\0\72\3\22\3\138\1\22\3\22\3\22\3\21\5\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\
    \\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\164\2\22\3\205\1\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\
    \\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\170\1\22\3\64\2\22\3\22\3\8\2\44\1\22\3\22\3\232\3\22\3\22\3\22\3\22\3\22\3\121\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\
    \\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\100\1\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\
    \\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\22\3\63\0\114\0\22\3\22\3\22\3\172\0\230\0\22\3\22\3\22\3\236\4"#

{-# INLINE isAlphabetic #-}
isAlphabetic :: Char -> Bool
isAlphabetic c = c >= '\x0041' && c <= '\x33479' && lookupIsAlphabeticBitMap (ord c)

{-# INLINE lookupIsAlphabeticBitMap #-}
lookupIsAlphabeticBitMap :: Int -> Bool
lookupIsAlphabeticBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isAlphabeticDataBitMap
    !(Ptr offsets#) = isAlphabeticOffsetsBitMap

isAlphabeticDataBitMap :: Ptr Int8
isAlphabeticDataBitMap = Ptr
    "\224\255\255\255\255\255\254\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\0\0\0\0\0\0\255\255\255\252\255\31\0\0\255\255\255\1\255\7\255\255\255\254\128\0\
    \\255\255\255\255\255\3\240\255\248\3\255\255\255\255\255\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\239\111\240\239\254\255\255\63\0\0\0\0\0\255\255\255\31\255\255\255\31\0\0\0\0\255\254\255\255\31\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\31\0\0\0\0\0\0\0\0\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\0\0\0\0\0\
    \\0\0\254\255\255\7\254\255\255\7\0\0\0\0\0\4\32\4\255\255\127\255\255\255\127\255\15\255\1\0\0\255\255\255\63\31\0\255\255\255\255\255\15\255\255\255\3\0\0\0\
    \\0\0\0\0\0\32\0\0\0\248\255\223\188\64\215\255\255\251\255\255\255\255\255\255\255\255\255\191\255\255\255\255\0\0\0\255\255\255\255\255\255\15\0\255\255\255\255\255\255\255\
    \\255\47\0\0\0\0\0\252\232\255\255\255\255\255\255\231\127\0\0\255\255\255\255\255\255\255\255\255\32\0\0\255\255\255\255\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\
    \\0\0\0\255\255\255\255\255\255\255\255\0\0\0\128\255\252\255\255\255\255\255\255\255\255\255\255\255\255\249\255\255\255\255\255\255\255\255\255\31\0\0\254\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\80\0\0\255\7\255\255\255\255\255\255\255\254\0\192\255\255\255\255\255\
    \\255\255\255\255\255\255\255\239\31\254\225\0\156\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\255\255\127\0\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\3\0\0\0\0\254\255\255\7\254\255\255\7\192\255\255\255\255\255\255\255\255\255\255\127\252\252\252\28\0\0\0\0\255\255\255\255\255\255\0\224\255\255\255\255\255\255\
    \\255\255\255\255\255\255\3\0\0\252\255\255\255\7\48\4\255\31\255\255\0\12\0\0\255\255\255\255\255\127\240\143\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\0\126\0\
    \\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\31\255\1\255\67\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\192\255\255\255\255\255\255\3\0\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\63\255\255\255\253\255\255\247\255\255\255\247\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\
    \\255\255\255\255\255\255\255\255\255\255\1\0\0\0\0\0\0\255\255\255\255\255\255\7\0\255\255\255\255\255\255\7\0\240\0\255\255\255\255\71\0\255\255\255\255\255\255\255\255\30\
    \\192\0\20\0\0\0\0\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\0\4\0\0\0\39\0\240\0\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\255\255\127\248\255\255\255\255\255\15\255\255\255\255\255\255\255\127\254\255\
    \\31\0\0\0\0\0\128\0\0\128\1\112\0\0\0\0\0\0\255\255\255\255\255\31\128\63\0\64\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\255\255\255\63\0\0\255\255\255\255\255\15\0\0\255\255\251\255\255\255\159\192\3\0\0\0\0\0\0\0\127\189\255\191\255\1\255\255\255\255\255\255\255\1\0\0\0\0\0\0\
    \\0\255\254\255\255\255\31\254\255\15\255\255\254\255\255\255\31\0\0\0\0\0\0\0\0\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\
    \\255\255\31\255\255\255\255\255\255\1\0\0\0\0\0\255\239\255\255\127\255\255\183\255\63\255\63\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\252\255\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\223\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\128\0\255\255\63\0\0\0\0\0\
    \\255\255\3\0\0\0\0\0\255\255\31\0\0\0\255\255\127\0\255\255\255\255\255\0\0\0\0\252\255\255\63\130\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\255\255\255\255\255\27\3\0\252\0\0\0\0\0\0\28\132\252\47\62\80\189\255\243\224\67\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\
    \\128\0\0\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\63\127\0\0\0\63\0\0\0\0\191\231\223\223\255\255\255\123\95\252\253\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\255\255\255\255\255\255\255\255\223\100\222\255\235\239\255\255\255\255\255\255\255\239\255\223\225\255\15\0\254\255\
    \\239\159\249\255\255\253\197\227\159\89\128\176\15\0\3\16\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\1\0\255\255\255\255\255\255\254\255\255\255\127\2\255\255\255\255\255\1\0\0\0\0\255\191\182\0\255\255\255\135\7\0\
    \\255\253\255\255\255\255\127\127\1\0\0\0\0\0\252\255\255\255\252\255\255\254\127\0\0\0\0\0\0\0\0\0\0\0\0\255\0\0\0\0\0\0\0\0\0\0\0\255\255\255\
    \\255\1\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\15\0\0\255\255\255\255\255\255\0\0\15\0\0\0\248\255\255\224\255\255\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\63\1\0\238\159\249\255\255\253\237\227\159\25\
    \\192\176\15\0\2\0\236\199\61\214\24\199\255\195\199\29\129\0\0\0\0\0\128\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\
    \\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\255\255\255\249\255\255\15\0\0\0\0\0\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\127\111\255\127\242\111\255\255\255\191\153\7\0\0\0\0\0\0\0\0\0\0\0\255\252\255\255\255\255\255\252\26\0\0\0\239\255\255\255\150\254\247\10\132\234\150\170\150\247\247\
    \\94\255\251\255\15\238\251\255\15\0\0\0\0\0\0\0\0\255\255\255\3\255\255\255\3\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\255\255\255\127\255\255\63\192\255\255\255\255\255\255\255\255\255\61\127\61\255\255\255\255\255\61\255\255\255\255\61\127\61\255\127\255\255\255\255\255\255\127\249\0\0\255\255\
    \\255\255\255\255\255\255\0\60\255\255\255\255\191\32\255\255\255\255\255\247\255\255\255\255\255\255\255\255\255\135\255\255\255\255\255\255\255\128\255\255\0\0\0\0\0\0\0\0\11\0\
    \\127\0\248\224\255\253\127\95\219\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\248\255\255\255\255\255\255\255\63\0\0\255\255\255\255\255\255\255\255\252\255\255\255\255\
    \\255\255\0\0\0\0\0\255\15\255\255\255\255\0\224\255\255\255\7\255\255\255\255\255\7\255\255\255\63\255\255\255\255\15\255\62\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\255\255\255\31\255\255\255\255\255\255\1\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\255\255\255\255\15\255\255\255\255\15\
    \\128\255\255\15\0\255\255\15\0\255\223\13\0\255\255\255\255\255\255\207\255\255\1\128\16\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\1\255\255\255\255\255\7\255\255\255\
    \\255\255\255\255\255\63\0\0\0\0\0\62\0\255\255\255\255\255\255\255\1\4\0\255\255\255\1\0\0\255\255\255\255\191\32\255\255\255\255\255\255\255\128\0\0\255\255\127\0\127\
    \\127\127\127\127\127\127\127\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\120\12\0\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\0\0\0\0\0\255\255\255\3\255\255\255\3\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\
    \\255\255\255\255\255\255\255\255\61\127\61\255\255\255\255\255\61\255\255\255\255\61\127\61\255\127\255\255\255\255\255\61\255\255\255\255\255\255\255\255\7\0\0\0\0\255\255\0\0\255\
    \\255\255\255\255\255\255\255\255\255\63\63\255\255\255\255\63\63\255\170\255\255\255\63\255\255\255\255\255\255\223\95\220\31\207\15\255\31\220\31\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\1\0\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\255\255\255\255\255\255\127\0\255\63\0\0\255\255\127\252\255\255\255\255\255\255\255\127\5\0\0\56\255\255\60\0\252\255\255\255\7\255\255\255\255\7\0\255\255\255\31\255\255\
    \\255\255\255\255\247\255\0\128\0\0\255\255\0\124\238\135\249\255\255\253\109\195\135\25\2\94\0\0\63\0\238\191\251\255\255\253\237\227\191\27\1\0\15\0\0\30\255\223\253\255\
    \\255\253\255\227\223\29\96\55\15\0\0\0\239\223\253\255\255\253\239\227\223\29\96\112\15\0\14\0\255\223\253\255\255\255\255\231\223\93\240\128\15\0\0\252\238\255\127\252\255\255\
    \\251\47\127\128\95\255\0\0\12\0\254\255\255\255\255\255\255\7\127\32\0\0\0\0\0\0\214\247\255\255\175\255\255\59\95\32\0\240\0\0\0\0\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\159\255\255\254\255\255\7\255\255\255\255\255\255\255\255\255\199\255\1\255\255\255\255\255\255\239\255\239\31\0\0\0\0\0\0\255\255\255\255\255\243\0\252\255\255\
    \\255\255\191\255\3\0\255\255\255\255\255\255\127\0\0\224\0\252\255\255\255\63\255\7\255\255\255\255\255\231\0\0\0\0\0\222\111\4\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\0\0\248\255\255\255\31\0\224\0\0\0\254\3\62\31\254\255\255\255\255\255\255\255\255\255\127\224\254\255\255\255\255\255\255\255\255\255\
    \\255\247\126\126\126\0\127\127\255\255\255\255\255\247\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\0\0\255\255\255\255\255\0\255\255\255\255\255\255\15\0\255\247\
    \\255\247\183\255\251\255\251\27\255\255\255\255\255\255\15\0\255\255\255\255\255\255\127\0\255\255\63\0\255\0\0\0\191\255\255\255\255\255\253\7\0\0\0\0\0\0\0\0\63\253\
    \\255\255\255\255\191\145\255\255\63\0\255\255\127\0\255\255\255\127\0\0\0\0\0\0\0\0\255\255\55\0\255\255\63\0\255\255\255\3\255\255\255\3\0\0\0\0\255\255\255\255\
    \\255\255\255\192\0\0\0\0\0\0\0\0\255\255\255\255\255\255\63\0\255\255\63\0\255\255\7\0\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\239\159\249\255\255\253\
    \\237\227\159\25\129\224\15\0\0\0\255\75\255\255\255\255\191\255\165\55\10\0\0\0\0\0\255\255\255\255\255\255\255\255\187\7\0\128\3\0\0\0\255\255\255\255\255\255\255\255\
    \\179\0\0\0\0\0\0\0\255\255\255\255\255\255\255\127\17\0\0\0\0\0\0\0\255\255\255\255\255\255\63\1\0\0\0\0\0\0\0\0\255\255\255\231\255\7\0\0\127\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\251\255\255\255\255\127\180\203\0\0\0\191\253\255\255\255\127\123\1\0\0\255\255\255\255\255\15\
    \\0\0\0\0\255\255\253\255\255\255\255\199\1\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\1\255\255\255\127\0\0\
    \\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\63\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\128\
    \\255\255\223\255\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\255\253\255\255\247\15\0\0\0\0\0\0\255\255\255\127\224\7\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\255\255\249\219\7\255\255\255\255\255\255\255\63\0\0\0\128\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\
    \\255\255\255\255\143\8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"#

isAlphabeticOffsetsBitMap :: Ptr Word16
isAlphabeticOffsetsBitMap = Ptr
    "\194\0\137\1\145\1\247\0\129\4\238\5\175\1\72\2\30\0\154\5\104\10\204\6\136\10\168\10\200\10\19\4\246\7\137\1\219\7\175\9\136\1\137\1\232\10\199\8\227\8\221\0\168\3\8\11\40\11\72\11\137\1\203\9\55\5\37\5\69\0\69\0\178\2\69\0\69\0\69\0\69\0\69\0\69\0\69\0\53\9\25\9\231\6\69\0\104\11\0\0\
    \\69\0\69\0\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\170\0\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\
    \\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\
    \\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\134\0\137\1\104\2\106\1\21\1\72\10\41\10\136\11\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\
    \\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\140\3\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\137\1\
    \\14\2\52\8\137\1\79\8\184\4\42\2\91\4\43\4\59\4\111\8\170\8\168\11\137\1\200\11\232\11\8\12\102\0\40\12\33\3\244\4\5\5\212\4\249\8\57\3\246\3\72\12\104\12\75\5\136\12\168\12\77\1\111\7\53\1\37\6\14\6\200\12\219\1\232\12\137\1\137\1\137\1\164\4\148\4\254\2\69\0\69\0\69\0\69\0\69\0\69\0\
    \\69\0\69\0\69\0\12\3\137\1\137\1\137\1\137\1\128\2\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\140\2\137\1\137\1\60\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\
    \\69\0\69\0\69\0\63\0\69\0\69\0\69\0\69\0\69\0\69\0\137\1\137\1\8\13\134\6\69\0\158\6\23\7\22\8\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\40\13\89\3\69\0\69\0\
    \\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\71\0\137\1\115\3\129\3\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\158\2\69\0\69\0\69\0\69\0\69\0\
    \\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\129\5\210\2\222\2\72\13\69\0\69\0\69\0\69\0\69\0\69\0\69\0\104\13\136\13\200\3\214\3\69\0\102\6\172\6\187\7\80\7\55\7\168\13\69\0\69\0\69\0\69\0\143\7\69\0\69\0\169\7\69\0\69\0\
    \\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\
    \\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\
    \\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\
    \\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\166\0\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\162\0\137\1\137\1\137\1\
    \\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\6\2\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\208\5\137\1\137\1\
    \\207\1\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\137\1\137\1\215\1\69\0\69\0\69\0\69\0\69\0\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\113\4\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\
    \\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\137\1\168\4"#

