{-# OPTIONS_GHC -fno-warn-unused-imports #-}
module CabalBundler.NixSingle.Template (render) where
import Prelude (String, fst, snd, ($), return)
import Control.Monad (forM_)
import CabalBundler.NixSingle.Input
type Writer a = (String, a)
tell :: String -> Writer (); tell x = (x, ())
execWriter :: Writer a -> String; execWriter = fst
render :: ZZ -> String
render z_root = execWriter $ do
  tell "{ stdenv\n"
  tell ", ghc\n"
  tell ", cabal-install\n"
  tell ", gcc\n"
  tell ", zlib\n"
  tell "}:\n"
  tell "\n"
  tell "let\n"
  tell "  hackageTarball = name: version: sha256: rest:\n"
  tell "    let\n"
  tell "      # We need a source tarball, note we use fetchurl: we know the hash of tarball, not \"nar\".\n"
  tell "      tarball = builtins.fetchurl {\n"
  tell "        url    = \"http://hackage.haskell.org/package/${name}-${version}/${name}-${version}.tar.gz\";\n"
  tell "        sha256 = sha256;\n"
  tell "      };\n"
  tell "\n"
  tell "      unpackedTarball = stdenv.mkDerivation {\n"
  tell "        name    = \"${name}-${version}-unpacked\";\n"
  tell "        tarball = tarball;\n"
  tell "        # we only install\n"
  tell "        phases = [\"installPhase\"];\n"
  tell "        installPhase = ''\n"
  tell "          echo $out\n"
  tell "          echo $tarball\n"
  tell "          mkdir -p $out\n"
  tell "          tar -xvz --directory $out --strip-components=1 -f $tarball\n"
  tell "        '';\n"
  tell "      };\n"
  tell "\n"
  tell "      # If revision is specified, we fetch the revision;\n"
  tell "      # and make new source derivation\n"
  tell "      # with .cabal file changed\n"
  tell "      patchedTarball = if  rest ? rev == false then unpackedTarball else\n"
  tell "        let\n"
  tell "          rev = toString rest.rev;\n"
  tell "\n"
  tell "          cabalFile = builtins.fetchurl {\n"
  tell "            url    = \"http://hackage.haskell.org/package/${name}-${version}/revision/${rev}.cabal\";\n"
  tell "            sha256 = rest.sha256;\n"
  tell "          };\n"
  tell "\n"
  tell "          # The result is simple:\n"
  tell "          # - copy original sources\n"
  tell "          # - overwrite with revisioned .cabal file\n"
  tell "          patched = stdenv.mkDerivation {\n"
  tell "            name = \"${name}-${version}-r${rev}-source\";\n"
  tell "            pkgName   = name;\n"
  tell "            sources   = unpackedTarball;\n"
  tell "            cabalFile = cabalFile;\n"
  tell "\n"
  tell "            # we only install\n"
  tell "            phases = [\"installPhase\"];\n"
  tell "\n"
  tell "            installPhase = ''\n"
  tell "              echo out $out\n"
  tell "              echo sources $sources\n"
  tell "              echo cabalfile $cabalFile\n"
  tell "              mkdir -p $out\n"
  tell "              cp -r $sources/* $out\n"
  tell "              rm -f $out/${name}.cabal\n"
  tell "              cp $cabalFile $out/${name}.cabal\n"
  tell "            '';\n"
  tell "          };\n"
  tell "\n"
  tell "        in patched;\n"
  tell "\n"
  tell "    in patchedTarball;\n"
  tell "in\n"
  tell "\n"
  tell "stdenv.mkDerivation {\n"
  tell "  name = \""
  tell (zDerivationName z_root)
  tell "\";\n"
  tell "\n"
  tell "  buildCommand = ''\n"
  tell "    TOPDIR=$(pwd)\n"
  tell "\n"
  tell "    CC=$gcc/bin/gcc\n"
  tell "    HC=$ghc/bin/ghc\n"
  tell "    HCPKG=$ghc/bin/ghc-pkg\n"
  tell "    CABAL=$cabal/bin/cabal\n"
  tell "\n"
  tell "    echo \"Tools: $CC $HC $HCPKG $CABAL\"\n"
  tell "\n"
  tell "    export LANG=C.utf8\n"
  tell "    export CABAL_DIR=$TOPDIR/.cabal\n"
  tell "    export CABAL_CONFIG=$CABAL_DIR/config\n"
  tell "\n"
  tell "    mkdir -p $CABAL_DIR\n"
  tell "    cat > $CABAL_CONFIG <<EOF\n"
  tell "    -- doesn't work\n"
  tell "    -- https://github.com/haskell/cabal/issues/5956\n"
  tell "    verbose: normal +nowrap\n"
  tell "    jobs: $NIX_BUILD_CORES\n"
  tell "\n"
  tell "    -- No global repository, all deps should exist in global package-db\n"
  tell "    -- repository hackage.haskell.org\n"
  tell "    --   url: http://hackage.haskell.org/\n"
  tell "\n"
  tell "    remote-repo-cache:      $CABAL_DIR/packages\n"
  tell "\n"
  tell "    -- cabal-install-2.2 doesn't know this yet :/\n"
  tell "    -- write-ghc-environment-files: never\n"
  tell "\n"
  tell "    build-summary:     $CABAL_DIR/logs/build.log\n"
  tell "    extra-prog-path:   $CABAL_DIR/bin\n"
  tell "    -- installdir:        $CABAL_DIR/bin\n"
  tell "    logs-dir:          $CABAL_DIR/logs\n"
  tell "    store-dir:         $CABAL_DIR/store\n"
  tell "    symlink-bindir:    $CABAL_DIR/bin\n"
  tell "    world-file:        $CABAL_DIR/world\n"
  tell "\n"
  tell "    install-dirs user\n"
  tell "    EOF\n"
  tell "\n"
  tell "    # Tool versions\n"
  tell "    ###############\n"
  tell "\n"
  tell "    $HC --version\n"
  tell "    $CABAL --version\n"
  tell "\n"
  tell "    echo \"Generating project file\"\n"
  tell "    ##############################\n"
  tell "\n"
  tell "    cat > cabal.project <<EOF\n"
  tell "    tests: False\n"
  tell "    benchmarks: False\n"
  tell "    documentation: False\n"
  tell "    EOF\n"
  tell "\n"
  tell "    for dep in $hsdeps; do\n"
  tell "      echo \"packages: $dep/*.cabal\" >> cabal.project\n"
  tell "    done\n"
  tell "\n"
  tell "    for dep in $cdeps; do\n"
  tell "      if [ -d \"$dep/lib\" ]; then\n"
  tell "        echo \"extra-lib-dirs: $dep/lib\" >> cabal.project\n"
  tell "      fi\n"
  tell "      if [ -d \"$dep/include\" ]; then\n"
  tell "        echo \"extra-include-dirs: $dep/include\" >> cabal.project\n"
  tell "      fi\n"
  tell "    done\n"
  tell "\n"
  tell "    echo \"Building project\"\n"
  tell "    #######################\n"
  tell "\n"
  tell "    $CABAL new-build -vverbose+nowrap --with-compiler=$HC --with-ghc=$CC \"$targetComp\"\n"
  tell "\n"
  tell "    echo \"Install built artifact\"\n"
  tell "    ##########################################\n"
  tell "\n"
  tell "    mkdir -p $out/bin\n"
  tell "    cp $(find dist-newstyle -name \"$targetExe\" -type f -executable | head -n1) $out/bin\n"
  tell "  '';\n"
  tell "\n"
  tell "  # Compiler\n"
  tell "  ghc     = ghc;\n"
  tell "  cabal   = cabal-install;\n"
  tell "  gcc     = gcc;\n"
  tell "\n"
  tell "  # Target\n"
  tell "  targetComp = \""
  tell (zComponentName z_root)
  tell "\";\n"
  tell "  targetExe  = \""
  tell (zExecutableName z_root)
  tell "\";\n"
  tell "\n"
  tell "  # Dependencies\n"
  tell "  cdeps   = [\n"
  forM_ (zCdeps z_root) $ \z_var0_dep -> do
    tell "    "
    tell z_var0_dep
    tell "\n"
  tell "    ];\n"
  tell "  hsdeps  = builtins.attrValues {\n"
  forM_ (zHsdeps z_root) $ \z_var1_dep -> do
    tell "    "
    tell (zdepName z_var1_dep)
    tell " = hackageTarball \""
    tell (zdepName z_var1_dep)
    tell "\" \""
    tell (zdepVersion z_var1_dep)
    tell "\" \""
    tell (zdepSha256 z_var1_dep)
    tell "\" "
    tell (zdepRevision z_var1_dep)
    tell ";\n"
  tell "  };\n"
  tell "}\n"
