# Examples

Consists of various examples to get familiar with writing GTK 4 applications using the Rust bindings. Note there are other examples part of [gtk-rs-core](https://github.com/gtk-rs/gtk-rs-core/tree/main/examples).

Each example can be run by changing the current working directory to this folder and then executing:

```bash
cargo run --bin [example_name]
```

For example, if you want to run the example in subfolder "basics", execute:

```bash
cargo run --bin basics
```

- [Basic example](./basics/)
- [About Dialog](./about_dialog/)
- [Implementing the Accessible Text Interface](./accessible_text/)
- [Using the Builder pattern](./builder_pattern/)
- [Clipboard](./clipboard/)
- [Clock example](./clock/)
- [Column View Datagrid Example](./column_view_datagrid/)
- [Composite Dialog](./composite_dialog/)
- [Composite Template](./composite_template/)
- [Confetti Snapshot Animation](./confetti_snapshot_animation/)
- [Content Provider](./content_provider/)
- [CSS](./css/)
- [Custom Application](./custom_application/)
- [Custom Buildable](./custom_buildable/)
- [Custom Editable](./custom_editable/)
- [Custom Layout Manager](./custom_layout_manager/)
- [Custom Orientable](./custom_orientable/)
- [Custom Paintable](./custom_paintable/)
- [Custom Widget](./custom_widget/)
- [Dialog](./dialog/)
- [Entry Completion](./entry_completion/)
- [Entry Undo](./entry_undo/)
- [Expressions](./expressions/)
- [FemtoVG Area](./femtovg_area/)
- [Fill and Stroke](./fill_and_stroke/)
- [FlowBox](./flow_box/)
- [GIF Paintable](./gif_paintable/)
- [Glium GL-Area](./glium_gl_area/)
- [Grid Packing](./grid_packing)
- [GtkBuilder](./gtk_builder/)
- [ListBox and ListModel](./list_box_model/)
- [ListBox: StringList with Sorter](./list_box_sort_stringlist/)
- [ListView: Applications Launcher](./list_view_apps_launcher/)
- [Menubar](./menubar/)
- [Rotation Bin](./rotation_bin/)
- [Scale](./scale/)
- [Scale Bin](./scale_bin/)
- [Search Bar](./search_bar/)
- [Squares](./squares/)
- [Squeezer Bin](./squeezer_bin/)
- [TextView](./text_viewer/)
- [Tokio Async Request](./tokio_async_request/)
- [Video Player](./video_player/)
- [Virtual Methods](./virtual_methods/)
