// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{ffi, RTSPStream};
#[cfg(feature = "v1_28")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_28")))]
use glib::signal::{connect_raw, SignalHandlerId};
use glib::{prelude::*, translate::*};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GstRTSPStreamTransport")]
    pub struct RTSPStreamTransport(Object<ffi::GstRTSPStreamTransport, ffi::GstRTSPStreamTransportClass>);

    match fn {
        type_ => || ffi::gst_rtsp_stream_transport_get_type(),
    }
}

impl RTSPStreamTransport {
    pub const NONE: Option<&'static RTSPStreamTransport> = None;

    //#[doc(alias = "gst_rtsp_stream_transport_new")]
    //pub fn new(stream: &impl IsA<RTSPStream>, tr: /*Ignored*/gst_rtsp::RTSPTransport) -> RTSPStreamTransport {
    //    unsafe { TODO: call ffi:gst_rtsp_stream_transport_new() }
    //}
}

pub trait RTSPStreamTransportExt: IsA<RTSPStreamTransport> + 'static {
    #[doc(alias = "gst_rtsp_stream_transport_get_rtpinfo")]
    #[doc(alias = "get_rtpinfo")]
    fn rtpinfo(&self, start_time: impl Into<Option<gst::ClockTime>>) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gst_rtsp_stream_transport_get_rtpinfo(
                self.as_ref().to_glib_none().0,
                start_time.into().into_glib(),
            ))
        }
    }

    #[doc(alias = "gst_rtsp_stream_transport_get_stream")]
    #[doc(alias = "get_stream")]
    fn stream(&self) -> Option<RTSPStream> {
        unsafe {
            from_glib_none(ffi::gst_rtsp_stream_transport_get_stream(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    //#[doc(alias = "gst_rtsp_stream_transport_get_transport")]
    //#[doc(alias = "get_transport")]
    //fn transport(&self) -> /*Ignored*/Option<gst_rtsp::RTSPTransport> {
    //    unsafe { TODO: call ffi:gst_rtsp_stream_transport_get_transport() }
    //}

    #[doc(alias = "gst_rtsp_stream_transport_get_url")]
    #[doc(alias = "get_url")]
    fn url(&self) -> Option<gst_rtsp::RTSPUrl> {
        unsafe {
            from_glib_none(ffi::gst_rtsp_stream_transport_get_url(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_stream_transport_is_timed_out")]
    #[doc(alias = "timed-out")]
    fn is_timed_out(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_rtsp_stream_transport_is_timed_out(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_rtsp_stream_transport_keep_alive")]
    fn keep_alive(&self) {
        unsafe {
            ffi::gst_rtsp_stream_transport_keep_alive(self.as_ref().to_glib_none().0);
        }
    }

    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    #[doc(alias = "gst_rtsp_stream_transport_message_sent")]
    fn message_sent(&self) {
        unsafe {
            ffi::gst_rtsp_stream_transport_message_sent(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gst_rtsp_stream_transport_recv_data")]
    fn recv_data(
        &self,
        channel: u32,
        buffer: gst::Buffer,
    ) -> Result<gst::FlowSuccess, gst::FlowError> {
        unsafe {
            try_from_glib(ffi::gst_rtsp_stream_transport_recv_data(
                self.as_ref().to_glib_none().0,
                channel,
                buffer.into_glib_ptr(),
            ))
        }
    }

    #[doc(alias = "gst_rtsp_stream_transport_send_rtcp")]
    fn send_rtcp(&self, buffer: &gst::Buffer) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_rtsp_stream_transport_send_rtcp(
                    self.as_ref().to_glib_none().0,
                    buffer.to_glib_none().0
                ),
                "Failed to send rtcp"
            )
        }
    }

    //#[cfg(feature = "v1_16")]
    //#[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    //#[doc(alias = "gst_rtsp_stream_transport_send_rtcp_list")]
    //fn send_rtcp_list(&self, buffer_list: /*Ignored*/&gst::BufferList) -> bool {
    //    unsafe { TODO: call ffi:gst_rtsp_stream_transport_send_rtcp_list() }
    //}

    #[doc(alias = "gst_rtsp_stream_transport_send_rtp")]
    fn send_rtp(&self, buffer: &gst::Buffer) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_rtsp_stream_transport_send_rtp(
                    self.as_ref().to_glib_none().0,
                    buffer.to_glib_none().0
                ),
                "Failed to send rtp"
            )
        }
    }

    //#[cfg(feature = "v1_16")]
    //#[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    //#[doc(alias = "gst_rtsp_stream_transport_send_rtp_list")]
    //fn send_rtp_list(&self, buffer_list: /*Ignored*/&gst::BufferList) -> bool {
    //    unsafe { TODO: call ffi:gst_rtsp_stream_transport_send_rtp_list() }
    //}

    #[doc(alias = "gst_rtsp_stream_transport_set_active")]
    fn set_active(&self, active: bool) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_rtsp_stream_transport_set_active(
                    self.as_ref().to_glib_none().0,
                    active.into_glib()
                ),
                "Failed to set active"
            )
        }
    }

    #[doc(alias = "gst_rtsp_stream_transport_set_callbacks")]
    fn set_callbacks<
        P: Fn(&gst::Buffer, u8) -> bool + 'static,
        Q: Fn(&gst::Buffer, u8) -> bool + 'static,
    >(
        &self,
        send_rtp: P,
        send_rtcp: Q,
    ) {
        let send_rtp_data: P = send_rtp;
        unsafe extern "C" fn send_rtp_func<
            P: Fn(&gst::Buffer, u8) -> bool + 'static,
            Q: Fn(&gst::Buffer, u8) -> bool + 'static,
        >(
            buffer: *mut gst::ffi::GstBuffer,
            channel: u8,
            user_data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let buffer = from_glib_borrow(buffer);
            let callback: &(P, Q) = &*(user_data as *mut _);
            let callback = &callback.0;
            (*callback)(&buffer, channel).into_glib()
        }
        let send_rtp = Some(send_rtp_func::<P, Q> as _);
        let send_rtcp_data: Q = send_rtcp;
        unsafe extern "C" fn send_rtcp_func<
            P: Fn(&gst::Buffer, u8) -> bool + 'static,
            Q: Fn(&gst::Buffer, u8) -> bool + 'static,
        >(
            buffer: *mut gst::ffi::GstBuffer,
            channel: u8,
            user_data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let buffer = from_glib_borrow(buffer);
            let callback: &(P, Q) = &*(user_data as *mut _);
            let callback = &callback.1;
            (*callback)(&buffer, channel).into_glib()
        }
        let send_rtcp = Some(send_rtcp_func::<P, Q> as _);
        unsafe extern "C" fn notify_func<
            P: Fn(&gst::Buffer, u8) -> bool + 'static,
            Q: Fn(&gst::Buffer, u8) -> bool + 'static,
        >(
            data: glib::ffi::gpointer,
        ) {
            let _callback: Box_<(P, Q)> = Box_::from_raw(data as *mut _);
        }
        let destroy_call4 = Some(notify_func::<P, Q> as _);
        let super_callback0: Box_<(P, Q)> = Box_::new((send_rtp_data, send_rtcp_data));
        unsafe {
            ffi::gst_rtsp_stream_transport_set_callbacks(
                self.as_ref().to_glib_none().0,
                send_rtp,
                send_rtcp,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call4,
            );
        }
    }

    #[doc(alias = "gst_rtsp_stream_transport_set_keepalive")]
    fn set_keepalive<P: Fn() + 'static>(&self, keep_alive: P) {
        let keep_alive_data: Box_<P> = Box_::new(keep_alive);
        unsafe extern "C" fn keep_alive_func<P: Fn() + 'static>(user_data: glib::ffi::gpointer) {
            let callback = &*(user_data as *mut P);
            (*callback)()
        }
        let keep_alive = Some(keep_alive_func::<P> as _);
        unsafe extern "C" fn notify_func<P: Fn() + 'static>(data: glib::ffi::gpointer) {
            let _callback = Box_::from_raw(data as *mut P);
        }
        let destroy_call3 = Some(notify_func::<P> as _);
        let super_callback0: Box_<P> = keep_alive_data;
        unsafe {
            ffi::gst_rtsp_stream_transport_set_keepalive(
                self.as_ref().to_glib_none().0,
                keep_alive,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    //#[cfg(feature = "v1_16")]
    //#[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    //#[doc(alias = "gst_rtsp_stream_transport_set_list_callbacks")]
    //fn set_list_callbacks(&self, send_rtp_list: /*Unimplemented*/Fn(/*Ignored*/gst::BufferList, u8) -> bool, send_rtcp_list: /*Unimplemented*/Fn(/*Ignored*/gst::BufferList, u8) -> bool, user_data: /*Unimplemented*/Option<Basic: Pointer>) {
    //    unsafe { TODO: call ffi:gst_rtsp_stream_transport_set_list_callbacks() }
    //}

    #[doc(alias = "gst_rtsp_stream_transport_set_message_sent")]
    fn set_message_sent<P: Fn() + 'static>(&self, message_sent: P) {
        let message_sent_data: Box_<P> = Box_::new(message_sent);
        unsafe extern "C" fn message_sent_func<P: Fn() + 'static>(user_data: glib::ffi::gpointer) {
            let callback = &*(user_data as *mut P);
            (*callback)()
        }
        let message_sent = Some(message_sent_func::<P> as _);
        unsafe extern "C" fn notify_func<P: Fn() + 'static>(data: glib::ffi::gpointer) {
            let _callback = Box_::from_raw(data as *mut P);
        }
        let destroy_call3 = Some(notify_func::<P> as _);
        let super_callback0: Box_<P> = message_sent_data;
        unsafe {
            ffi::gst_rtsp_stream_transport_set_message_sent(
                self.as_ref().to_glib_none().0,
                message_sent,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_rtsp_stream_transport_set_message_sent_full")]
    fn set_message_sent_full<P: Fn(&RTSPStreamTransport) + 'static>(&self, message_sent: P) {
        let message_sent_data: Box_<P> = Box_::new(message_sent);
        unsafe extern "C" fn message_sent_func<P: Fn(&RTSPStreamTransport) + 'static>(
            trans: *mut ffi::GstRTSPStreamTransport,
            user_data: glib::ffi::gpointer,
        ) {
            let trans = from_glib_borrow(trans);
            let callback = &*(user_data as *mut P);
            (*callback)(&trans)
        }
        let message_sent = Some(message_sent_func::<P> as _);
        unsafe extern "C" fn notify_func<P: Fn(&RTSPStreamTransport) + 'static>(
            data: glib::ffi::gpointer,
        ) {
            let _callback = Box_::from_raw(data as *mut P);
        }
        let destroy_call3 = Some(notify_func::<P> as _);
        let super_callback0: Box_<P> = message_sent_data;
        unsafe {
            ffi::gst_rtsp_stream_transport_set_message_sent_full(
                self.as_ref().to_glib_none().0,
                message_sent,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    #[doc(alias = "gst_rtsp_stream_transport_set_timed_out")]
    fn set_timed_out(&self, timedout: bool) {
        unsafe {
            ffi::gst_rtsp_stream_transport_set_timed_out(
                self.as_ref().to_glib_none().0,
                timedout.into_glib(),
            );
        }
    }

    //#[doc(alias = "gst_rtsp_stream_transport_set_transport")]
    //fn set_transport(&self, tr: /*Ignored*/gst_rtsp::RTSPTransport) {
    //    unsafe { TODO: call ffi:gst_rtsp_stream_transport_set_transport() }
    //}

    #[doc(alias = "gst_rtsp_stream_transport_set_url")]
    fn set_url(&self, url: Option<&gst_rtsp::RTSPUrl>) {
        unsafe {
            ffi::gst_rtsp_stream_transport_set_url(
                self.as_ref().to_glib_none().0,
                url.to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v1_28")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_28")))]
    #[doc(alias = "timed-out")]
    fn connect_timed_out_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_timed_out_trampoline<
            P: IsA<RTSPStreamTransport>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GstRTSPStreamTransport,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(RTSPStreamTransport::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::timed-out".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_timed_out_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<RTSPStreamTransport>> RTSPStreamTransportExt for O {}
