// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{Object, TaskPool, TaskState, ffi};
use glib::{prelude::*, translate::*};

glib::wrapper! {
    #[doc(alias = "GstTask")]
    pub struct Task(Object<ffi::GstTask, ffi::GstTaskClass>) @extends Object;

    match fn {
        type_ => || ffi::gst_task_get_type(),
    }
}

impl Task {
    pub const NONE: Option<&'static Task> = None;

    #[doc(alias = "gst_task_cleanup_all")]
    pub fn cleanup_all() {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gst_task_cleanup_all();
        }
    }
}

unsafe impl Send for Task {}
unsafe impl Sync for Task {}

pub trait TaskExt: IsA<Task> + 'static {
    #[doc(alias = "gst_task_get_pool")]
    #[doc(alias = "get_pool")]
    fn pool(&self) -> TaskPool {
        unsafe { from_glib_full(ffi::gst_task_get_pool(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gst_task_get_state")]
    #[doc(alias = "get_state")]
    fn state(&self) -> TaskState {
        unsafe { from_glib(ffi::gst_task_get_state(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gst_task_join")]
    fn join(&self) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_task_join(self.as_ref().to_glib_none().0),
                "Failed to join task"
            )
        }
    }

    #[doc(alias = "gst_task_pause")]
    fn pause(&self) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_task_pause(self.as_ref().to_glib_none().0),
                "Failed to pause task"
            )
        }
    }

    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    #[doc(alias = "gst_task_resume")]
    fn resume(&self) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_task_resume(self.as_ref().to_glib_none().0),
                "Failed to resume task"
            )
        }
    }

    #[doc(alias = "gst_task_set_pool")]
    fn set_pool(&self, pool: &impl IsA<TaskPool>) {
        unsafe {
            ffi::gst_task_set_pool(
                self.as_ref().to_glib_none().0,
                pool.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gst_task_set_state")]
    fn set_state(&self, state: TaskState) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_task_set_state(self.as_ref().to_glib_none().0, state.into_glib()),
                "Failed to set task state"
            )
        }
    }

    #[doc(alias = "gst_task_start")]
    fn start(&self) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_task_start(self.as_ref().to_glib_none().0),
                "Failed to start task"
            )
        }
    }

    #[doc(alias = "gst_task_stop")]
    fn stop(&self) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_task_stop(self.as_ref().to_glib_none().0),
                "Failed to stop task"
            )
        }
    }
}

impl<O: IsA<Task>> TaskExt for O {}
