// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{ClockTime, Object, ffi};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GstClock")]
    pub struct Clock(Object<ffi::GstClock, ffi::GstClockClass>) @extends Object;

    match fn {
        type_ => || ffi::gst_clock_get_type(),
    }
}

impl Clock {
    pub const NONE: Option<&'static Clock> = None;

    //#[doc(alias = "gst_clock_id_compare_func")]
    //pub fn id_compare_func(id1: /*Unimplemented*/Option<Basic: Pointer>, id2: /*Unimplemented*/Option<Basic: Pointer>) -> i32 {
    //    unsafe { TODO: call ffi:gst_clock_id_compare_func() }
    //}

    //#[cfg(feature = "v1_16")]
    //#[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    //#[doc(alias = "gst_clock_id_get_clock")]
    //pub fn id_get_clock(id: /*Unimplemented*/ClockID) -> Option<Clock> {
    //    unsafe { TODO: call ffi:gst_clock_id_get_clock() }
    //}

    //#[doc(alias = "gst_clock_id_get_time")]
    //pub fn id_get_time(id: /*Unimplemented*/ClockID) -> Option<ClockTime> {
    //    unsafe { TODO: call ffi:gst_clock_id_get_time() }
    //}

    //#[doc(alias = "gst_clock_id_ref")]
    //pub fn id_ref(id: /*Unimplemented*/ClockID) -> /*Unimplemented*/ClockID {
    //    unsafe { TODO: call ffi:gst_clock_id_ref() }
    //}

    //#[doc(alias = "gst_clock_id_unref")]
    //pub fn id_unref(id: /*Unimplemented*/ClockID) {
    //    unsafe { TODO: call ffi:gst_clock_id_unref() }
    //}

    //#[doc(alias = "gst_clock_id_unschedule")]
    //pub fn id_unschedule(id: /*Unimplemented*/ClockID) {
    //    unsafe { TODO: call ffi:gst_clock_id_unschedule() }
    //}

    //#[cfg(feature = "v1_16")]
    //#[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    //#[doc(alias = "gst_clock_id_uses_clock")]
    //pub fn id_uses_clock(id: /*Unimplemented*/ClockID, clock: &impl IsA<Clock>) -> bool {
    //    unsafe { TODO: call ffi:gst_clock_id_uses_clock() }
    //}

    //#[doc(alias = "gst_clock_id_wait")]
    //pub fn id_wait(id: /*Unimplemented*/ClockID) -> (Result<ClockSuccess, ClockError>, ClockTimeDiff) {
    //    unsafe { TODO: call ffi:gst_clock_id_wait() }
    //}

    //#[doc(alias = "gst_clock_id_wait_async")]
    //pub fn id_wait_async(id: /*Unimplemented*/ClockID, func: /*Unimplemented*/Fn(&Clock, impl Into<Option<ClockTime>>, /*Unimplemented*/ClockID) -> bool, user_data: /*Unimplemented*/Option<Basic: Pointer>) -> Result<ClockSuccess, ClockError> {
    //    unsafe { TODO: call ffi:gst_clock_id_wait_async() }
    //}
}

unsafe impl Send for Clock {}
unsafe impl Sync for Clock {}

pub trait ClockExt: IsA<Clock> + 'static {
    #[doc(alias = "gst_clock_add_observation")]
    fn add_observation(
        &self,
        observation_internal: ClockTime,
        observation_external: ClockTime,
    ) -> Option<f64> {
        unsafe {
            let mut r_squared = std::mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gst_clock_add_observation(
                self.as_ref().to_glib_none().0,
                observation_internal.into_glib(),
                observation_external.into_glib(),
                r_squared.as_mut_ptr(),
            ));
            if ret {
                Some(r_squared.assume_init())
            } else {
                None
            }
        }
    }

    #[doc(alias = "gst_clock_add_observation_unapplied")]
    fn add_observation_unapplied(
        &self,
        observation_internal: ClockTime,
        observation_external: ClockTime,
    ) -> Option<(f64, ClockTime, ClockTime, ClockTime, ClockTime)> {
        unsafe {
            let mut r_squared = std::mem::MaybeUninit::uninit();
            let mut internal = std::mem::MaybeUninit::uninit();
            let mut external = std::mem::MaybeUninit::uninit();
            let mut rate_num = std::mem::MaybeUninit::uninit();
            let mut rate_denom = std::mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gst_clock_add_observation_unapplied(
                self.as_ref().to_glib_none().0,
                observation_internal.into_glib(),
                observation_external.into_glib(),
                r_squared.as_mut_ptr(),
                internal.as_mut_ptr(),
                external.as_mut_ptr(),
                rate_num.as_mut_ptr(),
                rate_denom.as_mut_ptr(),
            ));
            if ret {
                Some((
                    r_squared.assume_init(),
                    try_from_glib(internal.assume_init()).expect("mandatory glib value is None"),
                    try_from_glib(external.assume_init()).expect("mandatory glib value is None"),
                    try_from_glib(rate_num.assume_init()).expect("mandatory glib value is None"),
                    try_from_glib(rate_denom.assume_init()).expect("mandatory glib value is None"),
                ))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gst_clock_adjust_unlocked")]
    fn adjust_unlocked(&self, internal: ClockTime) -> ClockTime {
        unsafe {
            try_from_glib(ffi::gst_clock_adjust_unlocked(
                self.as_ref().to_glib_none().0,
                internal.into_glib(),
            ))
            .expect("mandatory glib value is None")
        }
    }

    #[doc(alias = "gst_clock_get_internal_time")]
    #[doc(alias = "get_internal_time")]
    fn internal_time(&self) -> ClockTime {
        unsafe {
            try_from_glib(ffi::gst_clock_get_internal_time(
                self.as_ref().to_glib_none().0,
            ))
            .expect("mandatory glib value is None")
        }
    }

    #[doc(alias = "gst_clock_get_master")]
    #[doc(alias = "get_master")]
    #[must_use]
    fn master(&self) -> Option<Clock> {
        unsafe { from_glib_full(ffi::gst_clock_get_master(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gst_clock_get_resolution")]
    #[doc(alias = "get_resolution")]
    fn resolution(&self) -> ClockTime {
        unsafe {
            try_from_glib(ffi::gst_clock_get_resolution(
                self.as_ref().to_glib_none().0,
            ))
            .expect("mandatory glib value is None")
        }
    }

    #[doc(alias = "gst_clock_get_time")]
    #[doc(alias = "get_time")]
    fn time(&self) -> ClockTime {
        unsafe {
            try_from_glib(ffi::gst_clock_get_time(self.as_ref().to_glib_none().0))
                .expect("mandatory glib value is None")
        }
    }

    #[doc(alias = "gst_clock_get_timeout")]
    #[doc(alias = "get_timeout")]
    fn timeout(&self) -> Option<ClockTime> {
        unsafe { from_glib(ffi::gst_clock_get_timeout(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gst_clock_is_synced")]
    fn is_synced(&self) -> bool {
        unsafe { from_glib(ffi::gst_clock_is_synced(self.as_ref().to_glib_none().0)) }
    }

    #[cfg(feature = "v1_28")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_28")))]
    #[doc(alias = "gst_clock_is_system_monotonic")]
    fn is_system_monotonic(&self) -> bool {
        unsafe {
            from_glib(ffi::gst_clock_is_system_monotonic(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_clock_set_master")]
    fn set_master(&self, master: Option<&impl IsA<Clock>>) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_clock_set_master(
                    self.as_ref().to_glib_none().0,
                    master.map(|p| p.as_ref()).to_glib_none().0
                ),
                "Failed to set master clock"
            )
        }
    }

    #[doc(alias = "gst_clock_set_resolution")]
    fn set_resolution(&self, resolution: ClockTime) -> ClockTime {
        unsafe {
            try_from_glib(ffi::gst_clock_set_resolution(
                self.as_ref().to_glib_none().0,
                resolution.into_glib(),
            ))
            .expect("mandatory glib value is None")
        }
    }

    #[doc(alias = "gst_clock_set_synced")]
    fn set_synced(&self, synced: bool) {
        unsafe {
            ffi::gst_clock_set_synced(self.as_ref().to_glib_none().0, synced.into_glib());
        }
    }

    #[doc(alias = "gst_clock_set_timeout")]
    #[doc(alias = "timeout")]
    fn set_timeout(&self, timeout: impl Into<Option<ClockTime>>) {
        unsafe {
            ffi::gst_clock_set_timeout(self.as_ref().to_glib_none().0, timeout.into().into_glib());
        }
    }

    #[doc(alias = "gst_clock_unadjust_unlocked")]
    fn unadjust_unlocked(&self, external: ClockTime) -> ClockTime {
        unsafe {
            try_from_glib(ffi::gst_clock_unadjust_unlocked(
                self.as_ref().to_glib_none().0,
                external.into_glib(),
            ))
            .expect("mandatory glib value is None")
        }
    }

    #[doc(alias = "gst_clock_wait_for_sync")]
    fn wait_for_sync(
        &self,
        timeout: impl Into<Option<ClockTime>>,
    ) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_clock_wait_for_sync(
                    self.as_ref().to_glib_none().0,
                    timeout.into().into_glib()
                ),
                "Timed out waiting for sync"
            )
        }
    }

    #[doc(alias = "window-size")]
    fn window_size(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "window-size")
    }

    #[doc(alias = "window-size")]
    fn set_window_size(&self, window_size: i32) {
        ObjectExt::set_property(self.as_ref(), "window-size", window_size)
    }

    #[doc(alias = "window-threshold")]
    fn window_threshold(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "window-threshold")
    }

    #[doc(alias = "window-threshold")]
    fn set_window_threshold(&self, window_threshold: i32) {
        ObjectExt::set_property(self.as_ref(), "window-threshold", window_threshold)
    }

    #[doc(alias = "synced")]
    fn connect_synced<F: Fn(&Self, bool) + Send + Sync + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn synced_trampoline<
            P: IsA<Clock>,
            F: Fn(&P, bool) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstClock,
            synced: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    Clock::from_glib_borrow(this).unsafe_cast_ref(),
                    from_glib(synced),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"synced".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    synced_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "timeout")]
    fn connect_timeout_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_timeout_trampoline<
            P: IsA<Clock>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstClock,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Clock::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::timeout".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_timeout_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "window-size")]
    fn connect_window_size_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_window_size_trampoline<
            P: IsA<Clock>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstClock,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Clock::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::window-size".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_window_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "window-threshold")]
    fn connect_window_threshold_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_window_threshold_trampoline<
            P: IsA<Clock>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstClock,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Clock::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::window-threshold".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_window_threshold_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Clock>> ClockExt for O {}
