// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

#![cfg(unix)]

use gstreamer_vulkan_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::{Command, Stdio};
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["gstreamer-vulkan-1.0"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {cmd:?} failed, {status}").into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{name} {err}").into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing ';' separator");
        c_constants.push((name.to_owned(), value.to_owned()));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {rust_name}\nRust: {rust_value:?}\nC:    {c_value:?}",
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing first ';' separator");
        let (size, alignment) = value.split_once(';').expect("Missing second ';' separator");
        let size = size.parse().expect("Failed to parse size");
        let alignment = alignment.parse().expect("Failed to parse alignment");
        c_layouts.push((name.to_owned(), Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!("Layout mismatch for {rust_name}\nRust: {rust_layout:?}\nC:    {c_layout:?}",);
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut cmd = Command::new(exe);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }

    Ok(String::from_utf8(out.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "GstVulkanBarrierFlags",
        Layout {
            size: size_of::<GstVulkanBarrierFlags>(),
            alignment: align_of::<GstVulkanBarrierFlags>(),
        },
    ),
    (
        "GstVulkanBarrierType",
        Layout {
            size: size_of::<GstVulkanBarrierType>(),
            alignment: align_of::<GstVulkanBarrierType>(),
        },
    ),
    (
        "GstVulkanBufferMemoryAllocator",
        Layout {
            size: size_of::<GstVulkanBufferMemoryAllocator>(),
            alignment: align_of::<GstVulkanBufferMemoryAllocator>(),
        },
    ),
    (
        "GstVulkanBufferMemoryAllocatorClass",
        Layout {
            size: size_of::<GstVulkanBufferMemoryAllocatorClass>(),
            alignment: align_of::<GstVulkanBufferMemoryAllocatorClass>(),
        },
    ),
    (
        "GstVulkanBufferPool",
        Layout {
            size: size_of::<GstVulkanBufferPool>(),
            alignment: align_of::<GstVulkanBufferPool>(),
        },
    ),
    (
        "GstVulkanBufferPoolClass",
        Layout {
            size: size_of::<GstVulkanBufferPoolClass>(),
            alignment: align_of::<GstVulkanBufferPoolClass>(),
        },
    ),
    (
        "GstVulkanCommandPoolClass",
        Layout {
            size: size_of::<GstVulkanCommandPoolClass>(),
            alignment: align_of::<GstVulkanCommandPoolClass>(),
        },
    ),
    (
        "GstVulkanDescriptorCache",
        Layout {
            size: size_of::<GstVulkanDescriptorCache>(),
            alignment: align_of::<GstVulkanDescriptorCache>(),
        },
    ),
    (
        "GstVulkanDescriptorCacheClass",
        Layout {
            size: size_of::<GstVulkanDescriptorCacheClass>(),
            alignment: align_of::<GstVulkanDescriptorCacheClass>(),
        },
    ),
    (
        "GstVulkanDescriptorPoolClass",
        Layout {
            size: size_of::<GstVulkanDescriptorPoolClass>(),
            alignment: align_of::<GstVulkanDescriptorPoolClass>(),
        },
    ),
    (
        "GstVulkanDeviceClass",
        Layout {
            size: size_of::<GstVulkanDeviceClass>(),
            alignment: align_of::<GstVulkanDeviceClass>(),
        },
    ),
    (
        "GstVulkanDisplay",
        Layout {
            size: size_of::<GstVulkanDisplay>(),
            alignment: align_of::<GstVulkanDisplay>(),
        },
    ),
    (
        "GstVulkanDisplayClass",
        Layout {
            size: size_of::<GstVulkanDisplayClass>(),
            alignment: align_of::<GstVulkanDisplayClass>(),
        },
    ),
    (
        "GstVulkanDisplayType",
        Layout {
            size: size_of::<GstVulkanDisplayType>(),
            alignment: align_of::<GstVulkanDisplayType>(),
        },
    ),
    (
        "GstVulkanEncodeQueryResult",
        Layout {
            size: size_of::<GstVulkanEncodeQueryResult>(),
            alignment: align_of::<GstVulkanEncodeQueryResult>(),
        },
    ),
    (
        "GstVulkanError",
        Layout {
            size: size_of::<GstVulkanError>(),
            alignment: align_of::<GstVulkanError>(),
        },
    ),
    (
        "GstVulkanFenceCache",
        Layout {
            size: size_of::<GstVulkanFenceCache>(),
            alignment: align_of::<GstVulkanFenceCache>(),
        },
    ),
    (
        "GstVulkanFenceCacheClass",
        Layout {
            size: size_of::<GstVulkanFenceCacheClass>(),
            alignment: align_of::<GstVulkanFenceCacheClass>(),
        },
    ),
    (
        "GstVulkanFormatFlags",
        Layout {
            size: size_of::<GstVulkanFormatFlags>(),
            alignment: align_of::<GstVulkanFormatFlags>(),
        },
    ),
    (
        "GstVulkanFormatScaling",
        Layout {
            size: size_of::<GstVulkanFormatScaling>(),
            alignment: align_of::<GstVulkanFormatScaling>(),
        },
    ),
    (
        "GstVulkanFullScreenQuad",
        Layout {
            size: size_of::<GstVulkanFullScreenQuad>(),
            alignment: align_of::<GstVulkanFullScreenQuad>(),
        },
    ),
    (
        "GstVulkanFullScreenQuadClass",
        Layout {
            size: size_of::<GstVulkanFullScreenQuadClass>(),
            alignment: align_of::<GstVulkanFullScreenQuadClass>(),
        },
    ),
    (
        "GstVulkanHandle",
        Layout {
            size: size_of::<GstVulkanHandle>(),
            alignment: align_of::<GstVulkanHandle>(),
        },
    ),
    (
        "GstVulkanHandlePool",
        Layout {
            size: size_of::<GstVulkanHandlePool>(),
            alignment: align_of::<GstVulkanHandlePool>(),
        },
    ),
    (
        "GstVulkanHandlePoolClass",
        Layout {
            size: size_of::<GstVulkanHandlePoolClass>(),
            alignment: align_of::<GstVulkanHandlePoolClass>(),
        },
    ),
    (
        "GstVulkanHandleType",
        Layout {
            size: size_of::<GstVulkanHandleType>(),
            alignment: align_of::<GstVulkanHandleType>(),
        },
    ),
    (
        "GstVulkanHandleTypedef",
        Layout {
            size: size_of::<GstVulkanHandleTypedef>(),
            alignment: align_of::<GstVulkanHandleTypedef>(),
        },
    ),
    (
        "GstVulkanImageBufferPool",
        Layout {
            size: size_of::<GstVulkanImageBufferPool>(),
            alignment: align_of::<GstVulkanImageBufferPool>(),
        },
    ),
    (
        "GstVulkanImageBufferPoolClass",
        Layout {
            size: size_of::<GstVulkanImageBufferPoolClass>(),
            alignment: align_of::<GstVulkanImageBufferPoolClass>(),
        },
    ),
    (
        "GstVulkanImageMemoryAllocator",
        Layout {
            size: size_of::<GstVulkanImageMemoryAllocator>(),
            alignment: align_of::<GstVulkanImageMemoryAllocator>(),
        },
    ),
    (
        "GstVulkanImageMemoryAllocatorClass",
        Layout {
            size: size_of::<GstVulkanImageMemoryAllocatorClass>(),
            alignment: align_of::<GstVulkanImageMemoryAllocatorClass>(),
        },
    ),
    (
        "GstVulkanInstanceClass",
        Layout {
            size: size_of::<GstVulkanInstanceClass>(),
            alignment: align_of::<GstVulkanInstanceClass>(),
        },
    ),
    (
        "GstVulkanMemoryAllocator",
        Layout {
            size: size_of::<GstVulkanMemoryAllocator>(),
            alignment: align_of::<GstVulkanMemoryAllocator>(),
        },
    ),
    (
        "GstVulkanMemoryAllocatorClass",
        Layout {
            size: size_of::<GstVulkanMemoryAllocatorClass>(),
            alignment: align_of::<GstVulkanMemoryAllocatorClass>(),
        },
    ),
    (
        "GstVulkanOperation",
        Layout {
            size: size_of::<GstVulkanOperation>(),
            alignment: align_of::<GstVulkanOperation>(),
        },
    ),
    (
        "GstVulkanOperationClass",
        Layout {
            size: size_of::<GstVulkanOperationClass>(),
            alignment: align_of::<GstVulkanOperationClass>(),
        },
    ),
    (
        "GstVulkanPhysicalDeviceClass",
        Layout {
            size: size_of::<GstVulkanPhysicalDeviceClass>(),
            alignment: align_of::<GstVulkanPhysicalDeviceClass>(),
        },
    ),
    (
        "GstVulkanQueueClass",
        Layout {
            size: size_of::<GstVulkanQueueClass>(),
            alignment: align_of::<GstVulkanQueueClass>(),
        },
    ),
    (
        "GstVulkanQueueFamilyOps",
        Layout {
            size: size_of::<GstVulkanQueueFamilyOps>(),
            alignment: align_of::<GstVulkanQueueFamilyOps>(),
        },
    ),
    (
        "GstVulkanSwapper",
        Layout {
            size: size_of::<GstVulkanSwapper>(),
            alignment: align_of::<GstVulkanSwapper>(),
        },
    ),
    (
        "GstVulkanSwapperClass",
        Layout {
            size: size_of::<GstVulkanSwapperClass>(),
            alignment: align_of::<GstVulkanSwapperClass>(),
        },
    ),
    (
        "GstVulkanTrash",
        Layout {
            size: size_of::<GstVulkanTrash>(),
            alignment: align_of::<GstVulkanTrash>(),
        },
    ),
    (
        "GstVulkanTrashFenceListClass",
        Layout {
            size: size_of::<GstVulkanTrashFenceListClass>(),
            alignment: align_of::<GstVulkanTrashFenceListClass>(),
        },
    ),
    (
        "GstVulkanTrashList",
        Layout {
            size: size_of::<GstVulkanTrashList>(),
            alignment: align_of::<GstVulkanTrashList>(),
        },
    ),
    (
        "GstVulkanTrashListClass",
        Layout {
            size: size_of::<GstVulkanTrashListClass>(),
            alignment: align_of::<GstVulkanTrashListClass>(),
        },
    ),
    (
        "GstVulkanVideoFilter",
        Layout {
            size: size_of::<GstVulkanVideoFilter>(),
            alignment: align_of::<GstVulkanVideoFilter>(),
        },
    ),
    (
        "GstVulkanVideoFilterClass",
        Layout {
            size: size_of::<GstVulkanVideoFilterClass>(),
            alignment: align_of::<GstVulkanVideoFilterClass>(),
        },
    ),
    (
        "GstVulkanWindow",
        Layout {
            size: size_of::<GstVulkanWindow>(),
            alignment: align_of::<GstVulkanWindow>(),
        },
    ),
    (
        "GstVulkanWindowClass",
        Layout {
            size: size_of::<GstVulkanWindowClass>(),
            alignment: align_of::<GstVulkanWindowClass>(),
        },
    ),
    (
        "GstVulkanWindowError",
        Layout {
            size: size_of::<GstVulkanWindowError>(),
            alignment: align_of::<GstVulkanWindowError>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    (
        "GST_CAPS_FEATURE_MEMORY_VULKAN_BUFFER",
        "memory:VulkanBuffer",
    ),
    ("GST_CAPS_FEATURE_MEMORY_VULKAN_IMAGE", "memory:VulkanImage"),
    ("(gint) GST_VULKAN_BARRIER_FLAG_NONE", "0"),
    ("(gint) GST_VULKAN_BARRIER_NONE", "0"),
    ("(gint) GST_VULKAN_BARRIER_TYPE_BUFFER", "2"),
    ("(gint) GST_VULKAN_BARRIER_TYPE_IMAGE", "3"),
    ("(gint) GST_VULKAN_BARRIER_TYPE_MEMORY", "1"),
    ("GST_VULKAN_BUFFER_MEMORY_ALLOCATOR_NAME", "VulkanBuffer"),
    ("GST_VULKAN_DEVICE_CONTEXT_TYPE_STR", "gst.vulkan.device"),
    ("GST_VULKAN_DISPLAY_CONTEXT_TYPE_STR", "gst.vulkan.display"),
    ("(guint) GST_VULKAN_DISPLAY_TYPE_ANDROID", "32"),
    ("(guint) GST_VULKAN_DISPLAY_TYPE_ANY", "4294967295"),
    ("(guint) GST_VULKAN_DISPLAY_TYPE_COCOA", "4"),
    ("(guint) GST_VULKAN_DISPLAY_TYPE_IOS", "8"),
    ("(guint) GST_VULKAN_DISPLAY_TYPE_NONE", "0"),
    ("(guint) GST_VULKAN_DISPLAY_TYPE_WAYLAND", "2"),
    ("(guint) GST_VULKAN_DISPLAY_TYPE_WIN32", "16"),
    ("(guint) GST_VULKAN_DISPLAY_TYPE_XCB", "1"),
    ("(gint) GST_VULKAN_FAILED", "0"),
    ("(guint) GST_VULKAN_FORMAT_FLAG_ALPHA", "4"),
    ("(guint) GST_VULKAN_FORMAT_FLAG_COMPLEX", "16"),
    ("(guint) GST_VULKAN_FORMAT_FLAG_LE", "8"),
    ("(guint) GST_VULKAN_FORMAT_FLAG_RGB", "2"),
    ("(guint) GST_VULKAN_FORMAT_FLAG_YUV", "1"),
    ("(gint) GST_VULKAN_FORMAT_SCALING_SINT", "6"),
    ("(gint) GST_VULKAN_FORMAT_SCALING_SNORM", "2"),
    ("(gint) GST_VULKAN_FORMAT_SCALING_SRGB", "7"),
    ("(gint) GST_VULKAN_FORMAT_SCALING_SSCALED", "4"),
    ("(gint) GST_VULKAN_FORMAT_SCALING_UINT", "5"),
    ("(gint) GST_VULKAN_FORMAT_SCALING_UNORM", "1"),
    ("(gint) GST_VULKAN_FORMAT_SCALING_USCALED", "3"),
    ("(gint) GST_VULKAN_HANDLE_TYPE_DESCRIPTOR_SET_LAYOUT", "1"),
    ("(gint) GST_VULKAN_HANDLE_TYPE_FRAMEBUFFER", "6"),
    ("(gint) GST_VULKAN_HANDLE_TYPE_PIPELINE", "3"),
    ("(gint) GST_VULKAN_HANDLE_TYPE_PIPELINE_LAYOUT", "2"),
    ("(gint) GST_VULKAN_HANDLE_TYPE_RENDER_PASS", "4"),
    ("(gint) GST_VULKAN_HANDLE_TYPE_SAMPLER", "5"),
    (
        "(gint) GST_VULKAN_HANDLE_TYPE_SAMPLER_YCBCR_CONVERSION",
        "10",
    ),
    ("(gint) GST_VULKAN_HANDLE_TYPE_SHADER", "7"),
    ("(gint) GST_VULKAN_HANDLE_TYPE_VIDEO_SESSION", "8"),
    (
        "(gint) GST_VULKAN_HANDLE_TYPE_VIDEO_SESSION_PARAMETERS",
        "9",
    ),
    ("GST_VULKAN_IMAGE_MEMORY_ALLOCATOR_NAME", "VulkanImage"),
    (
        "GST_VULKAN_INSTANCE_CONTEXT_TYPE_STR",
        "gst.vulkan.instance",
    ),
    ("GST_VULKAN_MAX_COMPONENTS", "4"),
    ("GST_VULKAN_MEMORY_ALLOCATOR_NAME", "Vulkan"),
    ("GST_VULKAN_QUEUE_CONTEXT_TYPE_STR", "gst.vulkan.queue"),
    (
        "GST_VULKAN_SWAPPER_VIDEO_FORMATS",
        " { RGBA, BGRA, RGB, BGR } ",
    ),
    ("(gint) GST_VULKAN_WINDOW_ERROR_FAILED", "0"),
    ("(gint) GST_VULKAN_WINDOW_ERROR_OLD_LIBS", "1"),
    ("(gint) GST_VULKAN_WINDOW_ERROR_RESOURCE_UNAVAILABLE", "2"),
];
